/*
 * NewTypesPanel.java
 *
 * Created on September 20, 2002, 10:16 AM
 */

package org.netbeans.modules.openoffice.wizard.panels.service;

import org.openide.util.NbBundle;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import javax.swing.JFileChooser;
import java.util.Vector;
import javax.swing.ListModel;
import javax.swing.DefaultListModel;
import java.io.File;

/**
 *
 * @author  bn126049
 */
public class NewTypesPanel extends javax.swing.JPanel implements WizardDescriptor.Panel {
    private boolean initialized;
    private Vector vectorIDLFiles = new Vector();
    private Vector vectorIDLFileNames = new Vector();
    
    /** Creates new form NewTypesPanel */
    public NewTypesPanel() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jcheckboxNewTypes = new javax.swing.JCheckBox();
        jbuttonAdd = new javax.swing.JButton();
        jbuttonRemove = new javax.swing.JButton();
        jlistIDLFiles = new javax.swing.JList();

        setLayout(new java.awt.GridBagLayout());

        jcheckboxNewTypes.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/service/Bundle").getString("LBL_NewTypes"));
        jcheckboxNewTypes.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/service/Bundle").getString("LBL_NewTypesToolTip"));
        initialized = true;

        jcheckboxNewTypes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jcheckboxNewTypesActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jcheckboxNewTypes, gridBagConstraints);

        jbuttonAdd.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/service/Bundle").getString("LBL_NewTypesAdd"));
        jbuttonAdd.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/service/Bundle").getString("LBL_NewTypesAddToolTip"));
        jbuttonAdd.setEnabled(false);
        jbuttonAdd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbuttonAddActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(jbuttonAdd, gridBagConstraints);

        jbuttonRemove.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/service/Bundle").getString("LBL_NewTypesRemove"));
        jbuttonRemove.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/service/Bundle").getString("LBL_NewTypesRemoveToolTip"));
        jbuttonRemove.setEnabled(false);
        jbuttonRemove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbuttonRemoveActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jbuttonRemove, gridBagConstraints);

        jlistIDLFiles.setPreferredSize(new java.awt.Dimension(200, 200));
        jlistIDLFiles.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        add(jlistIDLFiles, gridBagConstraints);

    }//GEN-END:initComponents

    private void jbuttonRemoveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbuttonRemoveActionPerformed
        int intSelectedIndex = jlistIDLFiles.getSelectedIndex();
        
        if ( intSelectedIndex != -1 ) {
            vectorIDLFiles.remove( intSelectedIndex );
            
            vectorIDLFileNames.remove( intSelectedIndex );
            
            jlistIDLFiles.setListData( vectorIDLFileNames );
        }
    }//GEN-LAST:event_jbuttonRemoveActionPerformed

    private void jbuttonAddActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbuttonAddActionPerformed
        // Create a file chooser.
        JFileChooser jfilechooser = new JFileChooser();
        
        // Create a filter for IDL files.
        IDLFilter idlfilter = new IDLFilter();
        
        // Set the filter to the file chooser.
        jfilechooser.setFileFilter( idlfilter );
        
        // Get the return value of the file chooser.
        int intReturnValue = jfilechooser.showOpenDialog( this );
        
        // If approve is chosen.
        if ( intReturnValue == JFileChooser.APPROVE_OPTION ) {
            
            // If the selected file is not in the list.
            if ( !vectorIDLFiles.contains( jfilechooser.getSelectedFile() ) ) {
                
                // Add the file to the vector of IDL files.
                vectorIDLFiles.addElement( jfilechooser.getSelectedFile() );
                
                // 
                vectorIDLFileNames.addElement(
                jfilechooser.getSelectedFile().getName() );
                
                // Add vector of IDL files to the list.
                jlistIDLFiles.setListData( vectorIDLFileNames );
            }
        }
    }//GEN-LAST:event_jbuttonAddActionPerformed

    private void jcheckboxNewTypesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jcheckboxNewTypesActionPerformed
        if ( jcheckboxNewTypes.isSelected() ) {
            if ( jbuttonAdd.isEnabled() ) {
                jbuttonAdd.setEnabled( false );
                jbuttonRemove.setEnabled( false );
                jlistIDLFiles.setEnabled( false );
            }
            else {
                jbuttonAdd.setEnabled( true );
                jbuttonRemove.setEnabled( true );
                jlistIDLFiles.setEnabled( true );
            }
        }
    }//GEN-LAST:event_jcheckboxNewTypesActionPerformed

    public void addChangeListener(javax.swing.event.ChangeListener changeListener) {
    }    
    
    public java.awt.Component getComponent() {
        if ( !initialized ) {
            initialize();
        }
        
        return this;
    }    
    
    public org.openide.util.HelpCtx getHelp() {
        return new HelpCtx( "org.netbeans.modules.openoffice.help.HOMEID" );
    }
    
    public void readSettings(Object obj) {
    }
    
    public void removeChangeListener(javax.swing.event.ChangeListener changeListener) {
    }
    
    public void storeSettings(Object obj) {
    }
    
    private void initialize() {
        initComponents();
        setName( NbBundle.getMessage( NewTypesPanel.class,
        "TITLE_WizardNewTypesPanel" ) );
    }

    public boolean isValid() {
        return true;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList jlistIDLFiles;
    private javax.swing.JButton jbuttonAdd;
    private javax.swing.JCheckBox jcheckboxNewTypes;
    private javax.swing.JButton jbuttonRemove;
    // End of variables declaration//GEN-END:variables
    
}
