/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: delayload.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2007/10/15 12:51:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2007 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "precompiled_sal.hxx"
#include "sal/config.h"

#include <cstddef>

#define WIN32_LEAN_AND_MEAN
#pragma warning(push, 1)
#include <windows.h>
#include <delayimp.h>
#include <psapi.h>
#pragma warning(pop)

#include "osl/doublecheckedlocking.h"
#include "rtl/string.h"

#include "delayload.hxx"

namespace {

// Private copies of <cstring> functions are needed because this code must not
// link against the C/C++ runtime:

char * my_strrchr(char * s, int c) {
    char * p = NULL;
    for (; *s != '\0'; ++s) {
        if (*s == c) {
            p = s;
        }
    }
    return p;
}

std::size_t my_strlen(char const * s) {
    char const * p = s;
    for (; *p != '\0'; ++p);
    return p - s;
}

bool buildPath(
    char * path, char const * frontBegin, char const * frontEnd,
    char const * backBegin, std::size_t backLength)
{
    if (backLength <
        static_cast< std::size_t >(MAX_PATH - (frontEnd - frontBegin)))
        // hopefully std::size_t is large enough
    {
        char * p = path;
        while (frontBegin != frontEnd) {
            *p++ = *frontBegin++;
        }
        for (; backLength > 0; --backLength) {
            *p++ = *backBegin++;
        }
        *p++ = '\0';
        return true;
    } else {
        return false;
    }
}

}

namespace delayload {

char * getModulePath(char * path, HMODULE module) {
    if (!GetModuleFileNameA(module, path, MAX_PATH)) {
        return NULL;
    }
    char * p = my_strrchr(path, '\\');
    return p == NULL ? path : p + 1;
}

char * getUreBinPath(
    char * path, char const * programPath, char const * programPathEnd)
{
#define MY_LINK "ure-link"
    char p[MAX_PATH];
    if (!buildPath(
            p, programPath, programPathEnd,
            RTL_CONSTASCII_STRINGPARAM("..\\" MY_LINK)))
    {
        return NULL;
    }
    HANDLE h = CreateFileA(
        p, FILE_READ_DATA, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
    if (h == INVALID_HANDLE_VALUE) {
        return NULL;
    }
    char p1[MAX_PATH];
    DWORD n;
    BOOL ok = ReadFile(h, p1, MAX_PATH, &n, NULL);
    CloseHandle(h);
    if (!ok) {
        return NULL;
    }
    while (n > 0 && (p1[n - 1] == '\x0A' || p1[n - 1] == '\x0D')) {
        --n;
    }
    if (n == 0 || n == MAX_PATH) {
        return NULL;
    }
    p1[n] = 0;
    bool colon = false;
    // The ure-link file should only contain one line; this check is not perfect
    // (if the ReadFile did not read more than the first line) but at least
    // ensures that p1 does not contain more than the first line:
    for (char const * q = p1; q != p1 + n; ++q) {
        switch (*q) {
        case '\0':
        case '\x0A':
        case '\x0D':
            return NULL;
        case ':':
            colon = true;
            break;
        default:
            break;
        }
    }
    char p2[MAX_PATH];
    char * p3;
    if (colon || p1[0] == '\\') {
        // Interpret p1 as an absolute path:
        p3 = p1;
    } else {
        // Interpret p1 as a relative path:
        std::size_t n2 = my_strlen(p) - RTL_CONSTASCII_LENGTH(MY_LINK);
        if (!buildPath(p2, p, p + n2, p1, n)) {
            return NULL;
        }
        p3 = p2;
        n += n2; // cannot overflow
    }
    static char const SUFFIX[] = "\\bin\\";
    if (!buildPath(path, p3, p3 + n, RTL_CONSTASCII_STRINGPARAM(SUFFIX))) {
        return NULL;
    }
    return path + n + RTL_CONSTASCII_LENGTH(SUFFIX); // cannot overflow
}

}

extern "C" {

// For a DLL, set in *_pRawDllMain; for an executable, left NULL:
HMODULE __hCurrentModule = NULL;

static FARPROC WINAPI hook(unsigned const dliNotify, PDelayLoadInfo const pdli)
{
    //TODO  This function may fail as it handles file names through Windows
    // (ANSI) code page functionality instead of Unicode functionality
    // (curiously, pdli->szDll is always a char * and it seems to be unspecified
    // whether it represents the file name in the Windows (ANSI) code page, the
    // OEM code page, or Unicode):
    if (dliNotify != dliNotePreLoadLibrary) {
        return NULL;
    }
    HMODULE m = GetModuleHandleA(pdli->szDll);
    if (m != NULL) {
        return reinterpret_cast< FARPROC >(m);
    }
    static char thisPath[MAX_PATH];
    static char const * thisPathEnd = NULL;
    // Even if multiple threads write into thisPath or thisPathEnd
    // simultaneously, they should all write the same data:
    if (thisPathEnd == NULL) {
        // For an executable __hCurrentModule is NULL and getModulePath will
        // thus correctly return the path to the executable:
        char const * p = delayload::getModulePath(thisPath, __hCurrentModule);
        if (p == NULL) {
            return NULL;
        }
        OSL_DOUBLE_CHECKED_LOCKING_MEMORY_BARRIER();
        thisPathEnd = p;
    } else {
        OSL_DOUBLE_CHECKED_LOCKING_MEMORY_BARRIER();
    }
    std::size_t len = my_strlen(pdli->szDll);
    char path[MAX_PATH];
    if (!buildPath(path, thisPath, thisPathEnd, pdli->szDll, len)) {
        return NULL;
    }
    m = LoadLibraryExA(path, NULL, 0);
    if (m != NULL) {
        return reinterpret_cast< FARPROC >(m);
    }
    static char urePath[MAX_PATH];
    static char const * urePathEnd = NULL;
    // Even if multiple threads write into urePath or urePathEnd simultaneously,
    // they should all write the same data:
    if (urePathEnd == NULL) {
        char const * p = delayload::getUreBinPath(
            urePath, thisPath, thisPathEnd);
        if (p == NULL) {
            return NULL;
        }
        OSL_DOUBLE_CHECKED_LOCKING_MEMORY_BARRIER();
        urePathEnd = p;
    } else {
        OSL_DOUBLE_CHECKED_LOCKING_MEMORY_BARRIER();
    }
    if (!buildPath(path, urePath, urePathEnd, pdli->szDll, len)) {
        return NULL;
    }
    return reinterpret_cast< FARPROC >(LoadLibraryExA(path, NULL, 0));
}

PfnDliHook __pfnDliNotifyHook2 = hook;

}
