/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: lspcitem.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kz $ $Date: 2007/05/10 14:28:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SVX_LSPCITEM_HXX
#define _SVX_LSPCITEM_HXX

// include ---------------------------------------------------------------

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SVX_SVXENUM_HXX
#include <svx/svxenum.hxx>
#endif

#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

class SvXMLUnitConverter;
namespace rtl
{
	class OUString;
}

// class SvxLineSpacingItem ----------------------------------------------

/*
[Beschreibung]
Dieses Item beschreibt den Abstand zwischen den Zeilen.
*/

#define LINE_SPACE_DEFAULT_HEIGHT 200
class SVX_DLLPUBLIC SvxLineSpacingItem : public SfxEnumItemInterface
{
	friend SvStream& operator<<( SvStream&, SvxLineSpacingItem& ); //$ ostream

	short nInterLineSpace;
	USHORT nLineHeight;
	BYTE nPropLineSpace;
	SvxLineSpace eLineSpace;
	SvxInterLineSpace eInterLineSpace;

public:
	TYPEINFO();

	// Der Writer verlaesst sich auf eine Default-Hoehe von 200!
	// Eigentlich wuerde ich alle Werte mit 0 initialisieren, aber wer kann
	// die Folgen beim Writer absehen ?
	// => lieber einen krummen Wert als Default, aber der Programmierer
	// sieht, dass dort etwas besonderes passiert.

    SvxLineSpacingItem( USHORT nHeight /*= LINE_SPACE_DEFAULT_HEIGHT*/, const USHORT nId  );

	// "pure virtual Methoden" vom SfxPoolItem
	virtual int 			 operator==( const SfxPoolItem& ) const;
	virtual	sal_Bool        	 QueryValue( com::sun::star::uno::Any& rVal, BYTE nMemberId = 0 ) const;
	virtual	sal_Bool			 PutValue( const com::sun::star::uno::Any& rVal, BYTE nMemberId = 0 );

	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
                                    String &rText, const IntlWrapper * = 0 ) const;

	virtual SfxPoolItem*	 Clone( SfxItemPool *pPool = 0 ) const;
	virtual SfxPoolItem*	 Create(SvStream &, USHORT) const;
	virtual SvStream&		 Store(SvStream &, USHORT nItemVersion ) const;

	// Methoden zum Abfragen und Aendern
	// Interlinespace wird zur Hoehe addiert.
	inline short GetInterLineSpace() const { return nInterLineSpace; }
	inline void SetInterLineSpace( const short nSpace )
	{
		nInterLineSpace = nSpace;
		eInterLineSpace = SVX_INTER_LINE_SPACE_FIX;
	}

	// Bestimmt absolute oder minimale Zeilenhoehe.
	inline USHORT GetLineHeight() const { return nLineHeight; }
	inline void SetLineHeight( const USHORT nHeight )
	{
		nLineHeight = nHeight;
		eLineSpace = SVX_LINE_SPACE_MIN;
	}

	// Vergroessert oder verkleinert die Zeilenhoehe.
	const BYTE GetPropLineSpace() const { return nPropLineSpace; }
	inline void SetPropLineSpace( const BYTE nProp )
	{
		nPropLineSpace = nProp;
		eInterLineSpace = SVX_INTER_LINE_SPACE_PROP;
	}

	inline SvxLineSpace &GetLineSpaceRule() { return eLineSpace; }
	inline SvxLineSpace GetLineSpaceRule() const { return eLineSpace; }

	inline SvxInterLineSpace &GetInterLineSpaceRule() { return eInterLineSpace; }
	inline SvxInterLineSpace GetInterLineSpaceRule() const { return eInterLineSpace; }

	virtual USHORT			GetValueCount() const;
	virtual String			GetValueTextByPos( USHORT nPos ) const;
	virtual USHORT			GetEnumValue() const;
	virtual void			SetEnumValue( USHORT nNewVal );
};

#endif

