/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/



/*
 * hgfs.h -- 
 *
 * Header file for public common data types used in the VMware
 * Host/Guest File System (hgfs).
 *
 * This file is included by hgfsProto.h, which defines message formats
 * used in the hgfs protocol, and by hgfsDev.h, which defines the
 * interface between the kernel and the hgfs pserver. [bac]
 */


#ifndef _HGFS_H_
# define _HGFS_H_

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_DISTRIBUTE
#include "includeCheck.h"


/*
 * Maximum allowed packet size in bytes. All hgfs code should be made
 * safe with respect to this limit.
 */
#define HGFS_PACKET_MAX 6144


/*
 * Open mode
 *
 * These are equivalent to the O_RDONLY, O_WRONLY, O_RDWR open flags
 * in Unix; they specify which type of access is being requested.
 *
 * Changing the order of this enum will break stuff.
 *
 * This definition is used in some places that don't include
 * hgfsProto.h, which is why it is here instead of there.
 */
typedef enum {
   HGFS_OPEN_MODE_READ_ONLY,
   HGFS_OPEN_MODE_WRITE_ONLY,
   HGFS_OPEN_MODE_READ_WRITE,
} HgfsOpenMode;


/*
 * Return status for replies from the server.
 *
 * Changing the order of this enum will break the protocol; new status
 * types should be added at the end.
 *
 * This definition is used in some places that don't include
 * hgfsProto.h, which is why it is here instead of there.
 */
typedef enum {
   HGFS_STATUS_SUCCESS,
   HGFS_STATUS_NO_SUCH_FILE_OR_DIR,
   HGFS_STATUS_INVALID_HANDLE,
   HGFS_STATUS_OPERATION_NOT_PERMITTED,
   HGFS_STATUS_FILE_EXISTS,
   HGFS_STATUS_NOT_DIRECTORY,
   HGFS_STATUS_DIR_NOT_EMPTY,
   HGFS_STATUS_PROTOCOL_ERROR,
   HGFS_STATUS_ACCESS_DENIED,
   HGFS_STATUS_GENERIC_ERROR,
} HgfsStatus;

#endif // _HGFS_H_
