/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* init.c
 * Copyright (C) 2005 Hiroyuki Ikezoe <poincare@ikezoe.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "gsynaptics.h"
#include "gsynaptics-conf.h"

static GConfClient *gconf = NULL;

static void
setup_user_value (GSynaptics *synaptics)
{
	gboolean b_value;
	gint i_value;

	if (!gconf_client_dir_exists (gconf, DIRNAME, NULL))
		return;

	/* touchpad on/off */	
	b_value = gconf_client_get_bool (gconf, OFF_KEY, NULL);
	g_synaptics_set_enabled (synaptics, b_value ? 1 : 0);
	
	/* vertical scroll delta */
	i_value = gconf_client_get_int (gconf, VERTSCROLLDELTA_KEY, NULL);
	g_synaptics_set_vertical_scroll_delta (synaptics, i_value);
	
	/* horizontal scroll delta */
	i_value = gconf_client_get_int (gconf, HORIZSCROLLDELTA_KEY, NULL);
	g_synaptics_set_horizontal_scroll_delta (synaptics, i_value);
	
	/* circular scroll */
	i_value = gconf_client_get_int (gconf, CIRCSCROLLDELTA_KEY, NULL);
	b_value = gconf_client_get_bool (gconf, CIRCULARSCROLLING_KEY, NULL);
	g_synaptics_set_circular_scroll_delta (synaptics, i_value);
	g_synaptics_set_circular_scroll_enabled (synaptics, b_value);
	/* the trigger of curcular scrolling */
	i_value = gconf_client_get_int (gconf, CIRCSCROLLTRIGGER_KEY, NULL);
	g_synaptics_set_circular_scroll_trigger (synaptics, i_value);
	
	
	/* tapping time */
	i_value = gconf_client_get_int (gconf, MAXTAPTIME_KEY, NULL);
	g_synaptics_set_tap_time (synaptics, i_value);
	
	/* fast taps */
	b_value = gconf_client_get_bool (gconf, FASTTAPS_KEY, NULL);
	g_synaptics_set_fast_taps (synaptics, b_value);
	
	/* sensitivity */
	i_value = gconf_client_get_int (gconf, SENSITIVITY_KEY, NULL);
	g_synaptics_set_sensitivity (synaptics, i_value);

	/* coasting */
	b_value = gconf_client_get_bool (gconf, COASTENABLE_KEY, NULL);
	g_synaptics_set_coasting_enabled (synaptics, b_value);
	
	/* edge motion */
	b_value = gconf_client_get_bool (gconf, EDGEMOTIONUSEALWAYS_KEY, NULL);
	g_synaptics_set_edge_motion_enabled (synaptics, b_value);
}

int
main (int argc, char **argv)
{
	GSynaptics *synaptics;

	bindtextdomain (GETTEXT_PACKAGE, GSYNAPTICS_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	gnome_program_init ("gsynaptics-init", VERSION,
			LIBGNOMEUI_MODULE, argc, argv,
			GNOME_PARAM_APP_DATADIR, NULL,
			NULL);

	synaptics = g_synaptics_new ();

	if (!g_synaptics_is_available(synaptics))
	{
		g_object_unref (synaptics);
		g_printerr (_("GSynaptics couldn't initialize.\n"
			      "You have to set 'SHMConfig' 'true' in Xorg.conf or XFree86.conf to use GSynaptics\n"));
		exit(1);
	}

	gconf = gconf_client_get_default ();

	/* set user value */
	setup_user_value (synaptics);

	g_object_unref (synaptics);

	g_object_unref (gconf);

	return 0;
}
