/* -*- Mode: C; tab-width: 5; indent-tabs-mode: t; c-basic-offset: 5 -*- */

#ifndef NMA_GSM_MODEM_H
#define NMA_GSM_MODEM_H

#include <glib/gtypes.h>
#include <glib-object.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

#define NMA_TYPE_GSM_MODEM            (nma_gsm_modem_get_type ())
#define NMA_GSM_MODEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NMA_TYPE_GSM_MODEM, NMAGsmModem))
#define NMA_GSM_MODEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NMA_TYPE_GSM_MODEM, NMAGsmModemClass))
#define NMA_IS_GSM_MODEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NMA_TYPE_GSM_MODEM))
#define NMA_IS_GSM_MODEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), NMA_TYPE_GSM_MODEM))
#define NMA_GSM_MODEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NMA_TYPE_GSM_MODEM, NMAGsmModemClass))

typedef struct {
	GObject parent;
} NMAGsmModem;

typedef struct {
	GObjectClass parent;

	/* Signals */
	void (*signal_quality) (NMAGsmModem *modem, guint32 signal_quality);
	void (*network_mode) (NMAGsmModem *modem, guint32 network_mode);
} NMAGsmModemClass;

GType        nma_gsm_modem_get_type (void);

NMAGsmModem *nma_gsm_modem_new (DBusGConnection *bus,
						  const char *object_path);

guint32 nma_gsm_modem_get_signal_quality (NMAGsmModem *modem);
guint32 nma_gsm_modem_get_registration_info (NMAGsmModem *modem,
									char **operator_code,
									char **operator_name);

guint32 nma_gsm_modem_get_network_mode (NMAGsmModem *modem);

G_END_DECLS

#endif /* NMA_GSM_MODEM_H */
