/* NetworkManager Wireless Applet -- Display wireless access points and allow user control
 *
 * Dan Williams <dcbw@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * This applet used the GNOME Wireless Applet as a skeleton to build from.
 *
 * (C) Copyright 2005 Red Hat, Inc.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <string.h>
#include <stdlib.h>
#include <signal.h>

#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

#include "applet.h"
#include <syslog.h>

static GMainLoop *loop = NULL;

static void
log_handler (const gchar *log_domain,
             GLogLevelFlags log_level,
             const gchar *message,
             gpointer ignored)
{
  int syslog_priority;

  switch (log_level) {
  case G_LOG_LEVEL_ERROR:
    syslog_priority = LOG_CRIT;
    break;

  case G_LOG_LEVEL_CRITICAL:
    syslog_priority = LOG_ERR;
    break;

  case G_LOG_LEVEL_WARNING:
    syslog_priority = LOG_WARNING;
    break;

  case G_LOG_LEVEL_MESSAGE:
    syslog_priority = LOG_NOTICE;
    break;

  case G_LOG_LEVEL_DEBUG:
    syslog_priority = LOG_DEBUG;
    break;

  case G_LOG_LEVEL_INFO:
  default:
    syslog_priority = LOG_INFO;
    break;
  }

  syslog (syslog_priority, "%s", message);
}

static void
logging_setup (void)
{
  openlog (G_LOG_DOMAIN, LOG_CONS, LOG_DAEMON);
  g_log_set_handler (G_LOG_DOMAIN, 
		     G_LOG_LEVEL_MASK | G_LOG_FLAG_FATAL | G_LOG_FLAG_RECURSION,
		     log_handler,
		     NULL);
}

static void
logging_shutdown (void)
{
  closelog ();
}


static void
signal_handler (int signo)
{
	if (signo == SIGINT || signo == SIGTERM) {
		g_message ("Caught signal %d, shutting down...", signo);
		g_main_loop_quit (loop);
	}
}

static void
setup_signals (void)
{
	struct sigaction action;
	sigset_t mask;

	sigemptyset (&mask);
	action.sa_handler = signal_handler;
	action.sa_mask = mask;
	action.sa_flags = 0;
	sigaction (SIGTERM,  &action, NULL);
	sigaction (SIGINT,  &action, NULL);
}

int main (int argc, char *argv[])
{
	NMApplet * applet;

	bindtextdomain (GETTEXT_PACKAGE, NMALOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	gtk_init (&argc, &argv);
	textdomain (GETTEXT_PACKAGE);

	logging_setup ();

	g_debug("main");

	applet = nm_applet_new ();
	if (applet == NULL)
		exit (1);

	loop = g_main_loop_new (NULL, FALSE);
	setup_signals ();
	g_main_loop_run (loop);

	g_object_unref (G_OBJECT (applet));
	logging_shutdown ();

	exit (0);
}

