/* -*- Mode: C; tab-width: 5; indent-tabs-mode: t; c-basic-offset: 5 -*- */

#include "nma-gsm-modem.h"
#include "mm-types.h"

G_DEFINE_TYPE (NMAGsmModem, nma_gsm_modem, G_TYPE_OBJECT)

#define NMA_GSM_MODEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NMA_TYPE_GSM_MODEM, NMAGsmModemPrivate))

typedef struct {
	DBusGProxy *proxy;
	int signal_quality;
	int network_mode;

	gboolean disposed;
} NMAGsmModemPrivate;

enum {
	SIGNAL_QUALITY,
	NETWORK_MODE,

	LAST_SIGNAL
};

static guint signals[LAST_SIGNAL] = { 0, 0 };

static void
signal_quality_proxy (DBusGProxy *proxy,
				  guint32 signal_quality,
				  gpointer user_data)
{
	NMAGsmModem *modem = NMA_GSM_MODEM (user_data);


	NMA_GSM_MODEM_GET_PRIVATE (modem)->signal_quality = signal_quality;

	g_signal_emit (modem, signals[SIGNAL_QUALITY], 0, signal_quality);
}

static void
network_mode_proxy (DBusGProxy *proxy,
				guint32 network_mode,
				gpointer user_data)
{
	NMAGsmModem *modem = NMA_GSM_MODEM (user_data);

	g_debug("network_mode_proxy");

	NMA_GSM_MODEM_GET_PRIVATE (modem)->network_mode = network_mode;	

	g_signal_emit (modem, signals[NETWORK_MODE], 0, network_mode);
}

NMAGsmModem *
nma_gsm_modem_new (DBusGConnection *bus, const char *object_path)
{
	NMAGsmModem *modem;
	NMAGsmModemPrivate *priv;

	g_return_val_if_fail (bus != NULL, NULL);
	g_return_val_if_fail (object_path != NULL, NULL);

	modem = (NMAGsmModem *) g_object_new (NMA_TYPE_GSM_MODEM, NULL);
	if (!modem)
		return NULL;

	priv = NMA_GSM_MODEM_GET_PRIVATE (modem);
	priv->proxy = dbus_g_proxy_new_for_name (bus, MM_DBUS_SERVICE, object_path, MM_DBUS_INTERFACE_MODEM_GSM);

	dbus_g_proxy_add_signal (priv->proxy, "SignalQuality", G_TYPE_UINT, G_TYPE_INVALID);
	dbus_g_proxy_connect_signal (priv->proxy, "SignalQuality",
						    G_CALLBACK (signal_quality_proxy),
						    modem,
						    NULL);

	dbus_g_proxy_add_signal (priv->proxy, "NetworkMode", G_TYPE_UINT, G_TYPE_INVALID);
	dbus_g_proxy_connect_signal (priv->proxy, "NetworkMode",
						    G_CALLBACK (network_mode_proxy),
						    modem,
						    NULL);

	return modem;
}

guint32
nma_gsm_modem_get_signal_quality (NMAGsmModem *modem)
{
	NMAGsmModemPrivate *priv = NMA_GSM_MODEM_GET_PRIVATE (modem);
	GError *err = NULL;

	g_return_val_if_fail (NMA_IS_GSM_MODEM (modem), 0);

	//	if (priv->signal_quality == -1) {
		if (!dbus_g_proxy_call (priv->proxy, "GetSignalQuality", &err,
						    G_TYPE_INVALID,
						    G_TYPE_UINT, &priv->signal_quality,
						    G_TYPE_INVALID)) {
			g_warning ("Error in getting signal quality: %s", err->message);
			g_error_free (err);
		}
	//	}

	return priv->signal_quality;
}

guint32
nma_gsm_modem_get_registration_info (NMAGsmModem *modem,
							  char **operator_code,
							  char **operator_name)
{
	NMAGsmModemPrivate *priv = NMA_GSM_MODEM_GET_PRIVATE (modem);
	GError *err = NULL;
	guint32 status = MM_GSM_MODEM_REG_STATUS_UNKNOWN;

	g_return_val_if_fail (NMA_IS_GSM_MODEM (modem), 0);

    	if (!dbus_g_proxy_call (priv->proxy, "GetRegistrationInfo", &err,
    				    G_TYPE_INVALID,
    				    G_TYPE_UINT, &status,
    				    G_TYPE_STRING, operator_code,
    				    G_TYPE_STRING, operator_name,
    				    G_TYPE_INVALID)) {
    		g_warning ("Error in getting network mode: %s", err->message);
    		g_error_free (err);
    	}
	return status;
}
	

guint32
nma_gsm_modem_get_network_mode (NMAGsmModem *modem)
{
	NMAGsmModemPrivate *priv = NMA_GSM_MODEM_GET_PRIVATE (modem);
	GError *err = NULL;

	g_return_val_if_fail (NMA_IS_GSM_MODEM (modem), 0);

	g_debug("nma_gsm_modem_get_network_mode ");

	//if (priv->network_mode == -1) {
		if (!dbus_g_proxy_call (priv->proxy, "GetNetworkMode", &err,
					    G_TYPE_INVALID,
					    G_TYPE_UINT, &priv->network_mode,
					    G_TYPE_INVALID)) {
			g_warning ("Error in getting network mode: %s", err->message);
			g_error_free (err);
		}
	//}

	return priv->network_mode;
}

static void
nma_gsm_modem_init (NMAGsmModem *modem)
{
	NMAGsmModemPrivate *priv = NMA_GSM_MODEM_GET_PRIVATE (modem);

	priv->signal_quality = -1;
	priv->network_mode = -1;
}

static void
dispose (GObject *object)
{
	NMAGsmModemPrivate *priv = NMA_GSM_MODEM_GET_PRIVATE (object);

	if (priv->disposed)
		return;

	priv->disposed = TRUE;

	if (priv->proxy)
		g_object_unref (priv->proxy);

	G_OBJECT_CLASS (nma_gsm_modem_parent_class)->dispose (object);
}

static void
nma_gsm_modem_class_init (NMAGsmModemClass *modem_class)
{
	GObjectClass *object_class = G_OBJECT_CLASS (modem_class);

	g_type_class_add_private (modem_class, sizeof (NMAGsmModemPrivate));

	/* virtual methods */
	object_class->dispose = dispose;

	/* Signals */
	signals[SIGNAL_QUALITY] = 
		g_signal_new ("signal-quality",
				    G_OBJECT_CLASS_TYPE (object_class),
				    G_SIGNAL_RUN_FIRST,
				    G_STRUCT_OFFSET (NMAGsmModemClass, signal_quality),
				    NULL, NULL,
				    g_cclosure_marshal_VOID__UINT,
				    G_TYPE_NONE, 1,
				    G_TYPE_UINT);

	signals[NETWORK_MODE] = 
		g_signal_new ("network-mode",
				    G_OBJECT_CLASS_TYPE (object_class),
				    G_SIGNAL_RUN_FIRST,
				    G_STRUCT_OFFSET (NMAGsmModemClass, network_mode),
				    NULL, NULL,
				    g_cclosure_marshal_VOID__UINT,
				    G_TYPE_NONE, 1,
				    G_TYPE_UINT);
}
