/***************************************************************************
 *Copyright (C) 2008 Inventec Corporation.
 *
 * This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *************************************************************************/*
#ifndef THREEG_INCLUDED
#define THREEG_INCLUDED

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/module.h>

#include <linux/moduleparam.h> //接收參數
#include <linux/types.h> //裝置編號型別定義
#include <linux/kdev_t.h> //裝置編號處理函數，如MKDEV, MAJOR , MINOR
#include <linux/fs.h> //註冊裝置編號函數
#include <linux/cdev.h> //註冊字元裝置
#include <asm/io.h> //inb, outb
#include <linux/jiffies.h>
#include <linux/sched.h>

int threeg_open(struct inode *node, struct file *filp);
int threeg_release(struct inode *node, struct file *filp);
int read_device(void);
ssize_t threeg_read (struct file *filp, char __user *buff, size_t count, loff_t *fpos);
ssize_t threeg_write (struct file *filp, const char __user *buff, size_t count, loff_t *fpos);
#endif
