import bzrlib
from bzrlib import commands

from version import *


class BzrToolsCommand(commands.Command):

    def run_argv_aliases(self, argv, alias_argv=None):
        result = check_bzrlib_version(version_info[:2])
        if result is not None:
            return result
        commands.Command.run_argv_aliases(self, argv, alias_argv)


def check_bzrlib_version(desired):
    """Check that bzrlib is compatible.

    If version is < bzrtools version, assume incompatible.
    If version == bzrtools version, assume completely compatible
    If version == bzrtools version + 1, assume compatible, with deprecations
    Otherwise, assume incompatible.
    """
    desired_plus = (desired[0], desired[1]+1)
    bzrlib_version = bzrlib.version_info[:2]
    if bzrlib_version == desired or (bzrlib_version == desired_plus and
                                     bzrlib.version_info[3] == 'dev'):
        return
    try:
        from bzrlib.trace import warning
    except ImportError:
        # get the message out any way we can
        from warnings import warn as warning
    if bzrlib_version < desired:
        warning('Installed Bazaar version %s is too old to be used with'
                ' plugin \n'
                '"Bzrtools" %s.' % (
                bzrlib.__version__, '%s.%s.%s' % version_info))
        # Not using BzrNewError, because it may not exist.
        return 3
    else:
        warning('Plugin "Bzrtools" is not up to date with installed Bazaar'
                ' version %s.\n'
                'There should be a newer version of Bzrtools available, e.g.'
                ' %i.%i.'
                % (bzrlib.__version__, bzrlib_version[0], bzrlib_version[1]))
        if bzrlib_version != desired_plus:
            return 3
