/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _CUBEREFLEX_OPTIONS_H
#define _CUBEREFLEX_OPTIONS_H

#include <compiz-common.h>

COMPIZ_BEGIN_DECLS

CompPluginVTable * getCompPluginInfo (void);

typedef enum
{
    CubereflexDisplayOptionNum
} CubereflexDisplayOptions;

typedef void (*cubereflexDisplayOptionChangeNotifyProc) (CompDisplay *display, CompOption *opt, CubereflexDisplayOptions num);

CompOption *cubereflexGetDisplayOption (CompDisplay *d, CubereflexDisplayOptions num);

typedef enum
{
    CubereflexScreenOptionGroundColor1,
    CubereflexScreenOptionGroundColor2,
    CubereflexScreenOptionGroundSize,
    CubereflexScreenOptionIntensity,
    CubereflexScreenOptionAutoZoom,
    CubereflexScreenOptionZoomManualOnly,
    CubereflexScreenOptionMode,
    CubereflexScreenOptionNum
} CubereflexScreenOptions;

typedef void (*cubereflexScreenOptionChangeNotifyProc) (CompScreen *screen, CompOption *opt, CubereflexScreenOptions num);

CompOption *cubereflexGetScreenOption (CompScreen *s, CubereflexScreenOptions num);

typedef enum
{
    ModeJumpy = 0,
    ModeJumpyReflection = 1,
    ModeDistance = 2,
    ModeAbove = 3,
} CubereflexModeEnum;

unsigned short * cubereflexGetGroundColor1 (CompScreen *s);
unsigned short   cubereflexGetGroundColor1Red (CompScreen *s);
unsigned short   cubereflexGetGroundColor1Green (CompScreen *s);
unsigned short   cubereflexGetGroundColor1Blue (CompScreen *s);
unsigned short   cubereflexGetGroundColor1Alpha (CompScreen *s);
CompOption *     cubereflexGetGroundColor1Option (CompScreen *s);
void             cubereflexSetGroundColor1Notify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify);

unsigned short * cubereflexGetGroundColor2 (CompScreen *s);
unsigned short   cubereflexGetGroundColor2Red (CompScreen *s);
unsigned short   cubereflexGetGroundColor2Green (CompScreen *s);
unsigned short   cubereflexGetGroundColor2Blue (CompScreen *s);
unsigned short   cubereflexGetGroundColor2Alpha (CompScreen *s);
CompOption *     cubereflexGetGroundColor2Option (CompScreen *s);
void             cubereflexSetGroundColor2Notify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify);

float            cubereflexGetGroundSize (CompScreen *s);
CompOption *     cubereflexGetGroundSizeOption (CompScreen *s);
void             cubereflexSetGroundSizeNotify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify);

float            cubereflexGetIntensity (CompScreen *s);
CompOption *     cubereflexGetIntensityOption (CompScreen *s);
void             cubereflexSetIntensityNotify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify);

Bool             cubereflexGetAutoZoom (CompScreen *s);
CompOption *     cubereflexGetAutoZoomOption (CompScreen *s);
void             cubereflexSetAutoZoomNotify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify);

Bool             cubereflexGetZoomManualOnly (CompScreen *s);
CompOption *     cubereflexGetZoomManualOnlyOption (CompScreen *s);
void             cubereflexSetZoomManualOnlyNotify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify);

int              cubereflexGetMode (CompScreen *s);
CompOption *     cubereflexGetModeOption (CompScreen *s);
void             cubereflexSetModeNotify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify);

#ifndef GENERIC_PRIVATE_DEFINES
#define GENERIC_PRIVATE_DEFINES

#define GET_PLUGIN_CORE(object, plugin) \
    ((plugin##Core *) (object)->base.privates[plugin##CorePrivateIndex].ptr)
#define PLUGIN_CORE(object, plugin, prefix) \
    plugin##Core * prefix##c = GET_PLUGIN_CORE (object, plugin)

#define GET_PLUGIN_DISPLAY(object, plugin) \
    ((plugin##Display *) \
	(object)->base.privates[plugin##DisplayPrivateIndex].ptr)
#define PLUGIN_DISPLAY(object, plugin, prefix) \
    plugin##Display * prefix##d = GET_PLUGIN_DISPLAY (object, plugin)

#define GET_PLUGIN_SCREEN(object, parent, plugin) \
    ((plugin##Screen *) \
	(object)->base.privates[(parent)->screenPrivateIndex].ptr)
#define PLUGIN_SCREEN(object, plugin, prefix) \
    plugin##Screen * prefix##s = \
	GET_PLUGIN_SCREEN (object, \
	GET_PLUGIN_DISPLAY ((object)->display, plugin), plugin)

#define GET_PLUGIN_WINDOW(object, parent, plugin) \
    ((plugin##Window *) \
	(object)->base.privates[(parent)->windowPrivateIndex].ptr)
#define PLUGIN_WINDOW(object, plugin, prefix) \
    plugin##Window * prefix##w = \
	GET_PLUGIN_WINDOW  (object, \
	GET_PLUGIN_SCREEN  ((object)->screen, \
	GET_PLUGIN_DISPLAY ((object)->screen->display, plugin), plugin), plugin)

#endif

COMPIZ_END_DECLS

#endif
