/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "extrawm_options.h"

static int ExtrawmOptionsDisplayPrivateIndex;

static CompMetadata extrawmOptionsMetadata;

static CompPluginVTable *extrawmPluginVTable = NULL;
CompPluginVTable extrawmOptionsVTable;

#define EXTRAWM_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, ExtrawmOptions, o)
#define EXTRAWM_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, ExtrawmOptions, o)

typedef struct _ExtrawmOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[ExtrawmDisplayOptionNum];
    extrawmDisplayOptionChangeNotifyProc notify[ExtrawmDisplayOptionNum];
} ExtrawmOptionsDisplay;

typedef struct _ExtrawmOptionsScreen
{
} ExtrawmOptionsScreen;

CompAction * extrawmGetActivate (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionActivate].value.action;
}

void extrawmSetActivateInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionActivate].value.action.initiate = init;
}

void extrawmSetActivateTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionActivate].value.action.terminate = term;
}

CompOption * extrawmGetActivateOption (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionActivate];
}

void extrawmSetActivateNotify (CompDisplay *d, extrawmDisplayOptionChangeNotifyProc notify)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->notify[ExtrawmDisplayOptionActivate] = notify;
}

CompAction * extrawmGetToggleRedirectKey (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleRedirectKey].value.action;
}

void extrawmSetToggleRedirectKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleRedirectKey].value.action.initiate = init;
}

void extrawmSetToggleRedirectKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleRedirectKey].value.action.terminate = term;
}

CompOption * extrawmGetToggleRedirectKeyOption (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleRedirectKey];
}

void extrawmSetToggleRedirectKeyNotify (CompDisplay *d, extrawmDisplayOptionChangeNotifyProc notify)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->notify[ExtrawmDisplayOptionToggleRedirectKey] = notify;
}

CompAction * extrawmGetToggleFullscreenKey (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleFullscreenKey].value.action;
}

void extrawmSetToggleFullscreenKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleFullscreenKey].value.action.initiate = init;
}

void extrawmSetToggleFullscreenKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleFullscreenKey].value.action.terminate = term;
}

CompOption * extrawmGetToggleFullscreenKeyOption (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleFullscreenKey];
}

void extrawmSetToggleFullscreenKeyNotify (CompDisplay *d, extrawmDisplayOptionChangeNotifyProc notify)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->notify[ExtrawmDisplayOptionToggleFullscreenKey] = notify;
}

CompAction * extrawmGetToggleAlwaysOnTopKey (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleAlwaysOnTopKey].value.action;
}

void extrawmSetToggleAlwaysOnTopKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleAlwaysOnTopKey].value.action.initiate = init;
}

void extrawmSetToggleAlwaysOnTopKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleAlwaysOnTopKey].value.action.terminate = term;
}

CompOption * extrawmGetToggleAlwaysOnTopKeyOption (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleAlwaysOnTopKey];
}

void extrawmSetToggleAlwaysOnTopKeyNotify (CompDisplay *d, extrawmDisplayOptionChangeNotifyProc notify)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->notify[ExtrawmDisplayOptionToggleAlwaysOnTopKey] = notify;
}

CompAction * extrawmGetToggleStickyKey (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleStickyKey].value.action;
}

void extrawmSetToggleStickyKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleStickyKey].value.action.initiate = init;
}

void extrawmSetToggleStickyKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleStickyKey].value.action.terminate = term;
}

CompOption * extrawmGetToggleStickyKeyOption (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleStickyKey];
}

void extrawmSetToggleStickyKeyNotify (CompDisplay *d, extrawmDisplayOptionChangeNotifyProc notify)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->notify[ExtrawmDisplayOptionToggleStickyKey] = notify;
}

CompOption * extrawmGetDisplayOption (CompDisplay *d, ExtrawmDisplayOptions num)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo extrawmOptionsDisplayOptionInfo[] = {
    { "activate", "action", 0, 0, 0 },
    { "toggle_redirect_key", "key", 0, 0, 0 },
    { "toggle_fullscreen_key", "key", 0, 0, 0 },
    { "toggle_always_on_top_key", "key", 0, 0, 0 },
    { "toggle_sticky_key", "key", 0, 0, 0 },
};

static Bool extrawmOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, ExtrawmDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ExtrawmDisplayOptionActivate:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExtrawmDisplayOptionActivate])
                (*od->notify[ExtrawmDisplayOptionActivate]) (d, o, ExtrawmDisplayOptionActivate);
            return TRUE;
        }
        break;
     case ExtrawmDisplayOptionToggleRedirectKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExtrawmDisplayOptionToggleRedirectKey])
                (*od->notify[ExtrawmDisplayOptionToggleRedirectKey]) (d, o, ExtrawmDisplayOptionToggleRedirectKey);
            return TRUE;
        }
        break;
     case ExtrawmDisplayOptionToggleFullscreenKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExtrawmDisplayOptionToggleFullscreenKey])
                (*od->notify[ExtrawmDisplayOptionToggleFullscreenKey]) (d, o, ExtrawmDisplayOptionToggleFullscreenKey);
            return TRUE;
        }
        break;
     case ExtrawmDisplayOptionToggleAlwaysOnTopKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExtrawmDisplayOptionToggleAlwaysOnTopKey])
                (*od->notify[ExtrawmDisplayOptionToggleAlwaysOnTopKey]) (d, o, ExtrawmDisplayOptionToggleAlwaysOnTopKey);
            return TRUE;
        }
        break;
     case ExtrawmDisplayOptionToggleStickyKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExtrawmDisplayOptionToggleStickyKey])
                (*od->notify[ExtrawmDisplayOptionToggleStickyKey]) (d, o, ExtrawmDisplayOptionToggleStickyKey);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * extrawmOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    *count = ExtrawmDisplayOptionNum;
    return od->opt;
}

static Bool extrawmOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ExtrawmOptionsScreen *os;
    
    EXTRAWM_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ExtrawmOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void extrawmOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    EXTRAWM_OPTIONS_SCREEN (s);

    free (os);
}

static Bool extrawmOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ExtrawmOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ExtrawmOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[ExtrawmOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &extrawmOptionsMetadata, extrawmOptionsDisplayOptionInfo, od->opt, ExtrawmDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void extrawmOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, ExtrawmDisplayOptionNum);

    free (od);
}

static Bool extrawmOptionsInit (CompPlugin *p)
{
    ExtrawmOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (ExtrawmOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&extrawmOptionsMetadata, "extrawm",extrawmOptionsDisplayOptionInfo, ExtrawmDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&extrawmOptionsMetadata, "extrawm");
    if (extrawmPluginVTable && extrawmPluginVTable->init)
        return extrawmPluginVTable->init (p);
    return TRUE;
}

static void extrawmOptionsFini (CompPlugin *p)
{
    if (extrawmPluginVTable && extrawmPluginVTable->fini)
        extrawmPluginVTable->fini (p);

    if (ExtrawmOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (ExtrawmOptionsDisplayPrivateIndex);

    compFiniMetadata (&extrawmOptionsMetadata);
}

static CompBool extrawmOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) extrawmOptionsInitDisplay,
        (InitPluginObjectProc) extrawmOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void extrawmOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) extrawmOptionsFiniDisplay,
        (FiniPluginObjectProc) extrawmOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool extrawmOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = extrawmOptionsInitObject (p, o);
    if (extrawmPluginVTable->initObject)
        rv &= extrawmPluginVTable->initObject (p, o);
    return rv;
}

static void extrawmOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (extrawmPluginVTable->finiObject)
        extrawmPluginVTable->finiObject (p, o);
    extrawmOptionsFiniObject (p, o);
}

static CompOption * extrawmOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) extrawmOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool extrawmOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) extrawmOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
extrawmOptionsGetMetadata (CompPlugin *plugin)
{
    return &extrawmOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!extrawmPluginVTable)
    {
        extrawmPluginVTable = getCompPluginInfo ();
        memcpy(&extrawmOptionsVTable, extrawmPluginVTable, sizeof(CompPluginVTable));
        extrawmOptionsVTable.getMetadata = extrawmOptionsGetMetadata;
        extrawmOptionsVTable.init = extrawmOptionsInit;
        extrawmOptionsVTable.fini = extrawmOptionsFini;
        extrawmOptionsVTable.initObject = extrawmOptionsInitObjectWrapper;
        extrawmOptionsVTable.finiObject = extrawmOptionsFiniObjectWrapper;
        extrawmOptionsVTable.getObjectOptions = extrawmOptionsGetObjectOptions;
	extrawmOptionsVTable.setObjectOption = extrawmOptionsSetObjectOption;
	
    }
    return &extrawmOptionsVTable;
}

