/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "firepaint_options.h"

static int FirepaintOptionsDisplayPrivateIndex;

static CompMetadata firepaintOptionsMetadata;

static CompPluginVTable *firepaintPluginVTable = NULL;
CompPluginVTable firepaintOptionsVTable;

#define FIREPAINT_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, FirepaintOptions, o)
#define FIREPAINT_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, FirepaintOptions, o)

typedef struct _FirepaintOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[FirepaintDisplayOptionNum];
    firepaintDisplayOptionChangeNotifyProc notify[FirepaintDisplayOptionNum];
} FirepaintOptionsDisplay;

typedef struct _FirepaintOptionsScreen
{
    CompOption opt[FirepaintScreenOptionNum];
    firepaintScreenOptionChangeNotifyProc notify[FirepaintScreenOptionNum];
} FirepaintOptionsScreen;

CompAction * firepaintGetInitiateKey (CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[FirepaintDisplayOptionInitiateKey].value.action;
}

void firepaintSetInitiateKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->opt[FirepaintDisplayOptionInitiateKey].value.action.initiate = init;
}

void firepaintSetInitiateKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->opt[FirepaintDisplayOptionInitiateKey].value.action.terminate = term;
}

CompOption * firepaintGetInitiateKeyOption (CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[FirepaintDisplayOptionInitiateKey];
}

void firepaintSetInitiateKeyNotify (CompDisplay *d, firepaintDisplayOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->notify[FirepaintDisplayOptionInitiateKey] = notify;
}

CompAction * firepaintGetInitiateButton (CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[FirepaintDisplayOptionInitiateButton].value.action;
}

void firepaintSetInitiateButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->opt[FirepaintDisplayOptionInitiateButton].value.action.initiate = init;
}

void firepaintSetInitiateButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->opt[FirepaintDisplayOptionInitiateButton].value.action.terminate = term;
}

CompOption * firepaintGetInitiateButtonOption (CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[FirepaintDisplayOptionInitiateButton];
}

void firepaintSetInitiateButtonNotify (CompDisplay *d, firepaintDisplayOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->notify[FirepaintDisplayOptionInitiateButton] = notify;
}

CompAction * firepaintGetClearKey (CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[FirepaintDisplayOptionClearKey].value.action;
}

void firepaintSetClearKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->opt[FirepaintDisplayOptionClearKey].value.action.initiate = init;
}

void firepaintSetClearKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->opt[FirepaintDisplayOptionClearKey].value.action.terminate = term;
}

CompOption * firepaintGetClearKeyOption (CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[FirepaintDisplayOptionClearKey];
}

void firepaintSetClearKeyNotify (CompDisplay *d, firepaintDisplayOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->notify[FirepaintDisplayOptionClearKey] = notify;
}

CompAction * firepaintGetClearButton (CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[FirepaintDisplayOptionClearButton].value.action;
}

void firepaintSetClearButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->opt[FirepaintDisplayOptionClearButton].value.action.initiate = init;
}

void firepaintSetClearButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->opt[FirepaintDisplayOptionClearButton].value.action.terminate = term;
}

CompOption * firepaintGetClearButtonOption (CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[FirepaintDisplayOptionClearButton];
}

void firepaintSetClearButtonNotify (CompDisplay *d, firepaintDisplayOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->notify[FirepaintDisplayOptionClearButton] = notify;
}

int firepaintGetNumParticles (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionNumParticles].value.i;
}

CompOption * firepaintGetNumParticlesOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionNumParticles];
}

void firepaintSetNumParticlesNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionNumParticles] = notify;
}

float firepaintGetFireSize (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireSize].value.f;
}

CompOption * firepaintGetFireSizeOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionFireSize];
}

void firepaintSetFireSizeNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionFireSize] = notify;
}

float firepaintGetFireSlowdown (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireSlowdown].value.f;
}

CompOption * firepaintGetFireSlowdownOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionFireSlowdown];
}

void firepaintSetFireSlowdownNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionFireSlowdown] = notify;
}

float firepaintGetFireLife (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireLife].value.f;
}

CompOption * firepaintGetFireLifeOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionFireLife];
}

void firepaintSetFireLifeNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionFireLife] = notify;
}

unsigned short * firepaintGetFireColor (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireColor].value.c;
}

unsigned short firepaintGetFireColorRed (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireColor].value.c[0];
}

unsigned short firepaintGetFireColorGreen (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireColor].value.c[1];
}

unsigned short firepaintGetFireColorBlue (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireColor].value.c[2];
}

unsigned short firepaintGetFireColorAlpha (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireColor].value.c[3];
}

CompOption * firepaintGetFireColorOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionFireColor];
}

void firepaintSetFireColorNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionFireColor] = notify;
}

Bool firepaintGetFireMystical (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireMystical].value.b;
}

CompOption * firepaintGetFireMysticalOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionFireMystical];
}

void firepaintSetFireMysticalNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionFireMystical] = notify;
}

int firepaintGetBgBrightness (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionBgBrightness].value.i;
}

CompOption * firepaintGetBgBrightnessOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionBgBrightness];
}

void firepaintSetBgBrightnessNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionBgBrightness] = notify;
}

CompOption * firepaintGetDisplayOption (CompDisplay *d, FirepaintDisplayOptions num)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * firepaintGetScreenOption (CompScreen *s, FirepaintScreenOptions num)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo firepaintOptionsDisplayOptionInfo[] = {
    { "initiate_key", "key", 0, 0, 0 },
    { "initiate_button", "button", 0, 0, 0 },
    { "clear_key", "key", 0, 0, 0 },
    { "clear_button", "button", 0, 0, 0 },
};

static Bool firepaintOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, FirepaintDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case FirepaintDisplayOptionInitiateKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[FirepaintDisplayOptionInitiateKey])
                (*od->notify[FirepaintDisplayOptionInitiateKey]) (d, o, FirepaintDisplayOptionInitiateKey);
            return TRUE;
        }
        break;
     case FirepaintDisplayOptionInitiateButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[FirepaintDisplayOptionInitiateButton])
                (*od->notify[FirepaintDisplayOptionInitiateButton]) (d, o, FirepaintDisplayOptionInitiateButton);
            return TRUE;
        }
        break;
     case FirepaintDisplayOptionClearKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[FirepaintDisplayOptionClearKey])
                (*od->notify[FirepaintDisplayOptionClearKey]) (d, o, FirepaintDisplayOptionClearKey);
            return TRUE;
        }
        break;
     case FirepaintDisplayOptionClearButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[FirepaintDisplayOptionClearButton])
                (*od->notify[FirepaintDisplayOptionClearButton]) (d, o, FirepaintDisplayOptionClearButton);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * firepaintOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    *count = FirepaintDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo firepaintOptionsScreenOptionInfo[] = {
    { "num_Particles", "int", "<min>100</min><max>20000</max>", 0, 0 },
    { "fire_size", "float", "<min>0.1</min><max>40</max>", 0, 0 },
    { "fire_slowdown", "float", "<min>0.1</min><max>10</max>", 0, 0 },
    { "fire_life", "float", "<min>0.1</min><max>0.95</max>", 0, 0 },
    { "fire_color", "color", 0, 0, 0 },
    { "fire_mystical", "bool", 0, 0, 0 },
    { "bg_brightness", "int", "<min>0</min><max>100</max>", 0, 0 },
};

static Bool firepaintOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, FirepaintScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case FirepaintScreenOptionNumParticles:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionNumParticles])
                (*os->notify[FirepaintScreenOptionNumParticles]) (s, o, FirepaintScreenOptionNumParticles);
            return TRUE;
        }
        break;
     case FirepaintScreenOptionFireSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionFireSize])
                (*os->notify[FirepaintScreenOptionFireSize]) (s, o, FirepaintScreenOptionFireSize);
            return TRUE;
        }
        break;
     case FirepaintScreenOptionFireSlowdown:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionFireSlowdown])
                (*os->notify[FirepaintScreenOptionFireSlowdown]) (s, o, FirepaintScreenOptionFireSlowdown);
            return TRUE;
        }
        break;
     case FirepaintScreenOptionFireLife:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionFireLife])
                (*os->notify[FirepaintScreenOptionFireLife]) (s, o, FirepaintScreenOptionFireLife);
            return TRUE;
        }
        break;
     case FirepaintScreenOptionFireColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionFireColor])
                (*os->notify[FirepaintScreenOptionFireColor]) (s, o, FirepaintScreenOptionFireColor);
            return TRUE;
        }
        break;
     case FirepaintScreenOptionFireMystical:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionFireMystical])
                (*os->notify[FirepaintScreenOptionFireMystical]) (s, o, FirepaintScreenOptionFireMystical);
            return TRUE;
        }
        break;
     case FirepaintScreenOptionBgBrightness:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionBgBrightness])
                (*os->notify[FirepaintScreenOptionBgBrightness]) (s, o, FirepaintScreenOptionBgBrightness);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * firepaintOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    *count = FirepaintScreenOptionNum;
    return os->opt;
}

static Bool firepaintOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    FirepaintOptionsScreen *os;
    
    FIREPAINT_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(FirepaintOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &firepaintOptionsMetadata, firepaintOptionsScreenOptionInfo, os->opt, FirepaintScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void firepaintOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, FirepaintScreenOptionNum);

    free (os);
}

static Bool firepaintOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    FirepaintOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(FirepaintOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[FirepaintOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &firepaintOptionsMetadata, firepaintOptionsDisplayOptionInfo, od->opt, FirepaintDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void firepaintOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, FirepaintDisplayOptionNum);

    free (od);
}

static Bool firepaintOptionsInit (CompPlugin *p)
{
    FirepaintOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (FirepaintOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&firepaintOptionsMetadata, "firepaint",firepaintOptionsDisplayOptionInfo, FirepaintDisplayOptionNum, firepaintOptionsScreenOptionInfo, FirepaintScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&firepaintOptionsMetadata, "firepaint");
    if (firepaintPluginVTable && firepaintPluginVTable->init)
        return firepaintPluginVTable->init (p);
    return TRUE;
}

static void firepaintOptionsFini (CompPlugin *p)
{
    if (firepaintPluginVTable && firepaintPluginVTable->fini)
        firepaintPluginVTable->fini (p);

    if (FirepaintOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (FirepaintOptionsDisplayPrivateIndex);

    compFiniMetadata (&firepaintOptionsMetadata);
}

static CompBool firepaintOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) firepaintOptionsInitDisplay,
        (InitPluginObjectProc) firepaintOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void firepaintOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) firepaintOptionsFiniDisplay,
        (FiniPluginObjectProc) firepaintOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool firepaintOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = firepaintOptionsInitObject (p, o);
    if (firepaintPluginVTable->initObject)
        rv &= firepaintPluginVTable->initObject (p, o);
    return rv;
}

static void firepaintOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (firepaintPluginVTable->finiObject)
        firepaintPluginVTable->finiObject (p, o);
    firepaintOptionsFiniObject (p, o);
}

static CompOption * firepaintOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) firepaintOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) firepaintOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool firepaintOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) firepaintOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) firepaintOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
firepaintOptionsGetMetadata (CompPlugin *plugin)
{
    return &firepaintOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!firepaintPluginVTable)
    {
        firepaintPluginVTable = getCompPluginInfo ();
        memcpy(&firepaintOptionsVTable, firepaintPluginVTable, sizeof(CompPluginVTable));
        firepaintOptionsVTable.getMetadata = firepaintOptionsGetMetadata;
        firepaintOptionsVTable.init = firepaintOptionsInit;
        firepaintOptionsVTable.fini = firepaintOptionsFini;
        firepaintOptionsVTable.initObject = firepaintOptionsInitObjectWrapper;
        firepaintOptionsVTable.finiObject = firepaintOptionsFiniObjectWrapper;
        firepaintOptionsVTable.getObjectOptions = firepaintOptionsGetObjectOptions;
	firepaintOptionsVTable.setObjectOption = firepaintOptionsSetObjectOption;
	
    }
    return &firepaintOptionsVTable;
}

