/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "showmouse_options.h"

static int ShowmouseOptionsDisplayPrivateIndex;

static CompMetadata showmouseOptionsMetadata;

static CompPluginVTable *showmousePluginVTable = NULL;
CompPluginVTable showmouseOptionsVTable;

#define SHOWMOUSE_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, ShowmouseOptions, o)
#define SHOWMOUSE_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, ShowmouseOptions, o)

typedef struct _ShowmouseOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[ShowmouseDisplayOptionNum];
    showmouseDisplayOptionChangeNotifyProc notify[ShowmouseDisplayOptionNum];
} ShowmouseOptionsDisplay;

typedef struct _ShowmouseOptionsScreen
{
    CompOption opt[ShowmouseScreenOptionNum];
    showmouseScreenOptionChangeNotifyProc notify[ShowmouseScreenOptionNum];
} ShowmouseOptionsScreen;

CompAction * showmouseGetInitiate (CompDisplay *d)
{
    SHOWMOUSE_OPTIONS_DISPLAY(d);
    return &od->opt[ShowmouseDisplayOptionInitiate].value.action;
}

void showmouseSetInitiateInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SHOWMOUSE_OPTIONS_DISPLAY(d);
    od->opt[ShowmouseDisplayOptionInitiate].value.action.initiate = init;
}

void showmouseSetInitiateTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SHOWMOUSE_OPTIONS_DISPLAY(d);
    od->opt[ShowmouseDisplayOptionInitiate].value.action.terminate = term;
}

CompOption * showmouseGetInitiateOption (CompDisplay *d)
{
    SHOWMOUSE_OPTIONS_DISPLAY(d);
    return &od->opt[ShowmouseDisplayOptionInitiate];
}

void showmouseSetInitiateNotify (CompDisplay *d, showmouseDisplayOptionChangeNotifyProc notify)
{
    SHOWMOUSE_OPTIONS_DISPLAY(d);
    od->notify[ShowmouseDisplayOptionInitiate] = notify;
}

int showmouseGetNumParticles (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionNumParticles].value.i;
}

CompOption * showmouseGetNumParticlesOption (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return &os->opt[ShowmouseScreenOptionNumParticles];
}

void showmouseSetNumParticlesNotify (CompScreen *s, showmouseScreenOptionChangeNotifyProc notify)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    os->notify[ShowmouseScreenOptionNumParticles] = notify;
}

float showmouseGetSize (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionSize].value.f;
}

CompOption * showmouseGetSizeOption (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return &os->opt[ShowmouseScreenOptionSize];
}

void showmouseSetSizeNotify (CompScreen *s, showmouseScreenOptionChangeNotifyProc notify)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    os->notify[ShowmouseScreenOptionSize] = notify;
}

float showmouseGetSlowdown (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionSlowdown].value.f;
}

CompOption * showmouseGetSlowdownOption (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return &os->opt[ShowmouseScreenOptionSlowdown];
}

void showmouseSetSlowdownNotify (CompScreen *s, showmouseScreenOptionChangeNotifyProc notify)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    os->notify[ShowmouseScreenOptionSlowdown] = notify;
}

float showmouseGetLife (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionLife].value.f;
}

CompOption * showmouseGetLifeOption (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return &os->opt[ShowmouseScreenOptionLife];
}

void showmouseSetLifeNotify (CompScreen *s, showmouseScreenOptionChangeNotifyProc notify)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    os->notify[ShowmouseScreenOptionLife] = notify;
}

float showmouseGetDarken (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionDarken].value.f;
}

CompOption * showmouseGetDarkenOption (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return &os->opt[ShowmouseScreenOptionDarken];
}

void showmouseSetDarkenNotify (CompScreen *s, showmouseScreenOptionChangeNotifyProc notify)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    os->notify[ShowmouseScreenOptionDarken] = notify;
}

Bool showmouseGetBlend (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionBlend].value.b;
}

CompOption * showmouseGetBlendOption (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return &os->opt[ShowmouseScreenOptionBlend];
}

void showmouseSetBlendNotify (CompScreen *s, showmouseScreenOptionChangeNotifyProc notify)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    os->notify[ShowmouseScreenOptionBlend] = notify;
}

unsigned short * showmouseGetColor (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionColor].value.c;
}

unsigned short showmouseGetColorRed (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionColor].value.c[0];
}

unsigned short showmouseGetColorGreen (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionColor].value.c[1];
}

unsigned short showmouseGetColorBlue (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionColor].value.c[2];
}

unsigned short showmouseGetColorAlpha (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionColor].value.c[3];
}

CompOption * showmouseGetColorOption (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return &os->opt[ShowmouseScreenOptionColor];
}

void showmouseSetColorNotify (CompScreen *s, showmouseScreenOptionChangeNotifyProc notify)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    os->notify[ShowmouseScreenOptionColor] = notify;
}

Bool showmouseGetRandom (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionRandom].value.b;
}

CompOption * showmouseGetRandomOption (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return &os->opt[ShowmouseScreenOptionRandom];
}

void showmouseSetRandomNotify (CompScreen *s, showmouseScreenOptionChangeNotifyProc notify)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    os->notify[ShowmouseScreenOptionRandom] = notify;
}

float showmouseGetRotationSpeed (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionRotationSpeed].value.f;
}

CompOption * showmouseGetRotationSpeedOption (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return &os->opt[ShowmouseScreenOptionRotationSpeed];
}

void showmouseSetRotationSpeedNotify (CompScreen *s, showmouseScreenOptionChangeNotifyProc notify)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    os->notify[ShowmouseScreenOptionRotationSpeed] = notify;
}

int showmouseGetRadius (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionRadius].value.i;
}

CompOption * showmouseGetRadiusOption (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return &os->opt[ShowmouseScreenOptionRadius];
}

void showmouseSetRadiusNotify (CompScreen *s, showmouseScreenOptionChangeNotifyProc notify)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    os->notify[ShowmouseScreenOptionRadius] = notify;
}

int showmouseGetEmiters (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return os->opt[ShowmouseScreenOptionEmiters].value.i;
}

CompOption * showmouseGetEmitersOption (CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return &os->opt[ShowmouseScreenOptionEmiters];
}

void showmouseSetEmitersNotify (CompScreen *s, showmouseScreenOptionChangeNotifyProc notify)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    os->notify[ShowmouseScreenOptionEmiters] = notify;
}

CompOption * showmouseGetDisplayOption (CompDisplay *d, ShowmouseDisplayOptions num)
{
    SHOWMOUSE_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * showmouseGetScreenOption (CompScreen *s, ShowmouseScreenOptions num)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo showmouseOptionsDisplayOptionInfo[] = {
    { "initiate", "key", 0, 0, 0 },
};

static Bool showmouseOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    SHOWMOUSE_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, ShowmouseDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ShowmouseDisplayOptionInitiate:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ShowmouseDisplayOptionInitiate])
                (*od->notify[ShowmouseDisplayOptionInitiate]) (d, o, ShowmouseDisplayOptionInitiate);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * showmouseOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    SHOWMOUSE_OPTIONS_DISPLAY(d);
    *count = ShowmouseDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo showmouseOptionsScreenOptionInfo[] = {
    { "num_particles", "int", "<min>10</min><max>2000</max>", 0, 0 },
    { "size", "float", "<min>0.1</min><max>20</max>", 0, 0 },
    { "slowdown", "float", "<min>0.1</min><max>10</max>", 0, 0 },
    { "life", "float", "<min>0.1</min><max>1</max>", 0, 0 },
    { "darken", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "blend", "bool", 0, 0, 0 },
    { "color", "color", 0, 0, 0 },
    { "random", "bool", 0, 0, 0 },
    { "rotation_speed", "float", "<min>0.1</min><max>10.0</max>", 0, 0 },
    { "radius", "int", "<min>10</min><max>1000</max>", 0, 0 },
    { "emiters", "int", "<min>1</min><max>10</max>", 0, 0 },
};

static Bool showmouseOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, ShowmouseScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ShowmouseScreenOptionNumParticles:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowmouseScreenOptionNumParticles])
                (*os->notify[ShowmouseScreenOptionNumParticles]) (s, o, ShowmouseScreenOptionNumParticles);
            return TRUE;
        }
        break;
     case ShowmouseScreenOptionSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowmouseScreenOptionSize])
                (*os->notify[ShowmouseScreenOptionSize]) (s, o, ShowmouseScreenOptionSize);
            return TRUE;
        }
        break;
     case ShowmouseScreenOptionSlowdown:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowmouseScreenOptionSlowdown])
                (*os->notify[ShowmouseScreenOptionSlowdown]) (s, o, ShowmouseScreenOptionSlowdown);
            return TRUE;
        }
        break;
     case ShowmouseScreenOptionLife:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowmouseScreenOptionLife])
                (*os->notify[ShowmouseScreenOptionLife]) (s, o, ShowmouseScreenOptionLife);
            return TRUE;
        }
        break;
     case ShowmouseScreenOptionDarken:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowmouseScreenOptionDarken])
                (*os->notify[ShowmouseScreenOptionDarken]) (s, o, ShowmouseScreenOptionDarken);
            return TRUE;
        }
        break;
     case ShowmouseScreenOptionBlend:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowmouseScreenOptionBlend])
                (*os->notify[ShowmouseScreenOptionBlend]) (s, o, ShowmouseScreenOptionBlend);
            return TRUE;
        }
        break;
     case ShowmouseScreenOptionColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowmouseScreenOptionColor])
                (*os->notify[ShowmouseScreenOptionColor]) (s, o, ShowmouseScreenOptionColor);
            return TRUE;
        }
        break;
     case ShowmouseScreenOptionRandom:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowmouseScreenOptionRandom])
                (*os->notify[ShowmouseScreenOptionRandom]) (s, o, ShowmouseScreenOptionRandom);
            return TRUE;
        }
        break;
     case ShowmouseScreenOptionRotationSpeed:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowmouseScreenOptionRotationSpeed])
                (*os->notify[ShowmouseScreenOptionRotationSpeed]) (s, o, ShowmouseScreenOptionRotationSpeed);
            return TRUE;
        }
        break;
     case ShowmouseScreenOptionRadius:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowmouseScreenOptionRadius])
                (*os->notify[ShowmouseScreenOptionRadius]) (s, o, ShowmouseScreenOptionRadius);
            return TRUE;
        }
        break;
     case ShowmouseScreenOptionEmiters:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowmouseScreenOptionEmiters])
                (*os->notify[ShowmouseScreenOptionEmiters]) (s, o, ShowmouseScreenOptionEmiters);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * showmouseOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    SHOWMOUSE_OPTIONS_SCREEN(s);
    *count = ShowmouseScreenOptionNum;
    return os->opt;
}

static Bool showmouseOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ShowmouseOptionsScreen *os;
    
    SHOWMOUSE_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ShowmouseOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &showmouseOptionsMetadata, showmouseOptionsScreenOptionInfo, os->opt, ShowmouseScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void showmouseOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    SHOWMOUSE_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, ShowmouseScreenOptionNum);

    free (os);
}

static Bool showmouseOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ShowmouseOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ShowmouseOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[ShowmouseOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &showmouseOptionsMetadata, showmouseOptionsDisplayOptionInfo, od->opt, ShowmouseDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void showmouseOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    SHOWMOUSE_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, ShowmouseDisplayOptionNum);

    free (od);
}

static Bool showmouseOptionsInit (CompPlugin *p)
{
    ShowmouseOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (ShowmouseOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&showmouseOptionsMetadata, "showmouse",showmouseOptionsDisplayOptionInfo, ShowmouseDisplayOptionNum, showmouseOptionsScreenOptionInfo, ShowmouseScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&showmouseOptionsMetadata, "showmouse");
    if (showmousePluginVTable && showmousePluginVTable->init)
        return showmousePluginVTable->init (p);
    return TRUE;
}

static void showmouseOptionsFini (CompPlugin *p)
{
    if (showmousePluginVTable && showmousePluginVTable->fini)
        showmousePluginVTable->fini (p);

    if (ShowmouseOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (ShowmouseOptionsDisplayPrivateIndex);

    compFiniMetadata (&showmouseOptionsMetadata);
}

static CompBool showmouseOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) showmouseOptionsInitDisplay,
        (InitPluginObjectProc) showmouseOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void showmouseOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) showmouseOptionsFiniDisplay,
        (FiniPluginObjectProc) showmouseOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool showmouseOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = showmouseOptionsInitObject (p, o);
    if (showmousePluginVTable->initObject)
        rv &= showmousePluginVTable->initObject (p, o);
    return rv;
}

static void showmouseOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (showmousePluginVTable->finiObject)
        showmousePluginVTable->finiObject (p, o);
    showmouseOptionsFiniObject (p, o);
}

static CompOption * showmouseOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) showmouseOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) showmouseOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool showmouseOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) showmouseOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) showmouseOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
showmouseOptionsGetMetadata (CompPlugin *plugin)
{
    return &showmouseOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!showmousePluginVTable)
    {
        showmousePluginVTable = getCompPluginInfo ();
        memcpy(&showmouseOptionsVTable, showmousePluginVTable, sizeof(CompPluginVTable));
        showmouseOptionsVTable.getMetadata = showmouseOptionsGetMetadata;
        showmouseOptionsVTable.init = showmouseOptionsInit;
        showmouseOptionsVTable.fini = showmouseOptionsFini;
        showmouseOptionsVTable.initObject = showmouseOptionsInitObjectWrapper;
        showmouseOptionsVTable.finiObject = showmouseOptionsFiniObjectWrapper;
        showmouseOptionsVTable.getObjectOptions = showmouseOptionsGetObjectOptions;
	showmouseOptionsVTable.setObjectOption = showmouseOptionsSetObjectOption;
	
    }
    return &showmouseOptionsVTable;
}

