/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "neg_options.h"

static int NegOptionsDisplayPrivateIndex;

static CompMetadata negOptionsMetadata;

static CompPluginVTable *negPluginVTable = NULL;
CompPluginVTable negOptionsVTable;

#define NEG_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, NegOptions, o)
#define NEG_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, NegOptions, o)

typedef struct _NegOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[NegDisplayOptionNum];
    negDisplayOptionChangeNotifyProc notify[NegDisplayOptionNum];
} NegOptionsDisplay;

typedef struct _NegOptionsScreen
{
    CompOption opt[NegScreenOptionNum];
    negScreenOptionChangeNotifyProc notify[NegScreenOptionNum];
} NegOptionsScreen;

CompAction * negGetWindowToggleKey (CompDisplay *d)
{
    NEG_OPTIONS_DISPLAY(d);
    return &od->opt[NegDisplayOptionWindowToggleKey].value.action;
}

void negSetWindowToggleKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    NEG_OPTIONS_DISPLAY(d);
    od->opt[NegDisplayOptionWindowToggleKey].value.action.initiate = init;
}

void negSetWindowToggleKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    NEG_OPTIONS_DISPLAY(d);
    od->opt[NegDisplayOptionWindowToggleKey].value.action.terminate = term;
}

CompOption * negGetWindowToggleKeyOption (CompDisplay *d)
{
    NEG_OPTIONS_DISPLAY(d);
    return &od->opt[NegDisplayOptionWindowToggleKey];
}

void negSetWindowToggleKeyNotify (CompDisplay *d, negDisplayOptionChangeNotifyProc notify)
{
    NEG_OPTIONS_DISPLAY(d);
    od->notify[NegDisplayOptionWindowToggleKey] = notify;
}

CompAction * negGetScreenToggleKey (CompDisplay *d)
{
    NEG_OPTIONS_DISPLAY(d);
    return &od->opt[NegDisplayOptionScreenToggleKey].value.action;
}

void negSetScreenToggleKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    NEG_OPTIONS_DISPLAY(d);
    od->opt[NegDisplayOptionScreenToggleKey].value.action.initiate = init;
}

void negSetScreenToggleKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    NEG_OPTIONS_DISPLAY(d);
    od->opt[NegDisplayOptionScreenToggleKey].value.action.terminate = term;
}

CompOption * negGetScreenToggleKeyOption (CompDisplay *d)
{
    NEG_OPTIONS_DISPLAY(d);
    return &od->opt[NegDisplayOptionScreenToggleKey];
}

void negSetScreenToggleKeyNotify (CompDisplay *d, negDisplayOptionChangeNotifyProc notify)
{
    NEG_OPTIONS_DISPLAY(d);
    od->notify[NegDisplayOptionScreenToggleKey] = notify;
}

CompMatch * negGetNegMatch (CompScreen *s)
{
    NEG_OPTIONS_SCREEN(s);
    return &os->opt[NegScreenOptionNegMatch].value.match;
}

CompOption * negGetNegMatchOption (CompScreen *s)
{
    NEG_OPTIONS_SCREEN(s);
    return &os->opt[NegScreenOptionNegMatch];
}

void negSetNegMatchNotify (CompScreen *s, negScreenOptionChangeNotifyProc notify)
{
    NEG_OPTIONS_SCREEN(s);
    os->notify[NegScreenOptionNegMatch] = notify;
}

CompMatch * negGetExcludeMatch (CompScreen *s)
{
    NEG_OPTIONS_SCREEN(s);
    return &os->opt[NegScreenOptionExcludeMatch].value.match;
}

CompOption * negGetExcludeMatchOption (CompScreen *s)
{
    NEG_OPTIONS_SCREEN(s);
    return &os->opt[NegScreenOptionExcludeMatch];
}

void negSetExcludeMatchNotify (CompScreen *s, negScreenOptionChangeNotifyProc notify)
{
    NEG_OPTIONS_SCREEN(s);
    os->notify[NegScreenOptionExcludeMatch] = notify;
}

CompOption * negGetDisplayOption (CompDisplay *d, NegDisplayOptions num)
{
    NEG_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * negGetScreenOption (CompScreen *s, NegScreenOptions num)
{
    NEG_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo negOptionsDisplayOptionInfo[] = {
    { "window_toggle_key", "key", 0, 0, 0 },
    { "screen_toggle_key", "key", 0, 0, 0 },
};

static Bool negOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    NEG_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, NegDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case NegDisplayOptionWindowToggleKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[NegDisplayOptionWindowToggleKey])
                (*od->notify[NegDisplayOptionWindowToggleKey]) (d, o, NegDisplayOptionWindowToggleKey);
            return TRUE;
        }
        break;
     case NegDisplayOptionScreenToggleKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[NegDisplayOptionScreenToggleKey])
                (*od->notify[NegDisplayOptionScreenToggleKey]) (d, o, NegDisplayOptionScreenToggleKey);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * negOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    NEG_OPTIONS_DISPLAY(d);
    *count = NegDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo negOptionsScreenOptionInfo[] = {
    { "neg_match", "match", 0, 0, 0 },
    { "exclude_match", "match", 0, 0, 0 },
};

static Bool negOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    NEG_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, NegScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case NegScreenOptionNegMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[NegScreenOptionNegMatch])
                (*os->notify[NegScreenOptionNegMatch]) (s, o, NegScreenOptionNegMatch);
            return TRUE;
        }
        break;
     case NegScreenOptionExcludeMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[NegScreenOptionExcludeMatch])
                (*os->notify[NegScreenOptionExcludeMatch]) (s, o, NegScreenOptionExcludeMatch);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * negOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    NEG_OPTIONS_SCREEN(s);
    *count = NegScreenOptionNum;
    return os->opt;
}

static Bool negOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    NegOptionsScreen *os;
    
    NEG_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(NegOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &negOptionsMetadata, negOptionsScreenOptionInfo, os->opt, NegScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void negOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    NEG_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, NegScreenOptionNum);

    free (os);
}

static Bool negOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    NegOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(NegOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[NegOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &negOptionsMetadata, negOptionsDisplayOptionInfo, od->opt, NegDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void negOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    NEG_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, NegDisplayOptionNum);

    free (od);
}

static Bool negOptionsInit (CompPlugin *p)
{
    NegOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (NegOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&negOptionsMetadata, "neg",negOptionsDisplayOptionInfo, NegDisplayOptionNum, negOptionsScreenOptionInfo, NegScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&negOptionsMetadata, "neg");
    if (negPluginVTable && negPluginVTable->init)
        return negPluginVTable->init (p);
    return TRUE;
}

static void negOptionsFini (CompPlugin *p)
{
    if (negPluginVTable && negPluginVTable->fini)
        negPluginVTable->fini (p);

    if (NegOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (NegOptionsDisplayPrivateIndex);

    compFiniMetadata (&negOptionsMetadata);
}

static CompBool negOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) negOptionsInitDisplay,
        (InitPluginObjectProc) negOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void negOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) negOptionsFiniDisplay,
        (FiniPluginObjectProc) negOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool negOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = negOptionsInitObject (p, o);
    if (negPluginVTable->initObject)
        rv &= negPluginVTable->initObject (p, o);
    return rv;
}

static void negOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (negPluginVTable->finiObject)
        negPluginVTable->finiObject (p, o);
    negOptionsFiniObject (p, o);
}

static CompOption * negOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) negOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) negOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool negOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) negOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) negOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
negOptionsGetMetadata (CompPlugin *plugin)
{
    return &negOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!negPluginVTable)
    {
        negPluginVTable = getCompPluginInfo ();
        memcpy(&negOptionsVTable, negPluginVTable, sizeof(CompPluginVTable));
        negOptionsVTable.getMetadata = negOptionsGetMetadata;
        negOptionsVTable.init = negOptionsInit;
        negOptionsVTable.fini = negOptionsFini;
        negOptionsVTable.initObject = negOptionsInitObjectWrapper;
        negOptionsVTable.finiObject = negOptionsFiniObjectWrapper;
        negOptionsVTable.getObjectOptions = negOptionsGetObjectOptions;
	negOptionsVTable.setObjectOption = negOptionsSetObjectOption;
	
    }
    return &negOptionsVTable;
}

