#include "setup.h"
#ifndef HAVE_LIBZ
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Fri Jan 25 23:44:31 2008
 */
#include "setup.h"
#ifdef USE_MANUAL
#include "hugehelp.h"
#include <stdio.h>
void hugehelp(void)
{
   fputs(
"                                  _   _ ____  _     \n"
"  Project                     ___| | | |  _ \\| |    \n"
"                             / __| | | | |_) | |    \n"
"                            | (__| |_| |  _ <| |___ \n"
"                             \\___|\\___/|_| \\_\\_____|\n"
"\n"
"NAME\n"
"       curl - transfer a URL\n"
"\n"
"SYNOPSIS\n"
"       curl [options] [URL...]\n"
"\n"
"DESCRIPTION\n"
"       curl  is  a tool to transfer data from or to a server, using one of the\n"
, stdout);
 fputs(
"       supported protocols (HTTP, HTTPS, FTP, FTPS,  SCP,  SFTP,  TFTP,  DICT,\n"
"       TELNET,  LDAP  or  FILE).  The command is designed to work without user\n"
"       interaction.\n"
"\n"
"       curl offers a busload of useful tricks like proxy support, user authen-\n"
"       tication,  ftp upload, HTTP post, SSL connections, cookies, file trans-\n"
"       fer resume and more. As you will see below, the number of features will\n"
"       make your head spin!\n"
"\n"
, stdout);
 fputs(
"       curl  is  powered  by  libcurl  for  all transfer-related features. See\n"
"       libcurl(3) for details.\n"
"\n"
"URL\n"
"       The URL syntax is protocol dependent. You'll find a  detailed  descrip-\n"
"       tion in RFC 3986.\n"
"\n"
"       You  can  specify  multiple  URLs or parts of URLs by writing part sets\n"
"       within braces as in:\n"
"\n"
"        http://site.{one,two,three}.com\n"
"\n"
"       or you can get sequences of alphanumeric series by using [] as in:\n"
"\n"
"        ftp://ftp.numericals.com/file[1-100].txt\n"
, stdout);
 fputs(
"        ftp://ftp.numericals.com/file[001-100].txt    (with leading zeros)\n"
"        ftp://ftp.letters.com/file[a-z].txt\n"
"\n"
"       No nesting of the sequences is supported at the moment, but you can use\n"
"       several ones next to each other:\n"
"\n"
"        http://any.org/archive[1996-1999]/vol[1-4]/part{a,b,c}.html\n"
"\n"
"       You  can  specify  any amount of URLs on the command line. They will be\n"
"       fetched in a sequential manner in the specified order.\n"
"\n"
, stdout);
 fputs(
"       Since curl 7.15.1 you can also specify step counter for the ranges,  so\n"
"       that you can get every Nth number or letter:\n"
"        http://www.numericals.com/file[1-100:10].txt\n"
"        http://www.letters.com/file[a-z:2].txt\n"
"\n"
"       If  you  specify  URL  without protocol:// prefix, curl will attempt to\n"
"       guess what protocol you might want. It will then default  to  HTTP  but\n"
"       try  other  protocols based on often-used host name prefixes. For exam-\n"
, stdout);
 fputs(
"       ple, for host names starting with \"ftp.\" curl will assume you  want  to\n"
"       speak FTP.\n"
"\n"
"       Curl will attempt to re-use connections for multiple file transfers, so\n"
"       that getting many files from the same server will not do multiple  con-\n"
"       nects / handshakes. This improves speed. Of course this is only done on\n"
"       files specified on a single command line and  cannot  be  used  between\n"
"       separate curl invokes.\n"
"\n"
"PROGRESS METER\n"
, stdout);
 fputs(
"       curl  normally  displays a progress meter during operations, indicating\n"
"       amount of transferred data, transfer speeds  and  estimated  time  left\n"
"       etc.\n"
"\n"
"       However,  since  curl  displays data to the terminal by default, if you\n"
"       invoke curl to do an operation and it is about to  write  data  to  the\n"
"       terminal,  it disables the progress meter as otherwise it would mess up\n"
"       the output mixing progress meter and response data.\n"
"\n"
, stdout);
 fputs(
"       If you want a progress meter for HTTP POST or PUT requests, you need to\n"
"       redirect  the  response  output to a file, using shell redirect (>), -o\n"
"       [file] or similar.\n"
"\n"
"       It is not the same case for FTP upload as that operation is  not  spit-\n"
"       ting out any response data to the terminal.\n"
"\n"
"       If you prefer a progress \"bar\" instead of the regular meter, -# is your\n"
"       friend.\n"
"OPTIONS\n"
"       -a/--append\n"
, stdout);
 fputs(
"              (FTP) When used in an FTP upload, this will tell curl to  append\n"
"              to  the  target  file  instead  of  overwriting  it. If the file\n"
"              doesn't exist, it will be created.\n"
"\n"
"              If this option is used twice, the second one will disable append\n"
"              mode again.\n"
"\n"
"       -A/--user-agent <agent string>\n"
"              (HTTP) Specify the User-Agent string to send to the HTTP server.\n"
, stdout);
 fputs(
"              Some  badly  done  CGIs  fail  if  this  field  isn't   set   to\n"
"              \"Mozilla/4.0\".  To  encode  blanks  in  the string, surround the\n"
"              string with single quote marks. This can also be  set  with  the\n"
"              -H/--header option of course.\n"
"\n"
"              If  this  option is set more than once, the last one will be the\n"
"              one that's used.\n"
"\n"
"       --anyauth\n"
"              (HTTP) Tells curl to figure out authentication method by itself,\n"
, stdout);
 fputs(
"              and  use the most secure one the remote site claims it supports.\n"
"              This is done by first doing a request and checking the response-\n"
"              headers,  thus  possibly  inducing  an extra network round-trip.\n"
"              This is  used  instead  of  setting  a  specific  authentication\n"
"              method,  which  you  can  do with --basic, --digest, --ntlm, and\n"
"              --negotiate.\n"
"\n"
, stdout);
 fputs(
"              Note that using --anyauth is not recommended if you  do  uploads\n"
"              from  stdin, since it may require data to be sent twice and then\n"
"              the client must be able to rewind. If the need should arise when\n"
"              uploading from stdin, the upload operation will fail.\n"
"\n"
"              If  this option is used several times, the following occurrences\n"
"              make no difference.\n"
"\n"
"       -b/--cookie <name=data>\n"
, stdout);
 fputs(
"              (HTTP) Pass the data to the HTTP server as a cookie. It is  sup-\n"
"              posedly  the data previously received from the server in a \"Set-\n"
"              Cookie:\" line.  The data should be in the format  \"NAME1=VALUE1;\n"
"              NAME2=VALUE2\".\n"
"\n"
"              If  no  '=' letter is used in the line, it is treated as a file-\n"
"              name to use to read previously stored cookie lines  from,  which\n"
, stdout);
 fputs(
"              should  be used in this session if they match. Using this method\n"
"              also activates the \"cookie parser\" which will make  curl  record\n"
"              incoming cookies too, which may be handy if you're using this in\n"
"              combination with the -L/--location option. The  file  format  of\n"
"              the  file  to  read cookies from should be plain HTTP headers or\n"
"              the Netscape/Mozilla cookie file format.\n"
"\n"
, stdout);
 fputs(
"              NOTE that the file specified with -b/--cookie is  only  used  as\n"
"              input.  No cookies will be stored in the file. To store cookies,\n"
"              use the -c/--cookie-jar option or you could even save  the  HTTP\n"
"              headers to a file using -D/--dump-header!\n"
"\n"
"              If  this  option is set more than once, the last one will be the\n"
"              one that's used.\n"
"\n"
"       -B/--use-ascii\n"
, stdout);
 fputs(
"              Enable ASCII transfer when using FTP or LDAP. For FTP, this  can\n"
"              also  be enforced by using an URL that ends with \";type=A\". This\n"
"              option causes data sent to stdout to be in text mode  for  win32\n"
"              systems.\n"
"\n"
"              If  this option is used twice, the second one will disable ASCII\n"
"              usage.\n"
"\n"
"       --basic\n"
"              (HTTP) Tells curl to use HTTP Basic authentication. This is  the\n"
, stdout);
 fputs(
"              default  and this option is usually pointless, unless you use it\n"
"              to override a  previously  set  option  that  sets  a  different\n"
"              authentication  method  (such  as --ntlm, --digest and --negoti-\n"
"              ate).\n"
"\n"
"              If this option is used several times, the following  occurrences\n"
"              make no difference.\n"
"\n"
"       --ciphers <list of ciphers>\n"
"              (SSL) Specifies which ciphers to use in the connection. The list\n"
, stdout);
 fputs(
"              of ciphers must be using valid ciphers. Read up  on  SSL  cipher\n"
"              list           details           on           this          URL:\n"
"              http://www.openssl.org/docs/apps/ciphers.html\n"
"\n"
"              NSS ciphers are done differently than OpenSSL  and  GnuTLS.  The\n"
"              full  list of NSS ciphers is in the NSSCipherSuite entry at this\n"
"              URL: http://directory.fedora.redhat.com/docs/mod_nss.html#Direc-\n"
"              tives\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will override\n"
"              the others.\n"
"\n"
"       --compressed\n"
"              (HTTP) Request a compressed response using one of the algorithms\n"
"              libcurl supports, and return the uncompressed document.  If this\n"
"              option is used and the server  sends  an  unsupported  encoding,\n"
"              Curl will report an error.\n"
"\n"
"              If  this option is used several times, each occurrence will tog-\n"
, stdout);
 fputs(
"              gle it on/off.\n"
"\n"
"       --connect-timeout <seconds>\n"
"              Maximum time in seconds that you allow  the  connection  to  the\n"
"              server  to  take.   This  only limits the connection phase, once\n"
"              curl has connected this option is of no more use. See  also  the\n"
"              -m/--max-time option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -c/--cookie-jar <file name>\n"
, stdout);
 fputs(
"              Specify to which file you want curl to write all cookies after a\n"
"              completed  operation.  Curl  writes  all cookies previously read\n"
"              from a specified file as  well  as  all  cookies  received  from\n"
"              remote server(s). If no cookies are known, no file will be writ-\n"
"              ten. The file will be written using  the  Netscape  cookie  file\n"
"              format.  If  you  set  the  file name to a single dash, \"-\", the\n"
, stdout);
 fputs(
"              cookies will be written to stdout.\n"
"\n"
"              NOTE If the cookie jar can't be created or written to, the whole\n"
"              curl operation won't fail or even report an error clearly. Using\n"
"              -v will get a warning displayed, but that is  the  only  visible\n"
"              feedback you get about this possibly lethal situation.\n"
"\n"
"              If  this  option  is used several times, the last specified file\n"
"              name will be used.\n"
"\n"
, stdout);
 fputs(
"       -C/--continue-at <offset>\n"
"              Continue/Resume a previous file transfer at  the  given  offset.\n"
"              The  given  offset  is  the  exact  number of bytes that will be\n"
"              skipped counted from the beginning of the source file before  it\n"
"              is  transferred  to  the destination.  If used with uploads, the\n"
"              ftp server command SIZE will not be used by curl.\n"
"\n"
"              Use \"-C -\" to tell curl to automatically find out  where/how  to\n"
, stdout);
 fputs(
"              resume  the  transfer. It then uses the given output/input files\n"
"              to figure that out.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --create-dirs\n"
"              When  used  in  conjunction with the -o option, curl will create\n"
"              the necessary local directory hierarchy as needed.  This  option\n"
"              creates  the dirs mentioned with the -o option, nothing else. If\n"
, stdout);
 fputs(
"              the -o file name uses no dir or if the dirs it mentions  already\n"
"              exist, no dir will be created.\n"
"\n"
"              To  create remote directories when using FTP or SFTP, try --ftp-\n"
"              create-dirs.\n"
"\n"
"       --crlf (FTP) Convert LF to CRLF in upload. Useful for MVS (OS/390).\n"
"\n"
"              If this option is used several times, the following  occurrences\n"
"              make no difference.\n"
"\n"
"       -d/--data <data>\n"
, stdout);
 fputs(
"              (HTTP)  Sends  the  specified data in a POST request to the HTTP\n"
"              server, in the same way that a browser  does  when  a  user  has\n"
"              filled  in an HTML form and presses the submit button. This will\n"
"              cause curl to pass the data to the server using the content-type\n"
"              application/x-www-form-urlencoded.  Compare to -F/--form.\n"
"\n"
"              -d/--data  is  the  same  as  --data-ascii.  To post data purely\n"
, stdout);
 fputs(
"              binary, you should instead use the --data-binary option. To  URL\n"
"              encode the value of a form field you may use --data-urlencode.\n"
"\n"
"              If  any of these options is used more than once on the same com-\n"
"              mand line, the data pieces specified  will  be  merged  together\n"
"              with  a  separating  &-letter.  Thus,  using  '-d name=daniel -d\n"
"              skill=lousy'  would  generate  a  post  chunk  that  looks  like\n"
, stdout);
 fputs(
"              'name=daniel&skill=lousy'.\n"
"\n"
"              If  you  start  the data with the letter @, the rest should be a\n"
"              file name to read the data from, or - if you want curl  to  read\n"
"              the  data  from stdin.  The contents of the file must already be\n"
"              url-encoded. Multiple files can also be specified. Posting  data\n"
"              from  a file named 'foobar' would thus be done with --data @foo-\n"
"              bar.\n"
"\n"
"       --data-binary <data>\n"
, stdout);
 fputs(
"              (HTTP) This posts data exactly as specified with no  extra  pro-\n"
"              cessing whatsoever.\n"
"\n"
"              If  you  start  the data with the letter @, the rest should be a\n"
"              filename.  Data is posted in a similar  manner  as  --data-ascii\n"
"              does,  except  that  newlines  are preserved and conversions are\n"
"              never done.\n"
"\n"
"              If this option is used several times,  the  ones  following  the\n"
, stdout);
 fputs(
"              first will append data. As described in -d/--data.\n"
"\n"
"       --data-urlencode <data>\n"
"              (HTTP) This posts data, similar to the other --data options with\n"
"              the exception that this performs URL encoding. (Added in 7.18.0)\n"
"              To  be  CGI  compliant, the <data> part should begin with a name\n"
"              followed by a separator and a content specification. The  <data>\n"
"              part can be passed to curl using one of the following syntaxes:\n"
"\n"
, stdout);
 fputs(
"              content\n"
"                     This  will make curl URL encode the content and pass that\n"
"                     on. Just be careful so that the content  doesn't  contain\n"
"                     any  =  or  @  letters, as that will then make the syntax\n"
"                     match one of the other cases below!\n"
"\n"
"              =content\n"
"                     This will make curl URL encode the content and pass  that\n"
"                     on. The preceding = letter is not included in the data.\n"
"\n"
, stdout);
 fputs(
"              name=content\n"
"                     This  will make curl URL encode the content part and pass\n"
"                     that on. Note that the name part is expected  to  be  URL\n"
"                     encoded already.\n"
"\n"
"              @filename\n"
"                     This  will  make  curl  load  data  from  the  given file\n"
"                     (including any newlines), URL encode that data  and  pass\n"
"                     it on in the POST.\n"
"\n"
"              name@filename\n"
, stdout);
 fputs(
"                     This  will  make  curl  load  data  from  the  given file\n"
"                     (including any newlines), URL encode that data  and  pass\n"
"                     it  on  in  the  POST.  The  name part gets an equal sign\n"
"                     appended, resulting in name=urlencoded-file-content. Note\n"
"                     that the name is expected to be URL encoded already.\n"
"\n"
"       --digest\n"
"              (HTTP) Enables HTTP Digest authentication. This is a authentica-\n"
, stdout);
 fputs(
"              tion that prevents the password from being sent over the wire in\n"
"              clear  text.  Use  this in combination with the normal -u/--user\n"
"              option to set user name and password. See also --ntlm, --negoti-\n"
"              ate and --anyauth for related options.\n"
"\n"
"              If  this option is used several times, the following occurrences\n"
"              make no difference.\n"
"\n"
"       --disable-eprt\n"
, stdout);
 fputs(
"              (FTP) Tell curl to disable the use of the EPRT and LPRT commands\n"
"              when doing active FTP transfers. Curl will normally always first\n"
"              attempt to use EPRT, then LPRT before using PORT, but with  this\n"
"              option,  it  will  use PORT right away. EPRT and LPRT are exten-\n"
"              sions to the original FTP protocol, may not work on all  servers\n"
"              but  enable  more  functionality in a better way than the tradi-\n"
, stdout);
 fputs(
"              tional PORT command.\n"
"\n"
"              If this option is used several times, each occurrence will  tog-\n"
"              gle this on/off.\n"
"\n"
"       --disable-epsv\n"
"              (FTP)  Tell  curl  to  disable  the use of the EPSV command when\n"
"              doing passive FTP transfers. Curl  will  normally  always  first\n"
"              attempt  to  use EPSV before PASV, but with this option, it will\n"
"              not try using EPSV.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, each occurrence will  tog-\n"
"              gle this on/off.\n"
"\n"
"       -D/--dump-header <file>\n"
"              Write the protocol headers to the specified file.\n"
"\n"
"              This  option  is handy to use when you want to store the headers\n"
"              that a HTTP site sends to you. Cookies from  the  headers  could\n"
"              then  be  read  in a second curl invoke by using the -b/--cookie\n"
, stdout);
 fputs(
"              option! The -c/--cookie-jar option is however a  better  way  to\n"
"              store cookies.\n"
"\n"
"              When  used  on FTP, the ftp server response lines are considered\n"
"              being \"headers\" and thus are saved there.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -e/--referer <URL>\n"
"              (HTTP)  Sends the \"Referer Page\" information to the HTTP server.\n"
, stdout);
 fputs(
"              This can also be set with the -H/--header flag of course.   When\n"
"              used  with -L/--location you can append \";auto\" to the --referer\n"
"              URL to make curl automatically set the previous URL when it fol-\n"
"              lows  a  Location: header. The \";auto\" string can be used alone,\n"
"              even if you don't set an initial --referer.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --engine <name>\n"
, stdout);
 fputs(
"              Select  the  OpenSSL crypto engine to use for cipher operations.\n"
"              Use --engine list  to  print  a  list  of  build-time  supported\n"
"              engines.  Note  that  not  all  (or  none) of the engines may be\n"
"              available at run-time.\n"
"\n"
"       --environment\n"
"              (RISC OS ONLY) Sets a range of environment variables, using  the\n"
"              names the -w option supports, to easier allow extraction of use-\n"
, stdout);
 fputs(
"              ful information after having run curl.\n"
"\n"
"              If this option is used several times, each occurrence will  tog-\n"
"              gle this on/off.\n"
"\n"
"       --egd-file <file>\n"
"              (SSL)  Specify  the  path  name  to the Entropy Gathering Daemon\n"
"              socket. The socket is used to seed the  random  engine  for  SSL\n"
"              connections. See also the --random-file option.\n"
"\n"
"       -E/--cert <certificate[:password]>\n"
, stdout);
 fputs(
"              (SSL) Tells curl to use the specified certificate file when get-\n"
"              ting a file with HTTPS or FTPS. The certificate must be  in  PEM\n"
"              format.   If  the  optional password isn't specified, it will be\n"
"              queried for on the terminal. Note that  this  option  assumes  a\n"
"              \"certificate\"  file that is the private key and the private cer-\n"
"              tificate concatenated! See --cert  and  --key  to  specify  them\n"
, stdout);
 fputs(
"              independently.\n"
"\n"
"              If  curl  is  built against the NSS SSL library then this option\n"
"              tells curl the nickname of the certificate to use within the NSS\n"
"              database  defined  by  the  environment  variable SSL_DIR (or by\n"
"              default /etc/pki/nssdb). If the NSS  PEM  PKCS#11  module  (lib-\n"
"              nsspem.so) is available then PEM files may be loaded.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"       --cert-type <type>\n"
"              (SSL) Tells curl what certificate type the provided  certificate\n"
"              is in. PEM, DER and ENG are recognized types.  If not specified,\n"
"              PEM is assumed.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --cacert <CA certificate>\n"
"              (SSL) Tells curl to use the specified certificate file to verify\n"
"              the peer. The file may contain  multiple  CA  certificates.  The\n"
, stdout);
 fputs(
"              certificate(s) must be in PEM format.\n"
"\n"
"              curl  recognizes the environment variable named 'CURL_CA_BUNDLE'\n"
"              if that is set, and uses the given path as a path to a  CA  cert\n"
"              bundle. This option overrides that variable.\n"
"\n"
"              The  windows  version  of  curl will automatically look for a CA\n"
"              certs file named 'curl-ca-bundle.crt', either in the same direc-\n"
, stdout);
 fputs(
"              tory as curl.exe, or in the Current Working Directory, or in any\n"
"              folder along your PATH.\n"
"\n"
"              If curl is built against the NSS SSL library  then  this  option\n"
"              tells  curl the nickname of the CA certificate to use within the\n"
"              NSS database defined by the environment variable SSL_DIR (or  by\n"
"              default  /etc/pki/nssdb).   If  the NSS PEM PKCS#11 module (lib-\n"
, stdout);
 fputs(
"              nsspem.so) is available then PEM files may be loaded.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --capath <CA certificate directory>\n"
"              (SSL)  Tells  curl to use the specified certificate directory to\n"
"              verify the peer. The certificates must be in PEM format, and the\n"
"              directory  must  have  been processed using the c_rehash utility\n"
, stdout);
 fputs(
"              supplied with openssl. Using --capath can  allow  curl  to  make\n"
"              SSL-connections much more efficiently than using --cacert if the\n"
"              --cacert file contains many CA certificates.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -f/--fail\n"
"              (HTTP)  Fail  silently (no output at all) on server errors. This\n"
"              is mostly done like this to better enable scripts etc to  better\n"
, stdout);
 fputs(
"              deal  with  failed  attempts. In normal cases when a HTTP server\n"
"              fails to deliver a document, it returns an HTML document stating\n"
"              so  (which  often  also  describes why and more). This flag will\n"
"              prevent curl from outputting that and return error 22.\n"
"\n"
"              This method is not fail-safe and there are occasions where  non-\n"
"              successful  response  codes  will  slip through, especially when\n"
, stdout);
 fputs(
"              authentication is involved (response codes 401 and 407).\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
"              silent failure.\n"
"\n"
"       --ftp-account [data]\n"
"              (FTP) When an FTP server asks for \"account data\" after user name\n"
"              and password has been provided, this data is sent off using  the\n"
"              ACCT command. (Added in 7.13.0)\n"
"\n"
"              If  this option is used twice, the second will override the pre-\n"
, stdout);
 fputs(
"              vious use.\n"
"\n"
"       --ftp-create-dirs\n"
"              (FTP) When an FTP or SFTP URL/operation uses a path that doesn't\n"
"              currently  exist on the server, the standard behavior of curl is\n"
"              to fail. Using this option, curl will instead attempt to  create\n"
"              missing directories.\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              directory creation.\n"
"\n"
"       --ftp-method [method]\n"
, stdout);
 fputs(
"              (FTP) Control what method curl should use to reach a file  on  a\n"
"              FTP(S)  server. The method argument should be one of the follow-\n"
"              ing alternatives:\n"
"\n"
"              multicwd\n"
"                     curl does a single CWD operation for each  path  part  in\n"
"                     the  given URL. For deep hierarchies this means very many\n"
"                     commands. This is how RFC1738 says  it  should  be  done.\n"
, stdout);
 fputs(
"                     This is the default but the slowest behavior.\n"
"\n"
"              nocwd  curl  does  no  CWD at all. curl will do SIZE, RETR, STOR\n"
"                     etc and give a full path to the server for all these com-\n"
"                     mands. This is the fastest behavior.\n"
"\n"
"              singlecwd\n"
"                     curl does one CWD with the full target directory and then\n"
"                     operates on the file \"normally\"  (like  in  the  multicwd\n"
, stdout);
 fputs(
"                     case).  This  is  somewhat  more standards compliant than\n"
"                     'nocwd' but without the full penalty of 'multicwd'.\n"
"\n"
"       --ftp-pasv\n"
"              (FTP) Use PASV when transferring. PASV is the  internal  default\n"
"              behavior, but using this option can be used to override a previ-\n"
"              ous --ftp-port option. (Added in 7.11.0)\n"
"\n"
"              If this option is used several times, the following  occurrences\n"
"              make no difference.\n"
"\n"
, stdout);
 fputs(
"       --ftp-alternative-to-user <command>\n"
"              (FTP)  If  authenticating with the USER and PASS commands fails,\n"
"              send this  command.   When  connecting  to  Tumbleweed's  Secure\n"
"              Transport  server  over  FTPS  using a client certificate, using\n"
"              \"SITE AUTH\" will tell the server to retrieve the  username  from\n"
"              the certificate. (Added in 7.15.5)\n"
"\n"
"       --ftp-skip-pasv-ip\n"
, stdout);
 fputs(
"              (FTP) Tell curl to not use the IP address the server suggests in\n"
"              its response to curl's PASV command when curl connects the  data\n"
"              connection.  Instead  curl  will  re-use  the same IP address it\n"
"              already uses for the control connection. (Added in 7.14.2)\n"
"\n"
"              This option has no effect if PORT, EPRT or EPSV is used  instead\n"
"              of PASV.\n"
"\n"
"              If  this  option  is  used  twice, the second will again use the\n"
, stdout);
 fputs(
"              server's suggested address.\n"
"\n"
"       --ftp-ssl\n"
"              (FTP) Try to use SSL/TLS for the FTP connection.  Reverts  to  a\n"
"              non-secure  connection  if  the  server doesn't support SSL/TLS.\n"
"              See also --ftp-ssl-control and --ftp-ssl-reqd for different lev-\n"
"              els of encryption required. (Added in 7.11.0)\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              this.\n"
"\n"
"       --ftp-ssl-control\n"
, stdout);
 fputs(
"              (FTP) Require SSL/TLS for the ftp  login,  clear  for  transfer.\n"
"              Allows  secure  authentication, but non-encrypted data transfers\n"
"              for efficiency.  Fails the transfer if the server  doesn't  sup-\n"
"              port SSL/TLS.  (Added in 7.16.0)\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              this.\n"
"\n"
"       --ftp-ssl-reqd\n"
"              (FTP) Require SSL/TLS for the FTP  connection.   Terminates  the\n"
, stdout);
 fputs(
"              connection  if  the  server  doesn't support SSL/TLS.  (Added in\n"
"              7.15.5)\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
"              this.\n"
"\n"
"       --ftp-ssl-ccc\n"
"              (FTP)  Use  CCC  (Clear  Command Channel) Shuts down the SSL/TLS\n"
"              layer after authenticating. The rest of the control channel com-\n"
"              munication  will be unencrypted. This allows NAT routers to fol-\n"
, stdout);
 fputs(
"              low the FTP transaction. The default mode is passive. See --ftp-\n"
"              ssl-ccc-mode for other modes.  (Added in 7.16.1)\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              this.\n"
"\n"
"       --ftp-ssl-ccc-mode [active/passive]\n"
"              (FTP) Use CCC (Clear Command Channel) Sets  the  CCC  mode.  The\n"
"              passive  mode  will  not initiate the shutdown, but instead wait\n"
, stdout);
 fputs(
"              for the server to do it, and will not reply to the shutdown from\n"
"              the server. The active mode initiates the shutdown and waits for\n"
"              a reply from the server.  (Added in 7.16.2)\n"
"\n"
"       -F/--form <name=content>\n"
"              (HTTP) This lets curl emulate a filled in form in which  a  user\n"
"              has  pressed  the  submit  button. This causes curl to POST data\n"
"              using the Content-Type multipart/form-data according to RFC1867.\n"
, stdout);
 fputs(
"              This  enables  uploading of binary files etc. To force the 'con-\n"
"              tent' part to be a file, prefix the file name with an @ sign. To\n"
"              just get the content part from a file, prefix the file name with\n"
"              the letter <. The difference between @ and  <  is  then  that  @\n"
"              makes  a  file  get attached in the post as a file upload, while\n"
"              the < makes a text field and just get the contents for that text\n"
, stdout);
 fputs(
"              field from a file.\n"
"\n"
"              Example,  to send your password file to the server, where 'pass-\n"
"              word' is the name of the form-field to which /etc/passwd will be\n"
"              the input:\n"
"\n"
"              curl -F password=@/etc/passwd www.mypasswords.com\n"
"\n"
"              To  read  the file's content from stdin instead of a file, use -\n"
"              where the file name should've been. This goes for both @  and  <\n"
"              constructs.\n"
"\n"
, stdout);
 fputs(
"              You  can  also  tell  curl  what  Content-Type  to  use by using\n"
"              'type=', in a manner similar to:\n"
"\n"
"              curl -F \"web=@index.html;type=text/html\" url.com\n"
"\n"
"              or\n"
"\n"
"              curl -F \"name=daniel;type=text/foo\" url.com\n"
"\n"
"              You can also explicitly change the name field of an file  upload\n"
"              part by setting filename=, like this:\n"
"\n"
"              curl -F \"file=@localfile;filename=nameinpost\" url.com\n"
"\n"
, stdout);
 fputs(
"              See further examples and details in the MANUAL.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"       --form-string <name=string>\n"
"              (HTTP)  Similar  to  --form except that the value string for the\n"
"              named parameter is used literally. Leading '@' and  '<'  charac-\n"
"              ters, and the ';type=' string in the value have no special mean-\n"
"              ing. Use this in preference to --form if there's any possibility\n"
, stdout);
 fputs(
"              that  the  string  value may accidentally trigger the '@' or '<'\n"
"              features of --form.\n"
"\n"
"       -g/--globoff\n"
"              This option switches off the \"URL globbing parser\". When you set\n"
"              this  option, you can specify URLs that contain the letters {}[]\n"
"              without having them being interpreted by curl itself. Note  that\n"
"              these  letters are not normal legal URL contents but they should\n"
, stdout);
 fputs(
"              be encoded according to the URI standard.\n"
"\n"
"       -G/--get\n"
"              When used,  this  option  will  make  all  data  specified  with\n"
"              -d/--data  or  --data-binary  to  be  used in a HTTP GET request\n"
"              instead of the POST request that otherwise would  be  used.  The\n"
"              data will be appended to the URL with a '?'  separator.\n"
"\n"
"              If  used  in  combination with -I, the POST data will instead be\n"
, stdout);
 fputs(
"              appended to the URL with a HEAD request.\n"
"\n"
"              If this option is used several times, the following  occurrences\n"
"              make no difference.\n"
"\n"
"       -h/--help\n"
"              Usage help.\n"
"\n"
"       -H/--header <header>\n"
"              (HTTP)  Extra  header  to  use  when getting a web page. You may\n"
"              specify any number of extra headers. Note that if you should add\n"
"              a  custom  header  that has the same name as one of the internal\n"
, stdout);
 fputs(
"              ones curl would use, your externally set  header  will  be  used\n"
"              instead of the internal one. This allows you to make even trick-\n"
"              ier stuff than curl would normally do. You  should  not  replace\n"
"              internally  set  headers  without  knowing  perfectly  well what\n"
"              you're doing. Remove an internal header by giving a  replacement\n"
"              without  content  on  the  right  side  of  the colon, as in: -H\n"
"              \"Host:\".\n"
"\n"
, stdout);
 fputs(
"              curl will make sure that each header you  add/replace  get  sent\n"
"              with the proper end of line marker, you should thus not add that\n"
"              as a part of the header content: do not add newlines or carriage\n"
"              returns they will only mess things up for you.\n"
"\n"
"              See also the -A/--user-agent and -e/--referer options.\n"
"\n"
"              This  option  can  be  used multiple times to add/replace/remove\n"
"              multiple headers.\n"
"\n"
, stdout);
 fputs(
"       --hostpubmd5\n"
"              Pass a string  containing  32  hexadecimal  digits.  The  string\n"
"              should  be  the 128 bit MD5 checksum of the remote host's public\n"
"              key, curl will refuse the connection with the  host  unless  the\n"
"              md5sums  match.  This option is only for SCP and SFTP transfers.\n"
"              (Added in 7.17.1)\n"
"\n"
"       --ignore-content-length\n"
"              (HTTP) Ignore the Content-Length header.  This  is  particularly\n"
, stdout);
 fputs(
"              useful  for servers running Apache 1.x, which will report incor-\n"
"              rect Content-Length for files larger than 2 gigabytes.\n"
"\n"
"       -i/--include\n"
"              (HTTP) Include the HTTP-header in the  output.  The  HTTP-header\n"
"              includes  things  like  server-name, date of the document, HTTP-\n"
"              version and more...\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
"              header include.\n"
"\n"
"       --interface <name>\n"
, stdout);
 fputs(
"              Perform  an operation using a specified interface. You can enter\n"
"              interface name, IP address or host name. An example  could  look\n"
"              like:\n"
"\n"
"               curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -I/--head\n"
"              (HTTP/FTP/FILE) Fetch the HTTP-header only! HTTP-servers feature\n"
"              the  command  HEAD which this uses to get nothing but the header\n"
, stdout);
 fputs(
"              of a document. When used on a FTP or FILE  file,  curl  displays\n"
"              the file size and last modification time only.\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              header only.\n"
"\n"
"       -j/--junk-session-cookies\n"
"              (HTTP) When curl is told to read cookies from a given file, this\n"
"              option  will  make  it  discard all \"session cookies\". This will\n"
, stdout);
 fputs(
"              basically have the same effect as if a new session  is  started.\n"
"              Typical  browsers  always  discard  session cookies when they're\n"
"              closed down.\n"
"\n"
"              If this option is used several times, each occurrence will  tog-\n"
"              gle this on/off.\n"
"\n"
"       -k/--insecure\n"
"              (SSL)  This  option explicitly allows curl to perform \"insecure\"\n"
"              SSL connections and transfers. All SSL connections are attempted\n"
, stdout);
 fputs(
"              to  be  made secure by using the CA certificate bundle installed\n"
"              by default. This makes all connections considered \"insecure\"  to\n"
"              fail unless -k/--insecure is used.\n"
"\n"
"              See     this    online    resource    for    further    details:\n"
"              http://curl.haxx.se/docs/sslcerts.html\n"
"\n"
"              If this option is used twice, the second time will again disable\n"
"              it.\n"
"\n"
"       --keepalive-time <seconds>\n"
, stdout);
 fputs(
"              This  option  sets  the  time  a connection needs to remain idle\n"
"              before sending keepalive probes and the time between  individual\n"
"              keepalive probes. It is currently effective on operating systems\n"
"              offering  the  TCP_KEEPIDLE  and  TCP_KEEPINTVL  socket  options\n"
"              (meaning  Linux, recent AIX, HP-UX and more). This option has no\n"
"              effect if --no-keepalive is used. (Added in 7.18.0)\n"
"\n"
, stdout);
 fputs(
"              If this option is used multiple times, the last occurrence  sets\n"
"              the amount.\n"
"       --key <key>\n"
"              (SSL/SSH) Private key file name. Allows you to provide your pri-\n"
"              vate key in this separate file.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --key-type <type>\n"
"              (SSL)  Private key file type. Specify which type your --key pro-\n"
, stdout);
 fputs(
"              vided private key is. DER, PEM and ENG  are  supported.  If  not\n"
"              specified, PEM is assumed.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --krb <level>\n"
"              (FTP) Enable Kerberos authentication and use. The level must  be\n"
"              entered  and should be one of 'clear', 'safe', 'confidential' or\n"
"              'private'. Should you use a level that  is  not  one  of  these,\n"
, stdout);
 fputs(
"              'private' will instead be used.\n"
"\n"
"              This  option  requires that the library was built with kerberos4\n"
"              or GSSAPI (GSS-Negotiate) support. This is not very common.  Use\n"
"              -V/--version to see if your curl supports it.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -K/--config <config file>\n"
"              Specify which config file to read curl arguments from. The  con-\n"
, stdout);
 fputs(
"              fig  file  is a text file in which command line arguments can be\n"
"              written which then will be used as if they were written  on  the\n"
"              actual command line. Options and their parameters must be speci-\n"
"              fied on the same config file line,  separated  by  white  space,\n"
"              colon,  the equals sign or any combination thereof (however, the\n"
"              preferred separator is the equals sign). If the parameter is  to\n"
, stdout);
 fputs(
"              contain  white  spaces,  the  parameter  must be enclosed within\n"
"              quotes. Within double quotes, the following escape sequences are\n"
"              available:  \\\\,  \\\", \\t, \\n, \\r and \\v. A backlash preceding any\n"
"              other letter is  ignored. If the first column of a  config  line\n"
"              is  a  '#'  character, the rest of the line will be treated as a\n"
"              comment. Only write one option per physical line in  the  config\n"
"              file.\n"
"\n"
, stdout);
 fputs(
"              Specify the filename to -K/--config as '-' to make curl read the\n"
"              file from stdin.\n"
"\n"
"              Note that to be able to specify a URL in the  config  file,  you\n"
"              need  to  specify  it  using the --url option, and not by simply\n"
"              writing the URL on its own line. So, it could  look  similar  to\n"
"              this:\n"
"\n"
"              url = \"http://curl.haxx.se/docs/\"\n"
"\n"
"              Long  option  names  can  optionally be given in the config file\n"
, stdout);
 fputs(
"              without the initial double dashes.\n"
"\n"
"              When curl is invoked, it always (unless -q is used) checks for a\n"
"              default  config  file  and  uses it if found. The default config\n"
"              file is checked for in the following places in this order:\n"
"\n"
"              1) curl tries to find the \"home dir\": It first  checks  for  the\n"
"              CURL_HOME and then the HOME environment variables. Failing that,\n"
, stdout);
 fputs(
"              it uses getpwuid() on unix-like systems (which returns the  home\n"
"              dir  given the current user in your system). On Windows, it then\n"
"              checks for the APPDATA variable, or as a last resort the '%USER-\n"
"              PROFILE%0lication Data'.\n"
"\n"
"              2)  On  windows, if there is no _curlrc file in the home dir, it\n"
"              checks for one in the same dir the executable curl is placed. On\n"
, stdout);
 fputs(
"              unix-like  systems,  it will simply try to load .curlrc from the\n"
"              determined home dir.\n"
"\n"
"              # --- Example file ---\n"
"              # this is a comment\n"
"              url = \"curl.haxx.se\"\n"
"              output = \"curlhere.html\"\n"
"              user-agent = \"superagent/1.0\"\n"
"\n"
"              # and fetch another URL too\n"
"              url = \"curl.haxx.se/docs/manpage.html\"\n"
"              -O\n"
"              referer = \"http://nowhereatall.com/\"\n"
, stdout);
 fputs(
"              # --- End of example file ---\n"
"\n"
"              This option can be used multiple times to load  multiple  config\n"
"              files.\n"
"\n"
"       --libcurl <file>\n"
"              Append  this  option  to any ordinary curl command line, and you\n"
"              will get a libcurl-using source code written to  the  file  that\n"
"              does  the  equivalent operation of what your command line opera-\n"
"              tion does!\n"
"\n"
, stdout);
 fputs(
"              NOTE: this does not properly support -F and the sending of  mul-\n"
"              tipart  formposts,  so in those cases the output program will be\n"
"              missing necessary calls to curl_formadd(3), and possibly more.\n"
"\n"
"              If this option is used several times, the last given  file  name\n"
"              will be used. (Added in 7.16.1)\n"
"\n"
"       --limit-rate <speed>\n"
"              Specify  the  maximum  transfer  rate you want curl to use. This\n"
, stdout);
 fputs(
"              feature is useful if you have a limited pipe and you'd like your\n"
"              transfer not use your entire bandwidth.\n"
"\n"
"              The  given speed is measured in bytes/second, unless a suffix is\n"
"              appended.  Appending 'k' or 'K' will count the number  as  kilo-\n"
"              bytes,  'm'  or  M' makes it megabytes while 'g' or 'G' makes it\n"
"              gigabytes. Examples: 200K, 3m and 1G.\n"
"\n"
, stdout);
 fputs(
"              The given rate is the average speed, counted during  the  entire\n"
"              transfer. It means that curl might use higher transfer speeds in\n"
"              short bursts, but over time it uses no more than the given rate.\n"
"              If  you  are also using the -Y/--speed-limit option, that option\n"
"              will  take  precedence  and  might  cripple  the   rate-limiting\n"
"              slightly, to help keeping the speed-limit logic working.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -l/--list-only\n"
"              (FTP) When listing an FTP directory, this switch forces a  name-\n"
"              only  view.   Especially useful if you want to machine-parse the\n"
"              contents of an FTP directory since  the  normal  directory  view\n"
"              doesn't use a standard look or format.\n"
"\n"
"              This  option  causes  an  FTP NLST command to be sent.  Some FTP\n"
, stdout);
 fputs(
"              servers list only files in their response to NLST; they  do  not\n"
"              include subdirectories and symbolic links.\n"
"\n"
"              If this option is used twice, the second will again disable list\n"
"              only.\n"
"\n"
"       --local-port <num>[-num]\n"
"              Set a preferred number or range of local port numbers to use for\n"
"              the connection(s).  Note that port numbers by nature is a scarce\n"
, stdout);
 fputs(
"              resource that will be busy at times so  setting  this  range  to\n"
"              something  too  narrow  might cause unnecessary connection setup\n"
"              failures. (Added in 7.15.2)\n"
"\n"
"       -L/--location\n"
"              (HTTP/HTTPS) If the server reports that the requested  page  has\n"
"              moved to a different location (indicated with a Location: header\n"
"              and a 3XX response code) this option will  make  curl  redo  the\n"
, stdout);
 fputs(
"              request  on the new place. If used together with -i/--include or\n"
"              -I/--head, headers from all requested pages will be shown.  When\n"
"              authentication  is  used, curl only sends its credentials to the\n"
"              initial host. If a redirect takes curl to a different  host,  it\n"
"              won't  be  able to intercept the user+password. See also --loca-\n"
"              tion-trusted on how to change this. You can limit the amount  of\n"
, stdout);
 fputs(
"              redirects to follow by using the --max-redirs option.\n"
"\n"
"              When  curl follows a redirect and the request is not a plain GET\n"
"              (for example POST or PUT), it will do the following request with\n"
"              a GET if the HTTP response was 301, 302, or 303. If the response\n"
"              code was any other 3xx code, curl  will  re-send  the  following\n"
"              request using the same unmodified method.\n"
"\n"
, stdout);
 fputs(
"              If  this  option  is  used  twice, the second will again disable\n"
"              location following.\n"
"\n"
"       --location-trusted\n"
"              (HTTP/HTTPS) Like -L/--location, but will allow sending the name\n"
"              +  password to all hosts that the site may redirect to. This may\n"
"              or may not introduce a security breach if the site redirects you\n"
"              do  a  site to which you'll send your authentication info (which\n"
, stdout);
 fputs(
"              is plaintext in the case of HTTP Basic authentication).\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
"              location following.\n"
"\n"
"       --max-filesize <bytes>\n"
"              Specify  the  maximum  size (in bytes) of a file to download. If\n"
"              the file requested is larger than this value, the transfer  will\n"
"              not start and curl will return with exit code 63.\n"
"\n"
, stdout);
 fputs(
"              NOTE:  The  file size is not always known prior to download, and\n"
"              for such files this option has no effect even if the file trans-\n"
"              fer  ends  up  being larger than this given limit. This concerns\n"
"              both FTP and HTTP transfers.\n"
"\n"
"       -m/--max-time <seconds>\n"
"              Maximum time in seconds that you allow the  whole  operation  to\n"
"              take.   This is useful for preventing your batch jobs from hang-\n"
, stdout);
 fputs(
"              ing for hours due to slow networks or  links  going  down.   See\n"
"              also the --connect-timeout option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -M/--manual\n"
"              Manual. Display the huge help text.\n"
"\n"
"       -n/--netrc\n"
"              Makes curl scan the .netrc file in the user's home directory for\n"
"              login name and password. This is typically used for ftp on unix.\n"
, stdout);
 fputs(
"              If used with http, curl will  enable  user  authentication.  See\n"
"              netrc(4) or ftp(1) for details on the file format. Curl will not\n"
"              complain if that file hasn't the right  permissions  (it  should\n"
"              not  be  world  nor  group  readable).  The environment variable\n"
"              \"HOME\" is used to find the home directory.\n"
"\n"
"              A quick and very simple example of how  to  setup  a  .netrc  to\n"
, stdout);
 fputs(
"              allow  curl to ftp to the machine host.domain.com with user name\n"
"              'myself' and password 'secret' should look similar to:\n"
"\n"
"              machine host.domain.com login myself password secret\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
"              netrc usage.\n"
"\n"
"       --netrc-optional\n"
"              Very  similar to --netrc, but this option makes the .netrc usage\n"
"              optional and not mandatory as the --netrc does.\n"
"\n"
, stdout);
 fputs(
"       --negotiate\n"
"              (HTTP) Enables GSS-Negotiate authentication.  The  GSS-Negotiate\n"
"              method was designed by Microsoft and is used in their web appli-\n"
"              cations. It is  primarily  meant  as  a  support  for  Kerberos5\n"
"              authentication but may be also used along with another authenti-\n"
"              cation methods. For  more  information  see  IETF  draft  draft-\n"
"              brezak-spnego-http-04.txt.\n"
"\n"
, stdout);
 fputs(
"              If  you  want to enable Negotiate for your proxy authentication,\n"
"              then use --proxy-negotiate.\n"
"\n"
"              This option requires that the library was built with GSSAPI sup-\n"
"              port.  This  is not very common. Use -V/--version to see if your\n"
"              version supports GSS-Negotiate.\n"
"\n"
"              When using this option, you must also provide a  fake  -u/--user\n"
"              option  to  activate the authentication code properly. Sending a\n"
, stdout);
 fputs(
"              '-u :' is enough as the user  name  and  password  from  the  -u\n"
"              option aren't actually used.\n"
"\n"
"              If  this option is used several times, the following occurrences\n"
"              make no difference.\n"
"\n"
"       -N/--no-buffer\n"
"              Disables the buffering of the output stream. In normal work sit-\n"
"              uations,  curl  will  use a standard buffered output stream that\n"
"              will have the effect that it will output the data in chunks, not\n"
, stdout);
 fputs(
"              necessarily  exactly  when  the data arrives.  Using this option\n"
"              will disable that buffering.\n"
"\n"
"              If this option is used twice, the second will  again  switch  on\n"
"              buffering.\n"
"\n"
"       --no-keepalive\n"
"              Disables the use of keepalive messages on the TCP connection, as\n"
"              by default curl enables them.\n"
"\n"
"              If this option is used  twice,  the  second  will  again  enable\n"
"              keepalive.\n"
"\n"
, stdout);
 fputs(
"       --no-sessionid\n"
"              (SSL)  Disable curl's use of SSL session-ID caching.  By default\n"
"              all transfers are done using the cache. Note that while  nothing\n"
"              ever  should  get  hurt  by attempting to reuse SSL session-IDs,\n"
"              there seem to be broken SSL implementations in the wild that may\n"
"              require  you to disable this in order for you to succeed. (Added\n"
"              in 7.16.0)\n"
"\n"
, stdout);
 fputs(
"              If this option is used twice, the second will  again  switch  on\n"
"              use of the session cache.\n"
"\n"
"       --ntlm (HTTP)  Enables  NTLM  authentication.  The  NTLM authentication\n"
"              method was designed by Microsoft and is used by IIS web servers.\n"
"              It is a proprietary protocol, reversed engineered by clever peo-\n"
"              ple and implemented in curl based on their efforts. This kind of\n"
, stdout);
 fputs(
"              behavior  should  not be endorsed, you should encourage everyone\n"
"              who uses NTLM to switch to a public and  documented  authentica-\n"
"              tion method instead. Such as Digest.\n"
"\n"
"              If  you  want to enable NTLM for your proxy authentication, then\n"
"              use --proxy-ntlm.\n"
"\n"
"              This option requires that the library was built  with  SSL  sup-\n"
"              port. Use -V/--version to see if your curl supports NTLM.\n"
"\n"
, stdout);
 fputs(
"              If  this option is used several times, the following occurrences\n"
"              make no difference.\n"
"\n"
"       -o/--output <file>\n"
"              Write output to <file> instead of stdout. If you are using {} or\n"
"              []  to  fetch  multiple documents, you can use '#' followed by a\n"
"              number in the <file> specifier. That variable will  be  replaced\n"
"              with the current string for the URL being fetched. Like in:\n"
"\n"
, stdout);
 fputs(
"                curl http://{one,two}.site.com -o \"file_#1.txt\"\n"
"\n"
"              or use several variables like:\n"
"\n"
"                curl http://{site,host}.host[1-5].com -o \"#1_#2\"\n"
"\n"
"              You  may  use  this  option  as many times as you have number of\n"
"              URLs.\n"
"\n"
"              See also the --create-dirs option to create the  local  directo-\n"
"              ries dynamically.\n"
"\n"
"       -O/--remote-name\n"
"              Write  output to a local file named like the remote file we get.\n"
, stdout);
 fputs(
"              (Only the file part of the remote file is used, the path is  cut\n"
"              off.)\n"
"\n"
"              The  remote  file  name  to use for saving is extracted from the\n"
"              given URL, nothing else.\n"
"\n"
"              You may use this option as many times  as  you  have  number  of\n"
"              URLs.\n"
"\n"
"       --pass <phrase>\n"
"              (SSL/SSH) Pass phrase for the private key\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --post301\n"
, stdout);
 fputs(
"              Tells curl to respect  RFC  2616/10.3.2  and  not  convert  POST\n"
"              requests into GET requests when following a 301 redirection. The\n"
"              non-RFC behaviour is ubiquitous in web browsers,  so  curl  does\n"
"              the  conversion  by  default to maintain consistency. However, a\n"
"              server may requires a POST to remain a POST after such  a  redi-\n"
"              rection. This option is meaningful only when using -L/--location\n"
, stdout);
 fputs(
"              (Added in 7.17.1)\n"
"\n"
"       --proxy-anyauth\n"
"              Tells curl to pick a suitable authentication method when  commu-\n"
"              nicating  with  the  given  proxy.  This  might  cause  an extra\n"
"              request/response round-trip. (Added in 7.13.2)\n"
"\n"
"              If this option is used twice, the second will again disable  the\n"
"              proxy use-any authentication.\n"
"\n"
"       --proxy-basic\n"
"              Tells  curl  to use HTTP Basic authentication when communicating\n"
, stdout);
 fputs(
"              with the given proxy. Use --basic for enabling HTTP Basic with a\n"
"              remote  host.  Basic  is  the default authentication method curl\n"
"              uses with proxies.\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
"              proxy HTTP Basic authentication.\n"
"\n"
"       --proxy-digest\n"
"              Tells  curl to use HTTP Digest authentication when communicating\n"
"              with the given proxy. Use --digest for enabling HTTP Digest with\n"
, stdout);
 fputs(
"              a remote host.\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              proxy HTTP Digest.\n"
"\n"
"       --proxy-negotiate\n"
"              Tells curl to use HTTP Negotiate authentication when communicat-\n"
"              ing  with  the  given  proxy.  Use --negotiate for enabling HTTP\n"
"              Negotiate with a remote host.\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
, stdout);
 fputs(
"              proxy HTTP Negotiate. (Added in 7.17.1)\n"
"\n"
"       --proxy-ntlm\n"
"              Tells  curl  to  use HTTP NTLM authentication when communicating\n"
"              with the given proxy. Use --ntlm for enabling NTLM with a remote\n"
"              host.\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              proxy HTTP NTLM.\n"
"       -p/--proxytunnel\n"
"              When an HTTP proxy is used (-x/--proxy), this option will  cause\n"
, stdout);
 fputs(
"              non-HTTP  protocols  to  attempt  to  tunnel  through  the proxy\n"
"              instead of merely using it to do HTTP-like operations. The  tun-\n"
"              nel  approach  is  made  with the HTTP proxy CONNECT request and\n"
"              requires that the proxy allows direct connect to the remote port\n"
"              number curl wants to tunnel through to.\n"
"\n"
"              If  this  option  is  used  twice, the second will again disable\n"
"              proxy tunnel.\n"
"\n"
, stdout);
 fputs(
"       --pubkey <key>\n"
"              (SSH) Public key file name. Allows you to  provide  your  public\n"
"              key in this separate file.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -P/--ftp-port <address>\n"
"              (FTP) Reverses the initiator/listener roles when connecting with\n"
"              ftp.  This  switch  makes  Curl  use the PORT command instead of\n"
"              PASV. In practise, PORT tells  the  server  to  connect  to  the\n"
, stdout);
 fputs(
"              client's  specified address and port, while PASV asks the server\n"
"              for an ip address and port to connect to.  <address>  should  be\n"
"              one of:\n"
"\n"
"              interface\n"
"                     i.e  \"eth0\"  to  specify which interface's IP address you\n"
"                     want to use  (Unix only)\n"
"\n"
"              IP address\n"
"                     i.e \"192.168.10.1\" to specify exact IP number\n"
"\n"
"              host name\n"
, stdout);
 fputs(
"                     i.e \"my.host.domain\" to specify machine\n"
"\n"
"              -      make curl pick the same IP address that is  already  used\n"
"                     for the control connection\n"
"\n"
"       If  this  option is used several times, the last one will be used. Dis-\n"
"       able the use of PORT with --ftp-pasv. Disable the attempt  to  use  the\n"
"       EPRT  command  instead  of PORT by using --disable-eprt. EPRT is really\n"
"       PORT++.\n"
"\n"
, stdout);
 fputs(
"       -q     If used as the first parameter on the command line,  the  curlrc\n"
"              config  file  will not be read and used. See the -K/--config for\n"
"              details on the default config file search path.\n"
"\n"
"       -Q/--quote <command>\n"
"              (FTP/SFTP) Send an arbitrary command to the remote FTP  or  SFTP\n"
"              server.  Quote  commands  are sent BEFORE the transfer is taking\n"
"              place (just after the initial PWD command in an FTP transfer, to\n"
, stdout);
 fputs(
"              be exact). To make commands take place after a successful trans-\n"
"              fer, prefix them with a dash '-'.  To  make  commands  get  sent\n"
"              after  libcurl  has  changed  working directory, just before the\n"
"              transfer command(s), prefix the command with '+' (this  is  only\n"
"              supported  for  FTP). You may specify any number of commands. If\n"
"              the server returns failure for one of the commands,  the  entire\n"
, stdout);
 fputs(
"              operation  will  be aborted. You must send syntactically correct\n"
"              FTP commands as RFC959 defines to FTP servers,  or  one  of  the\n"
"              following commands (with appropriate arguments) to SFTP servers:\n"
"              chgrp, chmod, chown, ln, mkdir, pwd, rename, rm, rmdir, symlink.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"       --random-file <file>\n"
"              (SSL) Specify the path name to file containing what will be con-\n"
, stdout);
 fputs(
"              sidered as random data. The data is  used  to  seed  the  random\n"
"              engine for SSL connections.  See also the --egd-file option.\n"
"\n"
"       -r/--range <range>\n"
"              (HTTP/FTP/FILE)  Retrieve  a byte range (i.e a partial document)\n"
"              from a HTTP/1.1, FTP server or a local FILE. Ranges can be spec-\n"
"              ified in a number of ways.\n"
"\n"
"              0-499     specifies the first 500 bytes\n"
"\n"
"              500-999   specifies the second 500 bytes\n"
"\n"
, stdout);
 fputs(
"              -500      specifies the last 500 bytes\n"
"\n"
"              9500-     specifies the bytes from offset 9500 and forward\n"
"\n"
"              0-0,-1    specifies the first and last byte only(*)(H)\n"
"\n"
"              500-700,600-799\n"
"                        specifies 300 bytes from offset 500(H)\n"
"\n"
"              100-199,500-599\n"
"                        specifies two separate 100 bytes ranges(*)(H)\n"
"\n"
"       (*)  =  NOTE  that this will cause the server to reply with a multipart\n"
"       response!\n"
"\n"
, stdout);
 fputs(
"       Only digit characters (0-9) are valid in 'start' and  'stop'  of  range\n"
"       syntax  'start-stop'.  If  a non-digit character is given in the range,\n"
"       the server's response will be indeterminable,  depending  on  different\n"
"       server's configuration.\n"
"\n"
"       You  should  also  be aware that many HTTP/1.1 servers do not have this\n"
"       feature enabled, so that when  you  attempt  to  get  a  range,  you'll\n"
"       instead get the whole document.\n"
"\n"
, stdout);
 fputs(
"       FTP  range  downloads  only  support  the  simple  syntax  'start-stop'\n"
"       (optionally with one of the numbers omitted). It depends on the non-RFC\n"
"       command SIZE.\n"
"\n"
"       If this option is used several times, the last one will be used.\n"
"\n"
"       --raw  When  used, it disables all internal HTTP decoding of content or\n"
"              transfer encodings and instead makes them passed  on  unaltered,\n"
"              raw. (Added in 7.16.2)\n"
"\n"
, stdout);
 fputs(
"              If  this  option  is used several times, each occurrence toggles\n"
"              this on/off.\n"
"\n"
"       -R/--remote-time\n"
"              When used, this will make libcurl  attempt  to  figure  out  the\n"
"              timestamp  of the remote file, and if that is available make the\n"
"              local file get that same timestamp.\n"
"\n"
"              If this option is used twice,  the  second  time  disables  this\n"
"              again.\n"
"\n"
"       --retry <num>\n"
, stdout);
 fputs(
"              If  a  transient  error is returned when curl tries to perform a\n"
"              transfer, it will retry this number of times before  giving  up.\n"
"              Setting  the  number to 0 makes curl do no retries (which is the\n"
"              default). Transient error means either: a timeout,  an  FTP  5xx\n"
"              response code or an HTTP 5xx response code.\n"
"\n"
"              When  curl  is about to retry a transfer, it will first wait one\n"
, stdout);
 fputs(
"              second and then for all forthcoming retries it will  double  the\n"
"              waiting  time until it reaches 10 minutes which then will be the\n"
"              delay between the rest of the retries.  By  using  --retry-delay\n"
"              you   disable  this  exponential  backoff  algorithm.  See  also\n"
"              --retry-max-time to limit the total time  allowed  for  retries.\n"
"              (Added in 7.12.3)\n"
"\n"
, stdout);
 fputs(
"              If  this  option  is  used  multiple  times, the last occurrence\n"
"              decide the amount.\n"
"\n"
"       --retry-delay <seconds>\n"
"              Make curl sleep this amount of time between each  retry  when  a\n"
"              transfer  has  failed  with  a  transient  error (it changes the\n"
"              default backoff time algorithm between retries). This option  is\n"
"              only  interesting if --retry is also used. Setting this delay to\n"
, stdout);
 fputs(
"              zero will make curl use the default  backoff  time.   (Added  in\n"
"              7.12.3)\n"
"\n"
"              If  this  option  is  used  multiple  times, the last occurrence\n"
"              decide the amount.\n"
"\n"
"       --retry-max-time <seconds>\n"
"              The retry timer is reset  before  the  first  transfer  attempt.\n"
"              Retries will be done as usual (see --retry) as long as the timer\n"
"              hasn't reached this given limit. Notice that if the timer hasn't\n"
, stdout);
 fputs(
"              reached  the  limit, the request will be made and while perform-\n"
"              ing, it may take longer than this given time period. To limit  a\n"
"              single  request's  maximum  time,  use  -m/--max-time.  Set this\n"
"              option to zero to not timeout retries. (Added in 7.12.3)\n"
"\n"
"              If this option is  used  multiple  times,  the  last  occurrence\n"
"              decide the amount.\n"
"\n"
"       -s/--silent\n"
, stdout);
 fputs(
"              Silent mode. Don't show progress meter or error messages.  Makes\n"
"              Curl mute.\n"
"\n"
"              If this option is used twice,  the  second  will  again  disable\n"
"              silent mode.\n"
"\n"
"       -S/--show-error\n"
"              When  used with -s it makes curl show error message if it fails.\n"
"              If this option is used twice, the second will again disable show\n"
"              error.\n"
"\n"
"       --socks4 <host[:port]>\n"
, stdout);
 fputs(
"              Use the specified SOCKS4 proxy. If the port number is not speci-\n"
"              fied, it is assumed at port 1080. (Added in 7.15.2)\n"
"\n"
"              This option overrides any previous use of  -x/--proxy,  as  they\n"
"              are mutually exclusive.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --socks4a <host[:port]>\n"
"              Use the specified SOCKS4a proxy. If the port number is not spec-\n"
, stdout);
 fputs(
"              ified, it is assumed at port 1080. (Added in 7.18.0)\n"
"\n"
"              This  option  overrides  any previous use of -x/--proxy, as they\n"
"              are mutually exclusive.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --socks5-hostname <host[:port]>\n"
"              Use  the  specified  SOCKS5 proxy (and let the proxy resolve the\n"
"              host name). If the port number is not specified, it  is  assumed\n"
, stdout);
 fputs(
"              at port 1080. (Added in 7.18.0)\n"
"\n"
"              This  option  overrides  any previous use of -x/--proxy, as they\n"
"              are mutually exclusive.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"              (This  option  was  previously  wrongly  documented  and used as\n"
"              --socks without the number appended.)\n"
"\n"
"       --socks5 <host[:port]>\n"
"              Use the specified SOCKS5 proxy  -  but  resolve  the  host  name\n"
, stdout);
 fputs(
"              locally.  If  the port number is not specified, it is assumed at\n"
"              port 1080.\n"
"\n"
"              This option overrides any previous use of  -x/--proxy,  as  they\n"
"              are mutually exclusive.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"              (This option was  previously  wrongly  documented  and  used  as\n"
"              --socks without the number appended.)\n"
"\n"
"       --stderr <file>\n"
, stdout);
 fputs(
"              Redirect  all writes to stderr to the specified file instead. If\n"
"              the file name is a plain '-', it is instead written  to  stdout.\n"
"              This  option  has no point when you're using a shell with decent\n"
"              redirecting capabilities.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --tcp-nodelay\n"
"              Turn  on the TCP_NODELAY option. See the curl_easy_setopt(3) man\n"
, stdout);
 fputs(
"              page for details about this option. (Added in 7.11.2)\n"
"\n"
"              If this option is used several times,  each  occurrence  toggles\n"
"              this on/off.\n"
"\n"
"       -t/--telnet-option <OPT=val>\n"
"              Pass options to the telnet protocol. Supported options are:\n"
"\n"
"              TTYPE=<term> Sets the terminal type.\n"
"\n"
"              XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"              NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"       -T/--upload-file <file>\n"
, stdout);
 fputs(
"              This  transfers  the  specified local file to the remote URL. If\n"
"              there is no file part in the specified URL, Curl will append the\n"
"              local file name. NOTE that you must use a trailing / on the last\n"
"              directory to really prove to Curl that there is no file name  or\n"
"              curl will think that your last directory name is the remote file\n"
"              name to use. That will most likely cause the upload operation to\n"
, stdout);
 fputs(
"              fail.  If this is used on a http(s) server, the PUT command will\n"
"              be used.\n"
"\n"
"              Use the file name \"-\" (a single dash) to use stdin instead of  a\n"
"              given file.\n"
"\n"
"              You can specify one -T for each URL on the command line. Each -T\n"
"              + URL pair specifies what to upload and to where. curl also sup-\n"
"              ports \"globbing\" of the -T argument, meaning that you can upload\n"
, stdout);
 fputs(
"              multiple files to a single URL by using the  same  URL  globbing\n"
"              style supported in the URL, like this:\n"
"\n"
"              curl -T \"{file1,file2}\" http://www.uploadtothissite.com\n"
"\n"
"              or even\n"
"\n"
"              curl -T \"img[1-1000].png\" ftp://ftp.picturemania.com/upload/\n"
"\n"
"       --trace <file>\n"
"              Enables  a  full  trace  dump of all incoming and outgoing data,\n"
"              including descriptive information, to the given output file. Use\n"
, stdout);
 fputs(
"              \"-\" as filename to have the output sent to stdout.\n"
"\n"
"              This  option overrides previous uses of -v/--verbose or --trace-\n"
"              ascii.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --trace-ascii <file>\n"
"              Enables  a  full  trace  dump of all incoming and outgoing data,\n"
"              including descriptive information, to the given output file. Use\n"
"              \"-\" as filename to have the output sent to stdout.\n"
, stdout);
 fputs(
"\n"
"              This is very similar to --trace, but leaves out the hex part and\n"
"              only shows the ASCII part of the dump. It makes  smaller  output\n"
"              that might be easier to read for untrained humans.\n"
"\n"
"              This  option overrides previous uses of -v/--verbose or --trace.\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --trace-time\n"
"              Prepends  a  time  stamp to each trace or verbose line that curl\n"
, stdout);
 fputs(
"              displays.  (Added in 7.14.0)\n"
"\n"
"              If this option is used several times, each occurrence will  tog-\n"
"              gle it on/off.\n"
"\n"
"       -u/--user <user:password>\n"
"              Specify  user  and  password  to  use for server authentication.\n"
"              Overrides -n/--netrc and --netrc-optional.\n"
"\n"
"              If you just give the user name (without entering a  colon)  curl\n"
"              will prompt for a password.\n"
"\n"
, stdout);
 fputs(
"              If  you  use an SSPI-enabled curl binary and do NTLM authentica-\n"
"              tion, you can force curl to pick up the user name  and  password\n"
"              from  your  environment by simply specifying a single colon with\n"
"              this option: \"-u :\".\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -U/--proxy-user <user:password>\n"
"              Specify user and password to use for proxy authentication.\n"
"\n"
, stdout);
 fputs(
"              If  you  use an SSPI-enabled curl binary and do NTLM authentica-\n"
"              tion, you can force curl to pick up the user name  and  password\n"
"              from  your  environment by simply specifying a single colon with\n"
"              this option: \"-U :\".\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --url <URL>\n"
"              Specify  a  URL  to  fetch. This option is mostly handy when you\n"
, stdout);
 fputs(
"              want to specify URL(s) in a config file.\n"
"\n"
"              This option may be used any number of times.  To  control  where\n"
"              this URL is written, use the -o/--output or the -O/--remote-name\n"
"              options.\n"
"\n"
"       -v/--verbose\n"
"              Makes the fetching more  verbose/talkative.  Mostly  usable  for\n"
"              debugging.  Lines  starting with '>' means \"header data\" sent by\n"
"              curl, '<' means \"header data\" received by curl that is hidden in\n"
, stdout);
 fputs(
"              normal  cases  and lines starting with '*' means additional info\n"
"              provided by curl.\n"
"\n"
"              Note  that  if  you  only  want  HTTP  headers  in  the  output,\n"
"              -i/--include might be option you're looking for.\n"
"\n"
"              If  you think this option still doesn't give you enough details,\n"
"              consider using --trace or --trace-ascii instead.\n"
"\n"
"              This option overrides previous uses of --trace-ascii or --trace.\n"
, stdout);
 fputs(
"              If  this option is used twice, the second will do nothing extra.\n"
"\n"
"       -V/--version\n"
"              Displays information about curl and the libcurl version it uses.\n"
"              The  first  line  includes the full version of curl, libcurl and\n"
"              other 3rd party libraries linked with the executable.\n"
"\n"
"              The second line (starts with \"Protocols:\") shows  all  protocols\n"
"              that libcurl reports to support.\n"
"\n"
, stdout);
 fputs(
"              The third line (starts with \"Features:\") shows specific features\n"
"              libcurl reports to offer. Available features include:\n"
"\n"
"              IPv6   You can use IPv6 with this.\n"
"\n"
"              krb4   Krb4 for ftp is supported.\n"
"\n"
"              SSL    HTTPS and FTPS are supported.\n"
"\n"
"              libz   Automatic decompression of compressed files over HTTP  is\n"
"                     supported.\n"
"\n"
"              NTLM   NTLM authentication is supported.\n"
"\n"
"              GSS-Negotiate\n"
, stdout);
 fputs(
"                     Negotiate authentication and krb5 for ftp is supported.\n"
"\n"
"              Debug  This  curl  uses a libcurl built with Debug. This enables\n"
"                     more error-tracking and memory debugging etc.  For  curl-\n"
"                     developers only!\n"
"\n"
"              AsynchDNS\n"
"                     This curl uses asynchronous name resolves.\n"
"\n"
"              SPNEGO SPNEGO Negotiate authentication is supported.\n"
"\n"
"              Largefile\n"
, stdout);
 fputs(
"                     This curl supports transfers of large files, files larger\n"
"                     than 2GB.\n"
"\n"
"              IDN    This curl supports IDN - international domain names.\n"
"\n"
"              SSPI   SSPI is supported. If you use NTLM and set a  blank  user\n"
"                     name,  curl  will authenticate with your current user and\n"
"                     password.\n"
"\n"
"       -w/--write-out <format>\n"
"              Defines what to display on stdout after a completed and success-\n"
, stdout);
 fputs(
"              ful  operation.  The  format  is a string that may contain plain\n"
"              text mixed with any number of variables. The string can be spec-\n"
"              ified  as \"string\", to get read from a particular file you spec-\n"
"              ify it \"@filename\" and to tell curl  to  read  the  format  from\n"
"              stdin you write \"@-\".\n"
"\n"
"              The  variables  present in the output format will be substituted\n"
, stdout);
 fputs(
"              by the value or text that curl thinks fit, as  described  below.\n"
"              All  variables are specified like %{variable_name} and to output\n"
"              a normal % you just write them like %%. You can output a newline\n"
"              by  using \\n, a carriage return with \\r and a tab space with \\t.\n"
"              NOTE: The %-letter is a special letter in the win32-environment,\n"
"              where  all  occurrences  of  %  must  be doubled when using this\n"
"              option.\n"
"\n"
, stdout);
 fputs(
"              Available variables are at this point:\n"
"\n"
"              url_effective  The URL that was fetched  last.  This  is  mostly\n"
"                             meaningful  if  you've  told curl to follow loca-\n"
"                             tion: headers.\n"
"\n"
"              http_code      The numerical code that was  found  in  the  last\n"
"                             retrieved HTTP(S) page.\n"
"\n"
"              http_connect   The  numerical  code  that  was found in the last\n"
, stdout);
 fputs(
"                             response  (from  a  proxy)  to  a  curl   CONNECT\n"
"                             request. (Added in 7.12.4)\n"
"\n"
"              time_total     The  total time, in seconds, that the full opera-\n"
"                             tion lasted. The time will be displayed with mil-\n"
"                             lisecond resolution.\n"
"\n"
"              time_namelookup\n"
"                             The  time,  in  seconds,  it  took from the start\n"
, stdout);
 fputs(
"                             until the name resolving was completed.\n"
"\n"
"              time_connect   The time, in seconds,  it  took  from  the  start\n"
"                             until  the  connect to the remote host (or proxy)\n"
"                             was completed.\n"
"\n"
"              time_pretransfer\n"
"                             The time, in seconds,  it  took  from  the  start\n"
"                             until  the  file transfer is just about to begin.\n"
, stdout);
 fputs(
"                             This includes all pre-transfer commands and nego-\n"
"                             tiations that are specific to the particular pro-\n"
"                             tocol(s) involved.\n"
"\n"
"              time_redirect  The time, in seconds, it took for all redirection\n"
"                             steps  include  name lookup, connect, pretransfer\n"
"                             and  transfer  before   final   transaction   was\n"
, stdout);
 fputs(
"                             started.  time_redirect shows the complete execu-\n"
"                             tion time for multiple  redirections.  (Added  in\n"
"                             7.12.3)\n"
"\n"
"              time_starttransfer\n"
"                             The  time,  in  seconds,  it  took from the start\n"
"                             until the first byte is just about to  be  trans-\n"
"                             ferred.  This  includes time_pretransfer and also\n"
, stdout);
 fputs(
"                             the  time  the  server  needs  to  calculate  the\n"
"                             result.\n"
"\n"
"              size_download  The total amount of bytes that were downloaded.\n"
"\n"
"              size_upload    The total amount of bytes that were uploaded.\n"
"\n"
"              size_header    The total amount of bytes of the downloaded head-\n"
"                             ers.\n"
"\n"
"              size_request   The total amount of bytes that were sent  in  the\n"
, stdout);
 fputs(
"                             HTTP request.\n"
"\n"
"              speed_download The average download speed that curl measured for\n"
"                             the complete download.\n"
"\n"
"              speed_upload   The average upload speed that curl  measured  for\n"
"                             the complete upload.\n"
"\n"
"              content_type   The  Content-Type  of  the requested document, if\n"
"                             there was any.\n"
"\n"
, stdout);
 fputs(
"              num_connects   Number of new connects made in the recent  trans-\n"
"                             fer. (Added in 7.12.3)\n"
"\n"
"              num_redirects  Number  of  redirects  that  were followed in the\n"
"                             request. (Added in 7.12.3)\n"
"\n"
"              ftp_entry_path The initial path libcurl ended up in when logging\n"
"                             on to the remote FTP server. (Added in 7.15.4)\n"
"\n"
"       If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"       -x/--proxy <proxyhost[:port]>\n"
"              Use  specified  HTTP proxy. If the port number is not specified,\n"
"              it is assumed at port 1080.\n"
"\n"
"              This option overrides existing environment variables  that  sets\n"
"              proxy  to  use.  If  there's  an  environment variable setting a\n"
"              proxy, you can set proxy to \"\" to override it.\n"
"\n"
"              Note that all operations that are performed over  a  HTTP  proxy\n"
, stdout);
 fputs(
"              will  transparently  be converted to HTTP. It means that certain\n"
"              protocol specific operations might not be available. This is not\n"
"              the  case  if you can tunnel through the proxy, as done with the\n"
"              -p/--proxytunnel option.\n"
"\n"
"              Starting with 7.14.1, the proxy host can be specified the  exact\n"
"              same  way  as  the proxy environment variables, include protocol\n"
"              prefix (http://) and embedded user + password.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -X/--request <command>\n"
"              (HTTP) Specifies a custom request method to use when communicat-\n"
"              ing with the HTTP server.  The specified request  will  be  used\n"
"              instead  of  the  method otherwise used (which defaults to GET).\n"
"              Read the HTTP 1.1 specification for details and explanations.\n"
"\n"
, stdout);
 fputs(
"              (FTP) Specifies a custom FTP command to use instead of LIST when\n"
"              doing file lists with ftp.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -y/--speed-time <time>\n"
"              If a download is slower than speed-limit bytes per second during\n"
"              a speed-time period, the download gets aborted. If speed-time is\n"
"              used, the default speed-limit will be 1 unless set with -y.\n"
"\n"
, stdout);
 fputs(
"              This option controls transfers and thus  will  not  affect  slow\n"
"              connects  etc.  If this is a concern for you, try the --connect-\n"
"              timeout option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -Y/--speed-limit <speed>\n"
"              If a download is slower than this given speed, in bytes per sec-\n"
"              ond, for speed-time seconds it gets aborted. speed-time  is  set\n"
, stdout);
 fputs(
"              with -Y and is 30 if not set.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -z/--time-cond <date expression>\n"
"              (HTTP/FTP) Request a file that has been modified later than  the\n"
"              given  time  and date, or one that has been modified before that\n"
"              time. The date expression can be all sorts of date strings or if\n"
"              it  doesn't  match  any  internal ones, it tries to get the time\n"
, stdout);
 fputs(
"              from a given file name  instead!  See  the  curl_getdate(3)  man\n"
"              pages for date expression details.\n"
"\n"
"              Start the date expression with a dash (-) to make it request for\n"
"              a document that is older than the given date/time, default is  a\n"
"              document that is newer than the specified date/time.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --max-redirs <num>\n"
, stdout);
 fputs(
"              Set  maximum  number  of  redirection-followings   allowed.   If\n"
"              -L/--location  is  used, this option can be used to prevent curl\n"
"              from following redirections \"in absurdum\". By default, the limit\n"
"              is set to 50 redirections. Set this option to -1 to make it lim-\n"
"              itless.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -0/--http1.0\n"
, stdout);
 fputs(
"              (HTTP)  Forces curl to issue its requests using HTTP 1.0 instead\n"
"              of using its internally preferred: HTTP 1.1.\n"
"\n"
"       -1/--tlsv1\n"
"              (SSL) Forces curl to use TSL version 1 when negotiating  with  a\n"
"              remote TLS server.\n"
"\n"
"       -2/--sslv2\n"
"              (SSL)  Forces  curl to use SSL version 2 when negotiating with a\n"
"              remote SSL server.\n"
"\n"
"       -3/--sslv3\n"
"              (SSL) Forces curl to use SSL version 3 when negotiating  with  a\n"
, stdout);
 fputs(
"              remote SSL server.\n"
"\n"
"       -4/--ipv4\n"
"              If  libcurl  is  capable  of resolving an address to multiple IP\n"
"              versions (which it is if it is ipv6-capable), this option  tells\n"
"              libcurl to resolve names to IPv4 addresses only.\n"
"\n"
"       -6/--ipv6\n"
"              If  libcurl  is  capable  of resolving an address to multiple IP\n"
"              versions (which it is if it is ipv6-capable), this option  tells\n"
, stdout);
 fputs(
"              libcurl to resolve names to IPv6 addresses only.\n"
"\n"
"       -#/--progress-bar\n"
"              Make curl display progress information as a progress bar instead\n"
"              of the default statistics.\n"
"\n"
"              If this option is used twice, the second will again disable  the\n"
"              progress bar.\n"
"\n"
"FILES\n"
"       ~/.curlrc\n"
"              Default config file, see -K/--config for details.\n"
"\n"
"ENVIRONMENT\n"
"       http_proxy [protocol://]<host>[:port]\n"
, stdout);
 fputs(
"              Sets proxy server to use for HTTP.\n"
"\n"
"       HTTPS_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for HTTPS.\n"
"\n"
"       FTP_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for FTP.\n"
"\n"
"       ALL_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use if no protocol-specific proxy is set.\n"
"\n"
"       NO_PROXY <comma-separated list of hosts>\n"
"              list  of  host names that shouldn't go through any proxy. If set\n"
, stdout);
 fputs(
"              to a asterisk '*' only, it matches all hosts.\n"
"\n"
"EXIT CODES\n"
"       There exists a bunch of different error codes and  their  corresponding\n"
"       error  messages  that  may appear during bad conditions. At the time of\n"
"       this writing, the exit codes are:\n"
"\n"
"       1      Unsupported protocol. This build of curl has no support for this\n"
"              protocol.\n"
"\n"
"       2      Failed to initialize.\n"
"\n"
"       3      URL malformat. The syntax was not correct.\n"
"\n"
, stdout);
 fputs(
"       5      Couldn't  resolve  proxy.  The  given  proxy  host  could not be\n"
"              resolved.\n"
"\n"
"       6      Couldn't resolve host. The given remote host was not resolved.\n"
"\n"
"       7      Failed to connect to host.\n"
"\n"
"       8      FTP weird server reply.  The  server  sent  data  curl  couldn't\n"
"              parse.\n"
"\n"
"       9      FTP  access  denied. The server denied login or denied access to\n"
"              the particular resource or directory you wanted to  reach.  Most\n"
, stdout);
 fputs(
"              often  you  tried to change to a directory that doesn't exist on\n"
"              the server.\n"
"\n"
"       11     FTP weird PASS reply. Curl couldn't parse the reply sent to  the\n"
"              PASS request.\n"
"\n"
"       13     FTP  weird PASV reply, Curl couldn't parse the reply sent to the\n"
"              PASV request.\n"
"\n"
"       14     FTP weird 227 format.  Curl  couldn't  parse  the  227-line  the\n"
"              server sent.\n"
"\n"
, stdout);
 fputs(
"       15     FTP  can't  get host. Couldn't resolve the host IP we got in the\n"
"              227-line.\n"
"\n"
"       17     FTP couldn't set binary.  Couldn't  change  transfer  method  to\n"
"              binary.\n"
"\n"
"       18     Partial file. Only a part of the file was transferred.\n"
"\n"
"       19     FTP  couldn't download/access the given file, the RETR (or simi-\n"
"              lar) command failed.\n"
"\n"
"       21     FTP quote error. A quote command returned error from the server.\n"
, stdout);
 fputs(
"       22     HTTP  page  not  retrieved.  The  requested url was not found or\n"
"              returned another error with the HTTP error  code  being  400  or\n"
"              above. This return code only appears if -f/--fail is used.\n"
"\n"
"       23     Write  error.  Curl couldn't write data to a local filesystem or\n"
"              similar.\n"
"\n"
"       25     FTP couldn't STOR file. The server denied  the  STOR  operation,\n"
"              used for FTP uploading.\n"
"\n"
, stdout);
 fputs(
"       26     Read error. Various reading problems.\n"
"\n"
"       27     Out of memory. A memory allocation request failed.\n"
"\n"
"       28     Operation  timeout.  The  specified  time-out period was reached\n"
"              according to the conditions.\n"
"\n"
"       30     FTP PORT failed. The PORT command failed. Not  all  FTP  servers\n"
"              support  the  PORT  command,  try  doing  a  transfer using PASV\n"
"              instead!\n"
"\n"
, stdout);
 fputs(
"       31     FTP couldn't use REST. The REST command failed. This command  is\n"
"              used for resumed FTP transfers.\n"
"\n"
"       33     HTTP range error. The range \"command\" didn't work.\n"
"\n"
"       34     HTTP post error. Internal post-request generation error.\n"
"\n"
"       35     SSL connect error. The SSL handshaking failed.\n"
"\n"
"       36     FTP  bad  download  resume. Couldn't continue an earlier aborted\n"
"              download.\n"
"\n"
, stdout);
 fputs(
"       37     FILE couldn't read file. Failed to open the file. Permissions?\n"
"\n"
"       38     LDAP cannot bind. LDAP bind operation failed.\n"
"\n"
"       39     LDAP search failed.\n"
"\n"
"       41     Function not found. A required LDAP function was not found.\n"
"\n"
"       42     Aborted by callback. An application told curl to abort the oper-\n"
"              ation.\n"
"\n"
"       43     Internal error. A function was called with a bad parameter.\n"
"\n"
, stdout);
 fputs(
"       45     Interface  error.  A  specified  outgoing interface could not be\n"
"              used.\n"
"\n"
"       47     Too many redirects. When following redirects, curl hit the maxi-\n"
"              mum amount.\n"
"\n"
"       48     Unknown TELNET option specified.\n"
"\n"
"       49     Malformed telnet option.\n"
"\n"
"       51     The peer's SSL certificate or SSH MD5 fingerprint was not ok\n"
"\n"
"       52     The  server  didn't  reply anything, which here is considered an\n"
"              error.\n"
"\n"
, stdout);
 fputs(
"       53     SSL crypto engine not found\n"
"\n"
"       54     Cannot set SSL crypto engine as default\n"
"\n"
"       55     Failed sending network data\n"
"\n"
"       56     Failure in receiving network data\n"
"\n"
"       58     Problem with the local certificate\n"
"\n"
"       59     Couldn't use specified SSL cipher\n"
"\n"
"       60     Peer certificate cannot be authenticated with known CA  certifi-\n"
"              cates\n"
"\n"
"       61     Unrecognized transfer encoding\n"
"\n"
"       62     Invalid LDAP URL\n"
"\n"
, stdout);
 fputs(
"       63     Maximum file size exceeded\n"
"\n"
"       64     Requested FTP SSL level failed\n"
"\n"
"       65     Sending the data requires a rewind that failed\n"
"\n"
"       66     Failed to initialise SSL Engine\n"
"\n"
"       67     User,  password  or  similar was not accepted and curl failed to\n"
"              login\n"
"\n"
"       68     File not found on TFTP server\n"
"\n"
"       69     Permission problem on TFTP server\n"
"\n"
"       70     Out of disk space on TFTP server\n"
"\n"
"       71     Illegal TFTP operation\n"
"\n"
, stdout);
 fputs(
"       72     Unknown TFTP transfer ID\n"
"\n"
"       73     File already exists (TFTP)\n"
"\n"
"       74     No such user (TFTP)\n"
"\n"
"       75     Character conversion failed\n"
"\n"
"       76     Character conversion functions required\n"
"\n"
"       77     Problem with reading the SSL CA cert (path? access rights?)\n"
"\n"
"       78     The resource referenced in the URL does not exist\n"
"\n"
"       79     An unspecified error occurred during the SSH session\n"
"\n"
"       80     Failed to shut down the SSL connection\n"
"\n"
, stdout);
 fputs(
"       XX     There will appear more error codes here in future releases.  The\n"
"              existing ones are meant to never change.\n"
"\n"
"AUTHORS / CONTRIBUTORS\n"
"       Daniel  Stenberg is the main author, but the whole list of contributors\n"
"       is found in the separate THANKS file.\n"
"\n"
"WWW\n"
"       http://curl.haxx.se\n"
"\n"
"FTP\n"
"       ftp://ftp.sunet.se/pub/www/utilities/curl/\n"
"\n"
"SEE ALSO\n"
"       ftp(1), wget(1)\n"
"\n"
"LATEST VERSION\n"
"\n"
"  You always find news about what's going on as well as the latest versions\n"
, stdout);
 fputs(
"  from the curl web pages, located at:\n"
"\n"
"        http://curl.haxx.se\n"
"\n"
"SIMPLE USAGE\n"
"\n"
"  Get the main page from Netscape's web-server:\n"
"\n"
"        curl http://www.netscape.com/\n"
"\n"
"  Get the README file the user's home directory at funet's ftp-server:\n"
"\n"
"        curl ftp://ftp.funet.fi/README\n"
"\n"
"  Get a web page from a server using port 8000:\n"
"\n"
"        curl http://www.weirdserver.com:8000/\n"
"\n"
"  Get a list of a directory of an FTP site:\n"
"\n"
"        curl ftp://cool.haxx.se/\n"
"\n"
, stdout);
 fputs(
"  Get the definition of curl from a dictionary:\n"
"\n"
"        curl dict://dict.org/m:curl\n"
"\n"
"  Fetch two documents at once:\n"
"\n"
"        curl ftp://cool.haxx.se/ http://www.weirdserver.com:8000/\n"
"\n"
"  Get a file off an FTPS server:\n"
"\n"
"        curl ftps://files.are.secure.com/secrets.txt\n"
"\n"
"  or use the more appropriate FTPS way to get the same file:\n"
"\n"
"        curl --ftp-ssl ftp://files.are.secure.com/secrets.txt\n"
"\n"
"  Get a file from an SSH server using SFTP:\n"
"\n"
, stdout);
 fputs(
"        curl -u username sftp://shell.example.com/etc/issue\n"
"\n"
"  Get a file from an SSH server using SCP using a private key to authenticate:\n"
"\n"
"        curl -u username: --key ~/.ssh/id_dsa --pubkey ~/.ssh/id_dsa.pub \\\n"
"        	scp://shell.example.com/~/personal.txt\n"
"\n"
"\n"
"DOWNLOAD TO A FILE\n"
"\n"
"  Get a web page and store in a local file:\n"
"\n"
"        curl -o thatpage.html http://www.netscape.com/\n"
"\n"
"  Get a web page and store in a local file, make the local file get the name\n"
, stdout);
 fputs(
"  of the remote document (if no file name part is specified in the URL, this\n"
"  will fail):\n"
"\n"
"        curl -O http://www.netscape.com/index.html\n"
"\n"
"  Fetch two files and store them with their remote names:\n"
"\n"
"        curl -O www.haxx.se/index.html -O curl.haxx.se/download.html\n"
"\n"
"USING PASSWORDS\n"
"\n"
" FTP\n"
"\n"
"   To ftp files using name+passwd, include them in the URL like:\n"
"\n"
"        curl ftp://name:passwd@machine.domain:port/full/path/to/file\n"
"\n"
"   or specify them with the -u flag like\n"
"\n"
, stdout);
 fputs(
"        curl -u name:passwd ftp://machine.domain:port/full/path/to/file\n"
"\n"
" FTPS\n"
"\n"
"   It is just like for FTP, but you may also want to specify and use\n"
"   SSL-specific options for certificates etc.\n"
"\n"
"   Note that using FTPS:// as prefix is the \"implicit\" way as described in the\n"
"   standards while the recommended \"explicit\" way is done by using FTP:// and\n"
"   the --ftp-ssl option.\n"
"\n"
" HTTP\n"
"\n"
"   Curl also supports user and password in HTTP URLs, thus you can pick a file\n"
"   like:\n"
"\n"
, stdout);
 fputs(
"        curl http://name:passwd@machine.domain/full/path/to/file\n"
"\n"
"   or specify user and password separately like in\n"
"\n"
"        curl -u name:passwd http://machine.domain/full/path/to/file\n"
"\n"
"   HTTP offers many different methods of authentication and curl supports\n"
"   several: Basic, Digest, NTLM and Negotiate. Without telling which method to\n"
"   use, curl defaults to Basic. You can also ask curl to pick the most secure\n"
"   ones out of the ones that the server accepts for the given URL, by using\n"
, stdout);
 fputs(
"   --anyauth.\n"
"\n"
"   NOTE! Since HTTP URLs don't support user and password, you can't use that\n"
"   style when using Curl via a proxy. You _must_ use the -u style fetch\n"
"   during such circumstances.\n"
"\n"
" HTTPS\n"
"\n"
"   Probably most commonly used with private certificates, as explained below.\n"
"\n"
"PROXY\n"
"\n"
" Get an ftp file using a proxy named my-proxy that uses port 888:\n"
"\n"
"        curl -x my-proxy:888 ftp://ftp.leachsite.com/README\n"
"\n"
" Get a file from a HTTP server that requires user and password, using the\n"
, stdout);
 fputs(
" same proxy as above:\n"
"\n"
"        curl -u user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
" Some proxies require special authentication. Specify by using -U as above:\n"
"\n"
"        curl -U user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
" curl also supports SOCKS4 and SOCKS5 proxies with --socks4 and --socks5.\n"
"\n"
" See also the environment variables Curl support that offer further proxy\n"
" control.\n"
"\n"
"RANGES\n"
"\n"
"  With HTTP 1.1 byte-ranges were introduced. Using this, a client can request\n"
, stdout);
 fputs(
"  to get only one or more subparts of a specified document. Curl supports\n"
"  this with the -r flag.\n"
"\n"
"  Get the first 100 bytes of a document:\n"
"\n"
"        curl -r 0-99 http://www.get.this/\n"
"\n"
"  Get the last 500 bytes of a document:\n"
"\n"
"        curl -r -500 http://www.get.this/\n"
"\n"
"  Curl also supports simple ranges for FTP files as well. Then you can only\n"
"  specify start and stop position.\n"
"\n"
"  Get the first 100 bytes of a document using FTP:\n"
"\n"
"        curl -r 0-99 ftp://www.get.this/README  \n"
"\n"
"UPLOADING\n"
"\n"
" FTP\n"
"\n"
, stdout);
 fputs(
"  Upload all data on stdin to a specified ftp site:\n"
"\n"
"        curl -T - ftp://ftp.upload.com/myfile\n"
"\n"
"  Upload data from a specified file, login with user and password:\n"
"\n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/myfile\n"
"\n"
"  Upload a local file to the remote site, and use the local file name remote\n"
"  too:\n"
" \n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/\n"
"\n"
"  Upload a local file to get appended to the remote file using ftp:\n"
"\n"
, stdout);
 fputs(
"        curl -T localfile -a ftp://ftp.upload.com/remotefile\n"
"\n"
"  Curl also supports ftp upload through a proxy, but only if the proxy is\n"
"  configured to allow that kind of tunneling. If it does, you can run curl in\n"
"  a fashion similar to:\n"
"\n"
"        curl --proxytunnel -x proxy:port -T localfile ftp.upload.com\n"
"\n"
" HTTP\n"
"\n"
"  Upload all data on stdin to a specified http site:\n"
"\n"
"        curl -T - http://www.upload.com/myfile\n"
"\n"
"  Note that the http server must have been configured to accept PUT before\n"
, stdout);
 fputs(
"  this can be done successfully.\n"
"\n"
"  For other ways to do http data upload, see the POST section below.\n"
"\n"
"VERBOSE / DEBUG\n"
"\n"
"  If curl fails where it isn't supposed to, if the servers don't let you in,\n"
"  if you can't understand the responses: use the -v flag to get verbose\n"
"  fetching. Curl will output lots of info and what it sends and receives in\n"
"  order to let the user see all client-server interaction (but it won't show\n"
"  you the actual data).\n"
"\n"
"        curl -v ftp://ftp.upload.com/\n"
"\n"
, stdout);
 fputs(
"  To get even more details and information on what curl does, try using the\n"
"  --trace or --trace-ascii options with a given file name to log to, like\n"
"  this:\n"
"\n"
"        curl --trace trace.txt www.haxx.se\n"
" \n"
"\n"
"DETAILED INFORMATION\n"
"\n"
"  Different protocols provide different ways of getting detailed information\n"
"  about specific files/documents. To get curl to show detailed information\n"
"  about a single file, you should use -I/--head option. It displays all\n"
, stdout);
 fputs(
"  available info on a single file for HTTP and FTP. The HTTP information is a\n"
"  lot more extensive.\n"
"\n"
"  For HTTP, you can get the header information (the same as -I would show)\n"
"  shown before the data by using -i/--include. Curl understands the\n"
"  -D/--dump-header option when getting files from both FTP and HTTP, and it\n"
"  will then store the headers in the specified file.\n"
"\n"
"  Store the HTTP headers in a separate file (headers.txt in the example):\n"
"\n"
, stdout);
 fputs(
"        curl --dump-header headers.txt curl.haxx.se\n"
"\n"
"  Note that headers stored in a separate file can be very useful at a later\n"
"  time if you want curl to use cookies sent by the server. More about that in\n"
"  the cookies section.\n"
"\n"
"POST (HTTP)\n"
"\n"
"  It's easy to post data using curl. This is done using the -d <data>\n"
"  option.  The post data must be urlencoded.\n"
"\n"
"  Post a simple \"name\" and \"phone\" guestbook.\n"
"\n"
"        curl -d \"name=Rafael%20Sagula&phone=3320780\" \\\n"
, stdout);
 fputs(
"                http://www.where.com/guest.cgi\n"
"\n"
"  How to post a form with curl, lesson #1:\n"
"\n"
"  Dig out all the <input> tags in the form that you want to fill in. (There's\n"
"  a perl program called formfind.pl on the curl site that helps with this).\n"
"\n"
"  If there's a \"normal\" post, you use -d to post. -d takes a full \"post\n"
"  string\", which is in the format\n"
"\n"
"        <variable1>=<data1>&<variable2>=<data2>&...\n"
"\n"
"  The 'variable' names are the names set with \"name=\" in the <input> tags, and\n"
, stdout);
 fputs(
"  the data is the contents you want to fill in for the inputs. The data *must*\n"
"  be properly URL encoded. That means you replace space with + and that you\n"
"  write weird letters with %XX where XX is the hexadecimal representation of\n"
"  the letter's ASCII code.\n"
"\n"
"  Example:\n"
"\n"
"  (page located at http://www.formpost.com/getthis/\n"
"\n"
"        <form action=\"post.cgi\" method=\"post\">\n"
"        <input name=user size=10>\n"
"        <input name=pass type=password size=10>\n"
, stdout);
 fputs(
"        <input name=id type=hidden value=\"blablabla\">\n"
"        <input name=ding value=\"submit\">\n"
"        </form>\n"
"\n"
"  We want to enter user 'foobar' with password '12345'.\n"
"\n"
"  To post to this, you enter a curl command line like:\n"
"\n"
"        curl -d \"user=foobar&pass=12345&id=blablabla&ding=submit\"  (continues)\n"
"          http://www.formpost.com/getthis/post.cgi\n"
"\n"
"\n"
"  While -d uses the application/x-www-form-urlencoded mime-type, generally\n"
, stdout);
 fputs(
"  understood by CGI's and similar, curl also supports the more capable\n"
"  multipart/form-data type. This latter type supports things like file upload.\n"
"\n"
"  -F accepts parameters like -F \"name=contents\". If you want the contents to\n"
"  be read from a file, use <@filename> as contents. When specifying a file,\n"
"  you can also specify the file content type by appending ';type=<mime type>'\n"
"  to the file name. You can also post the contents of several files in one\n"
, stdout);
 fputs(
"  field.  For example, the field name 'coolfiles' is used to send three files,\n"
"  with different content types using the following syntax:\n"
"\n"
"        curl -F \"coolfiles=@fil1.gif;type=image/gif,fil2.txt,fil3.html\" \\\n"
"        http://www.post.com/postit.cgi\n"
"\n"
"  If the content-type is not specified, curl will try to guess from the file\n"
"  extension (it only knows a few), or use the previously specified type (from\n"
"  an earlier file if several files are specified in a list) or else it will\n"
, stdout);
 fputs(
"  using the default type 'text/plain'.\n"
"\n"
"  Emulate a fill-in form with -F. Let's say you fill in three fields in a\n"
"  form. One field is a file name which to post, one field is your name and one\n"
"  field is a file description. We want to post the file we have written named\n"
"  \"cooltext.txt\". To let curl do the posting of this data instead of your\n"
"  favourite browser, you have to read the HTML source of the form page and\n"
"  find the names of the input fields. In our example, the input field names\n"
, stdout);
 fputs(
"  are 'file', 'yourname' and 'filedescription'.\n"
"\n"
"        curl -F \"file=@cooltext.txt\" -F \"yourname=Daniel\" \\\n"
"             -F \"filedescription=Cool text file with cool text inside\" \\\n"
"             http://www.post.com/postit.cgi\n"
"\n"
"  To send two files in one post you can do it in two ways:\n"
"\n"
"  1. Send multiple files in a single \"field\" with a single field name:\n"
" \n"
"        curl -F \"pictures=@dog.gif,cat.gif\" \n"
" \n"
"  2. Send two fields with two field names: \n"
"\n"
, stdout);
 fputs(
"        curl -F \"docpicture=@dog.gif\" -F \"catpicture=@cat.gif\" \n"
"\n"
"  To send a field value literally without interpreting a leading '@'\n"
"  or '<', or an embedded ';type=', use --form-string instead of\n"
"  -F. This is recommended when the value is obtained from a user or\n"
"  some other unpredictable source. Under these circumstances, using\n"
"  -F instead of --form-string would allow a user to trick curl into\n"
"  uploading a file.\n"
"\n"
"REFERRER\n"
"\n"
, stdout);
 fputs(
"  A HTTP request has the option to include information about which address\n"
"  that referred to actual page.  Curl allows you to specify the\n"
"  referrer to be used on the command line. It is especially useful to\n"
"  fool or trick stupid servers or CGI scripts that rely on that information\n"
"  being available or contain certain data.\n"
"\n"
"        curl -e www.coolsite.com http://www.showme.com/\n"
"\n"
"  NOTE: The referer field is defined in the HTTP spec to be a full URL.\n"
"\n"
"USER AGENT\n"
"\n"
, stdout);
 fputs(
"  A HTTP request has the option to include information about the browser\n"
"  that generated the request. Curl allows it to be specified on the command\n"
"  line. It is especially useful to fool or trick stupid servers or CGI\n"
"  scripts that only accept certain browsers.\n"
"\n"
"  Example:\n"
"\n"
"  curl -A 'Mozilla/3.0 (Win95; I)' http://www.nationsbank.com/\n"
"\n"
"  Other common strings:\n"
"    'Mozilla/3.0 (Win95; I)'     Netscape Version 3 for Windows 95\n"
"    'Mozilla/3.04 (Win95; U)'    Netscape Version 3 for Windows 95\n"
, stdout);
 fputs(
"    'Mozilla/2.02 (OS/2; U)'     Netscape Version 2 for OS/2\n"
"    'Mozilla/4.04 [en] (X11; U; AIX 4.2; Nav)'           NS for AIX\n"
"    'Mozilla/4.05 [en] (X11; U; Linux 2.0.32 i586)'      NS for Linux\n"
"\n"
"  Note that Internet Explorer tries hard to be compatible in every way:\n"
"    'Mozilla/4.0 (compatible; MSIE 4.01; Windows 95)'    MSIE for W95\n"
"\n"
"  Mozilla is not the only possible User-Agent name:\n"
"    'Konqueror/1.0'             KDE File Manager desktop client\n"
, stdout);
 fputs(
"    'Lynx/2.7.1 libwww-FM/2.14' Lynx command line browser\n"
"\n"
"COOKIES\n"
"\n"
"  Cookies are generally used by web servers to keep state information at the\n"
"  client's side. The server sets cookies by sending a response line in the\n"
"  headers that looks like 'Set-Cookie: <data>' where the data part then\n"
"  typically contains a set of NAME=VALUE pairs (separated by semicolons ';'\n"
"  like \"NAME1=VALUE1; NAME2=VALUE2;\"). The server can also specify for what\n"
, stdout);
 fputs(
"  path the \"cookie\" should be used for (by specifying \"path=value\"), when the\n"
"  cookie should expire (\"expire=DATE\"), for what domain to use it\n"
"  (\"domain=NAME\") and if it should be used on secure connections only\n"
"  (\"secure\").\n"
"\n"
"  If you've received a page from a server that contains a header like:\n"
"        Set-Cookie: sessionid=boo123; path=\"/foo\";\n"
"\n"
"  it means the server wants that first pair passed on when we get anything in\n"
"  a path beginning with \"/foo\".\n"
"\n"
, stdout);
 fputs(
"  Example, get a page that wants my name passed in a cookie:\n"
"\n"
"        curl -b \"name=Daniel\" www.sillypage.com\n"
"\n"
"  Curl also has the ability to use previously received cookies in following\n"
"  sessions. If you get cookies from a server and store them in a file in a\n"
"  manner similar to:\n"
"\n"
"        curl --dump-header headers www.example.com\n"
"\n"
"  ... you can then in a second connect to that (or another) site, use the\n"
"  cookies from the 'headers' file like:\n"
"\n"
"        curl -b headers www.example.com\n"
"\n"
, stdout);
 fputs(
"  While saving headers to a file is a working way to store cookies, it is\n"
"  however error-prone and not the preferred way to do this. Instead, make curl\n"
"  save the incoming cookies using the well-known netscape cookie format like\n"
"  this:\n"
"\n"
"        curl -c cookies.txt www.example.com\n"
"\n"
"  Note that by specifying -b you enable the \"cookie awareness\" and with -L\n"
"  you can make curl follow a location: (which often is used in combination\n"
, stdout);
 fputs(
"  with cookies). So that if a site sends cookies and a location, you can\n"
"  use a non-existing file to trigger the cookie awareness like:\n"
"\n"
"        curl -L -b empty.txt www.example.com\n"
"\n"
"  The file to read cookies from must be formatted using plain HTTP headers OR\n"
"  as netscape's cookie file. Curl will determine what kind it is based on the\n"
"  file contents.  In the above command, curl will parse the header and store\n"
"  the cookies received from www.example.com.  curl will send to the server the\n"
, stdout);
 fputs(
"  stored cookies which match the request as it follows the location.  The\n"
"  file \"empty.txt\" may be a nonexistent file.\n"
"\n"
"  Alas, to both read and write cookies from a netscape cookie file, you can\n"
"  set both -b and -c to use the same file:\n"
"\n"
"        curl -b cookies.txt -c cookies.txt www.example.com\n"
"\n"
"PROGRESS METER\n"
"\n"
"  The progress meter exists to show a user that something actually is\n"
"  happening. The different fields in the output have the following meaning:\n"
"\n"
, stdout);
 fputs(
"  % Total    % Received % Xferd  Average Speed          Time             Curr.\n"
"                                 Dload  Upload Total    Current  Left    Speed\n"
"  0  151M    0 38608    0     0   9406      0  4:41:43  0:00:04  4:41:39  9287\n"
"\n"
"  From left-to-right:\n"
"   %             - percentage completed of the whole transfer\n"
"   Total         - total size of the whole expected transfer\n"
"   %             - percentage completed of the download\n"
"   Received      - currently downloaded amount of bytes\n"
, stdout);
 fputs(
"   %             - percentage completed of the upload\n"
"   Xferd         - currently uploaded amount of bytes\n"
"   Average Speed\n"
"   Dload         - the average transfer speed of the download\n"
"   Average Speed\n"
"   Upload        - the average transfer speed of the upload\n"
"   Time Total    - expected time to complete the operation\n"
"   Time Current  - time passed since the invoke\n"
"   Time Left     - expected time left to completion\n"
"   Curr.Speed    - the average transfer speed the last 5 seconds (the first\n"
, stdout);
 fputs(
"                   5 seconds of a transfer is based on less time of course.)\n"
"\n"
"  The -# option will display a totally different progress bar that doesn't\n"
"  need much explanation!\n"
"\n"
"SPEED LIMIT\n"
"\n"
"  Curl allows the user to set the transfer speed conditions that must be met\n"
"  to let the transfer keep going. By using the switch -y and -Y you\n"
"  can make curl abort transfers if the transfer speed is below the specified\n"
"  lowest limit for a specified time.\n"
"\n"
, stdout);
 fputs(
"  To have curl abort the download if the speed is slower than 3000 bytes per\n"
"  second for 1 minute, run:\n"
"\n"
"        curl -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  This can very well be used in combination with the overall time limit, so\n"
"  that the above operation must be completed in whole within 30 minutes:\n"
"\n"
"        curl -m 1800 -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  Forcing curl not to transfer data faster than a given rate is also possible,\n"
, stdout);
 fputs(
"  which might be useful if you're using a limited bandwidth connection and you\n"
"  don't want your transfer to use all of it (sometimes referred to as\n"
"  \"bandwidth throttle\").\n"
"\n"
"  Make curl transfer data no faster than 10 kilobytes per second:\n"
"\n"
"        curl --limit-rate 10K www.far-away-site.com\n"
"\n"
"    or\n"
"\n"
"        curl --limit-rate 10240 www.far-away-site.com\n"
"\n"
"  Or prevent curl from uploading data faster than 1 megabyte per second:\n"
"\n"
"        curl -T upload --limit-rate 1M ftp://uploadshereplease.com\n"
"\n"
, stdout);
 fputs(
"  When using the --limit-rate option, the transfer rate is regulated on a\n"
"  per-second basis, which will cause the total transfer speed to become lower\n"
"  than the given number. Sometimes of course substantially lower, if your\n"
"  transfer stalls during periods.\n"
"\n"
"CONFIG FILE\n"
"\n"
"  Curl automatically tries to read the .curlrc file (or _curlrc file on win32\n"
"  systems) from the user's home dir on startup.\n"
"\n"
"  The config file could be made up with normal command line switches, but you\n"
, stdout);
 fputs(
"  can also specify the long options without the dashes to make it more\n"
"  readable. You can separate the options and the parameter with spaces, or\n"
"  with = or :. Comments can be used within the file. If the first letter on a\n"
"  line is a '#'-letter the rest of the line is treated as a comment.\n"
"\n"
"  If you want the parameter to contain spaces, you must inclose the entire\n"
"  parameter within double quotes (\"). Within those quotes, you specify a\n"
"  quote as \\\".\n"
"\n"
, stdout);
 fputs(
"  NOTE: You must specify options and their arguments on the same line.\n"
"\n"
"  Example, set default time out and proxy in a config file:\n"
"\n"
"        # We want a 30 minute timeout:\n"
"        -m 1800\n"
"        # ... and we use a proxy for all accesses:\n"
"        proxy = proxy.our.domain.com:8080\n"
"\n"
"  White spaces ARE significant at the end of lines, but all white spaces\n"
"  leading up to the first characters of each line are ignored.\n"
"\n"
"  Prevent curl from reading the default file by using -q as the first command\n"
, stdout);
 fputs(
"  line parameter, like:\n"
"\n"
"        curl -q www.thatsite.com\n"
"\n"
"  Force curl to get and display a local help page in case it is invoked\n"
"  without URL by making a config file similar to:\n"
"\n"
"        # default url to get\n"
"        url = \"http://help.with.curl.com/curlhelp.html\"\n"
"\n"
"  You can specify another config file to be read by using the -K/--config\n"
"  flag. If you set config file name to \"-\" it'll read the config from stdin,\n"
"  which can be handy if you want to hide options from being visible in process\n"
, stdout);
 fputs(
"  tables etc:\n"
"\n"
"        echo \"user = user:passwd\" | curl -K - http://that.secret.site.com\n"
"\n"
"EXTRA HEADERS\n"
"\n"
"  When using curl in your own very special programs, you may end up needing\n"
"  to pass on your own custom headers when getting a web page. You can do\n"
"  this by using the -H flag.\n"
"\n"
"  Example, send the header \"X-you-and-me: yes\" to the server when getting a\n"
"  page:\n"
"\n"
"        curl -H \"X-you-and-me: yes\" www.love.com\n"
"\n"
"  This can also be useful in case you want curl to send a different text in a\n"
, stdout);
 fputs(
"  header than it normally does. The -H header you specify then replaces the\n"
"  header curl would normally send. If you replace an internal header with an\n"
"  empty one, you prevent that header from being sent. To prevent the Host:\n"
"  header from being used:\n"
"\n"
"        curl -H \"Host:\" www.server.com\n"
"\n"
"FTP and PATH NAMES\n"
"\n"
"  Do note that when getting files with the ftp:// URL, the given path is\n"
"  relative the directory you enter. To get the file 'README' from your home\n"
"  directory at your ftp site, do:\n"
"\n"
, stdout);
 fputs(
"        curl ftp://user:passwd@my.site.com/README\n"
"\n"
"  But if you want the README file from the root directory of that very same\n"
"  site, you need to specify the absolute file name:\n"
"\n"
"        curl ftp://user:passwd@my.site.com//README\n"
"\n"
"  (I.e with an extra slash in front of the file name.)\n"
"\n"
"FTP and firewalls\n"
"\n"
"  The FTP protocol requires one of the involved parties to open a second\n"
"  connction as soon as data is about to get transfered. There are two ways to\n"
"  do this.\n"
"\n"
, stdout);
 fputs(
"  The default way for curl is to issue the PASV command which causes the\n"
"  server to open another port and await another connection performed by the\n"
"  client. This is good if the client is behind a firewall that don't allow\n"
"  incoming connections.\n"
"\n"
"        curl ftp.download.com\n"
"\n"
"  If the server for example, is behind a firewall that don't allow connections\n"
"  on other ports than 21 (or if it just doesn't support the PASV command), the\n"
, stdout);
 fputs(
"  other way to do it is to use the PORT command and instruct the server to\n"
"  connect to the client on the given (as parameters to the PORT command) IP\n"
"  number and port.\n"
"\n"
"  The -P flag to curl supports a few different options. Your machine may have\n"
"  several IP-addresses and/or network interfaces and curl allows you to select\n"
"  which of them to use. Default address can also be used:\n"
"\n"
"        curl -P - ftp.download.com\n"
"\n"
, stdout);
 fputs(
"  Download with PORT but use the IP address of our 'le0' interface (this does\n"
"  not work on windows):\n"
"\n"
"        curl -P le0 ftp.download.com\n"
"\n"
"  Download with PORT but use 192.168.0.10 as our IP address to use:\n"
"\n"
"        curl -P 192.168.0.10 ftp.download.com\n"
"\n"
"NETWORK INTERFACE\n"
"\n"
"  Get a web page from a server using a specified port for the interface:\n"
"\n"
"        curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"  or\n"
"\n"
"        curl --interface 192.168.1.10 http://www.netscape.com/\n"
"\n"
"HTTPS\n"
"\n"
, stdout);
 fputs(
"  Secure HTTP requires SSL libraries to be installed and used when curl is\n"
"  built. If that is done, curl is capable of retrieving and posting documents\n"
"  using the HTTPS protocol.\n"
"\n"
"  Example:\n"
"\n"
"        curl https://www.secure-site.com\n"
"\n"
"  Curl is also capable of using your personal certificates to get/post files\n"
"  from sites that require valid certificates. The only drawback is that the\n"
"  certificate needs to be in PEM-format. PEM is a standard and open format to\n"
, stdout);
 fputs(
"  store certificates with, but it is not used by the most commonly used\n"
"  browsers (Netscape and MSIE both use the so called PKCS#12 format). If you\n"
"  want curl to use the certificates you use with your (favourite) browser, you\n"
"  may need to download/compile a converter that can convert your browser's\n"
"  formatted certificates to PEM formatted ones. This kind of converter is\n"
"  included in recent versions of OpenSSL, and for older versions Dr Stephen\n"
, stdout);
 fputs(
"  N. Henson has written a patch for SSLeay that adds this functionality. You\n"
"  can get his patch (that requires an SSLeay installation) from his site at:\n"
"  http://www.drh-consultancy.demon.co.uk/\n"
"\n"
"  Example on how to automatically retrieve a document using a certificate with\n"
"  a personal password:\n"
"\n"
"        curl -E /path/to/cert.pem:password https://secure.site.com/\n"
"\n"
"  If you neglect to specify the password on the command line, you will be\n"
, stdout);
 fputs(
"  prompted for the correct password before any data can be received.\n"
"\n"
"  Many older SSL-servers have problems with SSLv3 or TLS, that newer versions\n"
"  of OpenSSL etc is using, therefore it is sometimes useful to specify what\n"
"  SSL-version curl should use. Use -3, -2 or -1 to specify that exact SSL\n"
"  version to use (for SSLv3, SSLv2 or TLSv1 respectively):\n"
"\n"
"        curl -2 https://secure.site.com/\n"
"\n"
"  Otherwise, curl will first attempt to use v3 and then v2.\n"
"\n"
, stdout);
 fputs(
"  To use OpenSSL to convert your favourite browser's certificate into a PEM\n"
"  formatted one that curl can use, do something like this (assuming netscape,\n"
"  but IE is likely to work similarly):\n"
"\n"
"    You start with hitting the 'security' menu button in netscape. \n"
"\n"
"    Select 'certificates->yours' and then pick a certificate in the list \n"
"\n"
"    Press the 'export' button \n"
"\n"
"    enter your PIN code for the certs \n"
"\n"
"    select a proper place to save it \n"
"\n"
, stdout);
 fputs(
"    Run the 'openssl' application to convert the certificate. If you cd to the\n"
"    openssl installation, you can do it like:\n"
"\n"
"     # ./apps/openssl pkcs12 -in [file you saved] -clcerts -out [PEMfile]\n"
"\n"
"\n"
"RESUMING FILE TRANSFERS\n"
"\n"
" To continue a file transfer where it was previously aborted, curl supports\n"
" resume on http(s) downloads as well as ftp uploads and downloads.\n"
"\n"
" Continue downloading a document:\n"
"\n"
"        curl -C - -o file ftp://ftp.server.com/path/file\n"
"\n"
" Continue uploading a document(*1):\n"
, stdout);
 fputs(
"\n"
"        curl -C - -T file ftp://ftp.server.com/path/file\n"
"\n"
" Continue downloading a document from a web server(*2):\n"
"\n"
"        curl -C - -o file http://www.server.com/\n"
"\n"
" (*1) = This requires that the ftp server supports the non-standard command\n"
"        SIZE. If it doesn't, curl will say so.\n"
"\n"
" (*2) = This requires that the web server supports at least HTTP/1.1. If it\n"
"        doesn't, curl will say so.\n"
"\n"
"TIME CONDITIONS\n"
"\n"
" HTTP allows a client to specify a time condition for the document it\n"
, stdout);
 fputs(
" requests. It is If-Modified-Since or If-Unmodified-Since. Curl allow you to\n"
" specify them with the -z/--time-cond flag.\n"
"\n"
" For example, you can easily make a download that only gets performed if the\n"
" remote file is newer than a local copy. It would be made like:\n"
"\n"
"        curl -z local.html http://remote.server.com/remote.html\n"
"\n"
" Or you can download a file only if the local file is newer than the remote\n"
" one. Do this by prepending the date string with a '-', as in:\n"
"\n"
, stdout);
 fputs(
"        curl -z -local.html http://remote.server.com/remote.html\n"
"\n"
" You can specify a \"free text\" date as condition. Tell curl to only download\n"
" the file if it was updated since January 12, 2012:\n"
"\n"
"        curl -z \"Jan 12 2012\" http://remote.server.com/remote.html\n"
"\n"
" Curl will then accept a wide range of date formats. You always make the date\n"
" check the other way around by prepending it with a dash '-'.\n"
"\n"
"DICT\n"
"\n"
"  For fun try\n"
"\n"
"        curl dict://dict.org/m:curl\n"
, stdout);
 fputs(
"        curl dict://dict.org/d:heisenbug:jargon\n"
"        curl dict://dict.org/d:daniel:web1913\n"
"\n"
"  Aliases for 'm' are 'match' and 'find', and aliases for 'd' are 'define'\n"
"  and 'lookup'. For example,\n"
"\n"
"        curl dict://dict.org/find:curl\n"
"\n"
"  Commands that break the URL description of the RFC (but not the DICT\n"
"  protocol) are\n"
"\n"
"        curl dict://dict.org/show:db\n"
"        curl dict://dict.org/show:strat\n"
"\n"
"  Authentication is still missing (but this is not required by the RFC)\n"
"\n"
"LDAP\n"
"\n"
, stdout);
 fputs(
"  If you have installed the OpenLDAP library, curl can take advantage of it\n"
"  and offer ldap:// support.\n"
"\n"
"  LDAP is a complex thing and writing an LDAP query is not an easy task. I do\n"
"  advice you to dig up the syntax description for that elsewhere. Two places\n"
"  that might suit you are:\n"
"\n"
"  Netscape's \"Netscape Directory SDK 3.0 for C Programmer's Guide Chapter 10:\n"
"  Working with LDAP URLs\":\n"
"  http://developer.netscape.com/docs/manuals/dirsdk/csdk30/url.htm\n"
"\n"
, stdout);
 fputs(
"  RFC 2255, \"The LDAP URL Format\" http://curl.haxx.se/rfc/rfc2255.txt\n"
"\n"
"  To show you an example, this is now I can get all people from my local LDAP\n"
"  server that has a certain sub-domain in their email address:\n"
"\n"
"        curl -B \"ldap://ldap.frontec.se/o=frontec??sub?mail=*sth.frontec.se\"\n"
"\n"
"  If I want the same info in HTML format, I can get it by not using the -B\n"
"  (enforce ASCII) flag.\n"
"\n"
"ENVIRONMENT VARIABLES\n"
"\n"
"  Curl reads and understands the following environment variables:\n"
"\n"
, stdout);
 fputs(
"        http_proxy, HTTPS_PROXY, FTP_PROXY\n"
"\n"
"  They should be set for protocol-specific proxies. General proxy should be\n"
"  set with\n"
"        \n"
"        ALL_PROXY\n"
"\n"
"  A comma-separated list of host names that shouldn't go through any proxy is\n"
"  set in (only an asterisk, '*' matches all hosts)\n"
"\n"
"        NO_PROXY\n"
"\n"
"  If a tail substring of the domain-path for a host matches one of these\n"
"  strings, transactions with that node will not be proxied.\n"
"\n"
"\n"
, stdout);
 fputs(
"  The usage of the -x/--proxy flag overrides the environment variables.\n"
"\n"
"NETRC\n"
"\n"
"  Unix introduced the .netrc concept a long time ago. It is a way for a user\n"
"  to specify name and password for commonly visited ftp sites in a file so\n"
"  that you don't have to type them in each time you visit those sites. You\n"
"  realize this is a big security risk if someone else gets hold of your\n"
"  passwords, so therefore most unix programs won't read this file unless it is\n"
, stdout);
 fputs(
"  only readable by yourself (curl doesn't care though).\n"
"\n"
"  Curl supports .netrc files if told so (using the -n/--netrc and\n"
"  --netrc-optional options). This is not restricted to only ftp,\n"
"  but curl can use it for all protocols where authentication is used.\n"
"\n"
"  A very simple .netrc file could look something like:\n"
"\n"
"        machine curl.haxx.se login iamdaniel password mysecret\n"
"\n"
"CUSTOM OUTPUT\n"
"\n"
"  To better allow script programmers to get to know about the progress of\n"
, stdout);
 fputs(
"  curl, the -w/--write-out option was introduced. Using this, you can specify\n"
"  what information from the previous transfer you want to extract.\n"
"\n"
"  To display the amount of bytes downloaded together with some text and an\n"
"  ending newline:\n"
"\n"
"        curl -w 'We downloaded %{size_download} bytes\\n' www.download.com\n"
"\n"
"KERBEROS FTP TRANSFER\n"
"\n"
"  Curl supports kerberos4 and kerberos5/GSSAPI for FTP transfers. You need\n"
"  the kerberos package installed and used at curl build time for it to be\n"
"  used.\n"
"\n"
, stdout);
 fputs(
"  First, get the krb-ticket the normal way, like with the kinit/kauth tool.\n"
"  Then use curl in way similar to:\n"
"\n"
"        curl --krb private ftp://krb4site.com -u username:fakepwd\n"
"\n"
"  There's no use for a password on the -u switch, but a blank one will make\n"
"  curl ask for one and you already entered the real password to kinit/kauth.\n"
"\n"
"TELNET\n"
"\n"
"  The curl telnet support is basic and very easy to use. Curl passes all data\n"
"  passed to it on stdin to the remote server. Connect to a remote telnet\n"
, stdout);
 fputs(
"  server using a command line similar to:\n"
"\n"
"        curl telnet://remote.server.com\n"
"\n"
"  And enter the data to pass to the server on stdin. The result will be sent\n"
"  to stdout or to the file you specify with -o.\n"
"\n"
"  You might want the -N/--no-buffer option to switch off the buffered output\n"
"  for slow connections or similar.\n"
"\n"
"  Pass options to the telnet protocol negotiation, by using the -t option. To\n"
"  tell the server we use a vt100 terminal, try something like:\n"
"\n"
, stdout);
 fputs(
"        curl -tTTYPE=vt100 telnet://remote.server.com\n"
"\n"
"  Other interesting options for it -t include:\n"
"\n"
"   - XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"   - NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"  NOTE: the telnet protocol does not specify any way to login with a specified\n"
"  user and password so curl can't do that automatically. To do that, you need\n"
"  to track when the login prompt is received and send the username and\n"
"  password accordingly.\n"
"\n"
"PERSISTENT CONNECTIONS\n"
"\n"
, stdout);
 fputs(
"  Specifying multiple files on a single command line will make curl transfer\n"
"  all of them, one after the other in the specified order.\n"
"\n"
"  libcurl will attempt to use persistent connections for the transfers so that\n"
"  the second transfer to the same host can use the same connection that was\n"
"  already initiated and was left open in the previous transfer. This greatly\n"
"  decreases connection time for all but the first transfer and it makes a far\n"
"  better use of the network.\n"
"\n"
, stdout);
 fputs(
"  Note that curl cannot use persistent connections for transfers that are used\n"
"  in subsequence curl invokes. Try to stuff as many URLs as possible on the\n"
"  same command line if they are using the same host, as that'll make the\n"
"  transfers faster. If you use a http proxy for file transfers, practically\n"
"  all transfers will be persistent.\n"
"\n"
"MULTIPLE TRANSFERS WITH A SINGLE COMMAND LINE\n"
"\n"
"  As is mentioned above, you can download multiple files with one command line\n"
, stdout);
 fputs(
"  by simply adding more URLs. If you want those to get saved to a local file\n"
"  instead of just printed to stdout, you need to add one save option for each\n"
"  URL you specify. Note that this also goes for the -O option.\n"
"\n"
"  For example: get two files and use -O for the first and a custom file\n"
"  name for the second:\n"
"\n"
"    curl -O http://url.com/file.txt ftp://ftp.com/moo.exe -o moo.jpg\n"
"\n"
"  You can also upload multiple files in a similar fashion:\n"
"\n"
, stdout);
 fputs(
"    curl -T local1 ftp://ftp.com/moo.exe -T local2 ftp://ftp.com/moo2.txt\n"
"\n"
"MAILING LISTS\n"
"\n"
"  For your convenience, we have several open mailing lists to discuss curl,\n"
"  its development and things relevant to this. Get all info at\n"
"  http://curl.haxx.se/mail/. Some of the lists available are:\n"
"\n"
"  curl-users\n"
"\n"
"    Users of the command line tool. How to use it, what doesn't work, new\n"
"    features, related tools, questions, news, installations, compilations,\n"
"    running, porting etc.\n"
"\n"
"  curl-library\n"
"\n"
, stdout);
 fputs(
"    Developers using or developing libcurl. Bugs, extensions, improvements.\n"
"\n"
"  curl-announce\n"
"\n"
"    Low-traffic. Only receives announcements of new public versions. At worst,\n"
"    that makes something like one or two mails per month, but usually only one\n"
"    mail every second month.\n"
"\n"
"  curl-and-php\n"
"\n"
"    Using the curl functions in PHP. Everything curl with a PHP angle. Or PHP\n"
"    with a curl angle.\n"
"\n"
"  curl-and-python\n"
"\n"
"    Python hackers using curl with or without the python binding pycurl.\n"
"\n"
, stdout);
 fputs(
"  Please direct curl questions, feature requests and trouble reports to one of\n"
"  these mailing lists instead of mailing any individual.\n"
, stdout) ;
}
#endif /* USE_MANUAL */
#else
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Fri Jan 25 23:44:31 2008
 */
#include "setup.h"
#ifdef USE_MANUAL
#include "hugehelp.h"
#include <stdio.h>
#include <zlib.h>
static const unsigned char hugehelpgz[] = {
  /* This mumbo-jumbo is the huge help text compressed with gzip.
     Thanks to this operation, the size of this data shrunk from 121433
     to 36910 bytes. You can disable the use of compressed help
     texts by NOT passing -c to the mkhelp.pl tool. */
  0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0xed, 0xbd,
  0x69, 0x77, 0x1b, 0xc7, 0xb5, 0x2e, 0xfc, 0xf9, 0xe5, 0xaf, 0xe8, 0xc0,
  0x2b, 0x01, 0x99, 0x00, 0xe0, 0x20, 0xc9, 0xb6, 0x14, 0xc9, 0x31, 0x4d,
  0x52, 0x36, 0xaf, 0x29, 0x91, 0x97, 0xa0, 0x3c, 0x5c, 0xdb, 0x4b, 0xab,
  0x01, 0x34, 0xc9, 0x0e, 0x01, 0x34, 0xd2, 0xdd, 0x20, 0x89, 0xe4, 0xe4,
  0xfe, 0xf6, 0xbb, 0x9f, 0x3d, 0x54, 0x55, 0x0f, 0xa0, 0x68, 0xc7, 0x4e,
  0xee, 0xf0, 0xe6, 0x1c, 0x8b, 0x24, 0xd0, 0x5d, 0xe3, 0xae, 0x5d, 0x7b,
  0x7c, 0x76, 0x14, 0x7d, 0xe8, 0x7f, 0xef, 0xf9, 0xbf, 0xf7, 0xf4, 0x3f,
  0xf9, 0x3d, 0x8a, 0x36, 0xa2, 0xe8, 0x2c, 0xcf, 0xfe, 0x9a, 0x8c, 0xcb,
  0xf6, 0x17, 0xde, 0xbf, 0xff, 0xaf, 0x48, 0xfe, 0x8f, 0x5e, 0xf8, 0x91,
  0x7f, 0xf2, 0x4b, 0x0f, 0xfc, 0x6f, 0x3b, 0xf2, 0x2f, 0xfd, 0xd7, 0xfb,
  0xad, 0xe8, 0x31, 0x2f, 0xfd, 0x57, 0xb4, 0xc9, 0x2f, 0xbd, 0xd7, 0x9e,
  0x5e, 0xe2, 0x77, 0x1a, 0xe5, 0xc3, 0x3d, 0xfd, 0x88, 0xe1, 0xe1, 0x9f,
  0x6d, 0xbc, 0xf8, 0xe3, 0x7b, 0xfc, 0x4a, 0x9f, 0x6c, 0x6c, 0xbc, 0xdd,
  0x7f, 0x73, 0x64, 0xaf, 0x8e, 0x97, 0xf9, 0x34, 0xea, 0x47, 0x65, 0x1e,
  0xcf, 0x8b, 0xcb, 0x24, 0x8f, 0xe2, 0xe8, 0xdd, 0xf9, 0xc9, 0xc6, 0xc6,
  0xf0, 0xfb, 0xb7, 0xa7, 0x67, 0xc3, 0xe3, 0x61, 0xe5, 0xb1, 0x1f, 0xb2,
  0x45, 0x99, 0x66, 0xf3, 0xe2, 0xa7, 0xe8, 0x07, 0x7a, 0x68, 0x30, 0x18,
  0xfc, 0xb4, 0xb1, 0x71, 0x78, 0x34, 0x3c, 0x38, 0x3f, 0x3e, 0xbb, 0x38,
  0x3e, 0x7d, 0x5b, 0x79, 0x36, 0x4a, 0x8b, 0x88, 0x1a, 0x2b, 0xb3, 0x6c,
  0x4a, 0xff, 0xf8, 0xf6, 0x27, 0x71, 0x19, 0x47, 0x97, 0x79, 0x36, 0x8b,
  0xb2, 0x1c, 0x5f, 0xc4, 0x51, 0x91, 0xe4, 0xb7, 0x49, 0xde, 0x8b, 0x96,
  0x45, 0x3a, 0xbf, 0x8a, 0xb2, 0x79, 0x12, 0x65, 0x97, 0x51, 0x79, 0x9d,
  0x58, 0x73, 0xc5, 0x72, 0xb1, 0xc8, 0xf2, 0x32, 0x99, 0x44, 0x8b, 0x3c,
  0x2b, 0xb3, 0x71, 0x36, 0x2d, 0xa2, 0xcd, 0xaf, 0x2e, 0x2e, 0xce, 0x7a,
  0x11, 0xfe, 0x1d, 0xf6, 0xa2, 0xd7, 0xf8, 0xfd, 0x35, 0xff, 0x1a, 0x0d,
  0x0f, 0xce, 0xf0, 0x2f, 0x7f, 0x14, 0x5d, 0xc8, 0x8f, 0xc3, 0xe3, 0x83,
  0x8b, 0x9e, 0x35, 0x77, 0x71, 0x74, 0xf2, 0xf6, 0xe8, 0x82, 0x3e, 0x3d,
  0x39, 0xdc, 0x3f, 0x8b, 0x30, 0x8a, 0xe8, 0xf5, 0xf1, 0xc9, 0xd1, 0xd6,
  0x80, 0xbe, 0xba, 0x4e, 0xa2, 0x71, 0x36, 0x9b, 0xc5, 0xf3, 0x09, 0x86,
  0x3f, 0x49, 0x8a, 0xf4, 0x6a, 0x4e, 0xfd, 0xd2, 0x30, 0xef, 0xb2, 0xfc,
  0x26, 0xba, 0x4b, 0xcb, 0xeb, 0x6c, 0x59, 0xd2, 0x48, 0x93, 0xdc, 0x9a,
  0x4b, 0xe7, 0x65, 0x92, 0xc7, 0x63, 0xac, 0xcb, 0x60, 0xa3, 0xb2, 0x02,
  0xd9, 0x25, 0xcd, 0xb7, 0xa0, 0x09, 0x8e, 0x96, 0xc5, 0x34, 0x8b, 0x27,
  0x98, 0x16, 0xbd, 0x79, 0xb9, 0xa4, 0x05, 0xc9, 0xd3, 0xf1, 0x4d, 0x11,
  0x4d, 0xd3, 0x9b, 0x04, 0x93, 0xba, 0x5f, 0xd9, 0x24, 0x7b, 0xdc, 0x76,
  0x14, 0x2f, 0x69, 0xfe, 0xf3, 0xbe, 0x35, 0x57, 0xa6, 0xe3, 0x18, 0x1d,
  0xd0, 0xa0, 0x2f, 0xcb, 0x45, 0xb4, 0x5c, 0xa0, 0x39, 0x99, 0x7d, 0xb4,
  0xc8, 0x0a, 0x7a, 0x6b, 0x38, 0x3c, 0xa1, 0x91, 0xcf, 0xe7, 0x09, 0x0f,
  0xa4, 0xe8, 0xd1, 0x1f, 0xd9, 0x4d, 0x9a, 0xd0, 0x2f, 0x97, 0xe9, 0x34,
  0x91, 0xd5, 0x77, 0xcd, 0x61, 0x1b, 0xf2, 0xa4, 0x58, 0xce, 0x92, 0x08,
  0x33, 0x9d, 0x65, 0x79, 0x32, 0x88, 0xf6, 0x8b, 0x68, 0x95, 0x2d, 0x69,
  0x8a, 0xd3, 0x29, 0xed, 0x48, 0x12, 0x8d, 0x92, 0x69, 0x76, 0xd7, 0xc3,
  0x3e, 0x44, 0xf3, 0xe5, 0x6c, 0x44, 0xaf, 0xd0, 0xf0, 0x2f, 0x93, 0xb8,
  0x5c, 0xd2, 0xab, 0xfc, 0x98, 0x35, 0x37, 0x8b, 0x69, 0x16, 0xf4, 0x6e,
  0x1e, 0x5d, 0x27, 0x34, 0xcb, 0x62, 0x91, 0xce, 0x7f, 0xb7, 0xd1, 0xa4,
  0x85, 0x45, 0x76, 0x97, 0xe4, 0xb4, 0x98, 0xd1, 0x68, 0x15, 0xd1, 0xcc,
  0x47, 0xf2, 0xcd, 0x25, 0xd6, 0x3f, 0x9e, 0x4e, 0x1d, 0x81, 0xf4, 0xf3,
  0x64, 0x1a, 0x63, 0xb3, 0xad, 0xaf, 0x41, 0x34, 0x4c, 0x1c, 0x2d, 0xe8,
  0x7b, 0x9b, 0x4f, 0xb6, 0xf8, 0xcd, 0x49, 0x52, 0xc6, 0xe9, 0xb4, 0xa0,
  0x85, 0x07, 0xd1, 0xda, 0x06, 0xd3, 0x90, 0xe9, 0xcf, 0xa8, 0x58, 0xcd,
  0xcb, 0xf8, 0x1e, 0x7d, 0x1b, 0xdd, 0xd0, 0xf3, 0x8b, 0x64, 0x3e, 0x49,
  0xe6, 0xe5, 0x20, 0xfa, 0x3e, 0x5b, 0x76, 0xa9, 0xdb, 0xcb, 0x94, 0x56,
  0x20, 0x8e, 0xb4, 0x25, 0x0c, 0x8f, 0x76, 0x7d, 0x9c, 0xa7, 0x8b, 0x60,
  0xf1, 0xb3, 0x39, 0xed, 0x72, 0x74, 0xfe, 0xfa, 0x20, 0x7a, 0xf2, 0xfc,
  0xd3, 0x8f, 0xfd, 0x2e, 0x53, 0x13, 0x34, 0xc1, 0x78, 0x4e, 0x24, 0xba,
  0x48, 0xc6, 0xe9, 0x25, 0xcd, 0x6b, 0xb6, 0x9c, 0x96, 0xe9, 0x82, 0x56,
  0x1c, 0x23, 0x28, 0x40, 0x5c, 0x8b, 0x38, 0x2f, 0x0b, 0xac, 0x1d, 0x7f,
  0x40, 0x73, 0xbf, 0xcb, 0xd3, 0x12, 0x84, 0x8e, 0x2f, 0x68, 0xa5, 0xcb,
  0xc2, 0x9a, 0x03, 0x75, 0x51, 0x3f, 0x23, 0xa2, 0x26, 0x5a, 0xe1, 0xb8,
  0xa0, 0x4e, 0x5f, 0xb8, 0xbe, 0xa2, 0xeb, 0xb2, 0x5c, 0xbc, 0xd8, 0xde,
  0x2e, 0xd2, 0x32, 0x19, 0xfc, 0x83, 0x0e, 0x49, 0xaf, 0xbc, 0xcb, 0x7a,
  0xe5, 0x75, 0x9e, 0x24, 0xff, 0x1c, 0x10, 0xcd, 0xba, 0x07, 0xa9, 0x4b,
  0xec, 0x23, 0x86, 0x75, 0x95, 0xa0, 0x83, 0xbf, 0x2d, 0x93, 0x39, 0x1a,
  0xa4, 0x21, 0xc4, 0xd3, 0xc5, 0x75, 0x4c, 0xbb, 0x99, 0x10, 0xf9, 0xe1,
  0xd8, 0x11, 0x81, 0x60, 0x44, 0x72, 0xf0, 0x7e, 0xf8, 0xa9, 0xd1, 0xe7,
  0x25, 0x77, 0x49, 0xff, 0x0e, 0xf4, 0xa5, 0x98, 0xd6, 0x9a, 0x3a, 0xdb,
  0x06, 0x51, 0xfd, 0xb0, 0xdb, 0xdf, 0xdd, 0xd9, 0xf9, 0x69, 0x50, 0xde,
  0x97, 0x8f, 0x7c, 0x61, 0x67, 0xc7, 0xbf, 0x82, 0xa7, 0x37, 0x31, 0xe3,
  0x68, 0x4a, 0x44, 0x83, 0xfe, 0xff, 0x9e, 0xe4, 0x59, 0xb1, 0xd5, 0xd2,
  0xd4, 0x34, 0x29, 0xe9, 0x88, 0x05, 0xed, 0xc4, 0xfd, 0xbf, 0x4b, 0xb7,
  0xf6, 0xf0, 0xdb, 0x2c, 0x9a, 0x27, 0x05, 0xaf, 0xaa, 0xb0, 0x8e, 0x60,
  0xda, 0xb4, 0xfd, 0x9e, 0x81, 0xc4, 0x25, 0x7f, 0x3b, 0xcb, 0x66, 0x44,
  0x03, 0x3d, 0x3a, 0x98, 0xa5, 0x5b, 0x2c, 0x3a, 0x77, 0x8e, 0xe1, 0x24,
  0xc4, 0x8f, 0xe2, 0x29, 0x58, 0x51, 0x41, 0x0d, 0xd3, 0x60, 0x89, 0x01,
  0x24, 0xf1, 0xf8, 0x3a, 0xca, 0xe8, 0xed, 0xbc, 0xb9, 0x29, 0xf1, 0x7c,
  0x35, 0xc8, 0xf2, 0xab, 0xed, 0x38, 0x1f, 0x5f, 0xa7, 0xb7, 0xb4, 0x32,
  0xcf, 0x9f, 0x7f, 0xdc, 0xa7, 0x7f, 0x9e, 0xff, 0xb4, 0x7d, 0x9b, 0x4d,
  0x69, 0xa1, 0x9e, 0xfe, 0xb4, 0x8d, 0xed, 0xfe, 0x47, 0xdc, 0x1b, 0xf5,
  0xc6, 0xff, 0x1c, 0x5c, 0x97, 0xb3, 0xe9, 0x43, 0x54, 0x44, 0xed, 0x45,
  0xf1, 0x2c, 0x5b, 0xce, 0x4b, 0x47, 0x38, 0x44, 0x83, 0x65, 0xc0, 0x9d,
  0xa6, 0xe9, 0x9c, 0xce, 0x2c, 0x51, 0xfa, 0x4a, 0x4e, 0xec, 0x28, 0xf1,
  0x87, 0xbb, 0x1c, 0x5f, 0xd3, 0x54, 0x89, 0x92, 0x62, 0x5d, 0x86, 0x32,
  0xa5, 0xc9, 0xd0, 0x6b, 0x73, 0x3a, 0xc4, 0xa9, 0xb4, 0x23, 0x5d, 0xa5,
  0xf4, 0x5c, 0x96, 0x4f, 0x92, 0xdc, 0xd3, 0xf4, 0x30, 0xa5, 0x55, 0x93,
  0x53, 0xfb, 0xc9, 0x60, 0xf7, 0xd9, 0x60, 0xd7, 0x2d, 0x10, 0x6d, 0x65,
  0xe6, 0x86, 0x58, 0x94, 0xc9, 0x82, 0x06, 0xb3, 0x04, 0xf3, 0xe3, 0x93,
  0x88, 0x46, 0xe9, 0x04, 0x5f, 0x81, 0xe5, 0x44, 0x45, 0xe6, 0x0e, 0xcf,
  0x75, 0x5c, 0x56, 0xe8, 0x11, 0x4b, 0xbb, 0x8a, 0xde, 0xd2, 0xbe, 0x1b,
  0x57, 0xc9, 0x23, 0xd9, 0xe0, 0x17, 0xf5, 0x55, 0xbd, 0xbb, 0xbb, 0x5b,
  0x4f, 0x77, 0x2f, 0x76, 0x6b, 0xa4, 0x17, 0xbc, 0xd4, 0x46, 0x30, 0x2f,
  0xf6, 0xaa, 0x24, 0x73, 0x7c, 0x19, 0xf1, 0xb8, 0xfc, 0xa2, 0x83, 0x65,
  0x38, 0x0e, 0x6f, 0x1c, 0x83, 0x5a, 0xa4, 0xdf, 0x93, 0xcb, 0xf4, 0xbe,
  0x27, 0x8b, 0xc2, 0xab, 0x1d, 0x53, 0xfb, 0xb3, 0x05, 0xc8, 0xc2, 0x9a,
  0xbb, 0x5a, 0x26, 0x05, 0x71, 0x45, 0xcc, 0xd6, 0x31, 0x1b, 0x34, 0x3f,
  0x4b, 0xaf, 0xae, 0xcb, 0xe8, 0x2e, 0x06, 0xc7, 0x39, 0x2e, 0xe5, 0x6d,
  0xb0, 0x76, 0xe2, 0x32, 0x97, 0x31, 0xf1, 0x8a, 0x08, 0xa4, 0x25, 0x8c,
  0x1c, 0xd4, 0xe8, 0x96, 0x8d, 0xd6, 0x48, 0x88, 0x2d, 0x0a, 0x2e, 0xbd,
  0x51, 0x5c, 0x60, 0xc3, 0xe6, 0x44, 0x14, 0x25, 0xdd, 0x0e, 0x4b, 0xfc,
  0x75, 0x4d, 0xec, 0x3f, 0x9a, 0xc7, 0xb3, 0x44, 0x87, 0x09, 0x7e, 0xf9,
  0x9a, 0xd6, 0x34, 0xb9, 0x8f, 0x67, 0x8e, 0x85, 0x11, 0x43, 0xea, 0xf1,
  0x2e, 0xb9, 0xa7, 0xe9, 0x50, 0x94, 0x44, 0x90, 0x38, 0x31, 0x7c, 0x08,
  0x3b, 0x38, 0x68, 0x9d, 0x70, 0x8a, 0x05, 0xdf, 0x0f, 0xbc, 0x44, 0x18,
  0x7e, 0x14, 0x4c, 0x96, 0x96, 0x2c, 0xbe, 0xc1, 0x7d, 0xeb, 0xc9, 0xe6,
  0xa0, 0x65, 0x6d, 0xe8, 0x8e, 0xc1, 0x18, 0xc3, 0x7b, 0x89, 0x07, 0xe1,
  0x78, 0xa4, 0xbf, 0x9a, 0x70, 0x51, 0xf6, 0xea, 0x64, 0x43, 0xe4, 0xc2,
  0x03, 0x9c, 0xe1, 0x38, 0xe0, 0xd9, 0x42, 0xe4, 0x06, 0xa6, 0x5f, 0xcc,
  0x58, 0x04, 0x07, 0xe9, 0x76, 0x9e, 0x95, 0xd1, 0x24, 0x0b, 0xf8, 0x2f,
  0xf5, 0xea, 0xe6, 0x8f, 0xee, 0x0b, 0x12, 0xbc, 0x88, 0xf9, 0x4d, 0x8a,
  0x6b, 0xba, 0xae, 0x0a, 0x9c, 0x1d, 0xe2, 0x0c, 0xe9, 0x8c, 0x56, 0xf7,
  0x16, 0xab, 0xb1, 0x48, 0x92, 0xc9, 0x20, 0x3a, 0xbd, 0x04, 0x51, 0xe7,
  0x34, 0xe8, 0x92, 0xbf, 0xc6, 0xb9, 0x9b, 0xae, 0xa8, 0x61, 0x08, 0x25,
  0x73, 0x77, 0xc4, 0x78, 0x2c, 0xc1, 0x11, 0xe2, 0xa3, 0x46, 0x43, 0x9d,
  0x56, 0x0f, 0x28, 0xdf, 0xae, 0xa0, 0x7c, 0x0c, 0x8e, 0x8e, 0x68, 0x14,
  0xf1, 0x96, 0xd1, 0x6f, 0xe5, 0x5d, 0x92, 0xcc, 0x3d, 0xbb, 0x21, 0xde,
  0x40, 0x57, 0x9e, 0xac, 0x7e, 0x3a, 0xbf, 0xcd, 0x30, 0xc0, 0x8d, 0x8d,
  0xb3, 0xf3, 0xd3, 0x2f, 0xcf, 0x8f, 0x86, 0xc3, 0xe8, 0xcd, 0xd1, 0xc5,
  0xd1, 0x79, 0xf5, 0x42, 0x9d, 0x67, 0xf9, 0x8c, 0x6e, 0x4d, 0xa2, 0x92,
  0x49, 0x5a, 0x2c, 0xa6, 0xf1, 0x0a, 0x72, 0x06, 0xcd, 0xe5, 0x2a, 0x07,
  0x1d, 0xce, 0x12, 0x1c, 0xcb, 0xc9, 0x32, 0x67, 0x8e, 0xb8, 0x20, 0x66,
  0xa6, 0x52, 0x01, 0x5d, 0x76, 0x2c, 0x4a, 0xcc, 0xaf, 0xac, 0x39, 0xcf,
  0x66, 0x6c, 0x23, 0x70, 0x47, 0x43, 0x48, 0xeb, 0x79, 0x99, 0x8d, 0x57,
  0x07, 0xe2, 0x1c, 0xe6, 0x03, 0x46, 0x3b, 0xe3, 0x1b, 0x9a, 0xae, 0x46,
  0xda, 0x05, 0x3a, 0xbe, 0x97, 0x8e, 0x70, 0x89, 0xf9, 0x78, 0xa2, 0xf8,
  0x8a, 0x6e, 0x7c, 0x96, 0xec, 0xb0, 0x38, 0xe3, 0xc4, 0xc6, 0xee, 0x46,
  0xcc, 0xa2, 0x20, 0x64, 0x43, 0xda, 0x50, 0x1a, 0xf0, 0x2c, 0x9d, 0x13,
  0x9f, 0xa2, 0xfb, 0x48, 0xcf, 0x06, 0x0d, 0xf7, 0x12, 0x04, 0xe8, 0x25,
  0x2d, 0xac, 0x8c, 0x34, 0x42, 0x6f, 0xd1, 0x6e, 0x13, 0x4f, 0x71, 0xb3,
  0xe3, 0xc1, 0xa5, 0x25, 0xf6, 0x2c, 0x1e, 0xe1, 0x08, 0xe3, 0x60, 0xe1,
  0xae, 0xa5, 0x7e, 0xb9, 0x23, 0xfe, 0x20, 0x10, 0x2b, 0xad, 0x47, 0x1a,
  0x1e, 0xbd, 0x46, 0x83, 0x8a, 0x47, 0xd8, 0x56, 0x0c, 0xa6, 0xb6, 0x90,
  0x74, 0x2d, 0xf2, 0x59, 0xbc, 0x4b, 0x89, 0x30, 0xe8, 0xd9, 0xbb, 0x6c,
  0x39, 0x25, 0xb1, 0x09, 0x0f, 0x2c, 0x17, 0x9e, 0x64, 0x89, 0x44, 0x96,
  0xe5, 0x82, 0x7a, 0x9e, 0xa5, 0xf7, 0x7c, 0xc1, 0xd7, 0x5a, 0xa1, 0xf1,
  0xd1, 0x9f, 0x0b, 0xda, 0x88, 0x84, 0x47, 0x34, 0x08, 0x99, 0x11, 0xcb,
  0x5e, 0x38, 0x67, 0x8d, 0x6d, 0xc4, 0x91, 0x61, 0x06, 0x71, 0x76, 0x3a,
  0xbc, 0x00, 0xbb, 0x3c, 0x7b, 0x77, 0x41, 0x0d, 0x11, 0x63, 0x2f, 0x4a,
  0xda, 0x52, 0xbc, 0x38, 0x4f, 0x58, 0x48, 0xb5, 0xe6, 0x68, 0x07, 0xd3,
  0x9c, 0x55, 0x16, 0x0c, 0xca, 0x77, 0x6a, 0xe3, 0x63, 0xa9, 0x1b, 0x44,
  0x6c, 0x32, 0x77, 0x71, 0x9d, 0xd0, 0x11, 0x72, 0xaf, 0x6d, 0x7e, 0xb6,
  0xd5, 0x8b, 0xfa, 0xae, 0xb9, 0x1f, 0xf0, 0xe8, 0x4f, 0xe8, 0xb9, 0x48,
  0x67, 0xe9, 0x34, 0x0e, 0x6e, 0x8b, 0x63, 0x5e, 0x6f, 0x90, 0xb7, 0x3b,
  0x94, 0x63, 0x62, 0x52, 0x3c, 0x66, 0xe2, 0x0f, 0x2a, 0xa9, 0x62, 0x01,
  0xf9, 0x44, 0xfb, 0xcd, 0x82, 0x40, 0xc8, 0xa7, 0x82, 0xa4, 0xc5, 0x32,
  0x10, 0xb5, 0x40, 0xaf, 0x34, 0x42, 0x9c, 0xf8, 0xca, 0x5a, 0xd5, 0xc9,
  0xa4, 0xb1, 0x76, 0xe0, 0x7e, 0xac, 0xbd, 0xb8, 0xd5, 0xeb, 0x8c, 0xe2,
  0xbc, 0x43, 0x44, 0x43, 0x57, 0x95, 0xc8, 0xde, 0x7c, 0x45, 0x25, 0x57,
  0x4b, 0x9a, 0x81, 0x2c, 0x2d, 0x4d, 0xf2, 0x23, 0x8c, 0x04, 0xb2, 0xab,
  0x3b, 0xdb, 0x24, 0x14, 0xcd, 0x27, 0x83, 0x8d, 0x53, 0xd6, 0x68, 0x9c,
  0xfa, 0xd3, 0x8f, 0xb7, 0xfb, 0xfd, 0x78, 0x01, 0xe9, 0xb1, 0xa6, 0x73,
  0x6d, 0xd2, 0x3c, 0xb7, 0xa2, 0x6f, 0xc1, 0xd3, 0xf9, 0x74, 0xe3, 0xde,
  0x9d, 0x07, 0x93, 0xef, 0x09, 0x2b, 0x11, 0xce, 0x8f, 0x65, 0x36, 0xfa,
  0x8d, 0x5a, 0x9b, 0x53, 0x22, 0xa5, 0x7f, 0xe2, 0x1c, 0xf7, 0xa5, 0x30,
  0x49, 0x37, 0x0d, 0xcc, 0x23, 0x22, 0x8e, 0x95, 0x9b, 0x14, 0x49, 0xf4,
  0x38, 0xc0, 0x1a, 0xe0, 0x1d, 0x3c, 0x5a, 0x6b, 0x6e, 0x92, 0x25, 0xc5,
  0xbc, 0x4b, 0xd7, 0xee, 0x7d, 0x0a, 0x35, 0x21, 0x2d, 0x4d, 0x5c, 0x88,
  0xc6, 0x79, 0x82, 0x43, 0xec, 0x17, 0xd2, 0xaf, 0x27, 0x0f, 0x58, 0x54,
  0x3d, 0x2c, 0x0f, 0x4f, 0xab, 0xbc, 0x4b, 0xc7, 0x49, 0x4f, 0x65, 0x2b,
  0xe2, 0xad, 0x13, 0x56, 0xd4, 0xb8, 0x31, 0x3d, 0x3a, 0xed, 0xf3, 0x99,
  0x65, 0x13, 0xfa, 0xe6, 0x2a, 0x4e, 0x03, 0xed, 0xa8, 0xbf, 0x4f, 0x8b,
  0x09, 0x3d, 0xa7, 0x1f, 0x5f, 0x91, 0x74, 0x12, 0xbd, 0x94, 0x1f, 0x45,
  0x09, 0x7e, 0xf5, 0x59, 0x7d, 0x7d, 0x41, 0xfb, 0x5b, 0xd1, 0x50, 0xaf,
  0x69, 0x0c, 0xe0, 0x1d, 0x5e, 0xdd, 0x0f, 0xde, 0xc1, 0xaa, 0x15, 0xd4,
  0xb7, 0x51, 0x09, 0x1f, 0x17, 0xb9, 0x1d, 0x06, 0xb5, 0xe6, 0x86, 0x19,
  0x58, 0xd6, 0x28, 0x9e, 0x30, 0xef, 0xc4, 0x1c, 0xa2, 0x83, 0x2f, 0x8f,
  0x89, 0x1a, 0x2f, 0x49, 0xfc, 0x8f, 0xc0, 0x71, 0x64, 0xfa, 0xb4, 0x98,
  0x09, 0x1d, 0x72, 0x9a, 0x3f, 0x96, 0x0f, 0x4c, 0xba, 0x8c, 0xc2, 0x3b,
  0x50, 0xff, 0xd7, 0x79, 0x93, 0xfd, 0x9d, 0xd6, 0x20, 0xde, 0x7e, 0x3a,
  0xd8, 0xe9, 0x40, 0x83, 0xa4, 0xed, 0x23, 0xb9, 0x13, 0x93, 0x8e, 0x46,
  0xd3, 0x78, 0x4e, 0x4a, 0x1e, 0x28, 0x42, 0xd6, 0x8d, 0xc7, 0x4a, 0xd7,
  0xdc, 0x32, 0xcf, 0x89, 0xe9, 0x4e, 0x42, 0x66, 0x64, 0x57, 0x81, 0x4c,
  0x87, 0xaf, 0x64, 0xbd, 0x50, 0xfe, 0xb6, 0xcc, 0x88, 0x85, 0xcd, 0xe2,
  0xfc, 0xc6, 0x2e, 0x2d, 0x27, 0x8c, 0xe1, 0x46, 0xe1, 0x71, 0xf1, 0xf3,
  0x2d, 0xcd, 0xf5, 0xbf, 0xa2, 0x85, 0x86, 0x52, 0x06, 0x39, 0x4b, 0xf6,
  0x33, 0xb3, 0x1b, 0xae, 0x6d, 0xe3, 0x75, 0xea, 0x7e, 0xeb, 0xd1, 0x3a,
  0xd4, 0x43, 0x1c, 0x5f, 0x7a, 0x77, 0x6e, 0x24, 0x30, 0x8d, 0x49, 0x8e,
  0x70, 0x04, 0x30, 0x4a, 0x5a, 0xfa, 0xc6, 0xb7, 0x38, 0xf4, 0x5d, 0x21,
  0xa0, 0x60, 0xf7, 0xfb, 0x74, 0xba, 0xa1, 0xe0, 0xb6, 0x6f, 0xf4, 0x05,
  0x9d, 0x91, 0xc2, 0x1d, 0x92, 0xcb, 0xf4, 0x8a, 0x74, 0x40, 0xe1, 0x09,
  0xac, 0x13, 0x9b, 0x2a, 0x8c, 0x13, 0x7c, 0x9d, 0x4d, 0x70, 0x5d, 0xa4,
  0x65, 0x91, 0x4c, 0x2f, 0x7b, 0xb5, 0xe6, 0xf8, 0xae, 0x5a, 0xf2, 0x4d,
  0x0e, 0x81, 0xbf, 0x80, 0x2a, 0x34, 0xe6, 0xb6, 0xe6, 0x89, 0xb2, 0x82,
  0x19, 0x56, 0x16, 0x0a, 0x55, 0x34, 0x9e, 0xc6, 0xe9, 0xac, 0xc0, 0xf1,
  0x50, 0x5d, 0xa1, 0xa8, 0xd3, 0xcd, 0x85, 0xca, 0x03, 0x4c, 0x32, 0x23,
  0xc8, 0x23, 0x79, 0x01, 0x89, 0x03, 0xdb, 0x15, 0x1b, 0x3b, 0xe6, 0x4e,
  0x49, 0xfa, 0x1e, 0xdf, 0x30, 0x51, 0x72, 0x27, 0xc2, 0xc4, 0xfa, 0xb5,
  0xe6, 0x64, 0x53, 0x20, 0x2b, 0x97, 0xd7, 0x4b, 0x56, 0x8e, 0x8b, 0x22,
  0x1d, 0x81, 0x26, 0xe9, 0x8a, 0x5e, 0x8e, 0xf9, 0x64, 0xd3, 0x8a, 0x93,
  0xee, 0x91, 0xc7, 0xc4, 0xde, 0x4b, 0x36, 0x3f, 0x30, 0xd5, 0xf4, 0x89,
  0x44, 0x16, 0xeb, 0x46, 0xa7, 0x02, 0x46, 0x85, 0x5b, 0x14, 0x2a, 0x46,
  0x41, 0xcb, 0x55, 0x99, 0x65, 0x1c, 0xd5, 0x56, 0xb3, 0x7e, 0x68, 0x79,
  0x6d, 0x69, 0x70, 0x77, 0xd7, 0x29, 0x69, 0x3d, 0x22, 0x05, 0xb2, 0x8a,
  0x42, 0x97, 0x2e, 0x13, 0x5b, 0xbf, 0x4f, 0xc2, 0x68, 0x3a, 0x26, 0x0e,
  0xda, 0x9f, 0xa4, 0x24, 0xf4, 0x97, 0xf8, 0x6d, 0x5e, 0x4e, 0x67, 0x3d,
  0xac, 0x41, 0x9d, 0x0c, 0xfb, 0xf3, 0xe4, 0x2a, 0x23, 0x2d, 0xa4, 0x6c,
  0x52, 0xdd, 0x5b, 0xec, 0x01, 0x5f, 0x0e, 0x72, 0x15, 0x39, 0xea, 0xb0,
  0x8b, 0x85, 0x6e, 0x24, 0x12, 0xa9, 0xa0, 0xb5, 0x4f, 0x54, 0x1e, 0xe0,
  0x51, 0x28, 0x77, 0x2d, 0x6a, 0xcd, 0xb1, 0x80, 0x48, 0xc7, 0x88, 0x34,
  0xca, 0x9e, 0x4a, 0x1d, 0xb4, 0xa9, 0xb3, 0x78, 0xc5, 0x5b, 0x44, 0xd7,
  0x9b, 0xbb, 0x4d, 0x46, 0x60, 0x64, 0xc4, 0x41, 0x98, 0xb1, 0xf1, 0xc6,
  0x61, 0x41, 0xea, 0xdc, 0x18, 0x2a, 0xd7, 0x34, 0xc5, 0x73, 0xb3, 0x25,
  0xed, 0x2f, 0xbd, 0xc4, 0xac, 0x8e, 0x85, 0xdb, 0x3b, 0xda, 0x2a, 0xc7,
  0x7b, 0xf9, 0x0a, 0x2e, 0xae, 0x59, 0x32, 0x88, 0x73, 0x08, 0x0a, 0x77,
  0xcd, 0xe6, 0x64, 0xcc, 0x98, 0x26, 0x8f, 0x53, 0x87, 0x89, 0xd7, 0xf5,
  0xa2, 0xf4, 0x17, 0x24, 0x1f, 0x2c, 0xf0, 0xa4, 0xf5, 0xe7, 0xb4, 0xc6,
  0xa1, 0x4d, 0x6b, 0x85, 0x50, 0x56, 0x48, 0xab, 0x97, 0xd9, 0x74, 0x9a,
  0xdd, 0xf1, 0xa5, 0x3a, 0x26, 0xda, 0xcf, 0x59, 0x23, 0xae, 0xef, 0x35,
  0xac, 0x37, 0x73, 0x12, 0xa7, 0x52, 0x98, 0xab, 0xf0, 0x44, 0x70, 0x54,
  0x47, 0xc4, 0x3f, 0xc4, 0x92, 0x14, 0xbd, 0x84, 0xda, 0xf0, 0x0a, 0xab,
  0xb7, 0x86, 0x43, 0x9f, 0x91, 0xca, 0xc0, 0xbd, 0x86, 0xf7, 0x75, 0xc0,
  0x89, 0x21, 0x05, 0xc4, 0x6a, 0x97, 0x1a, 0xa8, 0xe4, 0x80, 0xe3, 0x56,
  0x3f, 0x1a, 0x74, 0x14, 0x12, 0xe6, 0xce, 0xae, 0x2d, 0xba, 0xdb, 0x6f,
  0xd3, 0x6c, 0x59, 0x4c, 0xb1, 0x8b, 0xe3, 0x84, 0x34, 0xec, 0x49, 0xa0,
  0x09, 0x48, 0xe3, 0xac, 0xee, 0x76, 0x86, 0x49, 0x59, 0x6f, 0xee, 0x80,
  0x3b, 0x7c, 0xd1, 0x51, 0x95, 0x99, 0xad, 0x43, 0xdc, 0xaa, 0x6e, 0x16,
  0x6d, 0xa9, 0xea, 0xc4, 0x97, 0x90, 0xa9, 0x89, 0x9b, 0x76, 0x60, 0x1e,
  0xdd, 0x7d, 0xf5, 0xcd, 0xfe, 0xc9, 0xbb, 0xa3, 0xdd, 0x3f, 0xd7, 0xe9,
  0x95, 0xbe, 0xdb, 0x93, 0xef, 0xf6, 0x3a, 0xad, 0x7b, 0x43, 0x6b, 0x19,
  0x75, 0x5f, 0x75, 0x55, 0xab, 0x75, 0xdb, 0xa3, 0x9d, 0x60, 0x14, 0x3d,
  0x95, 0x53, 0x4b, 0xb9, 0x82, 0x65, 0x61, 0x70, 0x79, 0xd7, 0xc7, 0xce,
  0x7a, 0x1d, 0xad, 0x24, 0xb3, 0x31, 0x90, 0x5c, 0x3c, 0x09, 0x17, 0xa3,
  0x28, 0x33, 0x08, 0xeb, 0xba, 0x41, 0x68, 0xb9, 0x90, 0x13, 0x60, 0x27,
  0xb7, 0x7e, 0xbb, 0xc8, 0x8c, 0x31, 0x65, 0x3f, 0x24, 0xe6, 0xf2, 0xc4,
  0x7c, 0x40, 0x49, 0x4c, 0xca, 0x2b, 0x22, 0x89, 0x72, 0x7c, 0x3d, 0xa0,
  0x6b, 0x56, 0xb8, 0x58, 0x5a, 0x28, 0x43, 0xa8, 0x73, 0x58, 0xdc, 0x41,
  0xb0, 0x7c, 0xde, 0xd2, 0x2c, 0x64, 0xeb, 0x3b, 0x3a, 0x16, 0x52, 0x68,
  0x68, 0x5f, 0x3a, 0xca, 0x3f, 0x98, 0x96, 0x99, 0xce, 0x54, 0x03, 0xc0,
  0x99, 0xce, 0xeb, 0xcd, 0xd1, 0x61, 0xcd, 0x66, 0xe8, 0x51, 0x4d, 0x97,
  0x30, 0x1d, 0xf7, 0xb4, 0x05, 0x1c, 0x60, 0x1a, 0x35, 0xf4, 0xb7, 0x95,
  0x72, 0x81, 0x6e, 0x9e, 0x28, 0xcb, 0x10, 0x55, 0xad, 0x7e, 0xd6, 0xa8,
  0xb1, 0x11, 0x49, 0x8a, 0x7a, 0x98, 0x88, 0x9f, 0x60, 0x7c, 0xfd, 0x13,
  0x22, 0xe8, 0x69, 0xa6, 0x57, 0x88, 0x1c, 0x20, 0x36, 0xa3, 0x98, 0x9c,
  0x65, 0x34, 0x90, 0x5d, 0xb6, 0x70, 0x02, 0x7d, 0x06, 0x22, 0x1a, 0x6f,
  0x85, 0x0d, 0x54, 0x0e, 0xb3, 0x23, 0x27, 0x52, 0x6e, 0x68, 0x65, 0x99,
  0xf2, 0x95, 0xcd, 0x93, 0xec, 0xdc, 0xd2, 0xdc, 0xdb, 0xa4, 0x2c, 0xc6,
  0xf1, 0x22, 0xd9, 0x56, 0x19, 0xc2, 0x36, 0x92, 0x7b, 0x91, 0x81, 0x34,
  0xd9, 0xe5, 0xe9, 0xc5, 0x91, 0xb0, 0x4b, 0x13, 0xf8, 0x02, 0x3d, 0x54,
  0x38, 0x73, 0x70, 0x66, 0xf9, 0x32, 0x87, 0x02, 0xab, 0xf7, 0x42, 0x5c,
  0x34, 0xd6, 0x9c, 0xf4, 0x81, 0x01, 0x1b, 0xd0, 0x6c, 0x32, 0x76, 0xa3,
  0x2b, 0x71, 0xd9, 0xd9, 0xa0, 0x9e, 0x06, 0x90, 0x6e, 0xf8, 0x63, 0x67,
  0x5d, 0xae, 0xf3, 0x37, 0xbd, 0x6e, 0xfb, 0x63, 0x37, 0x86, 0xfe, 0x5f,
  0x63, 0x2f, 0x7b, 0xa8, 0x69, 0x92, 0x17, 0x8a, 0xb8, 0xd5, 0x9c, 0x34,
  0x86, 0xdb, 0x44, 0xd7, 0x16, 0xeb, 0xd5, 0x7e, 0x49, 0x7a, 0x7d, 0xc5,
  0xee, 0x88, 0x43, 0x6a, 0x7e, 0xb2, 0x9c, 0x2d, 0x54, 0xb6, 0xf9, 0xdd,
  0x7f, 0x4c, 0x94, 0xf9, 0x42, 0x04, 0xd9, 0x7e, 0x5c, 0x8c, 0xd3, 0xb4,
  0xf6, 0xd6, 0xd1, 0x9c, 0xaf, 0x8a, 0xfd, 0xe1, 0xc1, 0xf1, 0xb1, 0x57,
  0xa5, 0xef, 0x44, 0x51, 0xc0, 0x34, 0xa0, 0x23, 0xd0, 0x92, 0xc0, 0x0d,
  0x21, 0x36, 0x1b, 0x76, 0x56, 0xc8, 0xb8, 0xe9, 0xb2, 0x6d, 0x3b, 0x6d,
  0x18, 0x5f, 0x32, 0x27, 0xda, 0x18, 0x27, 0x13, 0x6f, 0xb9, 0xa5, 0xf9,
  0xc0, 0x78, 0xc5, 0x64, 0x41, 0x17, 0x65, 0xa1, 0x26, 0x9d, 0x3f, 0x97,
  0xab, 0x45, 0xf2, 0x6a, 0xbf, 0x23, 0x62, 0x63, 0x7d, 0x4e, 0xb2, 0x30,
  0xe3, 0x98, 0x86, 0xaf, 0x9a, 0xb8, 0x5c, 0x87, 0xd8, 0xe2, 0x89, 0xea,
  0xcf, 0xca, 0x1b, 0x61, 0x01, 0x65, 0x39, 0x5e, 0xac, 0xf5, 0x74, 0xa1,
  0x3c, 0xd9, 0xab, 0xb3, 0x96, 0x15, 0x49, 0x1c, 0xb3, 0xe2, 0xd1, 0x97,
  0xd5, 0x23, 0xd4, 0x09, 0x5e, 0xb8, 0x06, 0x81, 0x91, 0xaa, 0x10, 0x8a,
  0x92, 0x2c, 0x85, 0x3c, 0x46, 0x90, 0x04, 0x69, 0xf2, 0x91, 0xfc, 0x02,
  0x6f, 0xd4, 0xc4, 0x9f, 0x81, 0x17, 0xa0, 0x9a, 0xbb, 0xef, 0x2c, 0x75,
  0x22, 0x23, 0xd4, 0xe6, 0xb2, 0x64, 0x2b, 0xcc, 0x82, 0xe4, 0xc0, 0x72,
  0x4a, 0x6c, 0x94, 0x34, 0xea, 0x39, 0x7e, 0x32, 0xa1, 0x2f, 0xd9, 0x5c,
  0xd0, 0x54, 0xf0, 0xa0, 0xbf, 0xe5, 0x29, 0xf4, 0xa2, 0x28, 0x64, 0xe7,
  0x22, 0xcb, 0x6b, 0xe3, 0xb2, 0x9b, 0xec, 0x1f, 0x60, 0xc9, 0xcd, 0xae,
  0xe7, 0x7a, 0x73, 0x35, 0xa9, 0xd8, 0xc4, 0xe2, 0x68, 0xb3, 0x58, 0x42,
  0x72, 0xa3, 0xab, 0xc5, 0xe4, 0x32, 0x93, 0xd4, 0x78, 0x1e, 0x26, 0x92,
  0xd5, 0x6f, 0x1c, 0xe2, 0xe4, 0x5b, 0x8f, 0x55, 0x09, 0x1f, 0x14, 0x38,
  0x7e, 0xa9, 0xc4, 0xd1, 0x1f, 0xa7, 0x8b, 0x6b, 0x1c, 0xfa, 0x97, 0xd3,
  0xb4, 0x60, 0xbb, 0x94, 0x7e, 0xd0, 0x90, 0x3a, 0x86, 0xc3, 0x13, 0x53,
  0x0b, 0x99, 0x6f, 0xf1, 0x45, 0x61, 0x6f, 0xeb, 0x8e, 0xa7, 0x66, 0x35,
  0x37, 0x0b, 0xa4, 0x30, 0x7b, 0x34, 0x5d, 0x3f, 0x0f, 0xae, 0x23, 0x27,
  0xe9, 0xc9, 0xe1, 0xba, 0x8d, 0xa7, 0xe9, 0xc4, 0xbe, 0x1b, 0x44, 0xe7,
  0x60, 0xfc, 0xcb, 0x05, 0x98, 0x42, 0xc4, 0x5e, 0x37, 0xfd, 0xaa, 0xd6,
  0x1c, 0x0f, 0x3e, 0xa4, 0x21, 0xf6, 0x53, 0x55, 0x78, 0x4a, 0xe5, 0x36,
  0x48, 0x83, 0xef, 0xe8, 0x2c, 0xbf, 0xa8, 0x73, 0x42, 0x6f, 0xdc, 0x26,
  0x11, 0x71, 0x5e, 0x14, 0x53, 0xf6, 0x37, 0x4c, 0xb2, 0x71, 0xb1, 0x4d,
  0x6a, 0x77, 0xb1, 0x6d, 0xe3, 0xab, 0x78, 0x16, 0xec, 0xce, 0x18, 0x0e,
  0xdd, 0xdc, 0x62, 0x48, 0xc0, 0x38, 0x6a, 0x8e, 0x9e, 0xa6, 0x2b, 0xe1,
  0x88, 0xa7, 0xd4, 0x2e, 0xcf, 0x87, 0x15, 0xa7, 0x2f, 0xe7, 0xcb, 0x8b,
  0x93, 0xa1, 0x88, 0x4b, 0x75, 0x11, 0x7b, 0x49, 0x87, 0x34, 0xb2, 0xdd,
  0x09, 0x1b, 0xe7, 0x6b, 0x58, 0xae, 0xb6, 0xe1, 0xf0, 0x80, 0x3f, 0x1c,
  0x2e, 0xa1, 0x5e, 0x51, 0x37, 0xf9, 0x4a, 0x9c, 0x2f, 0x0d, 0x46, 0x84,
  0xd9, 0xda, 0xfc, 0xc4, 0xfe, 0x94, 0xe5, 0xab, 0xc1, 0x65, 0x32, 0xc9,
  0xf2, 0x78, 0x40, 0x37, 0x10, 0x1d, 0x03, 0x36, 0xe4, 0xf3, 0x5c, 0x89,
  0x0b, 0xbd, 0xa7, 0xd9, 0xf3, 0x34, 0x3f, 0x3a, 0xc4, 0xd3, 0x75, 0x02,
  0x26, 0x69, 0x84, 0x08, 0xee, 0x17, 0x13, 0x70, 0xf5, 0x36, 0xb0, 0x83,
  0xda, 0x72, 0x79, 0xb3, 0x41, 0xb0, 0xa8, 0x10, 0x6e, 0x36, 0x5b, 0xc0,
  0xf0, 0x94, 0x4c, 0xda, 0xf9, 0xd1, 0xb9, 0xe9, 0x88, 0x91, 0x7f, 0xd2,
  0x1b, 0xb9, 0xea, 0xce, 0x6f, 0xe2, 0xf7, 0x57, 0x59, 0x4e, 0x7c, 0x7c,
  0x56, 0x34, 0x48, 0x4b, 0x5c, 0xa7, 0xa6, 0xa9, 0xf6, 0xd4, 0xb2, 0x58,
  0x2e, 0x73, 0x59, 0xfc, 0xe5, 0x3c, 0xe8, 0x80, 0x96, 0x6d, 0x39, 0x63,
  0x87, 0xa7, 0xad, 0x42, 0xfb, 0x45, 0x60, 0x6b, 0xa2, 0x8a, 0x90, 0x89,
  0xd5, 0x6c, 0x56, 0x61, 0xcb, 0x2f, 0x31, 0xdf, 0xb9, 0x77, 0xa4, 0x89,
  0x91, 0x03, 0xe6, 0x8c, 0xba, 0xb8, 0xed, 0x1c, 0x01, 0x79, 0x82, 0x67,
  0x59, 0x8b, 0xcd, 0xf3, 0x2c, 0xff, 0xa5, 0x7a, 0x8c, 0xf8, 0xdd, 0x1c,
  0x33, 0x51, 0x43, 0x5a, 0x76, 0x55, 0xdf, 0x78, 0xd8, 0x4a, 0x52, 0xec,
  0xdd, 0x76, 0x76, 0x79, 0x59, 0xdd, 0x17, 0x3e, 0xfc, 0x7d, 0xb4, 0x87,
  0x7b, 0xed, 0xa5, 0x5c, 0x38, 0x0d, 0x86, 0xf2, 0x26, 0xbe, 0x4f, 0x67,
  0xcb, 0x99, 0x18, 0xb5, 0x89, 0x8e, 0xf5, 0x31, 0xef, 0xc2, 0x8a, 0xc1,
  0xdb, 0x54, 0x5a, 0xf1, 0x1c, 0xa5, 0x61, 0x57, 0x76, 0x56, 0x7d, 0x59,
  0x40, 0xfe, 0x96, 0x38, 0xde, 0xc0, 0xd4, 0x74, 0x91, 0xc8, 0xa6, 0xe9,
  0x2c, 0x2d, 0x8b, 0x1a, 0x77, 0x8a, 0x16, 0xd7, 0x71, 0x41, 0xd7, 0x22,
  0xa4, 0x93, 0xba, 0x38, 0x8b, 0x75, 0xa5, 0x6f, 0xed, 0xe9, 0xa4, 0x71,
  0x17, 0x11, 0xdd, 0x10, 0x53, 0x65, 0x11, 0x87, 0xd6, 0x91, 0xbd, 0xe6,
  0x26, 0x35, 0xb4, 0x58, 0x86, 0x66, 0x24, 0xb9, 0xcc, 0xe2, 0x7b, 0x5e,
  0x15, 0x13, 0x84, 0x7f, 0xad, 0x63, 0xa3, 0xfa, 0x45, 0xb0, 0x09, 0x35,
  0x79, 0xf0, 0x25, 0x0b, 0x73, 0xd0, 0x6e, 0xea, 0x9b, 0xe0, 0xcc, 0x7c,
  0x99, 0x32, 0x74, 0x7e, 0xd2, 0x19, 0xc7, 0xed, 0x36, 0x17, 0xbb, 0x3e,
  0xc2, 0x06, 0x4c, 0x6c, 0x8d, 0x2f, 0xd9, 0xc6, 0xde, 0x54, 0x02, 0x16,
  0xa4, 0x87, 0x81, 0x60, 0x9d, 0x6a, 0x3d, 0x50, 0x22, 0x95, 0x46, 0x8a,
  0xa8, 0xd2, 0x4c, 0x45, 0xd5, 0x8c, 0x27, 0x6d, 0xd6, 0x85, 0x38, 0x90,
  0xb8, 0x79, 0x74, 0xb4, 0x29, 0xd1, 0x1d, 0x2c, 0xbb, 0xfc, 0x1b, 0x5a,
  0x73, 0xcd, 0x79, 0x7d, 0x95, 0xdf, 0xad, 0x35, 0x67, 0x16, 0x28, 0xa6,
  0x94, 0xcd, 0x62, 0x8b, 0x8d, 0x09, 0x73, 0x2f, 0x8a, 0x83, 0x59, 0xdf,
  0xcc, 0xb3, 0xbb, 0x79, 0x0f, 0x9f, 0x72, 0x5f, 0xb6, 0xbe, 0x18, 0x7b,
  0x83, 0xf5, 0x25, 0x7a, 0xbd, 0x35, 0x9e, 0x2c, 0x9d, 0xcc, 0x29, 0xd4,
  0x6b, 0x9a, 0x87, 0x0d, 0x34, 0x6a, 0x33, 0x1d, 0xab, 0x06, 0x12, 0xba,
  0x4a, 0x93, 0x32, 0x54, 0x84, 0x4c, 0x3b, 0x75, 0xbe, 0xaf, 0x49, 0x5c,
  0x5c, 0xf7, 0xa2, 0x4e, 0xbf, 0xd3, 0x6b, 0xa1, 0xb8, 0xba, 0x7e, 0x61,
  0xe3, 0x72, 0x02, 0x67, 0xbb, 0xae, 0xa3, 0xe6, 0x15, 0x1d, 0x27, 0x88,
  0x87, 0x44, 0xe3, 0x6e, 0x19, 0x58, 0xb0, 0x21, 0x43, 0xfb, 0xc6, 0x84,
  0x1e, 0xef, 0xae, 0xb3, 0x69, 0xeb, 0x09, 0x0a, 0x0c, 0x2c, 0x19, 0x9a,
  0x61, 0xab, 0x2f, 0xdc, 0xa5, 0xd0, 0x46, 0x6a, 0x1c, 0x2b, 0x1a, 0x4f,
  0x93, 0x38, 0x9f, 0xae, 0x54, 0x13, 0xae, 0x9f, 0xa0, 0x5b, 0x99, 0x0a,
  0x8c, 0xf4, 0x31, 0x51, 0x67, 0x3e, 0xc7, 0xfa, 0xaa, 0x6f, 0x2b, 0x99,
  0x48, 0x70, 0x01, 0xf3, 0x0e, 0x15, 0x2b, 0x4d, 0x15, 0xbb, 0x4d, 0x61,
  0xe9, 0x6b, 0xac, 0x76, 0x92, 0x4c, 0x46, 0xf1, 0xf8, 0x86, 0x57, 0x9a,
  0xdb, 0x14, 0x27, 0x16, 0xce, 0x9f, 0x33, 0x0e, 0x12, 0x29, 0x5f, 0xd3,
  0xc1, 0x2b, 0xd2, 0x72, 0x19, 0xaf, 0x3b, 0xb1, 0x55, 0xc5, 0xe7, 0x83,
  0x87, 0xb6, 0x4a, 0xcb, 0x6d, 0xf6, 0x87, 0x35, 0x47, 0xfa, 0x80, 0x8f,
  0x34, 0x49, 0x9e, 0xf3, 0x25, 0xe9, 0x3f, 0xc4, 0x56, 0x89, 0xed, 0x12,
  0x81, 0x7c, 0xd6, 0x30, 0xbf, 0xc8, 0x23, 0xdb, 0xe7, 0x1a, 0x70, 0xe4,
  0x8e, 0x58, 0xd5, 0xfd, 0x0b, 0xe9, 0x40, 0x56, 0xe9, 0x2a, 0xc5, 0x5e,
  0x44, 0xd2, 0x5c, 0xd3, 0xd0, 0x59, 0x7f, 0x22, 0xf2, 0xeb, 0x9b, 0xdc,
  0xc7, 0x70, 0x7a, 0xf9, 0x70, 0xa5, 0xd1, 0x4a, 0x0c, 0x13, 0x71, 0x59,
  0x8f, 0x92, 0x30, 0x26, 0x7d, 0x93, 0x2e, 0x16, 0x6c, 0x42, 0x41, 0x24,
  0x43, 0x60, 0x55, 0x1a, 0x25, 0x57, 0xe9, 0x7c, 0x1e, 0x06, 0x94, 0x64,
  0x4b, 0x52, 0xba, 0x64, 0xcc, 0xa3, 0xe4, 0x12, 0x5c, 0xb6, 0x29, 0xdb,
  0xf3, 0x48, 0x02, 0x37, 0xaa, 0xf3, 0xe6, 0x4c, 0x38, 0x3a, 0xc5, 0xd8,
  0xcf, 0xf1, 0xa5, 0xec, 0x09, 0xab, 0x69, 0x6a, 0xc7, 0x6c, 0x3b, 0x32,
  0x88, 0xf5, 0xd2, 0x6b, 0xc4, 0xdc, 0xca, 0xc3, 0xe3, 0xff, 0x71, 0xe4,
  0x1d, 0xde, 0x66, 0xc8, 0x21, 0x4d, 0x10, 0xd4, 0xdd, 0x20, 0x87, 0x77,
  0x24, 0x58, 0x74, 0xfa, 0x07, 0x51, 0xbf, 0xc3, 0xf6, 0xb8, 0xd0, 0xfb,
  0x44, 0x7a, 0x43, 0x46, 0xc7, 0x1b, 0xa1, 0x15, 0xd3, 0x95, 0x44, 0x41,
  0x81, 0xde, 0xa0, 0x9f, 0xe6, 0xc9, 0xf6, 0x35, 0x5f, 0x74, 0x59, 0x83,
  0x5f, 0xf1, 0x16, 0xaa, 0x7f, 0x4a, 0xe7, 0xc9, 0xa6, 0xbc, 0x52, 0xdd,
  0x5f, 0x72, 0xa1, 0xc9, 0xfe, 0x88, 0xb3, 0x71, 0x9b, 0x4d, 0x0c, 0xe2,
  0x32, 0x6f, 0x6a, 0x42, 0x6a, 0xde, 0x17, 0xe7, 0x60, 0x0b, 0x0b, 0xf8,
  0xf5, 0x6e, 0xa0, 0xbe, 0x70, 0x0b, 0xd2, 0x81, 0xf2, 0xfa, 0x38, 0xd8,
  0x77, 0xe7, 0x2c, 0xe7, 0x7c, 0xb7, 0xff, 0x95, 0x64, 0xa8, 0x9a, 0xe5,
  0x28, 0xd3, 0x41, 0x84, 0x71, 0x20, 0xd2, 0x66, 0x8b, 0x74, 0x48, 0x37,
  0x34, 0x89, 0x5f, 0x31, 0x09, 0xbd, 0x30, 0x36, 0x41, 0xa7, 0x55, 0xc1,
  0x36, 0xba, 0x4e, 0x69, 0xe4, 0xf9, 0xf8, 0x7a, 0x85, 0xcb, 0x02, 0x46,
  0x63, 0x84, 0x1d, 0x98, 0x60, 0xb0, 0x68, 0xb1, 0xc5, 0x4b, 0x1f, 0x4a,
  0xe2, 0x18, 0x7d, 0x04, 0x71, 0x8e, 0x9e, 0x33, 0x02, 0xaa, 0x8d, 0x8e,
  0xe8, 0xe2, 0x1a, 0x74, 0x9b, 0x4c, 0x21, 0x04, 0x1c, 0xb7, 0xd9, 0xb1,
  0xfa, 0x59, 0xc0, 0xc0, 0x79, 0xd7, 0x58, 0x1b, 0xe3, 0x58, 0x1c, 0xb1,
  0x01, 0x4a, 0x47, 0xb0, 0x9c, 0x4b, 0x5f, 0x7c, 0xaf, 0xe1, 0x42, 0x5c,
  0xd5, 0x9a, 0x53, 0xbf, 0xa2, 0xbe, 0xff, 0x21, 0xdf, 0x22, 0xbc, 0x63,
  0xf2, 0x9d, 0xdd, 0x7d, 0xb6, 0x30, 0xa2, 0xc1, 0xd5, 0x4d, 0x23, 0x12,
  0xc5, 0x09, 0xdd, 0xa1, 0xdf, 0xa7, 0xc3, 0xd0, 0x6f, 0x5d, 0x1a, 0xde,
  0xd2, 0xea, 0x4e, 0x4f, 0x2f, 0xd5, 0x2d, 0x4b, 0xdc, 0x87, 0x28, 0xa5,
  0x8c, 0x4e, 0x5e, 0x83, 0xda, 0x0e, 0xce, 0xe9, 0x27, 0xed, 0xb0, 0x1c,
  0x39, 0xb0, 0x75, 0x0e, 0xc6, 0x84, 0x51, 0xe3, 0xcd, 0x37, 0xc3, 0x68,
  0xf3, 0x74, 0xb8, 0xfd, 0xe4, 0xf9, 0xce, 0x7f, 0x56, 0xff, 0x9d, 0xc0,
  0xb4, 0x05, 0x6b, 0xcc, 0xcb, 0x07, 0x4c, 0xed, 0x24, 0xdb, 0xb1, 0x54,
  0xce, 0x07, 0xd1, 0x73, 0x70, 0x7e, 0x8f, 0x0d, 0xe1, 0x1c, 0x2a, 0x60,
  0x4e, 0xa9, 0xc0, 0x14, 0xdf, 0x2a, 0xa3, 0xf6, 0x5c, 0x50, 0x18, 0xb3,
  0xfb, 0x78, 0x25, 0xe7, 0x31, 0x8e, 0x46, 0x79, 0x76, 0x87, 0x68, 0x54,
  0xf6, 0x22, 0x47, 0xb2, 0x3f, 0xb0, 0x45, 0x70, 0x88, 0x2a, 0x84, 0xd1,
  0x3a, 0xbf, 0xa2, 0xed, 0xd7, 0x43, 0x14, 0xc3, 0x00, 0xfa, 0xe6, 0x84,
  0x85, 0x08, 0xd6, 0x29, 0x44, 0x1f, 0x11, 0xfe, 0x50, 0x2c, 0x47, 0x24,
  0xfc, 0xe2, 0x82, 0x2c, 0x9d, 0xed, 0x25, 0x0c, 0x28, 0xb5, 0xed, 0x8d,
  0x39, 0x7a, 0x48, 0x19, 0xd6, 0xa2, 0xcd, 0xbd, 0xa0, 0xdc, 0xd1, 0xec,
  0xc0, 0x2c, 0x4b, 0x93, 0x1c, 0x40, 0xc2, 0xfe, 0x6a, 0x51, 0x3f, 0x97,
  0xa4, 0x27, 0x4f, 0xd5, 0x4c, 0xb2, 0x7d, 0xdf, 0x27, 0x55, 0xba, 0x8f,
  0xc1, 0xf5, 0xa9, 0x79, 0x71, 0xd8, 0xe2, 0x1c, 0x1e, 0x90, 0xbc, 0x08,
  0xa9, 0x8b, 0x9a, 0xef, 0xbf, 0xa6, 0x9d, 0xc0, 0x13, 0x0d, 0x72, 0xf0,
  0x7b, 0xe4, 0xaf, 0x1e, 0x5e, 0x3a, 0x96, 0xff, 0xe4, 0x2b, 0xb1, 0x08,
  0x8a, 0x43, 0x18, 0x11, 0xba, 0xea, 0xc8, 0x20, 0x66, 0x37, 0xad, 0x1f,
  0x21, 0x58, 0xa9, 0xf3, 0x95, 0x04, 0x72, 0xa8, 0x11, 0xd9, 0xfc, 0x77,
  0xce, 0x9e, 0x2a, 0x6d, 0xca, 0x93, 0xde, 0x6c, 0x9d, 0xb1, 0xf6, 0x5c,
  0x3f, 0x91, 0xe2, 0x7d, 0xc6, 0x6b, 0xb7, 0xf1, 0x74, 0xc9, 0xfa, 0x64,
  0x2c, 0xfb, 0x20, 0x2e, 0x6d, 0x0e, 0x4b, 0x8b, 0x57, 0xdc, 0xb8, 0x36,
  0xec, 0xd6, 0xa0, 0x55, 0xa0, 0x40, 0x30, 0x86, 0xdc, 0x82, 0x85, 0xa9,
  0x0a, 0x85, 0x3b, 0x04, 0x55, 0x93, 0xaa, 0x85, 0x29, 0x4a, 0x24, 0x48,
  0x36, 0xeb, 0x37, 0x48, 0x5f, 0x43, 0xa3, 0x7a, 0x81, 0x77, 0x27, 0x05,
  0xb3, 0x0c, 0xc8, 0x58, 0xd8, 0x08, 0x7b, 0xb7, 0x67, 0x49, 0x7e, 0x25,
  0xf7, 0x28, 0x89, 0x44, 0x4d, 0x2b, 0x8b, 0xf8, 0xbd, 0x63, 0x17, 0x42,
  0xc5, 0x07, 0xef, 0x0f, 0x7d, 0xf1, 0xbc, 0x30, 0x5b, 0x5d, 0xc2, 0xc5,
  0xaa, 0xa2, 0x6f, 0xb7, 0x3f, 0x89, 0xd4, 0x89, 0x35, 0xa7, 0x95, 0xa0,
  0x7d, 0x6c, 0x4a, 0x03, 0xd3, 0xe9, 0xab, 0x29, 0xc9, 0x26, 0xab, 0x6e,
  0xa4, 0x51, 0x3e, 0x24, 0x8b, 0xcd, 0x13, 0x8e, 0xce, 0x62, 0x6b, 0x1d,
  0xb6, 0x32, 0x1a, 0x5f, 0x2f, 0xe7, 0x37, 0x66, 0xa1, 0x9b, 0x92, 0x64,
  0x5a, 0x44, 0x1c, 0xca, 0x5d, 0x6b, 0xae, 0x1b, 0x74, 0xf6, 0x87, 0xb0,
  0xed, 0xd6, 0x55, 0x16, 0x09, 0x1b, 0x41, 0x79, 0x81, 0xe7, 0xcb, 0x31,
  0x78, 0x75, 0x26, 0x7d, 0xde, 0x33, 0xaf, 0x72, 0x19, 0x38, 0x1c, 0xe2,
  0xe6, 0x39, 0xf4, 0xd2, 0x39, 0x7b, 0x2a, 0x5c, 0x83, 0xe2, 0x1d, 0x22,
  0x86, 0xd7, 0x37, 0x67, 0xaa, 0xd7, 0xab, 0x9c, 0x63, 0xa3, 0xcd, 0xf5,
  0x21, 0xf4, 0xee, 0xdd, 0x96, 0x2e, 0x5a, 0x9e, 0xcf, 0x5b, 0x61, 0x62,
  0x12, 0x77, 0xcd, 0x06, 0x34, 0xbd, 0x2f, 0x9a, 0x32, 0x17, 0x75, 0xd5,
  0x77, 0x27, 0xee, 0x4d, 0x18, 0x0b, 0x58, 0x0d, 0x6d, 0x70, 0x04, 0x31,
  0x88, 0xce, 0x32, 0x09, 0xee, 0xe5, 0x51, 0xb4, 0x7a, 0x7c, 0x63, 0x3f,
  0xe9, 0x49, 0xd4, 0xbd, 0xcc, 0xb2, 0x51, 0x9c, 0x77, 0x75, 0x0b, 0xd9,
  0xc3, 0x3e, 0x52, 0xbb, 0x97, 0x7a, 0xaf, 0x79, 0x3a, 0x9f, 0xd3, 0x73,
  0x75, 0x0a, 0x1d, 0x85, 0xe1, 0x4d, 0xd5, 0x73, 0xf7, 0x10, 0x47, 0xbe,
  0x50, 0x39, 0xbd, 0x54, 0x5b, 0x3a, 0x8b, 0xa2, 0x53, 0xbe, 0xe4, 0x6b,
  0xfe, 0x19, 0xb8, 0x07, 0xc5, 0xad, 0x8f, 0x50, 0xa5, 0xc6, 0x95, 0x06,
  0x57, 0x1c, 0x22, 0x40, 0x88, 0xb6, 0x8a, 0x2c, 0xb9, 0x4d, 0xf2, 0x7f,
  0x07, 0xb1, 0x60, 0xd9, 0x68, 0x43, 0x0f, 0xf9, 0xfe, 0x90, 0x79, 0xb8,
  0x08, 0x62, 0x09, 0xf9, 0x8a, 0x2c, 0x7e, 0xb8, 0xc1, 0xe3, 0x5a, 0x02,
  0x8e, 0x7a, 0x98, 0xe1, 0x38, 0x59, 0x94, 0x76, 0x46, 0xe6, 0xc9, 0x9d,
  0x7a, 0x27, 0xc1, 0x5c, 0x71, 0x15, 0x80, 0x6f, 0x8b, 0xb1, 0x69, 0xcc,
  0x57, 0x74, 0xc1, 0x4c, 0x85, 0xbe, 0xad, 0x6b, 0x20, 0x58, 0x02, 0xde,
  0xb9, 0x5f, 0x78, 0x2b, 0x9b, 0xe6, 0xc5, 0xae, 0x51, 0x7f, 0x3b, 0xb7,
  0x08, 0xdb, 0x1c, 0xd0, 0x21, 0x21, 0xac, 0x1c, 0xc8, 0x24, 0x31, 0x7a,
  0xc8, 0x8b, 0x90, 0x8c, 0x80, 0x91, 0x2c, 0x89, 0xe3, 0xfe, 0x0d, 0x32,
  0x71, 0x5c, 0xf4, 0xe7, 0x50, 0x4a, 0xcf, 0xad, 0xb0, 0x5e, 0x69, 0x12,
  0xf5, 0xab, 0x14, 0x6a, 0xdc, 0x16, 0x5b, 0xdb, 0x72, 0x2a, 0x65, 0x95,
  0x53, 0x66, 0xba, 0xb1, 0x29, 0x8b, 0x49, 0x0e, 0x66, 0x5f, 0xb0, 0x4b,
  0xc8, 0xac, 0x74, 0x83, 0x68, 0x73, 0x7f, 0x32, 0x91, 0x09, 0x7c, 0x32,
  0xd8, 0xfd, 0x74, 0xb0, 0xb3, 0xd5, 0x22, 0x9a, 0x8d, 0x24, 0x18, 0x4a,
  0xcd, 0x26, 0x69, 0x8c, 0x10, 0x79, 0x74, 0x23, 0xd3, 0xd1, 0x84, 0x05,
  0x23, 0x24, 0xd2, 0x8f, 0x84, 0xe2, 0x62, 0x3e, 0x75, 0x0d, 0xe3, 0x01,
  0x96, 0x5a, 0x54, 0x93, 0xd8, 0xd8, 0x73, 0x26, 0x41, 0x90, 0xb1, 0x71,
  0x0d, 0x17, 0x8e, 0x12, 0x07, 0x7e, 0xd8, 0xd6, 0xb5, 0xe3, 0xae, 0xc1,
  0x1c, 0xe0, 0x5e, 0x8d, 0xd9, 0xb0, 0x49, 0xcb, 0xc5, 0x5c, 0xab, 0x61,
  0x38, 0xf5, 0xbb, 0x2c, 0x09, 0x20, 0x49, 0xf1, 0x62, 0xa3, 0x61, 0x8b,
  0xe0, 0xfe, 0xdb, 0xb3, 0xa7, 0x44, 0x16, 0xf7, 0x3e, 0x6b, 0xee, 0xc5,
  0x2d, 0x66, 0x12, 0x8a, 0x19, 0x22, 0xd9, 0x88, 0x60, 0x12, 0xaf, 0x69,
  0x0e, 0x13, 0xfb, 0x6f, 0xea, 0x51, 0x18, 0x13, 0x81, 0x43, 0xe2, 0x2c,
  0x32, 0xef, 0xc3, 0xb5, 0xa6, 0x5c, 0xa8, 0x1e, 0x7f, 0x12, 0x37, 0xfc,
  0xd9, 0x2e, 0xac, 0x69, 0x15, 0x45, 0xaf, 0x24, 0x6d, 0xe9, 0xf3, 0x48,
  0x8f, 0x3a, 0x6c, 0xc0, 0xa1, 0x9e, 0xcb, 0xea, 0x18, 0x0f, 0x9e, 0x2f,
  0x63, 0x5e, 0x86, 0xf6, 0xe6, 0xd8, 0xd5, 0x1f, 0xae, 0x9e, 0x90, 0x1f,
  0x82, 0x38, 0x0b, 0x49, 0x01, 0x6a, 0x38, 0x57, 0x5f, 0x7d, 0x78, 0xf5,
  0x7e, 0xe6, 0xe2, 0x7d, 0x60, 0xf5, 0x2e, 0x38, 0x22, 0x97, 0x84, 0x04,
  0x8e, 0x9c, 0x79, 0x15, 0x04, 0x56, 0x40, 0x07, 0x4e, 0xe7, 0xe3, 0xe9,
  0x72, 0xe2, 0x3d, 0xd5, 0xd5, 0xa3, 0x19, 0x18, 0x32, 0x5e, 0xfd, 0x6a,
  0xbb, 0xce, 0xd4, 0x68, 0xa3, 0x6f, 0x6f, 0x4e, 0x34, 0x5a, 0x1a, 0xbc,
  0x8f, 0x6f, 0x62, 0xbd, 0x90, 0x03, 0xf5, 0xf1, 0x3a, 0xf5, 0x96, 0xdc,
  0x2f, 0xc4, 0x90, 0xcb, 0x17, 0xef, 0x28, 0x69, 0x93, 0xe6, 0x2a, 0x42,
  0xdd, 0xc4, 0x2e, 0xd5, 0xc6, 0xfc, 0x3e, 0x37, 0x2e, 0xfe, 0xc1, 0xc9,
  0x55, 0xe2, 0x30, 0x38, 0xe6, 0x28, 0xbc, 0xda, 0x43, 0x0b, 0x4c, 0x8b,
  0x3d, 0xc8, 0x38, 0x99, 0xac, 0xb9, 0xb8, 0x9e, 0x57, 0x8e, 0xbb, 0x6f,
  0xf5, 0xaa, 0x0b, 0x16, 0xab, 0xd4, 0x2b, 0x1e, 0xa5, 0xf5, 0x6b, 0xc5,
  0x56, 0x7b, 0xdb, 0x3e, 0x68, 0x2e, 0xad, 0xdb, 0xf7, 0x7f, 0xfa, 0x14,
  0xd9, 0xe3, 0x67, 0xa1, 0xa0, 0x32, 0x4d, 0x35, 0x67, 0x79, 0xa2, 0xb8,
  0x82, 0xb7, 0x17, 0xe6, 0xc7, 0xbf, 0x2d, 0xd9, 0xcc, 0x77, 0xb5, 0x8e,
  0x09, 0xf0, 0x05, 0x05, 0x23, 0x23, 0x4c, 0x32, 0x53, 0x96, 0x8d, 0xa8,
  0x69, 0xa6, 0x72, 0xaf, 0xcf, 0xf4, 0x39, 0xa4, 0x48, 0x89, 0x56, 0x28,
  0xf1, 0x01, 0x62, 0x75, 0xe4, 0x19, 0x52, 0xa6, 0xc4, 0x00, 0xf8, 0x29,
  0xb7, 0x50, 0xa0, 0xb9, 0x95, 0xdb, 0x6f, 0x3b, 0x09, 0x82, 0x28, 0xc4,
  0xf5, 0x7e, 0xa8, 0xfe, 0xe7, 0x35, 0xbe, 0xf7, 0x38, 0xf8, 0xa6, 0xe9,
  0xd6, 0xb3, 0x4b, 0x0e, 0xe6, 0x43, 0x96, 0x38, 0x39, 0x50, 0x9f, 0x56,
  0xfc, 0x2e, 0xcb, 0xd5, 0x70, 0x37, 0x4a, 0x98, 0xeb, 0xe3, 0x88, 0xc2,
  0x73, 0x27, 0x96, 0x60, 0xc4, 0xfc, 0x35, 0x83, 0x83, 0x60, 0xd9, 0x8d,
  0x38, 0xb2, 0x61, 0x20, 0x66, 0x32, 0x8b, 0x22, 0x6a, 0x8f, 0x1b, 0x92,
  0x74, 0x8b, 0xa8, 0xbf, 0xd4, 0xc0, 0xe5, 0x76, 0x1f, 0x1a, 0x47, 0x21,
  0x4b, 0x76, 0xa8, 0x2c, 0xa5, 0xf1, 0x08, 0x0c, 0x51, 0x1c, 0x32, 0x2c,
  0xdc, 0x7a, 0x8f, 0xfc, 0x5a, 0x27, 0xbc, 0x3a, 0xe9, 0x2d, 0x16, 0x12,
  0x26, 0x0a, 0xcb, 0x8b, 0x54, 0x99, 0xe0, 0x3f, 0x1a, 0x17, 0xd8, 0xd7,
  0x20, 0x8d, 0x7e, 0xb2, 0xc8, 0xcb, 0xd6, 0x80, 0xf8, 0x8b, 0xd0, 0xd8,
  0x68, 0x21, 0x1d, 0xec, 0x9d, 0x2c, 0xdc, 0x5d, 0x73, 0x74, 0x76, 0x7e,
  0xc1, 0x13, 0x3d, 0xc1, 0x2f, 0x6a, 0xe2, 0xac, 0x8f, 0x83, 0xad, 0x0e,
  0x1a, 0x67, 0x8b, 0x58, 0xb3, 0x84, 0x8d, 0x43, 0x2e, 0x6b, 0x68, 0x10,
  0x78, 0x1c, 0x5d, 0x52, 0x4c, 0x3c, 0xbd, 0x43, 0x7e, 0x09, 0x8b, 0x74,
  0x8d, 0xb5, 0x75, 0xe9, 0x49, 0x18, 0x09, 0x86, 0xd0, 0x93, 0xfb, 0x92,
  0x07, 0xa1, 0xa6, 0x5d, 0x11, 0x2a, 0xce, 0x4e, 0xf1, 0x25, 0xec, 0xf8,
  0x16, 0x60, 0xbd, 0xc6, 0x7b, 0x2a, 0x29, 0x24, 0xca, 0x7d, 0xd0, 0x2c,
  0xde, 0x8c, 0x72, 0xce, 0xfd, 0x8a, 0x69, 0x28, 0x83, 0xda, 0x54, 0x21,
  0x05, 0x13, 0xe9, 0x05, 0x19, 0xbe, 0xa6, 0x81, 0xb2, 0xb4, 0x67, 0x92,
  0x20, 0x35, 0xc0, 0x29, 0x31, 0x98, 0xb0, 0x65, 0x81, 0xf5, 0x58, 0x77,
  0xc7, 0xc5, 0xc7, 0x21, 0xc1, 0xc8, 0x7b, 0x41, 0xa7, 0x62, 0x08, 0xa9,
  0x8f, 0x0e, 0x43, 0xa7, 0x93, 0xcb, 0x6b, 0x2f, 0x9a, 0x7a, 0x74, 0xa9,
  0x96, 0xcd, 0x78, 0x9a, 0x96, 0x2b, 0x11, 0xf1, 0x47, 0x72, 0x9f, 0xaa,
  0xe1, 0x47, 0xd8, 0x30, 0xad, 0xef, 0x24, 0x6d, 0x3b, 0x84, 0x34, 0x1c,
  0x9e, 0x9c, 0xee, 0xd6, 0x2f, 0x94, 0xca, 0x5b, 0x9d, 0xba, 0xeb, 0xbc,
  0xba, 0xd2, 0x5e, 0xc3, 0xaf, 0xeb, 0x49, 0xb0, 0xb8, 0x6d, 0x25, 0x41,
  0xa1, 0xc1, 0x40, 0xb7, 0x35, 0x32, 0x6c, 0xd2, 0xe1, 0xf0, 0x1b, 0x67,
  0x61, 0x6f, 0x09, 0xdb, 0x15, 0xea, 0xc3, 0x41, 0x5e, 0x47, 0x7e, 0x3a,
  0x01, 0x9f, 0x95, 0xa5, 0x14, 0xf8, 0x20, 0x09, 0xf2, 0x98, 0x84, 0x08,
  0xa9, 0x7f, 0xa5, 0xbc, 0xb3, 0xfd, 0xe1, 0x37, 0x01, 0xcd, 0x05, 0x6b,
  0xe9, 0xb2, 0x37, 0xea, 0x97, 0x23, 0xb2, 0x6f, 0x72, 0x8b, 0x05, 0x43,
  0x5b, 0xff, 0xb9, 0x4d, 0xa9, 0x05, 0xe6, 0x89, 0xa3, 0xb7, 0x2e, 0xcc,
  0x7f, 0xcb, 0xce, 0x5b, 0xcd, 0xb3, 0x92, 0x54, 0xc9, 0x20, 0xd2, 0xaf,
  0x9a, 0x9d, 0xca, 0x71, 0x87, 0x1b, 0x6d, 0xd1, 0xee, 0xa1, 0x87, 0x4b,
  0xe2, 0x42, 0xf5, 0x48, 0x33, 0xc3, 0x70, 0x96, 0x8d, 0xd2, 0x42, 0x16,
  0xd1, 0xae, 0x76, 0xb3, 0xd1, 0x72, 0xfd, 0xc5, 0x1a, 0xaa, 0x9c, 0xb2,
  0x43, 0x96, 0xfd, 0xfe, 0x19, 0x5a, 0x19, 0x68, 0x00, 0x71, 0x11, 0x4a,
  0x0f, 0x36, 0x5c, 0x09, 0x65, 0x6c, 0x2a, 0x66, 0x73, 0x11, 0xe7, 0xd8,
  0xf4, 0x62, 0x89, 0xb8, 0x1c, 0xe4, 0x16, 0x64, 0xf8, 0xf9, 0xf0, 0x3d,
  0xb6, 0xf0, 0xf9, 0xa8, 0xcd, 0x56, 0x0e, 0xf3, 0x3b, 0x16, 0x15, 0xd6,
  0xc4, 0x55, 0x62, 0x05, 0x24, 0xd5, 0x0e, 0x36, 0x2a, 0x3d, 0xce, 0x7c,
  0x9e, 0x9b, 0x3e, 0x9c, 0x4a, 0xfc, 0x66, 0x63, 0x65, 0x43, 0x57, 0x48,
  0x36, 0xb7, 0x80, 0xc4, 0x24, 0xf4, 0x44, 0xb9, 0x88, 0x15, 0xd1, 0xe8,
  0x63, 0x6e, 0x6d, 0x5e, 0xa4, 0x13, 0x24, 0xf7, 0xd7, 0xf9, 0x0f, 0x5f,
  0xc8, 0x1d, 0x5d, 0xae, 0x8e, 0x06, 0x97, 0x2c, 0xe5, 0x2d, 0xc4, 0x7e,
  0xb2, 0x65, 0x2a, 0x4f, 0x7e, 0x43, 0xbf, 0x4f, 0x42, 0x2b, 0xc6, 0xa9,
  0x61, 0xa0, 0x46, 0x12, 0x64, 0x1e, 0xb6, 0xa8, 0x73, 0x0c, 0xf3, 0xb9,
  0x3e, 0x7e, 0x16, 0x5f, 0x25, 0x48, 0x20, 0x13, 0x47, 0xb8, 0x5e, 0xf0,
  0x1f, 0x48, 0x2f, 0x6a, 0x24, 0xe8, 0x40, 0x20, 0xf0, 0x6e, 0x9a, 0x20,
  0x1f, 0xe7, 0x72, 0x1a, 0x5f, 0x05, 0xd9, 0x38, 0xba, 0xf8, 0xcd, 0x80,
  0xda, 0x89, 0x9a, 0x39, 0xab, 0xa1, 0xcb, 0x2e, 0x29, 0x5b, 0x4c, 0x15,
  0x9d, 0x3f, 0xc3, 0x9f, 0xd7, 0xb1, 0x01, 0xba, 0x29, 0x37, 0x63, 0xad,
  0xf0, 0x88, 0x57, 0x70, 0xaa, 0x5e, 0x40, 0x8c, 0x55, 0x8e, 0xa5, 0x7a,
  0x68, 0xf1, 0x3c, 0x1f, 0x27, 0xe2, 0x3c, 0x24, 0x33, 0xd4, 0xf9, 0x00,
  0xc9, 0x10, 0x12, 0x9c, 0x78, 0xa2, 0xc3, 0x7a, 0xa1, 0x27, 0x43, 0x74,
  0x36, 0x1b, 0x94, 0x26, 0x35, 0xa9, 0xfa, 0x2e, 0x51, 0x46, 0x53, 0x20,
  0x18, 0xd4, 0x2d, 0xd7, 0x10, 0xc9, 0xd5, 0x2a, 0x39, 0x61, 0xef, 0x3c,
  0x06, 0x14, 0x43, 0x35, 0x48, 0x39, 0x85, 0xdd, 0x4d, 0xeb, 0xb7, 0xf4,
  0x13, 0x26, 0xf3, 0x2b, 0xa4, 0xee, 0xbe, 0x6c, 0x8d, 0x4e, 0x49, 0xa6,
  0x3e, 0xad, 0xd2, 0x02, 0xe6, 0xc6, 0xf9, 0x6a, 0x01, 0x7c, 0x00, 0x79,
  0x4f, 0x99, 0x10, 0x04, 0x36, 0x09, 0x8b, 0x0b, 0xf2, 0x6f, 0x07, 0x2d,
  0xee, 0x59, 0xd7, 0xa1, 0x44, 0x0c, 0xe2, 0x4a, 0x58, 0xd0, 0x72, 0x95,
  0xbc, 0xae, 0xf2, 0x19, 0x92, 0x78, 0x46, 0xcb, 0x74, 0x3a, 0x91, 0x60,
  0x1d, 0x0f, 0x67, 0xd0, 0xb0, 0xfc, 0xa3, 0xa1, 0x62, 0xa0, 0x49, 0x35,
  0x66, 0x7b, 0x43, 0x96, 0x25, 0xcb, 0x08, 0x9b, 0xb0, 0x19, 0xcc, 0x69,
  0xee, 0x5b, 0x76, 0xf1, 0xe9, 0x1b, 0x1a, 0x5e, 0x5f, 0xbf, 0xa6, 0x6e,
  0xe3, 0x74, 0x2a, 0x89, 0x7d, 0x65, 0x94, 0x2f, 0xe7, 0xdc, 0x7b, 0x75,
  0xa5, 0x6e, 0xd3, 0x3c, 0x9b, 0xcf, 0x9a, 0x3a, 0xf5, 0xe6, 0xf9, 0xf1,
  0xf0, 0x20, 0x3a, 0x1d, 0x46, 0xa7, 0x6f, 0x4f, 0xbe, 0xdf, 0xa2, 0x65,
  0x83, 0x5a, 0x23, 0xf0, 0x00, 0xe8, 0x3a, 0x78, 0x31, 0xba, 0x8d, 0xf3,
  0x94, 0x55, 0x84, 0x5e, 0x10, 0xa1, 0xd2, 0xa2, 0xfe, 0xc9, 0xd9, 0xec,
  0xdf, 0xd9, 0x16, 0xfb, 0xe8, 0x37, 0xc6, 0x66, 0x28, 0x52, 0x30, 0x3f,
  0x0e, 0xd0, 0x62, 0xe3, 0xea, 0xd8, 0x92, 0xdd, 0x96, 0xcd, 0xdc, 0x2b,
  0x58, 0x60, 0xc2, 0x53, 0x2d, 0xa1, 0x43, 0xd7, 0xf1, 0x2d, 0xba, 0xa7,
  0x89, 0xb6, 0xfb, 0xd2, 0xff, 0x7d, 0x82, 0x4d, 0x72, 0x25, 0xaa, 0x5b,
  0xfb, 0xed, 0x29, 0x71, 0xaf, 0x2e, 0x50, 0x4a, 0x68, 0x71, 0x11, 0x43,
  0x3e, 0x65, 0x9d, 0xc3, 0x78, 0xc0, 0xd1, 0xbc, 0xcc, 0xb3, 0xc5, 0x2a,
  0xfa, 0x32, 0x06, 0x8b, 0xc5, 0xd4, 0x0e, 0xe3, 0x64, 0xd6, 0x70, 0x2f,
  0x17, 0xd9, 0xf8, 0x26, 0x29, 0xe5, 0xc0, 0xca, 0xef, 0x3e, 0x46, 0x1b,
  0xea, 0x8c, 0xb0, 0xe8, 0x08, 0x9b, 0x37, 0xc1, 0xfd, 0xa7, 0xd4, 0x2a,
  0x91, 0xe0, 0x34, 0x94, 0xa6, 0x65, 0xcd, 0x72, 0xfd, 0x03, 0x85, 0x47,
  0x79, 0x12, 0x37, 0x21, 0x53, 0xab, 0x47, 0x9c, 0xf5, 0x8f, 0x70, 0xb3,
  0xc1, 0x55, 0xfb, 0x12, 0xff, 0x8a, 0x51, 0x30, 0xf9, 0xe1, 0x85, 0x69,
  0x4f, 0x3f, 0xb5, 0x2f, 0x43, 0x33, 0xc6, 0xbb, 0x2a, 0x3e, 0x04, 0x6d,
  0x69, 0x54, 0x14, 0xb8, 0xd9, 0x55, 0x33, 0x4b, 0xa8, 0x94, 0x3c, 0x3e,
  0x8d, 0x9c, 0xa2, 0xc5, 0x64, 0x64, 0xa1, 0x48, 0x82, 0xf2, 0x87, 0xb2,
  0x3c, 0x61, 0x63, 0x16, 0x23, 0xcc, 0x1a, 0xfd, 0xd9, 0xd1, 0x9b, 0x75,
  0xb1, 0x53, 0xaa, 0x95, 0x25, 0x76, 0x8f, 0x13, 0xa5, 0x38, 0x9d, 0x55,
  0x52, 0x4b, 0xdd, 0x60, 0xc3, 0xec, 0xdc, 0x5a, 0x73, 0x7f, 0x5b, 0x02,
  0xab, 0x65, 0xc2, 0x8b, 0xae, 0x1e, 0x36, 0x97, 0x08, 0x1d, 0x58, 0x98,
  0x6a, 0xa1, 0x3f, 0x02, 0xe1, 0x00, 0x0e, 0x5d, 0x4f, 0x5a, 0x0d, 0x66,
  0xd2, 0x51, 0x77, 0x91, 0x45, 0x2a, 0x09, 0xff, 0xe7, 0x94, 0x9e, 0xe8,
  0x26, 0x59, 0xb9, 0x78, 0x50, 0xfb, 0x8c, 0x5e, 0x6d, 0xae, 0x9d, 0x2e,
  0x0a, 0x6d, 0x3e, 0x7e, 0xce, 0xa1, 0xa6, 0xfe, 0x8e, 0x77, 0x5f, 0xf7,
  0x54, 0xcc, 0x23, 0xfd, 0x3e, 0x1a, 0x64, 0x16, 0x57, 0x04, 0xd4, 0x3b,
  0x6b, 0xe4, 0xa4, 0x38, 0x94, 0x9e, 0xe9, 0xaa, 0x55, 0xcb, 0xf5, 0x98,
  0x42, 0x60, 0x8b, 0xa5, 0xa4, 0x17, 0x17, 0xa5, 0x45, 0x1e, 0x73, 0x58,
  0xf6, 0x34, 0x1d, 0xe5, 0x70, 0xda, 0xb0, 0x34, 0x16, 0x1c, 0xdc, 0x46,
  0xcc, 0x9c, 0x27, 0x20, 0xe8, 0xf9, 0xe9, 0xf8, 0x86, 0x4f, 0x91, 0x32,
  0xc8, 0x70, 0xcb, 0x4d, 0xbc, 0x14, 0x94, 0x1e, 0xed, 0xab, 0xae, 0x29,
  0xc4, 0x65, 0x0c, 0x94, 0x0e, 0xce, 0x1a, 0x48, 0xe7, 0x86, 0x76, 0x24,
  0xd1, 0x49, 0x01, 0xd7, 0x73, 0x6c, 0x0f, 0x63, 0x7d, 0x7f, 0x78, 0x7c,
  0xce, 0xcc, 0x79, 0xb4, 0x5a, 0x93, 0x7a, 0xb0, 0x9d, 0x94, 0xe3, 0xed,
  0xc5, 0x4d, 0xba, 0x3d, 0x2f, 0x8a, 0xc9, 0x68, 0xcb, 0x25, 0x1d, 0x62,
  0xb2, 0xa0, 0x3e, 0xfa, 0xe7, 0xeb, 0x83, 0xe1, 0x47, 0xbb, 0xbb, 0x9c,
  0x6f, 0xbd, 0x84, 0x8a, 0xb3, 0x49, 0x0b, 0xd0, 0x48, 0x27, 0x2b, 0x68,
  0xdd, 0x67, 0x83, 0x22, 0xdb, 0x62, 0x73, 0x8b, 0xe3, 0xef, 0xbc, 0x46,
  0x68, 0x46, 0x9c, 0x70, 0x9a, 0x6c, 0x05, 0xcb, 0x59, 0x32, 0xf9, 0x4d,
  0x43, 0x72, 0x68, 0x75, 0xd9, 0x53, 0x1f, 0xbd, 0xc4, 0xbf, 0x1f, 0x3c,
  0xe2, 0x0c, 0xaf, 0x52, 0xd9, 0x12, 0xbc, 0xab, 0x8a, 0xc4, 0x6d, 0x0a,
  0xf3, 0x54, 0xf8, 0x75, 0x33, 0x38, 0x0b, 0x6e, 0x4b, 0x9a, 0x67, 0x2f,
  0x3a, 0x3c, 0x3a, 0x67, 0x9a, 0x3c, 0x7a, 0xfb, 0x25, 0xcb, 0xa2, 0x48,
  0x48, 0xbb, 0x9a, 0xa7, 0x7f, 0x07, 0xb7, 0xa3, 0x36, 0x0b, 0x09, 0xd2,
  0xc2, 0xd5, 0xe9, 0x8f, 0x67, 0xad, 0x39, 0xac, 0x17, 0x56, 0x91, 0x0f,
  0xd9, 0x6f, 0xbb, 0x4c, 0xb1, 0x30, 0xc6, 0x83, 0xfd, 0x70, 0x76, 0xbf,
  0x12, 0x43, 0xa4, 0xa7, 0x68, 0x44, 0x74, 0x16, 0x5b, 0xdc, 0x4b, 0x8b,
  0xc4, 0x44, 0x39, 0x71, 0xeb, 0x12, 0x5d, 0xa8, 0x6f, 0x22, 0x04, 0xba,
  0xa2, 0x61, 0x85, 0xcd, 0x16, 0xad, 0x49, 0x03, 0xc1, 0x03, 0x9b, 0xc5,
  0x96, 0x63, 0x9f, 0xa9, 0xd2, 0x5d, 0x7b, 0xb2, 0x9b, 0x4f, 0x16, 0xe4,
  0xbd, 0x29, 0x54, 0x66, 0x69, 0x0a, 0x0f, 0xe6, 0xf7, 0x3d, 0x20, 0x81,
  0xf5, 0xfd, 0xc1, 0xfe, 0xfb, 0x2f, 0xde, 0xbd, 0x3d, 0x3c, 0x39, 0xea,
  0xd6, 0x09, 0xe0, 0xd2, 0x71, 0x39, 0x12, 0x2c, 0x25, 0x6c, 0xbe, 0x16,
  0xb3, 0xc6, 0xf7, 0x28, 0xa7, 0x63, 0xf2, 0x6f, 0x1c, 0xdc, 0xea, 0x26,
  0xd8, 0x30, 0xae, 0xcc, 0x27, 0x9c, 0x14, 0x17, 0x6c, 0xb3, 0x25, 0x0c,
  0xa8, 0x33, 0xc6, 0xc6, 0xd7, 0xa2, 0xc1, 0x26, 0x9c, 0x47, 0x35, 0x61,
  0x09, 0x5a, 0xfd, 0x9f, 0x22, 0xe9, 0x05, 0x10, 0x3c, 0x15, 0xe1, 0x1c,
  0x71, 0x06, 0x7c, 0x01, 0xc4, 0x34, 0xa0, 0x96, 0xd5, 0x2d, 0x2a, 0x1e,
  0x70, 0xb4, 0x42, 0x84, 0xd3, 0xd7, 0x41, 0x8e, 0xf3, 0xb2, 0x4b, 0xc2,
  0x49, 0xca, 0xce, 0x9d, 0x30, 0xda, 0x67, 0xd2, 0x9a, 0x43, 0x81, 0x40,
  0xb5, 0x58, 0xc8, 0x68, 0x90, 0xdc, 0x27, 0x1c, 0x30, 0xa0, 0x6f, 0x1d,
  0xb0, 0x64, 0x53, 0x46, 0xdf, 0x66, 0x39, 0x27, 0xb9, 0x1f, 0x5a, 0x64,
  0x9b, 0x3d, 0x14, 0xcf, 0x57, 0x4d, 0x5f, 0xe0, 0x84, 0xa5, 0xb3, 0x8c,
  0x9e, 0x67, 0x9c, 0xb8, 0xb3, 0xfd, 0x8b, 0xaf, 0xda, 0x4e, 0x8c, 0xa8,
  0xc7, 0xc5, 0x23, 0xd8, 0xba, 0x6a, 0xd9, 0xe5, 0xfa, 0xb8, 0x39, 0xe1,
  0xec, 0xeb, 0x59, 0x7b, 0xf5, 0x34, 0x35, 0xb9, 0x7b, 0x4b, 0x12, 0x8d,
  0xe3, 0xee, 0xc6, 0xdc, 0x47, 0xab, 0xf5, 0x24, 0x19, 0x32, 0xf6, 0xf5,
  0x9c, 0xbd, 0xc9, 0xda, 0xbd, 0xc8, 0x80, 0x2e, 0x71, 0x3a, 0x8c, 0xb7,
  0x2b, 0x6b, 0xff, 0x3f, 0x82, 0xb3, 0xc7, 0x7c, 0x7e, 0x6a, 0x2c, 0xcb,
  0x87, 0x41, 0xae, 0x11, 0x6a, 0x2f, 0xc2, 0x3d, 0xfb, 0x10, 0xfb, 0xf2,
  0x31, 0x95, 0x0d, 0x23, 0x87, 0x70, 0xb4, 0x1a, 0x0f, 0x0b, 0x79, 0x54,
  0x3b, 0x03, 0xea, 0x99, 0xb4, 0x53, 0xdf, 0x2c, 0xd7, 0x93, 0xbc, 0x07,
  0x5d, 0x01, 0xf8, 0x1e, 0x09, 0x38, 0x46, 0x9e, 0x8d, 0x25, 0xd3, 0x26,
  0x08, 0x42, 0x7b, 0x9f, 0x27, 0xd7, 0x71, 0x71, 0x1d, 0x2d, 0xcb, 0x14,
  0x66, 0xd6, 0xba, 0xc8, 0xbd, 0x44, 0x24, 0x9a, 0xc5, 0x83, 0x58, 0x3e,
  0x97, 0xa6, 0x5b, 0xbb, 0xb5, 0x63, 0xb8, 0x05, 0x4d, 0x39, 0xf1, 0x26,
  0x4c, 0xa8, 0xee, 0x75, 0xa5, 0x74, 0x78, 0xd2, 0x0f, 0x21, 0xb6, 0x66,
  0x48, 0xfc, 0x63, 0x63, 0x6f, 0x72, 0x49, 0xd3, 0x4d, 0x83, 0x1c, 0xaf,
  0xa5, 0xeb, 0x82, 0x6f, 0x94, 0xf4, 0xb2, 0x2d, 0x33, 0xc4, 0xbe, 0x65,
  0x76, 0xa2, 0xfc, 0xbe, 0x10, 0x10, 0xae, 0xea, 0x76, 0x16, 0xbf, 0x21,
  0x05, 0x5d, 0x22, 0xf8, 0x8e, 0xa8, 0x78, 0x8d, 0xb5, 0xe6, 0x35, 0x83,
  0xb5, 0x14, 0xf0, 0x08, 0x62, 0x72, 0x9b, 0xf3, 0xcc, 0xb0, 0x8d, 0x60,
  0xca, 0x9b, 0x4e, 0xb7, 0x20, 0x26, 0xab, 0xc1, 0x8a, 0x63, 0xf9, 0x8b,
  0xd6, 0x24, 0x58, 0x64, 0xb6, 0x67, 0x45, 0x69, 0x08, 0x5f, 0x0c, 0xc7,
  0xc9, 0x13, 0x60, 0xbf, 0x17, 0x9b, 0xd1, 0xd4, 0x7a, 0xce, 0x90, 0x90,
  0xc4, 0x63, 0xe9, 0xb4, 0xaa, 0xb7, 0x16, 0xdf, 0x36, 0x0e, 0x75, 0x3c,
  0xb5, 0xa0, 0xb4, 0x4b, 0x45, 0x93, 0x54, 0x63, 0x2f, 0xf5, 0x7f, 0x3c,
  0x37, 0x37, 0x92, 0x78, 0xd7, 0x59, 0x15, 0x89, 0x43, 0x63, 0x52, 0x9d,
  0x6f, 0x72, 0xca, 0x20, 0xdc, 0x27, 0xc9, 0x34, 0x15, 0xe3, 0x9e, 0x65,
  0x73, 0xb1, 0xae, 0x20, 0x29, 0x5f, 0x85, 0x8b, 0xb5, 0xb4, 0x2f, 0x11,
  0x18, 0x54, 0x36, 0x13, 0x16, 0x90, 0x08, 0xb4, 0xa9, 0x80, 0x1e, 0x0c,
  0x20, 0x67, 0xd9, 0x41, 0x16, 0xde, 0x82, 0x21, 0xad, 0x1c, 0x22, 0xe8,
  0x96, 0xde, 0x6c, 0x6c, 0xa7, 0x6a, 0x31, 0x3b, 0xab, 0x1f, 0x4e, 0x68,
  0x53, 0xf0, 0x5c, 0x79, 0x07, 0x4a, 0x39, 0x05, 0x71, 0x19, 0xa6, 0xa5,
  0x49, 0x3e, 0xc5, 0xde, 0x5e, 0xbb, 0x29, 0x57, 0x73, 0x56, 0xd5, 0xa1,
  0x8f, 0x69, 0xf7, 0x8b, 0xf8, 0xd2, 0x81, 0x72, 0x10, 0x25, 0x43, 0x46,
  0x23, 0xad, 0x3a, 0x16, 0xff, 0x08, 0xc7, 0xa8, 0xb3, 0x29, 0xa3, 0xe1,
  0x3f, 0x59, 0x8e, 0x71, 0x1a, 0xa1, 0xe1, 0x07, 0xb0, 0x57, 0xf0, 0x5c,
  0x3a, 0xe7, 0x70, 0x31, 0x4d, 0x17, 0xd4, 0x6a, 0x9e, 0x2d, 0xaf, 0xae,
  0xe9, 0x4a, 0x64, 0xde, 0xc2, 0x17, 0x6c, 0x8b, 0xe1, 0xbf, 0x96, 0x5c,
  0xcb, 0x12, 0xe4, 0x6d, 0x36, 0x85, 0xdd, 0x72, 0xd3, 0x35, 0x2f, 0xad,
  0x3f, 0xdd, 0xd9, 0xe5, 0xf1, 0x3e, 0xdd, 0xf9, 0x64, 0xeb, 0x67, 0x62,
  0x2a, 0x69, 0x04, 0xa9, 0x58, 0x88, 0x75, 0x94, 0x7c, 0xf7, 0x39, 0x8f,
  0x45, 0xc3, 0x4b, 0x04, 0xba, 0xe7, 0x85, 0x5a, 0xe6, 0x15, 0x93, 0x0c,
  0x82, 0xa4, 0xe3, 0x31, 0x67, 0x33, 0x44, 0x3f, 0xe0, 0xba, 0xfa, 0x69,
  0x3d, 0x5a, 0x95, 0xa2, 0x54, 0x39, 0x70, 0x8e, 0x1b, 0x41, 0xe7, 0xeb,
  0xd8, 0xfb, 0x78, 0xbd, 0xa3, 0xc6, 0x11, 0xe7, 0xd2, 0x6c, 0x01, 0xd9,
  0x71, 0xfa, 0x2c, 0xb2, 0xd3, 0x8c, 0x27, 0xb2, 0x34, 0xae, 0xc9, 0xec,
  0x13, 0x0d, 0x2b, 0x13, 0xc7, 0xec, 0xe5, 0xe5, 0x7a, 0x43, 0xcf, 0xfe,
  0xc1, 0x81, 0xf7, 0x2c, 0x55, 0x43, 0x96, 0x9e, 0x20, 0x64, 0xe9, 0x17,
  0x27, 0x97, 0x57, 0xb2, 0x39, 0xcd, 0xc6, 0x59, 0x27, 0x1e, 0xb1, 0x79,
  0x2e, 0x8b, 0xc6, 0x8a, 0xae, 0x4f, 0x1d, 0x68, 0x2e, 0xa7, 0x46, 0xad,
  0xc3, 0x74, 0xba, 0xed, 0x93, 0x8d, 0x58, 0xcc, 0x34, 0xa1, 0x92, 0xa3,
  0x06, 0x24, 0xd8, 0xa7, 0x29, 0xf0, 0x6a, 0x4a, 0xae, 0x04, 0xd6, 0xbb,
  0x70, 0x5a, 0x8d, 0xd3, 0x16, 0x14, 0x29, 0x5a, 0x9c, 0x38, 0x47, 0x08,
  0x16, 0x4c, 0x56, 0x19, 0x27, 0xba, 0xa8, 0xe0, 0xd4, 0x92, 0x60, 0x01,
  0x04, 0x99, 0x10, 0xc9, 0xa3, 0x99, 0xc4, 0x60, 0xc1, 0xc6, 0x81, 0x67,
  0xb4, 0x3d, 0xb1, 0x61, 0x96, 0x4a, 0x6c, 0x62, 0x10, 0xb3, 0xff, 0xb8,
  0x04, 0x24, 0x35, 0x63, 0xaf, 0xd9, 0x16, 0x21, 0xf5, 0x76, 0x4a, 0xf7,
  0x37, 0x2f, 0x8f, 0xa8, 0x6a, 0x32, 0xe2, 0xbd, 0x51, 0xde, 0xf1, 0x83,
  0xfc, 0x6c, 0x27, 0x77, 0xe4, 0x20, 0xe5, 0x99, 0xea, 0x8f, 0xfa, 0x82,
  0xa4, 0xd0, 0x4a, 0x30, 0x9b, 0x87, 0x57, 0x19, 0x5f, 0x9b, 0x11, 0x88,
  0xc3, 0x35, 0xea, 0x86, 0x13, 0x6a, 0x6d, 0x73, 0xb8, 0x65, 0xde, 0x56,
  0x11, 0x2b, 0xb4, 0xbd, 0x38, 0xbf, 0x52, 0xe6, 0xeb, 0x22, 0x2d, 0x1b,
  0x31, 0x69, 0xfd, 0x86, 0xa5, 0xe3, 0x8a, 0x58, 0x30, 0x9d, 0x2f, 0x84,
  0x1b, 0xdc, 0xb6, 0xc4, 0xa9, 0xb1, 0x92, 0x35, 0xbe, 0x9b, 0xb4, 0x87,
  0x6d, 0xf0, 0x14, 0x38, 0x34, 0xdf, 0x65, 0xe0, 0x1d, 0x7c, 0x7b, 0x18,
  0xa4, 0xb8, 0xe1, 0x38, 0xf3, 0x9c, 0xd4, 0x3e, 0xc8, 0x31, 0x26, 0xd1,
  0xba, 0xc8, 0xb2, 0x20, 0x2e, 0x06, 0xe0, 0xde, 0x8c, 0x48, 0x31, 0x49,
  0x92, 0x85, 0x4b, 0x59, 0x61, 0x4c, 0x16, 0xe1, 0xd7, 0x31, 0x71, 0x61,
  0x06, 0x72, 0x9d, 0x35, 0xc5, 0x7d, 0x9f, 0x7a, 0xc9, 0xee, 0x7c, 0x1f,
  0xdf, 0x81, 0xa4, 0xa2, 0xf3, 0xd7, 0x07, 0xbb, 0x9f, 0x3c, 0xf9, 0x94,
  0x94, 0x0f, 0x78, 0x47, 0xe1, 0x34, 0x0f, 0x40, 0x69, 0x34, 0xce, 0x73,
  0x7d, 0x7c, 0x8f, 0xda, 0xa7, 0x4c, 0x78, 0x96, 0x0c, 0x3b, 0xa2, 0x26,
  0x84, 0x1a, 0xb2, 0x3c, 0x27, 0x27, 0xa2, 0x19, 0x3f, 0x94, 0xd1, 0x22,
  0x3a, 0xf8, 0x49, 0x4e, 0x66, 0x40, 0x18, 0x2e, 0x56, 0x4b, 0xe4, 0x85,
  0x41, 0x70, 0x1e, 0x26, 0x19, 0x67, 0x59, 0xf5, 0xa2, 0xf3, 0xa3, 0x8b,
  0xf3, 0x5e, 0x34, 0xbc, 0x38, 0x3d, 0x5f, 0x13, 0x94, 0x45, 0xb2, 0x00,
  0x18, 0x20, 0xd6, 0x0c, 0x64, 0x83, 0xbc, 0x78, 0x53, 0x1b, 0x83, 0xe4,
  0x04, 0xd6, 0xd9, 0x24, 0x28, 0xaf, 0x68, 0x0d, 0x8a, 0x0f, 0x62, 0xe3,
  0x83, 0xd5, 0x62, 0xb2, 0x21, 0x29, 0xe9, 0xc1, 0x89, 0xc9, 0xb6, 0x3f,
  0x82, 0x42, 0x40, 0x8b, 0x98, 0xae, 0x73, 0x45, 0xf1, 0x68, 0x15, 0x63,
  0xd0, 0x9f, 0xb2, 0x35, 0x30, 0x58, 0xce, 0x15, 0xc9, 0x91, 0xf0, 0x0e,
  0x8c, 0x98, 0x0f, 0x4a, 0xc7, 0x9c, 0xde, 0x1d, 0x36, 0x3a, 0xdd, 0x24,
  0x41, 0x94, 0xd3, 0x07, 0xe8, 0x97, 0xc4, 0xa0, 0x2d, 0x97, 0xfc, 0xc4,
  0x68, 0x50, 0xd9, 0x2c, 0xe1, 0x43, 0x2a, 0xf2, 0xab, 0xb1, 0xba, 0xc2,
  0x07, 0xa4, 0xb2, 0x1c, 0xdb, 0xde, 0x5c, 0x97, 0x77, 0xb9, 0xeb, 0x7c,
  0xe7, 0x99, 0x52, 0x87, 0xec, 0x0b, 0xc9, 0x71, 0xd3, 0x92, 0xf3, 0x18,
  0xba, 0x36, 0xaa, 0x6e, 0x9d, 0x97, 0xd0, 0x4d, 0xd6, 0x1e, 0x49, 0x00,
  0x47, 0x0d, 0x1c, 0xf3, 0x22, 0xb3, 0xb9, 0x0c, 0x3f, 0x0e, 0xac, 0xe5,
  0xcf, 0x75, 0xbf, 0x04, 0x0c, 0x1e, 0x46, 0x5e, 0xa3, 0xd1, 0x86, 0x43,
  0x54, 0x36, 0x52, 0x3c, 0xfc, 0xcb, 0x3a, 0x5b, 0xae, 0xf8, 0xc8, 0xaa,
  0x40, 0x21, 0xec, 0x93, 0xab, 0x53, 0x0e, 0xee, 0x2b, 0x1d, 0x3a, 0x12,
  0x57, 0x2d, 0x31, 0xa4, 0x72, 0x71, 0xee, 0xb6, 0x5f, 0x9c, 0xff, 0x3e,
  0x40, 0x0f, 0x96, 0x49, 0x3c, 0x97, 0xeb, 0x97, 0x19, 0x87, 0x50, 0x45,
  0x2f, 0x95, 0x43, 0x7c, 0xd6, 0x1e, 0xbc, 0xc1, 0x99, 0x27, 0x81, 0xfc,
  0x65, 0xb0, 0x88, 0x0c, 0x00, 0x39, 0x54, 0xfb, 0x1d, 0x2d, 0xfe, 0xd0,
  0x71, 0x1a, 0x11, 0x98, 0x7b, 0x8d, 0x1c, 0x27, 0x83, 0x6d, 0xf1, 0x92,
  0x85, 0x39, 0xba, 0x4d, 0x6d, 0x62, 0x69, 0x84, 0x18, 0xc2, 0xc5, 0x72,
  0x46, 0x77, 0xd0, 0x5d, 0x92, 0x4c, 0xba, 0x05, 0xbc, 0x7d, 0xc0, 0x0b,
  0xac, 0x0b, 0xac, 0xd8, 0x7c, 0x5e, 0x6d, 0x97, 0xe1, 0xcf, 0xb1, 0x66,
  0xec, 0x27, 0xb0, 0x54, 0x93, 0xd8, 0x40, 0xe3, 0x02, 0x6d, 0x49, 0xfd,
  0x5b, 0x75, 0x53, 0xfc, 0xf0, 0xf8, 0xe2, 0x28, 0xda, 0x7f, 0x77, 0xf1,
  0x55, 0x27, 0x80, 0x08, 0x0d, 0xb8, 0x07, 0xdf, 0x4b, 0x25, 0xdd, 0xb5,
  0xb7, 0x22, 0xb7, 0xb0, 0x28, 0x26, 0x8e, 0x9e, 0x96, 0x8c, 0xf2, 0x9a,
  0xcd, 0xba, 0x46, 0x0a, 0xcf, 0x06, 0xcf, 0xb6, 0x6a, 0x1b, 0x83, 0x04,
  0x58, 0xa6, 0xfb, 0x7e, 0xba, 0xf8, 0x70, 0x1c, 0x17, 0xc4, 0x73, 0x53,
  0xca, 0x8f, 0xcf, 0xa2, 0x78, 0x32, 0x61, 0xa4, 0xd5, 0x60, 0xb8, 0xc5,
  0xf2, 0x0a, 0x31, 0x7e, 0x2d, 0x78, 0x5c, 0x40, 0x3b, 0x70, 0x32, 0xb3,
  0x06, 0x6f, 0xd3, 0x2a, 0xf3, 0xf1, 0x09, 0x63, 0x6f, 0xa4, 0x33, 0xdd,
  0x99, 0xc2, 0x27, 0x9f, 0xac, 0x75, 0x34, 0xc1, 0x56, 0x6b, 0x78, 0x87,
  0xe3, 0x20, 0x18, 0x47, 0xd1, 0xa7, 0xbd, 0xad, 0x2b, 0x18, 0x71, 0x23,
  0x73, 0xd7, 0xb2, 0x55, 0x58, 0x50, 0x33, 0x3c, 0xf3, 0xb1, 0xca, 0x0d,
  0x61, 0x5f, 0x95, 0x05, 0x7d, 0x3a, 0xd8, 0xdb, 0x6a, 0xd5, 0x68, 0xf4,
  0x60, 0x41, 0x22, 0xa6, 0x73, 0x41, 0x7a, 0x38, 0xdc, 0xc6, 0xa4, 0x6e,
  0x4b, 0x44, 0x19, 0x07, 0x83, 0x51, 0x1f, 0x1c, 0xf7, 0x63, 0x87, 0xcf,
  0xe4, 0xb0, 0x26, 0x2e, 0x0d, 0x96, 0xe8, 0xd7, 0x13, 0xb4, 0x74, 0xff,
  0x5a, 0x33, 0x01, 0xbb, 0x85, 0x6d, 0x20, 0x7c, 0xf4, 0xb2, 0x56, 0xf5,
  0xa3, 0x5c, 0x14, 0xd3, 0x76, 0x42, 0xc9, 0x5d, 0x04, 0xce, 0x70, 0x78,
  0xb2, 0x7d, 0x71, 0x32, 0x74, 0xeb, 0x08, 0x79, 0xb8, 0xb2, 0x5f, 0xe7,
  0x60, 0x34, 0x00, 0x36, 0x62, 0x18, 0xdc, 0xc6, 0x65, 0x3d, 0xef, 0x2b,
  0x54, 0x67, 0x05, 0x66, 0x23, 0xbd, 0x74, 0x9a, 0x52, 0x2e, 0x49, 0x21,
  0x12, 0x2f, 0xaf, 0x9e, 0x60, 0xeb, 0xb5, 0x01, 0xf8, 0xea, 0xa3, 0x2e,
  0x75, 0xf8, 0x7d, 0xdb, 0x57, 0x89, 0xb1, 0xb4, 0x4f, 0xf3, 0xe4, 0x6f,
  0xe2, 0x61, 0x73, 0xd0, 0x38, 0xd1, 0x34, 0xb9, 0xad, 0xb3, 0xdc, 0x64,
  0x5a, 0x88, 0x0b, 0x9b, 0xdd, 0xfe, 0x18, 0x98, 0x02, 0x4b, 0x4e, 0x1e,
  0xc7, 0x77, 0x7f, 0x4d, 0xe9, 0x18, 0x4d, 0xb5, 0x6c, 0x8f, 0xcd, 0xaf,
  0x75, 0x9b, 0xce, 0x15, 0x06, 0xb3, 0xbe, 0x47, 0x88, 0xf0, 0x89, 0xa6,
  0xd9, 0x15, 0x00, 0x29, 0x2d, 0x3c, 0x96, 0x7d, 0xbc, 0x2e, 0xcf, 0xbb,
  0xae, 0xab, 0x4d, 0x25, 0xfc, 0xc3, 0xb6, 0xaa, 0xaa, 0x2b, 0xcb, 0x05,
  0x87, 0xad, 0xd4, 0x95, 0xb2, 0xf4, 0x54, 0x17, 0x39, 0xd7, 0xf4, 0x98,
  0x3a, 0x7b, 0xd5, 0x78, 0x35, 0x10, 0x13, 0x4f, 0x61, 0xb1, 0x88, 0x02,
  0x11, 0x90, 0x5e, 0x56, 0xa0, 0x69, 0x5c, 0xc2, 0x44, 0x2b, 0x88, 0x64,
  0x40, 0x11, 0x51, 0x75, 0x67, 0x3e, 0xfe, 0xcf, 0xed, 0x0c, 0x68, 0xec,
  0x67, 0x6d, 0x0b, 0x8e, 0x4e, 0xf5, 0xec, 0x10, 0x47, 0x66, 0xcf, 0xaf,
  0xe5, 0x84, 0xaf, 0xe5, 0x8b, 0xcd, 0x13, 0xb3, 0xf6, 0xc8, 0x04, 0x0b,
  0x54, 0x6b, 0xae, 0x7e, 0x6b, 0xfc, 0x36, 0x06, 0x8d, 0xb5, 0x84, 0x3c,
  0x1e, 0xb7, 0x0b, 0x07, 0x1c, 0xb1, 0x7d, 0x70, 0x70, 0x40, 0x1f, 0x1c,
  0x08, 0xad, 0x1e, 0xe8, 0x15, 0x72, 0x70, 0x8d, 0x3c, 0xb5, 0xe9, 0x56,
  0x34, 0xbc, 0x5e, 0x22, 0xc5, 0x2a, 0xbb, 0x13, 0x59, 0x55, 0xa7, 0x5a,
  0x8f, 0x60, 0x8a, 0x57, 0xb0, 0x7d, 0x08, 0x76, 0x4c, 0x45, 0xd8, 0x10,
  0xe5, 0x8e, 0x73, 0xe7, 0xcc, 0x17, 0x6c, 0xb7, 0x81, 0xf4, 0xd0, 0x9a,
  0xde, 0xba, 0x9c, 0x3b, 0x20, 0x36, 0x67, 0xd8, 0x9c, 0xbb, 0x13, 0xa0,
  0xc2, 0x7d, 0x2c, 0x27, 0xe7, 0xed, 0xfe, 0x05, 0x10, 0x7d, 0x4b, 0x8d,
  0x7b, 0x6c, 0x8f, 0xaf, 0x72, 0x44, 0xc0, 0x87, 0x20, 0x0e, 0x30, 0xcc,
  0x4c, 0x09, 0x62, 0x60, 0x3e, 0xe4, 0x7d, 0x49, 0x78, 0xea, 0x40, 0xfd,
  0xee, 0x2d, 0xe9, 0xf2, 0xba, 0xa2, 0x7d, 0x7e, 0x83, 0x43, 0x09, 0xd8,
  0x1d, 0x84, 0x3f, 0x8b, 0xe6, 0x19, 0xd9, 0xfd, 0x8f, 0x71, 0x2f, 0x1b,
  0xe2, 0x0f, 0x12, 0xef, 0xbd, 0xad, 0x33, 0xfb, 0x69, 0xad, 0x68, 0x0e,
  0x42, 0x50, 0x3a, 0x68, 0x92, 0x01, 0x03, 0xe8, 0x31, 0x41, 0x32, 0xbd,
  0xa0, 0xe5, 0x56, 0x0f, 0xa5, 0x85, 0xf7, 0x2a, 0xd2, 0xa1, 0x05, 0xf4,
  0x96, 0x1a, 0x7d, 0xa6, 0x11, 0xab, 0x05, 0x51, 0xd5, 0x84, 0x11, 0x79,
  0xc0, 0xdf, 0xcc, 0x74, 0x72, 0x17, 0x37, 0x04, 0x0a, 0x3b, 0xc0, 0x5e,
  0x8c, 0x23, 0xbd, 0x32, 0x55, 0x17, 0x83, 0x03, 0xf0, 0xc8, 0x93, 0xc5,
  0x74, 0xe5, 0xf4, 0x45, 0x6d, 0x7b, 0x9d, 0x60, 0x17, 0x5a, 0x1d, 0x34,
  0x14, 0x5e, 0x36, 0x5f, 0x07, 0x58, 0x54, 0x5b, 0xe1, 0x8e, 0x62, 0x88,
  0x5d, 0x97, 0x0d, 0xf8, 0xd1, 0x58, 0x7b, 0xae, 0xa1, 0xe8, 0x36, 0xa9,
  0x20, 0x90, 0x6f, 0x5c, 0x42, 0xbc, 0x42, 0x01, 0x6b, 0x62, 0xc9, 0x43,
  0x69, 0x8e, 0x53, 0x2c, 0x3e, 0xcb, 0x64, 0x09, 0x29, 0x5d, 0x9c, 0xd6,
  0x60, 0x20, 0x01, 0xe9, 0x5c, 0x72, 0xd2, 0x91, 0x45, 0x28, 0x36, 0x69,
  0x05, 0x16, 0xa8, 0x23, 0xdf, 0x21, 0xdf, 0xd4, 0xc0, 0xcc, 0x94, 0xb1,
  0x08, 0x7c, 0x40, 0x15, 0x3f, 0x40, 0x81, 0x2c, 0x4d, 0x52, 0x65, 0x00,
  0x84, 0x16, 0xb1, 0xd1, 0x3b, 0x69, 0x0e, 0x14, 0x29, 0xe0, 0x02, 0x31,
  0x04, 0xe2, 0xcd, 0x8e, 0xf3, 0x72, 0x9b, 0x31, 0x01, 0xf8, 0xa6, 0x82,
  0x1d, 0x34, 0x9f, 0x28, 0xba, 0x3c, 0xec, 0x16, 0x9f, 0x7e, 0xfc, 0x49,
  0x6b, 0xb8, 0xa7, 0xfa, 0x08, 0x8a, 0x10, 0xdf, 0x19, 0xe0, 0x33, 0x92,
  0x35, 0x2c, 0x9e, 0x37, 0xd4, 0xc5, 0x40, 0x8e, 0x25, 0x43, 0x77, 0x72,
  0xff, 0xdd, 0x71, 0xd3, 0x7c, 0x8d, 0x01, 0x75, 0xc5, 0x4c, 0x23, 0x99,
  0x37, 0x56, 0xa6, 0x41, 0x6a, 0xbb, 0x78, 0xa5, 0x5b, 0x81, 0x79, 0xe0,
  0xac, 0x9e, 0x47, 0x9f, 0x73, 0xa6, 0x10, 0x9a, 0xaf, 0x35, 0xf7, 0x57,
  0x38, 0xab, 0xae, 0x92, 0xb2, 0x99, 0xbc, 0xa6, 0x40, 0x56, 0x1f, 0x68,
  0xbc, 0x85, 0x06, 0x35, 0xf7, 0xee, 0xa5, 0xf2, 0x20, 0xa7, 0xf0, 0x59,
  0x4d, 0x13, 0x1a, 0x0c, 0xc7, 0xfa, 0xbc, 0x74, 0xd8, 0x08, 0x0e, 0xca,
  0xf2, 0xf3, 0x16, 0xad, 0x51, 0xc2, 0x47, 0xc5, 0xe0, 0xc6, 0xa0, 0x47,
  0x65, 0x19, 0x5b, 0xf5, 0x22, 0xb6, 0xd2, 0x22, 0xdf, 0xde, 0xc1, 0x23,
  0xbb, 0x8a, 0x0a, 0x44, 0x31, 0xd3, 0x36, 0xd8, 0x95, 0x97, 0xda, 0x68,
  0x2c, 0x98, 0xa5, 0x82, 0x77, 0x80, 0xf1, 0xb4, 0xad, 0x84, 0xc9, 0xf9,
  0xc8, 0x7d, 0x4a, 0xee, 0x1b, 0xe7, 0x97, 0xdf, 0x0d, 0xd6, 0xa9, 0x21,
  0x81, 0x1f, 0xdd, 0xc7, 0x33, 0x2e, 0xac, 0xe3, 0xaa, 0x0f, 0xb0, 0x6f,
  0xdb, 0xa7, 0x24, 0x69, 0x78, 0x45, 0x68, 0xc0, 0x15, 0xcf, 0x45, 0x17,
  0xcf, 0xd4, 0xf7, 0x1e, 0xef, 0x74, 0xcd, 0x90, 0x10, 0x3a, 0xaa, 0x99,
  0x22, 0x65, 0x38, 0x0e, 0x15, 0x4d, 0xbc, 0xc6, 0xe8, 0x69, 0xb2, 0x26,
  0x64, 0x0c, 0x6f, 0x32, 0xf4, 0xce, 0x8b, 0xd6, 0xa8, 0x8a, 0xfe, 0x6b,
  0x37, 0xd0, 0x57, 0x9f, 0x57, 0x5a, 0xbb, 0xbb, 0x1b, 0xcc, 0x56, 0xf6,
  0x5d, 0x51, 0x29, 0x2d, 0x16, 0xa4, 0x0a, 0x4b, 0x68, 0xbb, 0x91, 0x4c,
  0xb7, 0x70, 0xe4, 0xe5, 0x11, 0x02, 0xc2, 0xd2, 0x1b, 0xbe, 0xdc, 0x08,
  0xdd, 0x4d, 0xcd, 0x04, 0x1f, 0x0d, 0xcf, 0xf7, 0xd4, 0x27, 0x46, 0xc1,
  0xee, 0x6d, 0xc2, 0x0e, 0x05, 0x3d, 0xe2, 0x57, 0x99, 0xea, 0x66, 0x23,
  0xba, 0xb8, 0x90, 0xfc, 0x2a, 0x94, 0xd6, 0x14, 0x80, 0x8a, 0x32, 0x5f,
  0x8e, 0xcb, 0xa6, 0x71, 0xda, 0x57, 0xda, 0x52, 0x58, 0xbc, 0x20, 0x3f,
  0x44, 0xcc, 0x4e, 0x15, 0xa6, 0xe0, 0xf2, 0x33, 0x2c, 0x52, 0xbf, 0x8e,
  0xef, 0xc0, 0xf8, 0xba, 0xdd, 0x9e, 0x44, 0xf8, 0x6b, 0x7e, 0xbc, 0xcf,
  0xe6, 0x5e, 0xbb, 0xf0, 0x9d, 0xbb, 0x64, 0xf4, 0xea, 0x73, 0x84, 0xb9,
  0xdd, 0x33, 0x90, 0xa5, 0xe0, 0xf4, 0x82, 0x06, 0xb7, 0xf1, 0x67, 0x07,
  0x08, 0x09, 0x6d, 0xeb, 0x4e, 0x5c, 0x7c, 0x5d, 0x8b, 0x01, 0xd2, 0x44,
  0xd0, 0xda, 0x65, 0x96, 0xad, 0x6d, 0xec, 0xfb, 0xb0, 0xaa, 0x57, 0x72,
  0x0f, 0x68, 0x94, 0x14, 0x8e, 0x07, 0x48, 0x37, 0x57, 0x89, 0x27, 0x42,
  0x21, 0x3c, 0x6c, 0xe1, 0x5c, 0xcf, 0xa9, 0x1c, 0xc2, 0xb6, 0x04, 0xed,
  0xd1, 0xca, 0x15, 0x1b, 0xb0, 0x64, 0xcd, 0x57, 0x3d, 0xef, 0x55, 0x5d,
  0xbf, 0x20, 0x78, 0xfa, 0xd5, 0xe7, 0x0c, 0x95, 0x84, 0x5f, 0xff, 0xec,
  0xde, 0xc6, 0x3f, 0x44, 0xc5, 0xc4, 0x05, 0xd6, 0x4e, 0x04, 0xe2, 0xce,
  0xe5, 0x32, 0x67, 0x51, 0x26, 0x91, 0x23, 0x59, 0x30, 0x65, 0x18, 0xe6,
  0xaa, 0xb2, 0x92, 0x37, 0xfb, 0x6f, 0xdf, 0xed, 0x9f, 0x0c, 0x1e, 0x52,
  0xd7, 0x43, 0xeb, 0x9b, 0x8b, 0x6f, 0x62, 0x63, 0x58, 0x45, 0x4e, 0xc1,
  0x79, 0xd4, 0x98, 0x76, 0xb9, 0x09, 0x1f, 0x2c, 0x5c, 0x12, 0x0d, 0x0d,
  0x41, 0x01, 0xe4, 0xa4, 0x37, 0xa8, 0xc2, 0x23, 0xb8, 0xc4, 0x4b, 0x41,
  0x6a, 0xd1, 0x46, 0x55, 0x74, 0x68, 0x09, 0x82, 0x86, 0xb3, 0x2d, 0x8f,
  0xa5, 0x2c, 0x90, 0xc9, 0xdc, 0xd3, 0x14, 0xf5, 0x27, 0xa7, 0x80, 0xa9,
  0x3b, 0xd1, 0x4a, 0x7a, 0xdd, 0xcf, 0xbb, 0x72, 0x36, 0xba, 0x2f, 0xbb,
  0x40, 0x2b, 0xa1, 0x77, 0x9a, 0x31, 0x3e, 0x92, 0x35, 0xae, 0xd1, 0x9d,
  0x5d, 0xa1, 0x9a, 0xae, 0x0d, 0x41, 0xd7, 0x4c, 0x86, 0xc5, 0xd1, 0x0e,
  0x73, 0xad, 0xfd, 0x86, 0x4a, 0x72, 0x49, 0x3c, 0x6f, 0x71, 0x65, 0x30,
  0x9e, 0x92, 0x4b, 0xa3, 0x94, 0x7a, 0x3c, 0x7c, 0x35, 0x94, 0x99, 0x4d,
  0x5b, 0x14, 0xb8, 0x1c, 0xfc, 0x02, 0xe1, 0x04, 0x82, 0x6b, 0xd7, 0x16,
  0x22, 0x61, 0xe1, 0xac, 0x89, 0x2b, 0x89, 0xa2, 0x63, 0x41, 0x04, 0x0b,
  0x5d, 0xcc, 0x29, 0xa2, 0x43, 0xd9, 0x6b, 0x4b, 0xdf, 0x5e, 0x5d, 0x69,
  0xae, 0x27, 0xe6, 0x4d, 0x6b, 0x47, 0xb3, 0x6e, 0x80, 0xeb, 0x69, 0xd9,
  0x4a, 0xa2, 0xe3, 0x3a, 0xa8, 0x4f, 0xff, 0x8a, 0xc4, 0x9a, 0xab, 0x69,
  0x36, 0xca, 0x2e, 0x2f, 0x1f, 0xa0, 0x8d, 0x82, 0x2e, 0x44, 0xba, 0x99,
  0x0a, 0x76, 0x60, 0x72, 0x9a, 0x08, 0x92, 0x23, 0xf0, 0xde, 0x48, 0x8b,
  0x39, 0x02, 0xf0, 0x7e, 0x20, 0x86, 0x45, 0x86, 0xf2, 0x49, 0xca, 0x16,
  0x81, 0xd7, 0x67, 0x0c, 0x5a, 0x06, 0x87, 0x85, 0xc2, 0x72, 0x95, 0x3f,
  0x9e, 0xb7, 0xc5, 0xd8, 0xf9, 0xfb, 0xb6, 0x88, 0xfe, 0xf1, 0xcf, 0x1f,
  0x7e, 0x6a, 0x01, 0xbf, 0x81, 0x8d, 0x5b, 0x03, 0xd7, 0x11, 0x49, 0xab,
  0x09, 0x37, 0x6c, 0x85, 0xa6, 0x0d, 0x28, 0x3d, 0x34, 0x9c, 0x16, 0x49,
  0x19, 0x04, 0xa9, 0x01, 0xcd, 0x0b, 0xa3, 0x48, 0x1c, 0xa0, 0x00, 0x7b,
  0xdc, 0x21, 0xa1, 0x6a, 0xc8, 0xc2, 0x34, 0xb9, 0x8a, 0x25, 0x1f, 0xde,
  0xdd, 0x9e, 0xea, 0x7d, 0x59, 0x29, 0xb3, 0x6e, 0x58, 0xba, 0x7d, 0xca,
  0x70, 0x28, 0x48, 0xb1, 0xf9, 0xf6, 0xfc, 0xd8, 0xd9, 0xf6, 0x83, 0x8d,
  0xf8, 0x12, 0x1b, 0xd1, 0x58, 0x35, 0x57, 0x59, 0xa9, 0x57, 0xd7, 0x3e,
  0xc2, 0x64, 0x6f, 0x4e, 0x70, 0x90, 0x54, 0xec, 0x0a, 0x90, 0x50, 0x43,
  0x88, 0x09, 0xc0, 0x9b, 0x60, 0xdd, 0xa8, 0x22, 0xbc, 0xb8, 0x44, 0x7c,
  0x57, 0xc9, 0x49, 0xc2, 0x33, 0xbe, 0x3c, 0x72, 0x68, 0x5a, 0x0d, 0xba,
  0xaf, 0x94, 0x97, 0xaa, 0xe2, 0x6e, 0x31, 0x06, 0x80, 0x2b, 0x1c, 0x76,
  0xe7, 0xfd, 0x5c, 0x1c, 0xec, 0xd2, 0xa6, 0x84, 0x28, 0x8e, 0x8b, 0x68,
  0x8e, 0x96, 0xe5, 0xed, 0x97, 0xed, 0xc4, 0x10, 0x37, 0xba, 0x7f, 0xe9,
  0x46, 0x1e, 0x55, 0xa3, 0xd5, 0x38, 0x18, 0xe2, 0xd9, 0xd5, 0x32, 0x9a,
  0xfb, 0xc7, 0x3d, 0x3f, 0x5a, 0xdf, 0xa5, 0xcd, 0x65, 0xd4, 0x82, 0x9c,
  0xb5, 0x6e, 0x20, 0x5f, 0x1d, 0xed, 0x1f, 0xda, 0x84, 0xff, 0xa3, 0xb8,
  0x69, 0xd7, 0x9c, 0x59, 0x35, 0x5d, 0x34, 0x52, 0x6c, 0xe2, 0x2b, 0xe4,
  0xfd, 0x4d, 0x17, 0xc1, 0xb3, 0x41, 0x16, 0xd6, 0x4b, 0xf9, 0xb9, 0x8e,
  0x77, 0x1f, 0x09, 0x50, 0x8f, 0x3e, 0xec, 0x04, 0x02, 0x97, 0x46, 0xa0,
  0x69, 0x03, 0x74, 0xa1, 0x13, 0x07, 0xb8, 0x4a, 0xb8, 0xaa, 0x2c, 0x78,
  0x54, 0x5d, 0xf3, 0xd6, 0x33, 0xce, 0x50, 0x02, 0x0e, 0x9d, 0x52, 0x50,
  0x80, 0x34, 0x39, 0x2e, 0x8c, 0xe3, 0xd7, 0x1c, 0x28, 0xab, 0x26, 0x33,
  0x69, 0x14, 0xde, 0xc0, 0xd5, 0x59, 0x94, 0x48, 0xc7, 0x70, 0x23, 0xc3,
  0x7b, 0xd7, 0x71, 0xe1, 0xad, 0xdd, 0x92, 0x80, 0x5e, 0x84, 0x5e, 0x68,
  0xf3, 0x4e, 0x35, 0xcb, 0x1b, 0x58, 0x80, 0xb5, 0xb9, 0xc3, 0x7b, 0x22,
  0xcb, 0x22, 0x47, 0x19, 0x2f, 0x68, 0x6e, 0x98, 0xeb, 0xcd, 0x03, 0x74,
  0x2d, 0x9b, 0x70, 0xd7, 0xb5, 0x23, 0xe1, 0x5c, 0x62, 0xd9, 0x3c, 0xa9,
  0x1a, 0x40, 0x30, 0x47, 0xcb, 0x46, 0xe3, 0xdc, 0x2f, 0xae, 0x8a, 0xdc,
  0xb8, 0x59, 0x20, 0x54, 0x95, 0x4b, 0xe6, 0xba, 0xf1, 0x3c, 0x1c, 0xa7,
  0xcb, 0xb6, 0x9d, 0x64, 0xb2, 0xf0, 0xce, 0x97, 0xcc, 0x39, 0x4f, 0xd0,
  0x70, 0xe3, 0x06, 0x8e, 0xb2, 0x0d, 0xc7, 0xe1, 0xed, 0xbb, 0x5c, 0x4e,
  0xe3, 0xa7, 0x0c, 0xb9, 0xcb, 0xa4, 0x08, 0x28, 0x9d, 0x84, 0x61, 0x9c,
  0x04, 0xdf, 0xf7, 0xae, 0xc9, 0x35, 0xb5, 0x10, 0x09, 0x67, 0x08, 0x03,
  0x1c, 0x7e, 0x96, 0xc1, 0x17, 0x3c, 0xf7, 0xb3, 0xd6, 0x25, 0x23, 0x36,
  0x7c, 0x95, 0xde, 0x0a, 0xb5, 0xd8, 0xc8, 0x5a, 0x12, 0xa7, 0xdc, 0x18,
  0x1c, 0x2a, 0x4c, 0x66, 0xbe, 0x54, 0xc9, 0x26, 0x8f, 0x90, 0x68, 0x29,
  0x81, 0xc2, 0xa2, 0xca, 0x4c, 0x71, 0x97, 0x48, 0xdd, 0x5e, 0x22, 0xec,
  0xba, 0x77, 0xe9, 0x2b, 0x92, 0x9c, 0x5e, 0x74, 0xda, 0x03, 0xab, 0x3d,
  0xd6, 0x49, 0xe1, 0x30, 0x38, 0x39, 0x5a, 0x40, 0x87, 0xcc, 0x18, 0x53,
  0x44, 0x7c, 0xdb, 0x3a, 0x5c, 0xd1, 0xd0, 0x38, 0x8a, 0xa7, 0x0d, 0x86,
  0x4d, 0xc3, 0xf0, 0x17, 0x1c, 0x33, 0xc7, 0xbb, 0xcf, 0x25, 0x30, 0x51,
  0xb8, 0x0c, 0x9a, 0x4f, 0x40, 0xd0, 0x9c, 0x01, 0x8a, 0x2d, 0xa2, 0xc6,
  0xdb, 0x6e, 0x22, 0x8d, 0xbf, 0xce, 0x9d, 0xe5, 0x4d, 0x07, 0xa4, 0x6b,
  0xf2, 0x02, 0x96, 0x14, 0x7b, 0xdd, 0x21, 0x4b, 0x21, 0xdf, 0x2e, 0xce,
  0xf3, 0x94, 0x4e, 0x61, 0x03, 0xb5, 0x54, 0xc2, 0xe4, 0x4a, 0x57, 0x2c,
  0x97, 0x71, 0x78, 0x67, 0xe2, 0xb9, 0xa2, 0x2d, 0x41, 0x15, 0x47, 0x16,
  0xba, 0x90, 0xee, 0xbb, 0xb1, 0xce, 0x7d, 0xc0, 0x39, 0x4c, 0xb5, 0xc2,
  0x75, 0xec, 0x40, 0x08, 0x33, 0x4c, 0xd7, 0x61, 0x33, 0x54, 0x33, 0x96,
  0x59, 0x05, 0x71, 0xd7, 0x4c, 0x55, 0xd2, 0xe4, 0x98, 0x73, 0xbf, 0xe8,
  0xdb, 0x39, 0x93, 0x54, 0x5b, 0x5c, 0x08, 0x5e, 0x31, 0xe6, 0x11, 0x88,
  0xa7, 0x28, 0xf1, 0xba, 0x58, 0x8e, 0x66, 0x93, 0x67, 0xf5, 0x84, 0x05,
  0x40, 0xed, 0xc4, 0x4e, 0x9e, 0x52, 0x29, 0x83, 0x7f, 0x7f, 0xb2, 0x87,
  0x73, 0x70, 0x4f, 0x6d, 0x8d, 0xd3, 0x19, 0x7b, 0xaf, 0xd3, 0xab, 0xb4,
  0x2c, 0x0c, 0xa0, 0x44, 0x5e, 0x59, 0x5f, 0x4c, 0x88, 0xd7, 0x66, 0x77,
  0xef, 0xd3, 0x68, 0x94, 0x96, 0xd1, 0x9b, 0xc3, 0x67, 0x52, 0x02, 0xad,
  0x58, 0xce, 0x7c, 0xd5, 0x45, 0x06, 0xfb, 0xc4, 0xd0, 0x48, 0xf4, 0xa3,
  0xd1, 0x4d, 0x1b, 0x45, 0x3b, 0x6e, 0x92, 0x55, 0x18, 0x94, 0x04, 0x9c,
  0xa4, 0x22, 0xa9, 0xc3, 0xa3, 0x3b, 0x42, 0x93, 0x42, 0xb6, 0x56, 0x6b,
  0xa3, 0x45, 0x5a, 0xa6, 0xe9, 0x53, 0xff, 0x45, 0x64, 0xb5, 0x8c, 0x2a,
  0xb2, 0x9c, 0x95, 0x75, 0xc5, 0x9e, 0x0f, 0x0f, 0xce, 0x78, 0x1b, 0x87,
  0xd5, 0xb4, 0xfe, 0xfa, 0x7d, 0x10, 0x5a, 0xc5, 0x3e, 0x09, 0x6d, 0xa3,
  0xfd, 0x7e, 0x7a, 0x45, 0x8c, 0xc8, 0xe1, 0xac, 0xf4, 0x49, 0x73, 0xb9,
  0x5a, 0x57, 0xdb, 0xee, 0x98, 0x1f, 0xad, 0x98, 0x9f, 0x4e, 0xf8, 0x71,
  0x97, 0x37, 0x1b, 0x04, 0x43, 0xe0, 0x04, 0xa4, 0x63, 0x54, 0xab, 0x6c,
  0x40, 0x46, 0x6a, 0x15, 0x79, 0x9e, 0x80, 0x22, 0x3f, 0x20, 0x71, 0x91,
  0x37, 0x73, 0x7f, 0x01, 0x0b, 0x4a, 0xb4, 0x3b, 0xb8, 0xef, 0x85, 0xe5,
  0x97, 0x14, 0xdb, 0x1a, 0x45, 0x96, 0x1a, 0x09, 0x5c, 0x5c, 0xf4, 0xb3,
  0x36, 0x20, 0x34, 0x2d, 0xa6, 0xab, 0x29, 0x82, 0x44, 0x72, 0xe1, 0xbe,
  0x7b, 0xc4, 0xc5, 0xae, 0x62, 0x86, 0x55, 0x0e, 0x68, 0x2e, 0xa5, 0x13,
  0xa0, 0x30, 0x4c, 0x6b, 0xe6, 0x2d, 0x5f, 0xba, 0xe4, 0x69, 0xbb, 0x7d,
  0x55, 0xc8, 0xd5, 0xc8, 0x51, 0x23, 0xb7, 0xe0, 0x89, 0x66, 0x89, 0x28,
  0xb4, 0xc3, 0x3b, 0xce, 0x07, 0x57, 0x94, 0x4b, 0x5d, 0x83, 0x3e, 0xae,
  0xbc, 0x1e, 0x04, 0x1a, 0x77, 0xe3, 0xf9, 0x78, 0x59, 0x6e, 0xb4, 0x19,
  0x26, 0x5e, 0x58, 0xe5, 0x58, 0x04, 0x9c, 0x0c, 0x06, 0xbf, 0x75, 0xe4,
  0xa6, 0x9b, 0x37, 0xcf, 0x23, 0x3c, 0xb6, 0x7c, 0x61, 0x5c, 0x82, 0xcd,
  0xb6, 0x66, 0x1e, 0x9f, 0x09, 0xaa, 0x5b, 0x54, 0x2d, 0x79, 0x6b, 0xd1,
  0x06, 0x5e, 0xe4, 0x75, 0xcd, 0x0c, 0x9c, 0x86, 0x9f, 0xcc, 0xcb, 0x96,
  0x85, 0xb4, 0xde, 0x64, 0xcd, 0x02, 0xd7, 0x78, 0x58, 0x25, 0x7a, 0x10,
  0xed, 0xcf, 0x4d, 0xa9, 0x56, 0xb0, 0x03, 0x01, 0xbc, 0x6c, 0x94, 0xa4,
  0xb8, 0x49, 0x1a, 0xda, 0xbd, 0xaa, 0xf7, 0xc1, 0xcc, 0x92, 0xf2, 0x7a,
  0xe7, 0xc5, 0x6e, 0xa5, 0xbc, 0xb7, 0x02, 0xd1, 0x73, 0x85, 0x8f, 0xdf,
  0x2e, 0x9a, 0xfc, 0x58, 0x05, 0xbe, 0x36, 0xea, 0xdc, 0x7e, 0x8d, 0xff,
  0x8e, 0x4f, 0x8e, 0xb6, 0xa2, 0xd7, 0x28, 0x9d, 0xde, 0x20, 0x52, 0xb0,
  0x8a, 0xdf, 0xc9, 0x27, 0x76, 0xd6, 0x54, 0x9f, 0x6c, 0xc3, 0xc9, 0xb4,
  0x50, 0x06, 0x91, 0x8c, 0xe5, 0x00, 0xf2, 0x2c, 0x24, 0xd3, 0x28, 0xe3,
  0x4b, 0xd4, 0x30, 0x9a, 0x2d, 0x80, 0xad, 0x95, 0xd8, 0xd9, 0x6c, 0xe6,
  0xcb, 0x77, 0xf8, 0x0a, 0xb3, 0x5c, 0x6e, 0x5a, 0x63, 0x4d, 0x31, 0xf0,
  0x48, 0x8d, 0x6b, 0xb5, 0xf2, 0xca, 0x2d, 0xa3, 0x93, 0x7a, 0x61, 0xe9,
  0xdf, 0x25, 0xb4, 0x9a, 0x57, 0x6d, 0x96, 0x4d, 0x1c, 0x02, 0x9f, 0x94,
  0xbe, 0xc0, 0x7c, 0x7f, 0xeb, 0xb8, 0xce, 0x60, 0x69, 0x83, 0x6d, 0xfa,
  0x2b, 0x6d, 0xd3, 0x5f, 0x97, 0xf3, 0x9b, 0xbe, 0x16, 0xa4, 0x53, 0xa8,
  0x8b, 0xa2, 0x9d, 0xa9, 0x7c, 0xeb, 0x82, 0x45, 0x38, 0x60, 0x5f, 0xcc,
  0xa3, 0xcd, 0xba, 0x6c, 0x71, 0x80, 0xf5, 0xd5, 0x7b, 0xa0, 0x00, 0x4a,
  0x45, 0x9d, 0x84, 0x7b, 0x81, 0x46, 0x3e, 0x46, 0x9c, 0x2d, 0x54, 0xcb,
  0x8e, 0x95, 0xc8, 0xd3, 0xa6, 0x3b, 0xeb, 0x51, 0x8b, 0xb9, 0x22, 0x15,
  0xcb, 0x97, 0x6c, 0x37, 0x71, 0xf2, 0xb8, 0x06, 0x81, 0x40, 0x54, 0xc3,
  0xc6, 0x92, 0xe0, 0xe2, 0xea, 0xee, 0x49, 0xec, 0x1b, 0xd0, 0x3c, 0x41,
  0xb5, 0x35, 0xc9, 0x61, 0xb5, 0x40, 0x73, 0x91, 0x81, 0x31, 0x17, 0x1e,
  0x5b, 0xc6, 0x06, 0x18, 0xd5, 0x06, 0xa7, 0x51, 0x6a, 0x24, 0xee, 0x74,
  0x1b, 0x34, 0x3a, 0x9e, 0x66, 0x52, 0x15, 0xe6, 0x6e, 0xfe, 0x9f, 0xcb,
  0x70, 0xbf, 0xe1, 0xfb, 0xa2, 0x68, 0x0b, 0xaf, 0xb2, 0x44, 0xa0, 0x90,
  0xd4, 0x02, 0xeb, 0xa4, 0x6a, 0x0e, 0x0e, 0x13, 0x5a, 0xb9, 0x62, 0xc7,
  0x5a, 0xeb, 0x34, 0x73, 0x63, 0x2a, 0xe5, 0xe7, 0xd9, 0xde, 0xe5, 0xb1,
  0x7b, 0xf6, 0x69, 0xe8, 0x8d, 0x47, 0x90, 0x6e, 0x20, 0xa1, 0xd0, 0x49,
  0x5b, 0x71, 0x66, 0x86, 0x25, 0x26, 0xea, 0xb5, 0xc0, 0x87, 0x0a, 0x8c,
  0x4b, 0x2d, 0xdf, 0x49, 0xb2, 0xef, 0x58, 0x23, 0x8a, 0xe1, 0xf5, 0xaa,
  0x93, 0x8a, 0x2b, 0x75, 0xae, 0xe4, 0xa4, 0xde, 0x8b, 0xe9, 0xb4, 0x32,
  0x22, 0x0f, 0xaf, 0x12, 0x4c, 0xb4, 0x05, 0xda, 0x85, 0x6b, 0x59, 0xa8,
  0x48, 0x54, 0x59, 0x63, 0xdb, 0xca, 0x56, 0xe1, 0xd6, 0x5b, 0xa6, 0xb8,
  0x40, 0x05, 0x27, 0xf7, 0x73, 0xf2, 0x84, 0x14, 0x3c, 0x50, 0x57, 0x26,
  0xc3, 0x26, 0x88, 0x91, 0x35, 0x72, 0xe5, 0xac, 0xd6, 0x54, 0xa9, 0xe2,
  0xb4, 0xc1, 0xeb, 0xf8, 0xfe, 0x7e, 0x50, 0x24, 0x52, 0xb6, 0xa9, 0x28,
  0xa6, 0x9c, 0xa2, 0xd8, 0x5a, 0x9e, 0xea, 0xd1, 0x05, 0xa7, 0x99, 0x3b,
  0x7d, 0x90, 0xb5, 0xa4, 0x65, 0x78, 0xad, 0xde, 0x24, 0xc9, 0x22, 0x9e,
  0x72, 0xd8, 0x21, 0xde, 0x5e, 0x57, 0xfb, 0xa7, 0x2a, 0x9f, 0x17, 0xde,
  0x67, 0x2c, 0x88, 0x1b, 0x71, 0x28, 0x84, 0x02, 0xb4, 0xbf, 0x10, 0x5e,
  0x33, 0xc3, 0x30, 0xd2, 0x49, 0x63, 0x0c, 0x8a, 0xe5, 0x04, 0xa7, 0x10,
  0x28, 0xc3, 0x0d, 0x02, 0x0a, 0xd2, 0x48, 0xcd, 0xd3, 0x1c, 0xd9, 0x82,
  0xd6, 0xcd, 0x73, 0x86, 0xc4, 0x77, 0x52, 0x11, 0x27, 0xcb, 0x86, 0x82,
  0x5e, 0x7f, 0xdf, 0xaa, 0xa7, 0xfa, 0x74, 0x01, 0x61, 0x2e, 0x78, 0x22,
  0x73, 0xf2, 0x01, 0x03, 0xa0, 0x72, 0x55, 0xbe, 0xc6, 0xc5, 0x72, 0x29,
  0x80, 0x10, 0x32, 0xc5, 0x8b, 0x83, 0xb3, 0xf7, 0x5f, 0x1f, 0x1d, 0x9d,
  0x1d, 0x1f, 0xe2, 0x2a, 0xe1, 0xbb, 0xcb, 0x7d, 0xf4, 0xf6, 0xe2, 0x9b,
  0x13, 0xc3, 0x88, 0xb0, 0xf5, 0x69, 0xb0, 0x63, 0xd8, 0x83, 0xb9, 0xb9,
  0x93, 0x74, 0xbe, 0xbc, 0xef, 0x71, 0xcd, 0x1b, 0x52, 0x8e, 0xf6, 0x8f,
  0xbf, 0x23, 0xb1, 0xeb, 0xac, 0xff, 0xee, 0xbb, 0x46, 0x4e, 0x51, 0x25,
  0x3c, 0xae, 0x1e, 0x60, 0xe5, 0x82, 0xe5, 0xfa, 0xfd, 0x79, 0xe6, 0x37,
  0xd0, 0x11, 0x71, 0x0b, 0x94, 0xed, 0xe3, 0x28, 0xaa, 0xaa, 0x68, 0x85,
  0x92, 0x83, 0xe7, 0x66, 0xbc, 0xf7, 0x2d, 0x37, 0x67, 0x3c, 0x43, 0x4e,
  0xcc, 0x20, 0x24, 0xac, 0x55, 0xf4, 0x92, 0xfe, 0x69, 0xcb, 0x64, 0xdc,
  0x1e, 0x0e, 0xbf, 0xda, 0x8a, 0xce, 0x02, 0x14, 0x05, 0xe7, 0xd9, 0x1a,
  0x58, 0xdc, 0x94, 0x1a, 0x3f, 0x34, 0x55, 0x46, 0x5d, 0x87, 0x79, 0x23,
  0xc2, 0xd7, 0xb5, 0xe0, 0x6b, 0xb5, 0xb2, 0xd1, 0x2f, 0x69, 0xf7, 0x49,
  0xfe, 0x8a, 0x29, 0x9c, 0xd4, 0xe9, 0x07, 0x73, 0xf3, 0x9b, 0x73, 0xc4,
  0xb3, 0x03, 0x07, 0x4e, 0xa2, 0xe2, 0x0f, 0x5a, 0xe1, 0x09, 0xca, 0xb2,
  0xb5, 0xc0, 0x5e, 0x4b, 0xf2, 0x7e, 0x88, 0x3b, 0x91, 0x12, 0x95, 0x1f,
  0x1e, 0x9d, 0xf7, 0x38, 0x3d, 0xd3, 0x52, 0xf5, 0x99, 0x39, 0x7b, 0xfc,
  0x9b, 0x81, 0x15, 0xdc, 0x2d, 0x5b, 0xed, 0x6d, 0x8c, 0xa9, 0xf1, 0xef,
  0x4b, 0xd3, 0xbf, 0xc9, 0x47, 0xd1, 0xcb, 0x29, 0xbd, 0x38, 0x6d, 0x8f,
  0x68, 0xd6, 0x7a, 0xa0, 0x5f, 0x27, 0xf9, 0x28, 0xc9, 0xb3, 0xa2, 0x9e,
  0x5c, 0xa6, 0xd9, 0xe8, 0x5a, 0xa0, 0x10, 0xcd, 0x68, 0xb2, 0x69, 0xc3,
  0x1c, 0xcb, 0x02, 0x3d, 0xe7, 0x16, 0xce, 0x27, 0xcd, 0x74, 0x93, 0x2e,
  0x07, 0xef, 0x75, 0x7b, 0x51, 0x17, 0x39, 0x74, 0xf8, 0x49, 0xbc, 0xeb,
  0x92, 0x1d, 0x26, 0x69, 0x3c, 0xed, 0x36, 0x4b, 0xd1, 0x76, 0x75, 0xd9,
  0xbb, 0xb4, 0x6f, 0xd2, 0x98, 0xd5, 0xae, 0x8c, 0x75, 0x1c, 0xe2, 0x8d,
  0x49, 0x0b, 0x35, 0xac, 0xa1, 0x23, 0xb3, 0x40, 0x15, 0x0d, 0x14, 0x27,
  0xd7, 0x5c, 0xdd, 0xa8, 0xdc, 0x7e, 0x05, 0x55, 0x39, 0xaf, 0xc6, 0x52,
  0x16, 0xde, 0x33, 0x66, 0x09, 0xdf, 0x77, 0xb1, 0xa5, 0x85, 0xb3, 0x11,
  0xe0, 0x46, 0x57, 0xf1, 0x69, 0xc3, 0x47, 0x1a, 0x7d, 0x39, 0x1c, 0xee,
  0x9f, 0x1d, 0x47, 0x9b, 0xf4, 0xb3, 0xff, 0xd6, 0xea, 0x8e, 0x6f, 0x19,
  0xd5, 0xf8, 0x04, 0x0b, 0xcc, 0x85, 0x73, 0x58, 0x20, 0xb2, 0x73, 0x68,
  0xdd, 0xbb, 0xa2, 0x91, 0x0c, 0xfb, 0x0d, 0x5d, 0xa3, 0xa6, 0x26, 0x0a,
  0x1e, 0x8e, 0x5a, 0x67, 0xf3, 0xa8, 0x52, 0x84, 0xaf, 0x72, 0xed, 0xfc,
  0xea, 0xb4, 0xf5, 0xb5, 0xd4, 0x5a, 0xba, 0x4c, 0xaf, 0x10, 0x35, 0xcf,
  0x3f, 0xdb, 0xa0, 0x81, 0xaa, 0xc7, 0x2e, 0x78, 0xd0, 0x4b, 0xc6, 0x0c,
  0xfa, 0xa5, 0xa9, 0x4a, 0x22, 0x20, 0x2b, 0xec, 0x76, 0x4b, 0x34, 0x0a,
  0xde, 0x56, 0x9f, 0x6f, 0x1a, 0xc4, 0x54, 0xb0, 0x40, 0xe3, 0xfa, 0x98,
  0xb9, 0x92, 0x0e, 0x41, 0xbb, 0xe2, 0x48, 0xad, 0x5b, 0x09, 0xb5, 0x46,
  0x97, 0xe9, 0x44, 0xc9, 0xbc, 0x32, 0x5d, 0x95, 0x8c, 0xc5, 0x4a, 0x87,
  0x88, 0x00, 0x7b, 0xde, 0x4c, 0xa0, 0x75, 0x2b, 0xe1, 0xb8, 0x04, 0x48,
  0x6e, 0x38, 0x82, 0x41, 0x74, 0xba, 0x08, 0xe4, 0xbc, 0xeb, 0x24, 0xcd,
  0xbd, 0xc3, 0xd4, 0xe7, 0x7c, 0x33, 0x77, 0x68, 0x4e, 0x56, 0x34, 0xab,
  0xa0, 0x7a, 0x85, 0x5f, 0x3e, 0xa9, 0x58, 0xe1, 0x78, 0xaf, 0xa2, 0xba,
  0xd0, 0x44, 0x4a, 0xae, 0xbf, 0x42, 0xba, 0x6d, 0xaf, 0x11, 0x85, 0xc0,
  0x86, 0x59, 0x81, 0x07, 0x00, 0x9a, 0x6f, 0xc1, 0x41, 0x3a, 0x11, 0x43,
  0xa0, 0xaf, 0x2a, 0x2e, 0x19, 0xf6, 0x88, 0xd2, 0x71, 0xda, 0x54, 0x0c,
  0xbf, 0xb6, 0x4a, 0x50, 0xe2, 0x4d, 0xcd, 0x99, 0x7a, 0x0c, 0x4a, 0x5d,
  0x43, 0x45, 0x82, 0xd6, 0x3d, 0x30, 0x4c, 0xc5, 0x4d, 0xdc, 0x94, 0x14,
  0x1d, 0x8a, 0x47, 0x38, 0x05, 0x07, 0x96, 0xef, 0x5f, 0x76, 0x4b, 0x46,
  0x77, 0xa3, 0x28, 0x0e, 0x82, 0x8f, 0xd0, 0x80, 0x27, 0xca, 0x18, 0xf7,
  0xe3, 0x5b, 0x01, 0x4f, 0x98, 0x64, 0x4b, 0x30, 0x3a, 0xf9, 0xb4, 0xee,
  0xdf, 0x49, 0xa4, 0xf0, 0x5c, 0x01, 0x97, 0x11, 0x7c, 0x3c, 0x2d, 0x98,
  0xff, 0x0e, 0xbe, 0xe0, 0x45, 0x14, 0xfd, 0xf8, 0x23, 0x8d, 0xea, 0xc7,
  0x4e, 0x2f, 0xfa, 0xb1, 0xa4, 0xff, 0x68, 0x45, 0x7f, 0x14, 0x0c, 0xf9,
  0x1f, 0x6f, 0xe9, 0x26, 0x8d, 0x50, 0x30, 0x6d, 0x8a, 0x44, 0x7b, 0x0f,
  0x0f, 0xde, 0xcc, 0x47, 0x93, 0x28, 0x47, 0x0f, 0x1a, 0x1e, 0x89, 0xc1,
  0x6e, 0xe2, 0x16, 0x4b, 0x90, 0xff, 0x69, 0xc7, 0x96, 0xb3, 0xb9, 0x68,
  0xdd, 0xb6, 0xf9, 0xbc, 0xf1, 0x2d, 0x35, 0xbe, 0xe8, 0x89, 0xee, 0x47,
  0xce, 0xb5, 0x5e, 0x5a, 0x6a, 0x66, 0x18, 0x2d, 0xca, 0x27, 0xc2, 0x95,
  0x94, 0x0e, 0x0a, 0xbd, 0x37, 0x2b, 0x14, 0x8a, 0x7e, 0x7f, 0x0a, 0x8b,
  0xa4, 0xd4, 0x35, 0x64, 0x4e, 0x2e, 0x4c, 0x03, 0xe6, 0xf4, 0xc5, 0xf5,
  0x8a, 0x55, 0x4a, 0x69, 0xd3, 0x25, 0x57, 0xc9, 0x18, 0x5b, 0xaa, 0x39,
  0x34, 0xc5, 0x7c, 0x2b, 0xaa, 0xa8, 0x26, 0x00, 0x2b, 0x0d, 0x12, 0xf2,
  0x15, 0x1a, 0x5a, 0xb7, 0xdf, 0xad, 0xa2, 0x03, 0x5a, 0xe9, 0x90, 0xb6,
  0xf2, 0x22, 0x41, 0x25, 0x90, 0x46, 0xdd, 0x3e, 0x0f, 0x79, 0x2e, 0x41,
  0x6c, 0x23, 0xe1, 0x40, 0xce, 0x0b, 0xc6, 0x0e, 0x44, 0xb3, 0xfd, 0xd9,
  0x52, 0xab, 0x0d, 0x83, 0x58, 0x6b, 0xa3, 0x04, 0x84, 0x41, 0xa4, 0x3b,
  0xd4, 0x28, 0xa8, 0xe7, 0x01, 0x76, 0x66, 0x5f, 0x2a, 0xfb, 0x89, 0x5f,
  0x1d, 0xd4, 0xc1, 0xb5, 0xd1, 0x56, 0x88, 0xc5, 0x59, 0x34, 0x6c, 0xa7,
  0x58, 0x62, 0x7b, 0x13, 0xe3, 0x00, 0x67, 0x46, 0xfd, 0x92, 0xbb, 0xb9,
  0xf2, 0x90, 0x61, 0xc6, 0xd9, 0xf5, 0x81, 0xb5, 0x2b, 0xf2, 0x55, 0x30,
  0x1a, 0x47, 0xa9, 0x35, 0xb0, 0x05, 0xe3, 0x79, 0x15, 0x75, 0xd6, 0xea,
  0x43, 0x9d, 0xfa, 0x0b, 0x27, 0x19, 0xbb, 0x3e, 0xf5, 0x16, 0x14, 0xbc,
  0x3b, 0x71, 0x13, 0x18, 0x6c, 0xd8, 0x94, 0x91, 0x3b, 0xc4, 0x94, 0xe1,
  0xab, 0x1a, 0x1b, 0x87, 0x5a, 0xe3, 0x46, 0x12, 0xff, 0x9b, 0x80, 0x27,
  0xea, 0xa9, 0x44, 0x8d, 0xc6, 0x75, 0xc0, 0x9f, 0x66, 0x4c, 0x11, 0x80,
  0x52, 0x01, 0x24, 0x53, 0x63, 0xc3, 0xa6, 0xe9, 0x95, 0x7f, 0xb3, 0x7b,
  0x6c, 0x4b, 0xad, 0xfc, 0x92, 0xdf, 0xb8, 0x0e, 0xde, 0x24, 0xdc, 0x5d,
  0x55, 0x2e, 0xd8, 0x10, 0x96, 0xb2, 0x84, 0x7f, 0x49, 0x42, 0xf5, 0xa4,
  0x1a, 0xce, 0xbc, 0x96, 0xaa, 0x59, 0xe1, 0x41, 0x8f, 0x8a, 0x83, 0x66,
  0x85, 0xe9, 0x1d, 0x67, 0x61, 0x7f, 0x49, 0xe1, 0x04, 0xe5, 0x2c, 0x27,
  0x95, 0xb9, 0xb1, 0x33, 0xbb, 0x5b, 0x6a, 0x3c, 0xe0, 0x8a, 0x63, 0x5c,
  0x81, 0x4e, 0x75, 0xb1, 0xce, 0x75, 0x26, 0x78, 0x38, 0x9d, 0x17, 0x50,
  0xaf, 0x84, 0x29, 0xd8, 0x1c, 0x35, 0x15, 0xa2, 0x71, 0x14, 0x18, 0x70,
  0xe8, 0xab, 0xd3, 0x37, 0x47, 0x2e, 0x73, 0x52, 0xcc, 0x87, 0xf8, 0xa4,
  0x15, 0xe5, 0x70, 0xc0, 0x79, 0x0d, 0x06, 0x91, 0xd0, 0x6b, 0xe8, 0xae,
  0xb2, 0x3a, 0x57, 0x49, 0xb9, 0xb8, 0x5b, 0xa6, 0x93, 0x4d, 0xc6, 0xb1,
  0x58, 0xce, 0xd3, 0xfb, 0x3e, 0x1b, 0xba, 0x55, 0x9f, 0x33, 0x18, 0x87,
  0xc0, 0xb3, 0x05, 0x8f, 0xc8, 0xac, 0x25, 0x7b, 0xda, 0x32, 0x7a, 0x99,
  0x5e, 0x14, 0xba, 0x87, 0xb3, 0xef, 0xd2, 0xb9, 0x48, 0x31, 0xd2, 0xe4,
  0x16, 0xf8, 0x0f, 0xf1, 0x6f, 0x06, 0x24, 0xe2, 0x7d, 0x6f, 0xc9, 0x02,
  0x0d, 0xf6, 0x1b, 0xcd, 0xed, 0x9f, 0x9d, 0x1d, 0xee, 0x5f, 0xec, 0xbb,
  0xb9, 0x31, 0x00, 0x10, 0xfb, 0xee, 0x58, 0x9c, 0x81, 0x05, 0x21, 0x17,
  0x12, 0xec, 0xfe, 0x1e, 0x09, 0x7b, 0xf5, 0x1b, 0xf7, 0xec, 0xfc, 0x14,
  0xd6, 0xcb, 0xdf, 0xef, 0x58, 0x55, 0x2e, 0xae, 0x3f, 0xd3, 0x2c, 0x8e,
  0xb4, 0x47, 0x7a, 0xc6, 0xe9, 0xdc, 0xc1, 0x25, 0xf5, 0x5c, 0x14, 0x91,
  0x08, 0x71, 0xd1, 0x7b, 0x6c, 0x68, 0x3e, 0x76, 0x92, 0x09, 0x1b, 0x54,
  0x75, 0x2f, 0x7b, 0xcd, 0x4c, 0xaf, 0x60, 0x16, 0xd9, 0x3c, 0xa9, 0x83,
  0x21, 0x69, 0x59, 0x95, 0x64, 0xbc, 0x2c, 0x99, 0x6d, 0xd9, 0x91, 0x60,
  0xe2, 0x9a, 0x60, 0x95, 0xea, 0x47, 0xdd, 0x6d, 0x8e, 0xed, 0x8e, 0x80,
  0x81, 0x33, 0xeb, 0x17, 0x06, 0xc4, 0xe8, 0xcc, 0x44, 0x6a, 0x5c, 0x8a,
  0x60, 0x60, 0xa3, 0xd5, 0xc8, 0xeb, 0xc6, 0xc1, 0x11, 0x60, 0x3f, 0x22,
  0x72, 0x9b, 0x43, 0x63, 0x41, 0x3e, 0x22, 0x8e, 0xd7, 0xb7, 0xf0, 0x53,
  0x99, 0x36, 0x7d, 0xd0, 0x78, 0xa8, 0x74, 0xb0, 0xfa, 0x7a, 0xc7, 0xb4,
  0x33, 0xa9, 0x90, 0x3b, 0x75, 0x1a, 0xf9, 0xa5, 0x8c, 0xa9, 0xa2, 0x4f,
  0x31, 0x52, 0x2f, 0x47, 0x28, 0x36, 0xdd, 0x51, 0xe6, 0x11, 0xa5, 0x47,
  0x49, 0x24, 0x26, 0xf9, 0x16, 0x7f, 0x6d, 0xef, 0x0e, 0x76, 0x3a, 0xcd,
  0xd1, 0xe3, 0xa8, 0x5c, 0xb2, 0xa9, 0x3d, 0x9e, 0xcb, 0xe5, 0x2c, 0xb8,
  0xb4, 0xd9, 0x87, 0x07, 0xa8, 0x55, 0xc0, 0xe3, 0x39, 0x47, 0x5b, 0xb4,
  0x8d, 0xa5, 0x7f, 0xda, 0x70, 0x6e, 0x89, 0x6b, 0xd6, 0xf3, 0xe3, 0x79,
  0xc6, 0x21, 0xa7, 0x31, 0x6c, 0x72, 0xec, 0x78, 0xe8, 0xb4, 0x2f, 0xb0,
  0x78, 0xb1, 0x93, 0xfa, 0x3a, 0xff, 0xa2, 0x00, 0x42, 0xb7, 0xff, 0x01,
  0x70, 0xda, 0x5a, 0x56, 0x57, 0xf1, 0xe7, 0x5a, 0xb9, 0xef, 0x56, 0x30,
  0xd0, 0x7d, 0x81, 0xff, 0xad, 0x99, 0xe6, 0xe1, 0x42, 0x46, 0xcd, 0x36,
  0x04, 0x5d, 0x41, 0x77, 0xd2, 0x8c, 0xca, 0x59, 0x50, 0x7d, 0x2d, 0x96,
  0x70, 0xe5, 0xc6, 0xbd, 0xe1, 0x0a, 0xda, 0x6a, 0xb7, 0x7d, 0xb9, 0x66,
  0xd5, 0x18, 0xc8, 0x55, 0x2f, 0x82, 0xc2, 0xbd, 0x41, 0x31, 0xe0, 0x36,
  0x47, 0xbe, 0x64, 0xda, 0x0b, 0xf8, 0x21, 0xe9, 0x75, 0xb7, 0x31, 0xc3,
  0x96, 0x78, 0xf7, 0x15, 0xad, 0xee, 0x9d, 0x16, 0xd7, 0xce, 0xab, 0xaa,
  0x04, 0x3f, 0xd3, 0x5a, 0x03, 0x02, 0x6d, 0xfe, 0xae, 0xad, 0x52, 0xf0,
  0x0b, 0x05, 0x1b, 0xc9, 0x12, 0x51, 0xed, 0x24, 0x16, 0x01, 0x91, 0x2b,
  0x9a, 0xec, 0xd4, 0x7f, 0x1d, 0x14, 0x37, 0x9f, 0x5b, 0x94, 0x3e, 0xf6,
  0xa3, 0xd9, 0x91, 0x20, 0x25, 0xc0, 0xb6, 0xcc, 0x95, 0x9a, 0x7a, 0x8c,
  0x9e, 0xc3, 0xac, 0x22, 0x43, 0x0e, 0x7f, 0x6c, 0xa8, 0x71, 0x7a, 0x40,
  0xa8, 0xaf, 0x2b, 0x92, 0x99, 0xd7, 0x84, 0x62, 0x1b, 0x6e, 0x86, 0x2f,
  0x0a, 0x0a, 0xff, 0x40, 0x61, 0x49, 0xb0, 0xef, 0x19, 0x7c, 0x6a, 0x32,
  0xd9, 0x7c, 0xb2, 0x25, 0xfb, 0xe2, 0xca, 0xfd, 0xb2, 0x4f, 0xf2, 0x5f,
  0xd4, 0x2a, 0xb5, 0x56, 0xae, 0xec, 0x51, 0x0b, 0x82, 0x4b, 0x45, 0xe3,
  0x7c, 0x20, 0x07, 0x08, 0x84, 0x38, 0x4b, 0xcb, 0x3e, 0xdb, 0x9e, 0x5e,
  0x92, 0x24, 0x96, 0x4c, 0xd6, 0xa9, 0x9f, 0x9a, 0xfb, 0xaf, 0xe5, 0xd4,
  0x7d, 0xfa, 0x5e, 0xc4, 0xef, 0x36, 0x6a, 0x79, 0xab, 0xd1, 0xa3, 0xe1,
  0x97, 0x51, 0x27, 0x9b, 0xce, 0x90, 0x41, 0x7b, 0x25, 0x2e, 0x8a, 0xfd,
  0x2a, 0xb1, 0x54, 0x50, 0x87, 0xd5, 0x28, 0x5d, 0x24, 0x46, 0xcf, 0xdd,
  0x89, 0x78, 0x84, 0x41, 0x51, 0xf5, 0x4d, 0xb5, 0x61, 0x58, 0x12, 0xb3,
  0x44, 0x38, 0xcd, 0x4b, 0xa4, 0xdd, 0x8d, 0xe8, 0xfd, 0xbb, 0x74, 0x52,
  0x5e, 0xb7, 0x23, 0xf5, 0xc9, 0x22, 0xf2, 0xa4, 0x23, 0xc1, 0xbf, 0x40,
  0xc8, 0x0c, 0xaf, 0x13, 0xfb, 0xc2, 0xb7, 0xc5, 0xac, 0xdc, 0x33, 0xeb,
  0x7b, 0x4c, 0x44, 0x77, 0x89, 0x9c, 0x8a, 0xc6, 0xa4, 0x2c, 0x94, 0x6e,
  0x60, 0x67, 0x97, 0xe3, 0x75, 0x6f, 0x24, 0x6e, 0xf5, 0x6b, 0xb5, 0x99,
  0x08, 0xfe, 0x0e, 0x87, 0x60, 0x4b, 0xb0, 0x18, 0x17, 0x5d, 0xbb, 0x49,
  0xa7, 0xcd, 0x6a, 0x75, 0x2b, 0x56, 0xb1, 0xa2, 0xee, 0xac, 0x2b, 0xf1,
  0x8c, 0x6f, 0xba, 0xea, 0x44, 0xe0, 0xda, 0xad, 0xea, 0xaa, 0x97, 0x7c,
  0x89, 0xa8, 0x7b, 0x25, 0xdd, 0x7c, 0xe9, 0x9f, 0xa9, 0xbb, 0x6c, 0x9c,
  0x73, 0xdf, 0xae, 0x97, 0xe2, 0x45, 0xb4, 0xb7, 0xb3, 0xf3, 0x75, 0x2f,
  0x7a, 0x22, 0x65, 0x3c, 0x77, 0xbf, 0x6c, 0x5d, 0x21, 0x59, 0x20, 0xde,
  0x5f, 0x55, 0x4b, 0xe3, 0x5b, 0xbe, 0x04, 0x64, 0xd1, 0x7a, 0xae, 0xc0,
  0xf2, 0x64, 0x19, 0x58, 0x9e, 0x65, 0xf1, 0xd7, 0xec, 0x13, 0x1b, 0xb9,
  0x05, 0x69, 0x44, 0xa2, 0x62, 0x41, 0x2e, 0x33, 0x0e, 0x82, 0xc2, 0xee,
  0x5d, 0xd3, 0x6f, 0x88, 0x4a, 0xb0, 0x5d, 0xe5, 0x7e, 0x5a, 0xd2, 0xce,
  0x8b, 0x6b, 0x9c, 0xfd, 0xd1, 0x32, 0xe7, 0x63, 0x0c, 0x87, 0xab, 0x94,
  0x86, 0x81, 0xe5, 0xdd, 0xc4, 0x2d, 0x12, 0x22, 0x7c, 0x19, 0xcb, 0xb2,
  0x32, 0x9d, 0xc1, 0xba, 0xe2, 0x7b, 0xec, 0x26, 0x42, 0x5c, 0x50, 0xa0,
  0x87, 0x7c, 0x4f, 0xea, 0x14, 0x8f, 0x43, 0xce, 0x8a, 0x53, 0x49, 0x24,
  0x10, 0xb4, 0x0d, 0xa4, 0x50, 0x9d, 0x67, 0xec, 0x73, 0x14, 0x1d, 0x56,
  0xac, 0xd0, 0x2c, 0x28, 0xcb, 0x64, 0x23, 0x20, 0x8f, 0x2d, 0xac, 0x6a,
  0x85, 0x1c, 0x22, 0x69, 0xbf, 0x25, 0x26, 0x67, 0x8a, 0x57, 0xa6, 0x2b,
  0x06, 0xc5, 0x46, 0xd0, 0x23, 0xbb, 0x0e, 0x6c, 0x7c, 0xe1, 0xd0, 0x90,
  0xe9, 0x3b, 0xe6, 0x12, 0x22, 0x08, 0x5c, 0xfb, 0xed, 0x2c, 0x57, 0x53,
  0x80, 0xd6, 0xa7, 0x45, 0xd9, 0x87, 0xab, 0x77, 0x3d, 0x78, 0x12, 0x1e,
  0x11, 0xed, 0x9d, 0x1d, 0xdb, 0x13, 0x0f, 0x2a, 0x29, 0x46, 0x6f, 0x0e,
  0xbe, 0x96, 0xe4, 0x29, 0x9c, 0x2e, 0x66, 0x64, 0x0d, 0x30, 0x0c, 0xad,
  0xae, 0x9e, 0xdc, 0x21, 0x4b, 0xf6, 0xc8, 0x03, 0x7b, 0x55, 0xb9, 0x87,
  0x55, 0x85, 0x98, 0xc5, 0xe3, 0x6b, 0xba, 0x6a, 0xfa, 0x1c, 0xb9, 0xdd,
  0x9e, 0x48, 0xeb, 0x2a, 0x5b, 0xd6, 0x87, 0x05, 0xdc, 0x95, 0xb1, 0xed,
  0x88, 0x46, 0x48, 0x87, 0x28, 0x81, 0x18, 0x44, 0xcb, 0x5d, 0x88, 0xd4,
  0x5b, 0xb1, 0xab, 0x3a, 0x10, 0x27, 0x56, 0x2f, 0xb3, 0x7c, 0x1d, 0x02,
  0x6a, 0x3d, 0x6e, 0x8c, 0xc9, 0x15, 0xc3, 0xe1, 0xf1, 0xbc, 0x3d, 0x19,
  0x3a, 0xb8, 0x2c, 0xd5, 0xb5, 0x0b, 0xb6, 0x25, 0x90, 0x0e, 0x3b, 0xe3,
  0xb4, 0xd1, 0xd6, 0x2c, 0xff, 0x42, 0x70, 0xe5, 0x25, 0x04, 0x8a, 0x43,
  0x7c, 0x44, 0x08, 0x4e, 0xf3, 0x0a, 0x40, 0x03, 0x5a, 0xff, 0xb3, 0xd8,
  0xe3, 0x10, 0x71, 0xd7, 0x62, 0x66, 0xd7, 0x30, 0x16, 0x24, 0xe4, 0x85,
  0x75, 0x9c, 0xd9, 0x2c, 0xbd, 0x9a, 0x8d, 0x32, 0x12, 0xec, 0x71, 0x9d,
  0xdf, 0x14, 0x83, 0x5f, 0xec, 0xf3, 0x6b, 0xba, 0xfb, 0x78, 0xf0, 0x2d,
  0x5b, 0x5f, 0x91, 0x99, 0x90, 0x49, 0x22, 0x98, 0x28, 0x2f, 0x89, 0x85,
  0x7e, 0xf6, 0x43, 0x9f, 0xfe, 0xfd, 0xa9, 0xe1, 0xfc, 0x2c, 0x05, 0x57,
  0x45, 0x2d, 0x6b, 0x16, 0x98, 0x9b, 0x7b, 0xa0, 0x7a, 0x29, 0xde, 0xcd,
  0xed, 0xc8, 0xb7, 0x45, 0x80, 0xef, 0xdf, 0x06, 0xbd, 0xe1, 0xbc, 0x84,
  0x9b, 0xc5, 0xd6, 0x20, 0xb4, 0x84, 0x54, 0xda, 0x18, 0xad, 0x88, 0x80,
  0xed, 0x6e, 0x23, 0x62, 0x18, 0xc7, 0xf9, 0xb8, 0x19, 0xb5, 0xa8, 0x32,
  0x57, 0x58, 0xbd, 0x9e, 0xf8, 0x57, 0xb1, 0x02, 0x64, 0x91, 0xc8, 0x94,
  0xc8, 0x61, 0xb2, 0x84, 0x1b, 0x15, 0x01, 0x65, 0xe8, 0x2d, 0x65, 0x3f,
  0x32, 0xe0, 0x54, 0x29, 0xd0, 0x09, 0x36, 0x33, 0xce, 0x73, 0x20, 0x4b,
  0x0a, 0x8f, 0x91, 0x4a, 0xcb, 0xcb, 0x79, 0x20, 0xa1, 0x78, 0x7f, 0x27,
  0xf5, 0xb0, 0x5c, 0xb4, 0xb8, 0x9a, 0x91, 0x50, 0xd1, 0x00, 0x18, 0x09,
  0xf3, 0x45, 0xc3, 0x82, 0x15, 0xad, 0x91, 0x37, 0x8c, 0xb1, 0xbe, 0x65,
  0x66, 0x38, 0x57, 0x5f, 0x44, 0x0c, 0xea, 0xce, 0x03, 0xa0, 0xd1, 0xe5,
  0x09, 0x17, 0x58, 0xc3, 0xe4, 0x9a, 0x85, 0xa7, 0x11, 0x22, 0x39, 0x11,
  0xb4, 0xde, 0x00, 0xbc, 0xc1, 0x6a, 0x65, 0x6c, 0xc2, 0xb1, 0x3a, 0x66,
  0x03, 0x9c, 0x46, 0xad, 0xd7, 0xeb, 0x55, 0xb4, 0xa0, 0xda, 0xc5, 0xd1,
  0x93, 0xef, 0xbe, 0x8b, 0x2a, 0x20, 0x7f, 0x5b, 0x15, 0x9a, 0x6d, 0x96,
  0x9a, 0x23, 0x22, 0xca, 0xda, 0x8c, 0x04, 0x96, 0x0f, 0x60, 0xe6, 0x65,
  0x84, 0x7e, 0xb0, 0x3e, 0xc9, 0x16, 0x48, 0xc5, 0xfa, 0x91, 0xfa, 0xc6,
  0x1a, 0x9f, 0x1f, 0x04, 0xd4, 0x35, 0xfd, 0x35, 0x2e, 0x9a, 0xa9, 0xe7,
  0x62, 0x97, 0x25, 0xd0, 0x85, 0xa3, 0xfc, 0x6c, 0xad, 0xb0, 0x54, 0x85,
  0xa3, 0x1b, 0xba, 0x05, 0xef, 0xe0, 0xe1, 0xf8, 0xf6, 0x83, 0x18, 0x87,
  0x2e, 0xae, 0x47, 0xa3, 0x31, 0x99, 0x4b, 0x48, 0x41, 0x1c, 0x98, 0xc9,
  0xc6, 0x79, 0xa2, 0x9e, 0x24, 0x2b, 0xd6, 0xd3, 0xe0, 0x09, 0x62, 0x6e,
  0x42, 0x0c, 0x19, 0xcf, 0x0f, 0xa9, 0xc6, 0xc2, 0x1d, 0xf8, 0x9e, 0xf3,
  0xc1, 0x1b, 0xe1, 0x5e, 0xf1, 0xe3, 0xac, 0x38, 0x37, 0xb2, 0x22, 0x19,
  0xe1, 0x01, 0x41, 0x17, 0x66, 0x46, 0xe4, 0x78, 0x32, 0x4d, 0x9f, 0xe2,
  0xfb, 0x26, 0xff, 0x53, 0x6b, 0x8d, 0x35, 0xec, 0x7f, 0x9b, 0x0a, 0xd1,
  0x2f, 0xf3, 0x25, 0x2f, 0x11, 0x3c, 0xd0, 0xc8, 0xb0, 0xcf, 0x7c, 0xd2,
  0x1b, 0xbc, 0x8e, 0x16, 0x37, 0x27, 0x17, 0xa5, 0x77, 0xfe, 0xc2, 0xe7,
  0xd5, 0xd8, 0x59, 0x99, 0x99, 0x25, 0xf0, 0x23, 0x61, 0xbf, 0x5a, 0xd6,
  0xa7, 0x4f, 0x62, 0x70, 0x9f, 0x1f, 0x2b, 0x1a, 0x35, 0x0f, 0x42, 0xd3,
  0x9b, 0xc2, 0x68, 0x66, 0xe2, 0x1c, 0x0e, 0xd6, 0xcc, 0x54, 0x16, 0x23,
  0x22, 0x75, 0x5c, 0xc5, 0xa0, 0x20, 0x3a, 0x74, 0x5f, 0x1e, 0x5d, 0xd4,
  0x8f, 0x16, 0x23, 0x69, 0xa8, 0xd2, 0xca, 0x19, 0x1e, 0xf4, 0xf7, 0xd9,
  0xbb, 0x8b, 0x2d, 0x5f, 0x5f, 0x60, 0x92, 0xd5, 0x4c, 0x67, 0xd6, 0x78,
  0x4b, 0xbe, 0x4c, 0xcc, 0xc9, 0x2f, 0x8a, 0xbc, 0xc1, 0xc9, 0x30, 0xee,
  0x4c, 0xc0, 0x25, 0xf7, 0x64, 0x67, 0x97, 0x64, 0xc3, 0x9d, 0x3d, 0x36,
  0xfe, 0x3c, 0xd9, 0x79, 0xe2, 0x8c, 0xea, 0xf6, 0x54, 0xe3, 0x56, 0x9d,
  0xc8, 0x8b, 0xac, 0xa0, 0x32, 0xc9, 0x3f, 0xb9, 0xbf, 0xe7, 0x8f, 0x7b,
  0x75, 0xf4, 0x9e, 0x42, 0x55, 0xdb, 0x24, 0xa8, 0xdc, 0xbb, 0xe6, 0x68,
  0xf9, 0x15, 0x67, 0x43, 0xce, 0x72, 0x2e, 0x61, 0x6d, 0x50, 0xc3, 0x19,
  0x9e, 0xef, 0xb7, 0x8e, 0x67, 0x73, 0xbc, 0xc6, 0x0d, 0xb4, 0x7e, 0x1d,
  0x85, 0x94, 0xf7, 0x10, 0x33, 0x3c, 0x81, 0xfa, 0x52, 0x61, 0x9d, 0x56,
  0x0d, 0x0c, 0x43, 0x60, 0x0a, 0x33, 0xed, 0xd5, 0x72, 0x34, 0x6b, 0xcd,
  0xfd, 0x29, 0xf2, 0x39, 0xc8, 0x38, 0x66, 0x53, 0x39, 0x8c, 0x01, 0x47,
  0xe5, 0x22, 0x57, 0xc8, 0xa4, 0xf3, 0x27, 0x33, 0x73, 0x11, 0x48, 0xab,
  0xa6, 0x47, 0xd5, 0x2a, 0xce, 0xa5, 0x00, 0xc0, 0x98, 0x2c, 0xc7, 0x89,
  0x14, 0xb4, 0x22, 0x51, 0xbe, 0x5c, 0x45, 0x23, 0x81, 0x4d, 0x34, 0x6c,
  0x16, 0x34, 0xed, 0x8f, 0x45, 0xd3, 0xc4, 0x00, 0x16, 0x89, 0x24, 0xad,
  0x54, 0x30, 0xb7, 0xc5, 0x90, 0x09, 0xcd, 0x0d, 0xe6, 0x32, 0x97, 0x44,
  0x5d, 0x07, 0x5e, 0x9d, 0x5f, 0x66, 0x6a, 0xf4, 0x6c, 0x7a, 0x63, 0xf8,
  0x20, 0xb0, 0x6f, 0xd2, 0xec, 0xe2, 0xb1, 0x94, 0x76, 0x63, 0x6a, 0xfd,
  0x02, 0xe1, 0x78, 0xb5, 0xf6, 0x7e, 0x73, 0x80, 0xd6, 0x87, 0xc9, 0x01,
  0x2c, 0x81, 0xe5, 0x2e, 0x04, 0x62, 0xbe, 0x64, 0x7d, 0xeb, 0x91, 0xaa,
  0x34, 0xbf, 0xb1, 0x69, 0x5a, 0xe7, 0x96, 0xcf, 0xac, 0x16, 0x7c, 0x89,
  0xbb, 0x39, 0x4c, 0x4c, 0x38, 0x82, 0xeb, 0x62, 0x3f, 0xfd, 0xfd, 0x90,
  0x56, 0x03, 0xbb, 0x79, 0xf6, 0x9c, 0x62, 0xd9, 0xab, 0x62, 0xee, 0xac,
  0xab, 0x38, 0x27, 0xc5, 0xc7, 0x63, 0xab, 0x69, 0xa6, 0x31, 0xe6, 0x0c,
  0xf6, 0xcb, 0x77, 0x58, 0x72, 0xcf, 0x3e, 0x14, 0x3a, 0xed, 0x1f, 0x3f,
  0x19, 0xb4, 0xdb, 0x6b, 0x44, 0xb7, 0xf6, 0x31, 0xa9, 0xc6, 0xda, 0xc4,
  0xe3, 0x80, 0x2c, 0x1c, 0xa4, 0x91, 0x02, 0xe1, 0x34, 0x98, 0x1d, 0x9b,
  0x48, 0x5a, 0xb0, 0x36, 0x0a, 0xa0, 0x5e, 0x8b, 0x34, 0x5b, 0xae, 0x45,
  0xe0, 0xb2, 0x0a, 0x53, 0x6e, 0x3d, 0x78, 0x9a, 0x0d, 0x57, 0x30, 0xa6,
  0xcd, 0x37, 0x1e, 0x12, 0x43, 0x34, 0xa7, 0xb2, 0xb1, 0x58, 0xa2, 0x23,
  0xf2, 0x25, 0x61, 0x10, 0x14, 0x19, 0x29, 0x05, 0x79, 0x23, 0x3e, 0x8a,
  0xb3, 0xd5, 0x21, 0xae, 0x63, 0xb1, 0x98, 0x26, 0x83, 0x34, 0x03, 0x47,
  0x15, 0xb3, 0x6d, 0x21, 0x8c, 0x07, 0xc3, 0xd4, 0xde, 0x28, 0x21, 0x88,
  0xf6, 0x3a, 0x57, 0x92, 0xd4, 0x93, 0x0d, 0xe5, 0x46, 0x18, 0x04, 0x13,
  0xcd, 0xdd, 0x75, 0xc6, 0x30, 0xa6, 0xce, 0xda, 0xd6, 0xe2, 0xbb, 0xa2,
  0xfb, 0x78, 0x10, 0x60, 0x6b, 0xaa, 0xa2, 0x84, 0xe5, 0x54, 0x74, 0xe7,
  0xd4, 0x10, 0xfb, 0x47, 0x5c, 0x27, 0xfa, 0xaf, 0xd9, 0x48, 0x85, 0x0d,
  0x5c, 0x98, 0x6d, 0x70, 0xa6, 0x97, 0x1c, 0x3e, 0x4e, 0xda, 0x36, 0x69,
  0xfa, 0xe2, 0xf4, 0xc3, 0x80, 0xe6, 0x49, 0x09, 0x55, 0x93, 0x83, 0xcb,
  0x45, 0x23, 0x88, 0xa2, 0x2b, 0x2e, 0xaa, 0x28, 0x91, 0xa8, 0x12, 0x8a,
  0xd8, 0x80, 0x64, 0x73, 0x95, 0x83, 0x54, 0x1a, 0xe5, 0xc5, 0x81, 0x5f,
  0x6b, 0xcd, 0x4d, 0xfa, 0xeb, 0xa9, 0xad, 0x6f, 0x78, 0x37, 0xe6, 0xcd,
  0x50, 0xbc, 0x37, 0xfc, 0xe1, 0x20, 0x3a, 0x94, 0x20, 0x6b, 0x71, 0x36,
  0x2c, 0x35, 0xc5, 0x50, 0xea, 0xc9, 0xfa, 0x56, 0xe6, 0xdb, 0xa8, 0xf0,
  0x5a, 0xe6, 0xe3, 0x46, 0x23, 0x4e, 0x0e, 0x2a, 0xc6, 0x6a, 0x72, 0x18,
  0xf0, 0x83, 0x15, 0x27, 0x06, 0x44, 0x9b, 0x6e, 0xe1, 0xfc, 0x00, 0xaa,
  0x5c, 0x36, 0x35, 0x0f, 0x46, 0xed, 0x6a, 0x2b, 0x38, 0xeb, 0xa0, 0x44,
  0x25, 0x86, 0x58, 0x54, 0x61, 0xf1, 0x9e, 0x01, 0xee, 0x4b, 0x5d, 0x4b,
  0x2d, 0x26, 0x8e, 0xa5, 0xb9, 0xfa, 0x39, 0xa4, 0x33, 0xcc, 0xcb, 0x71,
  0xd5, 0x44, 0xd9, 0x89, 0xd4, 0x28, 0xe5, 0xdb, 0xb2, 0x8d, 0x3c, 0xaf,
  0xcd, 0xa7, 0x5b, 0x91, 0xf4, 0xba, 0xb9, 0xbb, 0x25, 0x20, 0x6b, 0x9a,
  0x9d, 0x1f, 0x42, 0x89, 0x5a, 0xd5, 0xa4, 0xb0, 0xa2, 0x6b, 0xd9, 0xf4,
  0x97, 0x8b, 0xe4, 0x63, 0xd5, 0x3c, 0xf8, 0x4d, 0x3a, 0xe6, 0x90, 0x13,
  0x59, 0xf0, 0x10, 0xab, 0xc9, 0x02, 0x6e, 0x94, 0x42, 0xf0, 0xc2, 0x89,
  0x65, 0x3a, 0xa0, 0xd9, 0x16, 0x56, 0xc6, 0xd2, 0x25, 0xad, 0x98, 0x64,
  0x0e, 0xc2, 0x65, 0x96, 0x67, 0x38, 0xf8, 0x70, 0x7f, 0x63, 0xb2, 0x5b,
  0x9a, 0x98, 0xd2, 0xe6, 0xd0, 0x6b, 0x24, 0xdc, 0x9d, 0xbe, 0x39, 0xea,
  0x84, 0x15, 0xb4, 0x9c, 0x7f, 0xb1, 0xba, 0x8d, 0x0d, 0xda, 0xdd, 0x8f,
  0xfe, 0xb6, 0x4c, 0xc7, 0x37, 0xbc, 0x83, 0x1c, 0x95, 0xc4, 0xbe, 0xa3,
  0xc4, 0x49, 0x72, 0xc4, 0xea, 0x21, 0xac, 0x8a, 0x1f, 0x1c, 0x1a, 0x19,
  0x5f, 0xa3, 0x4a, 0x35, 0xcd, 0xa3, 0x1d, 0x16, 0x0e, 0xc0, 0x28, 0x68,
  0xbb, 0x35, 0x79, 0x57, 0xed, 0x1e, 0x22, 0xa0, 0x4f, 0x32, 0x84, 0xb0,
  0xc2, 0x09, 0x22, 0xdb, 0xbd, 0x0e, 0xe7, 0xbb, 0x3b, 0x5b, 0x21, 0x7d,
  0xbc, 0x5b, 0x05, 0xfc, 0xee, 0x12, 0xff, 0x21, 0x9e, 0xdf, 0xb5, 0x20,
  0x34, 0x36, 0x66, 0x3c, 0x00, 0x80, 0xb1, 0xae, 0x6b, 0x21, 0x60, 0xe9,
  0xc2, 0xb7, 0x2e, 0x8d, 0xff, 0xc6, 0x37, 0xb5, 0xac, 0xdf, 0x12, 0x59,
  0xc2, 0xe1, 0x15, 0xcd, 0x1f, 0xf7, 0xcd, 0xf7, 0x5e, 0x7b, 0xe7, 0x1b,
  0x6c, 0x4f, 0x30, 0x4f, 0x7b, 0xbe, 0xa7, 0xf9, 0x1c, 0x7e, 0x74, 0x62,
  0x66, 0x0d, 0x8e, 0x37, 0x77, 0xd4, 0x9a, 0x7f, 0x10, 0x4f, 0x5d, 0xe4,
  0x02, 0xcc, 0x39, 0xb1, 0xd5, 0x60, 0x11, 0x06, 0x28, 0x6f, 0xc3, 0x86,
  0x54, 0x1d, 0xa5, 0x46, 0xb7, 0x3d, 0x5c, 0x7b, 0xbb, 0x12, 0x08, 0xd7,
  0x3c, 0xb2, 0x7c, 0x0b, 0x57, 0x9e, 0xa9, 0x6f, 0x9b, 0x20, 0x5c, 0x43,
  0x6a, 0x9f, 0x24, 0x88, 0x33, 0x12, 0x58, 0x81, 0x37, 0xe9, 0x38, 0xcf,
  0x8a, 0xec, 0x52, 0xa4, 0x00, 0xdb, 0x08, 0x67, 0x4a, 0x42, 0x4e, 0x74,
  0x8c, 0x42, 0x17, 0xf5, 0x6b, 0x62, 0xac, 0xc5, 0x10, 0x35, 0x88, 0x19,
  0x57, 0xfc, 0x8c, 0x4e, 0x13, 0x8c, 0x77, 0x30, 0xf7, 0x96, 0x62, 0xed,
  0x8e, 0x5d, 0x9c, 0xa7, 0x3a, 0xdf, 0x2d, 0x6e, 0xf2, 0xd9, 0xc3, 0xfa,
  0x2b, 0xb6, 0x40, 0xcb, 0x9c, 0xa8, 0x79, 0x56, 0xcb, 0x4d, 0x5e, 0x19,
  0x5e, 0x92, 0x68, 0x1d, 0xf6, 0x5a, 0xfb, 0xe8, 0x74, 0xce, 0x85, 0xa0,
  0x60, 0x6b, 0xe9, 0xe4, 0xb0, 0x66, 0x20, 0x47, 0x02, 0x46, 0xc7, 0x47,
  0x17, 0xaf, 0x89, 0xb2, 0xf2, 0xf8, 0xb2, 0xd4, 0x1f, 0x0d, 0x03, 0x7d,
  0x9e, 0xfc, 0x3d, 0xbe, 0xe9, 0x17, 0x0b, 0xec, 0x55, 0x1f, 0xdc, 0xb4,
  0xbf, 0xf3, 0x74, 0x50, 0xde, 0xb7, 0x46, 0x0b, 0x8a, 0x65, 0xd9, 0x0c,
  0x94, 0xca, 0x69, 0xfd, 0xce, 0x69, 0x8a, 0x2a, 0x2e, 0xe7, 0xec, 0x7e,
  0x55, 0x07, 0x5c, 0x6c, 0xab, 0x42, 0xcb, 0x70, 0x3b, 0x7d, 0x7e, 0xdc,
  0x13, 0xcb, 0x83, 0x10, 0x28, 0x8f, 0x0e, 0xc0, 0xd4, 0x28, 0xcb, 0x35,
  0xd0, 0x8b, 0x61, 0x22, 0x63, 0x23, 0xce, 0x92, 0xcb, 0x5e, 0xae, 0x0f,
  0xac, 0x5c, 0x93, 0xa4, 0xe7, 0x22, 0x2d, 0x2b, 0xa4, 0xda, 0xae, 0x4d,
  0x2f, 0x9b, 0x78, 0xf7, 0x58, 0x5a, 0x8e, 0x66, 0x63, 0xaa, 0xb0, 0xb0,
  0x6b, 0x80, 0x4f, 0xb1, 0x05, 0xe7, 0x03, 0x95, 0xdd, 0x05, 0xa8, 0x14,
  0x11, 0xf6, 0x06, 0x04, 0x57, 0x23, 0x3b, 0x96, 0x74, 0xcd, 0xe5, 0x38,
  0xe0, 0x6a, 0xb2, 0x6c, 0xcf, 0xae, 0xf3, 0xd1, 0xfe, 0x32, 0x7a, 0xc1,
  0x28, 0x4f, 0xc9, 0x1c, 0x05, 0x28, 0xec, 0x84, 0xcb, 0x6d, 0x2a, 0xb0,
  0xbe, 0x6c, 0xfb, 0x77, 0x5c, 0x30, 0x2c, 0x3b, 0xdc, 0x5f, 0xb6, 0x8f,
  0x2e, 0xce, 0x13, 0xdc, 0x7e, 0x12, 0x11, 0xa9, 0xb7, 0xfc, 0x7f, 0xb4,
  0x3c, 0xfc, 0xdb, 0x6d, 0x8e, 0xdd, 0x1f, 0x2d, 0xf1, 0x5d, 0xed, 0xc5,
  0x43, 0xe1, 0xc3, 0x32, 0x6f, 0x79, 0x42, 0x5d, 0xb1, 0x81, 0x43, 0xb5,
  0x40, 0xc4, 0xdc, 0x2c, 0xac, 0x99, 0xc2, 0xd5, 0xce, 0x49, 0x6b, 0xac,
  0x53, 0xdb, 0x52, 0xb8, 0x49, 0xaf, 0x8a, 0xfd, 0x5b, 0xb3, 0xb2, 0x4b,
  0x37, 0x30, 0xf9, 0x84, 0xcd, 0xb7, 0xb9, 0xac, 0xf9, 0x75, 0x97, 0xb8,
  0xa5, 0x6a, 0x83, 0x80, 0x32, 0xa8, 0x0e, 0xae, 0x4d, 0x70, 0x76, 0x29,
  0x17, 0xb6, 0xa0, 0xcd, 0xbf, 0x5e, 0x92, 0x48, 0xdb, 0x6b, 0x91, 0x56,
  0xcc, 0xa0, 0x9a, 0x4a, 0x49, 0x87, 0x58, 0xc1, 0x04, 0x14, 0x15, 0x4d,
  0x5b, 0x40, 0xda, 0xfa, 0x2d, 0x43, 0x30, 0x36, 0xea, 0x34, 0xb4, 0x8d,
  0xce, 0xec, 0xe0, 0x3c, 0x2a, 0xb7, 0x80, 0xff, 0xa2, 0x89, 0xdd, 0x6e,
  0x49, 0xf5, 0xb4, 0x44, 0x8d, 0xae, 0x5b, 0x3a, 0xaa, 0xe6, 0x67, 0x3c,
  0xb4, 0xcd, 0x5a, 0x6b, 0xdd, 0xe7, 0x72, 0x20, 0xf9, 0x9e, 0x0d, 0x94,
  0x2a, 0xfe, 0x5d, 0x1c, 0x84, 0x08, 0xc1, 0x00, 0x34, 0x58, 0x9b, 0x2a,
  0xa5, 0x78, 0x82, 0x73, 0xd7, 0xfa, 0xec, 0xb1, 0x53, 0x7f, 0x84, 0x90,
  0x20, 0xcd, 0xae, 0x4b, 0xbf, 0xa9, 0x4d, 0x5d, 0xd3, 0xee, 0xd2, 0x49,
  0x7b, 0x6e, 0x84, 0xae, 0x80, 0x01, 0x5d, 0xeb, 0x1a, 0x20, 0xdd, 0xcc,
  0xd2, 0x1b, 0x8f, 0x0f, 0xe9, 0xba, 0x81, 0x48, 0x74, 0x45, 0x7b, 0xff,
  0xc5, 0x6a, 0x0d, 0x66, 0x3c, 0xd7, 0x0e, 0x30, 0x8d, 0x91, 0xfd, 0x8e,
  0x5c, 0xac, 0x28, 0x28, 0x37, 0x85, 0x84, 0xef, 0x10, 0x3f, 0x44, 0xdc,
  0xbd, 0x96, 0x65, 0xda, 0xac, 0xb2, 0x9c, 0xfb, 0xec, 0x7d, 0x86, 0x74,
  0xb8, 0x5e, 0xe2, 0x96, 0x1d, 0xad, 0x2c, 0xef, 0x4d, 0xa1, 0x7a, 0xf2,
  0x44, 0xc1, 0x9c, 0x83, 0x01, 0x17, 0x2d, 0xf7, 0x0c, 0x67, 0x3a, 0x25,
  0x33, 0xf5, 0x40, 0x8d, 0xf2, 0xec, 0x86, 0xc8, 0x1b, 0xaf, 0xb1, 0x04,
  0x0b, 0x71, 0x59, 0xce, 0xa8, 0xe9, 0x35, 0xb4, 0xe2, 0x82, 0xfb, 0xd0,
  0x62, 0x6d, 0xd2, 0xfb, 0x27, 0xb2, 0xfc, 0x18, 0x4f, 0xec, 0x02, 0x2b,
  0xc5, 0x51, 0x7d, 0x76, 0x13, 0xf2, 0xc5, 0x81, 0x8a, 0x3f, 0x3e, 0x74,
  0xa1, 0xa1, 0x92, 0x3e, 0x00, 0xf8, 0xfb, 0x6b, 0x1e, 0x0f, 0xdd, 0x5d,
  0x79, 0x4f, 0xb3, 0x31, 0x79, 0x5b, 0x42, 0x92, 0x29, 0xa7, 0x33, 0x8f,
  0x2c, 0x63, 0x98, 0x91, 0x6f, 0x2f, 0x4e, 0xde, 0x44, 0x6b, 0xa4, 0x32,
  0xfe, 0xae, 0xfa, 0xd5, 0xbf, 0x22, 0x9b, 0xd1, 0x17, 0xc7, 0xc7, 0x43,
  0x96, 0xcc, 0xd4, 0x13, 0xd8, 0xd0, 0xfd, 0x4a, 0x71, 0x49, 0xe1, 0x26,
  0xcb, 0x53, 0x52, 0xd1, 0x72, 0x4e, 0xd7, 0x29, 0xb3, 0x71, 0x36, 0x45,
  0x62, 0x17, 0xde, 0xa1, 0x86, 0xa4, 0x08, 0x30, 0x73, 0x54, 0xe0, 0x4b,
  0x4d, 0x99, 0xa6, 0x16, 0x49, 0x23, 0x3c, 0x01, 0x8a, 0x0b, 0x0f, 0xc0,
  0x08, 0x41, 0x04, 0x44, 0x3e, 0xc1, 0x28, 0xa4, 0x67, 0x11, 0xf7, 0x29,
  0x63, 0x3f, 0xe3, 0x76, 0x57, 0xa5, 0xf5, 0x26, 0xe5, 0xe0, 0xab, 0x35,
  0xd5, 0x13, 0xaa, 0x40, 0x2f, 0x1c, 0x9e, 0x3e, 0xc9, 0x72, 0xf6, 0x59,
  0x04, 0x30, 0x23, 0x80, 0x9f, 0x5a, 0x72, 0x0c, 0x02, 0x86, 0xb7, 0xca,
  0x1a, 0x91, 0xdc, 0x77, 0xd7, 0x99, 0xf8, 0xff, 0x79, 0x99, 0x41, 0x4b,
  0xb2, 0xbb, 0xec, 0x9b, 0x10, 0x90, 0x0a, 0xb9, 0x8c, 0x2d, 0x09, 0x9b,
  0x73, 0x6e, 0xdc, 0x6e, 0xb4, 0x86, 0x27, 0x59, 0x29, 0x2b, 0xc9, 0x7a,
  0x21, 0x41, 0x00, 0x66, 0x29, 0xda, 0x9c, 0xc3, 0xf4, 0x6a, 0x0d, 0x42,
  0x52, 0xbb, 0xd0, 0x87, 0x11, 0x3d, 0x2c, 0xef, 0xb5, 0x45, 0x68, 0x56,
  0xe4, 0x3d, 0xa2, 0xb6, 0x7f, 0x59, 0xd4, 0xd3, 0x62, 0x66, 0x38, 0xcc,
  0xeb, 0x45, 0xbd, 0x0f, 0xc8, 0x73, 0xb5, 0x44, 0x19, 0x4c, 0xed, 0x3f,
  0x2a, 0x9c, 0x64, 0x34, 0x52, 0xbd, 0xc4, 0x5b, 0x63, 0xea, 0xbe, 0x95,
  0x18, 0x7c, 0xbd, 0xe6, 0x33, 0x7d, 0x28, 0x84, 0x35, 0x2a, 0xca, 0x49,
  0xb6, 0x14, 0xef, 0x16, 0x1b, 0xdd, 0x72, 0xe3, 0xc6, 0xff, 0xf8, 0x67,
  0xd3, 0x5d, 0xf7, 0xc3, 0x4f, 0x22, 0x3d, 0x4a, 0xc4, 0xa3, 0x0f, 0xff,
  0x33, 0xa2, 0x2a, 0x3c, 0x14, 0x1c, 0xb6, 0x0f, 0x79, 0x05, 0x32, 0x45,
  0x39, 0x5c, 0x0d, 0x74, 0x7c, 0xf1, 0x52, 0x2b, 0x2b, 0xd5, 0xb1, 0x59,
  0xbe, 0x1b, 0x83, 0x03, 0x07, 0x75, 0x47, 0x03, 0xa0, 0x26, 0xc5, 0x93,
  0x99, 0xac, 0x83, 0xee, 0xb1, 0xe0, 0xe0, 0x2a, 0x06, 0x21, 0x47, 0x66,
  0x8a, 0x01, 0x94, 0xc7, 0x0f, 0x46, 0xcb, 0x1e, 0x8a, 0x74, 0xde, 0xc4,
  0x7b, 0x90, 0x8d, 0xd6, 0x20, 0xcb, 0x7f, 0xd0, 0x79, 0xeb, 0x95, 0x77,
  0xd9, 0x3f, 0x07, 0x30, 0xf5, 0xb3, 0x9a, 0xdf, 0xcf, 0x04, 0xe9, 0xf1,
  0xfd, 0x47, 0xbb, 0xd0, 0x80, 0x3a, 0x4d, 0x7c, 0x4b, 0x5e, 0x01, 0xdb,
  0x73, 0x17, 0x33, 0xbd, 0x06, 0x5e, 0xa2, 0xda, 0x1d, 0x7a, 0xe9, 0xc1,
  0xb0, 0xf0, 0xcf, 0x01, 0xfe, 0xfd, 0x61, 0xb7, 0xff, 0xec, 0x27, 0xd7,
  0xeb, 0x47, 0xbb, 0xef, 0x3f, 0xda, 0xeb, 0xb4, 0xc2, 0x81, 0x42, 0x57,
  0x8c, 0xb4, 0x4e, 0x44, 0xb5, 0x78, 0xb6, 0x94, 0x3c, 0x14, 0x4f, 0x7b,
  0x5c, 0xf8, 0xc8, 0x33, 0x07, 0xe0, 0x55, 0x87, 0x1a, 0x3b, 0x3f, 0x29,
  0x3e, 0x00, 0x1f, 0x14, 0x56, 0x12, 0xb3, 0x9e, 0xe0, 0x7e, 0xe4, 0x4f,
  0x45, 0x2c, 0x91, 0x90, 0x03, 0x33, 0x14, 0x35, 0x90, 0x5a, 0x10, 0x5f,
  0x31, 0x59, 0x91, 0xa2, 0x20, 0x06, 0xbd, 0x80, 0xac, 0x4f, 0x19, 0x86,
  0x08, 0x38, 0x3b, 0xfd, 0x16, 0x03, 0x8e, 0x10, 0x75, 0x40, 0xd5, 0xb1,
  0xf6, 0x14, 0x14, 0x8d, 0x55, 0xa0, 0x4e, 0x07, 0xd7, 0x23, 0xc5, 0xd0,
  0x13, 0xc8, 0x08, 0x0d, 0x3c, 0x1c, 0xce, 0x56, 0x71, 0x86, 0xbb, 0x10,
  0xac, 0x29, 0x7c, 0x59, 0x8f, 0x71, 0x4f, 0x73, 0x92, 0x88, 0xd4, 0xb8,
  0x0c, 0xcb, 0xb2, 0x6c, 0x66, 0x24, 0x0f, 0xb6, 0x5a, 0x23, 0xef, 0xb4,
  0xb5, 0x20, 0x7e, 0x31, 0x0a, 0x42, 0x30, 0xa2, 0x42, 0xb0, 0x0f, 0xa1,
  0x4f, 0x01, 0x4c, 0x6d, 0x0c, 0x16, 0xbd, 0x26, 0xb2, 0xda, 0x55, 0xb6,
  0xea, 0x39, 0xf8, 0x8d, 0x64, 0x5a, 0x24, 0xad, 0x20, 0xb1, 0x20, 0x8a,
  0xa5, 0x81, 0x59, 0x9a, 0x92, 0x55, 0x21, 0x08, 0xb6, 0x51, 0x30, 0xe7,
  0x96, 0x5a, 0xa0, 0x16, 0xa8, 0xf7, 0x01, 0xaa, 0xe8, 0xa3, 0xd6, 0x4a,
  0x11, 0xbd, 0x5c, 0x5c, 0xe7, 0x74, 0xfd, 0x3d, 0x90, 0x3b, 0x8c, 0xa7,
  0xe4, 0x21, 0x77, 0x14, 0x83, 0xec, 0xd8, 0xdf, 0x30, 0x8b, 0x15, 0xf1,
  0xae, 0x4f, 0x76, 0x76, 0xeb, 0x7b, 0x51, 0x29, 0x2b, 0x9d, 0x73, 0xd5,
  0x44, 0xba, 0x1d, 0xce, 0x5f, 0x1f, 0x44, 0xd1, 0xde, 0xc7, 0xbb, 0x1f,
  0x6f, 0xef, 0xee, 0x0c, 0x9e, 0x0c, 0xf6, 0x54, 0x79, 0x65, 0xa3, 0x2a,
  0x09, 0x4f, 0xb7, 0x5c, 0xfb, 0x1d, 0x3e, 0xe8, 0x76, 0xb7, 0x2d, 0x24,
  0x3a, 0x6a, 0x2e, 0x40, 0x57, 0x54, 0xec, 0x0a, 0xcf, 0xe3, 0x63, 0x78,
  0x98, 0x9d, 0x43, 0xd1, 0xc0, 0xef, 0x5b, 0x2a, 0x86, 0x60, 0x28, 0x2a,
  0x1f, 0x2c, 0x05, 0x1c, 0x75, 0x94, 0xd2, 0xfd, 0x56, 0xa2, 0x44, 0x12,
  0xd2, 0x15, 0x49, 0xe6, 0x31, 0x04, 0x0d, 0x89, 0xe6, 0x0d, 0xaa, 0x81,
  0xb5, 0xe3, 0xb8, 0xcc, 0x5d, 0x59, 0x66, 0x24, 0xfb, 0x99, 0xf6, 0xc1,
  0x91, 0x63, 0xa9, 0xa4, 0xcf, 0x31, 0x30, 0x03, 0xdd, 0x0a, 0x5c, 0xb0,
  0xe2, 0x2b, 0xcb, 0xde, 0x8b, 0x5b, 0x83, 0xae, 0xd4, 0xdf, 0xaa, 0x57,
  0x6e, 0x2c, 0x9e, 0x79, 0x0f, 0x22, 0xa0, 0x1f, 0x48, 0x25, 0x02, 0xf6,
  0x65, 0x09, 0x50, 0xdc, 0x24, 0x6d, 0x03, 0x6b, 0x4a, 0x1d, 0xec, 0xb9,
  0xdf, 0x71, 0xcd, 0xc2, 0x87, 0x03, 0x87, 0x63, 0x36, 0xee, 0xbc, 0x21,
  0xe4, 0xc1, 0x48, 0x9c, 0x07, 0x90, 0xad, 0x44, 0x90, 0x20, 0xa2, 0x87,
  0xe8, 0xf1, 0x20, 0x45, 0x2c, 0xd8, 0x74, 0x4d, 0x03, 0x4f, 0x25, 0x6d,
  0xa2, 0x66, 0x1d, 0x31, 0x29, 0x55, 0x8b, 0x2e, 0xcd, 0x66, 0xcb, 0x46,
  0x01, 0x63, 0xab, 0xf1, 0xa4, 0x12, 0x47, 0x50, 0x8c, 0x4e, 0xc4, 0x1f,
  0x67, 0x51, 0xb2, 0xa8, 0x48, 0x0e, 0x59, 0x42, 0x28, 0x1c, 0x9f, 0xfc,
  0x76, 0x02, 0xdb, 0x76, 0xb1, 0x0a, 0x39, 0x32, 0x8d, 0xfa, 0x74, 0xb7,
  0x2d, 0x1a, 0x75, 0x25, 0xf7, 0xb6, 0x7e, 0xcd, 0xe8, 0xb4, 0xd6, 0xe4,
  0x4d, 0x88, 0x6f, 0xd4, 0x04, 0x96, 0xb2, 0x2e, 0xe9, 0x37, 0x96, 0x9b,
  0xf1, 0x63, 0x5a, 0x17, 0xdb, 0x97, 0x01, 0xc6, 0xd4, 0xd7, 0x7a, 0xb7,
  0xb5, 0x8a, 0x12, 0x56, 0xd9, 0x56, 0x75, 0xdd, 0xa5, 0xaf, 0x45, 0xcf,
  0x65, 0x7d, 0x59, 0x8c, 0x93, 0xee, 0xa5, 0x1a, 0x0b, 0x44, 0x51, 0x6c,
  0x49, 0xd0, 0x93, 0x98, 0x50, 0x1b, 0x8b, 0x2d, 0x3c, 0x5a, 0x42, 0x7e,
  0xf4, 0x49, 0x83, 0x7f, 0x77, 0x07, 0xa7, 0x9d, 0x24, 0x30, 0xa5, 0xa6,
  0x10, 0x5b, 0x48, 0x47, 0x18, 0x58, 0x9a, 0x14, 0xbf, 0xb5, 0xb7, 0x5e,
  0xf6, 0x67, 0xed, 0x7a, 0x36, 0xb7, 0x68, 0xc2, 0xc2, 0xfc, 0x03, 0x7b,
  0x14, 0x6e, 0x91, 0x48, 0xfe, 0xbf, 0xea, 0x1e, 0x49, 0xff, 0x2d, 0x9b,
  0xa4, 0x7d, 0xb5, 0x86, 0xf1, 0x04, 0x18, 0x7c, 0xbf, 0x75, 0x34, 0x4c,
  0xb0, 0xa0, 0x75, 0xbd, 0xa7, 0x61, 0x8d, 0x7e, 0x90, 0xad, 0xb8, 0x45,
  0x5c, 0xe7, 0xbe, 0xa8, 0xaf, 0x63, 0x9b, 0x4b, 0xfa, 0x01, 0x8e, 0x22,
  0xcb, 0x39, 0xaf, 0x58, 0xd8, 0x2b, 0x2b, 0x5a, 0x8f, 0x5b, 0x70, 0x4f,
  0x6a, 0x20, 0xe1, 0x07, 0x16, 0xf5, 0x37, 0xa2, 0x52, 0x6f, 0xfd, 0x7e,
  0x04, 0xfb, 0x86, 0x1e, 0xf8, 0x01, 0x76, 0x12, 0xac, 0x73, 0xd3, 0xe0,
  0xf0, 0xaf, 0x91, 0x2a, 0xdb, 0x3c, 0x2a, 0xcb, 0xca, 0x5d, 0x54, 0x96,
  0xaf, 0x8e, 0x22, 0xf4, 0xef, 0xa5, 0x50, 0xd1, 0x47, 0x6d, 0xd1, 0x16,
  0xdb, 0xba, 0x6e, 0x25, 0xa2, 0x61, 0xa7, 0x6d, 0xce, 0x05, 0x2e, 0xb7,
  0x4d, 0x2f, 0x4a, 0x1b, 0xb6, 0xad, 0x9b, 0xfd, 0x7b, 0x7b, 0x75, 0xab,
  0xd7, 0x12, 0x28, 0xca, 0xf7, 0x55, 0x8b, 0xdc, 0xc2, 0x4d, 0x39, 0x1b,
  0x8b, 0x95, 0x44, 0xd3, 0x52, 0xbc, 0x92, 0x63, 0xc5, 0x23, 0x89, 0xac,
  0x66, 0x75, 0x64, 0x48, 0xab, 0xf7, 0xab, 0xf5, 0xc0, 0xbb, 0x33, 0xd2,
  0x7a, 0xa7, 0x16, 0x88, 0x98, 0x96, 0x5a, 0x7e, 0x86, 0x31, 0xec, 0x58,
  0xca, 0x77, 0x51, 0x21, 0x85, 0xc2, 0x3f, 0x50, 0x27, 0x8d, 0x2b, 0x19,
  0x9d, 0xc6, 0x0b, 0xea, 0x89, 0x4b, 0xc8, 0xf2, 0xdd, 0x1b, 0x4b, 0x69,
  0x9c, 0xd2, 0xa3, 0xe4, 0xe9, 0x32, 0x1c, 0x9c, 0xbe, 0x7d, 0x7b, 0x74,
  0xe0, 0xb1, 0xaf, 0x9b, 0x41, 0x3a, 0x4d, 0x73, 0x83, 0x9a, 0x35, 0x24,
  0xe4, 0x51, 0x03, 0xd1, 0xd4, 0x08, 0x6c, 0xce, 0x6a, 0x3d, 0x5f, 0xb0,
  0x1c, 0xb4, 0xeb, 0xc1, 0x12, 0x99, 0x10, 0xcf, 0x25, 0x04, 0x53, 0x97,
  0xca, 0x56, 0xaa, 0xcc, 0xfe, 0x3d, 0x74, 0x24, 0xdd, 0x56, 0x98, 0xdc,
  0x72, 0xf4, 0x00, 0x40, 0x10, 0x04, 0x7c, 0x31, 0x2f, 0x3d, 0x88, 0x0d,
  0xe4, 0xbc, 0x54, 0x62, 0x46, 0x59, 0x8b, 0x9b, 0xfa, 0x6f, 0xc7, 0x06,
  0x3a, 0xdb, 0x0e, 0x8a, 0x8e, 0xbe, 0x54, 0xe0, 0xc8, 0xcf, 0xd6, 0xd4,
  0x35, 0x63, 0x93, 0x61, 0x11, 0xa4, 0xa2, 0x97, 0x59, 0xbe, 0x3d, 0x65,
  0xb1, 0x19, 0xd1, 0xde, 0xd9, 0xd4, 0x00, 0xeb, 0x82, 0x62, 0x9c, 0x2d,
  0x17, 0x18, 0xf5, 0xe7, 0x44, 0x40, 0xb3, 0xc2, 0x6a, 0x05, 0x19, 0x0e,
  0x17, 0x71, 0x75, 0x29, 0x51, 0x62, 0xd1, 0x25, 0x45, 0xf8, 0x23, 0x51,
  0x4f, 0x3e, 0x46, 0x4d, 0x45, 0xb8, 0x97, 0x16, 0xd0, 0x1a, 0x53, 0x20,
  0x5e, 0xf3, 0x8b, 0xa5, 0xb0, 0xc6, 0x4a, 0xd5, 0x34, 0x2e, 0x88, 0xad,
  0x74, 0x69, 0x59, 0x8f, 0x0d, 0x58, 0x3d, 0x94, 0xfb, 0x44, 0xd1, 0x50,
  0x0f, 0xc5, 0x69, 0x80, 0x9a, 0x92, 0xd2, 0x97, 0x97, 0x5a, 0xb6, 0x46,
  0x2a, 0x5e, 0x72, 0xb9, 0x75, 0x1f, 0xf5, 0xde, 0x12, 0xd0, 0x06, 0x10,
  0xe9, 0x45, 0xa3, 0x11, 0x36, 0x17, 0xb8, 0x33, 0x42, 0x2b, 0xe2, 0x96,
  0x3f, 0x44, 0xe4, 0x6d, 0x02, 0x7c, 0xd3, 0x0a, 0x34, 0x2c, 0x28, 0x0e,
  0x98, 0xb3, 0xbd, 0x9e, 0x6e, 0x3a, 0xa0, 0x35, 0xe8, 0x00, 0xb3, 0xb3,
  0x53, 0x85, 0x5f, 0x90, 0x98, 0x4d, 0xf7, 0x36, 0xcd, 0x3a, 0x80, 0x0f,
  0x6d, 0x46, 0x7c, 0xda, 0x2d, 0xa1, 0x16, 0x4e, 0x16, 0xdb, 0x37, 0xdf,
  0xcd, 0xd3, 0x7b, 0xd6, 0x53, 0x9a, 0xc2, 0xb7, 0x6b, 0x6b, 0xfd, 0xb0,
  0x3a, 0xbb, 0xcf, 0xf7, 0x06, 0xbb, 0x1f, 0x7f, 0x3a, 0x20, 0xb5, 0x73,
  0xb7, 0x13, 0x62, 0x4b, 0xb0, 0x8f, 0x0d, 0x6d, 0x08, 0x7f, 0xd8, 0x68,
  0xb9, 0x5b, 0xda, 0xe2, 0x5b, 0xc2, 0xb6, 0x67, 0xab, 0x41, 0x10, 0xa0,
  0x52, 0x69, 0x5d, 0x03, 0x58, 0xea, 0xad, 0xf6, 0x03, 0xab, 0x23, 0x33,
  0x24, 0x56, 0x87, 0xda, 0xea, 0x8e, 0x8a, 0x27, 0xb1, 0xf0, 0xf5, 0x46,
  0xdb, 0x00, 0xd4, 0x03, 0x22, 0x68, 0xaf, 0x42, 0xea, 0xfa, 0x6f, 0x70,
  0xb3, 0x9f, 0x7d, 0xa8, 0xe1, 0xa5, 0x72, 0x8c, 0x5f, 0x3d, 0x2d, 0xce,
  0x5f, 0xc7, 0x27, 0x42, 0x32, 0x12, 0x5c, 0x7d, 0xe4, 0x81, 0xf3, 0x6b,
  0xb1, 0x17, 0x3c, 0xbc, 0xa8, 0xac, 0xda, 0xaa, 0x35, 0xc7, 0x65, 0x4e,
  0x3d, 0x20, 0xaa, 0x9d, 0x45, 0xd7, 0xb2, 0x8b, 0x94, 0x87, 0x44, 0xcb,
  0x6d, 0xf6, 0x93, 0x05, 0x0c, 0xca, 0xfc, 0x62, 0x8a, 0x72, 0xb1, 0xb0,
  0x71, 0x59, 0x73, 0x78, 0xe7, 0x4f, 0x7f, 0x0a, 0xd8, 0xd0, 0xdf, 0x2a,
  0xe1, 0x6a, 0xea, 0x49, 0x17, 0xdc, 0x06, 0x0f, 0x61, 0x93, 0x19, 0x56,
  0x46, 0x98, 0xfd, 0xac, 0x2a, 0x3e, 0x67, 0xe2, 0x37, 0xd3, 0xbe, 0x02,
  0xc0, 0x0a, 0x57, 0xa8, 0x6d, 0x94, 0x08, 0x1a, 0x8a, 0xa2, 0x74, 0x69,
  0xa6, 0x01, 0x1b, 0xf5, 0x02, 0x10, 0x95, 0x66, 0x6c, 0x5e, 0x2d, 0xcc,
  0xad, 0x8a, 0x72, 0xa1, 0xb1, 0xaf, 0x09, 0x8a, 0xab, 0xb3, 0x79, 0x2c,
  0x98, 0xdc, 0x7f, 0xa7, 0x56, 0x19, 0x41, 0xe7, 0xc1, 0x3a, 0xc9, 0xdb,
  0x43, 0xe6, 0xb2, 0x08, 0x37, 0x00, 0xc3, 0x88, 0xf3, 0x51, 0x5a, 0xe6,
  0xb1, 0xc6, 0x5a, 0x68, 0x56, 0x58, 0x70, 0x8f, 0x72, 0x35, 0x49, 0xf8,
  0x4f, 0x86, 0xeb, 0x72, 0xc3, 0x88, 0xa3, 0xfc, 0x77, 0xee, 0xd5, 0x57,
  0x55, 0x66, 0xfb, 0x36, 0xf2, 0xca, 0xa2, 0x2f, 0x8e, 0x5e, 0x9f, 0x9e,
  0x1f, 0xd5, 0x6a, 0x72, 0x16, 0x08, 0x23, 0x6d, 0x0a, 0x85, 0x02, 0x19,
  0xbf, 0xc9, 0x85, 0xb7, 0xc4, 0xaa, 0x11, 0x82, 0x91, 0x9c, 0x7d, 0x7b,
  0x18, 0xf0, 0x68, 0xcb, 0xaf, 0xb3, 0x46, 0x7b, 0xcd, 0x78, 0xb6, 0x51,
  0x22, 0x47, 0x7b, 0x8b, 0xab, 0xa8, 0xc9, 0x49, 0xb3, 0x01, 0x72, 0xfa,
  0xa4, 0xf4, 0xa7, 0x95, 0x1c, 0xc5, 0x2b, 0x58, 0x14, 0x30, 0x86, 0xac,
  0x0b, 0xf1, 0x0d, 0xeb, 0x9e, 0xcd, 0x4c, 0x20, 0x05, 0x3a, 0x0a, 0x70,
  0x70, 0x06, 0x52, 0xe5, 0x4a, 0xb3, 0x7b, 0xdc, 0x4a, 0xac, 0x03, 0xc0,
  0x97, 0x6e, 0x2d, 0x67, 0x5e, 0x8b, 0xd6, 0x49, 0x52, 0xc9, 0x24, 0xb2,
  0x2c, 0xcb, 0x30, 0xab, 0xf1, 0xaf, 0x82, 0xab, 0x74, 0xa9, 0x68, 0xe0,
  0xeb, 0x52, 0x95, 0xb5, 0xe7, 0xcd, 0x62, 0xab, 0x52, 0xa5, 0xcd, 0x95,
  0x4b, 0xc6, 0xa0, 0xbb, 0x7f, 0xea, 0x46, 0x9b, 0xa5, 0x43, 0x0d, 0x6f,
  0xc9, 0xb3, 0x74, 0x78, 0x79, 0x1a, 0x49, 0x05, 0x92, 0x71, 0x95, 0x2a,
  0xd6, 0xd4, 0xa6, 0xb0, 0x39, 0xaf, 0x09, 0x26, 0x77, 0xb9, 0x5a, 0x02,
  0x40, 0xa2, 0xe9, 0x60, 0x0e, 0x54, 0xc3, 0x55, 0xcc, 0x94, 0x46, 0x7a,
  0x0f, 0xe5, 0xfb, 0x06, 0x01, 0xca, 0xce, 0x5b, 0x11, 0x8f, 0x14, 0xdf,
  0xef, 0x7b, 0x8b, 0xda, 0xe1, 0xd4, 0x80, 0x62, 0x35, 0x2f, 0x71, 0x5b,
  0x4b, 0x2c, 0xeb, 0x38, 0xcb, 0xb1, 0x9e, 0xb5, 0xe6, 0xa4, 0xd6, 0xb0,
  0x6e, 0x18, 0x6d, 0xc3, 0xf9, 0xeb, 0x83, 0xe7, 0xcf, 0x9e, 0xe3, 0xe0,
  0x71, 0x99, 0x00, 0x3a, 0x0f, 0x78, 0x42, 0xdd, 0x9f, 0x3d, 0x39, 0x0d,
  0x21, 0xa0, 0x5d, 0xe3, 0x26, 0x36, 0x4b, 0xa4, 0x6b, 0x74, 0x53, 0x68,
  0x65, 0x21, 0x3e, 0x52, 0xd6, 0x49, 0x0d, 0xf8, 0x6c, 0x0b, 0xed, 0x0f,
  0x83, 0x0e, 0x5e, 0x34, 0xc0, 0x47, 0xae, 0x72, 0xc4, 0xd3, 0x5e, 0xcf,
  0x32, 0x24, 0x58, 0x5d, 0x73, 0x25, 0xc9, 0x29, 0xfd, 0x37, 0xbb, 0x61,
  0xb4, 0x92, 0xc5, 0xdd, 0x04, 0x6e, 0x56, 0x01, 0xe5, 0xce, 0x67, 0xf8,
  0x8f, 0x3f, 0x2f, 0x56, 0x33, 0x84, 0x4d, 0xff, 0x0a, 0xd5, 0xab, 0x88,
  0xb4, 0xe8, 0x62, 0xe3, 0xfc, 0x83, 0x76, 0xf7, 0x97, 0x44, 0x2f, 0x84,
  0x90, 0x51, 0x6c, 0xb8, 0x37, 0xcc, 0x28, 0x7e, 0x31, 0xa8, 0x1d, 0x70,
  0x17, 0xa6, 0x27, 0xb6, 0x80, 0xc8, 0x19, 0x72, 0x2d, 0x6d, 0x85, 0x74,
  0xcd, 0x31, 0x2f, 0x8a, 0xf9, 0xc3, 0xf1, 0x33, 0x5e, 0xfe, 0xe6, 0xd0,
  0x56, 0x57, 0xe6, 0x51, 0x1e, 0x6f, 0x60, 0x1f, 0xc2, 0xf3, 0x2c, 0xc8,
  0xfd, 0x55, 0xe0, 0xde, 0x41, 0xc3, 0xd9, 0x92, 0x5c, 0x4d, 0x64, 0x9e,
  0xf5, 0x70, 0xf1, 0x7e, 0xbe, 0xcd, 0x0b, 0x71, 0x45, 0x4b, 0xc0, 0x3f,
  0x3e, 0xfb, 0x00, 0x30, 0x38, 0x89, 0xb1, 0x5a, 0x82, 0x9d, 0x78, 0x04,
  0x72, 0x2f, 0x34, 0xcf, 0x72, 0x13, 0x02, 0x83, 0xd4, 0xaa, 0x10, 0x88,
  0x25, 0x71, 0xe9, 0x6d, 0xd5, 0x89, 0x48, 0x70, 0xa8, 0xb9, 0xd1, 0xdd,
  0xc1, 0x6e, 0x2f, 0x20, 0x41, 0xc6, 0xcc, 0x51, 0x57, 0x0c, 0xfa, 0x1a,
  0x44, 0xe7, 0x68, 0xd9, 0x20, 0xf4, 0xf8, 0x74, 0x36, 0x8c, 0x1a, 0x8a,
  0xf4, 0x0e, 0x14, 0x69, 0x77, 0x60, 0x91, 0x33, 0xd1, 0x20, 0x8f, 0x9d,
  0xfe, 0xd3, 0xe7, 0xcf, 0x2b, 0x88, 0x98, 0xe1, 0x25, 0xf9, 0x6c, 0x67,
  0x47, 0x12, 0x49, 0xea, 0xaf, 0xd1, 0x17, 0xfd, 0xe7, 0xfc, 0x62, 0xf5,
  0x35, 0xd5, 0x8a, 0xd6, 0xbe, 0xd7, 0xc7, 0x37, 0x2d, 0xdd, 0xb1, 0xe8,
  0xb1, 0xf6, 0xad, 0xe7, 0xe8, 0xae, 0xe5, 0x2d, 0x81, 0x2e, 0xe0, 0xb5,
  0xcb, 0x2e, 0x2f, 0x51, 0xab, 0x05, 0x4f, 0x0a, 0x7a, 0x4c, 0x96, 0xdf,
  0xc5, 0xf9, 0xa4, 0x39, 0xdd, 0x9d, 0x5e, 0x7f, 0x77, 0xdd, 0x74, 0x1d,
  0xe4, 0x39, 0x6f, 0x20, 0xf8, 0xe4, 0xe6, 0x1f, 0xb7, 0x36, 0xbf, 0xda,
  0x6a, 0x9b, 0xfd, 0x27, 0x3b, 0x3b, 0xbd, 0x8f, 0xf1, 0xf3, 0xf9, 0xf3,
  0x76, 0xe1, 0xac, 0xd2, 0xc7, 0x13, 0x9b, 0x5a, 0x65, 0xb4, 0xd4, 0x4e,
  0x4b, 0xeb, 0xbb, 0xd4, 0xea, 0xee, 0xf3, 0xe7, 0x3d, 0xf4, 0xf2, 0xec,
  0x51, 0xad, 0x97, 0x77, 0x99, 0xd7, 0xec, 0x76, 0x5d, 0x57, 0x4c, 0x81,
  0x45, 0x6d, 0x0a, 0xf4, 0x67, 0x14, 0xbd, 0x92, 0x04, 0x9b, 0xc8, 0x34,
  0x6d, 0xc5, 0x29, 0x57, 0x93, 0x79, 0xb5, 0x28, 0xad, 0x94, 0x81, 0xd5,
  0xdb, 0xcf, 0x55, 0x41, 0xdd, 0xf0, 0x49, 0xc8, 0x6c, 0x3e, 0xf7, 0x80,
  0x2b, 0xec, 0xf7, 0xe3, 0xea, 0x20, 0x1e, 0xfc, 0x8e, 0x58, 0x22, 0xd1,
  0xcb, 0x16, 0xcb, 0x09, 0xb7, 0xf1, 0x34, 0x65, 0xda, 0xec, 0x72, 0x82,
  0x90, 0xd5, 0xa1, 0x2b, 0xca, 0x6c, 0xd1, 0x15, 0x1e, 0xcb, 0xe3, 0xb6,
  0xe6, 0x98, 0xa3, 0xdf, 0x47, 0xfa, 0x74, 0x9f, 0x1f, 0x53, 0x54, 0xd7,
  0x98, 0xcd, 0x23, 0xb5, 0xae, 0x22, 0x97, 0x78, 0xa3, 0x0e, 0x70, 0x6e,
  0xcd, 0xc5, 0x24, 0xf9, 0xb9, 0x75, 0x8b, 0x20, 0x4f, 0x51, 0xb9, 0x13,
  0x2a, 0x2e, 0x0a, 0xba, 0x92, 0xc0, 0x55, 0xd1, 0xa5, 0x60, 0x08, 0x1c,
  0x8c, 0x31, 0xe9, 0xd2, 0x51, 0x37, 0x2a, 0x22, 0x91, 0x14, 0xb7, 0x24,
  0x71, 0x6d, 0x99, 0xd7, 0xec, 0xc1, 0x95, 0x9a, 0x43, 0x52, 0x52, 0x12,
  0x97, 0xd7, 0x5d, 0x6c, 0xe5, 0x74, 0xd8, 0x61, 0x68, 0xc7, 0xde, 0x65,
  0xdf, 0x6b, 0xf9, 0x1a, 0x8d, 0x32, 0xf4, 0x10, 0x21, 0x06, 0x78, 0x22,
  0x31, 0x20, 0x74, 0x11, 0x30, 0x27, 0xe3, 0x78, 0x2e, 0x18, 0x2d, 0x05,
  0x76, 0x22, 0x14, 0xb8, 0x59, 0x1c, 0x89, 0x75, 0x49, 0x05, 0x3b, 0xaf,
  0xeb, 0x93, 0xb5, 0x4c, 0xde, 0xb6, 0xb2, 0xa7, 0x92, 0x10, 0xe4, 0x0a,
  0x0a, 0xb8, 0x59, 0xb0, 0x50, 0xa8, 0x79, 0xe3, 0x96, 0x65, 0x55, 0x18,
  0x9c, 0x82, 0x8b, 0xc1, 0x16, 0x8d, 0x58, 0x72, 0x12, 0x5a, 0xb7, 0xcd,
  0x91, 0x60, 0x80, 0x58, 0xc7, 0x74, 0x15, 0x08, 0x04, 0x96, 0x00, 0x9f,
  0xcd, 0x00, 0x21, 0x34, 0xd9, 0xe2, 0x18, 0x70, 0xd9, 0x05, 0x27, 0x22,
  0xab, 0x33, 0x6f, 0x23, 0xc0, 0x47, 0xe4, 0xfa, 0x2c, 0xc7, 0xff, 0xe3,
  0x68, 0x10, 0x2a, 0x3e, 0xbf, 0x96, 0xc3, 0x33, 0x8f, 0xef, 0x2c, 0x07,
  0x57, 0x7c, 0xd5, 0x44, 0x6f, 0x13, 0x0b, 0x5e, 0x8c, 0x19, 0xc1, 0x56,
  0x4b, 0x39, 0xb1, 0xb9, 0x6b, 0x42, 0x3c, 0xd0, 0xb0, 0x83, 0xac, 0x48,
  0x53, 0xb6, 0x16, 0x6b, 0x86, 0x4b, 0xe0, 0x71, 0xa5, 0x92, 0xd0, 0x1a,
  0xe1, 0xd2, 0x02, 0x66, 0x1c, 0xe7, 0x8b, 0x1b, 0x0f, 0xf4, 0xb7, 0xa4,
  0x4e, 0x18, 0xd9, 0xb7, 0x1e, 0x63, 0x47, 0x43, 0x1c, 0x3c, 0x50, 0x98,
  0xf9, 0x21, 0xd3, 0xd6, 0x63, 0x10, 0xfc, 0xcb, 0xec, 0xea, 0x6a, 0xda,
  0xe2, 0x05, 0x6d, 0x83, 0xee, 0x3f, 0xf7, 0x51, 0x06, 0x68, 0x6d, 0x7d,
  0xad, 0x3e, 0xcf, 0x76, 0x58, 0x88, 0x76, 0xa2, 0x71, 0x85, 0x80, 0xf9,
  0x50, 0x49, 0x58, 0x42, 0x9b, 0xf0, 0xc5, 0xe3, 0x2d, 0xe3, 0xd9, 0x22,
  0x6a, 0x09, 0x2e, 0x10, 0xac, 0x24, 0xcb, 0x02, 0x42, 0xd4, 0x9a, 0xc1,
  0x86, 0x4a, 0x8f, 0xcd, 0xe6, 0x82, 0x80, 0x07, 0x39, 0x13, 0xf4, 0x1e,
  0x2b, 0xe8, 0xae, 0x9f, 0x7f, 0xc9, 0x86, 0x2f, 0x50, 0xf1, 0x8e, 0x74,
  0xda, 0x4a, 0x4d, 0xb0, 0x29, 0xb1, 0x42, 0x7c, 0x09, 0xb0, 0xe1, 0x18,
  0xa3, 0xa2, 0x65, 0x37, 0x63, 0xa5, 0xa4, 0x94, 0x53, 0xe4, 0x93, 0x3c,
  0x17, 0xd4, 0x57, 0x91, 0xba, 0x13, 0xf5, 0xa7, 0x56, 0xe1, 0x0c, 0xad,
  0x22, 0x42, 0xbc, 0x86, 0x22, 0x7d, 0x12, 0xb8, 0x74, 0xcd, 0xb3, 0xf3,
  0x52, 0x84, 0x04, 0x37, 0xa8, 0x62, 0x62, 0x15, 0xcb, 0xa2, 0xe5, 0x62,
  0xd0, 0xc4, 0xce, 0x28, 0x3d, 0x8e, 0x8f, 0xbe, 0x4f, 0xdd, 0xef, 0x28,
  0x6d, 0xf3, 0xa0, 0x98, 0xcf, 0x71, 0x3f, 0x18, 0x9c, 0x62, 0x16, 0x0a,
  0x3c, 0x50, 0x3b, 0x5c, 0x24, 0x94, 0x3b, 0x37, 0x5f, 0x99, 0xae, 0x00,
  0x00, 0x25, 0x29, 0xc2, 0x4c, 0x5f, 0x00, 0x83, 0x58, 0x32, 0x00, 0x7b,
  0x1e, 0x04, 0x25, 0x7a, 0x76, 0x7f, 0xdf, 0xc4, 0xce, 0xf0, 0xa8, 0x0d,
  0x02, 0xb9, 0x2b, 0x87, 0x97, 0x1e, 0xad, 0x7e, 0xf9, 0x50, 0x32, 0x3e,
  0xd3, 0xd4, 0x28, 0x93, 0x70, 0x19, 0x59, 0xad, 0xb8, 0x65, 0x1d, 0x45,
  0xb8, 0x40, 0xa1, 0xf5, 0xa8, 0x19, 0x62, 0xa8, 0xb4, 0xe1, 0xc0, 0x21,
  0xd9, 0xb0, 0x37, 0xe5, 0x14, 0xcb, 0xf2, 0x9a, 0x58, 0x9b, 0x24, 0xdf,
  0xcb, 0x02, 0x59, 0x83, 0x86, 0xd4, 0xd9, 0xb2, 0x4e, 0xe8, 0x45, 0x96,
  0x3d, 0xe5, 0x2c, 0xf7, 0x32, 0x45, 0x61, 0xcf, 0x88, 0x33, 0xb0, 0xa9,
  0x85, 0x5d, 0x5a, 0xfe, 0x74, 0xbe, 0x54, 0xc4, 0xa7, 0x3a, 0xc8, 0x72,
  0xdb, 0xb2, 0x4f, 0x39, 0x53, 0x46, 0xea, 0x0f, 0xd4, 0x11, 0x6c, 0x75,
  0x5c, 0x12, 0x9a, 0xac, 0x96, 0x1a, 0x23, 0xd9, 0x3e, 0xbf, 0xda, 0xac,
  0x85, 0x17, 0x45, 0xa1, 0x23, 0x9c, 0x6b, 0xa3, 0xdf, 0xd3, 0x6a, 0x0b,
  0x62, 0x44, 0xc4, 0x78, 0xbd, 0xa8, 0x9f, 0x4a, 0x6b, 0x70, 0x95, 0xe5,
  0xb4, 0xa9, 0x33, 0x95, 0xda, 0xf9, 0xf6, 0xac, 0x4b, 0x93, 0xda, 0x95,
  0xcb, 0x8a, 0x05, 0x84, 0x9e, 0xc3, 0x64, 0x28, 0xb3, 0x52, 0x39, 0x9a,
  0x26, 0xbb, 0x39, 0xf5, 0xd6, 0xc6, 0xfd, 0x50, 0xa0, 0xc3, 0xde, 0xe0,
  0xc9, 0xd6, 0xcf, 0x71, 0x0d, 0x78, 0xd0, 0xbe, 0xf5, 0xb5, 0x03, 0x1a,
  0x8b, 0x8b, 0x2a, 0xb5, 0x95, 0xe2, 0x01, 0xb5, 0x73, 0x2f, 0x8b, 0xf8,
  0x40, 0xb2, 0xaf, 0x99, 0x13, 0x8b, 0x69, 0x92, 0x2c, 0x64, 0x6c, 0x0a,
  0x45, 0xa1, 0x47, 0xd5, 0xed, 0x1d, 0xb3, 0x74, 0x25, 0x52, 0x15, 0x17,
  0xd6, 0x71, 0x00, 0xb5, 0x4e, 0x40, 0x65, 0xb7, 0x12, 0xa9, 0xed, 0x9c,
  0x66, 0x53, 0x04, 0x2f, 0xd6, 0x46, 0xd6, 0x1e, 0x59, 0xb7, 0xa5, 0x3c,
  0x1c, 0xb7, 0xad, 0x6e, 0x60, 0xba, 0x19, 0xb5, 0xc2, 0x0f, 0x4d, 0x5c,
  0x34, 0x91, 0x36, 0xf8, 0xaa, 0x4d, 0x04, 0x0a, 0x8a, 0x0b, 0x40, 0xc8,
  0x8c, 0xb8, 0x64, 0xa4, 0xe6, 0x72, 0x0d, 0x1c, 0xef, 0x11, 0xb8, 0x3f,
  0x5e, 0xc2, 0x86, 0xb9, 0xe8, 0xef, 0x49, 0x9e, 0x05, 0xb7, 0x0f, 0xaf,
  0xa2, 0x09, 0xbf, 0x0e, 0x9b, 0xd6, 0x51, 0x23, 0xc6, 0x3e, 0xf0, 0x24,
  0xd2, 0x04, 0x11, 0xfb, 0xdf, 0x86, 0x62, 0x3e, 0x98, 0x21, 0x7e, 0xa1,
  0x07, 0x57, 0xe2, 0xd4, 0xf4, 0xba, 0xe0, 0x3a, 0x97, 0xc6, 0xd4, 0x15,
  0xb2, 0x91, 0xd1, 0x6d, 0x3d, 0x4d, 0xe8, 0xb5, 0x5c, 0x3f, 0x34, 0xe7,
  0xca, 0x9b, 0x8c, 0x87, 0x70, 0xe6, 0x41, 0x8c, 0x5b, 0x10, 0xd8, 0xeb,
  0x9b, 0x88, 0xf2, 0xd5, 0xa1, 0x6d, 0xe1, 0x63, 0x4e, 0xb3, 0x53, 0x43,
  0x2c, 0xf7, 0x5f, 0x37, 0xbf, 0x4b, 0x9a, 0xae, 0xf0, 0xab, 0x49, 0x4b,
  0x1e, 0xfd, 0xdb, 0xac, 0x4c, 0xc7, 0xbe, 0x0a, 0xaa, 0x6b, 0x47, 0xdf,
  0x6c, 0xf0, 0x79, 0x69, 0x47, 0x23, 0x27, 0xd1, 0x44, 0xaf, 0x02, 0x96,
  0x62, 0xc3, 0x66, 0xbf, 0x25, 0x5b, 0xcc, 0xd8, 0x03, 0xa3, 0x97, 0x64,
  0x4b, 0xb0, 0x00, 0xb3, 0x75, 0x58, 0xc5, 0xd8, 0xa6, 0x88, 0xe9, 0xb4,
  0xe4, 0xfc, 0xf3, 0x06, 0x50, 0x1b, 0x69, 0x36, 0x61, 0x6b, 0xa4, 0x30,
  0xa5, 0x66, 0xdc, 0x17, 0xb5, 0x37, 0x4d, 0x5c, 0x2c, 0x52, 0xb7, 0x08,
  0x31, 0x11, 0x53, 0x18, 0x78, 0xc4, 0x62, 0x5e, 0x49, 0xfd, 0x1f, 0x08,
  0x2e, 0xd5, 0xfa, 0x32, 0x55, 0xc4, 0x04, 0x99, 0xb8, 0x4b, 0x51, 0x22,
  0x2c, 0x23, 0xde, 0x31, 0xeb, 0xc7, 0xb0, 0xb9, 0x9a, 0x48, 0xb3, 0x8e,
  0x62, 0x75, 0x59, 0x63, 0x86, 0x2e, 0xfa, 0x25, 0x44, 0x5b, 0x00, 0x0f,
  0x0f, 0x78, 0xe3, 0xf5, 0x8d, 0x1b, 0xf2, 0x87, 0xa8, 0x3d, 0x46, 0x13,
  0x3e, 0x64, 0x88, 0x1f, 0x20, 0x14, 0x09, 0x8e, 0x26, 0xfc, 0x24, 0x6a,
  0xbb, 0xcf, 0x9d, 0x14, 0x20, 0xe9, 0x42, 0x03, 0xcd, 0x9d, 0xaf, 0xa3,
  0x30, 0x33, 0x34, 0xe0, 0xb2, 0x4c, 0x7e, 0xeb, 0x18, 0x8c, 0x22, 0x18,
  0xb7, 0x9f, 0xe6, 0x10, 0xd3, 0xa4, 0xe1, 0xf7, 0x79, 0xb0, 0xad, 0x02,
  0x85, 0x4f, 0xa8, 0xef, 0x0b, 0x34, 0x63, 0x80, 0x00, 0x80, 0x89, 0x57,
  0xa6, 0x09, 0xca, 0xa7, 0x67, 0xc0, 0xa1, 0x8b, 0xc1, 0xaf, 0x18, 0x9a,
  0x86, 0x9e, 0xea, 0xe6, 0x34, 0xf4, 0x1b, 0xb2, 0x19, 0x94, 0xfa, 0x29,
  0x9e, 0x46, 0x2f, 0x39, 0x86, 0xfa, 0x05, 0x54, 0xbf, 0x9f, 0x3e, 0x6b,
  0x94, 0x54, 0x4e, 0x0c, 0x4e, 0x50, 0x3d, 0x9d, 0xc3, 0xd3, 0x83, 0xaf,
  0x87, 0x4f, 0x2d, 0xf0, 0xc3, 0x4a, 0x10, 0x78, 0xc4, 0x33, 0xcb, 0x02,
  0x5d, 0x5b, 0x78, 0x81, 0x8f, 0x9d, 0xaf, 0xd2, 0x12, 0x19, 0x60, 0xda,
  0xee, 0xce, 0xa7, 0x3b, 0x0f, 0x41, 0x8c, 0xb5, 0x58, 0x41, 0x81, 0xee,
  0x98, 0xa7, 0x93, 0x44, 0x2b, 0xcc, 0xe7, 0x09, 0x02, 0x42, 0x5d, 0xf6,
  0x55, 0xe4, 0xa3, 0x34, 0x7a, 0x12, 0xc3, 0x0b, 0x7c, 0xbb, 0xba, 0x94,
  0x4e, 0x6c, 0x92, 0xa8, 0x49, 0x72, 0x29, 0x93, 0xfb, 0xf1, 0x94, 0x64,
  0x9f, 0xdb, 0xdf, 0xb4, 0xd6, 0x8e, 0xac, 0x7a, 0xfc, 0x8b, 0x96, 0x3d,
  0x7e, 0xdc, 0xba, 0xb7, 0x1a, 0x11, 0x7f, 0xc6, 0xba, 0xb7, 0xd5, 0x59,
  0xaa, 0xa2, 0x13, 0xfa, 0x95, 0x6f, 0x5d, 0xfa, 0x70, 0xe5, 0xe5, 0x8a,
  0xf8, 0xdf, 0x64, 0xdd, 0x9f, 0x71, 0xc9, 0x5c, 0xb6, 0x6f, 0x7f, 0x68,
  0xfd, 0x95, 0x61, 0xf8, 0x02, 0xf3, 0xbc, 0x05, 0xcf, 0x34, 0x0c, 0x64,
  0x93, 0x2d, 0x8c, 0x49, 0x18, 0xdc, 0x02, 0x14, 0xbf, 0xe9, 0x6d, 0x9b,
  0xec, 0xed, 0x3c, 0xd1, 0x5b, 0x1f, 0x3c, 0x31, 0x6e, 0xa7, 0xc4, 0x73,
  0x2c, 0x7b, 0x55, 0x5f, 0xbb, 0xff, 0x27, 0x76, 0xae, 0x26, 0xd1, 0x57,
  0x67, 0x81, 0xac, 0x25, 0x37, 0x76, 0x4e, 0xb3, 0xcd, 0xe9, 0xfe, 0x9e,
  0xae, 0x6a, 0xf9, 0x5b, 0xea, 0xc0, 0x6d, 0xa6, 0x98, 0x2a, 0x39, 0x54,
  0x8a, 0x27, 0xe8, 0x6e, 0x38, 0xd4, 0xde, 0xad, 0x06, 0xf1, 0xfc, 0x92,
  0x33, 0x6b, 0x04, 0x83, 0xc0, 0x01, 0xe0, 0x15, 0x38, 0x32, 0x09, 0x6b,
  0x1b, 0xb7, 0x44, 0x29, 0xb0, 0x01, 0x03, 0xe9, 0xe5, 0x2a, 0x79, 0x3e,
  0x82, 0x64, 0x2a, 0x87, 0xbb, 0x25, 0x7b, 0x4b, 0x08, 0xe6, 0xff, 0x12,
  0x86, 0xda, 0x46, 0x1e, 0x16, 0x84, 0xf7, 0x68, 0xe2, 0x50, 0x69, 0xe8,
  0x5f, 0x27, 0x8f, 0x72, 0x42, 0x0b, 0xd7, 0xee, 0x63, 0x3b, 0x37, 0xdc,
  0x35, 0x36, 0x06, 0x70, 0xd1, 0x17, 0xb6, 0xde, 0xe8, 0x3b, 0xea, 0xb4,
  0xf7, 0x54, 0xa3, 0xa8, 0x40, 0x9a, 0x53, 0xb8, 0x1e, 0xde, 0x8b, 0x99,
  0x98, 0x24, 0x70, 0x32, 0x46, 0x4e, 0xb7, 0xdf, 0x35, 0x2a, 0x30, 0xdb,
  0xa3, 0xab, 0xaa, 0xc4, 0xde, 0x36, 0x49, 0x64, 0x7b, 0x90, 0x39, 0x28,
  0x82, 0xd6, 0x22, 0x23, 0xe5, 0x4c, 0x54, 0x4b, 0xad, 0x79, 0xef, 0x8a,
  0x0f, 0x5f, 0x27, 0x98, 0x04, 0x84, 0x9b, 0x09, 0x57, 0xfe, 0x5b, 0x03,
  0x92, 0xc8, 0x4e, 0xd4, 0x78, 0x11, 0x8f, 0xd2, 0x69, 0x5a, 0xfe, 0x8c,
  0xb0, 0xee, 0x5f, 0xc2, 0xd8, 0xcb, 0xf1, 0xa2, 0x3f, 0xcf, 0xda, 0x8c,
  0x14, 0x17, 0x40, 0x28, 0x0b, 0xd2, 0xce, 0xdf, 0xbf, 0x3d, 0x3d, 0x3c,
  0x3a, 0xd9, 0xff, 0xde, 0x9c, 0x84, 0x2e, 0xae, 0x83, 0xa1, 0xd9, 0x93,
  0xb8, 0x58, 0xbd, 0x27, 0xf5, 0x89, 0xbe, 0xdc, 0x7c, 0xb2, 0x05, 0x7b,
  0x7e, 0xfd, 0x0c, 0x41, 0x5e, 0x0b, 0xf1, 0x8c, 0xd4, 0x62, 0xe4, 0xe7,
  0x51, 0xe3, 0xc6, 0xbb, 0x8f, 0xcf, 0x37, 0xa8, 0x4d, 0x5c, 0x95, 0xfc,
  0xb0, 0x58, 0xe1, 0xcf, 0xb1, 0xdc, 0x96, 0x74, 0x4e, 0xcb, 0x64, 0x3a,
  0x4f, 0x4a, 0xc5, 0xb5, 0x89, 0x5e, 0x9e, 0x9e, 0x5d, 0xbc, 0xba, 0x8d,
  0x1b, 0xe5, 0xea, 0x38, 0xf9, 0x48, 0x6b, 0x3d, 0x1a, 0x2d, 0xca, 0x9b,
  0x2e, 0x4e, 0x15, 0x89, 0xad, 0x16, 0x54, 0x60, 0x4f, 0xd2, 0x29, 0x6f,
  0x84, 0x98, 0x5d, 0x5c, 0x7c, 0x7f, 0x76, 0xf4, 0xea, 0x25, 0xbc, 0x2e,
  0x9f, 0x41, 0xb1, 0x51, 0xd5, 0x50, 0x9c, 0x30, 0x53, 0xa9, 0x16, 0x58,
  0x7f, 0xe7, 0xbb, 0xc3, 0xe3, 0xe1, 0xd9, 0xc9, 0xe9, 0xc1, 0xab, 0x97,
  0xdf, 0x59, 0x2d, 0xe3, 0xe0, 0x5d, 0xf7, 0x99, 0x03, 0xd9, 0x6b, 0xa2,
  0xcb, 0x1d, 0x7d, 0xfb, 0xfe, 0xe8, 0xed, 0x37, 0xaf, 0x5e, 0xde, 0xc6,
  0x79, 0x0f, 0xf3, 0x93, 0xb7, 0xb9, 0x14, 0x76, 0x13, 0xc1, 0x29, 0x58,
  0xa2, 0x0b, 0x60, 0x80, 0x2c, 0xe0, 0xff, 0x78, 0xc0, 0x3f, 0x2e, 0xa7,
  0xc3, 0x27, 0xe4, 0xd7, 0x65, 0x82, 0xc0, 0xca, 0x5c, 0x0d, 0xbe, 0x79,
  0x77, 0x7e, 0xd2, 0x7e, 0x76, 0x5d, 0x25, 0x13, 0x9f, 0x4b, 0x67, 0x55,
  0x49, 0x5c, 0xab, 0x9c, 0xb7, 0xe6, 0x71, 0xb1, 0x84, 0xe3, 0x3c, 0x6c,
  0xe3, 0x96, 0x90, 0x52, 0xf6, 0x04, 0x3a, 0x7c, 0x38, 0x8e, 0xa5, 0x10,
  0x70, 0x0c, 0x9a, 0x81, 0x14, 0xa2, 0xd9, 0xb6, 0xd3, 0x80, 0x53, 0xd5,
  0xac, 0x20, 0xa3, 0xb0, 0x63, 0x52, 0x41, 0x0e, 0x0c, 0x1c, 0x51, 0xa9,
  0x3c, 0x37, 0x1e, 0x8e, 0x45, 0xf3, 0x56, 0x27, 0x21, 0x89, 0x7a, 0x0d,
  0x65, 0xc8, 0xe3, 0x88, 0x21, 0x01, 0xef, 0xc6, 0x8d, 0x2b, 0x97, 0x13,
  0xed, 0x7b, 0x33, 0x46, 0x56, 0xb3, 0xf9, 0xd7, 0x63, 0x80, 0x35, 0x26,
  0x41, 0x2b, 0x08, 0x58, 0x20, 0xc2, 0x0c, 0xf7, 0x27, 0xc2, 0x9c, 0x11,
  0x24, 0xe2, 0x7c, 0x9e, 0xb2, 0xb1, 0x41, 0xb8, 0x49, 0x6b, 0xfd, 0xdc,
  0x81, 0x3f, 0x8d, 0x76, 0x0c, 0xb9, 0xdc, 0x36, 0xd2, 0x4c, 0x37, 0x8b,
  0x2d, 0xf5, 0xe1, 0x09, 0x17, 0x3a, 0x7b, 0x77, 0x11, 0x84, 0xe2, 0x34,
  0x0b, 0x41, 0xaf, 0xa9, 0x78, 0x68, 0x42, 0x81, 0x5f, 0xa8, 0x4e, 0xbf,
  0x43, 0xc2, 0xa3, 0x19, 0x0c, 0x10, 0x83, 0xb4, 0x65, 0x91, 0x92, 0x5c,
  0x61, 0x2b, 0x8c, 0xec, 0x6e, 0x98, 0x19, 0x7c, 0x75, 0xeb, 0xd6, 0x54,
  0x46, 0xc4, 0x11, 0x58, 0x88, 0x0f, 0x38, 0x66, 0xff, 0x42, 0xc2, 0xf1,
  0xc1, 0x4b, 0xb4, 0xfc, 0x55, 0x3d, 0x3e, 0x6e, 0x10, 0x1d, 0xe1, 0xdb,
  0xfe, 0x45, 0x03, 0x58, 0x14, 0x2f, 0x2c, 0xe2, 0x34, 0x0f, 0xbc, 0xd3,
  0x77, 0x5a, 0xe7, 0x4b, 0x97, 0x57, 0x63, 0xce, 0xb8, 0xc0, 0xca, 0x40,
  0xcb, 0x0d, 0xc2, 0x74, 0xb7, 0x26, 0x79, 0xbc, 0x88, 0x3a, 0x57, 0xd3,
  0x6c, 0x34, 0xa2, 0x99, 0x77, 0xcc, 0xee, 0x4c, 0x23, 0xb4, 0x80, 0x9a,
  0x9e, 0x65, 0xb5, 0x79, 0x0a, 0xe6, 0x3c, 0x69, 0xee, 0xab, 0x9e, 0xf3,
  0x6d, 0xe6, 0x0b, 0x05, 0x81, 0x44, 0x8a, 0xab, 0xae, 0x28, 0x27, 0x31,
  0x87, 0xb0, 0xbc, 0xe2, 0xf6, 0xe1, 0xcf, 0x23, 0xeb, 0xbf, 0xae, 0xea,
  0x97, 0x2b, 0xa8, 0xcc, 0x8e, 0xcb, 0xe9, 0x89, 0xe4, 0x73, 0xa8, 0x89,
  0xb2, 0x2d, 0x85, 0xbf, 0xa4, 0xe4, 0xfd, 0x45, 0xd4, 0xf9, 0x07, 0x46,
  0xb1, 0xdb, 0xc3, 0xbf, 0x7b, 0xff, 0xec, 0x84, 0x25, 0xef, 0x65, 0xf0,
  0x25, 0x52, 0x50, 0x0b, 0x4b, 0x8d, 0x6e, 0xc9, 0x84, 0x06, 0xfc, 0xe2,
  0xda, 0xd6, 0xd3, 0xd9, 0xd5, 0x0f, 0xbb, 0xfd, 0xdd, 0x9d, 0x9d, 0x9d,
  0x9f, 0x06, 0x0b, 0x2c, 0xdd, 0x25, 0x37, 0x8f, 0x18, 0xe9, 0x45, 0x3a,
  0x86, 0x13, 0x99, 0x36, 0x33, 0x8d, 0xb9, 0xb8, 0x8d, 0xf4, 0xb7, 0x1d,
  0x5e, 0x8e, 0x39, 0x42, 0xe5, 0x5a, 0x99, 0x9b, 0x43, 0xa5, 0x00, 0x30,
  0xd2, 0x92, 0x6b, 0x13, 0xf0, 0xc3, 0xd1, 0x64, 0x39, 0x5b, 0x30, 0xdc,
  0x28, 0x3b, 0x44, 0xd5, 0x73, 0x81, 0xcd, 0xa6, 0xdb, 0x4e, 0x90, 0x1c,
  0x11, 0xcc, 0xd3, 0x6b, 0x05, 0x88, 0xe7, 0x6f, 0x93, 0x02, 0x75, 0x0c,
  0xb8, 0x44, 0x71, 0x80, 0xa3, 0xd5, 0x33, 0x1e, 0x29, 0x54, 0xac, 0xe9,
  0xc9, 0x4c, 0xcc, 0x2d, 0xd5, 0x38, 0x71, 0x4e, 0x48, 0x1a, 0x09, 0x4b,
  0xd8, 0x39, 0xa8, 0x1e, 0x43, 0xf6, 0x49, 0x24, 0xca, 0xd8, 0x24, 0x9b,
  0x87, 0x44, 0x1b, 0x2f, 0xd9, 0x86, 0x52, 0x2d, 0x03, 0xfe, 0xf7, 0x6f,
  0x05, 0xce, 0x60, 0x84, 0x72, 0x2f, 0x59, 0x6e, 0x8b, 0x56, 0x27, 0xe1,
  0xb8, 0x18, 0xa7, 0xe9, 0x6f, 0x2a, 0xc7, 0x70, 0xaf, 0xdc, 0xcd, 0xff,
  0xc3, 0x1b, 0x06, 0x68, 0x5a, 0x85, 0x44, 0xf4, 0x90, 0x7b, 0x3c, 0x4f,
  0x81, 0xdc, 0x9b, 0x26, 0xd4, 0x68, 0x11, 0x99, 0x54, 0x7e, 0x9d, 0xdc,
  0xcb, 0x2d, 0xda, 0x4c, 0x42, 0x11, 0x34, 0xf3, 0x6b, 0x24, 0x59, 0x70,
  0x09, 0xb3, 0xe1, 0xc1, 0xf1, 0x71, 0x25, 0x7b, 0x1d, 0xcb, 0x26, 0x95,
  0x47, 0x24, 0xb7, 0xa0, 0x98, 0xa1, 0x70, 0x7b, 0x6e, 0x99, 0xf3, 0x8d,
  0xcb, 0x1b, 0x41, 0x1e, 0x9c, 0x90, 0x8a, 0x00, 0xd5, 0xb8, 0x48, 0x2d,
  0xaa, 0x26, 0x16, 0x98, 0xcd, 0xe5, 0x1c, 0xd7, 0x2c, 0x57, 0xf3, 0x5a,
  0xd2, 0x91, 0x2c, 0x7e, 0x6d, 0x82, 0x1c, 0xfc, 0xd6, 0xa4, 0xd7, 0xe2,
  0xe4, 0x3f, 0xcb, 0x35, 0x60, 0x83, 0xbd, 0x46, 0xec, 0x80, 0x13, 0x27,
  0x3d, 0xe0, 0x4b, 0x70, 0x71, 0x08, 0x05, 0xd2, 0x20, 0x6d, 0xbc, 0x5c,
  0xd2, 0xc9, 0x15, 0x71, 0x69, 0x88, 0x18, 0x2c, 0xce, 0xc1, 0xb6, 0x5b,
  0x11, 0x94, 0x9f, 0x3e, 0x1e, 0xb4, 0xe7, 0x03, 0xf1, 0x0d, 0x5a, 0x64,
  0x25, 0x6b, 0x00, 0xd6, 0xe2, 0x6e, 0x60, 0xb7, 0x6d, 0x4d, 0x54, 0x36,
  0x2c, 0xb8, 0xe8, 0x25, 0xfe, 0x7d, 0x61, 0x58, 0x6c, 0x6b, 0x41, 0x9a,
  0x15, 0x0b, 0xb5, 0x8a, 0xdb, 0x66, 0x11, 0xf1, 0x0c, 0x53, 0x20, 0xf1,
  0x56, 0xf5, 0xbc, 0xd2, 0x6a, 0x73, 0xa7, 0x6e, 0xf7, 0x3d, 0x70, 0x2c,
  0x37, 0x5a, 0x87, 0xa3, 0x6c, 0x63, 0x38, 0xb8, 0x1a, 0x39, 0xa8, 0x18,
  0xe7, 0xd2, 0x43, 0xca, 0xf1, 0xa9, 0xdb, 0x34, 0x95, 0x95, 0x0b, 0x47,
  0x8b, 0xd2, 0x26, 0x05, 0x6a, 0xb7, 0xa2, 0xb6, 0x1d, 0xe1, 0xf5, 0x22,
  0x29, 0x0f, 0x61, 0x1a, 0xec, 0xb0, 0xf6, 0x90, 0xb2, 0x6b, 0xf1, 0x6b,
  0x58, 0xa6, 0x04, 0xea, 0xd3, 0xd9, 0x71, 0x5f, 0xe3, 0x97, 0x14, 0xe6,
  0x47, 0x4a, 0x90, 0x61, 0x1e, 0x93, 0xac, 0x9e, 0x5f, 0xd8, 0x06, 0xa1,
  0xe3, 0xe1, 0x50, 0xb8, 0xdc, 0x4b, 0x35, 0xc5, 0x7c, 0xb9, 0xa8, 0xcd,
  0xad, 0xba, 0xea, 0x6d, 0x71, 0x97, 0x9a, 0x3c, 0x15, 0x8a, 0xfe, 0xae,
  0x34, 0xa8, 0x49, 0x46, 0xaa, 0xc8, 0x8a, 0xb4, 0xc0, 0x2b, 0xd3, 0x96,
  0x82, 0x14, 0x90, 0xde, 0x0b, 0x62, 0x6d, 0xcb, 0xe8, 0x45, 0xe7, 0x37,
  0xe4, 0xfd, 0xef, 0xcc, 0xae, 0xf2, 0x73, 0x48, 0x91, 0x1f, 0xad, 0x60,
  0xb4, 0x06, 0x60, 0x19, 0x6d, 0x30, 0x42, 0xff, 0xff, 0x8e, 0x06, 0x3b,
  0xfa, 0xee, 0xb7, 0xdd, 0x51, 0x2e, 0x53, 0xfb, 0x92, 0x24, 0xc8, 0xb5,
  0x8c, 0x24, 0x56, 0x99, 0xd4, 0xe1, 0x05, 0x35, 0x51, 0x1e, 0x48, 0xb7,
  0xa1, 0x59, 0x5e, 0xd3, 0x22, 0xad, 0x9c, 0x35, 0x66, 0xa3, 0x3d, 0xd3,
  0xca, 0xc4, 0x7e, 0x6a, 0x12, 0xaa, 0x0b, 0x07, 0x0c, 0x07, 0x89, 0x27,
  0x0f, 0x5a, 0xfd, 0x14, 0x42, 0x55, 0x2c, 0xa5, 0x95, 0xcc, 0x00, 0x89,
  0x28, 0x97, 0xfc, 0x08, 0x4b, 0x4d, 0x12, 0x79, 0xbf, 0x6d, 0x71, 0xb9,
  0xd2, 0x6f, 0x61, 0x56, 0xa7, 0x9e, 0x73, 0xc2, 0x87, 0x28, 0x4c, 0x9a,
  0xe7, 0xf4, 0x01, 0x04, 0x1b, 0x35, 0x33, 0x04, 0xeb, 0x19, 0x5c, 0x89,
  0xad, 0x00, 0xdb, 0xac, 0x64, 0x61, 0x15, 0x41, 0x0c, 0x02, 0xe1, 0xaa,
  0x8f, 0x6f, 0x97, 0xf1, 0xf4, 0x26, 0x86, 0x6c, 0x03, 0x8f, 0xa2, 0x2c,
  0x29, 0xb0, 0x79, 0x39, 0x6e, 0xa5, 0x2d, 0x89, 0x67, 0xb4, 0xbc, 0xba,
  0x12, 0x98, 0xbe, 0x13, 0x4e, 0x23, 0x10, 0xf8, 0x7b, 0x4b, 0x55, 0x8c,
  0xba, 0x9f, 0x75, 0x35, 0x52, 0xa9, 0x23, 0x25, 0x59, 0x58, 0xb8, 0xea,
  0x88, 0x70, 0x33, 0x5a, 0xb5, 0x88, 0xf1, 0xbd, 0xa8, 0xfb, 0xb2, 0xfd,
  0x1d, 0x54, 0x01, 0x4b, 0x6f, 0x15, 0x59, 0xcd, 0x69, 0xd8, 0xb4, 0x86,
  0xd7, 0x29, 0xdd, 0x8e, 0xf3, 0x66, 0x70, 0x82, 0xd5, 0x9f, 0x92, 0xaa,
  0x84, 0x91, 0x69, 0x71, 0x45, 0x7d, 0x8c, 0x7f, 0xb4, 0xfe, 0xe2, 0xc9,
  0x24, 0x55, 0xc8, 0x61, 0x48, 0x76, 0xcd, 0x94, 0x56, 0x24, 0x9d, 0xba,
  0xfe, 0xdb, 0xcb, 0x3b, 0xcb, 0xa8, 0xe0, 0xa9, 0x14, 0x6e, 0x21, 0xf1,
  0x1b, 0x4c, 0x79, 0x12, 0x6a, 0xe5, 0x6a, 0xd3, 0xf8, 0x82, 0xd5, 0xb2,
  0xdd, 0x75, 0x91, 0xb3, 0x52, 0xec, 0xc6, 0xc9, 0x52, 0x4a, 0x86, 0x6a,
  0x6a, 0x04, 0xb0, 0xb4, 0xa2, 0x52, 0xad, 0x65, 0x58, 0x66, 0x51, 0xf0,
  0x34, 0x5c, 0x94, 0x52, 0xec, 0x44, 0x0a, 0x6f, 0xf1, 0xc5, 0x88, 0x07,
  0x15, 0x79, 0x55, 0x0d, 0x76, 0xcd, 0xc2, 0xed, 0x73, 0x4e, 0x59, 0x70,
  0xa9, 0x69, 0x4e, 0x9a, 0xa9, 0x4a, 0xe3, 0x66, 0x8d, 0x7d, 0x9c, 0xe9,
  0xbc, 0x29, 0xcf, 0x55, 0x1a, 0x7b, 0x50, 0xa0, 0xfb, 0x39, 0x0e, 0x5f,
  0x09, 0x2d, 0x16, 0x70, 0x23, 0xc0, 0xa2, 0x04, 0xa7, 0x25, 0x00, 0x68,
  0x6b, 0x42, 0x75, 0xb2, 0x04, 0x56, 0x01, 0x38, 0x16, 0x3b, 0xa6, 0x28,
  0xf0, 0x8a, 0x60, 0x6e, 0x31, 0x9c, 0x86, 0x8b, 0xa3, 0xe5, 0xf3, 0x06,
  0x6d, 0xb8, 0x4d, 0x1a, 0x60, 0xc2, 0x92, 0x9f, 0xd5, 0x09, 0xd3, 0x13,
  0x09, 0x2d, 0xc5, 0x9a, 0x40, 0x10, 0x2d, 0x9f, 0x06, 0x6b, 0xbb, 0x45,
  0x64, 0x97, 0x22, 0x31, 0xf9, 0x84, 0xe5, 0xf4, 0x95, 0x82, 0xd4, 0xa5,
  0x0c, 0x0b, 0x36, 0xbf, 0x31, 0xb7, 0x7a, 0xb5, 0x6c, 0x6f, 0x6b, 0x8d,
  0x42, 0x5d, 0x27, 0x1e, 0xd2, 0x26, 0x9f, 0x0d, 0x85, 0x19, 0xe9, 0x9c,
  0x59, 0xf6, 0xfd, 0x8b, 0xce, 0x96, 0x6a, 0x07, 0xac, 0x37, 0xf9, 0xb4,
  0xfc, 0x36, 0xb9, 0xdf, 0x86, 0xec, 0x0a, 0x56, 0x65, 0x66, 0x2e, 0x68,
  0xed, 0x9e, 0x76, 0x25, 0x6f, 0xed, 0xfd, 0xb5, 0x84, 0x7d, 0x07, 0x9d,
  0xab, 0x75, 0x65, 0x6c, 0x11, 0xe1, 0xf5, 0xee, 0x5b, 0x7a, 0xce, 0x2e,
  0xb9, 0x64, 0xe2, 0xbe, 0x8b, 0x81, 0xb5, 0x57, 0x6d, 0xf1, 0x5f, 0x34,
  0xf3, 0x6c, 0x6f, 0x3f, 0x0e, 0x6c, 0x44, 0x60, 0xcc, 0xfc, 0x91, 0x2e,
  0x67, 0xda, 0xd4, 0x55, 0x6e, 0xf2, 0xd1, 0x53, 0xfa, 0xf1, 0x35, 0x7e,
  0x58, 0x0d, 0x01, 0x64, 0x9d, 0x9b, 0x8d, 0xa4, 0x09, 0x7e, 0x06, 0xd8,
  0x40, 0xe1, 0x07, 0x43, 0xa6, 0xa2, 0xd7, 0xfc, 0x4b, 0x9e, 0x3c, 0xf0,
  0x0e, 0xcd, 0xed, 0xef, 0xf4, 0x63, 0x7f, 0x59, 0x66, 0xa0, 0xc4, 0x31,
  0x07, 0x5c, 0xcf, 0x16, 0xb9, 0x82, 0x6a, 0x4a, 0x6a, 0x1a, 0xff, 0xa9,
  0x7e, 0x91, 0x42, 0x0a, 0x3a, 0x0a, 0xd3, 0x49, 0xd7, 0x24, 0x0d, 0xaf,
  0xef, 0x4f, 0xe0, 0x37, 0x5b, 0x81, 0x2f, 0x1e, 0x9c, 0xdb, 0x43, 0x80,
  0xe9, 0x0d, 0xb4, 0x90, 0x5a, 0xc3, 0x58, 0x0a, 0x5a, 0xcc, 0x67, 0x8f,
  0x5b, 0xc5, 0x43, 0xdc, 0x3e, 0xa6, 0x29, 0x8e, 0x2d, 0xd7, 0xbd, 0xf0,
  0x35, 0x7a, 0x43, 0x58, 0x6e, 0x7e, 0x58, 0xa5, 0x06, 0xc5, 0xc8, 0x6d,
  0x1f, 0x1c, 0xdf, 0x87, 0x1c, 0xfe, 0xc1, 0x8c, 0xe7, 0xc6, 0xcc, 0x03,
  0x33, 0xba, 0x80, 0xf3, 0x95, 0xbf, 0xf2, 0x22, 0xba, 0x40, 0xe9, 0xda,
  0x63, 0x18, 0x74, 0x2e, 0x08, 0xdc, 0xde, 0xdc, 0x84, 0xc4, 0xa1, 0x29,
  0x6c, 0xab, 0x05, 0x5f, 0x05, 0x8d, 0x0a, 0xbd, 0xfb, 0xc5, 0x6a, 0x3e,
  0xbe, 0x3e, 0x7c, 0x3b, 0x6c, 0x7f, 0x5d, 0xea, 0xa7, 0x68, 0x94, 0x1e,
  0x5c, 0x96, 0x78, 0x9a, 0x84, 0x3b, 0xb0, 0x4c, 0x96, 0x0a, 0xd5, 0x43,
  0xda, 0x02, 0xb0, 0x77, 0xf6, 0xf6, 0xe8, 0xcb, 0x53, 0xfb, 0xb1, 0x76,
  0xc9, 0x1f, 0x5c, 0xe1, 0x13, 0xd4, 0x76, 0x69, 0xb1, 0x2f, 0x37, 0x06,
  0xe7, 0x40, 0x2c, 0xbd, 0xf9, 0x1f, 0x55, 0x02, 0xf1, 0xba, 0xd0, 0x62,
  0x4f, 0x49, 0x52, 0xaa, 0xc5, 0xb4, 0x37, 0xc7, 0xe1, 0x64, 0x7b, 0x5f,
  0x7e, 0xd1, 0xbc, 0xc9, 0x0e, 0xdf, 0xae, 0xe9, 0x0e, 0xdf, 0xf4, 0x2d,
  0x11, 0x41, 0xaf, 0x6e, 0x49, 0x4f, 0xe7, 0xd5, 0x69, 0x59, 0x15, 0x92,
  0xda, 0xed, 0x47, 0x65, 0xea, 0xa6, 0x2b, 0xe2, 0xb8, 0x0b, 0xcd, 0x23,
  0xaf, 0x92, 0x2b, 0x21, 0x46, 0xa3, 0x69, 0x4c, 0x37, 0x68, 0xd4, 0x82,
  0x82, 0x1e, 0xd8, 0xdb, 0xab, 0x40, 0xdb, 0xc1, 0x2a, 0x2b, 0x26, 0x8e,
  0x21, 0x7e, 0xfa, 0x4a, 0xf3, 0x4d, 0x96, 0xee, 0x7c, 0x67, 0x75, 0xad,
  0xb2, 0x7f, 0x47, 0x97, 0x14, 0xbb, 0x43, 0x21, 0x1b, 0x46, 0x2f, 0xe5,
  0x3a, 0xfa, 0xac, 0x71, 0x20, 0x24, 0x97, 0xd3, 0x4c, 0xcf, 0xe6, 0x10,
  0xe2, 0x2b, 0x1f, 0x56, 0x24, 0x97, 0x06, 0xcc, 0xc5, 0x42, 0x92, 0x32,
  0x11, 0xbb, 0xb4, 0x26, 0x05, 0x37, 0x02, 0x90, 0x96, 0xd3, 0x20, 0x0b,
  0xd5, 0xa0, 0x77, 0xa5, 0xeb, 0x48, 0x2b, 0x34, 0x0a, 0x28, 0xa6, 0x61,
  0x16, 0x5b, 0xfe, 0xa3, 0x78, 0x59, 0xeb, 0x77, 0x03, 0x2a, 0x51, 0xcd,
  0xd2, 0x7b, 0x57, 0x6d, 0xb0, 0x22, 0x3d, 0x3b, 0x50, 0x4b, 0xc9, 0x80,
  0xd4, 0x86, 0x3f, 0x98, 0xec, 0x07, 0x2b, 0x5a, 0x47, 0x1e, 0xee, 0xb0,
  0x09, 0x0e, 0x09, 0x0c, 0x62, 0x65, 0x92, 0xdc, 0x42, 0x4e, 0x41, 0x1c,
  0x2f, 0x61, 0x1d, 0x63, 0xbf, 0x02, 0xe3, 0xe0, 0xb6, 0x36, 0xb7, 0xc2,
  0xbd, 0xdd, 0xf9, 0xdc, 0x6c, 0x72, 0x1d, 0x33, 0xd9, 0x03, 0xf9, 0x22,
  0x80, 0x04, 0xe2, 0xc6, 0xad, 0xf8, 0x9a, 0x2c, 0x05, 0xba, 0x6a, 0x58,
  0xc9, 0xe1, 0x9e, 0xe0, 0xb2, 0xaa, 0x0c, 0x30, 0xd9, 0xf9, 0xbc, 0xdf,
  0x69, 0x2f, 0xa1, 0xec, 0xd1, 0x3c, 0x21, 0x0c, 0xb1, 0x60, 0xac, 0x26,
  0x75, 0xb3, 0x21, 0x4a, 0x2f, 0xae, 0x62, 0xe1, 0x72, 0x44, 0xf2, 0x5b,
  0xb9, 0x6c, 0x96, 0x4b, 0x1b, 0x49, 0x56, 0x2a, 0x17, 0xab, 0x62, 0xdd,
  0x01, 0x0b, 0xee, 0x4b, 0x04, 0xb3, 0x1c, 0x08, 0x9b, 0x63, 0xc9, 0xd1,
  0x2a, 0x6a, 0xc8, 0x1c, 0x25, 0x0c, 0x8c, 0x31, 0xcd, 0xee, 0xea, 0xe2,
  0xca, 0x3e, 0x2e, 0x7a, 0x3f, 0x3a, 0xbe, 0x9d, 0xbc, 0x33, 0x0f, 0x96,
  0xfe, 0xdf, 0xff, 0xc3, 0xbe, 0x7e, 0x8f, 0x15, 0xfb, 0xa7, 0xad, 0x58,
  0xab, 0x49, 0x30, 0x36, 0x79, 0xfc, 0xf7, 0xde, 0x26, 0x23, 0x6b, 0xc3,
  0xf9, 0x3e, 0xd2, 0xe0, 0xef, 0x7d, 0x95, 0x41, 0x9d, 0x7d, 0x8c, 0xaa,
  0x90, 0x10, 0x0e, 0x9a, 0x93, 0x55, 0x49, 0xf4, 0x47, 0xc0, 0xa2, 0xd3,
  0x2b, 0x24, 0x51, 0xc2, 0xe7, 0x1c, 0xd6, 0xda, 0xfa, 0x31, 0xd7, 0x92,
  0x95, 0x24, 0xfc, 0xd0, 0xe0, 0xe3, 0xb1, 0x9e, 0xc5, 0x1f, 0x1b, 0xae,
  0x7d, 0x29, 0xbc, 0x85, 0x0d, 0xf9, 0x7d, 0x9f, 0x0e, 0x86, 0x66, 0xd4,
  0xc5, 0x91, 0x16, 0xcb, 0x8d, 0xec, 0x33, 0x03, 0xea, 0x9e, 0x3f, 0xd9,
  0xeb, 0x07, 0x7a, 0x76, 0xaf, 0x81, 0xa0, 0x0c, 0xbf, 0x9f, 0xc8, 0x4a,
  0x01, 0x1a, 0xaf, 0x24, 0xfa, 0xfd, 0x3e, 0x12, 0x77, 0xa3, 0xc4, 0x0d,
  0x2f, 0xd9, 0x80, 0x70, 0x57, 0xad, 0xce, 0xd0, 0xaa, 0xe2, 0x35, 0x4b,
  0xe3, 0x38, 0xa1, 0xa6, 0xba, 0x4d, 0x96, 0xdc, 0xc8, 0xa1, 0x09, 0x0d,
  0xf9, 0x86, 0xdd, 0xf7, 0x8c, 0xdf, 0x0f, 0xc1, 0x9f, 0xe7, 0x0c, 0x65,
  0x54, 0x12, 0xea, 0x60, 0x94, 0x16, 0x3c, 0x5b, 0x09, 0x70, 0x0d, 0xeb,
  0x55, 0xa8, 0x8e, 0xbd, 0x36, 0x33, 0x53, 0xae, 0x4f, 0x8f, 0xb6, 0x68,
  0x4a, 0x50, 0x97, 0x03, 0x78, 0xb2, 0xe9, 0xc4, 0x57, 0xdd, 0x91, 0x8a,
  0x90, 0x6d, 0x85, 0x28, 0xa3, 0xa6, 0x99, 0xc4, 0x8a, 0x91, 0x36, 0xb9,
  0x39, 0xbc, 0x47, 0xef, 0x39, 0x97, 0xc5, 0x9d, 0x27, 0xe2, 0x28, 0x49,
  0x8e, 0x44, 0x78, 0xc9, 0x71, 0x71, 0xb3, 0xa2, 0x3e, 0x97, 0x02, 0xb6,
  0x11, 0x84, 0xef, 0x3e, 0xdc, 0x77, 0xae, 0xb9, 0xcd, 0x52, 0x9c, 0x6c,
  0x73, 0xb8, 0xc5, 0x41, 0x0d, 0xeb, 0x06, 0xa1, 0x30, 0x38, 0x72, 0xa8,
  0xfd, 0x28, 0x64, 0x18, 0xaa, 0x15, 0xf2, 0xf2, 0xf2, 0x38, 0xd2, 0xb5,
  0x9e, 0xe5, 0x68, 0x4d, 0xca, 0x4e, 0xb4, 0x29, 0x36, 0x9e, 0x58, 0xc1,
  0x95, 0xb6, 0x14, 0x11, 0xcb, 0xae, 0x1d, 0x43, 0x9a, 0xfa, 0x50, 0x73,
  0x1c, 0x73, 0xdd, 0x08, 0x87, 0x7e, 0xda, 0x30, 0x29, 0xc3, 0x9c, 0xf1,
  0x5e, 0x92, 0x49, 0x1c, 0xaf, 0xf2, 0xb9, 0x25, 0xbd, 0xa0, 0xca, 0x5a,
  0xcf, 0x23, 0x57, 0xb1, 0x0e, 0xc3, 0x57, 0xc6, 0x23, 0xf6, 0x95, 0x67,
  0x9f, 0x4c, 0x84, 0xe1, 0xb3, 0xbd, 0xdc, 0x45, 0xd3, 0xcb, 0xc5, 0x65,
  0x37, 0xc5, 0x2c, 0x9d, 0x7e, 0xa0, 0xb9, 0x69, 0xaa, 0x4a, 0x0c, 0x8b,
  0x43, 0xcb, 0xd6, 0xd3, 0xc2, 0x13, 0x02, 0x9f, 0x82, 0xd2, 0xdc, 0x28,
  0xdc, 0x1b, 0xb5, 0xb0, 0x66, 0x0d, 0x46, 0x67, 0x7c, 0x7b, 0x9b, 0x2a,
  0x87, 0x1b, 0x96, 0xa8, 0xe7, 0x64, 0x70, 0xba, 0x62, 0x4e, 0x78, 0xb8,
  0x39, 0xc9, 0x48, 0xb2, 0xba, 0x94, 0x2a, 0xb4, 0xb1, 0x05, 0x22, 0x2e,
  0xfc, 0x65, 0xdc, 0x3e, 0xe4, 0x2a, 0x69, 0x35, 0x17, 0xdf, 0x8f, 0x28,
  0x2c, 0x89, 0xf2, 0xe8, 0x41, 0x39, 0x54, 0xd7, 0x16, 0x78, 0x31, 0x0e,
  0xb8, 0xdb, 0x34, 0x0b, 0xe9, 0xd6, 0xc3, 0xcd, 0x3d, 0x62, 0x2a, 0x0b,
  0x1c, 0x29, 0x11, 0x10, 0x3f, 0xbc, 0xfc, 0xbf, 0xd1, 0x4c, 0x7d, 0x79,
  0x43, 0x45, 0x69, 0x11, 0x24, 0x16, 0xcb, 0x67, 0x1b, 0x25, 0x57, 0x69,
  0xc3, 0x03, 0xd1, 0x26, 0xf7, 0x3a, 0xdd, 0x3d, 0x66, 0xa7, 0x40, 0xd2,
  0xaf, 0x83, 0x93, 0x48, 0x6a, 0x2b, 0x97, 0x37, 0xfa, 0xd0, 0x59, 0xd0,
  0x32, 0x10, 0x7c, 0x8c, 0x82, 0x7b, 0x76, 0x6c, 0xdb, 0x11, 0x08, 0x31,
  0xb4, 0x13, 0x1f, 0x6a, 0x0e, 0x8a, 0xb9, 0xd8, 0x35, 0x6f, 0xa1, 0x1a,
  0xac, 0xd9, 0x0b, 0x57, 0xe2, 0x74, 0xcd, 0x62, 0x33, 0x38, 0x1e, 0xc8,
  0x5c, 0x33, 0xf3, 0x02, 0xa8, 0xe1, 0x87, 0xfb, 0xa7, 0x33, 0xbd, 0x28,
  0x7c, 0x0d, 0x74, 0xa1, 0x78, 0x39, 0x73, 0x3d, 0xa3, 0x33, 0x46, 0x6d,
  0x79, 0x1c, 0x29, 0xb0, 0xd5, 0xdb, 0xe7, 0xe3, 0x58, 0xb6, 0x0e, 0xea,
  0xc7, 0x31, 0x6b, 0xe2, 0xaf, 0x62, 0xa9, 0xc8, 0xcd, 0x44, 0xf8, 0xa1,
  0xd1, 0xc5, 0x22, 0xef, 0xd7, 0x56, 0xc1, 0xfb, 0x3e, 0x8d, 0x86, 0xc5,
  0x6c, 0xf2, 0x18, 0x3e, 0xc6, 0xbc, 0x0b, 0xeb, 0xe4, 0x33, 0x45, 0x82,
  0xd5, 0x0a, 0x1c, 0x78, 0x4d, 0x1b, 0x65, 0xf4, 0xa8, 0x7c, 0x2a, 0x1e,
  0x2a, 0x8f, 0xfc, 0xf1, 0xc7, 0xe7, 0x37, 0xe1, 0x5e, 0x62, 0xbd, 0x62,
  0x9c, 0x88, 0xc6, 0xc9, 0x61, 0x34, 0xfd, 0x56, 0x50, 0xa1, 0xa8, 0x81,
  0x31, 0x94, 0xf3, 0x0e, 0xa8, 0x64, 0xe1, 0x8c, 0x60, 0x35, 0x16, 0x21,
  0xb2, 0x5b, 0x33, 0xff, 0x31, 0x6a, 0x06, 0x79, 0xaa, 0xbb, 0xb5, 0x82,
  0x4e, 0x37, 0x4f, 0x92, 0x89, 0xc2, 0x46, 0xd2, 0x45, 0x8c, 0xd3, 0x53,
  0xb6, 0xe6, 0x8e, 0x36, 0x2f, 0x5c, 0xda, 0xc5, 0xc6, 0x99, 0x41, 0x21,
  0xd6, 0xf7, 0x86, 0x02, 0xa0, 0x67, 0x86, 0x6f, 0x43, 0x9f, 0x78, 0x28,
  0xf0, 0x13, 0x22, 0x71, 0x24, 0x5c, 0x8d, 0x46, 0x9e, 0x6e, 0x39, 0x81,
  0xdc, 0x9a, 0x46, 0x06, 0x45, 0x8f, 0x6b, 0x4d, 0x9e, 0x5e, 0xd7, 0x96,
  0x5a, 0xca, 0x1f, 0x6c, 0xcb, 0x3c, 0xf9, 0x6e, 0x58, 0x2c, 0x57, 0x7d,
  0x60, 0xb3, 0xda, 0xc4, 0x2e, 0xee, 0xd1, 0x15, 0x6f, 0x7f, 0xd4, 0xe8,
  0x59, 0xaf, 0x31, 0xe1, 0xeb, 0xe1, 0x1e, 0xb5, 0x96, 0xb6, 0xc8, 0x29,
  0x8d, 0xae, 0x17, 0xb4, 0xab, 0x7e, 0x1f, 0xd0, 0x75, 0x0c, 0x7f, 0xd3,
  0x95, 0x9f, 0x97, 0x3c, 0x13, 0x28, 0x3e, 0x24, 0x92, 0x16, 0xcb, 0x5c,
  0xea, 0x7b, 0x7e, 0x98, 0x94, 0xdc, 0xf1, 0x77, 0x65, 0x83, 0xdb, 0xc7,
  0xe0, 0x76, 0x2f, 0x1c, 0x83, 0x7e, 0x58, 0x1f, 0x81, 0x1f, 0xc2, 0xcf,
  0x1c, 0x83, 0xb4, 0xd7, 0x18, 0x81, 0xe2, 0x2b, 0xbc, 0x47, 0x98, 0xa8,
  0x1d, 0xf7, 0x03, 0xf9, 0xac, 0x7f, 0xc1, 0x9f, 0x29, 0x68, 0x53, 0x50,
  0xd7, 0xd8, 0xc2, 0xb9, 0x89, 0xb3, 0x5f, 0x7e, 0x70, 0x04, 0xb9, 0xab,
  0x45, 0xde, 0xe8, 0x9b, 0x44, 0x5b, 0x13, 0x49, 0x0a, 0x28, 0x4e, 0x4e,
  0x83, 0x27, 0x3d, 0x2d, 0x72, 0x5f, 0x70, 0x62, 0xa1, 0x41, 0x91, 0x70,
  0xf0, 0xf3, 0xa3, 0x79, 0xc3, 0x23, 0x52, 0xf5, 0x30, 0x06, 0x5f, 0x4b,
  0xdb, 0xc6, 0x20, 0x28, 0x2a, 0xfe, 0x63, 0x95, 0xb9, 0x93, 0x3c, 0xf1,
  0x85, 0x43, 0x64, 0x48, 0xbf, 0x4c, 0x46, 0x6e, 0x8e, 0xe3, 0x92, 0x24,
  0x7f, 0x9a, 0x5a, 0xbe, 0x7a, 0xcf, 0x50, 0x50, 0x17, 0x01, 0x90, 0x1b,
  0x7f, 0x60, 0x76, 0x48, 0x0e, 0x82, 0x87, 0x47, 0x37, 0x55, 0xd4, 0xe0,
  0x69, 0xc6, 0x36, 0xc4, 0x87, 0xc7, 0x21, 0x49, 0x8d, 0x35, 0x94, 0x3a,
  0x43, 0xa3, 0xab, 0xe5, 0x7e, 0x05, 0xf2, 0xfb, 0xaf, 0xe7, 0x97, 0x75,
  0x19, 0x0c, 0xd1, 0x4b, 0xfe, 0xf1, 0xa1, 0x24, 0xa0, 0x20, 0xff, 0xc7,
  0x23, 0xe0, 0x3e, 0x2e, 0x8b, 0xa7, 0x6e, 0x8d, 0x59, 0x9f, 0x7d, 0xf5,
  0x38, 0xbf, 0x52, 0x72, 0x9f, 0x4a, 0xb6, 0x74, 0x5b, 0x64, 0xb3, 0xa3,
  0x8d, 0x22, 0x29, 0x8b, 0x56, 0xe0, 0x5a, 0x0b, 0x52, 0xf1, 0x19, 0x25,
  0x39, 0xe0, 0x3c, 0x19, 0x5b, 0xa1, 0xad, 0x45, 0xb4, 0x54, 0xb6, 0xd5,
  0x35, 0xd4, 0x04, 0x10, 0xf3, 0xf3, 0x17, 0x12, 0x2a, 0x7e, 0xcf, 0x61,
  0xc3, 0x1d, 0x86, 0xd0, 0xb4, 0x31, 0xd3, 0x9c, 0xdb, 0x3d, 0x8a, 0x22,
  0x15, 0x9a, 0x5e, 0x55, 0x93, 0x14, 0x35, 0x63, 0x17, 0xd1, 0xb8, 0x7c,
  0xe9, 0xc5, 0xe6, 0x65, 0x6c, 0xc3, 0x41, 0xd6, 0x78, 0x1f, 0x1c, 0xc3,
  0x05, 0x4a, 0x23, 0xb2, 0x77, 0x57, 0xd0, 0xc9, 0x50, 0x91, 0x42, 0xea,
  0xf2, 0xe2, 0x75, 0x09, 0xf4, 0x62, 0x9f, 0xa8, 0x30, 0x31, 0xfa, 0xb6,
  0x69, 0xd0, 0x33, 0x27, 0x90, 0x17, 0x57, 0x83, 0x11, 0x8a, 0xc3, 0x52,
  0x11, 0x22, 0x1d, 0x02, 0x89, 0x2f, 0xbd, 0xdc, 0x2c, 0x09, 0x28, 0x7a,
  0x08, 0x0a, 0x7b, 0x68, 0x81, 0x24, 0x5e, 0xb1, 0x3a, 0x72, 0xb1, 0x65,
  0x90, 0xb1, 0x0d, 0x6b, 0x22, 0xc4, 0x2b, 0x6e, 0xae, 0xba, 0xfb, 0xb4,
  0x86, 0x58, 0xbd, 0xce, 0x88, 0x32, 0xac, 0x38, 0x83, 0x39, 0xbe, 0x6a,
  0xb7, 0x17, 0x64, 0xaa, 0xb1, 0x0e, 0x14, 0xd8, 0x21, 0x85, 0xc0, 0x05,
  0xb6, 0x0f, 0xc0, 0x8b, 0xf5, 0xcb, 0x81, 0x43, 0x35, 0xee, 0x50, 0x3c,
  0x47, 0x93, 0x7e, 0xb4, 0x9d, 0x56, 0x42, 0xec, 0x39, 0x31, 0xd9, 0x16,
  0xb3, 0xb1, 0xc6, 0x0c, 0x6e, 0xb8, 0xa9, 0x71, 0xb2, 0x5b, 0x2c, 0x13,
  0x25, 0x74, 0x86, 0xf8, 0xf4, 0xb3, 0x19, 0xf9, 0x4f, 0x0f, 0x46, 0x21,
  0xfd, 0x4a, 0xac, 0xe0, 0x3b, 0x0e, 0x41, 0x90, 0x1b, 0x7f, 0x2d, 0xee,
  0xa6, 0x54, 0x70, 0x1b, 0xba, 0x10, 0xe8, 0x98, 0x6e, 0xbf, 0xa2, 0x24,
  0x39, 0xd3, 0xde, 0xd4, 0xda, 0x06, 0x1a, 0x7a, 0xf3, 0x08, 0x88, 0xfa,
  0x2a, 0xa2, 0xb6, 0x43, 0xe2, 0xbc, 0xa8, 0xa4, 0x00, 0x38, 0x49, 0xc4,
  0x17, 0x75, 0x6a, 0x01, 0x8f, 0x0d, 0x51, 0x56, 0x65, 0xfb, 0x74, 0x34,
  0xec, 0x47, 0xbd, 0x4b, 0x0b, 0x0d, 0xea, 0x50, 0x38, 0x16, 0x05, 0x43,
  0x60, 0x1f, 0xe2, 0x97, 0x47, 0x17, 0x5b, 0x4d, 0x00, 0x80, 0x78, 0xe2,
  0x47, 0xc6, 0x28, 0x56, 0x7a, 0x0a, 0xc4, 0xaf, 0x52, 0x49, 0x7d, 0xc1,
  0x9e, 0xdd, 0x2f, 0xa6, 0xf1, 0x3c, 0xae, 0x85, 0x6a, 0xd8, 0xca, 0xbd,
  0x5e, 0xb3, 0x70, 0x01, 0x68, 0xa3, 0xad, 0x5a, 0x10, 0xf2, 0x7e, 0x72,
  0x3c, 0xbc, 0xe0, 0x55, 0xac, 0x87, 0x65, 0x70, 0x18, 0x2b, 0x2b, 0xba,
  0xc0, 0x93, 0x56, 0x7f, 0x2a, 0x82, 0xa0, 0x7f, 0x3b, 0x02, 0x59, 0x21,
  0xd7, 0x1b, 0x62, 0x8f, 0xc2, 0x30, 0xe0, 0xdf, 0x16, 0xe8, 0x9e, 0xd8,
  0x8b, 0x69, 0x70, 0xbf, 0xe0, 0x52, 0x56, 0x1c, 0x01, 0x79, 0x59, 0x20,
  0x03, 0x44, 0x7a, 0x5c, 0xa0, 0xe2, 0x8b, 0x98, 0x75, 0x26, 0xcb, 0xbc,
  0x79, 0x5d, 0xc6, 0x51, 0xd0, 0xa1, 0xc0, 0x0e, 0xf4, 0x2a, 0x12, 0x2e,
  0x9c, 0x01, 0x85, 0xc7, 0xcc, 0xa4, 0xee, 0x83, 0x17, 0x1a, 0x46, 0x56,
  0x5f, 0x90, 0xc9, 0x80, 0x30, 0xc2, 0x21, 0xd9, 0xb4, 0x77, 0x49, 0x1b,
  0x9a, 0x22, 0x13, 0x1f, 0xac, 0x5c, 0x12, 0xd7, 0x57, 0x0f, 0xa3, 0x4f,
  0x4a, 0x28, 0x50, 0xe8, 0x1a, 0x93, 0xb8, 0x81, 0x65, 0x61, 0x14, 0xcb,
  0x65, 0x81, 0x62, 0x29, 0xa9, 0xca, 0x6b, 0xd2, 0x14, 0xf7, 0x54, 0xdc,
  0x12, 0x9f, 0x63, 0x90, 0x88, 0xc1, 0x81, 0x4b, 0xc4, 0x9e, 0xe7, 0x56,
  0x14, 0x8f, 0x66, 0x90, 0xaf, 0xac, 0xa8, 0x96, 0xbc, 0xd7, 0x6f, 0xd1,
  0x26, 0xa1, 0xb3, 0xad, 0x61, 0x88, 0xbf, 0x1e, 0x4d, 0x7c, 0xef, 0x68,
  0x42, 0xd6, 0xf0, 0x25, 0xff, 0xf1, 0xb3, 0xa8, 0x22, 0x40, 0x97, 0xe0,
  0x97, 0xd9, 0x46, 0x51, 0x21, 0x8f, 0x7e, 0x23, 0x92, 0x99, 0x1e, 0xe2,
  0xd8, 0x52, 0xbf, 0xd7, 0xaa, 0xff, 0x42, 0xac, 0xa8, 0x92, 0x44, 0xf0,
  0x0c, 0x5b, 0xb8, 0x69, 0x53, 0xdb, 0x6a, 0x38, 0xf4, 0xbf, 0xb7, 0x72,
  0x91, 0x4f, 0x76, 0x70, 0x39, 0xb1, 0xec, 0x92, 0x94, 0xbf, 0xe1, 0xd2,
  0xfd, 0x1d, 0x49, 0x69, 0xf4, 0x78, 0x9f, 0xc9, 0xff, 0xe5, 0x24, 0x66,
  0x7b, 0x84, 0x79, 0xfb, 0xd7, 0xc2, 0x72, 0x02, 0x57, 0x5e, 0xeb, 0x0c,
  0xa8, 0xa1, 0x0b, 0xd7, 0x37, 0x32, 0x15, 0x47, 0x00, 0x9d, 0x99, 0x65,
  0x13, 0x75, 0xdf, 0xc4, 0xa5, 0xad, 0xf0, 0xda, 0x8a, 0x60, 0x86, 0x21,
  0x84, 0xe3, 0x47, 0x8f, 0xf7, 0x22, 0xc5, 0xb0, 0x5d, 0xd3, 0xa4, 0x03,
  0xed, 0x6d, 0xa4, 0xd3, 0x0a, 0x7c, 0x87, 0xe2, 0x9a, 0x86, 0xd3, 0xb0,
  0x6b, 0x15, 0xc2, 0x4d, 0xc1, 0xfe, 0x5c, 0x62, 0x6a, 0xfc, 0x8c, 0x78,
  0xf4, 0x0a, 0x74, 0xd9, 0xd0, 0x56, 0x60, 0xc2, 0xb0, 0xd8, 0x25, 0xd2,
  0x33, 0x18, 0xf0, 0x1e, 0xbe, 0x44, 0x8f, 0x47, 0x47, 0xa3, 0x54, 0x03,
  0x96, 0xa1, 0x7f, 0x19, 0xd4, 0x5f, 0x4b, 0xd4, 0xb6, 0xfa, 0x09, 0x7d,
  0xb6, 0x90, 0x46, 0x5b, 0x2a, 0x9f, 0xfd, 0x9d, 0xe2, 0x30, 0x39, 0x60,
  0xec, 0xf7, 0xd4, 0x16, 0xc6, 0x88, 0xb4, 0xc7, 0x35, 0x79, 0x8f, 0x85,
  0x70, 0xff, 0xda, 0x64, 0xf5, 0x36, 0x68, 0x17, 0x40, 0xac, 0xe8, 0x71,
  0xe5, 0x8d, 0x10, 0x7b, 0x79, 0xb3, 0xbf, 0x25, 0x25, 0xb6, 0x6e, 0x12,
  0x41, 0xb6, 0x92, 0x6d, 0x6e, 0xaa, 0x93, 0xb1, 0xd3, 0xf4, 0x5c, 0x80,
  0x5c, 0x36, 0x9d, 0xf8, 0xf3, 0x64, 0x19, 0x0a, 0xe8, 0x6c, 0x5b, 0x6c,
  0x44, 0xc6, 0xef, 0x38, 0x8b, 0xbe, 0x71, 0x97, 0xd4, 0x1a, 0x23, 0x35,
  0x2f, 0x6c, 0xcc, 0x5f, 0xc3, 0xae, 0xc1, 0xdf, 0x32, 0x52, 0x14, 0x70,
  0x30, 0xac, 0xe2, 0x15, 0xad, 0xe0, 0x70, 0x80, 0x88, 0xf1, 0x60, 0x32,
  0xf3, 0x16, 0xbd, 0x10, 0xd5, 0x7a, 0x1d, 0x76, 0x31, 0x14, 0x58, 0xc5,
  0xc8, 0x1a, 0xf0, 0x38, 0xeb, 0x32, 0x64, 0x58, 0x1f, 0xcc, 0x83, 0x18,
  0x55, 0xcb, 0x98, 0x84, 0xf0, 0xc2, 0x08, 0xde, 0x45, 0x31, 0xd8, 0x79,
  0x6b, 0x44, 0x3f, 0x93, 0x9a, 0x07, 0x4e, 0x0e, 0x6d, 0x84, 0x51, 0x07,
  0x51, 0xa8, 0xa3, 0x62, 0x99, 0x4f, 0x96, 0xb3, 0xce, 0x20, 0x28, 0x7a,
  0xac, 0x0b, 0x03, 0x06, 0x5a, 0x3f, 0x08, 0x72, 0x09, 0x51, 0x9f, 0xcf,
  0x76, 0x6a, 0x06, 0x47, 0x83, 0xca, 0x09, 0xc0, 0x71, 0xfa, 0xbb, 0x21,
  0xfd, 0x50, 0x7b, 0x0d, 0x79, 0xab, 0xc4, 0xbd, 0xf6, 0x1b, 0x6e, 0xde,
  0x0e, 0x2d, 0x26, 0xe4, 0xd8, 0xdd, 0xc1, 0x4e, 0xbb, 0xe4, 0x88, 0x60,
  0x9a, 0x71, 0xe2, 0xab, 0x1c, 0xa5, 0xa4, 0xff, 0x61, 0xb4, 0x85, 0xaf,
  0x82, 0x27, 0x2e, 0x52, 0x95, 0xb9, 0x76, 0xec, 0x90, 0x36, 0xaa, 0x26,
  0xba, 0x02, 0x2f, 0x85, 0xe3, 0x0a, 0x9c, 0xa0, 0x99, 0x88, 0xed, 0xf1,
  0x85, 0x93, 0xda, 0x82, 0xe1, 0xed, 0x82, 0xe5, 0x4e, 0x8b, 0xdb, 0xdd,
  0x56, 0xdc, 0xe7, 0xda, 0xd0, 0x20, 0x89, 0x5d, 0x0c, 0x4f, 0x5c, 0xbc,
  0xde, 0xae, 0x48, 0xb3, 0x56, 0x31, 0x29, 0x28, 0xaf, 0xb4, 0xa6, 0x28,
  0xd8, 0xc5, 0xc9, 0xd0, 0xe4, 0x59, 0x3f, 0x84, 0x3d, 0x5c, 0x98, 0xc5,
  0xf4, 0x76, 0xaf, 0xbd, 0x70, 0xb6, 0x8e, 0xa1, 0x32, 0x88, 0x61, 0x30,
  0x88, 0xbd, 0xe6, 0x20, 0x1e, 0xaa, 0x4b, 0x26, 0x05, 0xac, 0x6b, 0x43,
  0x78, 0xa2, 0x43, 0x78, 0xf2, 0xd8, 0x55, 0x08, 0x07, 0xf0, 0xe4, 0xe7,
  0xae, 0x42, 0xeb, 0x10, 0x9e, 0x22, 0xee, 0x75, 0x71, 0xfb, 0xb4, 0x25,
  0xe2, 0xd3, 0xa1, 0x65, 0x72, 0xc8, 0x17, 0x72, 0xe6, 0xa7, 0x62, 0xec,
  0xf2, 0x1e, 0x35, 0xa0, 0xfd, 0x5b, 0x51, 0x89, 0xcc, 0x5b, 0xe4, 0x8f,
  0xeb, 0xb0, 0xfe, 0x3a, 0x66, 0x8f, 0xbf, 0x28, 0x68, 0x00, 0x97, 0xf6,
  0xcb, 0xe2, 0xf6, 0xe3, 0xbe, 0xf6, 0x50, 0xab, 0x5b, 0x24, 0xb5, 0x50,
  0xd6, 0x84, 0x1e, 0x4a, 0x15, 0x48, 0x06, 0xad, 0xe0, 0x08, 0x24, 0x7c,
  0x70, 0x7c, 0x76, 0xfb, 0xd4, 0x06, 0x95, 0x48, 0x1c, 0x58, 0x30, 0xdd,
  0x8f, 0x65, 0xba, 0x1f, 0xff, 0xdf, 0x34, 0xdd, 0x8f, 0xd7, 0x4f, 0xf7,
  0x23, 0x51, 0xcb, 0x19, 0xce, 0xaa, 0x3f, 0x8a, 0xf3, 0xb5, 0xe0, 0x7e,
  0x16, 0xbd, 0xe4, 0xb0, 0xaf, 0x2a, 0x51, 0xb8, 0x5a, 0x8c, 0x5b, 0xbe,
  0xa1, 0x66, 0xd6, 0xb3, 0x82, 0x8a, 0x44, 0x8f, 0x8a, 0xeb, 0x45, 0x99,
  0x8e, 0x7f, 0x6e, 0xed, 0xbc, 0x5f, 0x52, 0xdb, 0xd0, 0x8d, 0x8d, 0xfa,
  0x02, 0x84, 0xb9, 0x0b, 0xf1, 0xfb, 0x9f, 0xdb, 0x83, 0xd6, 0x12, 0x1b,
  0x87, 0xcd, 0x22, 0x18, 0x3d, 0x2e, 0x18, 0x5d, 0x2b, 0xa5, 0x11, 0x88,
  0x12, 0x47, 0x6f, 0xbf, 0x39, 0x3e, 0x3f, 0x7d, 0xfb, 0xe6, 0xe8, 0xad,
  0x73, 0xfc, 0x73, 0x3c, 0x82, 0xd8, 0x1c, 0x7e, 0x30, 0xab, 0xc2, 0x8b,
  0xed, 0xed, 0x9f, 0x18, 0x8f, 0xe5, 0x33, 0xb5, 0xdf, 0x35, 0xef, 0xcd,
  0x42, 0xed, 0x14, 0x1e, 0x02, 0xdb, 0xd2, 0x63, 0xd8, 0x22, 0xe4, 0x96,
  0x8b, 0x83, 0x56, 0xdf, 0x9f, 0x9d, 0x9f, 0x7e, 0xf7, 0xfd, 0xaf, 0xd8,
  0xfe, 0xb0, 0x02, 0xbb, 0xfc, 0xab, 0x36, 0xff, 0x3a, 0x1c, 0xfd, 0xfe,
  0xc9, 0xc9, 0xaf, 0xd6, 0x38, 0x2b, 0x02, 0xce, 0x70, 0xd3, 0x77, 0x56,
  0x30, 0x57, 0xff, 0xac, 0xa2, 0x22, 0xbc, 0x3d, 0xd5, 0x8e, 0xc5, 0x7c,
  0xd2, 0x37, 0xe4, 0xf2, 0x09, 0xeb, 0xe8, 0x20, 0x54, 0x8c, 0xa1, 0x81,
  0x5b, 0xc8, 0x5f, 0xb2, 0x04, 0xe3, 0x80, 0x91, 0xd4, 0x28, 0x27, 0xf8,
  0xda, 0x1c, 0xc1, 0x9f, 0x39, 0xfb, 0x98, 0x40, 0xd1, 0x98, 0xd9, 0xb5,
  0xa9, 0xce, 0x70, 0xf6, 0x37, 0xc2, 0x2e, 0xf2, 0xb4, 0xb8, 0xe1, 0xd4,
  0x07, 0x1c, 0x4f, 0x45, 0xf7, 0x2b, 0x19, 0x2c, 0x15, 0xd2, 0x38, 0x0f,
  0x05, 0xe4, 0xf5, 0xdd, 0xf1, 0x45, 0x74, 0x70, 0x7a, 0xe8, 0x69, 0xf7,
  0x82, 0x9d, 0x03, 0x6c, 0x5e, 0xc5, 0x11, 0x1c, 0x2d, 0xe7, 0xc8, 0x29,
  0xbc, 0xf4, 0x18, 0xe1, 0x0a, 0xd9, 0x86, 0xb0, 0x97, 0x42, 0x9d, 0xb7,
  0x5c, 0xc7, 0x5e, 0xca, 0x52, 0x20, 0x98, 0x65, 0x12, 0xa8, 0xf2, 0xf2,
  0xb0, 0xc3, 0xb1, 0x33, 0xc3, 0x2c, 0x62, 0x09, 0x01, 0xe5, 0x40, 0xe7,
  0x5a, 0x54, 0x7f, 0x3a, 0x46, 0x13, 0x9c, 0x0b, 0x49, 0xd0, 0x20, 0x09,
  0x67, 0xdf, 0x0b, 0xf4, 0x41, 0x11, 0x2b, 0x01, 0x57, 0xce, 0x19, 0x0c,
  0xb6, 0xa7, 0xb1, 0xef, 0x40, 0xeb, 0x94, 0xc1, 0x84, 0x38, 0x1c, 0xbb,
  0x6a, 0xb7, 0x9e, 0xfb, 0x4c, 0x76, 0x8f, 0xe1, 0xc1, 0xfa, 0x3b, 0x82,
  0x87, 0x27, 0x16, 0x88, 0x6f, 0x68, 0x2f, 0x06, 0xfb, 0x2d, 0x35, 0x88,
  0xd2, 0x62, 0x8d, 0x49, 0xd4, 0x6f, 0xfb, 0x9e, 0x12, 0xb5, 0xa0, 0x8a,
  0x42, 0xa8, 0x11, 0x07, 0x41, 0xfa, 0xf7, 0x40, 0x4e, 0x7e, 0xa2, 0x83,
  0x39, 0x3f, 0xa1, 0x99, 0x4f, 0x85, 0xcb, 0x69, 0x1c, 0xa4, 0x00, 0x8a,
  0xdf, 0xc5, 0x62, 0x30, 0xd7, 0xd2, 0x1e, 0xfe, 0xcd, 0x67, 0xf2, 0xe3,
  0xc0, 0x48, 0xc1, 0x23, 0x26, 0xf9, 0xe2, 0xb0, 0xb5, 0xf2, 0x8e, 0x86,
  0xa3, 0x34, 0x66, 0x78, 0x76, 0xb1, 0xd0, 0x36, 0x71, 0x82, 0x6b, 0x91,
  0x03, 0x1f, 0xd7, 0xfa, 0xb1, 0x6e, 0xa4, 0xb4, 0xe9, 0x85, 0xd3, 0x2a,
  0xc2, 0xc0, 0x11, 0x1b, 0x74, 0xb3, 0xb5, 0x4f, 0xea, 0x8b, 0x12, 0x84,
  0x9f, 0x54, 0xab, 0x1c, 0x7e, 0xea, 0x78, 0x42, 0x74, 0x97, 0x20, 0x4f,
  0xc0, 0x15, 0x58, 0x59, 0x4c, 0xdd, 0xec, 0xcc, 0xe3, 0x2b, 0x4e, 0x46,
  0x2e, 0x9e, 0xa1, 0x7e, 0xb7, 0xb1, 0x8e, 0xb7, 0xa1, 0xa4, 0xe5, 0x61,
  0x81, 0xeb, 0xe7, 0xbe, 0x93, 0x28, 0xe6, 0x50, 0x58, 0x44, 0x47, 0xce,
  0x53, 0x8b, 0x4d, 0xd2, 0xf6, 0xe5, 0x23, 0xf8, 0x6e, 0x88, 0xf5, 0x67,
  0xee, 0x6f, 0x7d, 0xa3, 0x81, 0x9a, 0x51, 0x0b, 0xdc, 0xc0, 0x2a, 0x2c,
  0x73, 0xc9, 0x98, 0xf1, 0x78, 0x1e, 0x1c, 0x21, 0x1a, 0xcf, 0xd5, 0xf6,
  0x2e, 0xc0, 0x9d, 0x9a, 0x7a, 0xd5, 0xb8, 0xc9, 0x4a, 0x07, 0x76, 0x0f,
  0xbd, 0x56, 0xd6, 0x8d, 0x61, 0x68, 0xe5, 0x54, 0x07, 0x90, 0x24, 0x38,
  0x43, 0xa6, 0x22, 0xf3, 0x51, 0x8d, 0x1a, 0x41, 0x1b, 0xbe, 0x22, 0x80,
  0x5f, 0x87, 0xdd, 0xdd, 0xda, 0x62, 0x9f, 0xed, 0x0f, 0x87, 0xb6, 0xd4,
  0x0c, 0x6a, 0x62, 0xeb, 0x29, 0x2b, 0xa8, 0xbe, 0x29, 0xce, 0x2e, 0xd4,
  0x6c, 0xf5, 0x96, 0x9b, 0x50, 0x1b, 0xa9, 0xf9, 0x73, 0x77, 0x9f, 0xf8,
  0x35, 0x77, 0x9d, 0x7d, 0x23, 0xad, 0xf5, 0x1e, 0xd9, 0x59, 0x6b, 0x5f,
  0xdf, 0xb4, 0xf4, 0xf5, 0xb4, 0x36, 0xaf, 0xbd, 0xbd, 0x4f, 0x22, 0x3b,
  0x65, 0x5a, 0x25, 0xcf, 0x75, 0xa6, 0xbd, 0x89, 0xc2, 0x4f, 0x0f, 0xf6,
  0x25, 0x55, 0xa7, 0xd9, 0x97, 0x52, 0x45, 0x51, 0xa9, 0x19, 0xb0, 0xfb,
  0xcc, 0x4f, 0x8b, 0x14, 0x43, 0xb4, 0x07, 0xdb, 0x83, 0x1c, 0x93, 0xc6,
  0xe9, 0xe1, 0xa4, 0x7c, 0x1c, 0x95, 0xe3, 0x33, 0xae, 0x27, 0x9f, 0x95,
  0xed, 0x0e, 0x4a, 0x1b, 0x46, 0xd0, 0xcf, 0x27, 0xae, 0x1f, 0x37, 0x72,
  0x28, 0x83, 0x92, 0x83, 0x3a, 0x08, 0x39, 0x82, 0xd2, 0x48, 0x10, 0x43,
  0xa3, 0x86, 0xef, 0x96, 0x62, 0x52, 0xf2, 0xb6, 0xef, 0xe5, 0x53, 0xc5,
  0x3d, 0x92, 0x32, 0x2e, 0x82, 0x66, 0xc0, 0x95, 0x2e, 0xe2, 0x0a, 0x38,
  0x00, 0x9b, 0x4d, 0x70, 0xdc, 0xad, 0x8f, 0x3c, 0x3c, 0xed, 0xbb, 0xcf,
  0x83, 0x35, 0xb1, 0x61, 0x99, 0xc1, 0x6f, 0xdb, 0x8e, 0x8f, 0x63, 0x21,
  0x22, 0xf6, 0xe0, 0xef, 0xf3, 0xa3, 0x8b, 0x73, 0x0e, 0x3f, 0x03, 0xbe,
  0x41, 0x5d, 0x5d, 0xa5, 0x33, 0xb5, 0xe5, 0x6c, 0xe3, 0x02, 0xda, 0x1c,
  0x70, 0x5d, 0x4f, 0xc9, 0x52, 0x2b, 0x4c, 0xf0, 0x3c, 0xa3, 0x7d, 0xfd,
  0xd3, 0xde, 0x73, 0x88, 0xf1, 0x72, 0x0f, 0xf9, 0xa0, 0x18, 0x3d, 0x19,
  0x6e, 0xfd, 0x7d, 0x64, 0x82, 0x20, 0x5b, 0x89, 0xcd, 0xd6, 0x45, 0x88,
  0x1a, 0x27, 0xf2, 0xee, 0x76, 0x29, 0xbf, 0x29, 0x0c, 0x50, 0x42, 0x3e,
  0x1b, 0x96, 0x1a, 0xd7, 0x79, 0x3c, 0x97, 0x5c, 0x2e, 0x19, 0x44, 0xd5,
  0xe7, 0xa1, 0x17, 0xa4, 0x44, 0x91, 0x8e, 0x12, 0x56, 0xa9, 0x9e, 0xa2,
  0x9a, 0x4c, 0xd3, 0xf0, 0x33, 0xca, 0x6e, 0xcd, 0xc1, 0xa6, 0x41, 0xd0,
  0x02, 0xf3, 0xce, 0xfb, 0xc5, 0x97, 0x29, 0x0b, 0xfc, 0xfd, 0x4b, 0x54,
  0xa9, 0x8c, 0x81, 0x90, 0x5e, 0xd4, 0x54, 0xf4, 0x3d, 0x39, 0x94, 0xdf,
  0x72, 0x58, 0xb6, 0xad, 0x59, 0xed, 0x30, 0x4a, 0xcc, 0x36, 0x33, 0x59,
  0x66, 0x3b, 0x1e, 0x58, 0xa9, 0x58, 0xd1, 0xcc, 0x67, 0xcd, 0x81, 0x29,
  0x3a, 0x45, 0xd0, 0xcd, 0xb3, 0x26, 0xf1, 0x0e, 0x2f, 0x4e, 0xcf, 0x95,
  0xc0, 0x9a, 0x2c, 0x57, 0x0e, 0x23, 0x3f, 0xe2, 0x7d, 0x8c, 0xbd, 0x16,
  0xfb, 0xbd, 0x09, 0x7c, 0x1a, 0x38, 0x81, 0xcc, 0x54, 0xdf, 0xeb, 0xc7,
  0xde, 0x71, 0xa3, 0x53, 0xfb, 0x26, 0xce, 0x39, 0xf9, 0x10, 0x31, 0xfd,
  0x58, 0x59, 0xba, 0x1f, 0x49, 0x9c, 0x9f, 0x05, 0xca, 0xc1, 0x9e, 0x9c,
  0xb3, 0xd3, 0x65, 0x29, 0xd5, 0x63, 0x91, 0x03, 0x04, 0x32, 0xd2, 0x6c,
  0x20, 0x18, 0x8f, 0xd4, 0x3a, 0xe4, 0x2c, 0x72, 0x75, 0x52, 0x94, 0x33,
  0x74, 0xea, 0xab, 0x79, 0xa9, 0xfd, 0xdd, 0xdd, 0x5e, 0xde, 0x6b, 0xce,
  0x16, 0x5f, 0x98, 0xe6, 0xc5, 0x9b, 0xc1, 0x04, 0xa4, 0x58, 0xce, 0xf5,
  0xcd, 0x1e, 0x93, 0x28, 0xc0, 0x63, 0xd6, 0x10, 0x81, 0x40, 0x36, 0xf2,
  0x62, 0xc5, 0x8e, 0x5b, 0x67, 0xae, 0x2b, 0xa8, 0x43, 0xe3, 0x6e, 0x2b,
  0xd5, 0x40, 0xed, 0x8b, 0xb7, 0x99, 0x22, 0xef, 0xc9, 0x61, 0xd5, 0xba,
  0x2c, 0xed, 0x55, 0xd3, 0x74, 0x53, 0xb8, 0x1d, 0x6b, 0x08, 0xc8, 0xc1,
  0xf9, 0xca, 0x1c, 0x50, 0x0e, 0x3c, 0xfd, 0xd2, 0x65, 0x8d, 0x82, 0x3f,
  0xb7, 0xfb, 0xe5, 0x7c, 0x62, 0xd4, 0x93, 0xdd, 0x26, 0x75, 0x40, 0xdc,
  0x3e, 0x3f, 0x1a, 0x5e, 0xc8, 0xd8, 0xf1, 0x5b, 0x63, 0xec, 0x92, 0x1d,
  0xe4, 0x6a, 0x2a, 0x16, 0xeb, 0xa8, 0x03, 0xf1, 0x5d, 0xf0, 0x97, 0x87,
  0x75, 0xf5, 0xc2, 0x35, 0x7b, 0x12, 0x04, 0x21, 0x31, 0xe3, 0x54, 0x5a,
  0xb9, 0xb0, 0xa2, 0x3a, 0x51, 0x47, 0x7b, 0xe9, 0xd0, 0x95, 0x2b, 0x47,
  0x22, 0xcb, 0x83, 0x0a, 0x64, 0x4f, 0x9e, 0xfa, 0x16, 0x16, 0x60, 0xee,
  0xda, 0xc0, 0xb1, 0x99, 0xa7, 0xf1, 0xa1, 0x73, 0xa6, 0x5e, 0xa1, 0xda,
  0xab, 0x10, 0x46, 0x0d, 0x73, 0xf8, 0xc9, 0x33, 0x97, 0x2b, 0x68, 0xe2,
  0x51, 0x30, 0x14, 0x7c, 0x8c, 0x64, 0xf7, 0xe2, 0x3a, 0x96, 0x0c, 0xe0,
  0x1a, 0xd9, 0x3d, 0xf9, 0xd8, 0x33, 0x5d, 0xc8, 0xce, 0xde, 0xc3, 0xa2,
  0x2b, 0x10, 0x5c, 0x47, 0x70, 0x51, 0xa5, 0xf3, 0x25, 0xc3, 0x1a, 0x10,
  0x97, 0x98, 0x02, 0xac, 0x45, 0x5d, 0x24, 0x0d, 0x6b, 0x70, 0x3d, 0x26,
  0xea, 0x89, 0x5e, 0x44, 0xa4, 0xdf, 0xfa, 0xed, 0x92, 0x04, 0x1c, 0x3e,
  0xcc, 0x5e, 0xc6, 0xa3, 0x83, 0x3b, 0x77, 0xb7, 0xc5, 0x20, 0x3a, 0x03,
  0xd6, 0x1d, 0xdb, 0xb9, 0x8b, 0xbf, 0xf8, 0xd6, 0xe4, 0xb0, 0x9c, 0x1c,
  0xee, 0x9f, 0xe1, 0xfa, 0x64, 0xe1, 0x34, 0x9d, 0xd3, 0xee, 0xf2, 0x27,
  0xf8, 0x35, 0xc0, 0x29, 0x6b, 0x4c, 0xf9, 0xb9, 0x7f, 0x59, 0x6b, 0x47,
  0xd6, 0x1f, 0x79, 0xaa, 0xb4, 0x45, 0x5a, 0x0b, 0x37, 0xe1, 0xb8, 0x33,
  0xce, 0xb4, 0x16, 0x62, 0x9e, 0x48, 0x0b, 0x97, 0xf6, 0x4c, 0x85, 0x8b,
  0x07, 0x4d, 0xc9, 0x9d, 0xb0, 0x2f, 0xeb, 0xc4, 0x49, 0xe1, 0x74, 0x72,
  0x00, 0x9d, 0x4f, 0x6d, 0xcd, 0xc1, 0x70, 0xa7, 0xe6, 0x0b, 0xae, 0xe4,
  0x3e, 0xf0, 0xc2, 0x4a, 0x7e, 0x0f, 0xcd, 0xa4, 0x01, 0x9c, 0x54, 0x75,
  0xc9, 0x3d, 0x15, 0x6a, 0x74, 0xa4, 0xe3, 0xae, 0xb1, 0xca, 0xe8, 0xd0,
  0xb1, 0xcb, 0xaa, 0xe2, 0xdd, 0x76, 0x65, 0x3e, 0x83, 0xa6, 0x9e, 0xf9,
  0xa6, 0x2e, 0x19, 0x09, 0xc9, 0xf8, 0xfb, 0x7e, 0x85, 0x07, 0x39, 0x18,
  0x24, 0x57, 0xc7, 0xf6, 0x21, 0x4d, 0xa1, 0x7a, 0x7f, 0x3c, 0x15, 0x62,
  0xb8, 0xc8, 0x32, 0xa9, 0xf0, 0xe4, 0x82, 0xb1, 0x06, 0x02, 0xf7, 0xdd,
  0xb4, 0x7d, 0x17, 0x3d, 0x55, 0xaf, 0xb4, 0x7a, 0x05, 0x6c, 0xf7, 0xfd,
  0x06, 0x80, 0xd9, 0xac, 0x01, 0xa1, 0xfe, 0xf4, 0x53, 0x55, 0xdf, 0x6e,
  0xe6, 0x44, 0x92, 0xd1, 0xc5, 0xd1, 0xc9, 0xdb, 0xa3, 0x0b, 0x97, 0xdf,
  0x6e, 0xb3, 0x09, 0x9e, 0x7f, 0xae, 0xd6, 0xa5, 0xa9, 0x86, 0xcb, 0x28,
  0x6e, 0x63, 0xdd, 0x07, 0xfa, 0x6c, 0xd7, 0x05, 0xd0, 0x2e, 0x12, 0x2e,
  0x71, 0xc5, 0xe7, 0x2f, 0x21, 0x01, 0xe8, 0x52, 0x92, 0xf9, 0xb8, 0xc0,
  0xde, 0x57, 0xd1, 0x9b, 0xc3, 0x67, 0x08, 0x41, 0xbe, 0x4a, 0xf2, 0x45,
  0xce, 0x00, 0xa0, 0x4a, 0x25, 0xd9, 0x8d, 0x6f, 0x6b, 0xcf, 0x07, 0xe3,
  0x9a, 0x8a, 0xa2, 0x1c, 0x43, 0x05, 0x59, 0x5a, 0x23, 0xce, 0x49, 0xef,
  0x69, 0x59, 0x12, 0x43, 0x0b, 0xb4, 0x5c, 0x7b, 0x96, 0x0d, 0x1e, 0x46,
  0x26, 0x7f, 0xf6, 0xc4, 0x73, 0x89, 0x7c, 0xb5, 0x00, 0xd4, 0x90, 0x54,
  0x02, 0x74, 0x24, 0xeb, 0x1f, 0x15, 0xc6, 0x74, 0x20, 0xe7, 0x0a, 0xd2,
  0x62, 0xf3, 0x2d, 0x04, 0xd5, 0x88, 0x15, 0xca, 0xbf, 0xf6, 0x2c, 0x54,
  0xd6, 0x0a, 0x2d, 0x0c, 0x46, 0x8b, 0x07, 0xb6, 0xc7, 0x82, 0x80, 0x7f,
  0xf4, 0x63, 0xf7, 0x28, 0xca, 0x17, 0xa5, 0x73, 0x05, 0x6d, 0x58, 0xff,
  0x82, 0x0a, 0x98, 0x72, 0xef, 0x7a, 0xd1, 0x47, 0x84, 0x8a, 0x60, 0xd9,
  0xfd, 0x1b, 0xcf, 0xab, 0x8a, 0x28, 0x63, 0x01, 0x7a, 0x14, 0x61, 0x4c,
  0x28, 0x5d, 0x5c, 0x07, 0x05, 0x8e, 0x3f, 0x96, 0x4b, 0xf0, 0x2c, 0x41,
  0x64, 0x7e, 0xb0, 0x8f, 0xc6, 0x5e, 0x2a, 0x19, 0xb1, 0x76, 0x8a, 0x84,
  0xaa, 0x0e, 0xe8, 0x64, 0xe8, 0x2b, 0x75, 0x9a, 0xc4, 0xb3, 0xbe, 0x60,
  0xdf, 0xc7, 0xbb, 0x4a, 0x8d, 0x34, 0xdd, 0xec, 0x6a, 0x4e, 0xba, 0xfd,
  0xa4, 0x59, 0xea, 0xca, 0x3f, 0xbd, 0xa7, 0x27, 0x51, 0x6a, 0xc2, 0x31,
  0xb7, 0x21, 0xd5, 0xdf, 0x7f, 0xff, 0x44, 0x69, 0x55, 0xdc, 0x58, 0x52,
  0x0b, 0x97, 0xda, 0x04, 0x42, 0x70, 0x92, 0x4c, 0x12, 0xbf, 0xa3, 0x1f,
  0x3f, 0x55, 0x91, 0xc6, 0xa4, 0x4e, 0xb0, 0x7b, 0xac, 0xc1, 0x14, 0x59,
  0xc7, 0xca, 0xfd, 0xfc, 0xd3, 0x7a, 0xa1, 0xe8, 0x0e, 0x96, 0x56, 0x68,
  0xd2, 0x15, 0xa0, 0xc7, 0xaf, 0x77, 0xe9, 0x5c, 0x23, 0x57, 0xeb, 0x6f,
  0x7f, 0xbc, 0xc6, 0x90, 0xa1, 0x3e, 0x80, 0x23, 0x26, 0x20, 0xff, 0xf8,
  0x27, 0x16, 0x17, 0x98, 0xf7, 0x42, 0xf4, 0x27, 0x08, 0xb3, 0x06, 0x57,
  0x66, 0x67, 0x06, 0x2a, 0xc0, 0xc2, 0x92, 0x51, 0x99, 0x1d, 0x5c, 0x5a,
  0x2f, 0x0d, 0x14, 0x4f, 0xea, 0xc4, 0xf7, 0x21, 0xd4, 0xf3, 0x9a, 0x9d,
  0xb6, 0x5e, 0xce, 0x26, 0x76, 0xe0, 0x23, 0x25, 0xfd, 0xc3, 0xcf, 0x95,
  0x0e, 0xec, 0xda, 0x31, 0x69, 0x6f, 0xdd, 0x0b, 0x9f, 0xec, 0x84, 0xa2,
  0xdf, 0x04, 0xf6, 0x32, 0x49, 0x21, 0x5c, 0xf7, 0xbc, 0x10, 0xc1, 0x31,
  0xf1, 0xe2, 0x2b, 0x22, 0x5e, 0x7e, 0xc4, 0x5d, 0x56, 0xfe, 0xa9, 0xbd,
  0x2a, 0xe3, 0x0a, 0xc5, 0x90, 0xe8, 0xf8, 0xd0, 0x3f, 0xf7, 0xc4, 0xcf,
  0xcd, 0x6a, 0x62, 0xab, 0xd5, 0x6d, 0x13, 0x2f, 0xf9, 0x78, 0xcf, 0x4f,
  0x9e, 0x6a, 0xac, 0x20, 0xf2, 0x78, 0xaf, 0x25, 0x26, 0xac, 0xfe, 0x88,
  0xec, 0xfc, 0x81, 0xab, 0x16, 0x28, 0x11, 0x7f, 0x85, 0xbf, 0x45, 0xfd,
  0xa3, 0x1f, 0x3f, 0xf0, 0xa8, 0x5e, 0x3a, 0x85, 0xbb, 0x2a, 0xfd, 0x6b,
  0x9f, 0x34, 0x0f, 0xb2, 0x49, 0xd5, 0xa5, 0x8a, 0x2b, 0x74, 0x9c, 0x70,
  0x9a, 0xa2, 0x4d, 0xc4, 0xc6, 0xfe, 0xc5, 0xec, 0x26, 0x39, 0x02, 0x05,
  0x8b, 0xbf, 0x04, 0x83, 0xfd, 0xd4, 0xb1, 0x4d, 0x67, 0x33, 0x61, 0xc7,
  0x1d, 0x52, 0x28, 0x43, 0xbc, 0x49, 0x36, 0x71, 0xf0, 0xc6, 0xf3, 0xc2,
  0xf8, 0x06, 0x64, 0xa7, 0xe9, 0x12, 0x5e, 0xce, 0x3d, 0x6b, 0x10, 0x45,
  0x4a, 0x93, 0x31, 0x2d, 0xa2, 0x48, 0xc7, 0xf6, 0x15, 0xed, 0x25, 0xd3,
  0x84, 0xb7, 0x3b, 0xed, 0xd4, 0xa8, 0xbd, 0xb8, 0x5e, 0x8a, 0xd2, 0xea,
  0xa6, 0xd3, 0x52, 0x76, 0xfc, 0xbb, 0xef, 0x02, 0x1b, 0xa9, 0xc3, 0xa3,
  0x25, 0x4a, 0xf7, 0xa0, 0x02, 0x6a, 0x8b, 0x14, 0x4e, 0x8f, 0x25, 0xe5,
  0xca, 0x86, 0x79, 0x32, 0x4d, 0x80, 0x52, 0x23, 0x3a, 0x41, 0x9d, 0xe3,
  0x5b, 0x2c, 0x2b, 0xe2, 0x1a, 0x04, 0x33, 0x3c, 0x51, 0x24, 0xa3, 0x39,
  0xbc, 0xb0, 0xaa, 0xe1, 0xd3, 0x9d, 0xb0, 0xff, 0xee, 0xe2, 0xab, 0xd3,
  0xf3, 0x61, 0xb4, 0x8d, 0x64, 0xc0, 0x8b, 0xf3, 0xe3, 0x2f, 0xde, 0x91,
  0xca, 0xe4, 0x4c, 0xb7, 0x87, 0x31, 0x29, 0x53, 0x53, 0x04, 0x1c, 0x24,
  0xf3, 0x51, 0x92, 0x5f, 0x19, 0x8e, 0x2c, 0xa7, 0xcb, 0x83, 0x09, 0x66,
  0xb9, 0xc0, 0x06, 0xfa, 0xa2, 0x88, 0x66, 0x9a, 0xe6, 0x20, 0xa6, 0x94,
  0xbe, 0xcb, 0xbc, 0x3a, 0x90, 0xd6, 0x72, 0x19, 0x5d, 0x29, 0xce, 0x8b,
  0xaf, 0xf6, 0xdf, 0x7e, 0x3d, 0x34, 0x28, 0xa5, 0x6f, 0xbf, 0xfd, 0x36,
  0xf4, 0x4c, 0xbc, 0xd8, 0xde, 0x66, 0xf0, 0x9c, 0xeb, 0xf8, 0xfe, 0x7e,
  0x50, 0x10, 0xbf, 0x08, 0x0a, 0x6e, 0x7b, 0xb0, 0xce, 0x62, 0x49, 0xd7,
  0x05, 0x7d, 0xbd, 0xbd, 0x58, 0x8e, 0x00, 0x0e, 0xba, 0xbd, 0x2c, 0x15,
  0x1c, 0x9b, 0xdf, 0xde, 0xde, 0xd8, 0x18, 0x1e, 0x1d, 0x45, 0xfb, 0x27,
  0xc3, 0xd3, 0xe0, 0xdd, 0xcd, 0xdd, 0x2d, 0xba, 0x48, 0xaf, 0x92, 0x92,
  0x7e, 0xd9, 0xd8, 0x38, 0xd9, 0xbf, 0x80, 0x9a, 0xf0, 0xcd, 0xd1, 0xf9,
  0xf0, 0xf8, 0xf4, 0x2d, 0xb6, 0x08, 0x99, 0xc5, 0xf1, 0x14, 0xf5, 0x60,
  0x71, 0x73, 0x23, 0x35, 0xeb, 0xce, 0x60, 0xa9, 0x91, 0x31, 0x4f, 0x77,
  0xbd, 0x08, 0x3e, 0xe2, 0x5e, 0xba, 0x43, 0xda, 0x77, 0x6c, 0x75, 0x5a,
  0x4b, 0xc8, 0xea, 0xe6, 0x43, 0xdb, 0x88, 0xbc, 0xa5, 0x40, 0x90, 0x7b,
  0x93, 0x91, 0x04, 0x7e, 0xf4, 0x04, 0x7c, 0x99, 0x63, 0x96, 0x83, 0xc4,
  0xdb, 0xd6, 0x89, 0x0f, 0x8f, 0xdf, 0x9c, 0x91, 0xd0, 0xfc, 0x6e, 0xb8,
  0xff, 0xe5, 0x11, 0x1e, 0xfd, 0x32, 0x29, 0xfd, 0x76, 0x08, 0x7c, 0x36,
  0x3a, 0x79, 0x9b, 0x94, 0xc5, 0x38, 0x5e, 0x20, 0xfc, 0x98, 0xba, 0xe9,
  0x0b, 0xd3, 0x09, 0xda, 0x16, 0xf1, 0xc9, 0xc3, 0xa8, 0xce, 0xf5, 0x79,
  0xc6, 0x38, 0x0d, 0xdb, 0x3d, 0x3f, 0xda, 0x3f, 0x7c, 0x73, 0x64, 0x61,
  0x41, 0x82, 0x2c, 0x46, 0x8d, 0x5e, 0x67, 0xb3, 0x24, 0xb0, 0x1d, 0x82,
  0xf1, 0x63, 0xf1, 0xe9, 0x1b, 0x54, 0xb6, 0x6f, 0xef, 0xce, 0x6f, 0x14,
  0x3f, 0x3b, 0xb8, 0x4c, 0xb7, 0xa5, 0x75, 0xeb, 0x2f, 0x76, 0x4b, 0x62,
  0xf1, 0x35, 0x2a, 0x00, 0x89, 0x1a, 0xc8, 0xfa, 0xe3, 0xa7, 0x3b, 0x3b,
  0x3b, 0x0f, 0xcc, 0x83, 0x2d, 0x75, 0x6a, 0x87, 0xa1, 0xa9, 0xbc, 0xc0,
  0xe3, 0xdb, 0xbe, 0x7d, 0xa3, 0xcc, 0xd0, 0xee, 0x89, 0x3f, 0xa5, 0x60,
  0x3a, 0xf0, 0x63, 0xdb, 0x07, 0x3d, 0xce, 0x32, 0xb7, 0x07, 0x95, 0xe5,
  0xe1, 0x42, 0xd8, 0x69, 0x19, 0x80, 0xef, 0xd8, 0xd0, 0x27, 0x29, 0x9f,
  0xf2, 0x38, 0x5f, 0xd5, 0x9b, 0xc4, 0x37, 0xd4, 0x26, 0x7e, 0x0c, 0xb2,
  0xfc, 0x6a, 0x7b, 0xf6, 0x82, 0xa3, 0x3e, 0xe8, 0xa1, 0xd7, 0x48, 0xa2,
  0xe6, 0x0a, 0xb5, 0x16, 0x40, 0x53, 0x60, 0x69, 0x11, 0xab, 0xf7, 0x88,
  0x71, 0xfd, 0x8c, 0x75, 0x90, 0x3a, 0xce, 0x97, 0x36, 0x73, 0x0b, 0x2a,
  0x68, 0xe9, 0xa4, 0xc0, 0x96, 0xc1, 0x4c, 0x33, 0x20, 0x16, 0x42, 0xbd,
  0xd0, 0xe7, 0x42, 0x24, 0xf4, 0x6b, 0x4e, 0x44, 0x33, 0x28, 0xef, 0x99,
  0x87, 0x02, 0x9d, 0x53, 0xcd, 0xad, 0xcc, 0xb6, 0xc2, 0x82, 0xde, 0xdc,
  0xc3, 0x1d, 0x17, 0x16, 0x73, 0x31, 0x55, 0x1c, 0xf1, 0x8c, 0x86, 0xeb,
  0x7d, 0xf6, 0xfb, 0x4c, 0x41, 0x85, 0xa3, 0x97, 0x47, 0x74, 0x1e, 0x4c,
  0x4a, 0x56, 0x7f, 0xae, 0xec, 0x39, 0xa0, 0x1e, 0xd4, 0x11, 0x6f, 0xf4,
  0xc5, 0xc8, 0x1d, 0x39, 0x87, 0x6e, 0x15, 0xd2, 0x1d, 0xc3, 0xef, 0x0f,
  0x92, 0xfb, 0x18, 0xb9, 0x34, 0xdc, 0x17, 0xed, 0xc9, 0x36, 0xc7, 0x94,
  0x3c, 0xba, 0xa7, 0x83, 0x33, 0x87, 0xe6, 0x4f, 0x2b, 0x70, 0x8b, 0x25,
  0xb8, 0x49, 0x78, 0xf6, 0xa1, 0xd0, 0xf8, 0xc0, 0x60, 0x5e, 0xd0, 0x2a,
  0xe0, 0x8d, 0xff, 0xb9, 0x3d, 0x28, 0x8a, 0xeb, 0xed, 0x74, 0xf2, 0x7e,
  0x52, 0xc4, 0xf4, 0x19, 0xf1, 0xb5, 0xc6, 0xc7, 0x03, 0xfa, 0x30, 0xfa,
  0xd1, 0x35, 0xf5, 0xff, 0x15, 0xe3, 0xf6, 0x69, 0xfc, 0xcf, 0x6d, 0xc0,
  0xc9, 0x30, 0xe0, 0x25, 0xaf, 0xda, 0xc6, 0xe1, 0xe9, 0xb7, 0x6f, 0x4f,
  0x4e, 0xf7, 0x0f, 0xa3, 0x8b, 0x53, 0x52, 0xe6, 0xa0, 0x8a, 0xb7, 0x9c,
  0x43, 0x06, 0xfa, 0x28, 0x33, 0xb9, 0x76, 0x42, 0xb3, 0x5d, 0x63, 0xf4,
  0x52, 0x5c, 0x97, 0x73, 0xdd, 0xaf, 0xcb, 0xd9, 0x87, 0x99, 0xcb, 0x63,
  0x3a, 0xe9, 0xb9, 0xda, 0xa3, 0xcd, 0x6a, 0xa3, 0x89, 0x95, 0xf4, 0xa8,
  0xd6, 0x32, 0x75, 0x91, 0x67, 0x9b, 0xe2, 0x68, 0xf5, 0xb1, 0x79, 0x82,
  0x04, 0x5f, 0x04, 0x72, 0x7f, 0x08, 0x42, 0xad, 0x6e, 0x39, 0xa9, 0x41,
  0x49, 0xf7, 0xf7, 0x56, 0x63, 0x82, 0xa7, 0x6b, 0xa7, 0x84, 0x4a, 0xc8,
  0xf7, 0x3c, 0xeb, 0xea, 0x21, 0x16, 0xf0, 0x1a, 0x3f, 0x3b, 0x86, 0xac,
  0x30, 0x6d, 0x25, 0xcd, 0x6d, 0xc8, 0xec, 0x9d, 0x6d, 0xe9, 0x0e, 0xfd,
  0xd8, 0xd9, 0xf6, 0x5d, 0xe0, 0x9b, 0xf0, 0x4a, 0xd8, 0x76, 0xd6, 0x15,
  0x19, 0xc0, 0xbb, 0xe1, 0xf1, 0xdb, 0x2f, 0xd9, 0x7d, 0xf2, 0xed, 0xe9,
  0xf9, 0xe1, 0x90, 0x9a, 0xc5, 0x5d, 0xb9, 0xc1, 0x0a, 0x36, 0xa3, 0x23,
  0xc9, 0xa8, 0x84, 0x40, 0xd1, 0xf5, 0x9f, 0x58, 0xcc, 0x9e, 0xf8, 0xa4,
  0x02, 0x1e, 0x66, 0x20, 0x30, 0x01, 0x64, 0xa3, 0x9d, 0xfd, 0x30, 0xad,
  0xca, 0xeb, 0x9f, 0xcf, 0x62, 0x20, 0x03, 0x26, 0x03, 0x01, 0xd2, 0x61,
  0x9f, 0xf8, 0x36, 0x12, 0xfb, 0xb7, 0x21, 0xb7, 0x6d, 0x97, 0x19, 0x1f,
  0x64, 0x6e, 0x25, 0xcb, 0x1d, 0x96, 0x62, 0x65, 0x45, 0x70, 0x02, 0x2e,
  0xa7, 0xf1, 0x15, 0x77, 0xd8, 0x3c, 0x1c, 0x41, 0x67, 0xda, 0xfd, 0x63,
  0xbb, 0x04, 0xff, 0xe1, 0xf6, 0x8e, 0x4b, 0x97, 0x80, 0xca, 0xc8, 0x21,
  0x6a, 0xf7, 0x15, 0xf9, 0x85, 0x01, 0xfd, 0xe1, 0x41, 0x06, 0xc0, 0x7a,
  0x1d, 0xf4, 0x51, 0xeb, 0xdc, 0x6c, 0x88, 0xd2, 0xdc, 0x0f, 0x72, 0x57,
  0x44, 0xb4, 0x45, 0x4b, 0x81, 0x9e, 0x58, 0x70, 0xcc, 0x35, 0xf7, 0xe9,
  0xb3, 0x71, 0x64, 0xc9, 0x31, 0x18, 0x1a, 0x3b, 0x84, 0x04, 0x4d, 0xd3,
  0x50, 0x81, 0xaa, 0x03, 0xc4, 0xcd, 0x74, 0x9c, 0x96, 0x1d, 0xe6, 0x95,
  0xac, 0x53, 0x1b, 0xd6, 0x8a, 0xf7, 0xef, 0x14, 0x25, 0x0d, 0x25, 0x26,
  0xde, 0xae, 0xc5, 0xf7, 0x34, 0x55, 0x2e, 0x9b, 0xcd, 0x24, 0x5d, 0xac,
  0x83, 0x94, 0x01, 0xdf, 0x4a, 0xaa, 0xe9, 0x2e, 0x0e, 0xaf, 0x1d, 0x5c,
  0x10, 0xbd, 0x0b, 0x8a, 0x90, 0x44, 0x7c, 0x1b, 0xc3, 0xf5, 0x66, 0x0d,
  0x98, 0x21, 0x79, 0xf4, 0x07, 0x21, 0xe4, 0xbc, 0xa0, 0x27, 0x35, 0x41,
  0x51, 0x53, 0xad, 0x07, 0x4b, 0xc4, 0xc2, 0x41, 0x7d, 0xcb, 0xc2, 0x25,
  0xe2, 0x30, 0x28, 0x69, 0xec, 0xaa, 0x0d, 0xb4, 0x91, 0x92, 0x9e, 0xaa,
  0xf5, 0xb4, 0xf4, 0x61, 0x32, 0x6a, 0x0e, 0xc9, 0xc4, 0xca, 0xe9, 0x4a,
  0x76, 0x3a, 0xd0, 0xff, 0x5a, 0x09, 0x4a, 0x07, 0xf1, 0xa8, 0x8e, 0x79,
  0xae, 0x8c, 0x10, 0x57, 0x88, 0xc1, 0xca, 0x47, 0x31, 0x88, 0x8f, 0x8c,
  0x23, 0x92, 0x5b, 0x40, 0xca, 0x2a, 0x28, 0x54, 0xbc, 0x99, 0x12, 0x0e,
  0xf9, 0x22, 0xfa, 0x22, 0x2e, 0xd2, 0x71, 0x2f, 0x3a, 0x4c, 0x49, 0x1a,
  0x2c, 0x7b, 0x1e, 0x4a, 0xca, 0x01, 0x70, 0x0d, 0xa2, 0x6f, 0xad, 0x50,
  0x0e, 0x31, 0x76, 0x8e, 0xd1, 0x63, 0xdb, 0x8f, 0xcb, 0x8d, 0xd9, 0x10,
  0xb3, 0x9a, 0x1a, 0xc6, 0xc2, 0x3c, 0x14, 0x6e, 0xdb, 0x23, 0xe4, 0xf0,
  0x66, 0xc6, 0xa4, 0x96, 0x56, 0x70, 0x63, 0xe5, 0xde, 0x2e, 0x60, 0xe0,
  0xc1, 0x25, 0xcb, 0xeb, 0x3b, 0x57, 0x10, 0x70, 0x65, 0xb0, 0xfc, 0xb7,
  0xc3, 0xec, 0x30, 0x0c, 0x66, 0x56, 0xc2, 0x0b, 0x8d, 0x6c, 0x30, 0x67,
  0x1c, 0x73, 0x54, 0x23, 0xb9, 0x0d, 0x0e, 0xc1, 0xa5, 0x75, 0xc2, 0x8a,
  0xe8, 0x99, 0x38, 0xbd, 0x38, 0xfa, 0x5d, 0x34, 0x4c, 0x01, 0x27, 0xed,
  0x28, 0x07, 0x84, 0x0a, 0x7f, 0xa4, 0x3a, 0x0a, 0x1a, 0x7b, 0xea, 0xf2,
  0xe1, 0xd4, 0x7e, 0x63, 0x31, 0xe3, 0x52, 0x5a, 0x20, 0x80, 0xc2, 0x61,
  0x9a, 0xbd, 0x4d, 0xe3, 0xc8, 0xd5, 0x72, 0xc3, 0xdc, 0xdf, 0x03, 0x3d,
  0xe7, 0xbd, 0x47, 0x4c, 0x5d, 0xea, 0x8b, 0x0c, 0x5c, 0x83, 0x76, 0x54,
  0xb7, 0x63, 0x75, 0x78, 0x9c, 0xe6, 0x74, 0x8d, 0xe0, 0xac, 0x8d, 0x05,
  0x0e, 0x8c, 0xa3, 0x8d, 0x78, 0xec, 0x50, 0x56, 0xe3, 0x11, 0xd1, 0x15,
  0x2f, 0x17, 0x0e, 0x1e, 0xbb, 0xca, 0x7c, 0x49, 0x42, 0xbb, 0xf2, 0x43,
  0x76, 0xc0, 0x79, 0x67, 0x9c, 0xcc, 0xc3, 0xe8, 0xe5, 0x8a, 0x9c, 0xb4,
  0xc1, 0xa1, 0x3d, 0xd4, 0x2a, 0xdf, 0x87, 0x73, 0xc7, 0x9d, 0x03, 0xe9,
  0x01, 0x91, 0x17, 0xa0, 0xd3, 0x49, 0x34, 0x5b, 0x69, 0x56, 0xa5, 0xf2,
  0x12, 0xe4, 0x32, 0xb0, 0x40, 0xfc, 0xe9, 0xa7, 0x8d, 0xbb, 0xe3, 0xde,
  0x3d, 0xfd, 0x82, 0xbe, 0x0e, 0x04, 0xef, 0x29, 0xdc, 0x42, 0x56, 0x26,
  0xc1, 0x4b, 0xdf, 0x0d, 0xa9, 0x26, 0xcc, 0x9c, 0x92, 0x0e, 0x9d, 0xb9,
  0xa7, 0x65, 0x5f, 0x5c, 0x25, 0x88, 0x0d, 0x11, 0xeb, 0x14, 0x19, 0xb9,
  0x10, 0xe7, 0xe2, 0x1a, 0x39, 0xc7, 0x4e, 0x5e, 0x7d, 0xb0, 0xc1, 0x25,
  0x4b, 0x17, 0xfd, 0x00, 0xf7, 0x32, 0x64, 0x86, 0x61, 0xa6, 0x0d, 0x23,
  0x36, 0x5f, 0x07, 0xe3, 0x70, 0x96, 0x6a, 0x20, 0xcc, 0x0e, 0x01, 0xd8,
  0x71, 0xbd, 0xfe, 0xbb, 0xf5, 0xc3, 0x79, 0xf7, 0x4b, 0x86, 0x33, 0x6e,
  0xf2, 0x45, 0x2d, 0xdb, 0x88, 0xa5, 0x09, 0xca, 0x92, 0x49, 0xb9, 0x57,
  0x64, 0x83, 0x58, 0x31, 0x48, 0xc1, 0x20, 0x97, 0x72, 0x67, 0x20, 0x2d,
  0x24, 0x0a, 0x70, 0x4b, 0x1c, 0x78, 0xd4, 0x9a, 0x78, 0x7a, 0x10, 0x30,
  0x0e, 0xd9, 0x0e, 0x66, 0x3f, 0xa4, 0x73, 0xe5, 0xec, 0x02, 0xd6, 0xb4,
  0x4d, 0x4d, 0x1a, 0xa2, 0x46, 0xcf, 0xf7, 0xdf, 0x7e, 0x79, 0xc4, 0xf4,
  0x0a, 0xb6, 0xe1, 0xb3, 0xcd, 0x90, 0x03, 0xd3, 0xcf, 0xa5, 0x08, 0xf1,
  0x9d, 0x18, 0x13, 0xe8, 0x8d, 0xc9, 0x72, 0x0c, 0x5f, 0xd8, 0x3b, 0x07,
  0x24, 0xc5, 0xd0, 0x58, 0x53, 0xae, 0x5e, 0x0c, 0x96, 0xa1, 0x5e, 0xa7,
  0x8d, 0xc8, 0x04, 0x78, 0xa6, 0x78, 0x5c, 0x2b, 0x99, 0x1a, 0x29, 0x8a,
  0xe5, 0x68, 0x11, 0x6b, 0x2a, 0x46, 0x1c, 0x46, 0xf7, 0xab, 0x34, 0x36,
  0xa8, 0x4c, 0x01, 0xbc, 0x4f, 0x0b, 0xda, 0xdb, 0xcd, 0x9f, 0xf3, 0xcd,
  0x3f, 0x08, 0x55, 0x2b, 0x41, 0x8d, 0xd8, 0xdd, 0xd9, 0xf1, 0x40, 0x04,
  0x3e, 0x4b, 0xa1, 0xb1, 0x8b, 0x79, 0xb4, 0xd3, 0x7f, 0xfe, 0x7c, 0xdd,
  0x76, 0xb9, 0x46, 0x39, 0xda, 0xfc, 0xd9, 0xa3, 0xdb, 0xec, 0xe3, 0xd1,
  0x75, 0x6d, 0xb6, 0xdc, 0x8d, 0x8c, 0x9a, 0xad, 0x1e, 0xbf, 0xc2, 0xb9,
  0x95, 0x55, 0x0e, 0x14, 0xeb, 0x00, 0x3b, 0xe2, 0xe6, 0xee, 0x82, 0xc4,
  0x52, 0x6e, 0x44, 0xee, 0x26, 0x63, 0x5c, 0x0d, 0x13, 0x19, 0x17, 0x70,
  0xfa, 0xa5, 0xce, 0xd5, 0xf0, 0xa8, 0x85, 0x09, 0xae, 0xf9, 0x35, 0x4b,
  0x74, 0xd9, 0x9c, 0x8d, 0x2a, 0xf9, 0x11, 0x49, 0x8f, 0x67, 0x50, 0x09,
  0x48, 0x82, 0xf4, 0x72, 0xe3, 0x3b, 0x2d, 0x45, 0x03, 0x3c, 0x5c, 0x18,
  0x7e, 0x05, 0x17, 0x30, 0x9d, 0x6b, 0x4d, 0x18, 0x5f, 0x55, 0x8d, 0xb8,
  0x57, 0x9b, 0x06, 0xdd, 0xbf, 0x88, 0xfa, 0x01, 0x0b, 0x52, 0x70, 0x02,
  0xf0, 0x9f, 0xd9, 0xca, 0xee, 0x54, 0xed, 0x83, 0xdb, 0x37, 0xd5, 0xbf,
  0x52, 0xae, 0xad, 0xa7, 0x01, 0x54, 0x4c, 0x31, 0x0d, 0x16, 0xd4, 0xd2,
  0xa5, 0x74, 0xc3, 0x2c, 0xad, 0xc6, 0x70, 0x1e, 0x37, 0x94, 0x78, 0x7d,
  0xe5, 0x29, 0x4c, 0xb2, 0x67, 0x12, 0x61, 0x5d, 0x39, 0x51, 0xa4, 0x26,
  0x3c, 0xc8, 0xe7, 0x25, 0x7b, 0xb1, 0x11, 0xfd, 0xab, 0x83, 0x7b, 0x60,
  0x58, 0x38, 0x8d, 0x56, 0x2f, 0xaf, 0x36, 0xcc, 0xe0, 0x26, 0x41, 0xab,
  0xcd, 0x25, 0xe2, 0x96, 0x64, 0x10, 0x71, 0x7b, 0xc7, 0xd2, 0x92, 0xad,
  0x4c, 0x0b, 0xbd, 0x63, 0xcf, 0x15, 0xbd, 0xc2, 0xc5, 0x92, 0x5a, 0xa6,
  0x35, 0x64, 0x6a, 0x66, 0x14, 0x5a, 0x79, 0xda, 0x02, 0x5c, 0x37, 0x22,
  0x0d, 0x55, 0x66, 0x68, 0x0b, 0x10, 0x11, 0xc3, 0xba, 0x31, 0x5b, 0xbb,
  0x61, 0x5f, 0xed, 0xa5, 0xe6, 0x6f, 0x33, 0x44, 0xf8, 0x31, 0x07, 0x9b,
  0xc3, 0x68, 0xeb, 0x13, 0xe2, 0xf3, 0xe5, 0x5c, 0x66, 0xc1, 0xd9, 0xe5,
  0x34, 0xf8, 0xb8, 0xb8, 0x66, 0x17, 0x9e, 0xab, 0x68, 0xd2, 0xb4, 0x2a,
  0x84, 0x49, 0xdd, 0xc4, 0xe4, 0x85, 0xc3, 0x33, 0x43, 0xad, 0x2c, 0x45,
  0x75, 0x05, 0x02, 0x51, 0xf8, 0xb1, 0xc7, 0x00, 0xdc, 0x62, 0xfd, 0x39,
  0x68, 0x54, 0x2e, 0xaa, 0x51, 0x9f, 0xd7, 0x16, 0x38, 0xca, 0x8b, 0xdb,
  0x92, 0x5b, 0x98, 0xc1, 0xff, 0xb8, 0xdc, 0x0b, 0x67, 0xd0, 0xd5, 0x96,
  0x90, 0xc5, 0x30, 0x2e, 0xa1, 0x25, 0x19, 0x75, 0xc6, 0x61, 0x35, 0xcd,
  0x88, 0x75, 0x00, 0x05, 0xec, 0x84, 0x50, 0x2b, 0xd1, 0x5a, 0x40, 0xa1,
  0x95, 0x18, 0x22, 0x36, 0x6f, 0x02, 0xfb, 0x33, 0x93, 0x3e, 0x79, 0x86,
  0x32, 0x40, 0x89, 0x25, 0xe7, 0x02, 0x5d, 0xa7, 0xc3, 0x0b, 0xc8, 0x87,
  0x2c, 0xcf, 0x9a, 0x08, 0xf3, 0xcd, 0xd1, 0xf9, 0x17, 0xa7, 0xc3, 0xa3,
  0x68, 0x3b, 0x3a, 0x3c, 0xfa, 0xe2, 0x1d, 0xd8, 0x06, 0x76, 0xcc, 0xb9,
  0x63, 0x0a, 0x05, 0x35, 0xe4, 0x7c, 0x01, 0x27, 0xde, 0x49, 0xd2, 0x53,
  0xcf, 0x28, 0x43, 0x23, 0x46, 0x54, 0x00, 0x44, 0xc9, 0x57, 0x6c, 0x74,
  0xca, 0xb1, 0x3a, 0x3e, 0xa9, 0x1f, 0x62, 0xdf, 0x1c, 0x80, 0x7e, 0xa5,
  0x21, 0x68, 0x1b, 0xca, 0x5d, 0xf1, 0xc2, 0x8b, 0x75, 0xb7, 0xa2, 0x42,
  0xea, 0xd1, 0xf0, 0x78, 0xf6, 0x86, 0x5c, 0x3f, 0x08, 0xca, 0xbe, 0x29,
  0x58, 0xe4, 0x34, 0x93, 0x8b, 0x0b, 0x99, 0x02, 0x5a, 0xd6, 0x1c, 0x49,
  0x6b, 0x5c, 0x4c, 0x47, 0xf1, 0xb8, 0x14, 0x45, 0xbe, 0x10, 0x82, 0x23,
  0x8e, 0x23, 0xf1, 0xdc, 0x56, 0x9d, 0x96, 0x19, 0x52, 0x91, 0x48, 0x4e,
  0xa2, 0x5c, 0x9c, 0x6a, 0x03, 0x15, 0x7f, 0xb8, 0x02, 0x4d, 0x6d, 0xe2,
  0x48, 0x20, 0x2b, 0xd8, 0x95, 0xe8, 0xde, 0x30, 0xb0, 0x75, 0x7a, 0x75,
  0x8c, 0x8a, 0x9e, 0xbc, 0xf2, 0x5b, 0x83, 0x3a, 0xe9, 0xdc, 0xae, 0x67,
  0x0c, 0x17, 0x32, 0x53, 0xa4, 0x8f, 0xc9, 0x5d, 0x1c, 0xe6, 0x8f, 0x87,
  0xc9, 0x0f, 0x70, 0xfb, 0x3b, 0x6c, 0x19, 0x39, 0x4f, 0x08, 0xbb, 0x09,
  0x84, 0xb7, 0xf5, 0xf0, 0xec, 0xa6, 0xe6, 0x6a, 0xb0, 0x40, 0x3d, 0xed,
  0x11, 0x4b, 0x91, 0x5d, 0xf1, 0x96, 0xb2, 0xee, 0x1e, 0xd5, 0xcb, 0x79,
  0xe9, 0x19, 0x94, 0xd6, 0x05, 0x99, 0xbd, 0xbc, 0x2f, 0x43, 0x0b, 0x07,
  0x71, 0xc9, 0x8d, 0xc3, 0xa3, 0x8b, 0xfd, 0xe3, 0x93, 0xa3, 0xc3, 0xe8,
  0xf8, 0xed, 0xeb, 0xd3, 0xf3, 0x37, 0xfb, 0x17, 0x6a, 0x82, 0x3f, 0x74,
  0xfa, 0x95, 0x43, 0x10, 0x37, 0x5c, 0xfd, 0x40, 0xf7, 0x62, 0x1a, 0xa6,
  0x6d, 0xbc, 0x52, 0x50, 0x0d, 0x59, 0x87, 0xa4, 0xb2, 0x08, 0x1b, 0x91,
  0x9a, 0xee, 0x3d, 0x26, 0x38, 0xee, 0xe6, 0x6d, 0x67, 0x6e, 0x1d, 0xd8,
  0x7a, 0x9a, 0x76, 0xc4, 0xf5, 0xc4, 0x1f, 0x6c, 0xca, 0xd5, 0xc5, 0x90,
  0x7b, 0x8a, 0xa1, 0x62, 0x39, 0xc8, 0x9e, 0x89, 0xb2, 0x7f, 0x8c, 0xfc,
  0x35, 0x4e, 0xbd, 0xd7, 0xfa, 0x95, 0xc7, 0xa5, 0x2b, 0xd2, 0x03, 0x7a,
  0x41, 0x3b, 0x0e, 0x91, 0x93, 0x49, 0x90, 0x2b, 0xe4, 0x05, 0x6d, 0xba,
  0x74, 0x07, 0x03, 0xfd, 0x96, 0x58, 0x1e, 0xfe, 0x24, 0xdc, 0x60, 0x24,
  0x76, 0x6f, 0xc0, 0xdb, 0x59, 0xaa, 0xe7, 0xe8, 0xbe, 0x4c, 0xe6, 0xae,
  0x34, 0xec, 0x6b, 0x6d, 0xc4, 0x73, 0x51, 0xb3, 0xa3, 0x29, 0x0a, 0x54,
  0xd8, 0xd4, 0xa6, 0x33, 0xd1, 0x92, 0xd4, 0xd2, 0x3f, 0x26, 0x8a, 0xc5,
  0x7c, 0xb0, 0x16, 0x80, 0xf3, 0xc3, 0xcf, 0xb9, 0x4f, 0xdd, 0x55, 0x87,
  0xb0, 0x17, 0xb6, 0x83, 0x12, 0x04, 0x7a, 0xdc, 0xfc, 0xc1, 0x2d, 0x8c,
  0xd4, 0x0e, 0xe9, 0x21, 0x94, 0x87, 0xea, 0x6b, 0xf7, 0x56, 0x59, 0x16,
  0xc2, 0x91, 0x6d, 0xa1, 0x08, 0x4e, 0x2c, 0x10, 0x8c, 0x88, 0x51, 0xb1,
  0x30, 0x85, 0x35, 0x90, 0x79, 0x30, 0x81, 0x97, 0x66, 0xb4, 0x83, 0x06,
  0xe0, 0xed, 0x6c, 0xae, 0x5e, 0x42, 0xa3, 0xf4, 0xa3, 0xab, 0xd5, 0x31,
  0x74, 0xcf, 0xf2, 0x4a, 0x06, 0x2f, 0xc4, 0xde, 0x2b, 0xc5, 0xeb, 0xbf,
  0x69, 0x48, 0xa2, 0xa0, 0x59, 0x6d, 0x50, 0x4d, 0xab, 0x4d, 0x33, 0x61,
  0x65, 0x52, 0xe1, 0x8b, 0x55, 0x3f, 0x4e, 0xc8, 0xea, 0xad, 0x6b, 0x1e,
  0xfd, 0xa4, 0x6d, 0x04, 0xca, 0xc6, 0xb9, 0x6c, 0x17, 0x51, 0x15, 0x70,
  0x52, 0x63, 0xf6, 0x67, 0x20, 0x23, 0x7b, 0x43, 0x93, 0xae, 0x95, 0x55,
  0xb2, 0xe9, 0x2a, 0xcc, 0xb5, 0x1b, 0xa3, 0xdc, 0x03, 0x0a, 0x58, 0x68,
  0x69, 0x97, 0x20, 0x54, 0x35, 0x7a, 0xc3, 0xb6, 0x7a, 0x2d, 0xb2, 0x0a,
  0xae, 0x37, 0xdf, 0x30, 0x30, 0x29, 0x7b, 0x69, 0xac, 0x02, 0x28, 0xb3,
  0x7f, 0xc9, 0xb9, 0x64, 0x2e, 0x0f, 0x67, 0x0f, 0x0a, 0xba, 0xb2, 0x0d,
  0x01, 0xba, 0xb0, 0x5c, 0x1a, 0x4c, 0x02, 0x3c, 0x57, 0x87, 0xda, 0xc2,
  0xb7, 0x8f, 0x2f, 0x17, 0xd8, 0x97, 0xd4, 0xf4, 0x18, 0x49, 0x2b, 0x76,
  0x28, 0x24, 0x76, 0xc6, 0xb5, 0xc2, 0x97, 0x1d, 0x72, 0x41, 0xf3, 0x29,
  0x07, 0x42, 0x68, 0x50, 0xce, 0x59, 0x56, 0xc8, 0x79, 0x63, 0x29, 0xbb,
  0xe3, 0x01, 0x97, 0x3b, 0x8b, 0x6b, 0xea, 0xa3, 0x13, 0x5d, 0x41, 0x4f,
  0x19, 0xd1, 0xd0, 0x1b, 0x1c, 0x74, 0x22, 0x8f, 0xbf, 0x3a, 0x8f, 0x2f,
  0xe3, 0x64, 0xfa, 0xfb, 0xbd, 0x9d, 0x61, 0x7c, 0xb5, 0x9c, 0xc6, 0x7f,
  0xe0, 0x17, 0x5f, 0x3d, 0x79, 0xb2, 0xb7, 0xf3, 0xc9, 0xa7, 0x3b, 0x9d,
  0xc0, 0x90, 0x5e, 0xf3, 0xc2, 0xb1, 0x53, 0x85, 0xcb, 0x30, 0x82, 0xf1,
  0x72, 0x3f, 0x83, 0xf1, 0x55, 0x8a, 0x6e, 0xbe, 0x82, 0xf4, 0xa2, 0x6b,
  0x10, 0x73, 0x84, 0xb8, 0xf0, 0x49, 0x2d, 0xc5, 0x40, 0x57, 0x2e, 0xd1,
  0xf5, 0x47, 0xbb, 0x2f, 0x84, 0x95, 0x5d, 0xb1, 0x4d, 0x25, 0x16, 0x8a,
  0x8d, 0x5e, 0xa6, 0x73, 0xba, 0x82, 0x3e, 0x8b, 0xca, 0xf8, 0xca, 0xd1,
  0x2a, 0xb7, 0xe0, 0x2a, 0x34, 0x9a, 0x25, 0xf2, 0x32, 0xe5, 0xd2, 0x73,
  0x03, 0x14, 0x62, 0x66, 0x5c, 0x21, 0x96, 0x7c, 0x16, 0x49, 0x3e, 0x95,
  0xac, 0xb1, 0x78, 0x66, 0x11, 0x5d, 0x78, 0x1f, 0xae, 0xca, 0xc1, 0x62,
  0xea, 0xea, 0x51, 0xb2, 0xf6, 0x95, 0x7a, 0x82, 0x9b, 0x2e, 0x0a, 0x5f,
  0x9a, 0x40, 0xee, 0x1b, 0x01, 0x5c, 0x62, 0xc4, 0xa2, 0x98, 0x16, 0x8b,
  0x61, 0x97, 0x3b, 0x3c, 0xab, 0x9e, 0xc3, 0x38, 0xef, 0x4f, 0x6c, 0xa6,
  0x03, 0xfe, 0x9d, 0x0b, 0xc3, 0xc4, 0x02, 0xe0, 0xda, 0x59, 0x48, 0xfa,
  0x81, 0xc3, 0xd5, 0xd6, 0x94, 0xc1, 0xca, 0xbc, 0x62, 0xef, 0x70, 0x8f,
  0x5e, 0x9a, 0x82, 0xbb, 0xfb, 0xd9, 0x2b, 0x26, 0x88, 0xdd, 0xcf, 0xfe,
  0xe0, 0x3e, 0xdb, 0xd3, 0xcf, 0xf6, 0x3e, 0xfb, 0xc3, 0x60, 0xc0, 0xe3,
  0x03, 0x85, 0x74, 0xed, 0xeb, 0xae, 0xe6, 0x34, 0xc5, 0x7a, 0x84, 0xe5,
  0x2f, 0x87, 0xae, 0x21, 0x7b, 0xdd, 0xb1, 0x9e, 0xc3, 0x55, 0xee, 0xa9,
  0xed, 0xd3, 0xf1, 0xad, 0xd4, 0x00, 0x1c, 0x19, 0x09, 0xad, 0x68, 0x5b,
  0x74, 0x67, 0xde, 0xe2, 0x76, 0x0a, 0x07, 0x4b, 0x10, 0x47, 0x7f, 0x04,
  0xa5, 0xfe, 0x71, 0x83, 0xf1, 0x63, 0xe0, 0xf0, 0xa2, 0xed, 0xe0, 0x0a,
  0x41, 0x91, 0x91, 0xad, 0x14, 0x52, 0x15, 0x54, 0x24, 0xb4, 0x8c, 0x10,
  0x2e, 0x5c, 0x82, 0x01, 0xae, 0xf4, 0x9f, 0x14, 0xda, 0x43, 0x36, 0x1c,
  0xfc, 0x8c, 0x83, 0xa5, 0x25, 0xe9, 0x40, 0x20, 0xa4, 0x75, 0xb3, 0x7e,
  0xff, 0xdd, 0x77, 0x2a, 0x4f, 0xd1, 0x2f, 0x3a, 0xee, 0x6b, 0xe2, 0x44,
  0x13, 0x62, 0x6e, 0x00, 0xc9, 0xa6, 0xc6, 0x05, 0x0c, 0x5c, 0x6f, 0xfc,
  0x4b, 0x9d, 0xa7, 0x34, 0x42, 0x1b, 0x2b, 0x15, 0xfa, 0x30, 0x32, 0x5e,
  0xd2, 0x23, 0x61, 0x62, 0x4c, 0x99, 0x9b, 0xec, 0x8a, 0xf1, 0x8e, 0xe8,
  0x90, 0xf0, 0xb1, 0x73, 0xbc, 0xe9, 0x4c, 0xfb, 0xd4, 0x98, 0xa9, 0xc0,
  0xba, 0x91, 0x4c, 0xb1, 0x22, 0xe4, 0xbc, 0xea, 0xc8, 0x83, 0x57, 0x69,
  0x47, 0x8d, 0x93, 0xf2, 0x49, 0xc7, 0xa7, 0xa8, 0xc9, 0x6e, 0xf0, 0x96,
  0xbd, 0x12, 0xc9, 0x29, 0xfd, 0x7b, 0xf2, 0x6a, 0x77, 0xa7, 0xfd, 0x09,
  0x28, 0x46, 0x5c, 0xd9, 0xf8, 0x95, 0x37, 0xee, 0x3e, 0xf4, 0x7c, 0x3a,
  0x91, 0xa7, 0xb5, 0xbe, 0x0f, 0xe3, 0x9a, 0xbf, 0xea, 0x8c, 0x70, 0xbf,
  0xe2, 0xff, 0xd7, 0x8c, 0x83, 0x43, 0x4e, 0xf4, 0xd9, 0x62, 0x39, 0x9a,
  0xa5, 0x95, 0x01, 0x6f, 0x63, 0x82, 0x9f, 0xb1, 0x39, 0x25, 0x71, 0xb4,
  0xc1, 0xe5, 0xdf, 0x44, 0xf4, 0xeb, 0x5e, 0x66, 0xd9, 0x28, 0xce, 0xbb,
  0x6a, 0x00, 0xb4, 0x71, 0x76, 0x77, 0xf7, 0x9e, 0x3c, 0x7d, 0xd6, 0x1d,
  0xa8, 0x98, 0xc6, 0x0c, 0x82, 0x75, 0xb4, 0x54, 0x75, 0x19, 0x69, 0x22,
  0x96, 0xe3, 0x19, 0xd6, 0x8c, 0x6d, 0x35, 0x94, 0x83, 0x87, 0xa1, 0xbb,
  0x57, 0xd2, 0xdb, 0x1f, 0xd0, 0xcf, 0x2b, 0xee, 0xe2, 0x0f, 0xe9, 0xe4,
  0x95, 0x9b, 0xe1, 0x1f, 0x30, 0x97, 0x57, 0x3a, 0x09, 0xda, 0x57, 0x8b,
  0xd3, 0x2d, 0x42, 0x24, 0xde, 0x0f, 0x6d, 0xae, 0x6d, 0xe2, 0x06, 0x4f,
  0x9a, 0x3d, 0x0d, 0xfd, 0x89, 0x58, 0x1d, 0x59, 0x58, 0xf5, 0x71, 0xaa,
  0xdb, 0xf7, 0x7d, 0x6a, 0xa5, 0x8f, 0x56, 0xfa, 0x9e, 0x5d, 0x47, 0x33,
  0x04, 0xa5, 0x63, 0x23, 0x7a, 0x1a, 0xac, 0x3c, 0x65, 0x3b, 0x87, 0x0a,
  0x02, 0x59, 0xc6, 0xb1, 0xaf, 0x07, 0x5f, 0x1e, 0x77, 0xd5, 0x41, 0x26,
  0x9a, 0x5b, 0xaf, 0xcd, 0xb0, 0xe6, 0x7c, 0xca, 0x9a, 0x69, 0xbc, 0x61,
  0xd5, 0x69, 0x63, 0xf8, 0x7b, 0xd0, 0xaf, 0xe4, 0x15, 0xa0, 0xfa, 0xb5,
  0xdc, 0x39, 0x74, 0x2d, 0x32, 0x52, 0x09, 0x40, 0x0d, 0x83, 0x66, 0x18,
  0xbb, 0x41, 0x1c, 0x3f, 0xac, 0x1b, 0x7b, 0x98, 0xc4, 0xfe, 0x6b, 0x67,
  0xc9, 0x76, 0x41, 0xb0, 0xfa, 0x28, 0x7d, 0x25, 0xdc, 0xc4, 0x18, 0x44,
  0xc7, 0x55, 0x7d, 0x10, 0x4a, 0x08, 0x79, 0x07, 0xdb, 0xe1, 0x47, 0x49,
  0xa5, 0x96, 0x80, 0x88, 0x85, 0xe0, 0x9e, 0x2f, 0x5d, 0x99, 0x80, 0xcf,
  0x22, 0x86, 0x3d, 0x96, 0xb7, 0x34, 0xcc, 0xb5, 0x52, 0x6a, 0x8d, 0x5f,
  0x52, 0xed, 0xc0, 0x59, 0xed, 0x03, 0xaf, 0x99, 0x8a, 0x05, 0xd2, 0x82,
  0x4c, 0x74, 0xb4, 0x52, 0x4b, 0x00, 0x5a, 0xe8, 0xfe, 0x99, 0x0f, 0xc1,
  0x4b, 0x6c, 0x03, 0x7f, 0xfd, 0x59, 0x57, 0xcc, 0x77, 0x95, 0x52, 0xc9,
  0x35, 0xaf, 0x80, 0x10, 0x68, 0x38, 0x9f, 0xec, 0xd2, 0x41, 0x36, 0x88,
  0x2c, 0x86, 0x1c, 0x36, 0x46, 0xd5, 0x27, 0x59, 0x6a, 0x3a, 0xd1, 0x4a,
  0x26, 0x2a, 0x0b, 0xf5, 0xb4, 0xf1, 0x04, 0x61, 0xbf, 0x90, 0x1d, 0xbb,
  0x08, 0x4f, 0xe0, 0xf7, 0xba, 0x3e, 0x33, 0x3a, 0x63, 0xb5, 0x0a, 0xe6,
  0x82, 0xc4, 0xaa, 0x7c, 0x6c, 0x68, 0xbe, 0xbf, 0x97, 0xe5, 0xc3, 0x89,
  0x15, 0x81, 0xe8, 0xe0, 0x43, 0x81, 0x25, 0xc5, 0xb1, 0x71, 0x44, 0x5e,
  0x23, 0xce, 0x5e, 0x3b, 0x7d, 0x85, 0xe5, 0xde, 0x1d, 0x5c, 0xa5, 0x97,
  0xb2, 0x18, 0xc4, 0x22, 0xaf, 0x92, 0x6d, 0xfa, 0x13, 0x75, 0x84, 0xf7,
  0x20, 0x93, 0xe1, 0x97, 0x27, 0xec, 0x37, 0x0d, 0x6f, 0xfe, 0xe0, 0x6c,
  0xb8, 0x73, 0x81, 0x5f, 0x52, 0x77, 0xe3, 0x2b, 0x36, 0xa1, 0x8e, 0x92,
  0xc9, 0xbc, 0x09, 0x4e, 0x18, 0x96, 0xe7, 0x96, 0x8a, 0xdf, 0x90, 0x1a,
  0x0a, 0x1f, 0x04, 0xa4, 0x4e, 0x31, 0x15, 0xd3, 0x21, 0x75, 0xa7, 0x6a,
  0x31, 0x41, 0x94, 0x1f, 0xdf, 0xab, 0xc9, 0xdd, 0x56, 0x2f, 0x0c, 0xad,
  0xb0, 0xc2, 0x57, 0xae, 0x32, 0x1f, 0x67, 0xf4, 0xa1, 0xfb, 0x4d, 0x2d,
  0x27, 0x11, 0x04, 0xe3, 0xf3, 0x36, 0xa7, 0xf5, 0x1d, 0xac, 0x56, 0x64,
  0x10, 0x87, 0x7b, 0x5a, 0x94, 0x5b, 0x5c, 0x25, 0x79, 0x5a, 0xb0, 0xaa,
  0xae, 0xe5, 0xb7, 0xfd, 0xba, 0x5b, 0x26, 0x3c, 0x77, 0xd5, 0x45, 0x89,
  0x88, 0x6d, 0xf6, 0x65, 0x08, 0x6f, 0x3b, 0x9a, 0x09, 0x4c, 0x2e, 0x93,
  0xed, 0xb4, 0x2f, 0xf7, 0xa5, 0x0a, 0x41, 0xfd, 0xd7, 0x83, 0xe8, 0x84,
  0x03, 0x83, 0x8a, 0x58, 0x12, 0x17, 0xed, 0x4e, 0x35, 0x0a, 0x20, 0x72,
  0x11, 0xa9, 0x7b, 0x43, 0x6a, 0x63, 0x20, 0x57, 0xcc, 0xc8, 0x88, 0xb1,
  0xaa, 0xbc, 0x9e, 0x29, 0x12, 0x85, 0x4a, 0x20, 0x3d, 0xb6, 0x40, 0xbb,
  0xe7, 0xb8, 0x52, 0x0a, 0x3f, 0xc5, 0x65, 0x79, 0x3d, 0x91, 0x06, 0x8d,
  0xb8, 0x2a, 0xbc, 0x10, 0x39, 0x03, 0x56, 0xee, 0x08, 0x5f, 0x52, 0xd2,
  0x12, 0xb1, 0xb3, 0x68, 0x95, 0x3d, 0xf1, 0xbf, 0x50, 0x6b, 0x4c, 0x59,
  0x98, 0x3b, 0x48, 0xa7, 0xc3, 0x9a, 0xe2, 0x34, 0x71, 0xfa, 0xb4, 0xa2,
  0x55, 0x6a, 0xcc, 0x9d, 0xc2, 0x02, 0x88, 0x80, 0xe1, 0xb1, 0xd7, 0x30,
  0x48, 0x8c, 0x2b, 0xbe, 0xa5, 0x5f, 0x70, 0xc9, 0x8f, 0x72, 0xda, 0x69,
  0x04, 0xbb, 0x62, 0x65, 0xa4, 0x98, 0xaf, 0xd6, 0xbb, 0x15, 0xc5, 0xe4,
  0xcd, 0x49, 0x64, 0x09, 0xa0, 0x97, 0x5e, 0x38, 0xb4, 0xa8, 0x09, 0x9e,
  0xa2, 0x1a, 0x43, 0x44, 0x02, 0xd2, 0xa7, 0xe4, 0x66, 0x93, 0xb5, 0x45,
  0x0e, 0x49, 0x84, 0xc5, 0xa9, 0x1c, 0xd3, 0xe0, 0x09, 0x79, 0x15, 0xb4,
  0x43, 0xa4, 0xd1, 0xc5, 0x12, 0x74, 0x7b, 0x51, 0x17, 0x43, 0xc5, 0x17,
  0x5d, 0x5e, 0x4f, 0xfe, 0x38, 0x58, 0xbe, 0xee, 0xa0, 0xe5, 0xe4, 0xe1,
  0x99, 0x57, 0x9f, 0x57, 0x56, 0x89, 0x3f, 0xb7, 0xa6, 0x5e, 0x49, 0x2c,
  0x61, 0x43, 0xca, 0xb6, 0x77, 0x83, 0xf6, 0x5f, 0x1d, 0x50, 0x2b, 0x52,
  0x8b, 0x44, 0xf6, 0x84, 0x05, 0x6a, 0xf7, 0x59, 0xca, 0x91, 0xee, 0x8d,
  0x86, 0x3e, 0x7c, 0x72, 0x2f, 0x8c, 0xfd, 0xb8, 0xf0, 0x0c, 0xe1, 0x68,
  0x42, 0x02, 0xc6, 0x6d, 0x69, 0x37, 0x53, 0xd1, 0xf4, 0xee, 0x32, 0xb6,
  0x2b, 0x30, 0x9f, 0xd9, 0x1d, 0x70, 0x14, 0x74, 0xbd, 0x34, 0x7a, 0x1a,
  0xa8, 0xeb, 0x1d, 0x5e, 0xd0, 0x8e, 0xd9, 0x49, 0x9c, 0x12, 0x6f, 0xab,
  0xdc, 0x34, 0x06, 0xd3, 0xd4, 0xb5, 0xc6, 0x38, 0xf1, 0xab, 0x49, 0x76,
  0x05, 0x76, 0xd5, 0xa3, 0x9b, 0x15, 0x3f, 0x3b, 0x11, 0x3f, 0xbe, 0xa7,
  0xfd, 0xca, 0x98, 0xf9, 0xb8, 0x88, 0xe8, 0x6e, 0x7f, 0x6b, 0x04, 0x49,
  0xd4, 0xb2, 0x25, 0x93, 0x6c, 0xac, 0xcd, 0xbb, 0xd6, 0x65, 0x4f, 0xa8,
  0x0b, 0xf7, 0x85, 0xef, 0x2e, 0x58, 0xa1, 0x58, 0xdb, 0x96, 0xc2, 0x30,
  0xd3, 0xb4, 0x94, 0x3b, 0x3c, 0xb2, 0xea, 0xb7, 0x6c, 0xd8, 0x02, 0xee,
  0xb6, 0x5c, 0x58, 0x53, 0x0d, 0xdb, 0xed, 0x7e, 0xde, 0x95, 0x68, 0xb0,
  0xee, 0xcb, 0x2e, 0xb3, 0x2e, 0x30, 0x24, 0x43, 0x9e, 0xd4, 0x5b, 0xa9,
  0x2b, 0xd7, 0x61, 0x5f, 0x84, 0x06, 0x2d, 0xda, 0xe3, 0x4f, 0x09, 0xdf,
  0xc7, 0x5e, 0x7b, 0x0c, 0xa3, 0x1b, 0xd8, 0x3a, 0xe0, 0xcb, 0xd5, 0x00,
  0x78, 0x63, 0x54, 0x8a, 0x4f, 0x55, 0x6f, 0x5b, 0x96, 0xc7, 0x38, 0x99,
  0xb0, 0x80, 0xc7, 0x50, 0xcc, 0x9b, 0xcb, 0xf9, 0x02, 0xa9, 0x23, 0xe3,
  0x52, 0x50, 0x57, 0xf9, 0x40, 0x0d, 0xa2, 0x77, 0x73, 0x01, 0xb8, 0x4a,
  0xa0, 0x23, 0x87, 0x0e, 0xdf, 0x9e, 0x73, 0x5c, 0xd3, 0x4a, 0x05, 0xa7,
  0xb7, 0x3a, 0x60, 0xb1, 0x89, 0x88, 0xf1, 0x5a, 0xfb, 0xc5, 0xfd, 0x9a,
  0xc3, 0x9d, 0xae, 0xc6, 0x69, 0x16, 0x07, 0x5c, 0x52, 0xa1, 0x72, 0x21,
  0xb8, 0xe7, 0x8e, 0x5e, 0x1f, 0x9d, 0x9f, 0x1f, 0x9d, 0x63, 0xbd, 0xf7,
  0x2b, 0xd0, 0xd5, 0x8c, 0x18, 0x20, 0x69, 0x3e, 0x06, 0xc1, 0x64, 0x61,
  0x39, 0xcd, 0x72, 0x82, 0xc2, 0x0e, 0x15, 0x33, 0x65, 0x23, 0x32, 0x47,
  0xad, 0x64, 0xd2, 0x8a, 0x59, 0x98, 0x6d, 0x8a, 0x1c, 0x94, 0xe5, 0xec,
  0xf7, 0x53, 0xdc, 0x2d, 0x6c, 0x75, 0xac, 0x48, 0x14, 0x1b, 0x91, 0xbd,
  0x9a, 0x4b, 0x45, 0x03, 0xb9, 0xaf, 0x4d, 0x81, 0x0c, 0x84, 0xd3, 0x81,
  0xc6, 0xd1, 0x24, 0xea, 0x7e, 0x9d, 0x3a, 0x9b, 0x04, 0xcf, 0xf7, 0x12,
  0xa7, 0x14, 0xfa, 0x12, 0xaf, 0x44, 0x51, 0x2e, 0x17, 0xe9, 0xc4, 0x99,
  0x78, 0xe9, 0x73, 0x12, 0xfa, 0x22, 0x39, 0xe7, 0x85, 0x8d, 0x98, 0xbd,
  0x89, 0x66, 0x80, 0x08, 0x2d, 0x6c, 0x92, 0xba, 0xea, 0xed, 0x63, 0x1c,
  0x09, 0x2d, 0xc5, 0xa2, 0x14, 0x5d, 0x96, 0x59, 0x6c, 0x83, 0x19, 0x25,
  0x6c, 0x5a, 0x04, 0xbf, 0x30, 0x67, 0x77, 0xc8, 0x1b, 0x60, 0xbf, 0x9a,
  0xf9, 0x68, 0x34, 0x5f, 0xc5, 0x47, 0x02, 0xc6, 0x73, 0x7f, 0x6f, 0x70,
  0x78, 0xa7, 0x8f, 0x14, 0x13, 0xaf, 0x38, 0xcd, 0x5a, 0x57, 0x48, 0x35,
  0x5f, 0xd2, 0xf7, 0x06, 0x08, 0xbc, 0x3a, 0x3a, 0x8f, 0xf6, 0xbf, 0x04,
  0xa6, 0xca, 0xbf, 0xb6, 0xad, 0x78, 0x4e, 0xef, 0x05, 0xdb, 0x54, 0xcd,
  0xf7, 0x4b, 0x26, 0x21, 0x3c, 0xf7, 0xa0, 0xb2, 0xa3, 0xa9, 0x16, 0xa2,
  0x08, 0x2e, 0xf7, 0xea, 0xde, 0x6d, 0x44, 0x1f, 0xdc, 0xbd, 0xc7, 0xec,
  0x1d, 0x4e, 0x56, 0xb8, 0x7b, 0x92, 0x28, 0x2c, 0xfe, 0x07, 0xdb, 0x13,
  0x1d, 0x7d, 0xd1, 0x50, 0x32, 0x65, 0x77, 0xf6, 0xa3, 0xee, 0x9b, 0xec,
  0xef, 0x24, 0x06, 0xc4, 0xdb, 0x4f, 0x06, 0x3b, 0xd1, 0xe6, 0xb7, 0xe9,
  0xfc, 0xf9, 0xb3, 0x3f, 0x47, 0xc7, 0x5b, 0xdd, 0x4a, 0x88, 0x9d, 0xc0,
  0x9e, 0x8e, 0xe2, 0xf9, 0x8d, 0xdb, 0xaa, 0x53, 0x3e, 0xce, 0x12, 0x74,
  0x61, 0x70, 0x7f, 0x2f, 0x78, 0xef, 0xd7, 0xb6, 0x28, 0xa5, 0x03, 0x25,
  0x5a, 0x2f, 0xfa, 0xc6, 0x41, 0x4e, 0x41, 0xa3, 0xa7, 0xa7, 0x26, 0x58,
  0xba, 0xe7, 0xcf, 0x1a, 0x4d, 0x3c, 0x75, 0x6d, 0xbc, 0x93, 0x36, 0x7e,
  0x66, 0x13, 0x7b, 0x83, 0x9d, 0xbd, 0x68, 0xf3, 0x74, 0xb8, 0xbd, 0xe7,
  0x5a, 0x68, 0x36, 0xb1, 0xc7, 0x4d, 0xe0, 0xa1, 0xea, 0xcb, 0x4f, 0xd1,
  0xff, 0x0f, 0xc9, 0xfc, 0xa7, 0x68, 0xf3, 0xbb, 0xdd, 0x5d, 0x6a, 0xe0,
  0xcf, 0xd1, 0xfe, 0xf1, 0x77, 0xd1, 0xd3, 0x01, 0x35, 0xf6, 0x36, 0xbe,
  0xd5, 0xe6, 0x14, 0x20, 0x66, 0xc8, 0x8d, 0xd0, 0xf7, 0x8d, 0x36, 0x9e,
  0xd5, 0xda, 0x38, 0x21, 0x2d, 0xf0, 0x9e, 0x6e, 0x93, 0x9d, 0xc1, 0x93,
  0xbd, 0x28, 0x7d, 0xf6, 0xe9, 0xc7, 0xd6, 0x90, 0xb6, 0xc1, 0xdf, 0x57,
  0x2d, 0x93, 0x92, 0x42, 0x48, 0x42, 0xce, 0xd1, 0x3d, 0x71, 0x31, 0x66,
  0x0d, 0x0c, 0x8e, 0x78, 0x1d, 0x4b, 0x2d, 0xec, 0x91, 0xa0, 0xce, 0xd3,
  0x4e, 0x89, 0xf5, 0x1a, 0x6e, 0x08, 0x92, 0x75, 0xe9, 0xca, 0x7c, 0xd1,
  0x18, 0x0e, 0x34, 0x51, 0x7b, 0xf4, 0xcf, 0xd1, 0x9b, 0xe1, 0xf1, 0x11,
  0xcd, 0x68, 0x87, 0x86, 0xe6, 0xd7, 0x50, 0x06, 0xc4, 0x5f, 0xf1, 0xe2,
  0xd2, 0xaa, 0x6e, 0x00, 0xd6, 0x82, 0xdb, 0x30, 0x09, 0x5b, 0x62, 0x91,
  0x00, 0xcc, 0x96, 0x15, 0x05, 0xf7, 0x8b, 0x74, 0xa1, 0xfe, 0xfe, 0x15,
  0x14, 0x06, 0xbd, 0x64, 0xd1, 0xf5, 0xd7, 0xd9, 0x9c, 0x8e, 0x49, 0x9e,
  0xe5, 0xdb, 0xbb, 0x83, 0x9d, 0x6e, 0x45, 0x4e, 0xf8, 0xfa, 0xf0, 0x48,
  0x72, 0x64, 0xde, 0xc4, 0x73, 0xe2, 0x8d, 0xc8, 0x18, 0x2f, 0x6e, 0xe0,
  0x6f, 0x17, 0xdf, 0x8d, 0xbc, 0x7f, 0xb2, 0x9a, 0xdf, 0xd3, 0x3e, 0x7e,
  0x32, 0xd8, 0x05, 0x6e, 0x15, 0x74, 0xdc, 0xd7, 0x6f, 0xe8, 0xef, 0xdd,
  0xa7, 0xdd, 0x08, 0x5f, 0x55, 0xf5, 0x75, 0x3b, 0xaf, 0x1b, 0x07, 0xa7,
  0xa7, 0x5f, 0x1f, 0x4b, 0xe8, 0xc5, 0x81, 0x9a, 0x50, 0x21, 0x56, 0x39,
  0x1d, 0x58, 0xb8, 0x2a, 0xe9, 0x6a, 0x88, 0x7e, 0xb5, 0x93, 0x45, 0x2b,
  0x79, 0x93, 0x24, 0x0b, 0x06, 0x9a, 0xaa, 0x71, 0x84, 0x52, 0x79, 0xb3,
  0x8c, 0x0c, 0x62, 0x74, 0x3a, 0xa9, 0x66, 0xbb, 0x03, 0x8e, 0xdc, 0x99,
  0x6b, 0x47, 0x2b, 0x97, 0x6b, 0x17, 0xfb, 0x2a, 0x50, 0x3c, 0x44, 0x17,
  0x43, 0x68, 0xe6, 0x66, 0x29, 0xbb, 0x4a, 0x2f, 0xaa, 0xa6, 0xdb, 0x1d,
  0x26, 0x65, 0x5f, 0x06, 0xfd, 0x42, 0x2d, 0xb4, 0x5d, 0x35, 0x37, 0x39,
  0x63, 0xd9, 0x42, 0x51, 0x27, 0xd9, 0x4c, 0xbc, 0x5a, 0xa0, 0x58, 0xd5,
  0xd4, 0x15, 0xf0, 0xe3, 0xd2, 0x67, 0x09, 0x07, 0x8c, 0xbd, 0xdd, 0x7f,
  0x73, 0xf4, 0xea, 0x9b, 0xfd, 0x93, 0x77, 0x47, 0xf4, 0x0a, 0x70, 0x17,
  0x37, 0x3d, 0x72, 0x11, 0x8f, 0x71, 0x96, 0x72, 0x19, 0xf1, 0x82, 0x64,
  0x82, 0xee, 0x86, 0x04, 0x06, 0x46, 0x1d, 0xbc, 0xb5, 0x2b, 0xaf, 0x11,
  0x5d, 0xe0, 0xaf, 0x3d, 0xf9, 0x6b, 0xef, 0xcf, 0x9d, 0xad, 0xca, 0xa4,
  0x1b, 0x3a, 0x31, 0xe8, 0xe5, 0x4e, 0x22, 0xc2, 0x18, 0x44, 0x9f, 0x23,
  0x2a, 0x65, 0x55, 0x3a, 0xe6, 0x8f, 0xb1, 0x3b, 0x0d, 0xcf, 0x6e, 0x8e,
  0x2a, 0xc5, 0xcd, 0x3b, 0x78, 0xe9, 0x15, 0x4b, 0x15, 0x1d, 0xe4, 0x83,
  0xa8, 0x9c, 0xc1, 0xbe, 0x6a, 0xb4, 0x61, 0x4d, 0x24, 0xf7, 0x0b, 0x04,
  0x1e, 0x6d, 0x76, 0xe4, 0x97, 0x57, 0x87, 0xfb, 0x17, 0x47, 0x78, 0xc1,
  0xba, 0xb7, 0x3a, 0x92, 0x06, 0xf6, 0x84, 0xf1, 0x6c, 0x76, 0xe4, 0xc3,
  0x57, 0x98, 0x50, 0x47, 0xc0, 0xb8, 0x05, 0x42, 0xad, 0x36, 0xae, 0x6c,
  0xae, 0xe1, 0x77, 0x41, 0x96, 0x50, 0x61, 0x11, 0x22, 0x9b, 0x1d, 0xf9,
  0xae, 0xe3, 0xac, 0xb5, 0x5a, 0x24, 0xcd, 0x55, 0xb8, 0x8e, 0xdb, 0x52,
  0x27, 0x04, 0x89, 0xdd, 0xef, 0x8f, 0x3a, 0x26, 0xc4, 0xbe, 0x14, 0x80,
  0x55, 0xb9, 0x8d, 0xd7, 0x9c, 0x26, 0x58, 0x94, 0xb2, 0x6c, 0x77, 0xef,
  0xc9, 0x9f, 0x79, 0x3d, 0x5f, 0x75, 0xb6, 0xe9, 0x6e, 0xe8, 0xfc, 0x19,
  0x5d, 0xa7, 0x1e, 0xe5, 0xdd, 0xed, 0x07, 0x34, 0x29, 0xa5, 0x28, 0x09,
  0x4f, 0xc1, 0xae, 0xb3, 0x25, 0x4c, 0xe6, 0xc5, 0x0b, 0x7a, 0x27, 0xb1,
  0xdb, 0x96, 0xbf, 0x6a, 0xde, 0x7b, 0xde, 0x2f, 0xae, 0xa0, 0x34, 0x77,
  0xe0, 0x83, 0xd2, 0x5d, 0x78, 0x7f, 0xf4, 0xe4, 0x5d, 0x99, 0xa3, 0x16,
  0x68, 0x43, 0x9f, 0xb3, 0x95, 0x85, 0x77, 0x73, 0x5f, 0x5a, 0x96, 0x9d,
  0xe7, 0x52, 0x97, 0x0a, 0x46, 0x6a, 0xc9, 0x31, 0x35, 0x84, 0x65, 0x01,
  0x62, 0x2d, 0x2b, 0x16, 0x90, 0xc4, 0xdd, 0x1f, 0x44, 0x39, 0xd8, 0x9d,
  0x1d, 0x8f, 0x90, 0x45, 0xb4, 0xb2, 0x3d, 0x0d, 0x74, 0x70, 0xb7, 0xf4,
  0x76, 0xfc, 0xd2, 0x20, 0x5b, 0x19, 0x17, 0xa5, 0xac, 0x65, 0xe1, 0x2c,
  0x46, 0xec, 0x59, 0xd4, 0x67, 0xab, 0xfb, 0x54, 0x8b, 0x12, 0xe7, 0x69,
  0x88, 0x02, 0x2f, 0x9a, 0x31, 0xb1, 0x9a, 0x79, 0x92, 0x3f, 0x18, 0xe1,
  0xd0, 0xe2, 0x78, 0xe2, 0x29, 0x06, 0x59, 0x00, 0x78, 0x67, 0x30, 0x18,
  0x78, 0x9c, 0xfc, 0x6b, 0x2e, 0x81, 0xce, 0xc3, 0x60, 0x98, 0xba, 0x4a,
  0x45, 0xaf, 0x58, 0xca, 0x78, 0x29, 0xd0, 0xc8, 0x96, 0x06, 0xbe, 0xa8,
  0x2d, 0xc2, 0x1d, 0x8d, 0xc0, 0xa2, 0xd1, 0xd5, 0x6e, 0xbb, 0x06, 0x23,
  0x7e, 0xd3, 0xb6, 0x09, 0x0f, 0x8c, 0x4d, 0x2c, 0x8d, 0x45, 0xcc, 0xb9,
  0xbf, 0x8e, 0x4f, 0x65, 0x6e, 0x2d, 0x40, 0xc1, 0xc8, 0x07, 0x96, 0x22,
  0x68, 0xbc, 0x25, 0xb2, 0x68, 0x3a, 0x94, 0x9e, 0x04, 0x1a, 0x80, 0xc9,
  0x65, 0x77, 0x9c, 0xe5, 0x26, 0x35, 0x79, 0x17, 0x39, 0x74, 0x3c, 0xae,
  0xac, 0xa5, 0x37, 0x88, 0x43, 0xf5, 0xb4, 0x76, 0x26, 0x62, 0x98, 0x85,
  0xb6, 0xcc, 0x02, 0xbf, 0xe6, 0x1e, 0x28, 0x20, 0x6b, 0x11, 0x2b, 0xf0,
  0x0e, 0x89, 0x6d, 0xd9, 0x8c, 0x5d, 0x5c, 0x3a, 0x79, 0x6f, 0x24, 0x41,
  0x74, 0x57, 0x5f, 0x12, 0x34, 0x2d, 0x3d, 0xc0, 0xb8, 0x87, 0x56, 0xe3,
  0x7c, 0xc8, 0x39, 0x3e, 0xb6, 0x16, 0x9d, 0x67, 0xbc, 0xb6, 0x36, 0xfe,
  0x56, 0xae, 0xb2, 0x2e, 0x5a, 0x51, 0xb1, 0x25, 0xb3, 0x84, 0x1c, 0xf0,
  0xbd, 0x28, 0xbe, 0x43, 0xbd, 0x06, 0xa2, 0x41, 0x71, 0x92, 0x89, 0x3d,
  0xe6, 0x24, 0xb0, 0x2a, 0xba, 0x19, 0x5a, 0x6d, 0x45, 0x09, 0x2f, 0x92,
  0xf2, 0x89, 0x0a, 0xf9, 0x28, 0x08, 0x52, 0x66, 0xbe, 0x4b, 0x19, 0x7b,
  0x1f, 0x88, 0x3f, 0x2a, 0xa1, 0x9b, 0x62, 0x8e, 0x91, 0x13, 0x8b, 0x1e,
  0x2a, 0xdd, 0xa4, 0x1c, 0x07, 0x08, 0x0b, 0x87, 0x04, 0x51, 0xd8, 0x6a,
  0x49, 0x61, 0x4d, 0xeb, 0xc4, 0xf9, 0xa2, 0xd9, 0xd8, 0x94, 0x70, 0xb5,
  0xcf, 0x79, 0xdf, 0x65, 0x2e, 0xba, 0xd8, 0xab, 0x3c, 0xbd, 0xba, 0x12,
  0x55, 0x2d, 0xaa, 0x4f, 0xad, 0x9d, 0xc8, 0x4e, 0xb0, 0x2a, 0xc9, 0x6c,
  0x51, 0xae, 0xd6, 0xad, 0xe6, 0x85, 0x59, 0x7b, 0xcc, 0xde, 0x52, 0x21,
  0x66, 0xf3, 0x3f, 0xca, 0xbe, 0x31, 0x32, 0x8f, 0xa4, 0xa0, 0xc1, 0xe8,
  0x55, 0xf5, 0x17, 0x9f, 0x9e, 0x6f, 0x70, 0xd1, 0x86, 0xb9, 0xcf, 0xb8,
  0xb3, 0x4d, 0x67, 0xc4, 0x0a, 0x1f, 0x6e, 0x32, 0x81, 0x55, 0x79, 0x86,
  0xab, 0xf8, 0xce, 0xc5, 0x3a, 0x09, 0x8e, 0xe6, 0x28, 0xf6, 0xaa, 0xd6,
  0x46, 0x54, 0xb1, 0xed, 0x22, 0xb9, 0xf3, 0x78, 0xae, 0x7c, 0x28, 0xbb,
  0x4d, 0x3c, 0x68, 0x8a, 0x37, 0x2f, 0x7a, 0xa4, 0x2b, 0x3d, 0xfd, 0x8e,
  0x99, 0xd4, 0x9c, 0xb9, 0x8e, 0x5f, 0xf1, 0x24, 0x6b, 0xab, 0x32, 0x88,
  0x82, 0x26, 0xc5, 0x48, 0x92, 0x85, 0x2c, 0x5e, 0xc6, 0xa6, 0x3e, 0x6a,
  0x6b, 0x51, 0xa3, 0xd0, 0x19, 0x4f, 0x3b, 0x50, 0x4d, 0xb0, 0x20, 0x69,
  0xa9, 0x54, 0x55, 0xb8, 0x18, 0x39, 0xef, 0xeb, 0xb5, 0x59, 0x76, 0xdc,
  0x26, 0x75, 0x38, 0xf9, 0x62, 0xa4, 0x44, 0xc0, 0x34, 0x00, 0x81, 0xce,
  0xb9, 0xeb, 0xf7, 0xa7, 0x71, 0xc1, 0xb5, 0x7a, 0x39, 0x12, 0x80, 0xb7,
  0x8c, 0x89, 0x9a, 0xcd, 0x68, 0x35, 0x9e, 0xda, 0x38, 0x7e, 0x2e, 0x32,
  0x43, 0x68, 0x8d, 0x31, 0xaf, 0xd0, 0x0c, 0x51, 0x09, 0x87, 0xe3, 0x8e,
  0x8d, 0xb9, 0x3f, 0x9c, 0x9a, 0x36, 0xaa, 0x9c, 0xd1, 0x0f, 0x1d, 0xd9,
  0xb3, 0xf3, 0xd3, 0x2f, 0xcf, 0x8f, 0x86, 0xc3, 0xe8, 0xcd, 0xd1, 0x85,
  0xe8, 0xfa, 0x17, 0x12, 0x06, 0x27, 0x10, 0x9f, 0xec, 0x64, 0xb0, 0xec,
  0x6c, 0x8b, 0x34, 0x31, 0x43, 0x02, 0x43, 0x35, 0x66, 0x70, 0xa0, 0xb1,
  0x28, 0xc7, 0x7a, 0xfc, 0x54, 0xa3, 0xe7, 0xae, 0xd9, 0xcc, 0xcf, 0xb1,
  0x4c, 0xec, 0x87, 0x74, 0x56, 0x73, 0x6f, 0x4b, 0x0d, 0x0a, 0x01, 0x5f,
  0x1b, 0xe7, 0xf2, 0xb6, 0x73, 0xad, 0xb6, 0xca, 0xd3, 0xfb, 0x7d, 0x74,
  0x61, 0xd5, 0x3a, 0x7f, 0x1f, 0x9d, 0x1b, 0x7d, 0xfc, 0x3e, 0xfa, 0x8e,
  0xda, 0x9c, 0xa0, 0x58, 0xac, 0x94, 0xa8, 0x1a, 0x72, 0x6d, 0x2a, 0x5f,
  0xaa, 0x80, 0x41, 0xde, 0x83, 0xff, 0x11, 0x95, 0xe7, 0x1f, 0xa8, 0x7f,
  0xc8, 0xc9, 0xc4, 0x82, 0x25, 0xa3, 0xb1, 0x74, 0xae, 0xe7, 0x03, 0x2d,
  0x70, 0x1d, 0x9d, 0x24, 0x97, 0x25, 0x0b, 0x24, 0xe8, 0x8e, 0x9a, 0xdb,
  0x01, 0x36, 0xda, 0x2e, 0x2a, 0xca, 0xd3, 0xaf, 0x4f, 0x3e, 0xfd, 0x78,
  0xe7, 0x53, 0xf9, 0xd5, 0xfe, 0x7d, 0xfe, 0x74, 0x47, 0x31, 0x06, 0xe9,
  0xaf, 0xa7, 0x2f, 0x9e, 0xee, 0xbe, 0x00, 0xf6, 0xc9, 0xce, 0x8b, 0x1d,
  0xfa, 0xff, 0xa7, 0xfa, 0x09, 0x00, 0x5e, 0x9e, 0xef, 0x7d, 0xfa, 0x09,
  0x07, 0xc1, 0x80, 0x3e, 0xa6, 0xd4, 0x49, 0xbf, 0xcc, 0xfa, 0x9c, 0x43,
  0xce, 0x42, 0xd0, 0xef, 0xab, 0xe6, 0x48, 0x78, 0xd5, 0x51, 0x7c, 0x0a,
  0x13, 0xf7, 0x35, 0xaf, 0xd5, 0xb4, 0x2a, 0x29, 0xce, 0x61, 0x45, 0x3d,
  0x37, 0x0d, 0x7d, 0x5b, 0xaa, 0x9a, 0x31, 0xf6, 0x42, 0xe5, 0x1d, 0x12,
  0x19, 0xe9, 0x6a, 0x0d, 0x40, 0x1e, 0x7e, 0x6e, 0xd7, 0x96, 0xe9, 0xb5,
  0xc1, 0xe8, 0x0d, 0xba, 0x55, 0xfa, 0x9e, 0xd6, 0x08, 0x27, 0x1a, 0x09,
  0x2a, 0xb5, 0xd5, 0x2a, 0xab, 0xfd, 0xdc, 0xfe, 0xc4, 0x72, 0x85, 0xb7,
  0x94, 0x1a, 0xa2, 0x66, 0x6f, 0x56, 0x60, 0xae, 0xad, 0xaf, 0x0a, 0xf1,
  0x6c, 0xf8, 0xed, 0xf7, 0x2b, 0x15, 0x14, 0x41, 0x73, 0x70, 0x06, 0x52,
  0x06, 0xad, 0x65, 0xca, 0x8d, 0xe6, 0xde, 0x2d, 0xc2, 0xf6, 0x1e, 0xd3,
  0x9c, 0x9f, 0x11, 0x53, 0xb0, 0xdb, 0xb9, 0x7e, 0xb0, 0x39, 0xa9, 0x04,
  0xb4, 0xb9, 0x6a, 0x6a, 0x06, 0xba, 0x63, 0x37, 0x9e, 0xbc, 0xea, 0x48,
  0xb6, 0x2f, 0x6f, 0xa8, 0xf8, 0x59, 0x70, 0x4e, 0x8b, 0x08, 0x0a, 0xb7,
  0x19, 0xdf, 0xf6, 0xf2, 0xbc, 0x51, 0x76, 0xa3, 0x2b, 0x50, 0x63, 0xd0,
  0x9f, 0xf6, 0xc1, 0xe7, 0xc9, 0x1d, 0xba, 0x07, 0xa7, 0xe6, 0xc3, 0xda,
  0x5d, 0xc5, 0x8a, 0x4d, 0x17, 0x26, 0xde, 0x76, 0x24, 0xfd, 0x73, 0x1c,
  0x39, 0x1e, 0x56, 0x35, 0x75, 0x17, 0x11, 0x17, 0x2b, 0x51, 0x98, 0x54,
  0x20, 0xf9, 0x00, 0xf9, 0x72, 0xcb, 0x58, 0x58, 0xff, 0x23, 0x17, 0xad,
  0xc5, 0xf7, 0x9a, 0x42, 0x2e, 0xc7, 0x42, 0xf9, 0xd3, 0x30, 0x21, 0xaa,
  0x02, 0xb6, 0x1c, 0x22, 0x4c, 0x6e, 0x48, 0xa9, 0x45, 0xba, 0x69, 0xe9,
  0xe6, 0x08, 0xca, 0xdc, 0xfc, 0x6e, 0x63, 0x63, 0x78, 0x76, 0x74, 0x74,
  0x18, 0x9d, 0x1c, 0xbf, 0x39, 0xbe, 0x08, 0x04, 0x72, 0x77, 0x91, 0x98,
  0xa5, 0xb5, 0xb0, 0xea, 0x0c, 0xd5, 0xe5, 0xf0, 0x90, 0x66, 0x5a, 0x60,
  0x5e, 0xaf, 0xf2, 0x59, 0xa2, 0x09, 0x0c, 0xd3, 0xfa, 0x7b, 0xac, 0x7a,
  0x73, 0x12, 0x3f, 0x23, 0xe8, 0x7b, 0x81, 0xae, 0x20, 0xe1, 0x66, 0x8c,
  0x52, 0x2d, 0x72, 0x49, 0x7c, 0xaf, 0xe1, 0x19, 0x55, 0xc9, 0x49, 0x91,
  0x99, 0x5c, 0x99, 0x16, 0x8d, 0x69, 0xad, 0x8d, 0x0a, 0x6b, 0x9b, 0x48,
  0x98, 0x73, 0x60, 0xa1, 0xe3, 0x68, 0xbd, 0xbb, 0x84, 0xd3, 0x11, 0x67,
  0xa9, 0xe0, 0xc3, 0x86, 0xb1, 0xc4, 0xae, 0x2e, 0xc2, 0x45, 0x26, 0x7c,
  0x3c, 0xec, 0x31, 0x2c, 0x59, 0x63, 0x81, 0xb4, 0xd6, 0x57, 0x58, 0x0c,
  0xe5, 0xc9, 0x8e, 0xcb, 0x14, 0x58, 0x30, 0xcf, 0x51, 0x51, 0x1f, 0x9d,
  0xed, 0x46, 0x24, 0x8f, 0x2c, 0x21, 0xd5, 0xe7, 0xcb, 0x79, 0xe3, 0xba,
  0xfb, 0x5e, 0xde, 0xa5, 0xf9, 0x7f, 0xbc, 0xc3, 0xd7, 0xdb, 0x65, 0x9c,
  0xf7, 0x49, 0xf2, 0x5a, 0xf5, 0xcd, 0xaa, 0x2a, 0x14, 0xa1, 0x71, 0xc6,
  0x62, 0xfa, 0x49, 0x3c, 0x8a, 0x7f, 0x4d, 0x5a, 0xf4, 0xe9, 0x1e, 0x19,
  0x3b, 0x24, 0xa7, 0x7a, 0x00, 0x30, 0xf5, 0x5e, 0xc4, 0x05, 0x3b, 0x5d,
  0xe4, 0xb3, 0xc8, 0x3a, 0x1e, 0xb5, 0xcb, 0x76, 0xd1, 0xf3, 0x28, 0x2e,
  0x8a, 0x97, 0xa9, 0x6b, 0x28, 0xc5, 0x34, 0x75, 0x2e, 0x4d, 0xd1, 0x7a,
  0x16, 0xed, 0x7e, 0x8a, 0x79, 0x3c, 0x6e, 0x3e, 0x40, 0xab, 0xb7, 0x18,
  0x36, 0x51, 0x17, 0x32, 0xbf, 0x9b, 0x92, 0xa1, 0xc0, 0x50, 0xc8, 0xb2,
  0xba, 0x16, 0x0c, 0xcb, 0xb1, 0x7a, 0xd0, 0x4f, 0xd4, 0x91, 0xce, 0x96,
  0x29, 0xf6, 0x6c, 0x8b, 0x84, 0xc4, 0x85, 0xcd, 0x64, 0x5d, 0x60, 0x6b,
  0x95, 0x58, 0xbd, 0x6e, 0xee, 0x73, 0xbd, 0x78, 0x19, 0x60, 0x1d, 0x21,
  0x5a, 0xbb, 0x4b, 0x27, 0x2c, 0x55, 0x9b, 0x11, 0x80, 0xe9, 0x4f, 0x88,
  0x4f, 0x62, 0xa4, 0xd9, 0x71, 0xc9, 0x1e, 0x4f, 0x37, 0x32, 0x15, 0x60,
  0xb8, 0xe4, 0x1b, 0x1b, 0x17, 0x36, 0x59, 0x7e, 0x40, 0xa1, 0x85, 0xaa,
  0x4f, 0x00, 0xac, 0xb9, 0xe3, 0x7b, 0x41, 0xdc, 0x7e, 0x59, 0x4e, 0xcd,
  0xae, 0xe0, 0x91, 0xd4, 0xab, 0x73, 0x46, 0x2a, 0x75, 0x30, 0xed, 0xdd,
  0x1d, 0x92, 0x5f, 0xa7, 0x59, 0xbd, 0xe4, 0x52, 0x53, 0x29, 0xe5, 0x69,
  0xf5, 0x79, 0x75, 0x76, 0x77, 0xbe, 0x5e, 0xbf, 0xea, 0x0c, 0x4d, 0xf9,
  0xe0, 0xcb, 0x7b, 0x4f, 0x1f, 0xd8, 0xb4, 0xd3, 0xbc, 0x52, 0x42, 0x43,
  0x04, 0x41, 0xef, 0x79, 0x69, 0x6c, 0x1b, 0x11, 0x7e, 0x72, 0x15, 0x73,
  0x49, 0xda, 0x07, 0x46, 0x6f, 0x99, 0x1a, 0xb5, 0xa1, 0xbc, 0xd1, 0x68,
  0x6c, 0xf9, 0xb2, 0x80, 0x85, 0x6c, 0xc1, 0x48, 0x2c, 0x5e, 0x8d, 0x75,
  0xc9, 0x88, 0x92, 0x61, 0x1b, 0xbc, 0x2d, 0x9c, 0xb3, 0x57, 0x65, 0x12,
  0x46, 0x3d, 0x79, 0x72, 0xc5, 0xae, 0x74, 0xe6, 0xc1, 0x50, 0xfb, 0x01,
  0xf6, 0xa6, 0xe7, 0x95, 0x78, 0x33, 0xe2, 0x86, 0x84, 0x9e, 0x98, 0xf1,
  0x8e, 0x63, 0x13, 0x59, 0xb5, 0xc4, 0x7a, 0xed, 0x62, 0x80, 0x7d, 0x76,
  0x9c, 0x71, 0x1d, 0xe5, 0x3b, 0xf3, 0x25, 0x84, 0xc5, 0x5c, 0xa4, 0xd2,
  0xc9, 0x80, 0x73, 0xeb, 0x84, 0x50, 0x1c, 0xb3, 0x47, 0x46, 0x17, 0xbc,
  0x61, 0xa5, 0x78, 0x08, 0xb8, 0x81, 0x9e, 0x52, 0x2d, 0xb7, 0xe4, 0xba,
  0x02, 0xc7, 0x2f, 0x2c, 0x79, 0x52, 0x10, 0x28, 0x61, 0xf7, 0x3f, 0x38,
  0x7d, 0xfb, 0xfa, 0xf8, 0x4b, 0x07, 0x2b, 0x20, 0x4c, 0x7c, 0x59, 0x66,
  0xb0, 0x6b, 0x8a, 0xd1, 0xd0, 0x95, 0xd9, 0x71, 0xee, 0x6e, 0xc5, 0xb7,
  0xd7, 0xa0, 0x5b, 0x62, 0x4f, 0xef, 0xc3, 0x0f, 0x98, 0x81, 0xcc, 0x9f,
  0xc0, 0x56, 0x2e, 0x98, 0xa1, 0xc5, 0x96, 0xb7, 0x3c, 0xd4, 0x60, 0x49,
  0x24, 0x3b, 0x23, 0xce, 0xcb, 0xe5, 0xc2, 0xc5, 0x0e, 0x06, 0xf8, 0xf8,
  0x8a, 0x4d, 0x87, 0x5b, 0x01, 0x15, 0x47, 0x97, 0x0b, 0x61, 0x4d, 0x12,
  0xf3, 0x58, 0x35, 0xec, 0xca, 0x1d, 0x00, 0xcb, 0x82, 0xe6, 0x88, 0xeb,
  0x05, 0xd0, 0x08, 0xc8, 0x99, 0x66, 0xf0, 0xfb, 0x07, 0x71, 0xf2, 0xe6,
  0xca, 0x41, 0x21, 0x1e, 0x99, 0xa8, 0x95, 0x51, 0x99, 0x89, 0x66, 0x86,
  0x79, 0x4b, 0x79, 0xc3, 0xef, 0x5d, 0xa1, 0x47, 0x0d, 0xfa, 0xf5, 0xae,
  0x22, 0xab, 0xfb, 0x95, 0xf8, 0xc0, 0x24, 0x19, 0x2c, 0x07, 0x10, 0x16,
  0x3d, 0xf1, 0x75, 0xf2, 0x27, 0xaf, 0xe0, 0xa1, 0x79, 0x01, 0x84, 0xc6,
  0x99, 0x40, 0x87, 0x84, 0x35, 0x66, 0x94, 0x4b, 0x7a, 0x24, 0xc5, 0xe3,
  0xcb, 0x20, 0x99, 0x4c, 0x02, 0x04, 0x8d, 0xe8, 0xc4, 0x5c, 0x0c, 0x5b,
  0x4b, 0xf7, 0xa3, 0x6e, 0x5f, 0xbf, 0xd3, 0x84, 0x0b, 0x97, 0x0e, 0x6c,
  0x0f, 0x95, 0x34, 0x0d, 0x8e, 0x18, 0x94, 0xb2, 0x62, 0xdc, 0x75, 0x60,
  0xa1, 0xf4, 0x41, 0x52, 0x7e, 0xfc, 0x02, 0xdd, 0xcd, 0x9e, 0x22, 0x9b,
  0x05, 0x27, 0xdf, 0x83, 0xc7, 0xc3, 0x2d, 0x96, 0x29, 0x55, 0x23, 0xa5,
  0x93, 0x57, 0xaa, 0x3a, 0x75, 0x38, 0xfd, 0xb2, 0x25, 0x8c, 0x1d, 0x0c,
  0xcb, 0x4b, 0xe2, 0x0e, 0x8c, 0xc3, 0xdf, 0xda, 0x04, 0xf1, 0xb6, 0x7c,
  0xa1, 0xc1, 0xf8, 0x96, 0xc2, 0x4f, 0x0d, 0x09, 0x8e, 0x2f, 0x0d, 0xf5,
  0x47, 0xb1, 0x2d, 0x8a, 0xeb, 0xef, 0x7b, 0xeb, 0xdc, 0x1e, 0xad, 0x2d,
  0x3d, 0xd1, 0x53, 0x9c, 0x5f, 0x29, 0x1e, 0x8b, 0x3a, 0xd5, 0x58, 0x49,
  0x74, 0xe8, 0xca, 0xce, 0x46, 0x09, 0xa1, 0xc4, 0x05, 0xcb, 0xb0, 0xf8,
  0xb4, 0x94, 0x74, 0x3e, 0xcd, 0x7e, 0x12, 0xeb, 0xa4, 0x23, 0xc4, 0x80,
  0xe3, 0x7c, 0xe4, 0x02, 0x52, 0x62, 0x7f, 0x97, 0x19, 0xea, 0xab, 0x37,
  0xd5, 0xea, 0x65, 0x16, 0xbc, 0x06, 0x7b, 0x1e, 0x6b, 0xc2, 0x89, 0xda,
  0x50, 0xa4, 0x2b, 0xab, 0xc0, 0x2e, 0x80, 0x59, 0x49, 0xe1, 0x9b, 0x90,
  0xef, 0x5f, 0x69, 0x72, 0x34, 0x9d, 0x67, 0x4d, 0x77, 0x57, 0xa0, 0x98,
  0x4f, 0x77, 0xd4, 0x12, 0x57, 0x6a, 0x94, 0x6a, 0x11, 0xed, 0x9f, 0x1f,
  0x91, 0x64, 0x7b, 0x35, 0xe7, 0x74, 0x66, 0x8c, 0xb0, 0xd4, 0xfd, 0x61,
  0xc1, 0x1a, 0xab, 0xa0, 0xe7, 0x03, 0x1d, 0xde, 0x05, 0x6f, 0x82, 0x98,
  0x34, 0x30, 0x80, 0x0e, 0x99, 0x0b, 0x3f, 0x03, 0xc9, 0x8d, 0x0d, 0x2b,
  0x8c, 0xb9, 0x0e, 0xf2, 0x92, 0x85, 0xa4, 0xe0, 0x2d, 0xa1, 0xae, 0x32,
  0x03, 0x83, 0x3e, 0x6b, 0xb0, 0xf5, 0x10, 0x21, 0xcc, 0xd6, 0x9a, 0x4f,
  0xb5, 0xcf, 0x40, 0xf8, 0x9b, 0x61, 0x30, 0x69, 0x5f, 0x15, 0x0f, 0xa8,
  0x27, 0xa7, 0x5e, 0xbb, 0xf5, 0xe8, 0x6f, 0x7c, 0xcf, 0x40, 0x16, 0xa9,
  0xcb, 0x05, 0x89, 0x0b, 0xac, 0x17, 0x43, 0xf6, 0x24, 0x10, 0x7e, 0x25,
  0x31, 0x0f, 0xa1, 0xd5, 0x62, 0xa3, 0x86, 0xf0, 0x13, 0x17, 0x89, 0x95,
  0x4a, 0x61, 0x75, 0x60, 0xa2, 0x67, 0x15, 0x54, 0x81, 0x28, 0x61, 0x1a,
  0xf1, 0x4c, 0x90, 0x58, 0x2b, 0x64, 0xd1, 0x6e, 0xe6, 0xfd, 0xc8, 0xcd,
  0xd6, 0x8f, 0xc1, 0x7d, 0x89, 0x8f, 0x5e, 0x45, 0x1d, 0xf5, 0x9f, 0x62,
  0x14, 0x03, 0x74, 0xc4, 0x2c, 0x95, 0xdd, 0xa7, 0xf8, 0x85, 0x3f, 0xe6,
  0x70, 0x37, 0x43, 0xb6, 0x1a, 0xc7, 0xf3, 0x00, 0xe3, 0x22, 0x53, 0xf7,
  0xaa, 0x1f, 0x88, 0xf8, 0xf8, 0x98, 0x43, 0x8f, 0x42, 0xd1, 0x38, 0xa8,
  0x2d, 0x02, 0x53, 0x0e, 0x72, 0x77, 0xed, 0xc0, 0x17, 0x49, 0xa5, 0x16,
  0x89, 0xcb, 0x10, 0xea, 0xf4, 0x3b, 0xb4, 0x16, 0xdd, 0xe9, 0xd4, 0x33,
  0x7c, 0x7b, 0x0c, 0xbb, 0xca, 0xc9, 0x74, 0x5e, 0x60, 0x52, 0xde, 0x05,
  0xb0, 0xda, 0x55, 0x25, 0xb3, 0x01, 0x60, 0xff, 0x48, 0xfc, 0x71, 0xc8,
  0x1b, 0x9c, 0x1d, 0xc2, 0x71, 0x02, 0xb7, 0x69, 0x61, 0x7e, 0x48, 0xa2,
  0xed, 0xb1, 0x06, 0x45, 0x48, 0x0a, 0x75, 0x52, 0x8e, 0x83, 0xa5, 0x4c,
  0xc6, 0xd7, 0x99, 0x04, 0xd3, 0xd2, 0xa2, 0x05, 0xf9, 0x97, 0x9d, 0xe8,
  0xbf, 0x94, 0x06, 0xbe, 0xf6, 0xc9, 0x7a, 0x20, 0x84, 0x81, 0x20, 0x0e,
  0x0d, 0x3c, 0x41, 0x1c, 0x7d, 0x77, 0x71, 0xbe, 0x1f, 0x7d, 0x75, 0xb4,
  0x7f, 0x78, 0x74, 0x3e, 0xac, 0x5d, 0xfa, 0x1a, 0xfe, 0x21, 0x12, 0x1a,
  0xec, 0xc1, 0x2c, 0x1a, 0x5b, 0xb6, 0xba, 0x86, 0xeb, 0x1b, 0xd7, 0x8b,
  0x57, 0x7c, 0x90, 0xe8, 0x7c, 0x40, 0x21, 0x12, 0xc7, 0x01, 0x62, 0xd2,
  0x10, 0xf7, 0x9c, 0x05, 0x6d, 0x68, 0x71, 0x4f, 0x67, 0x3d, 0x0f, 0x13,
  0x65, 0x3c, 0x98, 0x8e, 0xbf, 0x4c, 0x26, 0x99, 0x25, 0x01, 0x56, 0x77,
  0xee, 0x2b, 0x9f, 0x6a, 0x1d, 0xb0, 0x2d, 0xbd, 0x64, 0xd4, 0x80, 0xd8,
  0xf9, 0xae, 0x4f, 0xfd, 0xf6, 0x69, 0xf1, 0xfb, 0x40, 0x23, 0x5a, 0x25,
  0x45, 0xa7, 0x66, 0x0d, 0xac, 0x76, 0xbf, 0x21, 0x00, 0xe7, 0x8d, 0x93,
  0xf4, 0x55, 0x6b, 0x4b, 0x38, 0x5d, 0x53, 0xc0, 0x8e, 0xd7, 0x35, 0x08,
  0xbe, 0x54, 0x03, 0x21, 0x59, 0x4f, 0x50, 0x23, 0xab, 0x45, 0x03, 0x94,
  0xbc, 0x9a, 0xa9, 0x41, 0x61, 0x3c, 0x10, 0x9d, 0x02, 0xcb, 0x3a, 0x69,
  0xa9, 0x97, 0x3a, 0xdb, 0x45, 0x12, 0x8d, 0xdc, 0xa7, 0x61, 0xe9, 0x43,
  0xe1, 0xfd, 0xc0, 0xbe, 0x10, 0x0d, 0xcf, 0x2f, 0x2a, 0xae, 0x52, 0xb5,
  0x8b, 0x2a, 0x9e, 0xad, 0x36, 0x87, 0x31, 0x38, 0x9a, 0xb7, 0xa8, 0x7e,
  0x74, 0x69, 0xa8, 0xbb, 0xfa, 0xae, 0x84, 0x82, 0x41, 0xa9, 0x67, 0x53,
  0x27, 0x82, 0xcd, 0x64, 0xe3, 0x4d, 0x5e, 0x0d, 0x52, 0x80, 0x42, 0x62,
  0xe6, 0x0a, 0x01, 0x1c, 0x36, 0xee, 0x9e, 0x4b, 0xa2, 0xaf, 0xb2, 0x82,
  0xef, 0x82, 0xe6, 0xe3, 0xb8, 0xe4, 0xdb, 0x96, 0x9f, 0xdf, 0x50, 0x57,
  0x97, 0x83, 0x03, 0x63, 0xfc, 0x3c, 0x66, 0x5f, 0x67, 0xfb, 0x17, 0x5f,
  0xb1, 0xa3, 0x95, 0x49, 0xf8, 0x30, 0x83, 0xc2, 0x63, 0xee, 0xb5, 0x66,
  0x26, 0x96, 0x53, 0xe0, 0x44, 0xfe, 0x35, 0xe4, 0x24, 0x93, 0x27, 0xd9,
  0x91, 0xc7, 0x26, 0xca, 0x3c, 0x21, 0x29, 0x36, 0x55, 0xc3, 0x63, 0xb5,
  0x6e, 0x05, 0xc7, 0xbc, 0xbb, 0x34, 0x3b, 0x17, 0x74, 0xd9, 0x95, 0x1c,
  0xf4, 0xae, 0xcc, 0x89, 0x89, 0x1e, 0xc2, 0x1c, 0x34, 0x9e, 0x10, 0x65,
  0x8e, 0xbf, 0xb0, 0x4c, 0xf3, 0x1e, 0xed, 0x69, 0x3b, 0x30, 0x51, 0x70,
  0xa4, 0x3f, 0x9f, 0xad, 0x06, 0x4d, 0xc4, 0x8b, 0xe8, 0x8b, 0x65, 0x59,
  0x65, 0x2b, 0x35, 0xac, 0x3b, 0x27, 0x59, 0xe6, 0x59, 0x56, 0x56, 0xd1,
  0xe2, 0x78, 0x75, 0xe4, 0x44, 0x0b, 0x02, 0x95, 0x8c, 0x05, 0x4d, 0xcd,
  0x55, 0xee, 0x0e, 0x05, 0xc3, 0x78, 0x54, 0x64, 0xd3, 0x65, 0x19, 0x84,
  0x5d, 0xff, 0xbc, 0x31, 0x07, 0x83, 0xde, 0x3c, 0x1e, 0x24, 0x46, 0x50,
  0x88, 0x1b, 0xce, 0x63, 0xd2, 0xf4, 0x51, 0xe7, 0x11, 0x7e, 0xc7, 0x3c,
  0x9b, 0x57, 0x4b, 0x2b, 0x70, 0x84, 0xf7, 0x96, 0xdf, 0x6b, 0xba, 0x0b,
  0x93, 0x3b, 0x48, 0xeb, 0x26, 0x11, 0xbf, 0x96, 0x6a, 0xeb, 0x52, 0x8e,
  0xdb, 0x01, 0x7c, 0x30, 0xae, 0xc3, 0xa5, 0xb3, 0x61, 0xa1, 0x06, 0x8b,
  0x54, 0x24, 0x11, 0x21, 0x96, 0x01, 0xb9, 0xcd, 0x5f, 0x28, 0xb9, 0xdc,
  0x0a, 0x2a, 0x4d, 0x57, 0x6e, 0x91, 0xc9, 0x4f, 0x4b, 0xac, 0xd1, 0x80,
  0x26, 0xdd, 0x6b, 0xd5, 0x19, 0x14, 0x4c, 0x3e, 0x97, 0xbb, 0xde, 0x42,
  0x2c, 0x25, 0x78, 0xcc, 0xbc, 0x70, 0x36, 0x44, 0xbb, 0xf1, 0xe0, 0xa4,
  0x63, 0x8c, 0x25, 0xe6, 0xac, 0x85, 0xaf, 0xf3, 0xc7, 0x89, 0xc9, 0xa8,
  0xdf, 0x61, 0x52, 0xbb, 0x5d, 0x1f, 0x96, 0xab, 0xb0, 0x11, 0x05, 0x05,
  0x98, 0x64, 0xf0, 0x7a, 0xcf, 0x71, 0xf2, 0x37, 0x3b, 0xa4, 0xee, 0xe2,
  0xb4, 0x0c, 0xaf, 0x3f, 0x53, 0xbb, 0x7d, 0x9d, 0xf4, 0xd1, 0xaa, 0x12,
  0x87, 0xe1, 0xa3, 0x13, 0xaf, 0x90, 0xca, 0xa0, 0xe6, 0x17, 0x85, 0xcc,
  0x60, 0x5b, 0xcf, 0x75, 0xaa, 0x31, 0x94, 0xb2, 0xe6, 0x66, 0xfb, 0x82,
  0xf2, 0xce, 0xb6, 0x2c, 0xf8, 0xd1, 0xbd, 0x2b, 0xd1, 0x79, 0xfb, 0x07,
  0x4d, 0xd2, 0x18, 0x38, 0x80, 0x2f, 0x65, 0x97, 0xc7, 0x61, 0xd6, 0x34,
  0xaf, 0x8a, 0x8b, 0xec, 0x7d, 0x54, 0xd7, 0x61, 0x7f, 0x88, 0xd5, 0x9c,
  0x47, 0x7e, 0x3d, 0x0a, 0xe1, 0x9b, 0x7b, 0xbb, 0xac, 0x7f, 0x49, 0x94,
  0x02, 0xe3, 0x65, 0x59, 0x61, 0x18, 0x8f, 0x42, 0x52, 0x5d, 0x77, 0x2e,
  0xff, 0xc6, 0x70, 0x6c, 0x96, 0x50, 0xae, 0x4e, 0x55, 0x11, 0x7f, 0x02,
  0xf7, 0x4a, 0xa5, 0x86, 0x80, 0x24, 0x29, 0x17, 0x65, 0xbe, 0x1c, 0x57,
  0x70, 0x85, 0x98, 0x18, 0x2a, 0xce, 0x68, 0xb7, 0xbc, 0x59, 0xa8, 0xc2,
  0x6e, 0xc6, 0x95, 0x8c, 0x0d, 0x7d, 0x32, 0xec, 0x62, 0x4b, 0xaa, 0xda,
  0x69, 0x55, 0x4f, 0x16, 0xc5, 0x69, 0xfc, 0x8e, 0xc0, 0xfa, 0x67, 0x2e,
  0x61, 0xbc, 0x02, 0xcf, 0x24, 0xd1, 0xf7, 0xc1, 0x15, 0xa3, 0xf2, 0x06,
  0xdf, 0xaf, 0x79, 0xa4, 0x40, 0x51, 0x7c, 0x7b, 0xc3, 0x32, 0xb7, 0xe1,
  0xc0, 0x9c, 0xa8, 0xbb, 0xbe, 0x2f, 0x63, 0x47, 0xfd, 0x6d, 0xd3, 0x42,
  0x1a, 0x8c, 0xb5, 0x43, 0x47, 0x2f, 0x3c, 0x20, 0x54, 0x2d, 0x22, 0x33,
  0x99, 0x26, 0x5c, 0x1e, 0xde, 0xbc, 0xaf, 0x12, 0x0f, 0x20, 0xeb, 0x37,
  0x70, 0xc5, 0xde, 0xac, 0x7a, 0x5f, 0xed, 0xd6, 0x6c, 0x5e, 0x01, 0x67,
  0x02, 0xbe, 0xd1, 0x20, 0xa2, 0x43, 0x33, 0x1d, 0x32, 0x3b, 0xe1, 0x05,
  0x83, 0x00, 0x6f, 0x9b, 0x74, 0x7c, 0xe6, 0xba, 0xa0, 0x21, 0x60, 0xc6,
  0xdd, 0x69, 0xb2, 0xd3, 0x0d, 0xe0, 0xdd, 0x37, 0x25, 0xc0, 0x3d, 0x63,
  0x21, 0x1f, 0x66, 0x32, 0x9e, 0xa0, 0x28, 0xe9, 0x08, 0xe7, 0xda, 0x6a,
  0x19, 0x0a, 0x35, 0xf1, 0x73, 0x07, 0xb3, 0xfb, 0x7c, 0x6f, 0xb0, 0xfb,
  0xf1, 0xa7, 0x83, 0x9d, 0xc1, 0xee, 0x0e, 0x38, 0x0b, 0x86, 0x12, 0x0c,
  0x4e, 0xd6, 0xa5, 0xa5, 0xab, 0xca, 0x7b, 0xcd, 0x3e, 0xdf, 0x1e, 0x5d,
  0x7c, 0x7b, 0x7a, 0xfe, 0x75, 0x74, 0xfc, 0xf6, 0xe2, 0xe8, 0xfc, 0xf5,
  0xfe, 0xc1, 0x63, 0x31, 0x48, 0x43, 0xeb, 0x6c, 0x50, 0xd2, 0x2b, 0xf1,
  0x0b, 0xd3, 0x34, 0x81, 0xf9, 0x35, 0x4b, 0xca, 0xeb, 0x9d, 0x17, 0xbb,
  0x0f, 0x42, 0x23, 0xb6, 0x58, 0xc1, 0xfc, 0xfb, 0x36, 0xa9, 0x5d, 0x4c,
  0x6a, 0x7d, 0x2b, 0x0e, 0xac, 0x6a, 0x28, 0xd1, 0x44, 0x2e, 0x12, 0x95,
  0xf9, 0x3b, 0x23, 0x7d, 0xa7, 0xa3, 0x3c, 0x36, 0xfb, 0xcb, 0x48, 0xca,
  0xc3, 0x4b, 0xf2, 0xa8, 0xc2, 0x9a, 0x68, 0xa8, 0xb5, 0xb2, 0x5b, 0x44,
  0xe2, 0x2e, 0xd3, 0x69, 0xa9, 0x56, 0x03, 0x29, 0xe9, 0x3b, 0x61, 0x49,
  0xc6, 0x18, 0xb2, 0xd5, 0x99, 0xe4, 0x32, 0x93, 0x5c, 0xdf, 0x46, 0xea,
  0x4c, 0x4e, 0x5c, 0x4e, 0x84, 0xcb, 0xb1, 0xaf, 0x64, 0x96, 0xf0, 0x58,
  0xab, 0x15, 0xd0, 0xc2, 0x80, 0xd1, 0x1a, 0x4e, 0x5c, 0x61, 0x11, 0xbc,
  0x3c, 0xb1, 0x8a, 0x05, 0xf0, 0x40, 0x07, 0xc2, 0xa7, 0x21, 0x18, 0x8d,
  0x74, 0xc5, 0x72, 0x83, 0x01, 0x60, 0x56, 0x91, 0xfa, 0xe4, 0x76, 0xe2,
  0x3c, 0x01, 0x11, 0x73, 0x0c, 0xa8, 0x17, 0xad, 0x17, 0x15, 0xf4, 0xab,
  0x48, 0xb0, 0xd7, 0xc3, 0xd7, 0x45, 0xa2, 0xe4, 0x78, 0xc4, 0x49, 0x1e,
  0xdf, 0xa1, 0x92, 0x83, 0x64, 0x66, 0xfa, 0xc8, 0xbd, 0x00, 0x3e, 0x1e,
  0xf2, 0x81, 0x5f, 0xf3, 0xe8, 0xec, 0xe8, 0x4d, 0xdf, 0x2a, 0x4a, 0xd1,
  0xef, 0x62, 0x73, 0x31, 0x84, 0x3f, 0xc9, 0x63, 0x59, 0x24, 0x73, 0x8b,
  0x1e, 0x61, 0x9e, 0xa8, 0xe1, 0x2e, 0xe1, 0x04, 0x70, 0x68, 0x44, 0xfd,
  0x16, 0x5e, 0x8b, 0xc3, 0x68, 0x51, 0x86, 0x0e, 0xd7, 0xad, 0x02, 0x54,
  0x86, 0xfd, 0xd4, 0x10, 0xdd, 0x68, 0xd3, 0x85, 0xa5, 0xa2, 0x3f, 0x8e,
  0xbd, 0x64, 0xd7, 0xb8, 0xf3, 0x86, 0x67, 0x96, 0x57, 0x7c, 0xf6, 0xf5,
  0xc1, 0xf0, 0xa3, 0xdd, 0x3d, 0x1d, 0xce, 0x96, 0x09, 0xbf, 0xe0, 0x55,
  0xf5, 0x94, 0x73, 0x66, 0xd7, 0xe1, 0x18, 0x2d, 0x81, 0x98, 0x0f, 0x38,
  0x6f, 0xc6, 0xa6, 0x4b, 0x82, 0xd9, 0xaa, 0x64, 0xc1, 0x6c, 0x48, 0x1d,
  0x3f, 0x93, 0xa4, 0x5c, 0xc5, 0x27, 0x58, 0xfe, 0x19, 0xd6, 0x5c, 0xb1,
  0xc5, 0x4b, 0x17, 0xdc, 0x16, 0xcf, 0xed, 0x23, 0x69, 0x59, 0x5b, 0xe3,
  0x0c, 0x69, 0x1f, 0xc0, 0x51, 0xdf, 0x73, 0xac, 0xb7, 0xff, 0x16, 0xe0,
  0x76, 0x7a, 0xa9, 0x1b, 0x06, 0x8d, 0xef, 0x86, 0x0f, 0x80, 0xc6, 0x6b,
  0x4f, 0xac, 0x3e, 0xc1, 0xdc, 0x23, 0x3b, 0xe3, 0xe9, 0x53, 0xda, 0x28,
  0x3a, 0x59, 0x82, 0x4a, 0x00, 0xa6, 0x20, 0xe5, 0xb3, 0xdd, 0x23, 0x87,
  0x39, 0x10, 0xb4, 0x17, 0x12, 0x39, 0xf9, 0x76, 0x10, 0x7d, 0x95, 0xcc,
  0x91, 0x16, 0x8e, 0x18, 0x33, 0xcb, 0x33, 0xe2, 0x48, 0x38, 0x94, 0x1f,
  0xe1, 0x62, 0x11, 0x27, 0x49, 0xac, 0x58, 0x6f, 0xc4, 0xeb, 0x0a, 0x51,
  0xe4, 0x0c, 0x4a, 0x3d, 0x46, 0x3c, 0x1a, 0xdf, 0x44, 0x6a, 0x8d, 0xe4,
  0x6a, 0x61, 0x69, 0xa1, 0x0d, 0x6c, 0x56, 0x11, 0xdb, 0x18, 0xa3, 0x96,
  0x9b, 0xd3, 0x63, 0xce, 0x2e, 0x15, 0x35, 0x9e, 0xe2, 0x2d, 0x8e, 0xd3,
  0x89, 0x45, 0xb1, 0xf0, 0x4c, 0x65, 0x92, 0x5f, 0x43, 0xc3, 0x2f, 0xe8,
  0xba, 0x89, 0xe7, 0xe3, 0xd5, 0x60, 0x92, 0x10, 0x01, 0xd1, 0x69, 0x1b,
  0x2c, 0x6f, 0xb6, 0x83, 0x63, 0x0a, 0x96, 0x7f, 0x2d, 0x19, 0xf0, 0x55,
  0xfb, 0xae, 0x95, 0xb9, 0x6a, 0x82, 0x53, 0xc5, 0x95, 0x33, 0x01, 0x92,
  0xb0, 0x5c, 0x76, 0x39, 0x9e, 0x6b, 0x61, 0x9d, 0x8e, 0x22, 0x87, 0xc6,
  0x88, 0x16, 0x06, 0x8b, 0x64, 0xf6, 0xc2, 0x65, 0xdb, 0x1a, 0x7f, 0x50,
  0x98, 0x60, 0x27, 0x3f, 0x07, 0xb6, 0xc8, 0x79, 0x72, 0x35, 0x55, 0x81,
  0x22, 0x94, 0xd0, 0x5d, 0x13, 0x2d, 0xc9, 0x0e, 0x22, 0xd7, 0x6b, 0x6d,
  0xea, 0x0d, 0x36, 0x9e, 0xcd, 0xb8, 0xea, 0x80, 0x31, 0x7e, 0x2d, 0xae,
  0xe8, 0x1b, 0x51, 0x5c, 0x0c, 0x06, 0x86, 0x84, 0x18, 0xac, 0x96, 0x0c,
  0x8b, 0xbd, 0x51, 0x2f, 0x0b, 0x7d, 0x2b, 0x14, 0xc2, 0x70, 0xa2, 0x1a,
  0x07, 0xcc, 0x3e, 0x3e, 0x2b, 0x27, 0x25, 0x67, 0x85, 0xbe, 0xbe, 0x7d,
  0x02, 0xc3, 0xee, 0xc5, 0xc9, 0xb0, 0x27, 0xf4, 0x20, 0xb5, 0xd4, 0x03,
  0x58, 0x71, 0x4f, 0x7e, 0x30, 0x73, 0x48, 0xac, 0x96, 0x95, 0xb2, 0xcc,
  0x65, 0x34, 0xc2, 0x19, 0xbc, 0x47, 0xc8, 0x87, 0xfc, 0xdb, 0x42, 0x68,
  0xf0, 0x2c, 0x86, 0x63, 0xc8, 0xfd, 0x22, 0x10, 0x39, 0x2c, 0x13, 0x20,
  0xc4, 0x91, 0xc0, 0xf4, 0xa4, 0x17, 0xf5, 0xf7, 0x18, 0x22, 0x66, 0xb7,
  0xba, 0x90, 0x31, 0x20, 0xf5, 0xe3, 0x31, 0x17, 0x08, 0xd9, 0x70, 0xb5,
  0x83, 0x8d, 0x25, 0x6c, 0x2a, 0x59, 0xdf, 0xd2, 0xfb, 0xf8, 0xb1, 0xa7,
  0x93, 0xba, 0xdd, 0xe5, 0x38, 0x65, 0xc8, 0xa3, 0xb7, 0xc9, 0x74, 0xd5,
  0x14, 0x1b, 0xf6, 0x1e, 0xdc, 0x59, 0xce, 0x08, 0xb8, 0x4b, 0x1d, 0xf2,
  0xa5, 0x00, 0xf8, 0xb2, 0xd5, 0x0f, 0x27, 0x9b, 0xf6, 0xca, 0x06, 0x40,
  0xcb, 0xa8, 0xf6, 0xdc, 0x79, 0x74, 0xbb, 0x67, 0x6e, 0x55, 0x7c, 0x63,
  0x8b, 0x27, 0x76, 0x69, 0xcf, 0x48, 0x1a, 0x69, 0x7a, 0x88, 0xed, 0x0a,
  0x28, 0x17, 0x09, 0x3e, 0x44, 0xb7, 0xc4, 0x49, 0x2a, 0x9c, 0x06, 0x0a,
  0x54, 0xe9, 0x90, 0x76, 0xb0, 0xfd, 0x0c, 0xcc, 0x49, 0xb2, 0xb0, 0x8f,
  0xe8, 0xe1, 0x78, 0x67, 0x3e, 0xd3, 0x24, 0xc1, 0x16, 0xcb, 0x99, 0xd6,
  0x3a, 0x61, 0x46, 0xdc, 0xe3, 0xeb, 0xb6, 0x8c, 0x88, 0x13, 0xa7, 0x12,
  0xdf, 0x36, 0x65, 0x61, 0x9a, 0x05, 0x2c, 0xb5, 0x0c, 0xfa, 0x85, 0x82,
  0xb9, 0x47, 0x50, 0xe3, 0x98, 0x5e, 0xae, 0x53, 0x51, 0xd8, 0x39, 0x1c,
  0x93, 0x17, 0x8c, 0x58, 0x45, 0x37, 0xa2, 0xd3, 0xb7, 0x44, 0xa3, 0x65,
  0xc6, 0xf1, 0x9e, 0x4e, 0x60, 0xd0, 0x9c, 0xb1, 0x21, 0x4b, 0x9d, 0x51,
  0x37, 0x64, 0x92, 0xfd, 0xcf, 0xb0, 0x08, 0x45, 0xd7, 0xaf, 0x9a, 0x82,
  0xb9, 0x56, 0x97, 0x40, 0x9d, 0x01, 0xb4, 0xde, 0xd2, 0xd4, 0x59, 0x6e,
  0x85, 0xf9, 0xba, 0xc9, 0x3d, 0x44, 0xa4, 0xae, 0xf5, 0x2b, 0xdf, 0x4b,
  0xce, 0x3b, 0xaf, 0xef, 0xd9, 0xf1, 0x5b, 0x29, 0x36, 0xe7, 0xce, 0x52,
  0x02, 0xc9, 0x5b, 0x9e, 0x13, 0x41, 0x58, 0xcc, 0xd9, 0x70, 0xd1, 0x89,
  0x81, 0x05, 0x04, 0x87, 0x43, 0x92, 0x5a, 0x77, 0xe7, 0x4b, 0x19, 0x41,
  0x17, 0x37, 0x65, 0x51, 0x4c, 0xbb, 0xb5, 0x1a, 0x4a, 0x6e, 0x47, 0x6b,
  0x57, 0x92, 0x33, 0xdd, 0x8c, 0x27, 0x61, 0x51, 0x48, 0x6d, 0xa5, 0xc2,
  0x29, 0x7b, 0xb5, 0xbc, 0xc0, 0xd0, 0x66, 0xfc, 0x51, 0x34, 0xd8, 0xa6,
  0x0e, 0x8b, 0x6d, 0x7b, 0x71, 0x71, 0x33, 0x2e, 0xe8, 0x8e, 0x44, 0x12,
  0xec, 0x0f, 0xac, 0x85, 0xb3, 0x89, 0x89, 0x86, 0x3c, 0xf9, 0x29, 0xea,
  0x8f, 0xa7, 0x32, 0x43, 0xae, 0xd6, 0xf6, 0x03, 0xd1, 0x0d, 0x9e, 0xf8,
  0x69, 0x03, 0x09, 0x61, 0xc3, 0x77, 0x6f, 0x80, 0xdb, 0xcc, 0x15, 0xb1,
  0x2e, 0xce, 0xf7, 0xdf, 0x0e, 0x5f, 0x8b, 0x59, 0xf1, 0x22, 0x0b, 0x0a,
  0x6d, 0xa9, 0x4d, 0xd6, 0x7c, 0x6f, 0x0e, 0x5a, 0xeb, 0x4e, 0xc0, 0x84,
  0x2d, 0x2c, 0x59, 0xab, 0x70, 0xf5, 0xea, 0x80, 0xb3, 0x52, 0xc2, 0x8b,
  0x19, 0x36, 0x9d, 0xa8, 0xcd, 0x62, 0xcb, 0xdd, 0xae, 0x45, 0x58, 0xbb,
  0xc0, 0x83, 0xba, 0x89, 0x96, 0xe2, 0x1e, 0xc2, 0x99, 0x39, 0xb0, 0xc1,
  0xd8, 0xa7, 0xc2, 0xd0, 0xd7, 0x62, 0x28, 0x1e, 0x90, 0xfe, 0xd1, 0x57,
  0x18, 0xee, 0xa0, 0x52, 0x83, 0x33, 0x45, 0x09, 0x43, 0x57, 0xf8, 0x33,
  0xd7, 0x78, 0x98, 0x33, 0x67, 0x4d, 0x6f, 0xfe, 0x71, 0x77, 0xab, 0xbd,
  0xf9, 0x8b, 0x9f, 0xdb, 0x7c, 0xfb, 0xd8, 0x4d, 0xe0, 0xf7, 0x99, 0x19,
  0x9b, 0x7f, 0xdc, 0xdb, 0x7a, 0x70, 0x46, 0x61, 0x52, 0x99, 0xef, 0x93,
  0xde, 0xc0, 0x60, 0xa3, 0x57, 0x56, 0x56, 0x51, 0x2f, 0x62, 0x17, 0xdd,
  0x70, 0xe9, 0x61, 0xdd, 0x2a, 0x28, 0x07, 0x88, 0x7e, 0x75, 0xe2, 0x9f,
  0x77, 0x5a, 0x68, 0x90, 0xfe, 0xf1, 0xff, 0x38, 0x0a, 0xe1, 0xf0, 0x48,
  0x1b, 0x0f, 0x79, 0x1e, 0xd2, 0xab, 0x8b, 0x6c, 0xc0, 0x7d, 0xef, 0x3d,
  0xd0, 0xb7, 0x9f, 0x5d, 0xa0, 0xeb, 0xc2, 0x03, 0x88, 0x10, 0x22, 0x48,
  0xe3, 0xdb, 0xa4, 0x5d, 0x68, 0x3f, 0x1b, 0xbe, 0x82, 0xdb, 0xfa, 0xfe,
  0x2e, 0x8e, 0xdf, 0x1c, 0xa1, 0x72, 0xc8, 0xe1, 0x31, 0xf0, 0xba, 0x86,
  0x0a, 0x99, 0x67, 0x6a, 0xad, 0x03, 0x12, 0x0d, 0xc1, 0xb4, 0xc5, 0x35,
  0xe6, 0x22, 0x75, 0xdc, 0xf9, 0x77, 0x3b, 0x81, 0xae, 0x35, 0x94, 0xb4,
  0xb0, 0x84, 0xb5, 0xe3, 0xcb, 0xfe, 0x9b, 0x6c, 0xc2, 0xaa, 0x57, 0x5f,
  0xa0, 0x83, 0xe9, 0x2d, 0xfa, 0xf0, 0xdd, 0x7c, 0x56, 0xf9, 0x38, 0x4c,
  0x8b, 0x53, 0xad, 0x7a, 0x63, 0x1d, 0xe0, 0xf8, 0xdf, 0xb7, 0xfb, 0x7d,
  0x2e, 0x9f, 0x28, 0x11, 0x31, 0x6a, 0x17, 0xaf, 0x60, 0x1a, 0xd8, 0xd9,
  0xa7, 0xf5, 0x49, 0xa7, 0x2b, 0xf1, 0xe1, 0xc6, 0x3e, 0xf2, 0xc6, 0xe7,
  0xc0, 0x5d, 0x71, 0xc5, 0x6f, 0x67, 0x31, 0x12, 0x9b, 0xd0, 0x46, 0x05,
  0x8d, 0x11, 0xc2, 0x79, 0x72, 0xe7, 0x43, 0x47, 0xb4, 0x60, 0x55, 0xb6,
  0x58, 0xf1, 0x24, 0xef, 0x2a, 0x5e, 0xe9, 0x56, 0xd7, 0xd4, 0xdf, 0xe5,
  0x9d, 0x0a, 0xc4, 0xbe, 0xf4, 0x10, 0x12, 0xa0, 0x7e, 0xa2, 0x88, 0xf4,
  0xa7, 0x79, 0xc0, 0xc0, 0x74, 0xd8, 0x56, 0x02, 0x22, 0xc0, 0x67, 0x0c,
  0x80, 0x25, 0xab, 0xe3, 0xf4, 0x98, 0x92, 0x1b, 0xb8, 0xdb, 0x06, 0x30,
  0x13, 0x9b, 0x5f, 0x81, 0xb8, 0xce, 0xa2, 0x5a, 0x19, 0x2a, 0x89, 0x2c,
  0x3f, 0x56, 0x72, 0xa0, 0xbb, 0xfd, 0x2e, 0xa3, 0x1f, 0xa7, 0xf3, 0x96,
  0xc9, 0xf4, 0x7f, 0xfe, 0x6c, 0x1a, 0x5e, 0xab, 0xa8, 0x73, 0x09, 0x20,
  0x01, 0xb8, 0x00, 0x3a, 0x32, 0x00, 0xc1, 0xd6, 0x10, 0xda, 0x22, 0xa1,
  0x1e, 0x6c, 0xcd, 0x94, 0x13, 0x51, 0xd4, 0x5c, 0x50, 0xa1, 0xb3, 0x95,
  0x8a, 0xa5, 0x0b, 0x7c, 0x74, 0xb9, 0x98, 0xb0, 0x3f, 0x5b, 0x22, 0xf9,
  0xfe, 0x5b, 0x3c, 0x5f, 0xc6, 0xf9, 0x2a, 0xda, 0xdd, 0xeb, 0x45, 0x7b,
  0x3b, 0xbb, 0x7b, 0x2d, 0x73, 0xe8, 0xfc, 0x37, 0xc4, 0x93, 0xec, 0xf1,
  0xd7, 0x9d, 0xc7, 0xce, 0xc2, 0x47, 0x85, 0xf3, 0xcd, 0xaa, 0xf9, 0x93,
  0xc4, 0x7b, 0xe0, 0xda, 0x92, 0x82, 0x91, 0x28, 0x1f, 0xc5, 0x00, 0x60,
  0x2c, 0x58, 0x88, 0xe1, 0xc9, 0x2a, 0xd1, 0xb8, 0xb2, 0x08, 0x78, 0x62,
  0x23, 0x1a, 0x5f, 0x27, 0x8a, 0xe1, 0xed, 0xad, 0x6f, 0x71, 0xce, 0x65,
  0x76, 0xaa, 0x7b, 0x94, 0x96, 0xb6, 0x2d, 0x88, 0x4a, 0xc0, 0xde, 0x10,
  0xbd, 0x1f, 0x1e, 0x1f, 0x5c, 0x18, 0x42, 0xdc, 0x25, 0xae, 0xd3, 0x7c,
  0xf5, 0xb8, 0x8a, 0x25, 0x0f, 0x3e, 0x33, 0x79, 0x71, 0x9d, 0x90, 0x58,
  0x36, 0x1f, 0x2d, 0xaf, 0x5e, 0xfc, 0x35, 0xce, 0xaf, 0x82, 0x5a, 0xd2,
  0x6b, 0x9e, 0x9f, 0x70, 0x5a, 0xce, 0x0b, 0x62, 0x50, 0xbb, 0xcf, 0x77,
  0x9f, 0x48, 0xcc, 0x77, 0x8a, 0xfa, 0x46, 0xcc, 0x1f, 0xba, 0xb3, 0xae,
  0x00, 0x14, 0x70, 0xb0, 0xb9, 0x43, 0x25, 0x98, 0x4f, 0xba, 0xa2, 0x73,
  0xc5, 0xe1, 0xb3, 0x13, 0x7d, 0x56, 0xf2, 0x77, 0xbb, 0x8c, 0x8b, 0x41,
  0x8f, 0x23, 0xd9, 0x6d, 0xb9, 0xe8, 0x0e, 0x2a, 0x27, 0xfc, 0x03, 0x73,
  0x45, 0x17, 0xae, 0x40, 0xcb, 0x81, 0xf0, 0x64, 0x65, 0xa7, 0xa3, 0x3c,
  0x89, 0x6f, 0x7c, 0x5d, 0x29, 0x8f, 0x5e, 0x60, 0xf6, 0xf3, 0xf3, 0xd7,
  0x07, 0x02, 0xfa, 0x68, 0x59, 0x27, 0xbc, 0xd4, 0xbe, 0xe0, 0xfb, 0x16,
  0x46, 0xf9, 0x81, 0xfe, 0x11, 0x16, 0xfe, 0x62, 0x32, 0x7a, 0xc4, 0x43,
  0x74, 0xee, 0x04, 0x5e, 0x6b, 0xbf, 0x0a, 0x3d, 0x0f, 0xc1, 0xbf, 0x04,
  0xa9, 0x71, 0x09, 0x33, 0xa2, 0x82, 0x4d, 0x29, 0xd7, 0x24, 0x06, 0x6c,
  0xa9, 0xb5, 0xae, 0x35, 0x2c, 0xd5, 0x62, 0x40, 0xe3, 0x46, 0x2d, 0xa4,
  0xc3, 0xfd, 0xb3, 0x40, 0x79, 0x62, 0xe5, 0xc4, 0x1b, 0x8a, 0xf0, 0x1c,
  0x04, 0x67, 0x2e, 0x44, 0x27, 0xf6, 0xa4, 0x55, 0xcf, 0x8b, 0xbc, 0x25,
  0xf3, 0xc9, 0xc9, 0x6d, 0x2c, 0xb1, 0xc5, 0x99, 0x5e, 0x27, 0x6c, 0xd3,
  0x60, 0xec, 0xea, 0xe9, 0x24, 0x66, 0x1f, 0x92, 0x5e, 0x42, 0x2c, 0x8f,
  0x73, 0x5b, 0xa9, 0x06, 0x92, 0xd0, 0xde, 0xdc, 0x47, 0x1a, 0xff, 0xae,
  0x81, 0xfe, 0xf2, 0xbb, 0x3c, 0x86, 0xdc, 0xce, 0x95, 0x4d, 0x40, 0xf8,
  0x33, 0x0d, 0x3e, 0x2e, 0x6e, 0x88, 0x95, 0x8a, 0xef, 0x93, 0x7a, 0x4f,
  0xc7, 0x89, 0x19, 0x56, 0x27, 0xa9, 0xc4, 0x20, 0xc0, 0xa4, 0xc1, 0xd8,
  0x31, 0x95, 0x0d, 0x93, 0x1b, 0x08, 0x1a, 0xcc, 0xb4, 0x48, 0x04, 0xe7,
  0x2d, 0xba, 0xb8, 0xcb, 0x44, 0xea, 0x74, 0xb9, 0xf5, 0x12, 0xc5, 0x57,
  0x2c, 0x53, 0x81, 0x8a, 0xa0, 0xcd, 0x63, 0x7e, 0x10, 0x14, 0x5b, 0xea,
  0x38, 0x6b, 0xca, 0xa1, 0x73, 0x19, 0x0d, 0x0f, 0xbf, 0x8e, 0x90, 0x95,
  0x8c, 0x3e, 0x0e, 0x80, 0x1f, 0x0f, 0xef, 0xef, 0x8c, 0xb5, 0x89, 0x2f,
  0x97, 0x38, 0xef, 0x07, 0xd7, 0xf1, 0x02, 0x42, 0xf1, 0xee, 0x0e, 0x54,
  0xf0, 0x6f, 0x2d, 0xbf, 0x09, 0x07, 0xd5, 0xca, 0xfc, 0x15, 0x9d, 0x40,
  0x3b, 0x9f, 0xa0, 0x4e, 0x1f, 0x84, 0xe2, 0xaa, 0xe1, 0x8f, 0x6e, 0xcf,
  0x62, 0x7b, 0x06, 0x86, 0x35, 0x2d, 0x88, 0x34, 0xf2, 0x62, 0x72, 0xb3,
  0x3d, 0xa6, 0x7f, 0x9e, 0xec, 0x6c, 0x33, 0xf4, 0x60, 0xc9, 0x76, 0x32,
  0xd0, 0xe4, 0xde, 0xde, 0xb3, 0x67, 0xbd, 0xa8, 0x03, 0xcb, 0x95, 0x75,
  0x80, 0x23, 0x41, 0x27, 0xab, 0xd3, 0x56, 0x75, 0x6a, 0x3b, 0xbf, 0x1c,
  0xe3, 0x3f, 0xbc, 0x66, 0x25, 0x77, 0x2e, 0x34, 0x61, 0x81, 0xd7, 0x61,
  0x1e, 0x62, 0x8b, 0x18, 0x59, 0xdd, 0xd1, 0x3e, 0x98, 0x6d, 0x02, 0x6e,
  0x88, 0x45, 0x92, 0x2d, 0xcc, 0xb1, 0x36, 0x5b, 0xe9, 0x75, 0xc3, 0x34,
  0x16, 0x55, 0x92, 0x15, 0xaf, 0x25, 0x92, 0x48, 0x53, 0xc9, 0x8b, 0xe5,
  0xa8, 0xaf, 0x39, 0x95, 0xa2, 0x6b, 0xa4, 0x74, 0x72, 0x67, 0xa8, 0x43,
  0xad, 0x26, 0xe0, 0x06, 0x47, 0xfe, 0x22, 0xea, 0x28, 0x6d, 0xe1, 0xc7,
  0x80, 0xfd, 0x62, 0xc9, 0x18, 0xd3, 0xc8, 0x5e, 0xe9, 0x1f, 0x7f, 0xf9,
  0x0b, 0x35, 0xfb, 0x17, 0xb4, 0xf2, 0xea, 0x8f, 0x45, 0x79, 0x1d, 0x3c,
  0xd3, 0x51, 0x82, 0x3f, 0xf6, 0x5e, 0x41, 0x8e, 0xf4, 0x61, 0x60, 0x4e,
  0x4e, 0xfd, 0x79, 0x73, 0xa2, 0x1c, 0xb9, 0x17, 0xcc, 0x2f, 0xe5, 0xa4,
  0x2c, 0x31, 0xbc, 0x39, 0x47, 0xfb, 0x17, 0xf0, 0xd8, 0x25, 0x48, 0xe6,
  0x25, 0x2a, 0x64, 0xe4, 0xb5, 0x2d, 0x13, 0x31, 0x8e, 0xde, 0x7e, 0x73,
  0x7c, 0x7e, 0xfa, 0xf6, 0xcd, 0xd1, 0xdb, 0x8b, 0xe8, 0x9b, 0xfd, 0xf3,
  0xe3, 0xfd, 0x2f, 0x4e, 0x34, 0x67, 0x18, 0x53, 0x40, 0x7c, 0x84, 0x88,
  0xde, 0x35, 0xdc, 0xcc, 0x20, 0x87, 0xa3, 0x15, 0x28, 0xbe, 0x56, 0x3c,
  0xec, 0xbd, 0x22, 0x31, 0xb3, 0x8d, 0xf5, 0x3d, 0x17, 0x1b, 0xe8, 0xc1,
  0xe9, 0xf7, 0xde, 0xea, 0x0e, 0xc0, 0x76, 0xb9, 0x0a, 0xb2, 0x50, 0x11,
  0xba, 0x01, 0x2a, 0x35, 0xfe, 0xe4, 0xeb, 0x9c, 0x28, 0x94, 0xfd, 0x20,
  0xfa, 0x52, 0x12, 0x99, 0x35, 0x88, 0xc8, 0xbd, 0xaa, 0x49, 0x35, 0x6a,
  0xcb, 0x91, 0xff, 0xb9, 0x5f, 0xf6, 0x4f, 0x4e, 0x7c, 0x97, 0xfb, 0x22,
  0xd8, 0xf6, 0x7d, 0x3e, 0xb0, 0x15, 0xe5, 0xe2, 0x9a, 0xf6, 0x02, 0x63,
  0x23, 0xf9, 0x2f, 0xd7, 0x56, 0xae, 0xf3, 0x2a, 0xf3, 0xf0, 0xd2, 0xf3,
  0x55, 0x88, 0x24, 0x8d, 0x4e, 0x69, 0x5b, 0x36, 0x05, 0x85, 0x00, 0xbe,
  0x47, 0x3a, 0x48, 0x69, 0x71, 0xd3, 0x8b, 0xba, 0x7f, 0xec, 0x4a, 0x5e,
  0x52, 0xc2, 0x30, 0xab, 0xdc, 0x7a, 0xe1, 0xeb, 0x05, 0x46, 0x6f, 0x4f,
  0xfd, 0x98, 0x8e, 0x39, 0x0e, 0x1e, 0x44, 0xc5, 0x61, 0x8f, 0xb9, 0x83,
  0xf0, 0x49, 0x34, 0x9f, 0xb7, 0xcf, 0xae, 0x6d, 0x09, 0xcf, 0xe6, 0x61,
  0x5a, 0xcb, 0xde, 0x59, 0x5a, 0x24, 0x0e, 0xfb, 0x90, 0x91, 0x75, 0x49,
  0x47, 0x8b, 0xc7, 0x01, 0x6a, 0xae, 0x98, 0x6e, 0xa0, 0xed, 0xf2, 0xb5,
  0xaf, 0x55, 0x44, 0x65, 0x5d, 0x61, 0x14, 0x52, 0x7f, 0xd4, 0xb2, 0x50,
  0x76, 0xc9, 0x24, 0x74, 0xbf, 0xad, 0xc0, 0xd5, 0xe2, 0xa4, 0x42, 0xdc,
  0x74, 0x9e, 0x4e, 0x14, 0x84, 0xad, 0x95, 0x04, 0x06, 0xec, 0xdb, 0x38,
  0x3f, 0x60, 0xc8, 0xea, 0x39, 0xaa, 0xcb, 0x38, 0x84, 0x7f, 0x89, 0xb1,
  0x24, 0x96, 0x91, 0x23, 0x71, 0x69, 0xae, 0x12, 0x07, 0xc7, 0x2d, 0xb2,
  0x3c, 0x1e, 0x5f, 0x65, 0x26, 0x6b, 0xc7, 0xce, 0xe1, 0x2a, 0x09, 0x49,
  0x12, 0x92, 0x62, 0x22, 0x97, 0x43, 0x59, 0x72, 0x36, 0x2f, 0x76, 0xcd,
  0x9a, 0x85, 0x19, 0x61, 0x38, 0x65, 0x00, 0x08, 0x5f, 0x04, 0xd9, 0xac,
  0x3e, 0xca, 0x1b, 0x8c, 0x43, 0x9c, 0x92, 0x06, 0x7b, 0xc4, 0xe0, 0x52,
  0x96, 0xfd, 0xca, 0x01, 0x61, 0x3c, 0x2c, 0x3c, 0xc8, 0x4d, 0x6a, 0x6c,
  0x1f, 0x37, 0x69, 0xc6, 0x4f, 0x3a, 0x2a, 0x53, 0x24, 0xda, 0x18, 0xdb,
  0x89, 0xa3, 0x51, 0x7a, 0x15, 0x99, 0xdd, 0x23, 0x02, 0x29, 0x30, 0x04,
  0x56, 0x36, 0x4b, 0xb0, 0x55, 0x0c, 0x70, 0xc5, 0x82, 0xfa, 0x35, 0xaa,
  0x2b, 0x7b, 0x44, 0x26, 0x9b, 0x49, 0x81, 0x40, 0xf4, 0xc0, 0x6e, 0xc6,
  0xb6, 0xf3, 0x25, 0xd6, 0xd1, 0xa2, 0x76, 0x14, 0xbd, 0x59, 0x63, 0x98,
  0x60, 0x94, 0x65, 0x2c, 0xb9, 0x39, 0x67, 0x4c, 0x58, 0xf6, 0x29, 0xaf,
  0x83, 0xc5, 0x77, 0x82, 0x35, 0xb0, 0x29, 0x25, 0x99, 0x5e, 0x46, 0x9b,
  0x0e, 0x7e, 0x99, 0x6b, 0x68, 0x0b, 0x7e, 0x25, 0x28, 0x5b, 0xc2, 0xaf,
  0x2b, 0x65, 0x12, 0x6c, 0xb3, 0x14, 0x67, 0xe8, 0x52, 0x4a, 0x42, 0xd3,
  0xf8, 0x36, 0x03, 0x2e, 0x33, 0x27, 0x12, 0x91, 0xc7, 0x44, 0x59, 0xd4,
  0xbf, 0xfa, 0xe2, 0xaf, 0x8c, 0xad, 0xaa, 0x4f, 0xb1, 0xe5, 0x7d, 0xd6,
  0x72, 0xe5, 0x83, 0x56, 0x25, 0x0d, 0x45, 0xc5, 0x62, 0xda, 0x2f, 0x33,
  0x3d, 0x85, 0x96, 0xab, 0xc8, 0x12, 0x13, 0xa6, 0xd3, 0x00, 0x7f, 0x59,
  0x6c, 0x0f, 0x71, 0x43, 0xd2, 0x70, 0xa5, 0x9d, 0xf7, 0x35, 0x44, 0x42,
  0xb0, 0x5a, 0x83, 0x99, 0x68, 0xf0, 0x2d, 0x64, 0xb1, 0x9a, 0x41, 0x2c,
  0x60, 0x5f, 0xe6, 0x5f, 0x0d, 0xaf, 0x21, 0x2d, 0x01, 0x90, 0xc6, 0x33,
  0x91, 0x14, 0x3d, 0xf9, 0xcd, 0x56, 0x12, 0x9e, 0xb5, 0xb1, 0x71, 0xf0,
  0x6e, 0x78, 0x71, 0xfa, 0x26, 0x3a, 0x7d, 0x77, 0x71, 0xf6, 0xee, 0x42,
  0xef, 0xa9, 0x91, 0x04, 0xb0, 0x8a, 0x42, 0x28, 0x57, 0xbe, 0xed, 0xe6,
  0x4c, 0x9d, 0xc6, 0x1c, 0x9e, 0x90, 0x31, 0xee, 0x5a, 0x00, 0xc2, 0xe2,
  0x92, 0x57, 0x18, 0x93, 0x48, 0xe0, 0x5c, 0x79, 0xcd, 0xef, 0x68, 0xcd,
  0x39, 0xf1, 0x90, 0x0d, 0x39, 0x96, 0x0b, 0xc3, 0x4a, 0x4e, 0x7b, 0x39,
  0x8d, 0x55, 0x55, 0x69, 0x61, 0xf7, 0x6e, 0x15, 0xec, 0xc6, 0x07, 0x9c,
  0x98, 0x21, 0xc7, 0xdb, 0x79, 0xc2, 0xd8, 0x37, 0x8e, 0xfa, 0x18, 0x97,
  0x66, 0xbe, 0xb4, 0xf0, 0x43, 0x0e, 0x34, 0xa9, 0x66, 0x60, 0x85, 0x89,
  0x60, 0x65, 0x46, 0x33, 0xbc, 0x76, 0xa1, 0xc3, 0x88, 0x92, 0xe6, 0x90,
  0x29, 0x71, 0xc1, 0x23, 0x36, 0xc9, 0xea, 0x33, 0xdf, 0xc1, 0xe8, 0xdd,
  0xb8, 0x53, 0xef, 0xa2, 0xee, 0xb7, 0x49, 0xd8, 0xe0, 0xef, 0xff, 0x81,
  0xfc, 0xb6, 0xf7, 0xf6, 0xc9, 0x3f, 0xa5, 0xcb, 0x1f, 0xe7, 0x5d, 0x8e,
  0x34, 0xaa, 0xfa, 0x5a, 0xbf, 0x3e, 0x3a, 0xff, 0xe2, 0xe8, 0xfc, 0x74,
  0xc8, 0xf1, 0x26, 0x66, 0xdb, 0x6a, 0x12, 0xfb, 0x4d, 0x92, 0x8f, 0x92,
  0x3c, 0xd3, 0x0a, 0x29, 0xf6, 0xd7, 0xb3, 0xed, 0x2f, 0x87, 0xc3, 0xfd,
  0xb3, 0x63, 0x57, 0x4c, 0xc3, 0x65, 0xda, 0x88, 0x42, 0x34, 0x97, 0x5c,
  0x30, 0xcc, 0xdf, 0x5e, 0x21, 0xba, 0x18, 0xdf, 0x48, 0x04, 0x66, 0xc3,
  0xab, 0x69, 0x56, 0x59, 0xb8, 0x33, 0x35, 0x01, 0x0b, 0x0d, 0x1b, 0x78,
  0xce, 0x46, 0x50, 0x9b, 0xfc, 0x35, 0x8c, 0xc8, 0x3d, 0x17, 0xa5, 0x74,
  0x93, 0x8f, 0xfa, 0x44, 0xe8, 0x37, 0x56, 0x7c, 0x4e, 0x62, 0xc5, 0x89,
  0x4d, 0x4a, 0x10, 0xa9, 0x37, 0x2a, 0xdc, 0xa0, 0x20, 0xe4, 0xf6, 0x0d,
  0x8e, 0x06, 0xea, 0x3f, 0x4c, 0x07, 0xc2, 0xd9, 0xe5, 0x2c, 0x59, 0x64,
  0x20, 0xd8, 0xeb, 0x43, 0xb9, 0xfc, 0xd4, 0x9b, 0x2b, 0x24, 0x24, 0x76,
  0x2d, 0xfa, 0xe4, 0xa9, 0x03, 0x33, 0x0a, 0x6b, 0x05, 0x5e, 0x92, 0xa4,
  0xbd, 0xb8, 0x9b, 0xe8, 0x05, 0xc2, 0xf8, 0xbd, 0x73, 0xb1, 0x6b, 0x0b,
  0xff, 0xae, 0x7b, 0x37, 0x50, 0xf9, 0x88, 0x83, 0xda, 0x35, 0x64, 0x37,
  0x1a, 0x4d, 0xe3, 0xf9, 0x0d, 0xdf, 0x64, 0x7c, 0x33, 0x41, 0xb7, 0x34,
  0xa8, 0x1e, 0xd4, 0x89, 0x62, 0x67, 0x96, 0x66, 0xcf, 0xb3, 0xb4, 0x67,
  0x75, 0x85, 0x61, 0xc8, 0x75, 0x88, 0x44, 0x81, 0xdb, 0x86, 0x4f, 0x92,
  0x5f, 0x04, 0x98, 0x88, 0xb8, 0xd0, 0xba, 0x0b, 0xc4, 0x67, 0x5d, 0x5c,
  0x2a, 0xa9, 0x5b, 0x38, 0x89, 0xe4, 0x9e, 0xa5, 0xcc, 0xc4, 0x84, 0x71,
  0x18, 0xb4, 0x34, 0x3b, 0x1e, 0x98, 0x52, 0x38, 0xc5, 0xae, 0x70, 0x15,
  0x18, 0x94, 0x6b, 0x6b, 0x59, 0xe9, 0xb2, 0x52, 0x90, 0x21, 0xac, 0xd6,
  0xa1, 0x48, 0xd7, 0x07, 0x3e, 0x98, 0x24, 0xb6, 0xef, 0x64, 0x10, 0x5e,
  0xfe, 0x74, 0xee, 0xa9, 0x4a, 0x06, 0xc0, 0xda, 0x6d, 0x92, 0xd7, 0xdb,
  0xb4, 0x7d, 0x66, 0x80, 0xd4, 0x80, 0x18, 0xbb, 0x1d, 0x7a, 0x8a, 0x85,
  0x75, 0x56, 0x43, 0x29, 0x6d, 0xe0, 0x03, 0xab, 0x5e, 0xcc, 0x01, 0x4f,
  0xe2, 0x71, 0xe2, 0x30, 0x40, 0xbd, 0x7d, 0xcb, 0x09, 0x73, 0x9b, 0xbc,
  0x02, 0xe3, 0x19, 0x46, 0x30, 0x4a, 0x82, 0x3f, 0xdb, 0x00, 0x25, 0xa6,
  0x9d, 0xd5, 0x15, 0x27, 0xc8, 0xf6, 0xdf, 0xe2, 0xaa, 0xc8, 0xfa, 0xa3,
  0x25, 0x2b, 0x60, 0x1e, 0x8a, 0x4a, 0xf3, 0xdc, 0x50, 0x0f, 0x94, 0xb1,
  0xa7, 0xf8, 0x7b, 0x38, 0x32, 0x38, 0x83, 0x58, 0x7c, 0x1b, 0x9c, 0x52,
  0x56, 0xc5, 0x25, 0x71, 0x68, 0x14, 0x12, 0xa7, 0xcd, 0xf1, 0xaa, 0x1a,
  0x94, 0xab, 0x23, 0xd4, 0x4d, 0x76, 0x31, 0x66, 0x73, 0x2d, 0x67, 0xc6,
  0x46, 0xf5, 0x6a, 0x54, 0x6a, 0xe9, 0xa0, 0xc0, 0x2f, 0x58, 0x44, 0x48,
  0x14, 0x20, 0xdb, 0xc2, 0x4d, 0x2d, 0xb8, 0xfd, 0xb6, 0x44, 0xe1, 0x1b,
  0x49, 0xa4, 0x8f, 0xa7, 0x52, 0xc2, 0x60, 0xed, 0x2d, 0x22, 0x87, 0xa9,
  0xbc, 0xb8, 0xf8, 0xfe, 0xec, 0xe8, 0x95, 0xbd, 0xf9, 0xd0, 0x9e, 0x09,
  0xbe, 0x14, 0x07, 0x5c, 0x24, 0x8a, 0xe4, 0x18, 0x14, 0xf8, 0x23, 0x22,
  0xeb, 0x97, 0xe6, 0x08, 0x96, 0x6e, 0xfa, 0xd1, 0x77, 0x87, 0xc7, 0xc3,
  0xb3, 0x93, 0xd3, 0x83, 0x57, 0x2f, 0xbf, 0x33, 0x6e, 0xfc, 0x19, 0x00,
  0x55, 0x44, 0x46, 0x73, 0x9f, 0xf9, 0xfc, 0x77, 0x7d, 0xef, 0xed, 0xd1,
  0xb7, 0xef, 0x49, 0x0d, 0x78, 0x05, 0xc4, 0xeb, 0xde, 0x6d, 0x3c, 0xd5,
  0x97, 0xa0, 0x4b, 0xb5, 0xc8, 0x75, 0x41, 0xb6, 0x42, 0xdb, 0xc2, 0xba,
  0x9a, 0xd6, 0x3e, 0x96, 0x7b, 0x65, 0x31, 0x58, 0x41, 0xe1, 0x9c, 0xb8,
  0x92, 0x7a, 0xd8, 0x52, 0x35, 0x2f, 0x73, 0x37, 0x7f, 0xb7, 0x94, 0x58,
  0x3c, 0xf8, 0x9f, 0x43, 0xb7, 0x2e, 0x47, 0x6e, 0xea, 0x37, 0x3e, 0xe6,
  0x51, 0xb1, 0x65, 0x73, 0x44, 0x3f, 0x38, 0x8c, 0x3e, 0xe9, 0x58, 0x1c,
  0xa6, 0x0a, 0xe4, 0xa7, 0x40, 0x35, 0x80, 0x27, 0xb0, 0x88, 0x63, 0x57,
  0x80, 0x55, 0xc4, 0x17, 0x37, 0x96, 0x78, 0x3c, 0xa6, 0x1f, 0x00, 0x50,
  0x44, 0xb1, 0x92, 0x33, 0x14, 0x64, 0x1e, 0x5e, 0x40, 0x5f, 0x3a, 0x38,
  0x7d, 0xfb, 0xf6, 0xe8, 0xc0, 0x6c, 0xcd, 0x56, 0xeb, 0x8b, 0xf3, 0xda,
  0xab, 0xc0, 0x8c, 0x61, 0x1d, 0x85, 0xca, 0x89, 0x76, 0x6c, 0xae, 0x9a,
  0xe8, 0x06, 0x93, 0x81, 0x64, 0xcf, 0x41, 0x08, 0x15, 0x78, 0xd1, 0xf8,
  0xd2, 0x0e, 0x70, 0xa6, 0xa4, 0x51, 0x2b, 0x27, 0xc0, 0xb5, 0x40, 0x78,
  0x77, 0xa6, 0xe9, 0xc8, 0x5b, 0xc7, 0x6b, 0xbe, 0x47, 0xb8, 0xb6, 0x15,
  0xd0, 0x20, 0x3c, 0x42, 0x66, 0xf7, 0xf6, 0xd9, 0xa3, 0x45, 0x66, 0x75,
  0xed, 0x84, 0xf8, 0xd9, 0x2e, 0x1d, 0xe6, 0xf8, 0x39, 0x8d, 0x94, 0xd5,
  0x10, 0x13, 0xd1, 0xdc, 0xa7, 0x41, 0xf0, 0xa2, 0x62, 0xe4, 0x30, 0xb0,
  0xa7, 0xb2, 0x6c, 0x2e, 0x55, 0x2c, 0xd9, 0x3a, 0xb0, 0xa8, 0x90, 0xc0,
  0xc2, 0xd9, 0xc7, 0x1c, 0x64, 0xa2, 0x33, 0x6b, 0x48, 0x1f, 0x2a, 0x36,
  0x5e, 0x21, 0xcd, 0x87, 0x81, 0x88, 0x26, 0x10, 0xb5, 0xd8, 0xd4, 0x16,
  0x76, 0x66, 0x37, 0x29, 0x56, 0xd0, 0xaa, 0x81, 0x8b, 0x1b, 0xd6, 0x8d,
  0x5e, 0xea, 0x35, 0xf0, 0xc2, 0x73, 0x78, 0x5d, 0x9c, 0x33, 0xc2, 0x5f,
  0xa9, 0x30, 0xda, 0xa6, 0xf4, 0x68, 0xac, 0xdc, 0xa0, 0x8a, 0x79, 0x62,
  0x74, 0xa9, 0xc1, 0x2d, 0x0f, 0xae, 0xa8, 0x5b, 0x4d, 0x21, 0xdf, 0x3c,
  0xb1, 0xa0, 0x17, 0xb1, 0x27, 0x14, 0x70, 0x2c, 0xcc, 0xc7, 0xee, 0x32,
  0x46, 0x62, 0x06, 0x82, 0x3f, 0x72, 0xc5, 0x93, 0x59, 0xa2, 0x2e, 0xb2,
  0x96, 0x76, 0xe4, 0xc2, 0x84, 0xf0, 0xae, 0x19, 0xd6, 0x98, 0x03, 0xe9,
  0xd0, 0xe5, 0x0e, 0xc8, 0x4a, 0xec, 0xe8, 0x2b, 0xed, 0xd0, 0x25, 0x11,
  0xdb, 0x66, 0xf5, 0x24, 0x27, 0x25, 0xe6, 0x14, 0x08, 0x33, 0xe0, 0x06,
  0xa9, 0x74, 0x85, 0x26, 0x28, 0x3a, 0xcf, 0xa4, 0x30, 0x3c, 0xae, 0xc7,
  0xe3, 0x53, 0x7a, 0x2a, 0x1e, 0x40, 0x92, 0x2c, 0x17, 0x5c, 0x5c, 0x66,
  0xac, 0xf0, 0xda, 0x1c, 0xee, 0xe9, 0xda, 0xb3, 0x3b, 0xc4, 0xaf, 0x15,
  0x2d, 0xea, 0x9b, 0x77, 0x27, 0x17, 0xc7, 0x67, 0xa1, 0x97, 0x31, 0xfa,
  0xf6, 0xf8, 0xe2, 0x2b, 0x92, 0xd7, 0x51, 0x38, 0xf6, 0x04, 0xae, 0x9c,
  0x37, 0x6f, 0xf6, 0xdf, 0x22, 0x01, 0xfb, 0x2d, 0x47, 0xc5, 0xed, 0xb3,
  0xce, 0x00, 0x6e, 0x44, 0x2b, 0x0c, 0xd2, 0x41, 0x6a, 0x6e, 0xaf, 0xe9,
  0x52, 0xa8, 0x9d, 0x3e, 0x66, 0x38, 0x38, 0x42, 0xe1, 0x1a, 0x61, 0xc3,
  0x55, 0x27, 0x58, 0xc1, 0x80, 0xc3, 0xa7, 0x16, 0x7a, 0x16, 0xd6, 0xb9,
  0x8e, 0xab, 0xcd, 0x69, 0x60, 0x22, 0x9b, 0xb3, 0x03, 0x55, 0xae, 0x6e,
  0xef, 0xa6, 0xe0, 0x0d, 0x75, 0xe0, 0x9c, 0x1c, 0xa5, 0x4a, 0x22, 0xd3,
  0x5c, 0x55, 0x1a, 0xb9, 0x2e, 0xab, 0x61, 0xd9, 0xd4, 0x23, 0x0f, 0x89,
  0x5d, 0xc8, 0x99, 0xb7, 0xfc, 0x41, 0xd9, 0x84, 0xbe, 0x7c, 0x7e, 0x12,
  0xde, 0xa7, 0x83, 0x4a, 0x35, 0x26, 0x0b, 0x2d, 0xbb, 0xca, 0x12, 0x7f,
  0x70, 0xfb, 0xa7, 0x41, 0xd1, 0xd4, 0xd0, 0xaa, 0xfc, 0x42, 0xe4, 0xc6,
  0x4a, 0x11, 0x60, 0xc6, 0x3c, 0x3d, 0x75, 0xef, 0x6a, 0x90, 0x02, 0xc7,
  0xea, 0x6a, 0x6e, 0x87, 0xce, 0x8a, 0xd9, 0xa1, 0x3d, 0x56, 0x49, 0x4d,
  0xad, 0x55, 0x22, 0xb6, 0xdc, 0x1e, 0xce, 0xe8, 0x03, 0x06, 0x89, 0x77,
  0x81, 0x72, 0x59, 0xa9, 0x2c, 0x1b, 0x24, 0xf7, 0x09, 0xbc, 0x95, 0xf8,
  0xf5, 0xaf, 0x8b, 0xab, 0x30, 0xed, 0x87, 0x67, 0xa3, 0xf9, 0xad, 0xed,
  0x90, 0xb6, 0x22, 0xf7, 0x68, 0x71, 0xad, 0xca, 0x08, 0xb4, 0x62, 0xd6,
  0xee, 0xba, 0x0e, 0xf5, 0xfb, 0xbd, 0xe6, 0xf7, 0x7b, 0x62, 0x40, 0x7c,
  0xb3, 0x7f, 0x7c, 0x02, 0x7f, 0xf7, 0x09, 0x31, 0xf5, 0xa1, 0xad, 0x1d,
  0x07, 0x05, 0xb0, 0xbf, 0x9e, 0xd4, 0x3b, 0x3a, 0xa0, 0x3d, 0x07, 0xc5,
  0x6c, 0xb1, 0xb5, 0xcc, 0xa9, 0x60, 0xb7, 0x93, 0xcb, 0x5e, 0x91, 0x53,
  0xe8, 0x8a, 0xa5, 0x05, 0x2c, 0x44, 0x43, 0x63, 0x80, 0x32, 0x20, 0x77,
  0xb2, 0x8d, 0x94, 0x2f, 0x51, 0x09, 0x60, 0x60, 0xf4, 0xf7, 0x3c, 0x99,
  0x26, 0xb7, 0xaa, 0x4a, 0x09, 0xdc, 0xd3, 0x97, 0x6a, 0x9e, 0x94, 0xea,
  0x4f, 0xa5, 0xb7, 0xb2, 0x56, 0x2c, 0xa0, 0xe8, 0x73, 0x5b, 0x32, 0x65,
  0x7d, 0x02, 0x24, 0xba, 0xf7, 0xd8, 0xa4, 0x66, 0x0d, 0xc6, 0x7b, 0x7d,
  0xdc, 0x6a, 0x85, 0xac, 0xd8, 0xbb, 0x42, 0x73, 0xdc, 0xea, 0xa1, 0x45,
  0xa2, 0x1d, 0x58, 0xf9, 0x10, 0xd1, 0xb4, 0x7b, 0x86, 0x22, 0x27, 0xf6,
  0x01, 0x30, 0xc2, 0x1e, 0xb4, 0x32, 0x6e, 0xe9, 0x92, 0x58, 0x30, 0x80,
  0x82, 0x7b, 0x92, 0x5f, 0xc1, 0x34, 0x4d, 0xba, 0x78, 0x2f, 0x62, 0x47,
  0x29, 0xf8, 0x1f, 0x3f, 0x0b, 0x14, 0xac, 0x20, 0x7c, 0x81, 0xfe, 0x94,
  0xd8, 0x39, 0xfd, 0x8b, 0x9b, 0xca, 0x97, 0x0c, 0xb6, 0xd6, 0xe3, 0x20,
  0x56, 0xb6, 0x27, 0x6a, 0xbd, 0x62, 0x1e, 0xbd, 0x9a, 0xf3, 0x65, 0xfc,
  0x87, 0x66, 0x6d, 0x36, 0xac, 0xab, 0x2c, 0xb7, 0xd5, 0x95, 0x5d, 0x18,
  0x49, 0xb5, 0x97, 0x2f, 0x96, 0x30, 0x7c, 0x39, 0x34, 0x73, 0x8c, 0x62,
  0x86, 0x2a, 0x4d, 0x89, 0x14, 0x56, 0x72, 0x8d, 0x83, 0x87, 0x2f, 0x69,
  0x77, 0xa5, 0xf5, 0x93, 0xec, 0x0e, 0x65, 0xa1, 0x2e, 0x2f, 0x51, 0xa3,
  0xf6, 0x74, 0xee, 0x41, 0xd5, 0x70, 0x66, 0xe4, 0xc1, 0x99, 0x41, 0xd1,
  0xd3, 0xdc, 0xa2, 0xc5, 0x72, 0x34, 0x25, 0x35, 0xc1, 0xa2, 0x9f, 0x06,
  0xd1, 0x3e, 0xaf, 0x12, 0xb1, 0x57, 0x6e, 0x4e, 0xcc, 0xf4, 0x7c, 0xc3,
  0xd4, 0x82, 0x6d, 0xb4, 0x5c, 0x25, 0x8e, 0xe4, 0x8c, 0xeb, 0x63, 0x21,
  0xa8, 0x64, 0x96, 0xcd, 0x2d, 0x76, 0x72, 0x59, 0x08, 0xc4, 0x8e, 0xd5,
  0xb6, 0xdc, 0x10, 0x33, 0x44, 0x3a, 0x55, 0x4c, 0x4b, 0xbd, 0x8b, 0xf9,
  0x8d, 0x70, 0x32, 0x93, 0xfe, 0xe2, 0x7a, 0x61, 0x3b, 0x6d, 0x4c, 0x5f,
  0x62, 0xf7, 0x35, 0x5a, 0x8f, 0xcf, 0xd3, 0xd9, 0x57, 0x67, 0x83, 0xe8,
  0x08, 0x2d, 0xc9, 0x98, 0x54, 0x54, 0x60, 0xa1, 0x8c, 0xbe, 0xa3, 0xc9,
  0x5e, 0x21, 0x2b, 0xf7, 0x34, 0xc7, 0x5f, 0xdc, 0x9a, 0x7e, 0x29, 0x7a,
  0x18, 0x7f, 0x5b, 0xed, 0x95, 0x1a, 0xca, 0xb4, 0xaa, 0xf1, 0x19, 0xff,
  0x4e, 0x47, 0x85, 0xd4, 0x53, 0xb7, 0x4d, 0xbe, 0x87, 0x2c, 0xaf, 0x24,
  0x24, 0xcb, 0x9b, 0xd1, 0x28, 0x15, 0x9d, 0x7f, 0xb1, 0xe2, 0xfd, 0x63,
  0x19, 0x9e, 0xb3, 0xd8, 0x35, 0xdb, 0x45, 0x1a, 0x08, 0x48, 0x4b, 0xc9,
  0xcf, 0x39, 0xe6, 0xe5, 0x5c, 0xe5, 0x92, 0x8a, 0x9b, 0x27, 0x1a, 0xc6,
  0x90, 0xa9, 0x4d, 0x54, 0x44, 0x98, 0x22, 0xa9, 0x1d, 0xd7, 0x80, 0x63,
  0xdb, 0x17, 0xb8, 0x67, 0x31, 0x96, 0xdb, 0x74, 0x42, 0x5b, 0x30, 0xd8,
  0xf8, 0x5f, 0x3c, 0x60, 0xfe, 0x72, 0x59, 0xda, 0x01, 0x00,
};
/* Decompress and send to stdout a gzip-compressed buffer */
void hugehelp(void)
{
  unsigned char buf[0x10000];
  int status,headerlen;
  z_stream z;

  /* Make sure no gzip options are set */
  if (hugehelpgz[3] & 0xfe)
    return;

  headerlen = 10;
  z.avail_in = (unsigned int)(sizeof(hugehelpgz) - headerlen);
  z.next_in = (unsigned char *)hugehelpgz + headerlen;
  z.zalloc = (alloc_func)Z_NULL;
  z.zfree = (free_func)Z_NULL;
  z.opaque = 0;

  if (inflateInit2(&z, -MAX_WBITS) != Z_OK)
    return;

  while(1) {
    z.avail_out = (int)sizeof(buf);
    z.next_out = buf;
    status = inflate(&z, Z_SYNC_FLUSH);
    if (status == Z_OK || status == Z_STREAM_END) {
      fwrite(buf, sizeof(buf) - z.avail_out, 1, stdout);
      if (status == Z_STREAM_END)
         break;
    }
     else
      break;    /* Error */
  }
  inflateEnd(&z);
}
#endif /* USE_MANUAL */
#endif /* HAVE_LIBZ */
