/* dialogs.h
 * header files for callbacks that create dialog boxes prompting the
 * user for further action

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000-2005 Matthew Hiller */

#ifndef __DIALOGS_H__
#define __DIALOGS_H__

#include <gtk/gtk.h>
#include <denemo/denemo.h>

typedef enum actiontype
{ CHANGEINITIAL, INSERT } 
actiontype;

void clef_change_initial(GtkAction *action, scoreinfo *si);
void clef_change_insert(GtkAction *action, scoreinfo *si);

void key_change_initial(GtkAction *action, scoreinfo *si);
void key_change_insert(GtkAction *action, scoreinfo *si);

void timesig_change_initial(GtkAction *action,scoreinfo *si);
void timesig_change_insert(GtkAction *action, scoreinfo *si);

void
clef_change (scoreinfo *si,actiontype action);

void
key_change (scoreinfo *si,  actiontype action);

void
timesig_change (scoreinfo *si, actiontype action);

void
score_mwidth_change (GtkAction *action, gpointer callback_data);

void
score_staffspace_change (GtkAction *action, gpointer callback_data);




gboolean
staff_properties_change (GtkAction *action, gpointer callback_data);

//void
//new_score (gpointer callback_data, guint callback_action, 
//GtkWidget * widget);

void
playback_properties_change (GtkAction *action, gpointer callback_data);



void
tomeasurenum (GtkAction *action, scoreinfo *si);

void
preferences_change (GtkAction *action, scoreinfo *si);

void
header_change (GtkAction *action, scoreinfo *si);

void
score_properties_dialog(GtkAction *action, scoreinfo *si);

void export_pdf_action (GtkAction *action, scoreinfo *si);

#endif /* __DIALOGS_H__ */
