# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from elisa.base_components.view import View

import pygtk
pygtk.require('2.0')
import gtk


# FIXME: this code remains untested and is certainly broken
class GtkListView(View):
    """
    This class implements gtk list view support
    """

    supported_controllers = ('base:list_controller',)

    def __init__(self):
        View.__init__(self)
        self.context_path = 'gtk:gtk_context'
        self.liststore = gtk.ListStore(str)
        self.treeview = gtk.TreeView(self.liststore)
        self.context_handle = self.treeview

    def initialize(self):
        self.tvcolumn1 = gtk.TreeViewColumn("Test list")

        self.treeview.append_column(self.tvcolumn1)
        self.cell1 = gtk.CellRendererText()
        #self.cell1.set_property('cell-background', 'pink')
        self.tvcolumn1.pack_start(self.cell1, True)
        self.tvcolumn1.set_attributes(self.cell1, text=0)

        tree_selection = self.treeview.get_selection()
        tree_selection.set_mode(gtk.SELECTION_SINGLE)
        tree_selection.connect("changed", self._gtk_selection_changed)


    def _gtk_selection_changed(self, selection):
        selected_rows = selection.get_selected_rows()
        if selected_rows[1]:
            new_index = selected_rows[1][0][0]
            self.controller.model.current_selection = new_index


    def update(self):
        self.liststore.clear()

        for model in self._controller.model:
            self.liststore.append([model])
        tree_selection = self.treeview.get_selection()

        if len(self._controller.model):
            iter = self.liststore.get_iter(0)
            tree_selection.select_iter(iter)

    def inserted(self, elements, position):
        self.update()

    def removed(self, elements, position):
        self.update()

    def modified(self, key, value):
        self.update()

    def dirtied(self):
        self.update()

    def selection_changed(self, old_index, new_index):
        self.treeview.get_selection().select_path(new_index)
