# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.base_components.input_provider import PushInputProvider
from elisa.core.input_event import *

import pygst
pygst.require ("0.10")
import gst


class WebcamInput(PushInputProvider):

    def create_input_event(self, data):
        self.debug("input data=%r", data)

        event = InputEvent(EventSource.KEYBOARD,
                           EventType.KEY_DOWN,
                           EventAction.NONE)
        event.origin = self.origin

        """
        if self._previous_direction * data < 0.0:
            if data > 0.0:
                event.action = EventAction.PAUSE
            else:
                event.action = EventAction.PLAY
        """

#        if abs(data - self._previous_direction) > 50.0:
        if data > 70.0:
            event.action = EventAction.GO_LEFT
        elif data < -40.0:
            event.action = EventAction.GO_RIGHT

        """
        if data == '\n':
            event.value = EventValue.KEY_RETURN
            return event
        elif data in string.ascii_letters + string.digits:
            event.value = eval("EventValue.KEY_%s" % data)

        if data == 'z':
            event.action = EventAction.GO_UP
        elif data == 'q':
            event.action = EventAction.GO_LEFT
        elif data == 's':
            event.action = EventAction.GO_DOWN
        elif data == 'd':
            event.action = EventAction.GO_RIGHT
        elif data == 'o':
            event.action = EventAction.PLAY
        elif data == 'p':
            event.action = EventAction.PAUSE
        elif data == 'w':
            event.action = EventAction.EXIT
        elif data == '?':
            self._display_help()
        """

        return event


    def dataReceived(self, element, params):
        direction = element.props.direction

        e = self.create_input_event(direction)
        if (e and self.input_manager):
            self.input_manager.process_event(e, self.path)

        self._previous_direction = direction

    def bind(self):
        """
        pipeline = gst.parse_launch("v4lsrc autoprobe-fps=false ! tee name=t ! \
        queue ! ffmpegcolorspace ! redgreentv name=rg red-weight=160.0 \
        green-weight=80.0 ! ffmpegcolorspace ! videoscale ! \
        video/x-raw-rgb,width=320,height=240 ! ximagesink t. ! queue ! \
        ffmpegcolorspace ! ximagesink")
        """

        pipeline = gst.parse_launch("v4lsrc autoprobe-fps=false ! tee name=t ! \
        queue ! ffmpegcolorspace ! redgreentv name=rg red-weight=160.0 \
        green-weight=80.0 ! ffmpegcolorspace ! videoscale ! \
        video/x-raw-rgb,width=320,height=240 ! ximagesink t. ! queue ! \
        ffmpegcolorspace ! videoscale ! video/x-raw-rgb,width=320,height=240 ! ximagesink")

        pipeline.set_state(gst.STATE_PLAYING)

        rg = pipeline.get_by_name('rg')
        rg.connect('notify::direction', self.dataReceived)
        self._previous_direction = 0.0


    def unbind(self):
        pass
