# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.base_components.transition import Transition

from pgm.timing import implicit


class PigmentTransition(Transition):
    """
    Provides Pigment specific facilities to write transitions such as a
    wrapper that animates implicitly the view to which the transition is
    applied.

    @ivar implicit:   wrapper that animates implicitly the view
    @type implicit:   L{pgm.timing.implicit.AnimatedObject}
    """

    # FIXME: activate when all Pigment based views will inherit from
    # PigmentView
#    supported_views = ("pigment:pigment_view",)

    def __init__(self):
        Transition.__init__(self)
        self.implicit = None

    def apply(self, view, end_callback=None):
        Transition.apply(self, view, end_callback)

        widget = view.context_handle
        self.implicit = implicit.AnimatedObject(widget)

    def stop(self):
        if self.implicit != None and self.implicit.is_animated():
            self.implicit.stop_animations()
        Transition.stop(self)
