/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "MPL"); you may not use this file
 * except in compliance with the MPL. You may obtain a copy of
 * the MPL at http://www.mozilla.org/MPL/
 *
 * Software distributed under the MPL is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the MPL for the specific language governing
 * rights and limitations under the MPL.
 *
 * The Original Code is Enigmail.
 *
 * The Initial Developer of the Original Code is Patrick Brunschwig
 * Portions created by Patrick Brunschwig <patrick@mozilla-enigmail.org>
 * are Copyright (C) 2006 Patrick Brunschwig. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License (the "GPL"), in which case
 * the provisions of the GPL are applicable instead of
 * those above. If you wish to allow use of your version of this
 * file only under the terms of the GPL and not to allow
 * others to use your version of this file under the MPL, indicate
 * your decision by deleting the provisions above and replace them
 * with the notice and other provisions required by the GPL.
 * If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

#ifndef enigmail_h__
#define enigmail_h__

#define MOZILLA_INTERNAL_API

#if MOZILLA_MAJOR_VERSION==1 && MOZILLA_MINOR_VERSION<9
#define _ENIG_MOZILLA_1_8
#else
#define _ENIG_MOZILLA_1_9
#endif

#ifdef FORCE_PR_LOG
#include "nsIThread.h"
#ifdef _ENIG_MOZILLA_1_8
// Mozilla 1.8
#define ENIG_GET_THREAD(myThread) nsIThread::GetCurrent(getter_AddRefs(myThread))

#else
// Mozilla 1.9
#include "nsThreadUtils.h"

#define ENIG_GET_THREAD(myThread) NS_GetCurrentThread(getter_AddRefs(myThread))

#endif
#endif
#endif
