/**
 * GMyth Library
 *
 * @file gmyth/gmyth_debug.c
 * 
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Renato Filho <renato.filho@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gmyth_debug.h"

void
gmyth_debug_real(const char *func,
                 const char *file, const int line, gboolean newline,
                 const char *format, ...)
{
    va_list         args;
    char            buffer[1025];
    char            str_time[255];
    time_t          the_time;

    va_start(args, format);

    g_vsnprintf(buffer, 1024, format, args);

    va_end(args);

    time(&the_time);
    strftime(str_time, 254, "%H:%M:%S", localtime(&the_time));

    g_printerr(newline ? "(%s) [%p] [%s] %s:%d: %s\n" :
               "(%s) [%p] [%s] %s:%d: %s", str_time, g_thread_self(), func,
               file, line, buffer);
}
