/**
 * GMyth Library
 *
 * @file gmyth/gmyth_epg.h
 * 
 * @brief <p> GMythEPG class provides access to the program and channel data
 * from the Electronic Program Guide (EPG) of the Mythtv backend.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Leonardo Sobral Cunha <leonardo.cunha@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GMYTH_EPG_H_
#define GMYTH_EPG_H_

#include <glib-object.h>

#include "gmyth_query.h"
#include "gmyth_common.h"

G_BEGIN_DECLS
#define GMYTH_EPG_TYPE               (gmyth_epg_get_type ())
#define GMYTH_EPG(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_EPG_TYPE, GMythEPG))
#define GMYTH_EPG_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_EPG_TYPE, GMythEPGClass))
#define IS_GMYTH_EPG(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_EPG_TYPE))
#define IS_GMYTH_EPG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_EPG_TYPE))
#define GMYTH_EPG_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_EPG_TYPE, GMythEPGClass))
typedef struct _GMythEPG GMythEPG;
typedef struct _GMythEPGClass GMythEPGClass;

struct _GMythEPGClass {
    GObjectClass    parent_class;

    /*
     * callbacks 
     */
    /*
     * no one for now 
     */
};

struct _GMythEPG {
    GObject         parent;

    GMythQuery     *sqlquery;
    GMythBackendInfo *backend_info;
};

GType           gmyth_epg_get_type              (void) G_GNUC_CONST;;
GMythEPG*       gmyth_epg_new                   (void);
gboolean        gmyth_epg_connect               (GMythEPG           *gmyth_epg,
                                                 GMythBackendInfo   *backend_info);
gboolean        gmyth_epg_disconnect            (GMythEPG           *gmyth_epg);
gint            gmyth_epg_get_channel_list      (GMythEPG           *gmyth_epg,
                                                 GList              **glist_ptr);
gint            gmyth_epg_get_program_list      (GMythEPG           *gmyth_epg,
                                                 GList              **proglist,
                                                 gint               chanNum,
                                                 GTimeVal           *starttime,
                                                 GTimeVal           *endtime);
GMythChannelInfo*gmyth_epg_get_channel_info     (GMythEPG           *gmyth_epg,
                                                 gint               channel_id);
gboolean        gmyth_epg_channel_has_icon      (GMythEPG           *gmyth_epg,
                                                 GMythChannelInfo   *channel);
gboolean        gmyth_epg_channel_get_icon      (GMythEPG           *gmyth_epg,
                                                 GMythChannelInfo   *channel,
                                                 guint8             **data, 
                                                 guint              *length);

G_END_DECLS
#endif                          /* GMYTH_EPG_H_ */
