/**
 * GMyth Library
 *
 * @file gmyth/gmyth_file_transfer.h
 * 
 * @brief <p> GMythFileTransfer deals with the file streaming media remote/local
 * transfering to the MythTV frontend.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Rosfran Lins Borges <rosfran.borges@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GMYTH_FILE_TRANSFER_H__
#define __GMYTH_FILE_TRANSFER_H__

#include <glib-object.h>
#include <glib.h>

#include "gmyth_file.h"
#include "gmyth_socket.h"
#include "gmyth_uri.h"
#include "gmyth_backendinfo.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

G_BEGIN_DECLS
#define GMYTH_FILE_TRANSFER_TYPE               (gmyth_file_transfer_get_type ())
#define GMYTH_FILE_TRANSFER(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_FILE_TRANSFER_TYPE, GMythFileTransfer))
#define GMYTH_FILE_TRANSFER_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_FILE_TRANSFER_TYPE, GMythFileTransferClass))
#define IS_GMYTH_FILE_TRANSFER(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_FILE_TRANSFER_TYPE))
#define IS_GMYTH_FILE_TRANSFER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_FILE_TRANSFER_TYPE))
#define GMYTH_FILE_TRANSFER_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_FILE_TRANSFER_TYPE, GMythFileTransferClass))
typedef struct _GMythFileTransfer GMythFileTransfer;
typedef struct _GMythFileTransferClass GMythFileTransferClass;
typedef struct _GMythFileTransferPrivate GMythFileTransferPrivate;

struct _GMythFileTransfer {
    GMythFile       parent;
    GMythFileTransferPrivate *priv;
};

struct _GMythFileTransferClass {
    GMythFileClass  parent_class;

    /*
     * callbacks 
     */
    guint           program_info_changed_handler_signal_id;

    /*
     * signal default handlers 
     */
    void            (*program_info_changed_handler) (GMythFileTransfer *
                                                     transfer,
                                                     gint msg_code,
                                                     gpointer
                                                     livetv_recorder);
};


GType           gmyth_file_transfer_get_type(void);
GMythFileTransfer *gmyth_file_transfer_new(GMythBackendInfo *
                                           backend_info);
gchar          *gmyth_file_transfer_get_file_name(GMythFileTransfer *
                                                  transfer);
gboolean        gmyth_file_transfer_open(GMythFileTransfer * transfer,
                                         const gchar * filename);
void            gmyth_file_transfer_close(GMythFileTransfer * transfer);
gboolean        gmyth_file_transfer_is_open(GMythFileTransfer * transfer);

GMythFileReadResult
gmyth_file_transfer_read(GMythFileTransfer * transfer,
                         GByteArray * data, gint size,
                         gboolean read_unlimited);
gint64          gmyth_file_transfer_seek(GMythFileTransfer * transfer,
                                         guint64 pos, gint whence);
gboolean        gmyth_file_transfer_settimeout(GMythFileTransfer *
                                               transfer, gboolean fast);
guint64         gmyth_file_transfer_get_filesize(GMythFileTransfer *
                                                 transfer);

void
                gmyth_file_transfer_emit_program_info_changed_signal(GMythFileTransfer *
                                                                     transfer,
                                                                     gint
                                                                     msg_code,
                                                                     gpointer
                                                                     live_tv_recorder);

G_END_DECLS
#endif                          /* __GMYTH_FILE_TRANSFER_H__ */
