#
# Copyright (c) 2008 Canonical
#
# Written by Marc Tardif <marc@interunion.ca>
#
# This file is part of HWTest.
#
# HWTest is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# HWTest is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with HWTest.  If not, see <http://www.gnu.org/licenses/>.
#
import re

from hwtest.plugin import Plugin
from hwtest.template import Template
from hwtest.test import Test


class SuitesInfo(Plugin):

    required_attributes = ["directories", "scripts_path", "data_path"]
    optional_attributes = ["blacklist", "whitelist"]

    def register(self, manager):
        super(SuitesInfo, self).register(manager)
        self.tests = {}

        for (rt, rh) in [
             ("gather", self.gather),
             ("report", self.report),
             ("report-test", self.report_test)]:
            self._manager.reactor.call_on(rt, rh)

    def gather(self):
        directories = re.split("\s+", self.config.directories)
        blacklist = self.config.blacklist \
            and re.split("\s+", self.config.blacklist) or []
        whitelist = self.config.whitelist \
            and re.split("\s+", self.config.whitelist) or []
        template = Template("suite", ["name"])
        elements = template.load_directories(directories, blacklist, whitelist)

        for element in elements:
            test = Test(self._manager.registry, **element)
            for command in test.command, test.description:
                command.add_path(self.config.scripts_path)
                command.add_variable("data_path", self.config.data_path)

            self._manager.reactor.fire("test-%s" % test.plugin, test)

    def report_test(self, test):
        self.tests[test.name] = test

    def report(self):
        message = []
        for test in self.tests.values():
            attributes = dict(test.attributes)
            attributes["command"] = str(test.command)
            attributes["description"] = str(test.description)
            attributes["requires"] = str(test.requires)
            attributes["result"] = dict(test.result.attributes)

            message.append(attributes)
        self._manager.reactor.fire("report-tests", message)


factory = SuitesInfo
