/*
 *   componentSelectionPage.h
 *
 *   Copyright (C) 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef _COMPONENTSELECTIONPAGE_H_
#define _COMPONENTSELECTIONPAGE_H_

#include "componentSelectionPage_ui.h"
#include "pageWidget.h"

class KioskData;

class ComponentSelectionPage : public ComponentSelectionPageUI, public PageWidget
{
  Q_OBJECT
public:  
  ComponentSelectionPage( KioskData *data, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~ComponentSelectionPage();

  virtual void load();
  virtual bool save();
   
  virtual void setFocus();

  virtual QString subCaption();

  void setCurrentComponent(const QString &);
  QString currentComponent();

signals:
  void componentActivated();

protected:
  void loadComponentList();
  bool hasSelection();

protected slots:
  void slotComponentActivated(QIconViewItem *item);
  void slotComponentActivated();

private:
  KioskData *m_data;
};

#endif
