/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//Qt includes
#include <qlayout.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qhbox.h>

//KDE includes
#include <klocale.h>
#include <kactioncollection.h>
#include <kbuttonbox.h>
#include <klistbox.h>
#include <kfiledialog.h>
#include <kurl.h>
#include <kmessagebox.h>
#include <kiconloader.h>

#include <kdebug.h>

//Project includes
#include "postfixOptions.h"
#include "ksystemlogConfig.h"

PostfixOptions::PostfixOptions(QWidget *parent) :
	QWidget(parent) 
	{

	QHBoxLayout *layout = new QHBoxLayout(this);
	layout->setAutoAdd(true);

	QString description= i18n("<qt><p>These files will be analyzed to display <b>Postfix Logs</b>. This list also determine the order in which the files are read.</p></qt>");
	fileList=new SpecificFileList(this, description);
	
	connect(fileList, SIGNAL(fileListChanged(int)), this, SLOT(slotFileListChanged(int)));

	readConfig();
	

}

PostfixOptions::~PostfixOptions() {
	
}

bool PostfixOptions::isValid() {
	if (fileList->count()>0)
		return(true);
	else
		return(false);
}

void PostfixOptions::slotFileListChanged(int itemLeft) {
	if (itemLeft==0)
		emit optionsChanged(false);
	else
		emit optionsChanged(true);
}

void PostfixOptions::saveConfig() {
	kdDebug() << "Saving config from Daemon Options..." << endl;
	
	QStringList stringList;
	QValueList<int> valueList;
		
	fileList->saveConfig(stringList, valueList);
	
	KSystemLogConfig::setPostfixPaths(stringList);
	KSystemLogConfig::setPostfixLevels(valueList);
}

void PostfixOptions::readConfig() {
	QStringList stringList=KSystemLogConfig::postfixPaths();
	QValueList<int> valueList=KSystemLogConfig::postfixLevels();
	
	fileList->readConfig(stringList, valueList);
}

#include "postfixOptions.moc"
