/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * $Id$
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */

package org.jfree.fonts.registry;

/**
 * Creation-Date: 05.08.2007, 19:22:44
 *
 * @author Thomas Morgner
 */
public class FontKey
{
  private FontIdentifier identifier;
  private boolean aliased;
  private boolean fractional;
  private double fontSize;

  public FontKey(final FontIdentifier identifier,
                 final boolean aliased,
                 final boolean fractional, final double fontSize)
  {
    if (identifier == null)
    {
      throw new NullPointerException();
    }
    this.identifier = identifier;
    this.aliased = aliased;
    this.fractional = fractional;
    this.fontSize = fontSize;
  }

  public FontKey()
  {
  }

  public FontIdentifier getIdentifier()
  {
    return identifier;
  }

  public void setIdentifier(final FontIdentifier identifier)
  {
    this.identifier = identifier;
  }

  public boolean isAliased()
  {
    return aliased;
  }

  public void setAliased(final boolean aliased)
  {
    this.aliased = aliased;
  }

  public boolean isFractional()
  {
    return fractional;
  }

  public void setFractional(final boolean fractional)
  {
    this.fractional = fractional;
  }

  public double getFontSize()
  {
    return fontSize;
  }

  public void setFontSize(final double fontSize)
  {
    this.fontSize = fontSize;
  }

  public boolean equals(final Object o)
  {
    if (this == o)
    {
      return true;
    }
    if (o == null || getClass() != o.getClass())
    {
      return false;
    }

    final FontKey fontKey = (FontKey) o;

    if (aliased != fontKey.aliased)
    {
      return false;
    }
    if (fontKey.fontSize != fontSize)
    {
      return false;
    }
    if (fractional != fontKey.fractional)
    {
      return false;
    }
    if (!identifier.equals(fontKey.identifier))
    {
      return false;
    }

    return true;
  }

  public int hashCode()
  {
    int result = identifier.hashCode();
    result = 29 * result + (aliased ? 1 : 0);
    result = 29 * result + (fractional ? 1 : 0);
    final long temp = fontSize == +0.0d ? 0L : Double.doubleToLongBits(fontSize);
    result = 29 * result + (int) (temp ^ (temp >>> 32));
    return result;
  }
}
