(***********************************************************************)
(*                             ocamlbuild                              *)
(*                                                                     *)
(*  Nicolas Pouillard, Berke Durak, projet Gallium, INRIA Rocquencourt *)
(*                                                                     *)
(*  Copyright 2007 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the Q Public License version 1.0.               *)
(*                                                                     *)
(***********************************************************************)

(* $Id: ocaml_utils.mli,v 1.3 2007/02/26 16:27:45 ertai Exp $ *)
(* Original author: Nicolas Pouillard *)
val stdlib_dir : Pathname.t Lazy.t
val module_name_of_filename : Pathname.t -> string
val module_name_of_pathname : Pathname.t -> string
val ignore_stdlib : string -> bool
val non_dependency : string -> string -> unit
val expand_module :
  Pathname.t list -> Pathname.t -> string list -> Pathname.t list
val string_list_of_file : string -> string list
val ocaml_ppflags : Tags.t -> Command.spec
val ocaml_include_flags : Pathname.t -> Command.spec
val libraries_of : Pathname.t -> Pathname.t list
val use_lib : Pathname.t -> Pathname.t -> unit
val cmi_of : Pathname.t -> Pathname.t
val ocaml_add_include_flag : string -> Command.spec list -> Command.spec list
val module_importance : string -> string -> [ `ignored | `mandatory | `just_try ]

val info_libraries : (string, string * bool) Hashtbl.t

val ocaml_lib :
  ?extern:bool ->
  ?byte:bool ->
  ?native:bool ->
  ?dir:Pathname.t ->
  ?tag_name:string ->
  Pathname.t -> unit

