/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: RelationDlg.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: hr $ $Date: 2007/11/01 15:17:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef DBAUI_RELATIONDIALOG_HXX
#define DBAUI_RELATIONDIALOG_HXX

#ifndef _DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif

#ifndef _BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
//#ifndef _EDIT_HXX //autogen
//#include <vcl/edit.hxx>
//#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef DBAUI_JOINTABLEVIEW_HXX
#include "JoinTableView.hxx"
#endif
#ifndef DBAUI_RELCONTROLIFACE_HXX
#include "RelControliFace.hxx"
#endif
#ifndef _DBAUI_MODULE_DBU_HXX_
#include "moduledbu.hxx"
#endif


namespace dbaui
{
	class OJoinTableView;
	class OTableListBoxControl;
	class ORelationTableConnectionData;
	//========================================================================
	class ORelationDialog : public ModalDialog
							,public IRelationControlInterface
	{
        OModuleClient                           m_aModuleClient;
        ::std::auto_ptr<OTableListBoxControl>	m_pTableControl;
		OJoinTableView::OTableWindowMap*	    m_pTableMap;

        FixedLine   aFL_CascUpd;
		RadioButton aRB_NoCascUpd,
					aRB_CascUpd,
					aRB_CascUpdNull,
					aRB_CascUpdDefault;
        FixedLine   aFL_CascDel;
		RadioButton	aRB_NoCascDel,
					aRB_CascDel,
					aRB_CascDelNull,
					aRB_CascDelDefault;

		OKButton	aPB_OK;
		CancelButton aPB_CANCEL;
		HelpButton	aPB_HELP;

		
		TTableConnectionData::value_type 										m_pConnData;
		TTableConnectionData::value_type 										m_pOrigConnData;
		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection > m_xConnection;

		BOOL																	m_bTriedOneUpdate;

	public:
		ORelationDialog(OJoinTableView* pParent,
						const TTableConnectionData::value_type& pConnectionData,
						BOOL bAllowTableSelect = FALSE );
		virtual ~ORelationDialog();

		virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection > getConnection(){ return m_xConnection; }

		virtual short Execute();

		/** getTableMap gives acces to the table window map
			@retrun the table window from the join view
		*/
		OJoinTableView::OTableWindowMap* getTableMap() const { return m_pTableMap; }

		/** getConnectionData returns the current connection data
			@return the current connectiondata
		*/
		virtual TTableConnectionData::value_type getConnectionData() const;

		/** setValid set the valid inside, can be used for OK buttons
			@param	_bValid	true when the using control allows an update
		*/
		virtual void setValid(sal_Bool _bValid);

		/** notifyConnectionChange is callback which is called when the table selection has changed and a new connection exists
			@param	_pConnectionData	the connection which exists between the new tables
		*/
		virtual void notifyConnectionChange();
	protected:
		void Init(const TTableConnectionData::value_type& _pConnectionData);

	private:
		DECL_LINK( OKClickHdl, Button* );	
	};
}
#endif // DBAUI_RELATIONDIALOG_HXX


