/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: FixedText.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/07/09 11:56:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef RPT_FIXEDTEXT_HXX
#include "FixedText.hxx"
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif
#ifndef REPORTDESIGN_SHARED_CORESTRINGS_HRC
#include "corestrings.hrc"
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSTATE_HPP_
#include <com/sun/star/beans/XPropertyState.hpp>
#endif
#ifndef REPORTDESIGN_CORE_RESOURCE_HRC_
#include "core_resource.hrc"
#endif
#ifndef REPORTDESIGN_CORE_RESOURCE_HXX_
#include "core_resource.hxx"
#endif
#ifndef _COMPHELPER_SEQUENCE_HXX_
#include <comphelper/sequence.hxx>
#endif
#ifndef REPORTDESIGN_TOOLS_HXX
#include "Tools.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _COMPHELPER_PROPERTY_HXX_
#include <comphelper/property.hxx>
#endif
#ifndef RPT_FORMATCONDITION_HXX
#include "FormatCondition.hxx"
#endif
#ifndef _COM_SUN_STAR_TEXT_PARAGRAPHVERTALIGN_HPP_
#include <com/sun/star/text/ParagraphVertAlign.hpp>
#endif
#include "ReportHelperImpl.hxx"
// =============================================================================
namespace reportdesign
{
// =============================================================================
	using namespace com::sun::star;
	using namespace comphelper;
uno::Sequence< ::rtl::OUString > lcl_getFixedTextOptionals()
{
	::rtl::OUString pProps[] = { PROPERTY_DATAFIELD };
	return uno::Sequence< ::rtl::OUString >(pProps,sizeof(pProps)/sizeof(pProps[0]));
}
DBG_NAME( rpt_OFixedText )
// -----------------------------------------------------------------------------
OFixedText::OFixedText(uno::Reference< uno::XComponentContext > const & _xContext)
:FixedTextBase(m_aMutex) 
,FixedTextPropertySet(_xContext,static_cast< Implements >(IMPLEMENTS_PROPERTY_SET),lcl_getFixedTextOptionals())
,m_aProps(m_aMutex,static_cast< container::XContainer*>( this ),_xContext)
,m_bMultiLine(sal_False)
{
	DBG_CTOR( rpt_OFixedText,NULL);
	m_aProps.aComponent.m_sName  = RPT_RESSTRING(RID_STR_FIXEDTEXT,m_aProps.aComponent.m_xContext->getServiceManager());
	m_aProps.aComponent.m_nBorder = 0; // no border
}
// -----------------------------------------------------------------------------
OFixedText::OFixedText(uno::Reference< uno::XComponentContext > const & _xContext
                       ,const uno::Reference< lang::XMultiServiceFactory>& _xFactory
                       ,uno::Reference< drawing::XShape >& _xShape)
:FixedTextBase(m_aMutex) 
,FixedTextPropertySet(_xContext,static_cast< Implements >(IMPLEMENTS_PROPERTY_SET),lcl_getFixedTextOptionals())
,m_aProps(m_aMutex,static_cast< container::XContainer*>( this ),_xContext)
,m_bMultiLine(sal_False)
{
	DBG_CTOR( rpt_OFixedText,NULL);
	m_aProps.aComponent.m_sName  = RPT_RESSTRING(RID_STR_FIXEDTEXT,m_aProps.aComponent.m_xContext->getServiceManager());
	m_aProps.aComponent.m_nBorder = 0; // no border
    m_aProps.aComponent.m_xFactory = _xFactory;
    osl_incrementInterlockedCount( &m_refCount );
    {
        m_aProps.aComponent.setShape(_xShape,this,m_refCount);
    }
    osl_decrementInterlockedCount( &m_refCount );
}
// -----------------------------------------------------------------------------
OFixedText::~OFixedText()
{
    DBG_DTOR( rpt_OFixedText,NULL);
}
// -----------------------------------------------------------------------------
IMPLEMENT_FORWARD_REFCOUNT( OFixedText, FixedTextBase )
// --------------------------------------------------------------------------------
uno::Any SAL_CALL OFixedText::queryInterface( const uno::Type& _rType ) throw (uno::RuntimeException)
{
	uno::Any aReturn = FixedTextBase::queryInterface(_rType);
    if ( !aReturn.hasValue() )
        aReturn = FixedTextPropertySet::queryInterface(_rType);
    if ( !aReturn.hasValue() && OReportControlModel::isInterfaceForbidden(_rType) )
        return aReturn;

	return aReturn.hasValue() ? aReturn : (m_aProps.aComponent.m_xProxy.is() ? m_aProps.aComponent.m_xProxy->queryAggregation(_rType) : aReturn);
}

//IMPLEMENT_FORWARD_XINTERFACE2(OFixedText,FixedTextBase,FixedTextPropertySet)
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::dispose() throw(uno::RuntimeException) 
{
	FixedTextPropertySet::dispose();
	cppu::WeakComponentImplHelperBase::dispose();
    uno::Reference< report::XFixedText> xHoldAlive = this;
    {
        m_aProps.dispose(m_refCount);
    }
}
// -----------------------------------------------------------------------------
::rtl::OUString OFixedText::getImplementationName_Static(  ) throw(uno::RuntimeException)
{
	return ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.comp.report.OFixedText"));
}

//--------------------------------------------------------------------------
::rtl::OUString SAL_CALL OFixedText::getImplementationName(  ) throw(uno::RuntimeException)
{
	return getImplementationName_Static();
}
//--------------------------------------------------------------------------
uno::Sequence< ::rtl::OUString > OFixedText::getSupportedServiceNames_Static(  ) throw(uno::RuntimeException)
{
	uno::Sequence< ::rtl::OUString > aServices(1);//2);
	aServices.getArray()[0] = SERVICE_FIXEDTEXT;
    //aServices.getArray()[1] = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.form.component.FixedText"));
	
	return aServices;
}
//------------------------------------------------------------------------------
uno::Reference< uno::XInterface > OFixedText::create(uno::Reference< uno::XComponentContext > const & xContext)
{
	return *(new OFixedText(xContext));
}

//--------------------------------------------------------------------------
uno::Sequence< ::rtl::OUString > SAL_CALL OFixedText::getSupportedServiceNames(  ) throw(uno::RuntimeException)
{
	return getSupportedServiceNames_Static();
}
//------------------------------------------------------------------------------
sal_Bool SAL_CALL OFixedText::supportsService(const ::rtl::OUString& ServiceName) throw( uno::RuntimeException )
{
	return ::comphelper::existsValue(ServiceName,getSupportedServiceNames_Static());
}
// -----------------------------------------------------------------------------
// XReportComponent
REPORTCOMPONENT_IMPL(OFixedText)
REPORTCOMPONENT_IMPL2(OFixedText)
REPORTCONTROLFORMAT_IMPL(OFixedText,m_aProps.aFormatProperties)
// -----------------------------------------------------------------------------
uno::Reference< beans::XPropertySetInfo > SAL_CALL OFixedText::getPropertySetInfo(  ) throw(uno::RuntimeException)
{
	return FixedTextPropertySet::getPropertySetInfo();
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::setPropertyValue( const ::rtl::OUString& aPropertyName, const uno::Any& aValue ) throw (beans::UnknownPropertyException, beans::PropertyVetoException, lang::IllegalArgumentException, lang::WrappedTargetException, uno::RuntimeException)
{
	FixedTextPropertySet::setPropertyValue( aPropertyName, aValue );
}
// -----------------------------------------------------------------------------
uno::Any SAL_CALL OFixedText::getPropertyValue( const ::rtl::OUString& PropertyName ) throw (beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException)
{
	return FixedTextPropertySet::getPropertyValue( PropertyName);
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::addPropertyChangeListener( const ::rtl::OUString& aPropertyName, const uno::Reference< beans::XPropertyChangeListener >& xListener ) throw (beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException)
{
	FixedTextPropertySet::addPropertyChangeListener( aPropertyName, xListener );
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::removePropertyChangeListener( const ::rtl::OUString& aPropertyName, const uno::Reference< beans::XPropertyChangeListener >& aListener ) throw (beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException)
{
	FixedTextPropertySet::removePropertyChangeListener( aPropertyName, aListener );
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::addVetoableChangeListener( const ::rtl::OUString& PropertyName, const uno::Reference< beans::XVetoableChangeListener >& aListener ) throw (beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException)
{
	FixedTextPropertySet::addVetoableChangeListener( PropertyName, aListener );
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::removeVetoableChangeListener( const ::rtl::OUString& PropertyName, const uno::Reference< beans::XVetoableChangeListener >& aListener ) throw (beans::UnknownPropertyException, lang::WrappedTargetException, uno::RuntimeException)
{
	FixedTextPropertySet::removeVetoableChangeListener( PropertyName, aListener );
}
// -----------------------------------------------------------------------------
// XReportControlModel
::rtl::OUString SAL_CALL OFixedText::getDataField() throw ( beans::UnknownPropertyException, uno::RuntimeException)
{
	throw beans::UnknownPropertyException();
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::setDataField( const ::rtl::OUString& /*_datafield*/ ) throw (lang::IllegalArgumentException, beans::UnknownPropertyException, uno::RuntimeException)
{
	throw beans::UnknownPropertyException();
}
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
::sal_Bool SAL_CALL OFixedText::getPrintWhenGroupChange() throw (beans::UnknownPropertyException, uno::RuntimeException)
{
	::osl::MutexGuard aGuard(m_aMutex);
	return m_aProps.bPrintWhenGroupChange;
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::setPrintWhenGroupChange( ::sal_Bool _printwhengroupchange ) throw (beans::UnknownPropertyException, uno::RuntimeException)
{
	set(PROPERTY_PRINTWHENGROUPCHANGE,_printwhengroupchange,m_aProps.bPrintWhenGroupChange);
}
// -----------------------------------------------------------------------------
::rtl::OUString SAL_CALL OFixedText::getConditionalPrintExpression() throw (beans::UnknownPropertyException, uno::RuntimeException)
{
	::osl::MutexGuard aGuard(m_aMutex);
	return m_aProps.aConditionalPrintExpression;
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::setConditionalPrintExpression( const ::rtl::OUString& _conditionalprintexpression ) throw (beans::UnknownPropertyException, uno::RuntimeException)
{
	set(PROPERTY_CONDITIONALPRINTEXPRESSION,_conditionalprintexpression,m_aProps.aConditionalPrintExpression);
}
// -----------------------------------------------------------------------------

// XCloneable
uno::Reference< util::XCloneable > SAL_CALL OFixedText::createClone(  ) throw (uno::RuntimeException)
{
    uno::Reference< report::XReportComponent> xSource = this;
    uno::Reference< report::XFixedText> xSet(cloneObject(xSource,m_aProps.aComponent.m_xFactory,SERVICE_FIXEDTEXT),uno::UNO_QUERY_THROW);
	return xSet.get();
}
// -----------------------------------------------------------------------------

// XFixedText
::rtl::OUString SAL_CALL OFixedText::getLabel() throw (uno::RuntimeException)
{
	::osl::MutexGuard aGuard(m_aMutex);
	return m_sLabel;
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::setLabel( const ::rtl::OUString& _label ) throw (uno::RuntimeException)
{
	set(PROPERTY_LABEL,_label,m_sLabel);
}
// -----------------------------------------------------------------------------
// XChild
uno::Reference< uno::XInterface > SAL_CALL OFixedText::getParent(  ) throw (uno::RuntimeException)
{
    return OShapeHelper::getParent(this);
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::setParent( const uno::Reference< uno::XInterface >& Parent ) throw (lang::NoSupportException, uno::RuntimeException)
{
	OShapeHelper::setParent(Parent,this);
}
// -----------------------------------------------------------------------------
::sal_Bool SAL_CALL OFixedText::getMultiLine() throw (uno::RuntimeException)
{
	::osl::MutexGuard aGuard(m_aMutex);
	return m_bMultiLine;
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::setMultiLine( ::sal_Bool _multiline ) throw (uno::RuntimeException)
{
	set(PROPERTY_MULTILINE,_multiline,m_bMultiLine);
}
// -----------------------------------------------------------------------------
uno::Reference< report::XFormatCondition > SAL_CALL OFixedText::createFormatCondition(  ) throw (uno::Exception, uno::RuntimeException)
{
	return new OFormatCondition(m_aProps.aComponent.m_xContext);
}
// -----------------------------------------------------------------------------
// XContainer
void SAL_CALL OFixedText::addContainerListener( const uno::Reference< container::XContainerListener >& xListener ) throw (uno::RuntimeException)
{
	m_aProps.addContainerListener(xListener);
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::removeContainerListener( const uno::Reference< container::XContainerListener >& xListener ) throw (uno::RuntimeException)
{
	m_aProps.removeContainerListener(xListener);
}
// -----------------------------------------------------------------------------
// XElementAccess
uno::Type SAL_CALL OFixedText::getElementType(  ) throw (uno::RuntimeException)
{
	return ::getCppuType(static_cast< uno::Reference<report::XFormatCondition>*>(NULL));
}
// -----------------------------------------------------------------------------
::sal_Bool SAL_CALL OFixedText::hasElements(  ) throw (uno::RuntimeException)
{
	return m_aProps.hasElements();
}
// -----------------------------------------------------------------------------
// XIndexContainer
void SAL_CALL OFixedText::insertByIndex( ::sal_Int32 Index, const uno::Any& Element ) throw (lang::IllegalArgumentException, lang::IndexOutOfBoundsException, lang::WrappedTargetException, uno::RuntimeException)
{
    m_aProps.insertByIndex(Index,Element);
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::removeByIndex( ::sal_Int32 Index ) throw (lang::IndexOutOfBoundsException, lang::WrappedTargetException, uno::RuntimeException)
{
    m_aProps.removeByIndex(Index);
}
// -----------------------------------------------------------------------------
// XIndexReplace
void SAL_CALL OFixedText::replaceByIndex( ::sal_Int32 Index, const uno::Any& Element ) throw (lang::IllegalArgumentException, lang::IndexOutOfBoundsException, lang::WrappedTargetException, uno::RuntimeException)
{
    m_aProps.replaceByIndex(Index,Element);
}
// -----------------------------------------------------------------------------
// XIndexAccess
::sal_Int32 SAL_CALL OFixedText::getCount(  ) throw (uno::RuntimeException)
{
	return m_aProps.getCount();
}
// -----------------------------------------------------------------------------
uno::Any SAL_CALL OFixedText::getByIndex( ::sal_Int32 Index ) throw (lang::IndexOutOfBoundsException, lang::WrappedTargetException, uno::RuntimeException)
{
    return m_aProps.getByIndex( Index );
}
// -----------------------------------------------------------------------------
// XShape
awt::Point SAL_CALL OFixedText::getPosition(  ) throw (uno::RuntimeException)
{
	return OShapeHelper::getPosition(this);
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::setPosition( const awt::Point& aPosition ) throw (uno::RuntimeException)
{
    OShapeHelper::setPosition(aPosition,this);
}
// -----------------------------------------------------------------------------
awt::Size SAL_CALL OFixedText::getSize(  ) throw (uno::RuntimeException)
{
	return OShapeHelper::getSize(this);
}
// -----------------------------------------------------------------------------
void SAL_CALL OFixedText::setSize( const awt::Size& aSize ) throw (beans::PropertyVetoException, uno::RuntimeException)
{
    OShapeHelper::setSize(aSize,this);
}
// -----------------------------------------------------------------------------

// XShapeDescriptor
::rtl::OUString SAL_CALL OFixedText::getShapeType(  ) throw (uno::RuntimeException)
{
	::osl::MutexGuard aGuard(m_aMutex);
    if ( m_aProps.aComponent.m_xShape.is() )
	    return m_aProps.aComponent.m_xShape->getShapeType();
    return ::rtl::OUString();
}
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
// =============================================================================
} // namespace reportdesign
// =============================================================================

