/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: BasicPaneFactory.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/04/03 15:49:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_FRAMEWORK_BASIC_PANE_FACTORY_HXX
#define SD_FRAMEWORK_BASIC_PANE_FACTORY_HXX

#include "MutexOwner.hxx"

#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XPANECONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XPaneController.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XCONFIGURATIONCHANGELISTENER_HPP_
#include <com/sun/star/drawing/framework/XConfigurationChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XCONFIGURATIONCONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XConfigurationController.hpp>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _CPPUHELPER_COMPBASE3_HXX_
#include <cppuhelper/compbase3.hxx>
#endif
#include "UpdateLockManager.hxx"


#include <boost/scoped_ptr.hpp>
#include <boost/shared_ptr.hpp>

namespace {

typedef ::cppu::WeakComponentImplHelper3 <
    ::com::sun::star::lang::XInitialization,
    ::com::sun::star::drawing::framework::XPaneFactory,
    ::com::sun::star::drawing::framework::XConfigurationChangeListener
    > BasicPaneFactoryInterfaceBase;

} // end of anonymous namespace.


namespace sd {

class ViewShellBase;
}

namespace sd { namespace framework {

/** This factory provides the frequently used standard panes
        private:resource/floater/CenterPaneURL
        private:resource/floater/LeftImpressPaneURL
        private:resource/floater/LeftDrawPaneURL
        private:resource/floater/RightPaneURL
    There are two left panes because this is (seems to be) the only way to
    show different titles for the left pane in Draw and Impress.
*/
class BasicPaneFactory
    : private sd::MutexOwner,
      public BasicPaneFactoryInterfaceBase      
{
public:
    BasicPaneFactory (
        const ::com::sun::star::uno::Reference<com::sun::star::uno::XComponentContext>& rxContext);
    virtual ~BasicPaneFactory (void);
    
    virtual void SAL_CALL disposing (void);

    
    // XInitialization
    
    virtual void SAL_CALL initialize(
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Any>& aArguments)
        throw (::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException);


    // XPaneFactory
    
    virtual ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XPane>
        SAL_CALL createPane (
            const ::com::sun::star::uno::Reference<
                com::sun::star::drawing::framework::XResourceId>& rxPaneId)
        throw (::com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
        releasePane (
            const ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XPane>&
                rxPane)
        throw (::com::sun::star::uno::RuntimeException);


    // XConfigurationChangeListener

    virtual void SAL_CALL notifyConfigurationChange (
        const com::sun::star::drawing::framework::ConfigurationChangeEvent& rEvent)
        throw (com::sun::star::uno::RuntimeException);


    // lang::XEventListener
    
    virtual void SAL_CALL disposing (
        const com::sun::star::lang::EventObject& rEventObject)
        throw (com::sun::star::uno::RuntimeException);

private:
    ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XConfigurationController>
        mxConfigurationController;
    ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XPaneController>
        mxPaneController;
    ViewShellBase* mpViewShellBase;
    class PaneDescriptor;
    class PaneContainer;
    ::boost::scoped_ptr<PaneContainer> mpPaneContainer;
    bool mbFirstUpdateSeen;
    ::boost::shared_ptr<UpdateLockManager> mpUpdateLockManager;

    /** Create a new instance of FrameWindowPane.
        @param rPaneId
            There is only one frame window so this id is just checked to
            have the correct value.
    */
    ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XPane>
        CreateFrameWindowPane (
            const ::com::sun::star::uno::Reference<
                com::sun::star::drawing::framework::XResourceId>& rxPaneId);

    /** Create a new instance of ChildWindowPane.
        @param rPaneId
            The ResourceURL member defines which side pane to create.
    */
    ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XPane>
        CreateChildWindowPane (
            const ::com::sun::star::uno::Reference<
                com::sun::star::drawing::framework::XResourceId>& rxPaneId,
            const PaneDescriptor& rDescriptor);

    void ThrowIfDisposed (void) const
        throw (::com::sun::star::lang::DisposedException);
};

} } // end of namespace sd::framework

#endif
