/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SlsPageNotificationObjectContact.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/26 11:46:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#include "view/SlsPageNotificationObjectContact.hxx"

#include <svx/svdpage.hxx>
#include <svx/sdr/contact/viewobjectcontact.hxx>

#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif

namespace sd { namespace slidesorter { namespace view {

PageNotificationObjectContact::PageNotificationObjectContact (
    SdrPage& rBroadcaster,
    ::sdr::contact::ViewObjectContact& rListener)
    : ObjectContactPainter(sal_False),
      mrBroadcaster(rBroadcaster),
      mrListener(rListener)
{
    mbIsPreviewRenderer = sal_True;
}




PageNotificationObjectContact::~PageNotificationObjectContact (void)
{
}




sal_uInt32 PageNotificationObjectContact::GetPaintObjectCount (void) const
{
    return 1;
}




::sdr::contact::ViewContact& PageNotificationObjectContact::GetPaintObjectViewContact (
    sal_uInt32 nIndex) const
{
    if (nIndex!=0)
    {
        OSL_ASSERT(nIndex==0);
        throw new ::com::sun::star::uno::RuntimeException(
            ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                "PageNotificationObjectContact: IllegalArgument nIndex!=0")),
            NULL);
    }
    else
        return mrBroadcaster.GetViewContact();
}




void PageNotificationObjectContact::InvalidatePartOfView (const Rectangle& ) const
{
    mrListener.ActionChanged();
}




void PageNotificationObjectContact::EnsureValidDrawHierarchy (
    ::sdr::contact::DisplayInfo& rDisplayInfo)
{
    return ObjectContactPainter::EnsureValidDrawHierarchy(rDisplayInfo);
}

} } } // end of namespace ::sd::slidesorter::view
