/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: unolingu.hxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: hr $ $Date: 2007/01/02 15:05:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _UNO_LINGU_HXX
#define _UNO_LINGU_HXX

#ifndef INCLUDED_I18NPOOL_LANG_H
#include <i18npool/lang.h>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _VOS_REFERNCE_HXX_
#include <vos/refernce.hxx>
#endif

#ifndef _COM_SUN_STAR_UTIL_LANGUAGE_HPP_
#include <com/sun/star/util/Language.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_LOCALE_HPP_
#include <com/sun/star/lang/Locale.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XLINGUSERVICEMANAGER_HPP_
#include <com/sun/star/linguistic2/XLinguServiceManager.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XSPELLCHECKER1_HPP_
#include <com/sun/star/linguistic2/XSpellChecker1.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XHYPHENATOR_HPP_
#include <com/sun/star/linguistic2/XHyphenator.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XTHESAURUS_HPP_
#include <com/sun/star/linguistic2/XThesaurus.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARYLIST_HPP_
#include <com/sun/star/linguistic2/XDictionaryList.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARY1_HPP_
#include <com/sun/star/linguistic2/XDictionary1.hpp>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

class LinguMgrExitLstnr;

class Window;

// SvxAddEntryToDic return values
#define DIC_ERR_NONE		0
#define DIC_ERR_FULL		1
#define DIC_ERR_READONLY	2
#define DIC_ERR_UNKNOWN		3
#define DIC_ERR_NOT_EXISTS	4

///////////////////////////////////////////////////////////////////////////
// SvxLinguConfigUpdate
// class to update configuration items when (before!) the linguistic is used.
//
// This class is called by all the dummy implementations to update all of the
// configuration (list of used/available services) when the linguistic is
// accessed for the first time.

class SvxLinguConfigUpdate
{
    static INT32    nCurrentDataFilesChangedCheckValue;
    static INT16    nNeedUpdating;  // n == -1 => needs to be checked
                                    // n ==  0 => already updated, nothing to be done
                                    // n ==  1 => needs to be updated

    static INT32 CalcDataFilesChangedCheckValue();

public:

    static void UpdateAll( sal_Bool bForceCheck = sal_False );
    static BOOL IsNeedUpdateAll( sal_Bool bForceCheck = sal_False );
};

///////////////////////////////////////////////////////////////////////////

class SVX_DLLPUBLIC LinguMgr
{
	friend class LinguMgrExitLstnr;

    //static ::VOS::ORefCount aRefCount;

	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XLinguServiceManager > xLngSvcMgr;
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XSpellChecker1 > xSpell;
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XHyphenator >	xHyph;
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XThesaurus >		xThes;
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XDictionaryList > xDicList;
	static ::com::sun::star::uno::Reference<
		::com::sun::star::beans::XPropertySet > 		xProp;

	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XDictionary1 >	xIgnoreAll;
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XDictionary1 >	xChangeAll;

	static LinguMgrExitLstnr						   *pExitLstnr;
	static sal_Bool										bExiting;

	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XSpellChecker1 > GetSpell();
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XHyphenator > 	GetHyph();
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XThesaurus > 	GetThes();
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XDictionaryList > GetDicList();
	static ::com::sun::star::uno::Reference<
		::com::sun::star::beans::XPropertySet > 		GetProp();
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XDictionary1 >	GetStandard();
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XDictionary1 >	GetIgnoreAll();
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XDictionary1 >	GetChangeAll();

	// disallow access to copy-constructor and assignment-operator
	LinguMgr(const LinguMgr &);
	LinguMgr & operator = (const LinguMgr &);

public:

	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XSpellChecker1 > GetSpellChecker();
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XHyphenator > 	GetHyphenator();
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XThesaurus > 	GetThesaurus();
	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XDictionaryList > GetDictionaryList();
	static ::com::sun::star::uno::Reference<
		::com::sun::star::beans::XPropertySet > 		GetLinguPropertySet();

	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XLinguServiceManager > GetLngSvcMgr();

	static ::com::sun::star::uno::Reference<
		::com::sun::star::linguistic2::XDictionary1 > 	GetStandardDic();
	static ::com::sun::star::uno::Reference< 
		::com::sun::star::linguistic2::XDictionary1 > 	GetIgnoreAllList();
	static ::com::sun::star::uno::Reference< 
		::com::sun::star::linguistic2::XDictionary1 > 	GetChangeAllList();

    // update all configuration entries
    static void UpdateAll();
};

///////////////////////////////////////////////////////////////////////////

namespace com { namespace sun { namespace star { namespace linguistic2 {
	class XHyphenatedWord;
}}}}


struct SvxAlternativeSpelling
{
	String		aReplacement;
	::com::sun::star::uno::Reference< 
		::com::sun::star::linguistic2::XHyphenatedWord >	xHyphWord;
	INT16  		nChangedPos,
		 		nChangedLength;
	BOOL		bIsAltSpelling;

	inline SvxAlternativeSpelling();
};

inline SvxAlternativeSpelling::SvxAlternativeSpelling() :
	nChangedPos(-1), nChangedLength(-1), bIsAltSpelling(FALSE)
{
}


SVX_DLLPUBLIC SvxAlternativeSpelling SvxGetAltSpelling( 
		const ::com::sun::star::uno::Reference< 
			::com::sun::star::linguistic2::XHyphenatedWord > & rHyphWord );


///////////////////////////////////////////////////////////////////////////

class SVX_DLLPUBLIC SvxDicListChgClamp
{
private:
	::com::sun::star::uno::Reference< 
		::com::sun::star::linguistic2::XDictionaryList > 	xDicList;

	// disallow access to copy-constructor and assignment-operator
	SVX_DLLPRIVATE SvxDicListChgClamp(const SvxDicListChgClamp &);
	SVX_DLLPRIVATE SvxDicListChgClamp & operator = (const SvxDicListChgClamp &);

public:
	SvxDicListChgClamp( ::com::sun::star::uno::Reference< 
		::com::sun::star::linguistic2::XDictionaryList >  &rxDicList );
	~SvxDicListChgClamp();
};

///////////////////////////////////////////////////////////////////////////

//TL:TODO: remove those functions or make them inline
SVX_DLLPUBLIC ::com::sun::star::uno::Reference< 
	::com::sun::star::linguistic2::XSpellChecker1 >	SvxGetSpellChecker();
::com::sun::star::uno::Reference< 
	::com::sun::star::linguistic2::XHyphenator >  	SvxGetHyphenator();
::com::sun::star::uno::Reference< 
	::com::sun::star::linguistic2::XThesaurus >  	SvxGetThesaurus();
SVX_DLLPUBLIC ::com::sun::star::uno::Reference< 
	::com::sun::star::linguistic2::XDictionaryList > SvxGetDictionaryList();
SVX_DLLPUBLIC ::com::sun::star::uno::Reference< 
	::com::sun::star::beans::XPropertySet > 		SvxGetLinguPropertySet();
//TL:TODO: remove argument or provide SvxGetIgnoreAllList with the same one
SVX_DLLPUBLIC ::com::sun::star::uno::Reference< 
	::com::sun::star::linguistic2::XDictionary1 >  	SvxGetOrCreatePosDic( 
			::com::sun::star::uno::Reference< 
				::com::sun::star::linguistic2::XDictionaryList >  xDicList );
SVX_DLLPUBLIC ::com::sun::star::uno::Reference< 
	::com::sun::star::linguistic2::XDictionary1 >  	SvxGetIgnoreAllList();
SVX_DLLPUBLIC ::com::sun::star::uno::Reference< 
	::com::sun::star::linguistic2::XDictionary1 >  	SvxGetChangeAllList();

///////////////////////////////////////////////////////////////////////////
// misc functions
//

SVX_DLLPUBLIC LanguageType 						SvxLocaleToLanguage( 
		const ::com::sun::star::lang::Locale& rLocale );
SVX_DLLPUBLIC ::com::sun::star::lang::Locale& 	SvxLanguageToLocale( 
		::com::sun::star::lang::Locale& rLocale, LanguageType eLang );
SVX_DLLPUBLIC ::com::sun::star::lang::Locale		SvxCreateLocale( LanguageType eLang );

SVX_DLLPUBLIC String	SvxGetDictionaryURL(const String &rDicName, 
							sal_Bool bIsUserDic = sal_True);


SVX_DLLPUBLIC sal_uInt8    SvxAddEntryToDic( 
	::com::sun::star::uno::Reference< 
		::com::sun::star::linguistic2::XDictionary >  &rxDic,
	const ::rtl::OUString &rWord, sal_Bool bIsNeg,
	const ::rtl::OUString &rRplcTxt, sal_Int16 nRplcLang, 
	sal_Bool bStripDot = sal_True );
SVX_DLLPUBLIC short	SvxDicError( Window *pParent, sal_Int16 nError );

SVX_DLLPUBLIC sal_Bool	SvxSaveDictionaries( 
	const ::com::sun::star::uno::Reference< 
		::com::sun::star::linguistic2::XDictionaryList >  &xDicList );

#endif



