/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: column.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: vg $ $Date: 2007/10/22 15:17:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COLUMN_HXX
#define _COLUMN_HXX


#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#ifndef _IMAGE_HXX //autogen
#include <vcl/image.hxx>
#endif
#ifndef _GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif
#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
#ifndef _BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _IMAGEBTN_HXX //autogen
#include <vcl/imagebtn.hxx>
#endif
#ifndef _CTRLBOX_HXX
#include <svtools/ctrlbox.hxx>
#endif
#ifndef _VALUESET_HXX //autogen
#include <svtools/valueset.hxx>
#endif
#ifndef _BASEDLGS_HXX //autogen
#include <sfx2/basedlgs.hxx>
#endif
#ifndef _SFXTABDLG_HXX //autogen
#include <sfx2/tabdlg.hxx>
#endif

#ifndef _FMTCLBL_HXX
#include <fmtclbl.hxx>
#endif
#ifndef _COLEX_HXX
#include <colex.hxx>
#endif
#ifndef _PRCNTFLD_HXX
#include <prcntfld.hxx>
#endif

const int nMaxCols = 99;
class SwColMgr;
class SwWrtShell;
class SwColumnPage;
/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

class SwColumnDlg : public SfxModalDialog
{
	OKButton 			aOK;
	CancelButton 		aCancel;
	HelpButton 			aHelp;

	FixedText			aApplyToFT;
	ListBox				aApplyToLB;

	SwWrtShell& 		rWrtShell;
	SwColumnPage*		pTabPage;
	SfxItemSet* 		pPageSet;
	SfxItemSet* 		pSectionSet;
	SfxItemSet* 		pSelectionSet;
	SfxItemSet* 		pFrameSet;

	long				nOldSelection;
	long 				nSelectionWidth;
	long 				nPageWidth;

	BOOL				bPageChanged : 1;
	BOOL				bSectionChanged : 1;
	BOOL				bSelSectionChanged : 1;
	BOOL				bFrameChanged : 1;


	DECL_LINK(ObjectHdl, ListBox*);
	DECL_LINK(OkHdl, OKButton*);

public:
	SwColumnDlg(Window* pParent, SwWrtShell& rSh);
	virtual ~SwColumnDlg();

	SwWrtShell& 	GetWrtShell()	{ return rWrtShell; }
};

/*-----------------07.03.97 08.26-------------------

--------------------------------------------------*/
class ColumnValueSet : public ValueSet
{
	public:
		ColumnValueSet(Window* pParent, const ResId& rResId) :
			ValueSet(pParent, rResId){}
		~ColumnValueSet();

	virtual void	UserDraw( const UserDrawEvent& rUDEvt );
    virtual void    DataChanged( const DataChangedEvent& rDCEvt );
};

/*--------------------------------------------------------------------
	Beschreibung:	Spaltendialog jetzt als TabPage
 --------------------------------------------------------------------*/
class SwColumnPage : public SfxTabPage
{
	FixedText		aClNrLbl;
	NumericField	aCLNrEdt;
	ColumnValueSet	aDefaultVS;
	ImageList		aPreColsIL;
	CheckBox		aBalanceColsCB;
	FixedLine		aFLGroup;

	ImageButton		aBtnUp;
    FixedText       aColumnFT;
	FixedText		aWidthFT;
	FixedText		aDistFT;
    FixedText       aLbl1;
	PercentField	aEd1;
	PercentField	aDistEd1;
    FixedText       aLbl2;
	PercentField	aEd2;
	PercentField	aDistEd2;
    FixedText       aLbl3;
	PercentField	aEd3;
	ImageButton		aBtnDown;
	CheckBox		aAutoWidthBox;

	FixedLine		aFLLayout;

	FixedText		aLineTypeLbl;
	LineListBox		aLineTypeDLB;
	FixedText		aLineHeightLbl;
	MetricField		aLineHeightEdit;
	FixedText		aLinePosLbl;
	ListBox			aLinePosDLB;
	FixedLine		aFLLineType;

    FixedLine       aVertFL;
    FixedLine       aPropertiesFL;
    FixedText       aTextDirectionFT;
    ListBox         aTextDirectionLB;

    // Example
	SwColExample 		aPgeExampleWN;
	SwColumnOnlyExample	aFrmExampleWN;

	SwColMgr*       pColMgr;

	USHORT			nFirstVis;
	USHORT			nCols;
	long			nColWidth[nMaxCols];
	long			nColDist[nMaxCols];
	USHORT			nMinWidth;
	PercentField	*pModifiedField;
	BOOL 			bFormat;
	BOOL			bFrm;
	BOOL 			bHtmlMode;
	BOOL			bLockUpdate;

	// Handler
	DECL_LINK( ColModify, NumericField * );
	DECL_LINK( GapModify, PercentField * );
	DECL_LINK( EdModify, PercentField * );
	DECL_LINK( AutoWidthHdl, CheckBox * );
	DECL_LINK( Timeout, Timer * );
	DECL_LINK( SetDefaultsHdl, ValueSet * );

	DECL_LINK( Up, Button * );
	DECL_LINK( Down, Button * );
	void			Apply(Button *);
	DECL_LINK( UpdateColMgr, void* );

	void			Update();
	void			UpdateCols();
	void			Init();
	void			ResetColWidth();
	void			SetLabels( USHORT nVis );

    using TabPage::ActivatePage;
    using TabPage::DeactivatePage;

	virtual void 	ActivatePage(const SfxItemSet& rSet);
	virtual int 	DeactivatePage(SfxItemSet *pSet);

	SwColumnPage(Window *pParent, const SfxItemSet &rSet);

public:
    virtual ~SwColumnPage();

	static SfxTabPage *Create(Window *pParent, const SfxItemSet &rSet);
	static USHORT* GetRanges();

	virtual BOOL 	FillItemSet(SfxItemSet &rSet);
	virtual void 	Reset(const SfxItemSet &rSet);

	void SetFrmMode(BOOL bMod);
	void SetPageWidth(long nPageWidth);

	void SetFormatUsed(BOOL bFmt) { bFormat = bFmt; }

	void ShowBalance(BOOL bShow) {aBalanceColsCB.Show(bShow);}
    void SetInSection(BOOL bSet);

};

#endif

