/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: download.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2007/04/11 20:10:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _DOWNLOAD_HXX
#define _DOWNLOAD_HXX

// Forward declarations
class String;
class Link;

#define DOWNLOAD_SUCCESS	0
#define DOWNLOAD_CONNECT	1
#define DOWNLOAD_LOCATION	2
#define DOWNLOAD_ABORT		3
#define DOWNLOAD_FILEACCESS	4
#define DOWNLOAD_INSTALL	5
#define DOWNLOAD_ERROR		6

class Downloader
/* ***************************************************************************
Purpose: Abstract base class for a file downloader
*************************************************************************** */
{
public:
	Downloader() {};

	virtual void Download(const String &rDestLocation,
						  const String &rSourceLocation,
						  const Link &rFinishedLink) = 0;
};

#endif
