/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: hierarchydatasupplier.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: ihi $ $Date: 2007/06/05 18:06:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _HIERARCHYDATASUPPLIER_HXX
#define _HIERARCHYDATASUPPLIER_HXX

#ifndef _RTL_REF_HXX_
#include <rtl/ref.hxx>
#endif

#ifndef _COM_SUN_STAR_UCB_OPENMODE_HPP_
#include <com/sun/star/ucb/OpenMode.hpp>
#endif

#ifndef _UCBHELPER_RESULTSET_HXX
#include <ucbhelper/resultset.hxx>
#endif

namespace hierarchy_ucp {

class HierarchyEntryData;
struct DataSupplier_Impl;
class HierarchyContent;

class HierarchyResultSetDataSupplier : 
        public ::ucbhelper::ResultSetDataSupplier
{
	DataSupplier_Impl*	m_pImpl;

private:
	sal_Bool checkResult( const HierarchyEntryData& rResult );

public:
	HierarchyResultSetDataSupplier(
					const com::sun::star::uno::Reference<
						com::sun::star::lang::XMultiServiceFactory >& rxSMgr,
                    const rtl::Reference< HierarchyContent >& rContent,
					sal_Int32 nOpenMode = com::sun::star::ucb::OpenMode::ALL );
	virtual ~HierarchyResultSetDataSupplier();

	virtual rtl::OUString queryContentIdentifierString( sal_uInt32 nIndex );
	virtual com::sun::star::uno::Reference<
				com::sun::star::ucb::XContentIdentifier >
	queryContentIdentifier( sal_uInt32 nIndex );
	virtual com::sun::star::uno::Reference< com::sun::star::ucb::XContent >
	queryContent( sal_uInt32 nIndex );

	virtual sal_Bool getResult( sal_uInt32 nIndex );

	virtual sal_uInt32 totalCount();
	virtual sal_uInt32 currentCount();
	virtual sal_Bool isCountFinal();

	virtual com::sun::star::uno::Reference< com::sun::star::sdbc::XRow >
	queryPropertyValues( sal_uInt32 nIndex  );
	virtual void releasePropertyValues( sal_uInt32 nIndex );

	virtual void close();

	virtual void validate()
		throw( com::sun::star::ucb::ResultSetException );
};

} // namespace hierarchy_ucp

#endif /* !_HIERARCHYDATASUPPLIER_HXX */
