/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: qnametostr.cxx,v $
 *
 *  $Revision: 1.31 $
 *
 *  last change: $Author: vg $ $Date: 2007/10/29 15:28:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <doctok/resourceids.hxx>
#include <ooxml/resourceids.hxx>
#include <resourcemodel/QNameToString.hxx>

namespace writerfilter
{

QNameToString::Pointer_t QNameToString::pInstance;

QNameToString::Pointer_t QNameToString::Instance()
{
    if (pInstance.get() == NULL)
        pInstance = QNameToString::Pointer_t(new QNameToString());

    return pInstance;
}

string QNameToString::operator()(writerfilter::QName_t qName)
{
    return mMap[qName];
}

QNameToString::QNameToString()
{

    /* ooxml */
    
    mMap[NS_ooxml::LN_CT_Highlight_val] = "ooxml:CT_Highlight_val";
    mMap[NS_ooxml::LN_CT_Color_val] = "ooxml:CT_Color_val";
    mMap[NS_ooxml::LN_CT_Color_themeColor] = "ooxml:CT_Color_themeColor";
    mMap[NS_ooxml::LN_CT_Color_themeTint] = "ooxml:CT_Color_themeTint";
    mMap[NS_ooxml::LN_CT_Color_themeShade] = "ooxml:CT_Color_themeShade";
    mMap[NS_ooxml::LN_CT_Lang_val] = "ooxml:CT_Lang_val";
    mMap[NS_ooxml::LN_CT_Guid_val] = "ooxml:CT_Guid_val";
    mMap[NS_ooxml::LN_CT_Underline_val] = "ooxml:CT_Underline_val";
    mMap[NS_ooxml::LN_CT_Underline_color] = "ooxml:CT_Underline_color";
    mMap[NS_ooxml::LN_CT_Underline_themeColor] = "ooxml:CT_Underline_themeColor";
    mMap[NS_ooxml::LN_CT_Underline_themeTint] = "ooxml:CT_Underline_themeTint";
    mMap[NS_ooxml::LN_CT_Underline_themeShade] = "ooxml:CT_Underline_themeShade";
    mMap[NS_ooxml::LN_CT_TextEffect_val] = "ooxml:CT_TextEffect_val";
    mMap[NS_ooxml::LN_CT_Border_color] = "ooxml:CT_Border_color";
    mMap[NS_ooxml::LN_CT_Border_themeColor] = "ooxml:CT_Border_themeColor";
    mMap[NS_ooxml::LN_CT_Border_themeTint] = "ooxml:CT_Border_themeTint";
    mMap[NS_ooxml::LN_CT_Border_themeShade] = "ooxml:CT_Border_themeShade";
    mMap[NS_ooxml::LN_CT_Shd_val] = "ooxml:CT_Shd_val";
    mMap[NS_ooxml::LN_CT_Shd_color] = "ooxml:CT_Shd_color";
    mMap[NS_ooxml::LN_CT_Shd_themeColor] = "ooxml:CT_Shd_themeColor";
    mMap[NS_ooxml::LN_CT_Shd_themeTint] = "ooxml:CT_Shd_themeTint";
    mMap[NS_ooxml::LN_CT_Shd_themeShade] = "ooxml:CT_Shd_themeShade";
    mMap[NS_ooxml::LN_CT_Shd_fill] = "ooxml:CT_Shd_fill";
    mMap[NS_ooxml::LN_CT_Shd_themeFill] = "ooxml:CT_Shd_themeFill";
    mMap[NS_ooxml::LN_CT_Shd_themeFillTint] = "ooxml:CT_Shd_themeFillTint";
    mMap[NS_ooxml::LN_CT_Shd_themeFillShade] = "ooxml:CT_Shd_themeFillShade";
    mMap[NS_ooxml::LN_CT_Em_val] = "ooxml:CT_Em_val";
    mMap[NS_ooxml::LN_CT_Language_val] = "ooxml:CT_Language_val";
    mMap[NS_ooxml::LN_CT_Language_eastAsia] = "ooxml:CT_Language_eastAsia";
    mMap[NS_ooxml::LN_CT_Language_bidi] = "ooxml:CT_Language_bidi";
    mMap[NS_ooxml::LN_CT_EastAsianLayout_id] = "ooxml:CT_EastAsianLayout_id";
    mMap[NS_ooxml::LN_CT_EastAsianLayout_combine] = "ooxml:CT_EastAsianLayout_combine";
    mMap[NS_ooxml::LN_CT_EastAsianLayout_combineBrackets] = "ooxml:CT_EastAsianLayout_combineBrackets";
    mMap[NS_ooxml::LN_CT_EastAsianLayout_vert] = "ooxml:CT_EastAsianLayout_vert";
    mMap[NS_ooxml::LN_CT_EastAsianLayout_vertCompress] = "ooxml:CT_EastAsianLayout_vertCompress";
    mMap[NS_ooxml::LN_CT_FramePr_dropCap] = "ooxml:CT_FramePr_dropCap";
    mMap[NS_ooxml::LN_CT_FramePr_lines] = "ooxml:CT_FramePr_lines";
    mMap[NS_ooxml::LN_CT_FramePr_hAnchor] = "ooxml:CT_FramePr_hAnchor";
    mMap[NS_ooxml::LN_CT_FramePr_vAnchor] = "ooxml:CT_FramePr_vAnchor";
    mMap[NS_ooxml::LN_CT_FramePr_x] = "ooxml:CT_FramePr_x";
    mMap[NS_ooxml::LN_CT_FramePr_xAlign] = "ooxml:CT_FramePr_xAlign";
    mMap[NS_ooxml::LN_CT_FramePr_y] = "ooxml:CT_FramePr_y";
    mMap[NS_ooxml::LN_CT_FramePr_yAlign] = "ooxml:CT_FramePr_yAlign";
    mMap[NS_ooxml::LN_CT_FramePr_hRule] = "ooxml:CT_FramePr_hRule";
    mMap[NS_ooxml::LN_CT_TabStop_val] = "ooxml:CT_TabStop_val";
    mMap[NS_ooxml::LN_CT_TabStop_leader] = "ooxml:CT_TabStop_leader";
    mMap[NS_ooxml::LN_CT_TabStop_pos] = "ooxml:CT_TabStop_pos";
    mMap[NS_ooxml::LN_CT_Spacing_before] = "ooxml:CT_Spacing_before";
    mMap[NS_ooxml::LN_CT_Spacing_beforeLines] = "ooxml:CT_Spacing_beforeLines";
    mMap[NS_ooxml::LN_CT_Spacing_beforeAutospacing] = "ooxml:CT_Spacing_beforeAutospacing";
    mMap[NS_ooxml::LN_CT_Spacing_after] = "ooxml:CT_Spacing_after";
    mMap[NS_ooxml::LN_CT_Spacing_afterLines] = "ooxml:CT_Spacing_afterLines";
    mMap[NS_ooxml::LN_CT_Spacing_afterAutospacing] = "ooxml:CT_Spacing_afterAutospacing";
    mMap[NS_ooxml::LN_CT_Spacing_line] = "ooxml:CT_Spacing_line";
    mMap[NS_ooxml::LN_CT_Spacing_lineRule] = "ooxml:CT_Spacing_lineRule";
    mMap[NS_ooxml::LN_CT_Ind_left] = "ooxml:CT_Ind_left";
    mMap[NS_ooxml::LN_CT_Ind_leftChars] = "ooxml:CT_Ind_leftChars";
    mMap[NS_ooxml::LN_CT_Ind_right] = "ooxml:CT_Ind_right";
    mMap[NS_ooxml::LN_CT_Ind_rightChars] = "ooxml:CT_Ind_rightChars";
    mMap[NS_ooxml::LN_CT_Ind_hanging] = "ooxml:CT_Ind_hanging";
    mMap[NS_ooxml::LN_CT_Ind_hangingChars] = "ooxml:CT_Ind_hangingChars";
    mMap[NS_ooxml::LN_CT_Ind_firstLine] = "ooxml:CT_Ind_firstLine";
    mMap[NS_ooxml::LN_CT_Ind_firstLineChars] = "ooxml:CT_Ind_firstLineChars";
    mMap[NS_ooxml::LN_CT_Jc_val] = "ooxml:CT_Jc_val";
    mMap[NS_ooxml::LN_CT_Markup_id] = "ooxml:CT_Markup_id";
    mMap[NS_ooxml::LN_CT_TrackChange_author] = "ooxml:CT_TrackChange_author";
    mMap[NS_ooxml::LN_CT_TrackChange_date] = "ooxml:CT_TrackChange_date";
    mMap[NS_ooxml::LN_CT_Comment_initials] = "ooxml:CT_Comment_initials";
    mMap[NS_ooxml::LN_CT_SectPrChange_sectPr] = "ooxml:CT_SectPrChange_sectPr";
    mMap[NS_ooxml::LN_CT_NumPr_numberingChange] = "ooxml:CT_NumPr_numberingChange";
    mMap[NS_ooxml::LN_CT_NumPr_ins] = "ooxml:CT_NumPr_ins";
    mMap[NS_ooxml::LN_CT_Tabs_tab] = "ooxml:CT_Tabs_tab";
    mMap[NS_ooxml::LN_CT_PPrBase_pStyle] = "ooxml:CT_PPrBase_pStyle";
    mMap[NS_ooxml::LN_CT_PPrBase_framePr] = "ooxml:CT_PPrBase_framePr";
    mMap[NS_ooxml::LN_CT_PPrBase_windowControl] = "ooxml:CT_PPrBase_windowControl";
    mMap[NS_ooxml::LN_CT_PPrBase_numPr] = "ooxml:CT_PPrBase_numPr";
    mMap[NS_ooxml::LN_CT_PrBase_pBdr] = "ooxml:CT_PrBase_pBdr";
    mMap[NS_ooxml::LN_CT_PPrBase_tabs] = "ooxml:CT_PPrBase_tabs";
    mMap[NS_ooxml::LN_CT_PPrBase_kinsoku] = "ooxml:CT_PPrBase_kinsoku";
    mMap[NS_ooxml::LN_CT_PPrBase_wordWrap] = "ooxml:CT_PPrBase_wordWrap";
    mMap[NS_ooxml::LN_CT_PPrBase_adjustRightInd] = "ooxml:CT_PPrBase_adjustRightInd";
    mMap[NS_ooxml::LN_CT_PPrBase_snapToGrid] = "ooxml:CT_PPrBase_snapToGrid";
    mMap[NS_ooxml::LN_CT_PPrBase_spacing] = "ooxml:CT_PPrBase_spacing";
    mMap[NS_ooxml::LN_CT_PPrBase_ind] = "ooxml:CT_PPrBase_ind";
    mMap[NS_ooxml::LN_CT_PPrBase_divId] = "ooxml:CT_PPrBase_divId";
    mMap[NS_ooxml::LN_CT_PPrBase_cnfStyle] = "ooxml:CT_PPrBase_cnfStyle";
    mMap[NS_ooxml::LN_CT_PPr_rPr] = "ooxml:CT_PPr_rPr";
    mMap[NS_ooxml::LN_CT_PPr_sectPr] = "ooxml:CT_PPr_sectPr";
    mMap[NS_ooxml::LN_CT_PPr_pPrChange] = "ooxml:CT_PPr_pPrChange";
    mMap[NS_ooxml::LN_CT_Rel_id] = "ooxml:CT_Rel_id";
    mMap[NS_ooxml::LN_CT_PageSz_w] = "ooxml:CT_PageSz_w";
    mMap[NS_ooxml::LN_CT_PageSz_h] = "ooxml:CT_PageSz_h";
    mMap[NS_ooxml::LN_CT_PageSz_orient] = "ooxml:CT_PageSz_orient";
    mMap[NS_ooxml::LN_CT_PageSz_code] = "ooxml:CT_PageSz_code";
    mMap[NS_ooxml::LN_CT_PageMar_top] = "ooxml:CT_PageMar_top";
    mMap[NS_ooxml::LN_CT_PageMar_right] = "ooxml:CT_PageMar_right";
    mMap[NS_ooxml::LN_CT_PageMar_bottom] = "ooxml:CT_PageMar_bottom";
    mMap[NS_ooxml::LN_CT_PageMar_left] = "ooxml:CT_PageMar_left";
    mMap[NS_ooxml::LN_CT_PageMar_header] = "ooxml:CT_PageMar_header";
    mMap[NS_ooxml::LN_CT_PageMar_footer] = "ooxml:CT_PageMar_footer";
    mMap[NS_ooxml::LN_CT_PageMar_gutter] = "ooxml:CT_PageMar_gutter";
    mMap[NS_ooxml::LN_CT_LineNumber_countBy] = "ooxml:CT_LineNumber_countBy";
    mMap[NS_ooxml::LN_CT_LineNumber_start] = "ooxml:CT_LineNumber_start";
    mMap[NS_ooxml::LN_CT_LineNumber_distance] = "ooxml:CT_LineNumber_distance";
    mMap[NS_ooxml::LN_CT_LineNumber_restart] = "ooxml:CT_LineNumber_restart";
    mMap[NS_ooxml::LN_CT_PageNumber_fmt] = "ooxml:CT_PageNumber_fmt";
    mMap[NS_ooxml::LN_CT_PageNumber_start] = "ooxml:CT_PageNumber_start";
    mMap[NS_ooxml::LN_CT_PageNumber_chapStyle] = "ooxml:CT_PageNumber_chapStyle";
    mMap[NS_ooxml::LN_CT_PageNumber_chapSep] = "ooxml:CT_PageNumber_chapSep";
    mMap[NS_ooxml::LN_CT_Column_space] = "ooxml:CT_Column_space";
    mMap[NS_ooxml::LN_CT_Column_w] = "ooxml:CT_Column_w";
    mMap[NS_ooxml::LN_CT_Columns_equalWidth] = "ooxml:CT_Columns_equalWidth";
    mMap[NS_ooxml::LN_CT_Columns_space] = "ooxml:CT_Columns_space";
    mMap[NS_ooxml::LN_CT_Columns_num] = "ooxml:CT_Columns_num";
    mMap[NS_ooxml::LN_CT_Columns_sep] = "ooxml:CT_Columns_sep";
    mMap[NS_ooxml::LN_CT_Columns_col] = "ooxml:CT_Columns_col";
    mMap[NS_ooxml::LN_CT_HdrFtrRef_type] = "ooxml:CT_HdrFtrRef_type";
    mMap[NS_ooxml::LN_CT_HdrFtrRef_id] = "ooxml:CT_HdrFtrRef_id";
    mMap[NS_ooxml::LN_EG_HdrFtrReferences_headerReference] = "ooxml:EG_HdrFtrReferences_headerReference";
    mMap[NS_ooxml::LN_EG_HdrFtrReferences_footerReference] = "ooxml:EG_HdrFtrReferences_footerReference";
    mMap[NS_ooxml::LN_EG_SectPrContents_bidi] = "ooxml:EG_SectPrContents_bidi";
    mMap[NS_ooxml::LN_EG_SectPrContents_cols] = "ooxml:EG_SectPrContents_cols";
    mMap[NS_ooxml::LN_EG_SectPrContents_docGrid] = "ooxml:EG_SectPrContents_docGrid";
    mMap[NS_ooxml::LN_EG_SectPrContents_endnotePr] = "ooxml:EG_SectPrContents_endnotePr";
    mMap[NS_ooxml::LN_EG_SectPrContents_footnotePr] = "ooxml:EG_SectPrContents_footnotePr";
    mMap[NS_ooxml::LN_EG_SectPrContents_formProt] = "ooxml:EG_SectPrContents_formProt";
    mMap[NS_ooxml::LN_EG_SectPrContents_lnNumType] = "ooxml:EG_SectPrContents_lnNumType";
    mMap[NS_ooxml::LN_EG_SectPrContents_noEndnote] = "ooxml:EG_SectPrContents_noEndnote";
    mMap[NS_ooxml::LN_EG_SectPrContents_paperSrc] = "ooxml:EG_SectPrContents_paperSrc";
    mMap[NS_ooxml::LN_EG_SectPrContents_pgBorders] = "ooxml:EG_SectPrContents_pgBorders";
    mMap[NS_ooxml::LN_EG_SectPrContents_pgMar] = "ooxml:EG_SectPrContents_pgMar";
    mMap[NS_ooxml::LN_EG_SectPrContents_pgNumType] = "ooxml:EG_SectPrContents_pgNumType";
    mMap[NS_ooxml::LN_EG_SectPrContents_pgSz] = "ooxml:EG_SectPrContents_pgSz";
    mMap[NS_ooxml::LN_EG_SectPrContents_printerSettings] = "ooxml:EG_SectPrContents_printerSettings";
    mMap[NS_ooxml::LN_EG_SectPrContents_rtlGutter] = "ooxml:EG_SectPrContents_rtlGutter";
    mMap[NS_ooxml::LN_EG_SectPrContents_textDirection] = "ooxml:EG_SectPrContents_textDirection";
    mMap[NS_ooxml::LN_EG_SectPrContents_titlePg] = "ooxml:EG_SectPrContents_titlePg";
    mMap[NS_ooxml::LN_EG_SectPrContents_vAlign] = "ooxml:EG_SectPrContents_vAlign";
    mMap[NS_ooxml::LN_CT_SectPr_sectPrChange] = "ooxml:CT_SectPr_sectPrChange";
    mMap[NS_ooxml::LN_CT_Br_type] = "ooxml:CT_Br_type";
    mMap[NS_ooxml::LN_CT_Br_clear] = "ooxml:CT_Br_clear";
    mMap[NS_ooxml::LN_CT_PTab_alignment] = "ooxml:CT_PTab_alignment";
    mMap[NS_ooxml::LN_CT_PTab_relativeTo] = "ooxml:CT_PTab_relativeTo";
    mMap[NS_ooxml::LN_CT_PTab_leader] = "ooxml:CT_PTab_leader";
    mMap[NS_ooxml::LN_CT_Sym_font] = "ooxml:CT_Sym_font";
    mMap[NS_ooxml::LN_CT_Sym_char] = "ooxml:CT_Sym_char";
    mMap[NS_ooxml::LN_CT_Fonts_hint] = "ooxml:CT_Fonts_hint";
    mMap[NS_ooxml::LN_CT_Fonts_ascii] = "ooxml:CT_Fonts_ascii";
    mMap[NS_ooxml::LN_CT_Fonts_hAnsi] = "ooxml:CT_Fonts_hAnsi";
    mMap[NS_ooxml::LN_CT_Fonts_eastAsia] = "ooxml:CT_Fonts_eastAsia";
    mMap[NS_ooxml::LN_CT_Fonts_cs] = "ooxml:CT_Fonts_cs";
    mMap[NS_ooxml::LN_CT_Fonts_asciiTheme] = "ooxml:CT_Fonts_asciiTheme";
    mMap[NS_ooxml::LN_CT_Fonts_hAnsiTheme] = "ooxml:CT_Fonts_hAnsiTheme";
    mMap[NS_ooxml::LN_CT_Fonts_eastAsiaTheme] = "ooxml:CT_Fonts_eastAsiaTheme";
    mMap[NS_ooxml::LN_CT_Fonts_cstheme] = "ooxml:CT_Fonts_cstheme";
    mMap[NS_ooxml::LN_EG_RPrBase_rStyle] = "ooxml:EG_RPrBase_rStyle";
    mMap[NS_ooxml::LN_EG_RPrBase_rFonts] = "ooxml:EG_RPrBase_rFonts";
    mMap[NS_ooxml::LN_EG_RPrBase_snapToGrid] = "ooxml:EG_RPrBase_snapToGrid";
    mMap[NS_ooxml::LN_EG_RPrBase_color] = "ooxml:EG_RPrBase_color";
    mMap[NS_ooxml::LN_EG_RPrBase_u] = "ooxml:EG_RPrBase_u";
    mMap[NS_ooxml::LN_EG_RPrBase_bdr] = "ooxml:EG_RPrBase_bdr";
    mMap[NS_ooxml::LN_EG_RPrBase_shd] = "ooxml:EG_RPrBase_shd";
    mMap[NS_ooxml::LN_EG_RPrBase_fitText] = "ooxml:EG_RPrBase_fitText";
    mMap[NS_ooxml::LN_EG_RPrBase_vertAlign] = "ooxml:EG_RPrBase_vertAlign";
    mMap[NS_ooxml::LN_EG_RPrBase_rtl] = "ooxml:EG_RPrBase_rtl";
    mMap[NS_ooxml::LN_EG_RPrBase_lang] = "ooxml:EG_RPrBase_lang";
    mMap[NS_ooxml::LN_EG_RPrBase_eastAsianLayout] = "ooxml:EG_RPrBase_eastAsianLayout";
    mMap[NS_ooxml::LN_EG_RPrBase_oMath] = "ooxml:EG_RPrBase_oMath";
    mMap[NS_ooxml::LN_CT_ParaRPr_rPrChange] = "ooxml:CT_ParaRPr_rPrChange";
    mMap[NS_ooxml::LN_CT_Height_val] = "ooxml:CT_Height_val";
    mMap[NS_ooxml::LN_CT_Height_hRule] = "ooxml:CT_Height_hRule";
    mMap[NS_ooxml::LN_CT_TblWidth_w] = "ooxml:CT_TblWidth_w";
    mMap[NS_ooxml::LN_CT_TblWidth_type] = "ooxml:CT_TblWidth_type";
    mMap[NS_ooxml::LN_CT_TblGridBase_gridCol] = "ooxml:CT_TblGridBase_gridCol";
    mMap[NS_ooxml::LN_CT_TblGrid_tblGridChange] = "ooxml:CT_TblGrid_tblGridChange";
    mMap[NS_ooxml::LN_CT_TcBorders_top] = "ooxml:CT_TcBorders_top";
    mMap[NS_ooxml::LN_CT_TcBorders_left] = "ooxml:CT_TcBorders_left";
    mMap[NS_ooxml::LN_CT_TcBorders_bottom] = "ooxml:CT_TcBorders_bottom";
    mMap[NS_ooxml::LN_CT_TcBorders_right] = "ooxml:CT_TcBorders_right";
    mMap[NS_ooxml::LN_CT_TcBorders_insideH] = "ooxml:CT_TcBorders_insideH";
    mMap[NS_ooxml::LN_CT_TcBorders_insideV] = "ooxml:CT_TcBorders_insideV";
    mMap[NS_ooxml::LN_CT_TcBorders_tl2br] = "ooxml:CT_TcBorders_tl2br";
    mMap[NS_ooxml::LN_CT_TcBorders_tr2bl] = "ooxml:CT_TcBorders_tr2bl";
    mMap[NS_ooxml::LN_CT_TcMar_top] = "ooxml:CT_TcMar_top";
    mMap[NS_ooxml::LN_CT_TcMar_left] = "ooxml:CT_TcMar_left";
    mMap[NS_ooxml::LN_CT_TcMar_bottom] = "ooxml:CT_TcMar_bottom";
    mMap[NS_ooxml::LN_CT_TcMar_right] = "ooxml:CT_TcMar_right";
    mMap[NS_ooxml::LN_CT_TcPrBase_cnfStyle] = "ooxml:CT_TcPrBase_cnfStyle";
    mMap[NS_ooxml::LN_CT_TcPrBase_tcW] = "ooxml:CT_TcPrBase_tcW";
    mMap[NS_ooxml::LN_CT_TcPrBase_gridSpan] = "ooxml:CT_TcPrBase_gridSpan";
    mMap[NS_ooxml::LN_CT_TcPrBase_hMerge] = "ooxml:CT_TcPrBase_hMerge";
    mMap[NS_ooxml::LN_CT_TcPrBase_vMerge] = "ooxml:CT_TcPrBase_vMerge";
    mMap[NS_ooxml::LN_CT_TcPrBase_tcBorders] = "ooxml:CT_TcPrBase_tcBorders";
    mMap[NS_ooxml::LN_CT_TcPrBase_shd] = "ooxml:CT_TcPrBase_shd";
    mMap[NS_ooxml::LN_CT_TcPrBase_noWrap] = "ooxml:CT_TcPrBase_noWrap";
    mMap[NS_ooxml::LN_CT_TcPrBase_tcMar] = "ooxml:CT_TcPrBase_tcMar";
    mMap[NS_ooxml::LN_CT_TcPrBase_textDirection] = "ooxml:CT_TcPrBase_textDirection";
    mMap[NS_ooxml::LN_CT_TcPrBase_tcFitText] = "ooxml:CT_TcPrBase_tcFitText";
    mMap[NS_ooxml::LN_CT_TcPrBase_vAlign] = "ooxml:CT_TcPrBase_vAlign";
    mMap[NS_ooxml::LN_CT_TcPrBase_hideMark] = "ooxml:CT_TcPrBase_hideMark";
    mMap[NS_ooxml::LN_CT_TrPrBase_cnfStyle] = "ooxml:CT_TrPrBase_cnfStyle";
    mMap[NS_ooxml::LN_CT_TrPrBase_divId] = "ooxml:CT_TrPrBase_divId";
    mMap[NS_ooxml::LN_CT_TrPrBase_gridBefore] = "ooxml:CT_TrPrBase_gridBefore";
    mMap[NS_ooxml::LN_CT_TrPrBase_gridAfter] = "ooxml:CT_TrPrBase_gridAfter";
    mMap[NS_ooxml::LN_CT_TrPrBase_wBefore] = "ooxml:CT_TrPrBase_wBefore";
    mMap[NS_ooxml::LN_CT_TrPrBase_wAfter] = "ooxml:CT_TrPrBase_wAfter";
    mMap[NS_ooxml::LN_CT_TrPrBase_trHeight] = "ooxml:CT_TrPrBase_trHeight";
    mMap[NS_ooxml::LN_CT_TrPrBase_tblHeader] = "ooxml:CT_TrPrBase_tblHeader";
    mMap[NS_ooxml::LN_CT_TrPrBase_tblCellSpacing] = "ooxml:CT_TrPrBase_tblCellSpacing";
    mMap[NS_ooxml::LN_CT_TrPrBase_jc] = "ooxml:CT_TrPrBase_jc";
    mMap[NS_ooxml::LN_CT_TrPrBase_hidden] = "ooxml:CT_TrPrBase_hidden";
    mMap[NS_ooxml::LN_CT_TblBorders_top] = "ooxml:CT_TblBorders_top";
    mMap[NS_ooxml::LN_CT_TblBorders_left] = "ooxml:CT_TblBorders_left";
    mMap[NS_ooxml::LN_CT_TblBorders_bottom] = "ooxml:CT_TblBorders_bottom";
    mMap[NS_ooxml::LN_CT_TblBorders_right] = "ooxml:CT_TblBorders_right";
    mMap[NS_ooxml::LN_CT_TblBorders_insideH] = "ooxml:CT_TblBorders_insideH";
    mMap[NS_ooxml::LN_CT_TblBorders_insideV] = "ooxml:CT_TblBorders_insideV";
    mMap[NS_ooxml::LN_CT_TblPrBase_tblStyle] = "ooxml:CT_TblPrBase_tblStyle";
    mMap[NS_ooxml::LN_CT_TblPrBase_tblpPr] = "ooxml:CT_TblPrBase_tblpPr";
    mMap[NS_ooxml::LN_CT_TblPrBase_tblOverlap] = "ooxml:CT_TblPrBase_tblOverlap";
    mMap[NS_ooxml::LN_CT_TblPrBase_bidiVisual] = "ooxml:CT_TblPrBase_bidiVisual";
    mMap[NS_ooxml::LN_CT_TblPrBase_tblStyleRowBandSize] = "ooxml:CT_TblPrBase_tblStyleRowBandSize";
    mMap[NS_ooxml::LN_CT_TblPrBase_tblStyleColBandSize] = "ooxml:CT_TblPrBase_tblStyleColBandSize";
    mMap[NS_ooxml::LN_CT_TblPrBase_tblW] = "ooxml:CT_TblPrBase_tblW";
    mMap[NS_ooxml::LN_CT_TblPrBase_jc] = "ooxml:CT_TblPrBase_jc";
    mMap[NS_ooxml::LN_CT_TblPrBase_tblCellSpacing] = "ooxml:CT_TblPrBase_tblCellSpacing";
    mMap[NS_ooxml::LN_CT_TblPrBase_tblInd] = "ooxml:CT_TblPrBase_tblInd";
    mMap[NS_ooxml::LN_CT_TblPrBase_tblBorders] = "ooxml:CT_TblPrBase_tblBorders";
    mMap[NS_ooxml::LN_CT_TblPrBase_shd] = "ooxml:CT_TblPrBase_shd";
    mMap[NS_ooxml::LN_CT_TblPrBase_tblLayout] = "ooxml:CT_TblPrBase_tblLayout";
    mMap[NS_ooxml::LN_CT_TblPrBase_tblCellMar] = "ooxml:CT_TblPrBase_tblCellMar";
    mMap[NS_ooxml::LN_CT_TblPrBase_tblLook] = "ooxml:CT_TblPrBase_tblLook";
    mMap[NS_ooxml::LN_CT_TblPr_tblPrChange] = "ooxml:CT_TblPr_tblPrChange";
    mMap[NS_ooxml::LN_CT_FtnPos_val] = "ooxml:CT_FtnPos_val";
    mMap[NS_ooxml::LN_CT_EdnPos_val] = "ooxml:CT_EdnPos_val";
    mMap[NS_ooxml::LN_CT_NumFmt_val] = "ooxml:CT_NumFmt_val";
    mMap[NS_ooxml::LN_CT_NumRestart_val] = "ooxml:CT_NumRestart_val";
    mMap[NS_ooxml::LN_CT_FtnEdnRef_customMarkFollows] = "ooxml:CT_FtnEdnRef_customMarkFollows";
    mMap[NS_ooxml::LN_CT_FtnEdnRef_id] = "ooxml:CT_FtnEdnRef_id";
    mMap[NS_ooxml::LN_EG_FtnEdnNumProps_numStart] = "ooxml:EG_FtnEdnNumProps_numStart";
    mMap[NS_ooxml::LN_EG_FtnEdnNumProps_numRestart] = "ooxml:EG_FtnEdnNumProps_numRestart";
    mMap[NS_ooxml::LN_CT_FtnProps_pos] = "ooxml:CT_FtnProps_pos";
    mMap[NS_ooxml::LN_CT_FtnProps_numFmt] = "ooxml:CT_FtnProps_numFmt";
    mMap[NS_ooxml::LN_CT_EdnProps_pos] = "ooxml:CT_EdnProps_pos";
    mMap[NS_ooxml::LN_CT_EdnProps_numFmt] = "ooxml:CT_EdnProps_numFmt";
    mMap[NS_ooxml::LN_CT_RPrDefault_rPr] = "ooxml:CT_RPrDefault_rPr";
    mMap[NS_ooxml::LN_CT_PPrDefault_pPr] = "ooxml:CT_PPrDefault_pPr";
    mMap[NS_ooxml::LN_CT_DocDefaults_pPrDefault] = "ooxml:CT_DocDefaults_pPrDefault";
    mMap[NS_ooxml::LN_CT_DocDefaults_rPrDefault] = "ooxml:CT_DocDefaults_rPrDefault";
    mMap[NS_ooxml::LN_CT_LevelText_val] = "ooxml:CT_LevelText_val";
    mMap[NS_ooxml::LN_CT_LevelText_null] = "ooxml:CT_LevelText_null";
    mMap[NS_ooxml::LN_CT_LvlLegacy_legacy] = "ooxml:CT_LvlLegacy_legacy";
    mMap[NS_ooxml::LN_CT_LvlLegacy_legacySpace] = "ooxml:CT_LvlLegacy_legacySpace";
    mMap[NS_ooxml::LN_CT_LvlLegacy_legacyIndent] = "ooxml:CT_LvlLegacy_legacyIndent";
    mMap[NS_ooxml::LN_CT_Lvl_lvlRestart] = "ooxml:CT_Lvl_lvlRestart";
    mMap[NS_ooxml::LN_CT_Lvl_pStyle] = "ooxml:CT_Lvl_pStyle";
    mMap[NS_ooxml::LN_CT_Lvl_suff] = "ooxml:CT_Lvl_suff";
    mMap[NS_ooxml::LN_CT_Lvl_lvlText] = "ooxml:CT_Lvl_lvlText";
    mMap[NS_ooxml::LN_CT_Lvl_lvlPicBulletId] = "ooxml:CT_Lvl_lvlPicBulletId";
    mMap[NS_ooxml::LN_CT_Lvl_lvlJc] = "ooxml:CT_Lvl_lvlJc";
    mMap[NS_ooxml::LN_CT_Lvl_pPr] = "ooxml:CT_Lvl_pPr";
    mMap[NS_ooxml::LN_CT_Lvl_rPr] = "ooxml:CT_Lvl_rPr";
    mMap[NS_ooxml::LN_CT_Lvl_ilvl] = "ooxml:CT_Lvl_ilvl";
    mMap[NS_ooxml::LN_CT_Lvl_tplc] = "ooxml:CT_Lvl_tplc";
    mMap[NS_ooxml::LN_CT_Lvl_tentative] = "ooxml:CT_Lvl_tentative";
    mMap[NS_ooxml::LN_CT_AbstractNum_multiLevelType] = "ooxml:CT_AbstractNum_multiLevelType";
    mMap[NS_ooxml::LN_CT_AbstractNum_name] = "ooxml:CT_AbstractNum_name";
    mMap[NS_ooxml::LN_CT_AbstractNum_styleLink] = "ooxml:CT_AbstractNum_styleLink";
    mMap[NS_ooxml::LN_CT_AbstractNum_numStyleLink] = "ooxml:CT_AbstractNum_numStyleLink";
    mMap[NS_ooxml::LN_CT_AbstractNum_lvl] = "ooxml:CT_AbstractNum_lvl";
    mMap[NS_ooxml::LN_CT_AbstractNum_abstractNumId] = "ooxml:CT_AbstractNum_abstractNumId";
    mMap[NS_ooxml::LN_CT_NumLvl_startOverride] = "ooxml:CT_NumLvl_startOverride";
    mMap[NS_ooxml::LN_CT_NumLvl_lvl] = "ooxml:CT_NumLvl_lvl";
    mMap[NS_ooxml::LN_CT_NumLvl_ilvl] = "ooxml:CT_NumLvl_ilvl";
    mMap[NS_ooxml::LN_CT_Num_abstractNumId] = "ooxml:CT_Num_abstractNumId";
    mMap[NS_ooxml::LN_CT_Num_lvlOverride] = "ooxml:CT_Num_lvlOverride";
    mMap[NS_ooxml::LN_CT_Num_numId] = "ooxml:CT_Num_numId";
    mMap[NS_ooxml::LN_CT_Numbering_numPicBullet] = "ooxml:CT_Numbering_numPicBullet";
    mMap[NS_ooxml::LN_CT_Numbering_abstractNum] = "ooxml:CT_Numbering_abstractNum";
    mMap[NS_ooxml::LN_CT_Numbering_num] = "ooxml:CT_Numbering_num";
    mMap[NS_ooxml::LN_CT_Numbering_numIdMacAtCleanup] = "ooxml:CT_Numbering_numIdMacAtCleanup";
    mMap[NS_ooxml::LN_CT_Style_name] = "ooxml:CT_Style_name";
    mMap[NS_ooxml::LN_CT_Style_aliases] = "ooxml:CT_Style_aliases";
    mMap[NS_ooxml::LN_CT_Style_basedOn] = "ooxml:CT_Style_basedOn";
    mMap[NS_ooxml::LN_CT_Style_next] = "ooxml:CT_Style_next";
    mMap[NS_ooxml::LN_CT_Style_link] = "ooxml:CT_Style_link";
    mMap[NS_ooxml::LN_CT_Style_autoRedefine] = "ooxml:CT_Style_autoRedefine";
    mMap[NS_ooxml::LN_CT_Style_hidden] = "ooxml:CT_Style_hidden";
    mMap[NS_ooxml::LN_CT_Style_uiPriority] = "ooxml:CT_Style_uiPriority";
    mMap[NS_ooxml::LN_CT_Style_semiHidden] = "ooxml:CT_Style_semiHidden";
    mMap[NS_ooxml::LN_CT_Style_unhideWhenUsed] = "ooxml:CT_Style_unhideWhenUsed";
    mMap[NS_ooxml::LN_CT_Style_qFormat] = "ooxml:CT_Style_qFormat";
    mMap[NS_ooxml::LN_CT_Style_locked] = "ooxml:CT_Style_locked";
    mMap[NS_ooxml::LN_CT_Style_personal] = "ooxml:CT_Style_personal";
    mMap[NS_ooxml::LN_CT_Style_personalCompose] = "ooxml:CT_Style_personalCompose";
    mMap[NS_ooxml::LN_CT_Style_personalReply] = "ooxml:CT_Style_personalReply";
    mMap[NS_ooxml::LN_CT_Style_rsid] = "ooxml:CT_Style_rsid";
    mMap[NS_ooxml::LN_CT_Style_pPr] = "ooxml:CT_Style_pPr";
    mMap[NS_ooxml::LN_CT_Style_rPr] = "ooxml:CT_Style_rPr";
    mMap[NS_ooxml::LN_CT_Style_tblPr] = "ooxml:CT_Style_tblPr";
    mMap[NS_ooxml::LN_CT_Style_trPr] = "ooxml:CT_Style_trPr";
    mMap[NS_ooxml::LN_CT_Style_tcPr] = "ooxml:CT_Style_tcPr";
    mMap[NS_ooxml::LN_CT_Style_tblStylePr] = "ooxml:CT_Style_tblStylePr";
    mMap[NS_ooxml::LN_CT_Style_type] = "ooxml:CT_Style_type";
    mMap[NS_ooxml::LN_CT_Style_styleId] = "ooxml:CT_Style_styleId";
    mMap[NS_ooxml::LN_CT_Style_default] = "ooxml:CT_Style_default";
    mMap[NS_ooxml::LN_CT_Style_customStyle] = "ooxml:CT_Style_customStyle";
    mMap[NS_ooxml::LN_CT_FontSig_usb0] = "ooxml:CT_FontSig_usb0";
    mMap[NS_ooxml::LN_CT_FontSig_usb1] = "ooxml:CT_FontSig_usb1";
    mMap[NS_ooxml::LN_CT_FontSig_usb2] = "ooxml:CT_FontSig_usb2";
    mMap[NS_ooxml::LN_CT_FontSig_usb3] = "ooxml:CT_FontSig_usb3";
    mMap[NS_ooxml::LN_CT_FontSig_csb0] = "ooxml:CT_FontSig_csb0";
    mMap[NS_ooxml::LN_CT_FontSig_csb1] = "ooxml:CT_FontSig_csb1";
    mMap[NS_ooxml::LN_CT_FontRel_fontKey] = "ooxml:CT_FontRel_fontKey";
    mMap[NS_ooxml::LN_CT_FontRel_subsetted] = "ooxml:CT_FontRel_subsetted";
    mMap[NS_ooxml::LN_CT_Font_altName] = "ooxml:CT_Font_altName";
    mMap[NS_ooxml::LN_CT_Font_panose1] = "ooxml:CT_Font_panose1";
    mMap[NS_ooxml::LN_CT_Font_charset] = "ooxml:CT_Font_charset";
    mMap[NS_ooxml::LN_CT_Font_family] = "ooxml:CT_Font_family";
    mMap[NS_ooxml::LN_CT_Font_notTrueType] = "ooxml:CT_Font_notTrueType";
    mMap[NS_ooxml::LN_CT_Font_pitch] = "ooxml:CT_Font_pitch";
    mMap[NS_ooxml::LN_CT_Font_sig] = "ooxml:CT_Font_sig";
    mMap[NS_ooxml::LN_CT_Font_embedRegular] = "ooxml:CT_Font_embedRegular";
    mMap[NS_ooxml::LN_CT_Font_embedBold] = "ooxml:CT_Font_embedBold";
    mMap[NS_ooxml::LN_CT_Font_embedItalic] = "ooxml:CT_Font_embedItalic";
    mMap[NS_ooxml::LN_CT_Font_embedBoldItalic] = "ooxml:CT_Font_embedBoldItalic";
    mMap[NS_ooxml::LN_CT_Font_name] = "ooxml:CT_Font_name";
        /* Attributes */
    mMap[NS_rtf::LN_ISTD]= "rtf:ISTD";
    mMap[NS_rtf::LN_header]= "rtf:header";
    mMap[NS_rtf::LN_footer]= "rtf:footer";
    mMap[NS_rtf::LN_headerr]= "rtf:headerr";
    mMap[NS_rtf::LN_headerl]= "rtf:headerl";
    mMap[NS_rtf::LN_footerr]= "rtf:footerr";
    mMap[NS_rtf::LN_footerl]= "rtf:footerl";
    mMap[NS_rtf::LN_headerf]= "rtf:headerf";
    mMap[NS_rtf::LN_footerf]= "rtf:footerf";
    mMap[NS_rtf::LN_footnote]= "rtf:footnote";
    mMap[NS_rtf::LN_endnote]= "rtf:endnote";
    mMap[NS_rtf::LN_annotation]= "rtf:annotation";
    mMap[NS_rtf::LN_BOOKMARKNAME]= "rtf:BOOKMARKNAME";
    mMap[NS_rtf::LN_XAlign]= "rtf:XAlign";
    mMap[NS_rtf::LN_YAlign]= "rtf:YAlign";
    mMap[NS_rtf::LN_XRelTo]= "rtf:XRelTo";
    mMap[NS_rtf::LN_YRelTo]= "rtf:YRelTo";
    mMap[NS_rtf::LN_LayoutInTableCell]= "rtf:LayoutInTableCell";
    mMap[NS_rtf::LN_Inline]= "rtf:Inline";
    mMap[NS_rtf::LN_DffRecord]= "rtf:DffRecord";
    mMap[NS_rtf::LN_DffAttribute]= "rtf:DffAttribute";
    mMap[NS_rtf::LN_dfftype]= "rtf:dfftype";
    mMap[NS_rtf::LN_dffheader]= "rtf:dffheader";
    mMap[NS_rtf::LN_dffinstance]= "rtf:dffinstance";
    mMap[NS_rtf::LN_dffversion]= "rtf:dffversion";
    mMap[NS_rtf::LN_blob]= "rtf:blob";
    mMap[NS_rtf::LN_ISTARTAT]= "rtf:ISTARTAT";
    mMap[NS_rtf::LN_NFC]= "rtf:NFC";
    mMap[NS_rtf::LN_JC]= "rtf:JC";
    mMap[NS_rtf::LN_FLEGAL]= "rtf:FLEGAL";
    mMap[NS_rtf::LN_FNORESTART]= "rtf:FNORESTART";
    mMap[NS_rtf::LN_FPREV]= "rtf:FPREV";
    mMap[NS_rtf::LN_FPREVSPACE]= "rtf:FPREVSPACE";
    mMap[NS_rtf::LN_FWORD6]= "rtf:FWORD6";
    mMap[NS_rtf::LN_UNUSED5_7]= "rtf:UNUSED5_7";
    mMap[NS_rtf::LN_RGBXCHNUMS]= "rtf:RGBXCHNUMS";
    mMap[NS_rtf::LN_IXCHFOLLOW]= "rtf:IXCHFOLLOW";
    mMap[NS_rtf::LN_DXASPACE]= "rtf:DXASPACE";
    mMap[NS_rtf::LN_DXAINDENT]= "rtf:DXAINDENT";
    mMap[NS_rtf::LN_CBGRPPRLCHPX]= "rtf:CBGRPPRLCHPX";
    mMap[NS_rtf::LN_CBGRPPRLPAPX]= "rtf:CBGRPPRLPAPX";
    mMap[NS_rtf::LN_LSID]= "rtf:LSID";
    mMap[NS_rtf::LN_TPLC]= "rtf:TPLC";
    mMap[NS_rtf::LN_RGISTD]= "rtf:RGISTD";
    mMap[NS_rtf::LN_FSIMPLELIST]= "rtf:FSIMPLELIST";
    mMap[NS_rtf::LN_FRESTARTHDN]= "rtf:FRESTARTHDN";
    mMap[NS_rtf::LN_UNSIGNED26_2]= "rtf:UNSIGNED26_2";
    mMap[NS_rtf::LN_ISTARTAT]= "rtf:ISTARTAT";
    mMap[NS_rtf::LN_ILVL]= "rtf:ILVL";
    mMap[NS_rtf::LN_FSTARTAT]= "rtf:FSTARTAT";
    mMap[NS_rtf::LN_FFORMATTING]= "rtf:FFORMATTING";
    mMap[NS_rtf::LN_UNSIGNED4_6]= "rtf:UNSIGNED4_6";
    mMap[NS_rtf::LN_LSID]= "rtf:LSID";
    mMap[NS_rtf::LN_UNUSED4]= "rtf:UNUSED4";
    mMap[NS_rtf::LN_UNUSED8]= "rtf:UNUSED8";
    mMap[NS_rtf::LN_CLFOLVL]= "rtf:CLFOLVL";
    mMap[NS_rtf::LN_CBFFNM1]= "rtf:CBFFNM1";
    mMap[NS_rtf::LN_PRQ]= "rtf:PRQ";
    mMap[NS_rtf::LN_FTRUETYPE]= "rtf:FTRUETYPE";
    mMap[NS_rtf::LN_UNUSED1_3]= "rtf:UNUSED1_3";
    mMap[NS_rtf::LN_FF]= "rtf:FF";
    mMap[NS_rtf::LN_UNUSED1_7]= "rtf:UNUSED1_7";
    mMap[NS_rtf::LN_WWEIGHT]= "rtf:WWEIGHT";
    mMap[NS_rtf::LN_CHS]= "rtf:CHS";
    mMap[NS_rtf::LN_IXCHSZALT]= "rtf:IXCHSZALT";
    mMap[NS_rtf::LN_PANOSE]= "rtf:PANOSE";
    mMap[NS_rtf::LN_FS]= "rtf:FS";
    mMap[NS_rtf::LN_STI]= "rtf:STI";
    mMap[NS_rtf::LN_FSCRATCH]= "rtf:FSCRATCH";
    mMap[NS_rtf::LN_FINVALHEIGHT]= "rtf:FINVALHEIGHT";
    mMap[NS_rtf::LN_FHASUPE]= "rtf:FHASUPE";
    mMap[NS_rtf::LN_FMASSCOPY]= "rtf:FMASSCOPY";
    mMap[NS_rtf::LN_SGC]= "rtf:SGC";
    mMap[NS_rtf::LN_ISTDBASE]= "rtf:ISTDBASE";
    mMap[NS_rtf::LN_CUPX]= "rtf:CUPX";
    mMap[NS_rtf::LN_ISTDNEXT]= "rtf:ISTDNEXT";
    mMap[NS_rtf::LN_BCHUPE]= "rtf:BCHUPE";
    mMap[NS_rtf::LN_FAUTOREDEF]= "rtf:FAUTOREDEF";
    mMap[NS_rtf::LN_FHIDDEN]= "rtf:FHIDDEN";
    mMap[NS_rtf::LN_UNUSED8_3]= "rtf:UNUSED8_3";
    mMap[NS_rtf::LN_CSTD]= "rtf:CSTD";
    mMap[NS_rtf::LN_CSTD]= "rtf:CSTD";
    mMap[NS_rtf::LN_CBSTDBASEINFILE]= "rtf:CBSTDBASEINFILE";
    mMap[NS_rtf::LN_FSTDSTYLENAMESWRITTEN]= "rtf:FSTDSTYLENAMESWRITTEN";
    mMap[NS_rtf::LN_UNUSED4_2]= "rtf:UNUSED4_2";
    mMap[NS_rtf::LN_STIMAXWHENSAVED]= "rtf:STIMAXWHENSAVED";
    mMap[NS_rtf::LN_ISTDMAXFIXEDWHENSAVED]= "rtf:ISTDMAXFIXEDWHENSAVED";
    mMap[NS_rtf::LN_NVERBUILTINNAMESWHENSAVED]= "rtf:NVERBUILTINNAMESWHENSAVED";
    mMap[NS_rtf::LN_RGFTCSTANDARDCHPSTSH]= "rtf:RGFTCSTANDARDCHPSTSH";
    mMap[NS_rtf::LN_WIDENT]= "rtf:WIDENT";
    mMap[NS_rtf::LN_NFIB]= "rtf:NFIB";
    mMap[NS_rtf::LN_NPRODUCT]= "rtf:NPRODUCT";
    mMap[NS_rtf::LN_LID]= "rtf:LID";
    mMap[NS_rtf::LN_PNNEXT]= "rtf:PNNEXT";
    mMap[NS_rtf::LN_FDOT]= "rtf:FDOT";
    mMap[NS_rtf::LN_FGLSY]= "rtf:FGLSY";
    mMap[NS_rtf::LN_FCOMPLEX]= "rtf:FCOMPLEX";
    mMap[NS_rtf::LN_FHASPIC]= "rtf:FHASPIC";
    mMap[NS_rtf::LN_CQUICKSAVES]= "rtf:CQUICKSAVES";
    mMap[NS_rtf::LN_FENCRYPTED]= "rtf:FENCRYPTED";
    mMap[NS_rtf::LN_FWHICHTBLSTM]= "rtf:FWHICHTBLSTM";
    mMap[NS_rtf::LN_FREADONLYRECOMMENDED]= "rtf:FREADONLYRECOMMENDED";
    mMap[NS_rtf::LN_FWRITERESERVATION]= "rtf:FWRITERESERVATION";
    mMap[NS_rtf::LN_FEXTCHAR]= "rtf:FEXTCHAR";
    mMap[NS_rtf::LN_FLOADOVERRIDE]= "rtf:FLOADOVERRIDE";
    mMap[NS_rtf::LN_FFAREAST]= "rtf:FFAREAST";
    mMap[NS_rtf::LN_FCRYPTO]= "rtf:FCRYPTO";
    mMap[NS_rtf::LN_NFIBBACK]= "rtf:NFIBBACK";
    mMap[NS_rtf::LN_LKEY]= "rtf:LKEY";
    mMap[NS_rtf::LN_ENVR]= "rtf:ENVR";
    mMap[NS_rtf::LN_FMAC]= "rtf:FMAC";
    mMap[NS_rtf::LN_FEMPTYSPECIAL]= "rtf:FEMPTYSPECIAL";
    mMap[NS_rtf::LN_FLOADOVERRIDEPAGE]= "rtf:FLOADOVERRIDEPAGE";
    mMap[NS_rtf::LN_FFUTURESAVEDUNDO]= "rtf:FFUTURESAVEDUNDO";
    mMap[NS_rtf::LN_FWORD97SAVED]= "rtf:FWORD97SAVED";
    mMap[NS_rtf::LN_FSPARE0]= "rtf:FSPARE0";
    mMap[NS_rtf::LN_CHS]= "rtf:CHS";
    mMap[NS_rtf::LN_CHSTABLES]= "rtf:CHSTABLES";
    mMap[NS_rtf::LN_FCMIN]= "rtf:FCMIN";
    mMap[NS_rtf::LN_FCMAC]= "rtf:FCMAC";
    mMap[NS_rtf::LN_CSW]= "rtf:CSW";
    mMap[NS_rtf::LN_WMAGICCREATED]= "rtf:WMAGICCREATED";
    mMap[NS_rtf::LN_WMAGICREVISED]= "rtf:WMAGICREVISED";
    mMap[NS_rtf::LN_WMAGICCREATEDPRIVATE]= "rtf:WMAGICCREATEDPRIVATE";
    mMap[NS_rtf::LN_WMAGICREVISEDPRIVATE]= "rtf:WMAGICREVISEDPRIVATE";
    mMap[NS_rtf::LN_PNFBPCHPFIRST_W6]= "rtf:PNFBPCHPFIRST_W6";
    mMap[NS_rtf::LN_PNCHPFIRST_W6]= "rtf:PNCHPFIRST_W6";
    mMap[NS_rtf::LN_CPNBTECHP_W6]= "rtf:CPNBTECHP_W6";
    mMap[NS_rtf::LN_PNFBPPAPFIRST_W6]= "rtf:PNFBPPAPFIRST_W6";
    mMap[NS_rtf::LN_PNPAPFIRST_W6]= "rtf:PNPAPFIRST_W6";
    mMap[NS_rtf::LN_CPNBTEPAP_W6]= "rtf:CPNBTEPAP_W6";
    mMap[NS_rtf::LN_PNFBPLVCFIRST_W6]= "rtf:PNFBPLVCFIRST_W6";
    mMap[NS_rtf::LN_PNLVCFIRST_W6]= "rtf:PNLVCFIRST_W6";
    mMap[NS_rtf::LN_CPNBTELVC_W6]= "rtf:CPNBTELVC_W6";
    mMap[NS_rtf::LN_LIDFE]= "rtf:LIDFE";
    mMap[NS_rtf::LN_CLW]= "rtf:CLW";
    mMap[NS_rtf::LN_CBMAC]= "rtf:CBMAC";
    mMap[NS_rtf::LN_LPRODUCTCREATED]= "rtf:LPRODUCTCREATED";
    mMap[NS_rtf::LN_LPRODUCTREVISED]= "rtf:LPRODUCTREVISED";
    mMap[NS_rtf::LN_CCPTEXT]= "rtf:CCPTEXT";
    mMap[NS_rtf::LN_CCPFTN]= "rtf:CCPFTN";
    mMap[NS_rtf::LN_CCPHDD]= "rtf:CCPHDD";
    mMap[NS_rtf::LN_CCPMCR]= "rtf:CCPMCR";
    mMap[NS_rtf::LN_CCPATN]= "rtf:CCPATN";
    mMap[NS_rtf::LN_CCPEDN]= "rtf:CCPEDN";
    mMap[NS_rtf::LN_CCPTXBX]= "rtf:CCPTXBX";
    mMap[NS_rtf::LN_CCPHDRTXBX]= "rtf:CCPHDRTXBX";
    mMap[NS_rtf::LN_PNFBPCHPFIRST]= "rtf:PNFBPCHPFIRST";
    mMap[NS_rtf::LN_PNCHPFIRST]= "rtf:PNCHPFIRST";
    mMap[NS_rtf::LN_CPNBTECHP]= "rtf:CPNBTECHP";
    mMap[NS_rtf::LN_PNFBPPAPFIRST]= "rtf:PNFBPPAPFIRST";
    mMap[NS_rtf::LN_PNPAPFIRST]= "rtf:PNPAPFIRST";
    mMap[NS_rtf::LN_CPNBTEPAP]= "rtf:CPNBTEPAP";
    mMap[NS_rtf::LN_PNFBPLVCFIRST]= "rtf:PNFBPLVCFIRST";
    mMap[NS_rtf::LN_PNLVCFIRST]= "rtf:PNLVCFIRST";
    mMap[NS_rtf::LN_CPNBTELVC]= "rtf:CPNBTELVC";
    mMap[NS_rtf::LN_FCISLANDFIRST]= "rtf:FCISLANDFIRST";
    mMap[NS_rtf::LN_FCISLANDLIM]= "rtf:FCISLANDLIM";
    mMap[NS_rtf::LN_CFCLCB]= "rtf:CFCLCB";
    mMap[NS_rtf::LN_FCSTSHFORIG]= "rtf:FCSTSHFORIG";
    mMap[NS_rtf::LN_LCBSTSHFORIG]= "rtf:LCBSTSHFORIG";
    mMap[NS_rtf::LN_FCSTSHF]= "rtf:FCSTSHF";
    mMap[NS_rtf::LN_LCBSTSHF]= "rtf:LCBSTSHF";
    mMap[NS_rtf::LN_FCPLCFFNDREF]= "rtf:FCPLCFFNDREF";
    mMap[NS_rtf::LN_LCBPLCFFNDREF]= "rtf:LCBPLCFFNDREF";
    mMap[NS_rtf::LN_FCPLCFFNDTXT]= "rtf:FCPLCFFNDTXT";
    mMap[NS_rtf::LN_LCBPLCFFNDTXT]= "rtf:LCBPLCFFNDTXT";
    mMap[NS_rtf::LN_FCPLCFANDREF]= "rtf:FCPLCFANDREF";
    mMap[NS_rtf::LN_LCBPLCFANDREF]= "rtf:LCBPLCFANDREF";
    mMap[NS_rtf::LN_FCPLCFANDTXT]= "rtf:FCPLCFANDTXT";
    mMap[NS_rtf::LN_LCBPLCFANDTXT]= "rtf:LCBPLCFANDTXT";
    mMap[NS_rtf::LN_FCPLCFSED]= "rtf:FCPLCFSED";
    mMap[NS_rtf::LN_LCBPLCFSED]= "rtf:LCBPLCFSED";
    mMap[NS_rtf::LN_FCPLCFPAD]= "rtf:FCPLCFPAD";
    mMap[NS_rtf::LN_LCBPLCFPAD]= "rtf:LCBPLCFPAD";
    mMap[NS_rtf::LN_FCPLCFPHE]= "rtf:FCPLCFPHE";
    mMap[NS_rtf::LN_LCBPLCFPHE]= "rtf:LCBPLCFPHE";
    mMap[NS_rtf::LN_FCSTTBFGLSY]= "rtf:FCSTTBFGLSY";
    mMap[NS_rtf::LN_LCBSTTBFGLSY]= "rtf:LCBSTTBFGLSY";
    mMap[NS_rtf::LN_FCPLCFGLSY]= "rtf:FCPLCFGLSY";
    mMap[NS_rtf::LN_LCBPLCFGLSY]= "rtf:LCBPLCFGLSY";
    mMap[NS_rtf::LN_FCPLCFHDD]= "rtf:FCPLCFHDD";
    mMap[NS_rtf::LN_LCBPLCFHDD]= "rtf:LCBPLCFHDD";
    mMap[NS_rtf::LN_FCPLCFBTECHPX]= "rtf:FCPLCFBTECHPX";
    mMap[NS_rtf::LN_LCBPLCFBTECHPX]= "rtf:LCBPLCFBTECHPX";
    mMap[NS_rtf::LN_FCPLCFBTEPAPX]= "rtf:FCPLCFBTEPAPX";
    mMap[NS_rtf::LN_LCBPLCFBTEPAPX]= "rtf:LCBPLCFBTEPAPX";
    mMap[NS_rtf::LN_FCPLCFSEA]= "rtf:FCPLCFSEA";
    mMap[NS_rtf::LN_LCBPLCFSEA]= "rtf:LCBPLCFSEA";
    mMap[NS_rtf::LN_FCSTTBFFFN]= "rtf:FCSTTBFFFN";
    mMap[NS_rtf::LN_LCBSTTBFFFN]= "rtf:LCBSTTBFFFN";
    mMap[NS_rtf::LN_FCPLCFFLDMOM]= "rtf:FCPLCFFLDMOM";
    mMap[NS_rtf::LN_LCBPLCFFLDMOM]= "rtf:LCBPLCFFLDMOM";
    mMap[NS_rtf::LN_FCPLCFFLDHDR]= "rtf:FCPLCFFLDHDR";
    mMap[NS_rtf::LN_LCBPLCFFLDHDR]= "rtf:LCBPLCFFLDHDR";
    mMap[NS_rtf::LN_FCPLCFFLDFTN]= "rtf:FCPLCFFLDFTN";
    mMap[NS_rtf::LN_LCBPLCFFLDFTN]= "rtf:LCBPLCFFLDFTN";
    mMap[NS_rtf::LN_FCPLCFFLDATN]= "rtf:FCPLCFFLDATN";
    mMap[NS_rtf::LN_LCBPLCFFLDATN]= "rtf:LCBPLCFFLDATN";
    mMap[NS_rtf::LN_FCPLCFFLDMCR]= "rtf:FCPLCFFLDMCR";
    mMap[NS_rtf::LN_LCBPLCFFLDMCR]= "rtf:LCBPLCFFLDMCR";
    mMap[NS_rtf::LN_FCSTTBFBKMK]= "rtf:FCSTTBFBKMK";
    mMap[NS_rtf::LN_LCBSTTBFBKMK]= "rtf:LCBSTTBFBKMK";
    mMap[NS_rtf::LN_FCPLCFBKF]= "rtf:FCPLCFBKF";
    mMap[NS_rtf::LN_LCBPLCFBKF]= "rtf:LCBPLCFBKF";
    mMap[NS_rtf::LN_FCPLCFBKL]= "rtf:FCPLCFBKL";
    mMap[NS_rtf::LN_LCBPLCFBKL]= "rtf:LCBPLCFBKL";
    mMap[NS_rtf::LN_FCCMDS]= "rtf:FCCMDS";
    mMap[NS_rtf::LN_LCBCMDS]= "rtf:LCBCMDS";
    mMap[NS_rtf::LN_FCPLCMCR]= "rtf:FCPLCMCR";
    mMap[NS_rtf::LN_LCBPLCMCR]= "rtf:LCBPLCMCR";
    mMap[NS_rtf::LN_FCSTTBFMCR]= "rtf:FCSTTBFMCR";
    mMap[NS_rtf::LN_LCBSTTBFMCR]= "rtf:LCBSTTBFMCR";
    mMap[NS_rtf::LN_FCPRDRVR]= "rtf:FCPRDRVR";
    mMap[NS_rtf::LN_LCBPRDRVR]= "rtf:LCBPRDRVR";
    mMap[NS_rtf::LN_FCPRENVPORT]= "rtf:FCPRENVPORT";
    mMap[NS_rtf::LN_LCBPRENVPORT]= "rtf:LCBPRENVPORT";
    mMap[NS_rtf::LN_FCPRENVLAND]= "rtf:FCPRENVLAND";
    mMap[NS_rtf::LN_LCBPRENVLAND]= "rtf:LCBPRENVLAND";
    mMap[NS_rtf::LN_FCWSS]= "rtf:FCWSS";
    mMap[NS_rtf::LN_LCBWSS]= "rtf:LCBWSS";
    mMap[NS_rtf::LN_FCDOP]= "rtf:FCDOP";
    mMap[NS_rtf::LN_LCBDOP]= "rtf:LCBDOP";
    mMap[NS_rtf::LN_FCSTTBFASSOC]= "rtf:FCSTTBFASSOC";
    mMap[NS_rtf::LN_LCBSTTBFASSOC]= "rtf:LCBSTTBFASSOC";
    mMap[NS_rtf::LN_FCCLX]= "rtf:FCCLX";
    mMap[NS_rtf::LN_LCBCLX]= "rtf:LCBCLX";
    mMap[NS_rtf::LN_FCPLCFPGDFTN]= "rtf:FCPLCFPGDFTN";
    mMap[NS_rtf::LN_LCBPLCFPGDFTN]= "rtf:LCBPLCFPGDFTN";
    mMap[NS_rtf::LN_FCAUTOSAVESOURCE]= "rtf:FCAUTOSAVESOURCE";
    mMap[NS_rtf::LN_LCBAUTOSAVESOURCE]= "rtf:LCBAUTOSAVESOURCE";
    mMap[NS_rtf::LN_FCGRPXSTATNOWNERS]= "rtf:FCGRPXSTATNOWNERS";
    mMap[NS_rtf::LN_LCBGRPXSTATNOWNERS]= "rtf:LCBGRPXSTATNOWNERS";
    mMap[NS_rtf::LN_FCSTTBFATNBKMK]= "rtf:FCSTTBFATNBKMK";
    mMap[NS_rtf::LN_LCBSTTBFATNBKMK]= "rtf:LCBSTTBFATNBKMK";
    mMap[NS_rtf::LN_FCPLCDOAMOM]= "rtf:FCPLCDOAMOM";
    mMap[NS_rtf::LN_LCBPLCDOAMOM]= "rtf:LCBPLCDOAMOM";
    mMap[NS_rtf::LN_FCPLCDOAHDR]= "rtf:FCPLCDOAHDR";
    mMap[NS_rtf::LN_LCBPLCDOAHDR]= "rtf:LCBPLCDOAHDR";
    mMap[NS_rtf::LN_FCPLCSPAMOM]= "rtf:FCPLCSPAMOM";
    mMap[NS_rtf::LN_LCBPLCSPAMOM]= "rtf:LCBPLCSPAMOM";
    mMap[NS_rtf::LN_FCPLCSPAHDR]= "rtf:FCPLCSPAHDR";
    mMap[NS_rtf::LN_LCBPLCSPAHDR]= "rtf:LCBPLCSPAHDR";
    mMap[NS_rtf::LN_FCPLCFATNBKF]= "rtf:FCPLCFATNBKF";
    mMap[NS_rtf::LN_LCBPLCFATNBKF]= "rtf:LCBPLCFATNBKF";
    mMap[NS_rtf::LN_FCPLCFATNBKL]= "rtf:FCPLCFATNBKL";
    mMap[NS_rtf::LN_LCBPLCFATNBKL]= "rtf:LCBPLCFATNBKL";
    mMap[NS_rtf::LN_FCPMS]= "rtf:FCPMS";
    mMap[NS_rtf::LN_LCBPMS]= "rtf:LCBPMS";
    mMap[NS_rtf::LN_FCFORMFLDSTTBF]= "rtf:FCFORMFLDSTTBF";
    mMap[NS_rtf::LN_LCBFORMFLDSTTBF]= "rtf:LCBFORMFLDSTTBF";
    mMap[NS_rtf::LN_FCPLCFENDREF]= "rtf:FCPLCFENDREF";
    mMap[NS_rtf::LN_LCBPLCFENDREF]= "rtf:LCBPLCFENDREF";
    mMap[NS_rtf::LN_FCPLCFENDTXT]= "rtf:FCPLCFENDTXT";
    mMap[NS_rtf::LN_LCBPLCFENDTXT]= "rtf:LCBPLCFENDTXT";
    mMap[NS_rtf::LN_FCPLCFFLDEDN]= "rtf:FCPLCFFLDEDN";
    mMap[NS_rtf::LN_LCBPLCFFLDEDN]= "rtf:LCBPLCFFLDEDN";
    mMap[NS_rtf::LN_FCPLCFPGDEDN]= "rtf:FCPLCFPGDEDN";
    mMap[NS_rtf::LN_LCBPLCFPGDEDN]= "rtf:LCBPLCFPGDEDN";
    mMap[NS_rtf::LN_FCDGGINFO]= "rtf:FCDGGINFO";
    mMap[NS_rtf::LN_LCBDGGINFO]= "rtf:LCBDGGINFO";
    mMap[NS_rtf::LN_FCSTTBFRMARK]= "rtf:FCSTTBFRMARK";
    mMap[NS_rtf::LN_LCBSTTBFRMARK]= "rtf:LCBSTTBFRMARK";
    mMap[NS_rtf::LN_FCSTTBFCAPTION]= "rtf:FCSTTBFCAPTION";
    mMap[NS_rtf::LN_LCBSTTBFCAPTION]= "rtf:LCBSTTBFCAPTION";
    mMap[NS_rtf::LN_FCSTTBFAUTOCAPTION]= "rtf:FCSTTBFAUTOCAPTION";
    mMap[NS_rtf::LN_LCBSTTBFAUTOCAPTION]= "rtf:LCBSTTBFAUTOCAPTION";
    mMap[NS_rtf::LN_FCPLCFWKB]= "rtf:FCPLCFWKB";
    mMap[NS_rtf::LN_LCBPLCFWKB]= "rtf:LCBPLCFWKB";
    mMap[NS_rtf::LN_FCPLCFSPL]= "rtf:FCPLCFSPL";
    mMap[NS_rtf::LN_LCBPLCFSPL]= "rtf:LCBPLCFSPL";
    mMap[NS_rtf::LN_FCPLCFTXBXTXT]= "rtf:FCPLCFTXBXTXT";
    mMap[NS_rtf::LN_LCBPLCFTXBXTXT]= "rtf:LCBPLCFTXBXTXT";
    mMap[NS_rtf::LN_FCPLCFFLDTXBX]= "rtf:FCPLCFFLDTXBX";
    mMap[NS_rtf::LN_LCBPLCFFLDTXBX]= "rtf:LCBPLCFFLDTXBX";
    mMap[NS_rtf::LN_FCPLCFHDRTXBXTXT]= "rtf:FCPLCFHDRTXBXTXT";
    mMap[NS_rtf::LN_LCBPLCFHDRTXBXTXT]= "rtf:LCBPLCFHDRTXBXTXT";
    mMap[NS_rtf::LN_FCPLCFFLDHDRTXBX]= "rtf:FCPLCFFLDHDRTXBX";
    mMap[NS_rtf::LN_LCBPLCFFLDHDRTXBX]= "rtf:LCBPLCFFLDHDRTXBX";
    mMap[NS_rtf::LN_FCSTWUSER]= "rtf:FCSTWUSER";
    mMap[NS_rtf::LN_LCBSTWUSER]= "rtf:LCBSTWUSER";
    mMap[NS_rtf::LN_FCSTTBTTMBD]= "rtf:FCSTTBTTMBD";
    mMap[NS_rtf::LN_LCBSTTBTTMBD]= "rtf:LCBSTTBTTMBD";
    mMap[NS_rtf::LN_FCUNUSED]= "rtf:FCUNUSED";
    mMap[NS_rtf::LN_LCBUNUSED]= "rtf:LCBUNUSED";
    mMap[NS_rtf::LN_FCPGDMOTHER]= "rtf:FCPGDMOTHER";
    mMap[NS_rtf::LN_LCBPGDMOTHER]= "rtf:LCBPGDMOTHER";
    mMap[NS_rtf::LN_FCBKDMOTHER]= "rtf:FCBKDMOTHER";
    mMap[NS_rtf::LN_LCBBKDMOTHER]= "rtf:LCBBKDMOTHER";
    mMap[NS_rtf::LN_FCPGDFTN]= "rtf:FCPGDFTN";
    mMap[NS_rtf::LN_LCBPGDFTN]= "rtf:LCBPGDFTN";
    mMap[NS_rtf::LN_FCBKDFTN]= "rtf:FCBKDFTN";
    mMap[NS_rtf::LN_LCBBKDFTN]= "rtf:LCBBKDFTN";
    mMap[NS_rtf::LN_FCPGDEDN]= "rtf:FCPGDEDN";
    mMap[NS_rtf::LN_LCBPGDEDN]= "rtf:LCBPGDEDN";
    mMap[NS_rtf::LN_FCBKDEDN]= "rtf:FCBKDEDN";
    mMap[NS_rtf::LN_LCBBKDEDN]= "rtf:LCBBKDEDN";
    mMap[NS_rtf::LN_FCSTTBFINTLFLD]= "rtf:FCSTTBFINTLFLD";
    mMap[NS_rtf::LN_LCBSTTBFINTLFLD]= "rtf:LCBSTTBFINTLFLD";
    mMap[NS_rtf::LN_FCROUTESLIP]= "rtf:FCROUTESLIP";
    mMap[NS_rtf::LN_LCBROUTESLIP]= "rtf:LCBROUTESLIP";
    mMap[NS_rtf::LN_FCSTTBSAVEDBY]= "rtf:FCSTTBSAVEDBY";
    mMap[NS_rtf::LN_LCBSTTBSAVEDBY]= "rtf:LCBSTTBSAVEDBY";
    mMap[NS_rtf::LN_FCSTTBFNM]= "rtf:FCSTTBFNM";
    mMap[NS_rtf::LN_LCBSTTBFNM]= "rtf:LCBSTTBFNM";
    mMap[NS_rtf::LN_FCPLCFLST]= "rtf:FCPLCFLST";
    mMap[NS_rtf::LN_LCBPLCFLST]= "rtf:LCBPLCFLST";
    mMap[NS_rtf::LN_FCPLFLFO]= "rtf:FCPLFLFO";
    mMap[NS_rtf::LN_LCBPLFLFO]= "rtf:LCBPLFLFO";
    mMap[NS_rtf::LN_FCPLCFTXBXBKD]= "rtf:FCPLCFTXBXBKD";
    mMap[NS_rtf::LN_LCBPLCFTXBXBKD]= "rtf:LCBPLCFTXBXBKD";
    mMap[NS_rtf::LN_FCPLCFTXBXHDRBKD]= "rtf:FCPLCFTXBXHDRBKD";
    mMap[NS_rtf::LN_LCBPLCFTXBXHDRBKD]= "rtf:LCBPLCFTXBXHDRBKD";
    mMap[NS_rtf::LN_FCDOCUNDO]= "rtf:FCDOCUNDO";
    mMap[NS_rtf::LN_LCBDOCUNDO]= "rtf:LCBDOCUNDO";
    mMap[NS_rtf::LN_FCRGBUSE]= "rtf:FCRGBUSE";
    mMap[NS_rtf::LN_LCBRGBUSE]= "rtf:LCBRGBUSE";
    mMap[NS_rtf::LN_FCUSP]= "rtf:FCUSP";
    mMap[NS_rtf::LN_LCBUSP]= "rtf:LCBUSP";
    mMap[NS_rtf::LN_FCUSKF]= "rtf:FCUSKF";
    mMap[NS_rtf::LN_LCBUSKF]= "rtf:LCBUSKF";
    mMap[NS_rtf::LN_FCPLCUPCRGBUSE]= "rtf:FCPLCUPCRGBUSE";
    mMap[NS_rtf::LN_LCBPLCUPCRGBUSE]= "rtf:LCBPLCUPCRGBUSE";
    mMap[NS_rtf::LN_FCPLCUPCUSP]= "rtf:FCPLCUPCUSP";
    mMap[NS_rtf::LN_LCBPLCUPCUSP]= "rtf:LCBPLCUPCUSP";
    mMap[NS_rtf::LN_FCSTTBGLSYSTYLE]= "rtf:FCSTTBGLSYSTYLE";
    mMap[NS_rtf::LN_LCBSTTBGLSYSTYLE]= "rtf:LCBSTTBGLSYSTYLE";
    mMap[NS_rtf::LN_FCPLGOSL]= "rtf:FCPLGOSL";
    mMap[NS_rtf::LN_LCBPLGOSL]= "rtf:LCBPLGOSL";
    mMap[NS_rtf::LN_FCPLCOCX]= "rtf:FCPLCOCX";
    mMap[NS_rtf::LN_LCBPLCOCX]= "rtf:LCBPLCOCX";
    mMap[NS_rtf::LN_FCPLCFBTELVC]= "rtf:FCPLCFBTELVC";
    mMap[NS_rtf::LN_LCBPLCFBTELVC]= "rtf:LCBPLCFBTELVC";
    mMap[NS_rtf::LN_DWLOWDATETIME]= "rtf:DWLOWDATETIME";
    mMap[NS_rtf::LN_DWHIGHDATETIME]= "rtf:DWHIGHDATETIME";
    mMap[NS_rtf::LN_FCPLCFLVC]= "rtf:FCPLCFLVC";
    mMap[NS_rtf::LN_LCBPLCFLVC]= "rtf:LCBPLCFLVC";
    mMap[NS_rtf::LN_FCPLCASUMY]= "rtf:FCPLCASUMY";
    mMap[NS_rtf::LN_LCBPLCASUMY]= "rtf:LCBPLCASUMY";
    mMap[NS_rtf::LN_FCPLCFGRAM]= "rtf:FCPLCFGRAM";
    mMap[NS_rtf::LN_LCBPLCFGRAM]= "rtf:LCBPLCFGRAM";
    mMap[NS_rtf::LN_FCSTTBLISTNAMES]= "rtf:FCSTTBLISTNAMES";
    mMap[NS_rtf::LN_LCBSTTBLISTNAMES]= "rtf:LCBSTTBLISTNAMES";
    mMap[NS_rtf::LN_FCSTTBFUSSR]= "rtf:FCSTTBFUSSR";
    mMap[NS_rtf::LN_LCBSTTBFUSSR]= "rtf:LCBSTTBFUSSR";
    mMap[NS_rtf::LN_IBKL]= "rtf:IBKL";
    mMap[NS_rtf::LN_ITCFIRST]= "rtf:ITCFIRST";
    mMap[NS_rtf::LN_FPUB]= "rtf:FPUB";
    mMap[NS_rtf::LN_ITCLIM]= "rtf:ITCLIM";
    mMap[NS_rtf::LN_FCOL]= "rtf:FCOL";
    mMap[NS_rtf::LN_FN]= "rtf:FN";
    mMap[NS_rtf::LN_FCSEPX]= "rtf:FCSEPX";
    mMap[NS_rtf::LN_FNMPR]= "rtf:FNMPR";
    mMap[NS_rtf::LN_FCMPR]= "rtf:FCMPR";
    mMap[NS_rtf::LN_ICOFORE]= "rtf:ICOFORE";
    mMap[NS_rtf::LN_ICOBACK]= "rtf:ICOBACK";
    mMap[NS_rtf::LN_IPAT]= "rtf:IPAT";
    mMap[NS_rtf::LN_SHDFORECOLOR]= "rtf:SHDFORECOLOR";
    mMap[NS_rtf::LN_SHDBACKCOLOR]= "rtf:SHDBACKCOLOR";
    mMap[NS_rtf::LN_SHDPATTERN]= "rtf:SHDPATTERN";
    mMap[NS_rtf::LN_DPTLINEWIDTH]= "rtf:DPTLINEWIDTH";
    mMap[NS_rtf::LN_BRCTYPE]= "rtf:BRCTYPE";
    mMap[NS_rtf::LN_ICO]= "rtf:ICO";
    mMap[NS_rtf::LN_DPTSPACE]= "rtf:DPTSPACE";
    mMap[NS_rtf::LN_FSHADOW]= "rtf:FSHADOW";
    mMap[NS_rtf::LN_FFRAME]= "rtf:FFRAME";
    mMap[NS_rtf::LN_UNUSED2_15]= "rtf:UNUSED2_15";
    mMap[NS_rtf::LN_FFIRSTMERGED]= "rtf:FFIRSTMERGED";
    mMap[NS_rtf::LN_FMERGED]= "rtf:FMERGED";
    mMap[NS_rtf::LN_FVERTICAL]= "rtf:FVERTICAL";
    mMap[NS_rtf::LN_FBACKWARD]= "rtf:FBACKWARD";
    mMap[NS_rtf::LN_FROTATEFONT]= "rtf:FROTATEFONT";
    mMap[NS_rtf::LN_FVERTMERGE]= "rtf:FVERTMERGE";
    mMap[NS_rtf::LN_FVERTRESTART]= "rtf:FVERTRESTART";
    mMap[NS_rtf::LN_VERTALIGN]= "rtf:VERTALIGN";
    mMap[NS_rtf::LN_FUNUSED]= "rtf:FUNUSED";
    mMap[NS_rtf::LN_CellPrefferedSize]= "rtf:CellPrefferedSize";
    mMap[NS_rtf::LN_BRCTOP]= "rtf:BRCTOP";
    mMap[NS_rtf::LN_BRCLEFT]= "rtf:BRCLEFT";
    mMap[NS_rtf::LN_BRCBOTTOM]= "rtf:BRCBOTTOM";
    mMap[NS_rtf::LN_BRCRIGHT]= "rtf:BRCRIGHT";
    mMap[NS_rtf::LN_IBKL]= "rtf:IBKL";
    mMap[NS_rtf::LN_ITCFIRST]= "rtf:ITCFIRST";
    mMap[NS_rtf::LN_FPUB]= "rtf:FPUB";
    mMap[NS_rtf::LN_ITCLIM]= "rtf:ITCLIM";
    mMap[NS_rtf::LN_FCOL]= "rtf:FCOL";
    mMap[NS_rtf::LN_LINECOLOR]= "rtf:LINECOLOR";
    mMap[NS_rtf::LN_LINEWIDTH]= "rtf:LINEWIDTH";
    mMap[NS_rtf::LN_LINETYPE]= "rtf:LINETYPE";
    mMap[NS_rtf::LN_JC]= "rtf:JC";
    mMap[NS_rtf::LN_TLC]= "rtf:TLC";
    mMap[NS_rtf::LN_UNUSED0_6]= "rtf:UNUSED0_6";
    mMap[NS_rtf::LN_MM]= "rtf:MM";
    mMap[NS_rtf::LN_XEXT]= "rtf:XEXT";
    mMap[NS_rtf::LN_YEXT]= "rtf:YEXT";
    mMap[NS_rtf::LN_HMF]= "rtf:HMF";
    mMap[NS_rtf::LN_unknown]= "rtf:unknown";
    mMap[NS_rtf::LN_dropdownIndex]= "rtf:dropdownIndex";
    mMap[NS_rtf::LN_tooltip]= "rtf:tooltip";
    mMap[NS_rtf::LN_nomark]= "rtf:nomark";
    mMap[NS_rtf::LN_useSize]= "rtf:useSize";
    mMap[NS_rtf::LN_numbersOnly]= "rtf:numbersOnly";
    mMap[NS_rtf::LN_dateOnly]= "rtf:dateOnly";
    mMap[NS_rtf::LN_unused]= "rtf:unused";
    mMap[NS_rtf::LN_size]= "rtf:size";
    mMap[NS_rtf::LN_hpsCheckbox]= "rtf:hpsCheckbox";
    mMap[NS_rtf::LN_fftitle]= "rtf:fftitle";
    mMap[NS_rtf::LN_LCB]= "rtf:LCB";
    mMap[NS_rtf::LN_CBHEADER]= "rtf:CBHEADER";
    mMap[NS_rtf::LN_MFP]= "rtf:MFP";
    mMap[NS_rtf::LN_BM_RCWINMF]= "rtf:BM_RCWINMF";
    mMap[NS_rtf::LN_DXAGOAL]= "rtf:DXAGOAL";
    mMap[NS_rtf::LN_DYAGOAL]= "rtf:DYAGOAL";
    mMap[NS_rtf::LN_MX]= "rtf:MX";
    mMap[NS_rtf::LN_MY]= "rtf:MY";
    mMap[NS_rtf::LN_DXACROPLEFT]= "rtf:DXACROPLEFT";
    mMap[NS_rtf::LN_DYACROPTOP]= "rtf:DYACROPTOP";
    mMap[NS_rtf::LN_DXACROPRIGHT]= "rtf:DXACROPRIGHT";
    mMap[NS_rtf::LN_DYACROPBOTTOM]= "rtf:DYACROPBOTTOM";
    mMap[NS_rtf::LN_BRCL]= "rtf:BRCL";
    mMap[NS_rtf::LN_FFRAMEEMPTY]= "rtf:FFRAMEEMPTY";
    mMap[NS_rtf::LN_FBITMAP]= "rtf:FBITMAP";
    mMap[NS_rtf::LN_FDRAWHATCH]= "rtf:FDRAWHATCH";
    mMap[NS_rtf::LN_FERROR]= "rtf:FERROR";
    mMap[NS_rtf::LN_BPP]= "rtf:BPP";
    mMap[NS_rtf::LN_BRCTOP]= "rtf:BRCTOP";
    mMap[NS_rtf::LN_BRCLEFT]= "rtf:BRCLEFT";
    mMap[NS_rtf::LN_BRCBOTTOM]= "rtf:BRCBOTTOM";
    mMap[NS_rtf::LN_BRCRIGHT]= "rtf:BRCRIGHT";
    mMap[NS_rtf::LN_DXAORIGIN]= "rtf:DXAORIGIN";
    mMap[NS_rtf::LN_DYAORIGIN]= "rtf:DYAORIGIN";
    mMap[NS_rtf::LN_CPROPS]= "rtf:CPROPS";
    mMap[NS_rtf::LN_SPID]= "rtf:SPID";
    mMap[NS_rtf::LN_XALEFT]= "rtf:XALEFT";
    mMap[NS_rtf::LN_YATOP]= "rtf:YATOP";
    mMap[NS_rtf::LN_XARIGHT]= "rtf:XARIGHT";
    mMap[NS_rtf::LN_YABOTTOM]= "rtf:YABOTTOM";
    mMap[NS_rtf::LN_FHDR]= "rtf:FHDR";
    mMap[NS_rtf::LN_BX]= "rtf:BX";
    mMap[NS_rtf::LN_BY]= "rtf:BY";
    mMap[NS_rtf::LN_WR]= "rtf:WR";
    mMap[NS_rtf::LN_WRK]= "rtf:WRK";
    mMap[NS_rtf::LN_FRCASIMPLE]= "rtf:FRCASIMPLE";
    mMap[NS_rtf::LN_FBELOWTEXT]= "rtf:FBELOWTEXT";
    mMap[NS_rtf::LN_FANCHORLOCK]= "rtf:FANCHORLOCK";
    mMap[NS_rtf::LN_CTXBX]= "rtf:CTXBX";
    mMap[NS_rtf::LN_CH]= "rtf:CH";
    mMap[NS_rtf::LN_UNUSED0_5]= "rtf:UNUSED0_5";
    mMap[NS_rtf::LN_FLT]= "rtf:FLT";
    mMap[NS_rtf::LN_shpLeft]= "rtf:shpLeft";
    mMap[NS_rtf::LN_shpTop]= "rtf:shpTop";
    mMap[NS_rtf::LN_shpRight]= "rtf:shpRight";
    mMap[NS_rtf::LN_shpBottom]= "rtf:shpBottom";
    mMap[NS_rtf::LN_shppid]= "rtf:shppid";
    mMap[NS_rtf::LN_shpfBid]= "rtf:shpfBid";
    mMap[NS_rtf::LN_shpfComplex]= "rtf:shpfComplex";
    mMap[NS_rtf::LN_shpop]= "rtf:shpop";
    mMap[NS_rtf::LN_shpspidMax]= "rtf:shpspidMax";
    mMap[NS_rtf::LN_shpcidcl]= "rtf:shpcidcl";
    mMap[NS_rtf::LN_shpcspSaved]= "rtf:shpcspSaved";
    mMap[NS_rtf::LN_shpcdgSaved]= "rtf:shpcdgSaved";
    mMap[NS_rtf::LN_shpdgid]= "rtf:shpdgid";
    mMap[NS_rtf::LN_shpcspidCur]= "rtf:shpcspidCur";
    mMap[NS_rtf::LN_shpbtWin32]= "rtf:shpbtWin32";
    mMap[NS_rtf::LN_shpbtMacOS]= "rtf:shpbtMacOS";
    mMap[NS_rtf::LN_shprgbUid]= "rtf:shprgbUid";
    mMap[NS_rtf::LN_shptag]= "rtf:shptag";
    mMap[NS_rtf::LN_shpsize]= "rtf:shpsize";
    mMap[NS_rtf::LN_shpcRef]= "rtf:shpcRef";
    mMap[NS_rtf::LN_shpfoDelay]= "rtf:shpfoDelay";
    mMap[NS_rtf::LN_shpusage]= "rtf:shpusage";
    mMap[NS_rtf::LN_shpcbName]= "rtf:shpcbName";
    mMap[NS_rtf::LN_shpunused2]= "rtf:shpunused2";
    mMap[NS_rtf::LN_shpunused3]= "rtf:shpunused3";
    mMap[NS_rtf::LN_FRD]= "rtf:FRD";
    mMap[NS_rtf::LN_IBST]= "rtf:IBST";
    mMap[NS_rtf::LN_AK]= "rtf:AK";
    mMap[NS_rtf::LN_UNUSED22_2]= "rtf:UNUSED22_2";
    mMap[NS_rtf::LN_GRFBMC]= "rtf:GRFBMC";
    mMap[NS_rtf::LN_LTAGBKMK]= "rtf:LTAGBKMK";
    mMap[NS_rtf::LN_CTXBX]= "rtf:CTXBX";
    mMap[NS_rtf::LN_INEXTREUSE]= "rtf:INEXTREUSE";
    mMap[NS_rtf::LN_CREUSABLE]= "rtf:CREUSABLE";
    mMap[NS_rtf::LN_FREUSABLE]= "rtf:FREUSABLE";
    mMap[NS_rtf::LN_LID]= "rtf:LID";
    mMap[NS_rtf::LN_TXIDUNDO]= "rtf:TXIDUNDO";
    mMap[NS_rtf::LN_fcPic]= "rtf:fcPic";
    mMap[NS_rtf::LN_FONT]= "rtf:FONT";
    mMap[NS_rtf::LN_CHAR]= "rtf:CHAR";
    mMap[NS_rtf::LN_LINEPROPSTOP]= "rtf:LINEPROPSTOP";
    mMap[NS_rtf::LN_LINEPROPSLEFT]= "rtf:LINEPROPSLEFT";
    mMap[NS_rtf::LN_LINEPROPSBOTTOM]= "rtf:LINEPROPSBOTTOM";
    mMap[NS_rtf::LN_LINEPROPSRIGHT]= "rtf:LINEPROPSRIGHT";
    mMap[NS_rtf::LN_LINEPROPSHORIZONTAL]= "rtf:LINEPROPSHORIZONTAL";
    mMap[NS_rtf::LN_LINEPROPSVERTICAL]= "rtf:LINEPROPSVERTICAL";
    mMap[NS_rtf::LN_BRCTOP]= "rtf:BRCTOP";
    mMap[NS_rtf::LN_BRCLEFT]= "rtf:BRCLEFT";
    mMap[NS_rtf::LN_BRCLEFT]= "rtf:BRCLEFT";
    mMap[NS_rtf::LN_BRCRIGHT]= "rtf:BRCRIGHT";
    mMap[NS_rtf::LN_BRCBETWEEN]= "rtf:BRCBETWEEN";
    mMap[NS_rtf::LN_LINEPROPSTOP]= "rtf:LINEPROPSTOP";
    mMap[NS_rtf::LN_LINEPROPSLEFT]= "rtf:LINEPROPSLEFT";
    mMap[NS_rtf::LN_LINEPROPSBOTTOM]= "rtf:LINEPROPSBOTTOM";
    mMap[NS_rtf::LN_LINEPROPSRIGHT]= "rtf:LINEPROPSRIGHT";
    mMap[NS_rtf::LN_LINEPROPSBETWEEN]= "rtf:LINEPROPSBETWEEN";
    mMap[NS_rtf::LN_LINEPROPS]= "rtf:LINEPROPS";
    mMap[NS_rtf::LN_unit]= "rtf:unit";
    mMap[NS_rtf::LN_preferredWidth]= "rtf:preferredWidth";
    mMap[NS_rtf::LN_unit]= "rtf:unit";
    mMap[NS_rtf::LN_trleft]= "rtf:trleft";
    mMap[NS_rtf::LN_fcEastAsianLayout]= "rtf:fcEastAsianLayout";
    mMap[NS_rtf::LN_rectangle]= "rtf:rectangle";
    mMap[NS_rtf::LN_shptype]= "rtf:shptype";
    mMap[NS_rtf::LN_shpid]= "rtf:shpid";
    mMap[NS_rtf::LN_shpfGroup]= "rtf:shpfGroup";
    mMap[NS_rtf::LN_shpfChild]= "rtf:shpfChild";
    mMap[NS_rtf::LN_shpfPatriarch]= "rtf:shpfPatriarch";
    mMap[NS_rtf::LN_shpfDeleted]= "rtf:shpfDeleted";
    mMap[NS_rtf::LN_shpfOleShape]= "rtf:shpfOleShape";
    mMap[NS_rtf::LN_shpfHaveMaster]= "rtf:shpfHaveMaster";
    mMap[NS_rtf::LN_shpfFlipH]= "rtf:shpfFlipH";
    mMap[NS_rtf::LN_shpfFlipV]= "rtf:shpfFlipV";
    mMap[NS_rtf::LN_shpfConnector]= "rtf:shpfConnector";
    mMap[NS_rtf::LN_shpfHaveAnchor]= "rtf:shpfHaveAnchor";
    mMap[NS_rtf::LN_shpfBackground]= "rtf:shpfBackground";
    mMap[NS_rtf::LN_shpfHaveSpt]= "rtf:shpfHaveSpt";
    mMap[NS_rtf::LN_shpdgg]= "rtf:shpdgg";
    mMap[NS_rtf::LN_shpfbse]= "rtf:shpfbse";
    mMap[NS_rtf::LN_payload]= "rtf:payload";
    mMap[NS_rtf::LN_payload]= "rtf:payload";
    mMap[NS_rtf::LN_csp]= "rtf:csp";
    mMap[NS_rtf::LN_spidCur]= "rtf:spidCur";
    mMap[NS_rtf::LN_fdg]= "rtf:fdg";

        /* Operations */
    mMap[NS_rtf::LN_LISTLEVEL] = "rtf:LISTLEVEL";
    mMap[NS_rtf::LN_LFO] = "rtf:LFO";
    mMap[NS_rtf::LN_F] = "rtf:F";
    mMap[NS_rtf::LN_ALTFONTNAME] = "rtf:ALTFONTNAME";
    mMap[NS_rtf::LN_XSZFFN] = "rtf:XSZFFN";
    mMap[NS_rtf::LN_XSTZNAME] = "rtf:XSTZNAME";
    mMap[NS_rtf::LN_XSTZNAME1] = "rtf:XSTZNAME1";
    mMap[NS_rtf::LN_UPXSTART] = "rtf:UPXSTART";
    mMap[NS_rtf::LN_UPX] = "rtf:UPX";
    mMap[NS_rtf::LN_sed] = "rtf:sed";
    mMap[NS_rtf::LN_FLT] = "rtf:FLT";
    mMap[NS_rtf::LN_ffdefault] = "rtf:ffdefault";
    mMap[NS_rtf::LN_ffchecked] = "rtf:ffchecked";
    mMap[NS_rtf::LN_ffformatting] = "rtf:ffformatting";
    mMap[NS_rtf::LN_ffhelp] = "rtf:ffhelp";
    mMap[NS_rtf::LN_fftooltip] = "rtf:fftooltip";
    mMap[NS_rtf::LN_DffRecord] = "rtf:DffRecord";
    mMap[NS_rtf::LN_ffdata] = "rtf:ffdata";
    mMap[NS_rtf::LN_shape] = "rtf:shape";
    mMap[NS_rtf::LN_shpname] = "rtf:shpname";
    mMap[NS_rtf::LN_shpvalue] = "rtf:shpvalue";
    mMap[NS_rtf::LN_shpstringvalue] = "rtf:shpstringvalue";
    mMap[NS_rtf::LN_xstUsrInitl] = "rtf:xstUsrInitl";
    mMap[NS_rtf::LN_dxaDel] = "rtf:dxaDel";
    mMap[NS_rtf::LN_dxaAdd] = "rtf:dxaAdd";
    mMap[NS_rtf::LN_tbdAdd] = "rtf:tbdAdd";
    mMap[NS_rtf::LN_rgbrc] = "rtf:rgbrc";
    mMap[NS_rtf::LN_cellx] = "rtf:cellx";
    mMap[NS_rtf::LN_tc] = "rtf:tc";
    mMap[NS_rtf::LN_shd] = "rtf:shd";
    mMap[NS_rtf::LN_cellShd] = "rtf:cellShd";
    mMap[NS_rtf::LN_cellTopColor] = "rtf:cellTopColor";
    mMap[NS_rtf::LN_cellLeftColor] = "rtf:cellLeftColor";
    mMap[NS_rtf::LN_cellBottomColor] = "rtf:cellBottomColor";
    mMap[NS_rtf::LN_cellRightColor] = "rtf:cellRightColor";
    mMap[NS_rtf::LN_CELLSHADOW] = "rtf:CELLSHADOW";
    mMap[NS_rtf::LN_shpopt] = "rtf:shpopt";
    mMap[NS_rtf::LN_shpoptextraoffset] = "rtf:shpoptextraoffset";
    mMap[NS_rtf::LN_shptypename] = "rtf:shptypename";
    mMap[NS_rtf::LN_shpdgg] = "rtf:shpdgg";
    mMap[NS_rtf::LN_shpblipbname] = "rtf:shpblipbname";
    mMap[NS_rtf::LN_blip] = "rtf:blip";
    mMap[NS_rtf::LN_blip] = "rtf:blip";
    mMap[NS_rtf::LN_shptxt] = "rtf:shptxt";

        /* Classes */
    mMap[NS_rtf::LN_LISTTABLE] = "rtf:LISTTABLE";
    mMap[NS_rtf::LN_LFOTABLE] = "rtf:LFOTABLE";
    mMap[NS_rtf::LN_FONTTABLE] = "rtf:FONTTABLE";
    mMap[NS_rtf::LN_STYLESHEET] = "rtf:STYLESHEET";
}
}
