/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ODSLParser.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: os $ $Date: 2007/06/19 05:34:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/**
  Copyright 2005 Sun Microsystems, Inc.
  */

#ifndef INCLUDED_ODSL_ODSLREADER_HXX
#include <ODSLParser.hxx>
#endif

#ifndef INCLUDED_XXMLREADER_HXX
#include <odiapi/xxml/XXmlReader.hxx>
#endif 

#include <odiapi/sl/od_sl.hxx>

#include <osl/time.h>

#include <stdio.h>

#include <com/sun/star/io/XStream.hpp>
#include <com/sun/star/io/XInputStream.hpp>
#include <com/sun/star/io/XSeekable.hpp>
#include <com/sun/star/io/XTruncate.hpp>
#include <com/sun/star/task/XStatusIndicator.hpp>
#include <com/sun/star/container/XNameContainer.hpp>
#include <ucbhelper/contentbroker.hxx>
#include <com/sun/star/ucb/XSimpleFileAccess.hpp>
#include <osl/process.h>
#include <rtl/string.hxx>
#include <set>
#include <assert.h>
#include <cppuhelper/implbase2.hxx>
#include <com/sun/star/embed/XTransactedObject.hpp>
#include <com/sun/star/embed/XStorage.hpp>
#include <com/sun/star/util/XCloseable.hpp>
#include <comphelper/storagehelper.hxx>
#include <com/sun/star/embed/XTransactedObject.hpp>
#include <com/sun/star/beans/PropertyValue.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <comphelper/seqstream.hxx>


using namespace ::com::sun::star;
using namespace ::writerfilter;
using namespace ::odiapi;

namespace writerfilter { namespace odsl {

const sal_Char ODSLReader::SERVICE_NAME[40] = "debugservices.odsl.ODSLReader";
const sal_Char ODSLReader::IMPLEMENTATION_NAME[40] = "debugservices.odsl.ODSLReader";


class MyHandler : public xxml::ContentHandler
{
public:
	virtual void startDocument()
	{
	}
	virtual void endDocument()
	{
	}
	virtual void startElement(QName_t name, QName_t attrName[], const xxml::Value *attrValue[], int attrs)
	{
		if (name==NS_text::LN_p)
		{
//		printf("<{%s}:%s>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name));
		for(int i=0;i<attrs;i++)
		{
			if (attrName[i]==NS_text::LN_style_name)
			{
			printf("@{%s}:%s=\"%s\"\n", QName::serializer().getNamespaceUri(attrName[i]), QName::serializer().getLocalName(attrName[i]), attrValue[i]->getOString().getStr());
			}
//			printf("@{%s}:%s=\"%s\"\n", QName::serializer().getNamespaceUri(attrName[i]), QName::serializer().getLocalName(attrName[i]), attrValue[i]->getOString().getStr());
		}
		}
	}

	virtual void endElement(QName_t /*name*/)
	{
//		printf("</%s>\n", QName::serializer().getLocalName(name));
		//printf("</{%s}:%s>\n", QName::serializer().getNamespaceUri(name), QName::serializer().getLocalName(name));
	}
	virtual void characters(const xxml::Value &/*value*/)
	{
//		printf("\"%s\"\n", value.getOString().getStr());
	}

	virtual void startStream(QName_t /*stream*/)
	{
	}
	virtual void endStream(QName_t /*stream*/)
	{
	}

	virtual void startReading(size_t /*totalBytes*/)
	{
	}
	virtual void continueReading(size_t /*bytes*/)
	{
	}
	virtual void endReading()
	{
	}
};



ODSLReader::ODSLReader(const uno::Reference< uno::XComponentContext > &xContext_) :
xContext( xContext_ )
{
}

void dumpProperty(const props::Property::Pointer_t pr)
{
	printf("<%s", QName::serializer().getLocalName(pr->getId()));
	props::Iterator<props::Property::Pointer_t>::Pointer_t j= pr->getPropertyBag()->createIterator();
	for(j->first();!j->isDone();j->next())
	{
		props::Property::Pointer_t pr1=j->getCurrent();
		if (!pr->hasPropertyBag())
		{
			printf(" %s=\"%s\"", QName::serializer().getLocalName(pr1->getId()), pr->getStringValue().c_str());
		}
	}
	printf(">\n");
	props::Iterator<props::Property::Pointer_t>::Pointer_t k= pr->getPropertyBag()->createIterator();
	for(k->first();!k->isDone();k->next())
	{
		props::Property::Pointer_t pr1=k->getCurrent();
		if (pr->hasPropertyBag())
			dumpProperty(pr1);
	}
	printf("</%s>\n", QName::serializer().getLocalName(pr->getId()));
}


void dumpStyle(QName_t /*name*/, props::PropertyPoolHandle_Pointer_t ph)
{
	printf("<style \n");
	props::Iterator<props::Property::Pointer_t>::Pointer_t j= ph->getPropertyBag()->createIterator();
	for(j->first();!j->isDone();j->next())
	{
		props::Property::Pointer_t pr=j->getCurrent();
		if (!pr->hasPropertyBag())
		{
			printf(" %s=\"%s\"", QName::serializer().getLocalName(pr->getId()), pr->getStringValue().c_str());
		}
	}
	printf(">\n");
	props::Iterator<props::Property::Pointer_t>::Pointer_t k= ph->getPropertyBag()->createIterator();
	for(k->first();!k->isDone();k->next())
	{
		props::Property::Pointer_t pr=k->getCurrent();
		if (pr->hasPropertyBag())
			dumpProperty(pr);
	}
	printf("</style>\n");
}

sal_Int32 SAL_CALL ODSLReader::run( const uno::Sequence< rtl::OUString >& aArguments ) throw (uno::RuntimeException)
{
	printf("<out xmlns:style=\"a\">\n");

	odiapi::props::PropertyPool::Pointer_t propertyPool=odiapi::props::createPropertyPool();
	MyHandler bridge;
	std::auto_ptr<ODSLHandler> handler=ODSLHandler::createODSLHandler(propertyPool, bridge);

  if (aArguments.getLength()!=1)
  {
	  return 1;
  }
	uno::Sequence<uno::Any> aUcbInitSequence(2);
	aUcbInitSequence[0] <<= rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("Local"));
	aUcbInitSequence[1] <<= rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("Office"));
	uno::Reference<lang::XMultiServiceFactory> xServiceFactory(xContext->getServiceManager(), uno::UNO_QUERY_THROW);
	uno::Reference<lang::XMultiComponentFactory> xFactory(xContext->getServiceManager(), uno::UNO_QUERY_THROW );
    if (::ucbhelper::ContentBroker::initialize(xServiceFactory, aUcbInitSequence))
	{
		// construct an URL of the input file name
		rtl::OUString arg=aArguments[0];
		rtl_uString *dir=NULL;
		osl_getProcessWorkingDir(&dir);
		rtl::OUString absFileUrl;
		osl_getAbsoluteFileURL(dir, arg.pData, &absFileUrl.pData);
		rtl_uString_release(dir);
/*
		// get file simple file access service
		uno::Reference<com::sun::star::ucb::XSimpleFileAccess> xFileAccess(
		xFactory->createInstanceWithContext(
			::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.ucb.SimpleFileAccess")), 
			xContext), uno::UNO_QUERY_THROW );

		// open file
		uno::Reference<io::XInputStream> xInputStream = xFileAccess->openFileRead(absFileUrl);
*/

		uno::Reference <lang::XSingleServiceFactory> xStorageFactory(
			xServiceFactory->createInstance (rtl::OUString::createFromAscii("com.sun.star.embed.StorageFactory")), uno::UNO_QUERY_THROW);
		uno::Sequence< uno::Any > aArgs( 2 );
		aArgs[0] <<= absFileUrl;
		aArgs[1] <<= embed::ElementModes::READ;
		uno::Reference<embed::XStorage> xStorage(xStorageFactory->createInstanceWithArguments(aArgs), uno::UNO_QUERY_THROW);

		// parse file. The reader will close the input stream.
		std::auto_ptr<xxml::XXmlReader> reader=xxml::XXmlReader::createXXmlReader(*handler);
		TimeValue t1; osl_getSystemTime(&t1);

        rtl::OUString settings = rtl::OUString::createFromAscii("settings.xml");
		reader->read(xStorage, settings);
        rtl::OUString meta = rtl::OUString::createFromAscii("meta.xml");
		reader->read(xStorage, meta);
        rtl::OUString styles = rtl::OUString::createFromAscii("styles.xml");
		reader->read(xStorage, styles);
        rtl::OUString content = rtl::OUString::createFromAscii("content.xml");
		reader->read(xStorage, content);

		TimeValue t2; osl_getSystemTime(&t2);
		printf("time=%lis\n", t2.Seconds-t1.Seconds);
/*
		props::Iterator<props::PropertyBag_Pointer_t>::Pointer_t i = propertyPool->createIterator();
		for(i->first();!i->isDone();i->next())
		{
			props::PropertyBag_Pointer_t bag=i->getCurrent();
			props::Iterator<props::Property::Pointer_t>::Pointer_t j= bag->createIterator();
			for(j->first();!j->isDone();j->next())
			{
				props::Property::Pointer_t pr=j->getCurrent();
				printf("id=%i %s %s \n", pr->getId(), QName::serializer().getNamespaceUri(pr->getId()), QName::serializer().getLocalName(pr->getId()));
			}
		}
*/

		for (std::map<QName_t, props::PropertyPoolHandle_Pointer_t>::const_iterator i=
			handler->getStyles().begin();
			i!=handler->getStyles().end();
			i++)
		{
			dumpStyle(i->first, i->second);
//			printf("%s %s\n", QName::serializer().getNamespaceUri(i->first), QName::serializer().getLocalName(i->first));
			/*
			const props::Property::Pointer_t pr=i->second;
			printf("id=%i %s %s\n", pr->getId(), QName::serializer().getNamespaceUri(pr->getId()), QName::serializer().getLocalName(pr->getId()));
		props::Iterator<props::Property::Pointer_t>::Pointer_t j= pr->getPropertyBag()->createIterator();
		if (props::Property::Pointer_t name=pr->findChild(NS_style::LN_name))
		{
			printf("\tNAME=%s\n", name->getStringValue().c_str());
		}
		if (props::Property::Pointer_t display_name=pr->findChild(NS_style::LN_display_name))
		{
			printf("\tDISPLAY_NAME=%s\n", display_name->getStringValue().c_str());
		}
		if (props::Property::Pointer_t _class=pr->findChild(NS_style::LN_class))
		{
			printf("\tCLASS=%s\n", _class->getStringValue().c_str());
		}
		if (props::Property::Pointer_t family=pr->findChild(NS_style::LN_family))
		{
			printf("\tFAMILY=%s\n", family->getStringValue().c_str());
		}
		for(j->first();!j->isDone();j->next())
		{
			props::Property::Pointer_t pr=j->getCurrent();
			printf("\tid=%i %s %s \n", pr->getId(), QName::serializer().getNamespaceUri(pr->getId()), QName::serializer().getLocalName(pr->getId()));

		}
		*/
		}

		/*
		props::PropertyBag_Pointer_t bag=handler->getStyles();
		props::Iterator<props::Property::Pointer_t>::Pointer_t j= bag->createIterator();
		for(j->first();!j->isDone();j->next())
		{
			props::Property::Pointer_t pr=j->getCurrent();
			printf("id=%i %s %s \n", pr->getId(), QName::serializer().getNamespaceUri(pr->getId()), QName::serializer().getLocalName(pr->getId()));
		}
*/
		printf("</out>\n");
        ::ucbhelper::ContentBroker::deinitialize();
	}
	else printf("can't initialize UCB!\n");


/*
  std::auto_ptr<xxml::XXmlReader> reader=xxml::XXmlReader::createXXmlReader(handler);
  rtl::OString arg8;
  rtl::OUString arg=aArguments[0];
  if (arg.convertToString(&arg8, RTL_TEXTENCODING_ASCII_US, RTL_UNICODETOTEXT_FLAGS_INVALID_ERROR))
  {
	  TimeValue t1; osl_getSystemTime(&t1);
	  reader->read(arg8.getStr());
	  TimeValue t2; osl_getSystemTime(&t2);
	  printf("Events=%i time=%is time/event=%0.10fs\n", handler.events, t2.Seconds-t1.Seconds, (double)(t2.Seconds-t1.Seconds)/(double)handler.events);
		
  }
*/


	return 0;
}

::rtl::OUString ODSLReader_getImplementationName ()
{
	return rtl::OUString::createFromAscii ( ODSLReader::IMPLEMENTATION_NAME );
}

sal_Bool SAL_CALL ODSLReader_supportsService( const ::rtl::OUString& ServiceName )
{
	return ServiceName.equals( rtl::OUString::createFromAscii( ODSLReader::SERVICE_NAME ) );
}
uno::Sequence< rtl::OUString > SAL_CALL ODSLReader_getSupportedServiceNames(  ) throw (uno::RuntimeException)
{
	uno::Sequence < rtl::OUString > aRet(1);
	rtl::OUString* pArray = aRet.getArray();
	pArray[0] =  rtl::OUString::createFromAscii ( ODSLReader::SERVICE_NAME );
	return aRet;
}

uno::Reference< uno::XInterface > SAL_CALL ODSLReader_createInstance( const uno::Reference< uno::XComponentContext > & xContext) throw( uno::Exception )
{
	return (cppu::OWeakObject*) new ODSLReader( xContext );
}

} } /* end namespace writerfilter::rtftok */
