/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xmlfiltertestdialog.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/12/01 14:35:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _XMLFILTERTESTDIALOG_HXX_
#define _XMLFILTERTESTDIALOG_HXX_

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XEVENTBROADCASTER_HPP_
#include <com/sun/star/document/XEventBroadcaster.hpp>
#endif

#ifndef _SV_DIALOG_HXX 
#include <vcl/dialog.hxx>
#endif

#ifndef _SV_BUTTON_HXX 
#include <vcl/button.hxx>
#endif
#ifndef _SV_FIXED_HXX 
#include <vcl/fixed.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX 
#include <svtools/poolitem.hxx>
#endif

class filter_info_impl;
class XMLSourceFileDialog;

class XMLFilterTestDialog : public ModalDialog
{
public:
	XMLFilterTestDialog( Window* pParent, ResMgr& rResMgr, const com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >& rxMSF  );
	virtual ~XMLFilterTestDialog();

	void test( const filter_info_impl& rFilterInfo );
	const filter_info_impl*	getFilterInfo() const;

	void updateCurrentDocumentButtonState( com::sun::star::uno::Reference< com::sun::star::lang::XComponent > * pRef = NULL );

private:
	DECL_LINK(ClickHdl_Impl, PushButton * );

	void onExportBrowse();
	void onExportCurrentDocument();
	void onImportBrowse();
	void onImportRecentDocument();
	void initDialog();

	com::sun::star::uno::Reference< com::sun::star::lang::XComponent > getFrontMostDocument( const rtl::OUString& rServiceName );
	void import( const rtl::OUString& rURL );
	void displayXMLFile( const rtl::OUString& rURL );
	void doExport( com::sun::star::uno::Reference< com::sun::star::lang::XComponent > xComp );

private:
	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > mxMSF;
	com::sun::star::uno::Reference< com::sun::star::document::XEventBroadcaster > mxGlobalBroadcaster;
	com::sun::star::uno::Reference< com::sun::star::document::XEventListener > mxGlobalEventListener;
	com::sun::star::uno::WeakReference< com::sun::star::lang::XComponent > mxLastFocusModel;

	ResMgr&				mrResMgr;

	rtl::OUString	maImportRecentFile;
	rtl::OUString	maExportRecentFile;

	FixedLine	maFLExport;
	FixedText	maFTExportXSLT;
	FixedText	maFTExportXSLTFile;
	FixedText	maFTTransformDocument;
	PushButton	maPBExportBrowse;
	PushButton	maPBCurrentDocument;
	FixedText	maFTNameOfCurentFile;
	FixedLine	maFLImport;
	FixedText	maFTImportXSLT;
	FixedText	maFTImportXSLTFile;
	FixedText	maFTImportTemplate;
	FixedText	maFTImportTemplateFile;
	FixedText	maFTTransformFile;
	CheckBox	maCBXDisplaySource;
	PushButton	maPBImportBrowse;
	PushButton	maPBRecentDocument;
	FixedText	maFTNameOfRecentFile;
	PushButton	maPBClose;
	HelpButton	maPBHelp;

	XMLSourceFileDialog*	mpSourceDLG;
	filter_info_impl*		mpFilterInfo;

	String maDialogTitle;

	::rtl::OUString sDTDPath;
};

#endif
