/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: CommandController.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/04/03 15:43:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "precompiled_sd.hxx"

#include "framework/CommandController.hxx"

#include "ViewShellBase.hxx"
#include "DrawController.hxx"

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::drawing::framework;

using ::rtl::OUString;

namespace sd { namespace framework {

Reference<XInterface> SAL_CALL CommandController_createInstance (
    const Reference<XComponentContext>& rxContext)
{
    return Reference<XInterface>(CommandController::CreateInstance(rxContext), UNO_QUERY);
}




::rtl::OUString CommandController_getImplementationName (void) throw(RuntimeException)
{
    return ::rtl::OUString(
        RTL_CONSTASCII_USTRINGPARAM("com.sun.star.comp.Draw.framework.CommandController"));
}




Sequence<rtl::OUString> SAL_CALL CommandController_getSupportedServiceNames (void)
    throw (RuntimeException)
{
	static const ::rtl::OUString sServiceName(
        ::rtl::OUString::createFromAscii("com.sun.star.drawing.framework.CommandController"));
	return Sequence<rtl::OUString>(&sServiceName, 1);
}





//===== ToolbarController =====================================================

Reference<XCommandController> CommandController::CreateInstance (
    const Reference<XComponentContext>& rxContext)
{
	return Reference<XCommandController>(new CommandController(rxContext));
}




CommandController::CommandController (
    const Reference<XComponentContext>&rxContext)
    throw()
    : CommandControllerInterfaceBase(MutexOwner::maMutex)
{
    (void)rxContext;
}




CommandController::~CommandController (void)
    throw()
{
}




void SAL_CALL CommandController::disposing (void)
{
    ::osl::MutexGuard aGuard (maMutex);
}




void SAL_CALL CommandController::updateStart (
    const Reference<XConfiguration>& rxRequestedConfiguration,
    const Reference<XConfiguration>& rxCurrentConfiguration,
    const Sequence<Reference<XResourceId> >& rResourcesToDeactivate)
    throw (RuntimeException)
{
    (void)rxRequestedConfiguration;
    (void)rxCurrentConfiguration;
    (void)rResourcesToDeactivate;
}




void SAL_CALL CommandController::updateEnd (
    const Reference<XConfiguration>& rxRequestedConfiguration,
    const Reference<XConfiguration>& rxCurrentConfiguration,
    const Sequence<Reference<XResourceId> >& rResourcesToActivate)
    throw (RuntimeException)
{
    (void)rxRequestedConfiguration;
    (void)rxCurrentConfiguration;
    (void)rResourcesToActivate;
}




void SAL_CALL CommandController::initialize (const Sequence<Any>& aArguments)
    throw (Exception, RuntimeException)
{
    (void)aArguments;
}



} } // end of namespace sd::framework
