/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SlsPageNotificationObjectContact.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/26 11:46:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_SLIDESORTER_PAGE_NOTIFICATION_OBJECT_CONTACT_HXX
#define SD_SLIDESORTER_PAGE_NOTIFICATION_OBJECT_CONTACT_HXX

#include <svx/sdr/contact/objectcontactofobjlistpainter.hxx>

namespace sd { namespace slidesorter { namespace view {


/** We use this object contact to establish a link between the contact
    objects of an SdrPage object and an SdrPageObj object: a call to
    SdrPage::ActionChanged() eventually calls our InvalidatePartOfView().
    From there we can forward it to the PageObjectViewObjectContact object
    which in effect can update its preview.
*/
class PageNotificationObjectContact
    : public ::sdr::contact::ObjectContactPainter
{
public:
    /** Create a new object contact that forwards notifications from the
        given SdrPage to the given ViewObjectContact.
    */
	PageNotificationObjectContact (
        SdrPage& rBroadcaster,
        ::sdr::contact::ViewObjectContact& rListener);
    virtual ~PageNotificationObjectContact (void);

    /** Call this method in the first PaintObject() call after creation of a
        new object of this class.  This will lead to the creation of the
        tree of contact objects that link the broadcasting SdrPage with the
        listening ViewObjectContact.
    */
    virtual void EnsureValidDrawHierarchy (::sdr::contact::DisplayInfo& rDisplayInfo);

protected:
    /** There is only one object: the ViewContact of the broadcasting
        SdrPage.
    */
    virtual sal_uInt32 GetPaintObjectCount (void) const;

    /** There is only one object: the ViewContact of the broadcasting
        SdrPage.
        @throws RuntimeException
            When an invalid index is given then a RuntimeException is
            thrown.
        @param nIndex
            Only 0 is a valid index.
    */
    virtual ::sdr::contact::ViewContact& GetPaintObjectViewContact (sal_uInt32 nIndex) const;

    /** This call is translated into a ActionChanged() at the listening
        ViewObjectContact object.
        @param rRectangle
            Ignored.  ActionChanged() is always called.
    */
    virtual void InvalidatePartOfView (const Rectangle& rRectangle) const;

private:
	SdrPage& mrBroadcaster;
    ::sdr::contact::ViewObjectContact& mrListener;
};



} } } // end of namespace ::sd::slidesorter::view

#endif
