/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: bbmgr.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: hr $ $Date: 2007/09/27 11:50:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"

// #include *****************************************************************



#include "errhdl.hxx"
#include "linetype.hxx"

// Globals ******************************************************************

static const SwLineType __FAR_DATA aLineTypeArr[] =
{
//  In          Out         Dist
	{ LIN_0,    LIN_1,      LIN_0 }, // Einfache Linien
	{ LIN_0,	LIN_2,		LIN_0 },
	{ LIN_0,	LIN_3,	    LIN_0 },
	{ LIN_0,	LIN_5,		LIN_0 },
	{ LIN_1,    LIN_1,      LIN_2 }, // Doppelte Linien
	{ LIN_2,    LIN_2,      LIN_2 }, // Doppelte Linien
	{ LIN_3,	LIN_3,		LIN_3 },
	{ LIN_3,	LIN_2, 		LIN_2 },
	{ LIN_2,	LIN_3, 		LIN_2 },
	{ LIN_4,	LIN_3, 		LIN_3 },
	{ LIN_3,	LIN_4, 		LIN_3 }
};


// **************************************************************************

#if OSL_DEBUG_LEVEL > 0
static USHORT GetLineTypeCount()
{
	return (sizeof(aLineTypeArr) / sizeof(SwLineType));
}
#endif

const SwLineType& GetLineType(USHORT nIdx)
{
#if OSL_DEBUG_LEVEL > 0
	ASSERT(nIdx < GetLineTypeCount(), "Ungueltiger LineTypeIndex");
#endif
	return aLineTypeArr[nIdx];
}

// **************************************************************************



