/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: MetaImportComponent.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/27 15:19:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_xmloff.hxx"

#ifndef _XMLOFF_METAIMPORTCOMPONENT_HXX
#include "MetaImportComponent.hxx"
#endif

#ifndef _XMLOFF_XMLNMSPE_HXX
#include "xmlnmspe.hxx"
#endif

#ifndef _XMLOFF_XMLTOKEN_HXX
#include <xmloff/xmltoken.hxx>
#endif

#ifndef _XMLOFF_XMLMETAI_HXX
#include <xmloff/xmlmetai.hxx>
#endif

using namespace ::com::sun::star;
using namespace ::xmloff::token;

class SvXMLMetaDocumentContext : public SvXMLImportContext
{
private:
	::com::sun::star::uno::Reference<
		::com::sun::star::document::XDocumentInfo>	xDocInfo;

public:
	SvXMLMetaDocumentContext(SvXMLImport& rImport, USHORT nPrfx,
							const rtl::OUString& rLName,
							const ::com::sun::star::uno::Reference<
								::com::sun::star::xml::sax::XAttributeList>& xAttrList,
							const ::com::sun::star::uno::Reference<
								::com::sun::star::document::XDocumentInfo>&	rDocInfo);
	virtual ~SvXMLMetaDocumentContext();

	virtual SvXMLImportContext *CreateChildContext( USHORT nPrefix,
													const rtl::OUString& rLocalName,
													const ::com::sun::star::uno::Reference<
									  	::com::sun::star::xml::sax::XAttributeList>& xAttrList );
	virtual void EndElement();
};

SvXMLMetaDocumentContext::SvXMLMetaDocumentContext(SvXMLImport& rImport,
						USHORT nPrfx, const rtl::OUString& rLName,
						const uno::Reference<xml::sax::XAttributeList>&,
						const uno::Reference<document::XDocumentInfo>& rDocInfo) :
	SvXMLImportContext( rImport, nPrfx, rLName ),
	xDocInfo(rDocInfo)
{
	// here are no attributes
}

SvXMLMetaDocumentContext::~SvXMLMetaDocumentContext()
{
}

SvXMLImportContext *SvXMLMetaDocumentContext::CreateChildContext( USHORT nPrefix,
									 const rtl::OUString& rLocalName,
									 const ::com::sun::star::uno::Reference<
									  	::com::sun::star::xml::sax::XAttributeList>& )
{
	if (  (XML_NAMESPACE_OFFICE == nPrefix) &&
		 IsXMLToken(rLocalName, XML_META) )
	{
		return new SfxXMLMetaContext(GetImport(), nPrefix, rLocalName, xDocInfo);
	}
	else
	{
		return new SvXMLImportContext( GetImport(), nPrefix, rLocalName );
	}
}

void SvXMLMetaDocumentContext::EndElement()
{
}

//===========================================================================

// #110680#
XMLMetaImportComponent::XMLMetaImportComponent(
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory) throw() 
:	SvXMLImport(xServiceFactory)
{
}

XMLMetaImportComponent::~XMLMetaImportComponent() throw()
{
}


SvXMLImportContext* XMLMetaImportComponent::CreateContext(
	sal_uInt16 nPrefix,
	const rtl::OUString& rLocalName,
	const uno::Reference<xml::sax::XAttributeList > & xAttrList )
{
	if (  (XML_NAMESPACE_OFFICE == nPrefix) &&
		 IsXMLToken(rLocalName, XML_DOCUMENT_META) )
	{
		return new SvXMLMetaDocumentContext(*this, nPrefix, rLocalName, xAttrList, xDocInfo);
	}
	else
	{
		return SvXMLImport::CreateContext(nPrefix, rLocalName, xAttrList);
	}
}

void SAL_CALL XMLMetaImportComponent::setTargetDocument( const uno::Reference< lang::XComponent >& xDoc )
	throw(lang::IllegalArgumentException, uno::RuntimeException)
{
	xDocInfo = uno::Reference< document::XDocumentInfo >::query( xDoc );
	if( !xDocInfo.is() )
		throw lang::IllegalArgumentException();
}

uno::Sequence< rtl::OUString > SAL_CALL
	XMLMetaImportComponent_getSupportedServiceNames()
		throw()
{
	const rtl::OUString aServiceName( RTL_CONSTASCII_USTRINGPARAM(
		"com.sun.star.document.XMLOasisMetaImporter" ) );
	const uno::Sequence< rtl::OUString > aSeq( &aServiceName, 1 );
	return aSeq;
}

rtl::OUString SAL_CALL XMLMetaImportComponent_getImplementationName() throw()
{
	return rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "XMLMetaImportComponent" ) );
}

uno::Reference< uno::XInterface > SAL_CALL XMLMetaImportComponent_createInstance(
		const uno::Reference< lang::XMultiServiceFactory > & rSMgr)
	throw( uno::Exception )
{
	// #110680#
	// return (cppu::OWeakObject*)new XMLMetaImportComponent;
	return (cppu::OWeakObject*)new XMLMetaImportComponent(rSMgr);
}


