#!/usr/bin/env python
# -*- coding: UTF-8 -*-
import sys, os, string

poHeader="""# Tuxpaint-stamps [Language] translation.
# Copyright (C) 2002-2005
# This file is distributed under the same license as the Tuxpaint-stamps package.
# [Translator's name] <translator@email.address>, 2002-2005.
#
msgid ""
msgstr ""
"Project-Id-Version: tuxpaint-stamps\\n"
"Report-Msgid-Bugs-To: tuxpaint-i18n@lists.sourceforge.net\\n"
"MIME-Version: 1.0\\n"
"Content-Type: text/plain; charset=UTF-8\\n"
"Content-Transfer-Encoding: 8bit\\n"
"""
localeList = []

def lister(poLocale, dirname, filesindir):
    for fname in filesindir:
        fnlist = os.path.splitext(fname)
        if fnlist[1] == ".txt":
            txtFile = open(os.path.join(dirname, fname), 'rb')
            # write stamp filename down follow mark('#').
            poFile.write('\n#: ' + dirname + '/' + fnlist[0] + '\n')
            # write description in msgid.
	    line = txtFile.readline()[:-1]
	    line = string.replace(line, '"', '\\"')
            poFile.write('msgid "' + line + '"\n')
	    localeString = ""
            for line in txtFile.readlines():
                # replace " to \"
                line = string.replace(line, '"', '\\"')
                splitup = string.find(line,'.utf8')
                if splitup != -1 and line[0] != '#' :
                    locale = line[:splitup]
                    if locale not in localeList:
                        localeList.append(locale)
                    if locale == poLocale:
                        localeString = line[string.find(line, "=") + 1:-1]
            txtFile.close()
            # write translation or empty string in msgstr.
            poFile.write('msgstr "' + localeString + '"\n')

if __name__ == '__main__':
    poFile = open('./tuxpaint-stamps.pot', 'wb')
    print ">>", poFile.name
    poFile.write(poHeader)
    os.path.walk('../stamps/', lister, None)
    poFile.close()
#    for locale in localeList:
#        poFile = open('./tuxpaint-stamps-' + locale + '.po', 'wb')
#        poFile.write(poHeader)
#        os.path.walk('../stamps/', lister, locale)
#        poFile.close()
