/* i386-linux.elf.shell-entry.h
   created from i386-linux.elf.shell-entry.bin, 29969 (0x7511) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_I386_LINUX_ELF_SHELL_ENTRY_SIZE    29969
#define STUB_I386_LINUX_ELF_SHELL_ENTRY_ADLER32 0x16901af6
#define STUB_I386_LINUX_ELF_SHELL_ENTRY_CRC32   0xc843974b

unsigned char stub_i386_linux_elf_shell_entry[29969] = {
127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
168, 31,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,   /* 0x  20 */
183,  0,180,  0,232,252,255,255,255, 96,252,139,116, 36, 36,139,   /* 0x  30 */
124, 36, 44,131,205,255,235,  3,164,235,  3,138,  6, 70,136,  7,   /* 0x  40 */
 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192,   /* 0x  50 */
 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,   /* 0x  60 */
131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252,   /* 0x  70 */
 17,219,115,255,  1,219,115,255,117,  9,139, 30,131,238,252, 17,   /* 0x  80 */
219,115,255, 49,201,131,232,  3,114, 13,193,224,  8,138,  6, 70,   /* 0x  90 */
131,240,255,116,255,137,197,  1,219,117,  7,139, 30,131,238,252,   /* 0x  a0 */
 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x  b0 */
201,117,255, 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x  c0 */
201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 48,  1,219,   /* 0x  d0 */
115, 48,117,  9,139, 30,131,238,252, 17,219,115, 48, 65, 65,131,   /* 0x  e0 */
193,  2,129,253,  0,243,255,255,131,209,  1, 86,141, 52, 47,243,   /* 0x  f0 */
164, 94,233,252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,   /* 0x 100 */
118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,   /* 0x 110 */
139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,   /* 0x 120 */
207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,  7,   /* 0x 130 */
 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192,   /* 0x 140 */
 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,   /* 0x 150 */
131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252,   /* 0x 160 */
 17,219,114, 15,  1,219,115, 11,117, 15,139, 30,131,238,252, 17,   /* 0x 170 */
219,114, 15, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x 180 */
192,235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,   /* 0x 190 */
131,240,255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139,   /* 0x 1a0 */
 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,   /* 0x 1b0 */
252, 17,219, 17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,   /* 0x 1c0 */
252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 1d0 */
115, 68,  1,219,115, 68,117,  9,139, 30,131,238,252, 17,219,115,   /* 0x 1e0 */
 68, 65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  1, 86,   /* 0x 1f0 */
141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,131,253,   /* 0x 200 */
252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,   /* 0x 210 */
252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,   /* 0x 220 */
  4,119,241,  1,207,233,252,255,255,255,235,  3,164,235,  3,138,   /* 0x 230 */
  6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 240 */
114,  1, 49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,   /* 0x 250 */
117,  7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139,   /* 0x 260 */
 30,131,238,252, 17,219,114, 30,  1,219,115, 11,117, 30,139, 30,   /* 0x 270 */
131,238,252, 17,219,114, 30, 72,  1,219,117,  7,139, 30,131,238,   /* 0x 280 */
252, 17,219, 17,192,235,255,  1,219,117,  7,139, 30,131,238,252,   /* 0x 290 */
 17,219, 17,201,235,255, 49,201,131,232,  3,114, 17,193,224,  8,   /* 0x 2a0 */
138,  6, 70,131,240,255,116,255,209,248,137,197,235, 11,  1,219,   /* 0x 2b0 */
117,  7,139, 30,131,238,252, 17,219,114,204, 65,  1,219,117,  7,   /* 0x 2c0 */
139, 30,131,238,252, 17,219,114,190,  1,219,117,  7,139, 30,131,   /* 0x 2d0 */
238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x 2e0 */
219,115, 81,  1,219,115, 81,117,  9,139, 30,131,238,252, 17,219,   /* 0x 2f0 */
115, 81, 65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  2,   /* 0x 300 */
 86,141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,131,   /* 0x 310 */
253,252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,   /* 0x 320 */
233,252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,   /* 0x 330 */
233,  4,119,241,  1,207,233,252,255,255,255,255,210,  1,219,117,   /* 0x 340 */
  2,255,210,144,232,252,255,255,255,  1,219,116,255,195,139, 30,   /* 0x 350 */
131,238,252, 17,219,195, 41,201, 17,201,114, 11, 17,201,114,  6,   /* 0x 360 */
 17,201, 17,192, 72, 17,192,131,233,  1,115,  1,141, 72, 15, 61,   /* 0x 370 */
240,255,  0,  0,114, 14,141,  4, 14, 80,233, 14,  0,  0,  0, 17,   /* 0x 380 */
201, 17,201,131,193, 13,235,  1,133,201,116, 25, 65,131,193,  8,   /* 0x 390 */
235,  1, 41,201, 90, 41,219,141, 65,  1,115, 22,114, 21,114, 20,   /* 0x 3a0 */
114, 19,131,193,  2,114,  6, 65,114,  5,233,252,255,255,255, 17,   /* 0x 3b0 */
201,209,233,115,  1,164,209,233,115,  2,102,165,243,165,141, 65,   /* 0x 3c0 */
  1,235,  3,164,164,164, 17,192,115, 22,131,232,  3,114, 11,193,   /* 0x 3d0 */
224,  8,172,131,240,255,116, 50,137,197, 17,201, 17,201,117,255,   /* 0x 3e0 */
 65, 17,201,115,  0,131,193,  2,129,253,  0,243,255,255,131,209,   /* 0x 3f0 */
  1, 86,141, 52, 47,131,253,252,119, 19,209,233,115,  1,164,209,   /* 0x 400 */
233,115,  2,102,165,243,165, 94,233,252,255,255,255,131,253,255,   /* 0x 410 */
117,  5,172,243,170,235,240,243,164,235,236,137,229,141,156, 36,   /* 0x 420 */
  0,  0,  0,  0, 49,192, 80, 57,220,117,251, 70, 70, 83,104,  0,   /* 0x 430 */
  0,  0,  0, 87,131,195,  4, 83,104,  0,  0,  0,  0, 86,131,195,   /* 0x 440 */
  4, 83, 80,199,  3,  0,  0,  0,  0,137,229,139, 85,  0,172, 74,   /* 0x 450 */
136,193, 36,  7,192,233,  3,187,  0,253,255,255,211,227,141,164,   /* 0x 460 */
 92,144,241,255,255,131,228,224,106,  0,106,  0,137,227, 83,131,   /* 0x 470 */
195,  4,139, 77,  0,255, 49, 87, 83,131,195,  4,136, 67,  2,172,   /* 0x 480 */
 74,136,193, 36, 15,136,  3,192,233,  4,136, 75,  1, 82, 86, 83,   /* 0x 490 */
 80, 85, 87, 86, 83,131,236,124,139,148, 36,144,  0,  0,  0,199,   /* 0x 4a0 */
 68, 36,116,  0,  0,  0,  0,198, 68, 36,115,  0,139,172, 36,156,   /* 0x 4b0 */
  0,  0,  0,141, 66,  4,137, 68, 36,120,184,  1,  0,  0,  0, 15,   /* 0x 4c0 */
182, 74,  2,137,195,211,227,137,217, 73,137, 76, 36,108, 15,182,   /* 0x 4d0 */
 74,  1,211,224, 72,137, 68, 36,104,139,132, 36,168,  0,  0,  0,   /* 0x 4e0 */
 15,182, 50,199, 69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,   /* 0x 4f0 */
  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,137,116, 36,   /* 0x 500 */
100,199, 68, 36, 92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,   /* 0x 510 */
  0,199, 68, 36, 84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,   /* 0x 520 */
  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0, 57,   /* 0x 530 */
 76, 36,116,115, 14,139, 68, 36,120,102,199,  0,  0,  4,131,192,   /* 0x 540 */
  2,226,246,139,156, 36,148,  0,  0,  0, 49,255,199, 68, 36, 72,   /* 0x 550 */
255,255,255,255,137,218,  3,148, 36,152,  0,  0,  0,137, 84, 36,   /* 0x 560 */
 76, 49,210, 59, 92, 36, 76, 15,132,124,  9,  0,  0, 15,182,  3,   /* 0x 570 */
193,231,  8, 66, 67,  9,199,131,250,  4,126,231,139,140, 36,164,   /* 0x 580 */
  0,  0,  0, 57, 76, 36,116, 15,131,100,  9,  0,  0,139,116, 36,   /* 0x 590 */
116, 35,116, 36,108,139, 68, 36, 96,139, 84, 36,120,193,224,  4,   /* 0x 5a0 */
137,116, 36, 68,  1,240,129,124, 36, 72,255,255,255,  0,141, 44,   /* 0x 5b0 */
 66,119, 24, 59, 92, 36, 76, 15,132, 44,  9,  0,  0,193,100, 36,   /* 0x 5c0 */
 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,   /* 0x 5d0 */
139, 85,  0,193,232, 11, 15,183,202, 15,175,193, 57,199, 15,131,   /* 0x 5e0 */
221,  1,  0,  0,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,138,   /* 0x 5f0 */
 76, 36,100,193,248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,182,   /* 0x 600 */
 84, 36,115,102,137, 69,  0,139, 68, 36,116, 35, 68, 36,104,139,   /* 0x 610 */
108, 36,120,211,224,185,  8,  0,  0,  0, 43, 76, 36,100,211,250,   /* 0x 620 */
  1,208,105,192,  0,  6,  0,  0,131,124, 36, 96,  6,141,132,  5,   /* 0x 630 */
108, 14,  0,  0,137, 68, 36, 20, 15,142,202,  0,  0,  0,139, 68,   /* 0x 640 */
 36,116, 43, 68, 36, 92,139,148, 36,160,  0,  0,  0, 15,182,  4,   /* 0x 650 */
  2,137, 68, 36, 64,209,100, 36, 64,139, 76, 36, 64,141, 20, 54,   /* 0x 660 */
139,108, 36, 20,129,225,  0,  1,  0,  0,129,124, 36, 72,255,255,   /* 0x 670 */
255,  0,141, 68, 77,  0,137, 76, 36, 60,141, 44, 16,119, 24, 59,   /* 0x 680 */
 92, 36, 76, 15,132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,182,   /* 0x 690 */
  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,141,  0,  2,   /* 0x 6a0 */
  0,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 35,137,   /* 0x 6b0 */
 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,131,   /* 0x 6c0 */
124, 36, 60,  0,141,  4,  1,102,137,133,  0,  2,  0,  0,116, 34,   /* 0x 6d0 */
235, 46, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,   /* 0x 6e0 */
  5,102, 41,193,131,124, 36, 60,  0,102,137,141,  0,  2,  0,  0,   /* 0x 6f0 */
116, 14,129,254,255,  0,  0,  0, 15,142, 87,255,255,255,235,121,   /* 0x 700 */
129,254,255,  0,  0,  0,127,113,141, 20, 54,139,108, 36, 20,  1,   /* 0x 710 */
213,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,   /* 0x 720 */
132,196,  7,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,   /* 0x 730 */
 67,  9,199,139, 68, 36, 72,102,139, 77,  0,193,232, 11, 15,183,   /* 0x 740 */
241, 15,175,198, 57,199,115, 25,137, 68, 36, 72,184,  0,  8,  0,   /* 0x 750 */
  0, 41,240,137,214,193,248,  5,141,  4,  1,102,137, 69,  0,235,   /* 0x 760 */
159, 41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,   /* 0x 770 */
102, 41,193,102,137, 77,  0,235,135,139, 84, 36,116,137,240,139,   /* 0x 780 */
140, 36,160,  0,  0,  0,136, 68, 36,115,136,  4, 10, 66,131,124,   /* 0x 790 */
 36, 96,  3,137, 84, 36,116,127, 13,199, 68, 36, 96,  0,  0,  0,   /* 0x 7a0 */
  0,233, 27,  7,  0,  0,131,124, 36, 96,  9,127, 10,131,108, 36,   /* 0x 7b0 */
 96,  3,233, 10,  7,  0,  0,131,108, 36, 96,  6,233,  0,  7,  0,   /* 0x 7c0 */
  0,139, 76, 36, 72, 41,199,139,116, 36, 96, 41,193,137,208,102,   /* 0x 7d0 */
193,232,  5,102, 41,194,129,249,255,255,255,  0,102,137, 85,  0,   /* 0x 7e0 */
139,108, 36,120,141,116,117,  0,137,116, 36, 56,119, 22, 59, 92,   /* 0x 7f0 */
 36, 76, 15,132,241,  6,  0,  0, 15,182,  3,193,231,  8,193,225,   /* 0x 800 */
  8, 67,  9,199,139,108, 36, 56,137,200,193,232, 11,102,139,149,   /* 0x 810 */
128,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 82,137,198,   /* 0x 820 */
184,  0,  8,  0,  0, 41,232,139,108, 36, 88,193,248,  5,139, 76,   /* 0x 830 */
 36, 84,141,  4,  2,139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,   /* 0x 840 */
120,102,137,130,128,  1,  0,  0,139, 68, 36, 92,137,108, 36, 84,   /* 0x 850 */
137, 68, 36, 88, 49,192,131,124, 36, 96,  6, 15,159,192,129,193,   /* 0x 860 */
100,  6,  0,  0,141,  4, 64,137, 68, 36, 96,233,116,  2,  0,  0,   /* 0x 870 */
137,206, 41,199, 41,198,137,208,102,193,232,  5,139, 76, 36, 56,   /* 0x 880 */
102, 41,194,129,254,255,255,255,  0,102,137,145,128,  1,  0,  0,   /* 0x 890 */
119, 22, 59, 92, 36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,193,   /* 0x 8a0 */
231,  8,193,230,  8, 67,  9,199,139,108, 36, 56,137,242,193,234,   /* 0x 8b0 */
 11,102,139,141,152,  1,  0,  0, 15,183,193, 15,175,208, 57,215,   /* 0x 8c0 */
 15,131,227,  0,  0,  0,189,  0,  8,  0,  0,137,214, 41,197,199,   /* 0x 8d0 */
 68, 36, 52,  0,  8,  0,  0,137,232,193,248,  5,141,  4,  1,139,   /* 0x 8e0 */
 76, 36, 56,102,137,129,152,  1,  0,  0,139, 68, 36, 96,139, 76,   /* 0x 8f0 */
 36, 68,193,224,  5,  3, 68, 36,120,129,250,255,255,255,  0,141,   /* 0x 900 */
 44, 72,119, 22, 59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,182,   /* 0x 910 */
  3,193,231,  8,193,230,  8, 67,  9,199,102,139,149,224,  1,  0,   /* 0x 920 */
  0,137,240,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 96,   /* 0x 930 */
 41, 76, 36, 52,193,124, 36, 52,  5,139,116, 36, 52,137, 68, 36,   /* 0x 940 */
 72,131,124, 36,116,  0,141,  4, 50,102,137,133,224,  1,  0,  0,   /* 0x 950 */
 15,132,147,  5,  0,  0, 49,192,131,124, 36, 96,  6,139,172, 36,   /* 0x 960 */
160,  0,  0,  0,139, 84, 36,116, 15,159,192,141, 68,  0,  9,137,   /* 0x 970 */
 68, 36, 96,139, 68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,136,   /* 0x 980 */
 68, 36,115,136,  4, 42, 66,137, 84, 36,116,233, 49,  5,  0,  0,   /* 0x 990 */
 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,102,137,149,   /* 0x 9a0 */
224,  1,  0,  0,233, 31,  1,  0,  0,137,200, 41,214,102,193,232,   /* 0x 9b0 */
  5,139,108, 36, 56,102, 41,193, 41,215,129,254,255,255,255,  0,   /* 0x 9c0 */
102,137,141,152,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,   /* 0x 9d0 */
  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139,   /* 0x 9e0 */
 76, 36, 56,137,240,193,232, 11,102,139,145,176,  1,  0,  0, 15,   /* 0x 9f0 */
183,202, 15,175,193, 57,199,115, 35,137,198,184,  0,  8,  0,  0,   /* 0x a00 */
 41,200,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,176,   /* 0x a10 */
  1,  0,  0,139, 68, 36, 88,233,160,  0,  0,  0,137,241, 41,199,   /* 0x a20 */
 41,193,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,129,   /* 0x a30 */
249,255,255,255,  0,102,137,144,176,  1,  0,  0,119, 22, 59, 92,   /* 0x a40 */
 36, 76, 15,132,161,  4,  0,  0, 15,182,  3,193,231,  8,193,225,   /* 0x a50 */
  8, 67,  9,199,139,116, 36, 56,137,200,193,232, 11,102,139,150,   /* 0x a60 */
200,  1,  0,  0, 15,183,234, 15,175,197, 57,199,115, 32,137,198,   /* 0x a70 */
184,  0,  8,  0,  0, 41,232,139,108, 36, 56,193,248,  5,141,  4,   /* 0x a80 */
  2,102,137,133,200,  1,  0,  0,139, 68, 36, 84,235, 38,137,206,   /* 0x a90 */
 41,199, 41,198,137,208,102,193,232,  5,102, 41,194,139, 68, 36,   /* 0x aa0 */
 56,102,137,144,200,  1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,   /* 0x ab0 */
137, 84, 36, 80,139, 76, 36, 88,137, 76, 36, 84,139,108, 36, 92,   /* 0x ac0 */
137, 68, 36, 92,137,108, 36, 88, 49,192,131,124, 36, 96,  6,139,   /* 0x ad0 */
 76, 36,120, 15,159,192,129,193,104, 10,  0,  0,141, 68, 64,  8,   /* 0x ae0 */
137, 68, 36, 96,129,254,255,255,255,  0,119, 22, 59, 92, 36, 76,   /* 0x af0 */
 15,132,243,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,   /* 0x b00 */
  9,199,102,139, 17,137,240,193,232, 11, 15,183,234, 15,175,197,   /* 0x b10 */
 57,199,115, 47,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,   /* 0x b20 */
100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,   /* 0x b30 */
  4,  2,102,137,  1,139, 68, 36, 68,141, 76,  1,  4,137, 76, 36,   /* 0x b40 */
 16,235,114, 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,   /* 0x b50 */
129,254,255,255,255,  0,102,137, 17,119, 22, 59, 92, 36, 76, 15,   /* 0x b60 */
132,132,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,   /* 0x b70 */
199,102,139, 81,  2,137,240,193,232, 11, 15,183,234, 15,175,197,   /* 0x b80 */
 57,199,115, 59,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,   /* 0x b90 */
100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,   /* 0x ba0 */
  4,  2,139, 84, 36, 68,102,137, 65,  2,141,140, 17,  4,  1,  0,   /* 0x bb0 */
  0,137, 76, 36, 16,199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,   /* 0x bc0 */
198, 41,199,137,208,137,116, 36, 72,102,193,232,  5,199, 68, 36,   /* 0x bd0 */
 44, 16,  0,  0,  0,102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,   /* 0x be0 */
102,137, 81,  2,129,193,  4,  2,  0,  0,137, 76, 36, 16,139, 76,   /* 0x bf0 */
 36, 48,186,  1,  0,  0,  0,137, 76, 36, 40,141, 44, 18,139,116,   /* 0x c00 */
 36, 16,  1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92,   /* 0x c10 */
 36, 76, 15,132,209,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,   /* 0x c20 */
193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11,   /* 0x c30 */
 15,183,202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,   /* 0x c40 */
  8,  0,  0, 41,200,193,248,  5,141,  4,  2,137,234,102,137,  6,   /* 0x c50 */
235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,   /* 0x c60 */
194,102,137, 22,141, 85,  1,139,116, 36, 40, 78,137,116, 36, 40,   /* 0x c70 */
117,137,138, 76, 36, 48,184,  1,  0,  0,  0,211,224, 41,194,  3,   /* 0x c80 */
 84, 36, 44,131,124, 36, 96,  3,137, 84, 36, 12, 15,143,231,  1,   /* 0x c90 */
  0,  0,131, 68, 36, 96,  7,131,250,  3,137,208,126,  5,184,  3,   /* 0x ca0 */
  0,  0,  0,139,116, 36,120,193,224,  7,199, 68, 36, 36,  6,  0,   /* 0x cb0 */
  0,  0,141,132,  6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,   /* 0x cc0 */
  0,  0,141, 44,  0,139,116, 36,  8,  1,238,129,124, 36, 72,255,   /* 0x cd0 */
255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,   /* 0x ce0 */
100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,   /* 0x cf0 */
 72,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115,   /* 0x d00 */
 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,   /* 0x d10 */
  4,  2,102,137,  6,137,232,235, 21, 41, 68, 36, 72, 41,199,137,   /* 0x d20 */
208,102,193,232,  5,102, 41,194,141, 69,  1,102,137, 22,139,108,   /* 0x d30 */
 36, 36, 77,137,108, 36, 36,117,137,141, 80,192,131,250,  3,137,   /* 0x d40 */
 20, 36, 15,142, 39,  1,  0,  0,137,208,137,214,209,248,131,230,   /* 0x d50 */
  1,141, 72,255,131,206,  2,131,250, 13,137, 76, 36, 32,127, 28,   /* 0x d60 */
139,108, 36,120,211,230,  1,210,137, 52, 36,141, 68,117,  0, 41,   /* 0x d70 */
208,  5, 94,  5,  0,  0,137, 68, 36,  4,235, 86,141, 80,251,129,   /* 0x d80 */
124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,   /* 0x d90 */
  1,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,   /* 0x da0 */
199,209,108, 36, 72,  1,246, 59,124, 36, 72,114,  7, 43,124, 36,   /* 0x db0 */
 72,131,206,  1, 74,117,200,139, 68, 36,120,193,230,  4,137, 52,   /* 0x dc0 */
 36,  5, 68,  6,  0,  0,199, 68, 36, 32,  4,  0,  0,  0,137, 68,   /* 0x dd0 */
 36,  4,199, 68, 36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,   /* 0x de0 */
108, 36,  4,  1,192,137, 68, 36, 24,  1,197,129,124, 36, 72,255,   /* 0x df0 */
255,255,  0,119, 24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,193,   /* 0x e00 */
100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,   /* 0x e10 */
 72,102,139, 85,  0,193,232, 11, 15,183,242, 15,175,198, 57,199,   /* 0x e20 */
115, 27,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,193,248,  5,   /* 0x e30 */
141,  4,  2,102,137, 69,  0,139, 68, 36, 24,235, 31, 41, 68, 36,   /* 0x e40 */
 72, 41,199,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 24,   /* 0x e50 */
102,137, 85,  0,139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,   /* 0x e60 */
209,100, 36, 28, 73,137, 76, 36, 32, 15,133,112,255,255,255,139,   /* 0x e70 */
 52, 36, 70,137,116, 36, 92,116, 89,139, 76, 36, 12,139,108, 36,   /* 0x e80 */
116,131,193,  2, 57,108, 36, 92,119, 95,139,132, 36,160,  0,  0,   /* 0x e90 */
  0,137,234, 43, 68, 36, 92,  3,148, 36,160,  0,  0,  0,141, 52,   /* 0x ea0 */
 40,138,  6, 70,136, 68, 36,115,136,  2, 66,255, 68, 36,116, 73,   /* 0x eb0 */
116, 15,139,172, 36,164,  0,  0,  0, 57,108, 36,116,114,226,235,   /* 0x ec0 */
 17,139,132, 36,164,  0,  0,  0, 57, 68, 36,116, 15,130,187,246,   /* 0x ed0 */
255,255,129,124, 36, 72,255,255,255,  0,119, 21, 59, 92, 36, 76,   /* 0x ee0 */
184,  1,  0,  0,  0,116, 41,235,  7,184,  1,  0,  0,  0,235, 32,   /* 0x ef0 */
 67, 43,156, 36,148,  0,  0,  0, 49,192,139,148, 36,156,  0,  0,   /* 0x f00 */
  0,139, 76, 36,116,137, 26,139,156, 36,168,  0,  0,  0,137, 11,   /* 0x f10 */
131,196,124, 91, 94, 95, 93, 85, 87, 86, 83,131,236,124,139,148,   /* 0x f20 */
 36,144,  0,  0,  0,199, 68, 36,116,  0,  0,  0,  0,198, 68, 36,   /* 0x f30 */
115,  0,139,172, 36,156,  0,  0,  0,141, 66,  4,137, 68, 36,120,   /* 0x f40 */
184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217, 73,   /* 0x f50 */
137, 76, 36,108, 15,182, 74,  1,211,224, 72,137, 68, 36,104,139,   /* 0x f60 */
132, 36,168,  0,  0,  0, 15,182, 50,199, 69,  0,  0,  0,  0,  0,   /* 0x f70 */
199, 68, 36, 96,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,   /* 0x f80 */
  3,  0,  0,137,116, 36,100,199, 68, 36, 92,  1,  0,  0,  0,199,   /* 0x f90 */
 68, 36, 88,  1,  0,  0,  0,199, 68, 36, 84,  1,  0,  0,  0,199,   /* 0x fa0 */
 68, 36, 80,  1,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,   /* 0x fb0 */
136, 54,  7,  0,  0, 57, 76, 36,116,115, 14,139, 68, 36,120,102,   /* 0x fc0 */
199,  0,  0,  4,131,192,  2,226,246,139,156, 36,148,  0,  0,  0,   /* 0x fd0 */
 49,255,199, 68, 36, 72,255,255,255,255,137,218,  3,148, 36,152,   /* 0x fe0 */
  0,  0,  0,137, 84, 36, 76, 49,210, 59, 92, 36, 76, 15,132,124,   /* 0x ff0 */
  9,  0,  0, 15,182,  3,193,231,  8, 66, 67,  9,199,131,250,  4,   /* 0x1000 */
126,231,139,140, 36,164,  0,  0,  0, 57, 76, 36,116, 15,131,100,   /* 0x1010 */
  9,  0,  0,139,116, 36,116, 35,116, 36,108,139, 68, 36, 96,139,   /* 0x1020 */
 84, 36,120,193,224,  4,137,116, 36, 68,  1,240,129,124, 36, 72,   /* 0x1030 */
255,255,255,  0,141, 44, 66,119, 24, 59, 92, 36, 76, 15,132, 44,   /* 0x1040 */
  9,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,   /* 0x1050 */
199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,202, 15,   /* 0x1060 */
175,193, 57,199, 15,131,221,  1,  0,  0,137, 68, 36, 72,184,  0,   /* 0x1070 */
  8,  0,  0, 41,200,138, 76, 36,100,193,248,  5,190,  1,  0,  0,   /* 0x1080 */
  0,141,  4,  2, 15,182, 84, 36,115,102,137, 69,  0,139, 68, 36,   /* 0x1090 */
116, 35, 68, 36,104,139,108, 36,120,211,224,185,  8,  0,  0,  0,   /* 0x10a0 */
 43, 76, 36,100,211,250,  1,208,105,192,  0,  6,  0,  0,131,124,   /* 0x10b0 */
 36, 96,  6,141,132,  5,108, 14,  0,  0,137, 68, 36, 20, 15,142,   /* 0x10c0 */
202,  0,  0,  0,139, 68, 36,116, 43, 68, 36, 92,139,148, 36,160,   /* 0x10d0 */
  0,  0,  0, 15,182,  4,  2,137, 68, 36, 64,209,100, 36, 64,139,   /* 0x10e0 */
 76, 36, 64,141, 20, 54,139,108, 36, 20,129,225,  0,  1,  0,  0,   /* 0x10f0 */
129,124, 36, 72,255,255,255,  0,141, 68, 77,  0,137, 76, 36, 60,   /* 0x1100 */
141, 44, 16,119, 24, 59, 92, 36, 76, 15,132, 96,  8,  0,  0,193,   /* 0x1110 */
100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,   /* 0x1120 */
 72,102,139,141,  0,  2,  0,  0,193,232, 11, 15,183,241, 15,175,   /* 0x1130 */
198, 57,199,115, 35,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,   /* 0x1140 */
137,214,193,248,  5,131,124, 36, 60,  0,141,  4,  1,102,137,133,   /* 0x1150 */
  0,  2,  0,  0,116, 34,235, 46, 41, 68, 36, 72, 41,199,137,200,   /* 0x1160 */
141,114,  1,102,193,232,  5,102, 41,193,131,124, 36, 60,  0,102,   /* 0x1170 */
137,141,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142,   /* 0x1180 */
 87,255,255,255,235,121,129,254,255,  0,  0,  0,127,113,141, 20,   /* 0x1190 */
 54,139,108, 36, 20,  1,213,129,124, 36, 72,255,255,255,  0,119,   /* 0x11a0 */
 24, 59, 92, 36, 76, 15,132,196,  7,  0,  0,193,100, 36, 72,  8,   /* 0x11b0 */
 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 77,   /* 0x11c0 */
  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 25,137, 68,   /* 0x11d0 */
 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,141,  4,   /* 0x11e0 */
  1,102,137, 69,  0,235,159, 41, 68, 36, 72, 41,199,137,200,141,   /* 0x11f0 */
114,  1,102,193,232,  5,102, 41,193,102,137, 77,  0,235,135,139,   /* 0x1200 */
 84, 36,116,137,240,139,140, 36,160,  0,  0,  0,136, 68, 36,115,   /* 0x1210 */
136,  4, 10, 66,131,124, 36, 96,  3,137, 84, 36,116,127, 13,199,   /* 0x1220 */
 68, 36, 96,  0,  0,  0,  0,233, 27,  7,  0,  0,131,124, 36, 96,   /* 0x1230 */
  9,127, 10,131,108, 36, 96,  3,233, 10,  7,  0,  0,131,108, 36,   /* 0x1240 */
 96,  6,233,  0,  7,  0,  0,139, 76, 36, 72, 41,199,139,116, 36,   /* 0x1250 */
 96, 41,193,137,208,102,193,232,  5,102, 41,194,129,249,255,255,   /* 0x1260 */
255,  0,102,137, 85,  0,139,108, 36,120,141,116,117,  0,137,116,   /* 0x1270 */
 36, 56,119, 22, 59, 92, 36, 76, 15,132,241,  6,  0,  0, 15,182,   /* 0x1280 */
  3,193,231,  8,193,225,  8, 67,  9,199,139,108, 36, 56,137,200,   /* 0x1290 */
193,232, 11,102,139,149,128,  1,  0,  0, 15,183,234, 15,175,197,   /* 0x12a0 */
 57,199,115, 82,137,198,184,  0,  8,  0,  0, 41,232,139,108, 36,   /* 0x12b0 */
 88,193,248,  5,139, 76, 36, 84,141,  4,  2,139, 84, 36, 56,137,   /* 0x12c0 */
 76, 36, 80,139, 76, 36,120,102,137,130,128,  1,  0,  0,139, 68,   /* 0x12d0 */
 36, 92,137,108, 36, 84,137, 68, 36, 88, 49,192,131,124, 36, 96,   /* 0x12e0 */
  6, 15,159,192,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36,   /* 0x12f0 */
 96,233,116,  2,  0,  0,137,206, 41,199, 41,198,137,208,102,193,   /* 0x1300 */
232,  5,139, 76, 36, 56,102, 41,194,129,254,255,255,255,  0,102,   /* 0x1310 */
137,145,128,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 77,  6,   /* 0x1320 */
  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139,108,   /* 0x1330 */
 36, 56,137,242,193,234, 11,102,139,141,152,  1,  0,  0, 15,183,   /* 0x1340 */
193, 15,175,208, 57,215, 15,131,227,  0,  0,  0,189,  0,  8,  0,   /* 0x1350 */
  0,137,214, 41,197,199, 68, 36, 52,  0,  8,  0,  0,137,232,193,   /* 0x1360 */
248,  5,141,  4,  1,139, 76, 36, 56,102,137,129,152,  1,  0,  0,   /* 0x1370 */
139, 68, 36, 96,139, 76, 36, 68,193,224,  5,  3, 68, 36,120,129,   /* 0x1380 */
250,255,255,255,  0,141, 44, 72,119, 22, 59, 92, 36, 76, 15,132,   /* 0x1390 */
219,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,   /* 0x13a0 */
102,139,149,224,  1,  0,  0,137,240,193,232, 11, 15,183,202, 15,   /* 0x13b0 */
175,193, 57,199,115, 96, 41, 76, 36, 52,193,124, 36, 52,  5,139,   /* 0x13c0 */
116, 36, 52,137, 68, 36, 72,131,124, 36,116,  0,141,  4, 50,102,   /* 0x13d0 */
137,133,224,  1,  0,  0, 15,132,147,  5,  0,  0, 49,192,131,124,   /* 0x13e0 */
 36, 96,  6,139,172, 36,160,  0,  0,  0,139, 84, 36,116, 15,159,   /* 0x13f0 */
192,141, 68,  0,  9,137, 68, 36, 96,139, 68, 36,116, 43, 68, 36,   /* 0x1400 */
 92,138, 68,  5,  0,136, 68, 36,115,136,  4, 42, 66,137, 84, 36,   /* 0x1410 */
116,233, 49,  5,  0,  0, 41,198, 41,199,137,208,102,193,232,  5,   /* 0x1420 */
102, 41,194,102,137,149,224,  1,  0,  0,233, 31,  1,  0,  0,137,   /* 0x1430 */
200, 41,214,102,193,232,  5,139,108, 36, 56,102, 41,193, 41,215,   /* 0x1440 */
129,254,255,255,255,  0,102,137,141,152,  1,  0,  0,119, 22, 59,   /* 0x1450 */
 92, 36, 76, 15,132, 22,  5,  0,  0, 15,182,  3,193,231,  8,193,   /* 0x1460 */
230,  8, 67,  9,199,139, 76, 36, 56,137,240,193,232, 11,102,139,   /* 0x1470 */
145,176,  1,  0,  0, 15,183,202, 15,175,193, 57,199,115, 35,137,   /* 0x1480 */
198,184,  0,  8,  0,  0, 41,200,139,108, 36, 56,193,248,  5,141,   /* 0x1490 */
  4,  2,102,137,133,176,  1,  0,  0,139, 68, 36, 88,233,160,  0,   /* 0x14a0 */
  0,  0,137,241, 41,199, 41,193,137,208,102,193,232,  5,102, 41,   /* 0x14b0 */
194,139, 68, 36, 56,129,249,255,255,255,  0,102,137,144,176,  1,   /* 0x14c0 */
  0,  0,119, 22, 59, 92, 36, 76, 15,132,161,  4,  0,  0, 15,182,   /* 0x14d0 */
  3,193,231,  8,193,225,  8, 67,  9,199,139,116, 36, 56,137,200,   /* 0x14e0 */
193,232, 11,102,139,150,200,  1,  0,  0, 15,183,234, 15,175,197,   /* 0x14f0 */
 57,199,115, 32,137,198,184,  0,  8,  0,  0, 41,232,139,108, 36,   /* 0x1500 */
 56,193,248,  5,141,  4,  2,102,137,133,200,  1,  0,  0,139, 68,   /* 0x1510 */
 36, 84,235, 38,137,206, 41,199, 41,198,137,208,102,193,232,  5,   /* 0x1520 */
102, 41,194,139, 68, 36, 56,102,137,144,200,  1,  0,  0,139, 84,   /* 0x1530 */
 36, 84,139, 68, 36, 80,137, 84, 36, 80,139, 76, 36, 88,137, 76,   /* 0x1540 */
 36, 84,139,108, 36, 92,137, 68, 36, 92,137,108, 36, 88, 49,192,   /* 0x1550 */
131,124, 36, 96,  6,139, 76, 36,120, 15,159,192,129,193,104, 10,   /* 0x1560 */
  0,  0,141, 68, 64,  8,137, 68, 36, 96,129,254,255,255,255,  0,   /* 0x1570 */
119, 22, 59, 92, 36, 76, 15,132,243,  3,  0,  0, 15,182,  3,193,   /* 0x1580 */
231,  8,193,230,  8, 67,  9,199,102,139, 17,137,240,193,232, 11,   /* 0x1590 */
 15,183,234, 15,175,197, 57,199,115, 47,137, 68, 36, 72,184,  0,   /* 0x15a0 */
  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68, 36,   /* 0x15b0 */
 44,  0,  0,  0,  0,141,  4,  2,102,137,  1,139, 68, 36, 68,141,   /* 0x15c0 */
 76,  1,  4,137, 76, 36, 16,235,114, 41,198, 41,199,137,208,102,   /* 0x15d0 */
193,232,  5,102, 41,194,129,254,255,255,255,  0,102,137, 17,119,   /* 0x15e0 */
 22, 59, 92, 36, 76, 15,132,132,  3,  0,  0, 15,182,  3,193,231,   /* 0x15f0 */
  8,193,230,  8, 67,  9,199,102,139, 81,  2,137,240,193,232, 11,   /* 0x1600 */
 15,183,234, 15,175,197, 57,199,115, 59,137, 68, 36, 72,184,  0,   /* 0x1610 */
  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68, 36,   /* 0x1620 */
 44,  8,  0,  0,  0,141,  4,  2,139, 84, 36, 68,102,137, 65,  2,   /* 0x1630 */
141,140, 17,  4,  1,  0,  0,137, 76, 36, 16,199, 68, 36, 48,  3,   /* 0x1640 */
  0,  0,  0,235, 47, 41,198, 41,199,137,208,137,116, 36, 72,102,   /* 0x1650 */
193,232,  5,199, 68, 36, 44, 16,  0,  0,  0,102, 41,194,199, 68,   /* 0x1660 */
 36, 48,  8,  0,  0,  0,102,137, 81,  2,129,193,  4,  2,  0,  0,   /* 0x1670 */
137, 76, 36, 16,139, 76, 36, 48,186,  1,  0,  0,  0,137, 76, 36,   /* 0x1680 */
 40,141, 44, 18,139,116, 36, 16,  1,238,129,124, 36, 72,255,255,   /* 0x1690 */
255,  0,119, 24, 59, 92, 36, 76, 15,132,209,  2,  0,  0,193,100,   /* 0x16a0 */
 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,   /* 0x16b0 */
102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,   /* 0x16c0 */
137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,   /* 0x16d0 */
  2,137,234,102,137,  6,235, 21, 41, 68, 36, 72, 41,199,137,208,   /* 0x16e0 */
102,193,232,  5,102, 41,194,102,137, 22,141, 85,  1,139,116, 36,   /* 0x16f0 */
 40, 78,137,116, 36, 40,117,137,138, 76, 36, 48,184,  1,  0,  0,   /* 0x1700 */
  0,211,224, 41,194,  3, 84, 36, 44,131,124, 36, 96,  3,137, 84,   /* 0x1710 */
 36, 12, 15,143,231,  1,  0,  0,131, 68, 36, 96,  7,131,250,  3,   /* 0x1720 */
137,208,126,  5,184,  3,  0,  0,  0,139,116, 36,120,193,224,  7,   /* 0x1730 */
199, 68, 36, 36,  6,  0,  0,  0,141,132,  6, 96,  3,  0,  0,137,   /* 0x1740 */
 68, 36,  8,184,  1,  0,  0,  0,141, 44,  0,139,116, 36,  8,  1,   /* 0x1750 */
238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,   /* 0x1760 */
132, 10,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,   /* 0x1770 */
 67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202,   /* 0x1780 */
 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0,   /* 0x1790 */
 41,200,193,248,  5,141,  4,  2,102,137,  6,137,232,235, 21, 41,   /* 0x17a0 */
 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,141, 69,   /* 0x17b0 */
  1,102,137, 22,139,108, 36, 36, 77,137,108, 36, 36,117,137,141,   /* 0x17c0 */
 80,192,131,250,  3,137, 20, 36, 15,142, 39,  1,  0,  0,137,208,   /* 0x17d0 */
137,214,209,248,131,230,  1,141, 72,255,131,206,  2,131,250, 13,   /* 0x17e0 */
137, 76, 36, 32,127, 28,139,108, 36,120,211,230,  1,210,137, 52,   /* 0x17f0 */
 36,141, 68,117,  0, 41,208,  5, 94,  5,  0,  0,137, 68, 36,  4,   /* 0x1800 */
235, 86,141, 80,251,129,124, 36, 72,255,255,255,  0,119, 24, 59,   /* 0x1810 */
 92, 36, 76, 15,132, 86,  1,  0,  0,193,100, 36, 72,  8, 15,182,   /* 0x1820 */
  3,193,231,  8, 67,  9,199,209,108, 36, 72,  1,246, 59,124, 36,   /* 0x1830 */
 72,114,  7, 43,124, 36, 72,131,206,  1, 74,117,200,139, 68, 36,   /* 0x1840 */
120,193,230,  4,137, 52, 36,  5, 68,  6,  0,  0,199, 68, 36, 32,   /* 0x1850 */
  4,  0,  0,  0,137, 68, 36,  4,199, 68, 36, 28,  1,  0,  0,  0,   /* 0x1860 */
184,  1,  0,  0,  0,139,108, 36,  4,  1,192,137, 68, 36, 24,  1,   /* 0x1870 */
197,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,   /* 0x1880 */
132,234,  0,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,   /* 0x1890 */
 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,   /* 0x18a0 */
242, 15,175,198, 57,199,115, 27,137, 68, 36, 72,184,  0,  8,  0,   /* 0x18b0 */
  0, 41,240,193,248,  5,141,  4,  2,102,137, 69,  0,139, 68, 36,   /* 0x18c0 */
 24,235, 31, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102,   /* 0x18d0 */
 41,194,139, 68, 36, 24,102,137, 85,  0,139, 84, 36, 28, 64,  9,   /* 0x18e0 */
 20, 36,139, 76, 36, 32,209,100, 36, 28, 73,137, 76, 36, 32, 15,   /* 0x18f0 */
133,112,255,255,255,139, 52, 36, 70,137,116, 36, 92,116, 89,139,   /* 0x1900 */
 76, 36, 12,139,108, 36,116,131,193,  2, 57,108, 36, 92,119, 95,   /* 0x1910 */
139,132, 36,160,  0,  0,  0,137,234, 43, 68, 36, 92,  3,148, 36,   /* 0x1920 */
160,  0,  0,  0,141, 52, 40,138,  6, 70,136, 68, 36,115,136,  2,   /* 0x1930 */
 66,255, 68, 36,116, 73,116, 15,139,172, 36,164,  0,  0,  0, 57,   /* 0x1940 */
108, 36,116,114,226,235, 17,139,132, 36,164,  0,  0,  0, 57, 68,   /* 0x1950 */
 36,116, 15,130,187,246,255,255,129,124, 36, 72,255,255,255,  0,   /* 0x1960 */
119, 21, 59, 92, 36, 76,184,  1,  0,  0,  0,116, 41,235,  7,184,   /* 0x1970 */
  1,  0,  0,  0,235, 32, 67, 43,156, 36,148,  0,  0,  0, 49,192,   /* 0x1980 */
139,148, 36,156,  0,  0,  0,139, 76, 36,116,137, 26,139,156, 36,   /* 0x1990 */
168,  0,  0,  0,137, 11,131,196,124, 91, 94, 95, 93,  3,115,252,   /* 0x19a0 */
  3,123,248, 49,192,141,140, 36,  0,255,255,255,137,236, 80, 57,   /* 0x19b0 */
204,117,251,137,236, 49,201,185,  0,  0,  0,  0,138,  7, 71, 44,   /* 0x19c0 */
232, 60,  1,119,247,128, 63,  0,117,  4,139,  7,138, 95,  4,102,   /* 0x19d0 */
193,232,  8,134,196,193,192, 16,134,196, 41,248,128,235,232,137,   /* 0x19e0 */
  7,131,199,  5,136,216,226,  9,185,  0,  0,  0,  0,176,232,176,   /* 0x19f0 */
233,242,174,117,  4,128, 63,  0,117,255,139,  7,102,193,232,  8,   /* 0x1a00 */
134,196,193,192, 16,134,196, 41,248,171,235,  4,139, 84, 36, 36,   /* 0x1a10 */
  3, 84, 36, 40, 57,214,116,  1, 72, 43,124, 36, 44,139, 84, 36,   /* 0x1a20 */
 48,137, 58,137, 68, 36, 28, 97,195, 93,184,  0,  0, 64,  1,141,   /* 0x1a30 */
144,140,  0,  0,  0,  3, 64, 72,  5,255, 15,  0,  0, 37,  0,240,   /* 0x1a40 */
255,255,106,  0,106,255,106, 50,106,  3,255, 50, 80,137,227,106,   /* 0x1a50 */
 90, 88,205,128,131,196, 24,141, 88,  3,116,109,112, 47,105, 51,   /* 0x1a60 */
 56, 54, 45,108,105,110,117,120, 46,101,108,102, 46,115,104,101,   /* 0x1a70 */
108,108, 45,101,110,116,114,121, 46, 98,105,110, 58, 32, 32, 32,   /* 0x1a80 */
 32, 32,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,   /* 0x1a90 */
102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,105,111,   /* 0x1aa0 */
110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32,   /* 0x1ab0 */
 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32,   /* 0x1ac0 */
 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32,   /* 0x1ad0 */
 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,   /* 0x1ae0 */
103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 76, 69,   /* 0x1af0 */
 88, 69, 67, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x1b00 */
 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1b10 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1b20 */
 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x1b30 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x1b40 */
 78, 76, 89, 10, 32, 32, 49, 32, 76, 69, 88, 69, 67, 48, 49, 48,   /* 0x1b50 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32,   /* 0x1b60 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1b70 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 57, 32, 32, 50, 42,   /* 0x1b80 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x1b90 */
 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 78, 50, 66, 83, 77,   /* 0x1ba0 */
 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1bb0 */
 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1bc0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 54, 32,   /* 0x1bd0 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x1be0 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x1bf0 */
 10, 32, 32, 51, 32, 78, 50, 66, 70, 65, 83, 49, 48, 32, 32, 32,   /* 0x1c00 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x1c10 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1c20 */
 32, 48, 48, 48, 48, 48, 48, 52, 57, 32, 32, 50, 42, 42, 48, 32,   /* 0x1c30 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x1c40 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 78,   /* 0x1c50 */
 50, 66, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x1c60 */
 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1c70 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1c80 */
 48, 52, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1c90 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,   /* 0x1ca0 */
 53, 32, 78, 50, 66, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32,   /* 0x1cb0 */
 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1cc0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1cd0 */
 48, 48, 48, 48, 53, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x1ce0 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x1cf0 */
 10, 32, 32, 54, 32, 78, 50, 66, 83, 77, 65, 50, 48, 32, 32, 32,   /* 0x1d00 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48,   /* 0x1d10 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1d20 */
 32, 48, 48, 48, 48, 48, 48, 53, 99, 32, 32, 50, 42, 42, 48, 32,   /* 0x1d30 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x1d40 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 78,   /* 0x1d50 */
 50, 66, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x1d60 */
 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1d70 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1d80 */
 48, 54, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1d90 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x1da0 */
 79, 78, 76, 89, 10, 32, 32, 56, 32, 78, 50, 66, 68, 69, 67, 50,   /* 0x1db0 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32,   /* 0x1dc0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1dd0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54, 97, 32, 32, 50,   /* 0x1de0 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x1df0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 78, 50, 66, 83,   /* 0x1e00 */
 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1e10 */
 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1e20 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 55,   /* 0x1e30 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x1e40 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x1e50 */
 89, 10, 32, 49, 48, 32, 78, 50, 66, 70, 65, 83, 51, 48, 32, 32,   /* 0x1e60 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48,   /* 0x1e70 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e80 */
 32, 32, 48, 48, 48, 48, 48, 48, 56, 52, 32, 32, 50, 42, 42, 48,   /* 0x1e90 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x1ea0 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32,   /* 0x1eb0 */
 78, 50, 66, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x1ec0 */
 48, 48, 48, 48, 51,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1ed0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1ee0 */
 48, 48, 57, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x1ef0 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x1f00 */
 68, 79, 78, 76, 89, 10, 32, 49, 50, 32, 78, 50, 66, 83, 77, 65,   /* 0x1f10 */
 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100,   /* 0x1f20 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1f30 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 49, 32, 32,   /* 0x1f40 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x1f50 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x1f60 */
 32, 49, 51, 32, 78, 50, 66, 70, 65, 83, 52, 48, 32, 32, 32, 32,   /* 0x1f70 */
 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48,   /* 0x1f80 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1f90 */
 48, 48, 48, 48, 48, 48,100,101, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x1fa0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x1fb0 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32, 78, 50,   /* 0x1fc0 */
 66, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x1fd0 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1fe0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1ff0 */
101,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x2000 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 53,   /* 0x2010 */
 32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x2020 */
 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2030 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2040 */
 48, 48, 48,101,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2050 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x2060 */
 32, 49, 54, 32, 78, 50, 66, 68, 69, 67, 53, 48, 32, 32, 32, 32,   /* 0x2070 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48,   /* 0x2080 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2090 */
 48, 48, 48, 48, 48, 48,102, 50, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x20a0 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x20b0 */
 76, 89, 10, 32, 49, 55, 32, 78, 50, 66, 83, 77, 65, 54, 48, 32,   /* 0x20c0 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32, 48,   /* 0x20d0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x20e0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48,102, 98, 32, 32, 50, 42, 42,   /* 0x20f0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x2100 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 56,   /* 0x2110 */
 32, 78, 50, 66, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x2120 */
 48, 48, 48, 48, 48, 49, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2130 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2140 */
 48, 48, 49, 48, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2150 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x2160 */
 65, 68, 79, 78, 76, 89, 10, 32, 49, 57, 32, 78, 50, 66, 70, 65,   /* 0x2170 */
 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,   /* 0x2180 */
 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2190 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 50, 48, 32,   /* 0x21a0 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x21b0 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x21c0 */
 10, 32, 50, 48, 32, 78, 50, 66, 68, 69, 67, 54, 48, 32, 32, 32,   /* 0x21d0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x21e0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x21f0 */
 32, 48, 48, 48, 48, 48, 49, 51, 54, 32, 32, 50, 42, 42, 48, 32,   /* 0x2200 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x2210 */
 78, 76, 89, 10, 32, 50, 49, 32, 78, 50, 68, 83, 77, 65, 49, 48,   /* 0x2220 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32,   /* 0x2230 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2240 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 51, 54, 32, 32, 50, 42,   /* 0x2250 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2260 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50,   /* 0x2270 */
 50, 32, 78, 50, 68, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32,   /* 0x2280 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2290 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x22a0 */
 48, 48, 48, 49, 51, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x22b0 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x22c0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 51, 32, 78, 50, 68, 70,   /* 0x22d0 */
 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x22e0 */
 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x22f0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 51, 98,   /* 0x2300 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x2310 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 52, 32, 78,   /* 0x2320 */
 50, 68, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x2330 */
 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2340 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2350 */
 49, 52, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x2360 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50,   /* 0x2370 */
 53, 32, 78, 50, 68, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32,   /* 0x2380 */
 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2390 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x23a0 */
 48, 48, 48, 49, 52, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x23b0 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x23c0 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 54, 32, 78, 50, 68, 70,   /* 0x23d0 */
 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x23e0 */
 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x23f0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 53, 49,   /* 0x2400 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x2410 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2420 */
 89, 10, 32, 50, 55, 32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 32,   /* 0x2430 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48,   /* 0x2440 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2450 */
 32, 32, 48, 48, 48, 48, 48, 49, 53, 97, 32, 32, 50, 42, 42, 48,   /* 0x2460 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x2470 */
 79, 78, 76, 89, 10, 32, 50, 56, 32, 78, 50, 68, 83, 77, 65, 51,   /* 0x2480 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32,   /* 0x2490 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x24a0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 54, 55, 32, 32, 50,   /* 0x24b0 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x24c0 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x24d0 */
 50, 57, 32, 78, 50, 68, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32,   /* 0x24e0 */
 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48,   /* 0x24f0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2500 */
 48, 48, 48, 48, 49, 55, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2510 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x2520 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 48, 32, 78, 50, 68,   /* 0x2530 */
 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x2540 */
 48, 53, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2550 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 56,   /* 0x2560 */
 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x2570 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x2580 */
 76, 89, 10, 32, 51, 49, 32, 78, 50, 68, 83, 77, 65, 52, 48, 32,   /* 0x2590 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48,   /* 0x25a0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x25b0 */
 48, 32, 32, 48, 48, 48, 48, 48, 49,100, 53, 32, 32, 50, 42, 42,   /* 0x25c0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x25d0 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 50,   /* 0x25e0 */
 32, 78, 50, 68, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x25f0 */
 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2600 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2610 */
 48, 48, 49,101, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2620 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x2630 */
 65, 68, 79, 78, 76, 89, 10, 32, 51, 51, 32, 78, 50, 68, 83, 77,   /* 0x2640 */
 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2650 */
 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2660 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,102, 49, 32,   /* 0x2670 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2680 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 52, 32, 78, 50,   /* 0x2690 */
 68, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x26a0 */
 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x26b0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,   /* 0x26c0 */
102, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x26d0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 53,   /* 0x26e0 */
 32, 78, 50, 68, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x26f0 */
 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2700 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2710 */
 48, 48, 49,102, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2720 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x2730 */
 32, 51, 54, 32, 78, 50, 68, 83, 77, 65, 54, 48, 32, 32, 32, 32,   /* 0x2740 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32, 48, 48, 48, 48,   /* 0x2750 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2760 */
 48, 48, 48, 48, 48, 49,102,102, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x2770 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x2780 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 55, 32, 78, 50,   /* 0x2790 */
 68, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x27a0 */
 48, 48, 49, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x27b0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,   /* 0x27c0 */
 48, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x27d0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x27e0 */
 78, 76, 89, 10, 32, 51, 56, 32, 78, 50, 68, 70, 65, 83, 54, 49,   /* 0x27f0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54, 32, 32,   /* 0x2800 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2810 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 50, 52, 32, 32, 50, 42,   /* 0x2820 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2830 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51,   /* 0x2840 */
 57, 32, 78, 50, 68, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32,   /* 0x2850 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2860 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2870 */
 48, 48, 48, 50, 51, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x2880 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2890 */
 10, 32, 52, 48, 32, 78, 50, 69, 83, 77, 65, 49, 48, 32, 32, 32,   /* 0x28a0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48,   /* 0x28b0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x28c0 */
 32, 48, 48, 48, 48, 48, 50, 51, 97, 32, 32, 50, 42, 42, 48, 32,   /* 0x28d0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x28e0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 49, 32, 78,   /* 0x28f0 */
 50, 69, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x2900 */
 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2910 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2920 */
 50, 51,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x2930 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x2940 */
 79, 78, 76, 89, 10, 32, 52, 50, 32, 78, 50, 69, 70, 65, 83, 49,   /* 0x2950 */
 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32,   /* 0x2960 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2970 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 51,102, 32, 32, 50,   /* 0x2980 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x2990 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 51, 32, 78, 50, 69, 68,   /* 0x29a0 */
 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x29b0 */
 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x29c0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 52, 53,   /* 0x29d0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x29e0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 52, 32, 78,   /* 0x29f0 */
 50, 69, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x2a00 */
 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2a10 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2a20 */
 50, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x2a30 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x2a40 */
 79, 78, 76, 89, 10, 32, 52, 53, 32, 78, 50, 69, 70, 65, 83, 50,   /* 0x2a50 */
 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32,   /* 0x2a60 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2a70 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 53, 53, 32, 32, 50,   /* 0x2a80 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x2a90 */
 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x2aa0 */
 52, 54, 32, 78, 50, 69, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32,   /* 0x2ab0 */
 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48,   /* 0x2ac0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x2ad0 */
 48, 48, 48, 48, 50, 53,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x2ae0 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x2af0 */
 89, 10, 32, 52, 55, 32, 78, 50, 69, 83, 77, 65, 51, 48, 32, 32,   /* 0x2b00 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48,   /* 0x2b10 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2b20 */
 32, 32, 48, 48, 48, 48, 48, 50, 54, 98, 32, 32, 50, 42, 42, 48,   /* 0x2b30 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x2b40 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 56, 32,   /* 0x2b50 */
 78, 50, 69, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x2b60 */
 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x2b70 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2b80 */
 48, 50, 55, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x2b90 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x2ba0 */
 68, 79, 78, 76, 89, 10, 32, 52, 57, 32, 78, 50, 69, 68, 69, 67,   /* 0x2bb0 */
 51, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 53,102,   /* 0x2bc0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x2bd0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 56, 55, 32, 32,   /* 0x2be0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x2bf0 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x2c00 */
 32, 53, 48, 32, 78, 50, 69, 83, 77, 65, 52, 48, 32, 32, 32, 32,   /* 0x2c10 */
 32, 32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48,   /* 0x2c20 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2c30 */
 48, 48, 48, 48, 48, 50,101, 54, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x2c40 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x2c50 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 49, 32, 78, 50,   /* 0x2c60 */
 69, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2c70 */
 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2c80 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,   /* 0x2c90 */
102, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x2ca0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x2cb0 */
 78, 76, 89, 10, 32, 53, 50, 32, 78, 50, 69, 83, 77, 65, 53, 48,   /* 0x2cc0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,   /* 0x2cd0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2ce0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 48, 50, 32, 32, 50, 42,   /* 0x2cf0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x2d00 */
 65, 68, 79, 78, 76, 89, 10, 32, 53, 51, 32, 78, 50, 69, 70, 65,   /* 0x2d10 */
 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2d20 */
 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2d30 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 48, 52, 32,   /* 0x2d40 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2d50 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 52, 32, 78, 50,   /* 0x2d60 */
 69, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x2d70 */
 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2d80 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,   /* 0x2d90 */
 48, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x2da0 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 53,   /* 0x2db0 */
 32, 78, 50, 69, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x2dc0 */
 48, 48, 48, 48, 48, 48, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x2dd0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2de0 */
 48, 48, 51, 49, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x2df0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x2e00 */
 65, 68, 79, 78, 76, 89, 10, 32, 53, 54, 32, 78, 50, 69, 70, 65,   /* 0x2e10 */
 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,   /* 0x2e20 */
 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x2e30 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 49, 99, 32,   /* 0x2e40 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x2e50 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2e60 */
 10, 32, 53, 55, 32, 78, 50, 69, 70, 65, 83, 54, 49, 32, 32, 32,   /* 0x2e70 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48,   /* 0x2e80 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2e90 */
 32, 48, 48, 48, 48, 48, 51, 51, 53, 32, 32, 50, 42, 42, 48, 32,   /* 0x2ea0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x2eb0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 56, 32, 78,   /* 0x2ec0 */
 50, 69, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x2ed0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2ee0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x2ef0 */
 51, 52, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x2f00 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53,   /* 0x2f10 */
 57, 32, 67, 76, 49, 83, 77, 65, 49, 66, 32, 32, 32, 32, 32, 32,   /* 0x2f20 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2f30 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x2f40 */
 48, 48, 48, 51, 52, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x2f50 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x2f60 */
 10, 32, 54, 48, 32, 67, 76, 49, 70, 65, 83, 49, 66, 32, 32, 32,   /* 0x2f70 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48,   /* 0x2f80 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x2f90 */
 32, 48, 48, 48, 48, 48, 51, 52,100, 32, 32, 50, 42, 42, 48, 32,   /* 0x2fa0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x2fb0 */
 78, 76, 89, 10, 32, 54, 49, 32, 67, 76, 49, 71, 69, 84, 49, 66,   /* 0x2fc0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x2fd0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x2fe0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 53, 51, 32, 32, 50, 42,   /* 0x2ff0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x3000 */
 65, 68, 79, 78, 76, 89, 10, 32, 54, 50, 32, 67, 76, 49, 69, 78,   /* 0x3010 */
 84, 69, 82, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3020 */
 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3030 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 53, 51, 32,   /* 0x3040 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x3050 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x3060 */
 10, 32, 54, 51, 32, 67, 76, 49, 83, 77, 65, 49, 48, 32, 32, 32,   /* 0x3070 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48,   /* 0x3080 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3090 */
 32, 48, 48, 48, 48, 48, 51, 53, 57, 32, 32, 50, 42, 42, 48, 32,   /* 0x30a0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x30b0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54, 52, 32, 67,   /* 0x30c0 */
 76, 49, 82, 76, 79, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x30d0 */
 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x30e0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x30f0 */
 51, 53,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x3100 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54,   /* 0x3110 */
 53, 32, 67, 76, 49, 87, 73, 68, 48, 49, 32, 32, 32, 32, 32, 32,   /* 0x3120 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3130 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3140 */
 48, 48, 48, 51, 54, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3150 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x3160 */
 10, 32, 54, 54, 32, 67, 76, 49, 87, 73, 68, 48, 50, 32, 32, 32,   /* 0x3170 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x3180 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3190 */
 32, 48, 48, 48, 48, 48, 51, 54, 56, 32, 32, 50, 42, 42, 48, 32,   /* 0x31a0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x31b0 */
 78, 76, 89, 10, 32, 54, 55, 32, 67, 76, 49, 87, 73, 68, 48, 51,   /* 0x31c0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,   /* 0x31d0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x31e0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 54, 97, 32, 32, 50, 42,   /* 0x31f0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x3200 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 54,   /* 0x3210 */
 56, 32, 67, 76, 49, 87, 73, 68, 48, 52, 32, 32, 32, 32, 32, 32,   /* 0x3220 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3230 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3240 */
 48, 48, 48, 51, 54, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3250 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x3260 */
 10, 32, 54, 57, 32, 67, 76, 49, 87, 73, 68, 48, 53, 32, 32, 32,   /* 0x3270 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x3280 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3290 */
 32, 48, 48, 48, 48, 48, 51, 54,101, 32, 32, 50, 42, 42, 48, 32,   /* 0x32a0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x32b0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 48, 32, 67,   /* 0x32c0 */
 76, 49, 87, 73, 68, 48, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x32d0 */
 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x32e0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x32f0 */
 51, 55, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x3300 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55,   /* 0x3310 */
 49, 32, 67, 76, 49, 87, 73, 68, 48, 55, 32, 32, 32, 32, 32, 32,   /* 0x3320 */
 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3330 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3340 */
 48, 48, 48, 51, 55, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3350 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x3360 */
 10, 32, 55, 50, 32, 67, 76, 49, 87, 73, 68, 48, 56, 32, 32, 32,   /* 0x3370 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 97, 32, 32, 48, 48, 48,   /* 0x3380 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3390 */
 32, 48, 48, 48, 48, 48, 51, 55, 53, 32, 32, 50, 42, 42, 48, 32,   /* 0x33a0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x33b0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 51, 32, 67,   /* 0x33c0 */
 76, 49, 87, 73, 68, 48, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x33d0 */
 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x33e0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x33f0 */
 51, 56,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x3400 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55,   /* 0x3410 */
 52, 32, 67, 76, 49, 87, 73, 68, 49, 48, 32, 32, 32, 32, 32, 32,   /* 0x3420 */
 48, 48, 48, 48, 48, 48, 49, 49, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3430 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3440 */
 48, 48, 48, 51, 57, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3450 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x3460 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 53, 32, 67, 76, 49, 83,   /* 0x3470 */
 84, 65, 82, 84, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3480 */
 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3490 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 97, 50,   /* 0x34a0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x34b0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 54, 32, 67,   /* 0x34c0 */
 76, 49, 84, 79, 80, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x34d0 */
 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x34e0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x34f0 */
 51, 97, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x3500 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55,   /* 0x3510 */
 55, 32, 67, 76, 49, 84, 79, 80, 48, 49, 32, 32, 32, 32, 32, 32,   /* 0x3520 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3530 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3540 */
 48, 48, 48, 51, 97, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3550 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x3560 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 56, 32, 67, 76, 49, 84,   /* 0x3570 */
 79, 80, 48, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3580 */
 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3590 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 97, 99,   /* 0x35a0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x35b0 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x35c0 */
 89, 10, 32, 55, 57, 32, 67, 76, 49, 84, 79, 80, 48, 51, 32, 32,   /* 0x35d0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48,   /* 0x35e0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x35f0 */
 32, 32, 48, 48, 48, 48, 48, 51, 97,101, 32, 32, 50, 42, 42, 48,   /* 0x3600 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x3610 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 48, 32,   /* 0x3620 */
 67, 76, 49, 84, 79, 80, 48, 52, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x3630 */
 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x3640 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x3650 */
 48, 51, 98, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x3660 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x3670 */
 68, 79, 78, 76, 89, 10, 32, 56, 49, 32, 67, 76, 49, 84, 79, 80,   /* 0x3680 */
 48, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51,   /* 0x3690 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x36a0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 98, 53, 32, 32,   /* 0x36b0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x36c0 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x36d0 */
 32, 56, 50, 32, 67, 76, 49, 84, 79, 80, 48, 54, 32, 32, 32, 32,   /* 0x36e0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48,   /* 0x36f0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3700 */
 48, 48, 48, 48, 48, 51, 98, 56, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3710 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3720 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 51, 32, 67, 76,   /* 0x3730 */
 49, 84, 79, 80, 48, 55, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3740 */
 48, 48, 49, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3750 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,   /* 0x3760 */
 98,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3770 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 52,   /* 0x3780 */
 32, 67, 76, 49, 79, 70, 70, 48, 49, 32, 32, 32, 32, 32, 32, 48,   /* 0x3790 */
 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x37a0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x37b0 */
 48, 48, 51,100, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x37c0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x37d0 */
 32, 56, 53, 32, 67, 76, 49, 79, 70, 70, 48, 50, 32, 32, 32, 32,   /* 0x37e0 */
 32, 32, 48, 48, 48, 48, 48, 48, 49, 50, 32, 32, 48, 48, 48, 48,   /* 0x37f0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3800 */
 48, 48, 48, 48, 48, 51,100, 56, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x3810 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x3820 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 54, 32, 67, 76,   /* 0x3830 */
 49, 79, 70, 70, 48, 51, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3840 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3850 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,   /* 0x3860 */
101, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3870 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 55,   /* 0x3880 */
 32, 67, 76, 49, 79, 70, 70, 48, 52, 32, 32, 32, 32, 32, 32, 48,   /* 0x3890 */
 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x38a0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x38b0 */
 48, 48, 51,101, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x38c0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x38d0 */
 65, 68, 79, 78, 76, 89, 10, 32, 56, 56, 32, 67, 76, 49, 76, 69,   /* 0x38e0 */
 78, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x38f0 */
 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3900 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,102, 48, 32,   /* 0x3910 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x3920 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 57, 32, 67, 76,   /* 0x3930 */
 49, 76, 69, 78, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3940 */
 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3950 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,   /* 0x3960 */
102, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3970 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 48,   /* 0x3980 */
 32, 67, 76, 49, 76, 69, 78, 48, 50, 32, 32, 32, 32, 32, 32, 48,   /* 0x3990 */
 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x39a0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x39b0 */
 48, 48, 51,102, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x39c0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x39d0 */
 65, 68, 79, 78, 76, 89, 10, 32, 57, 49, 32, 67, 76, 49, 67, 79,   /* 0x39e0 */
 80, 89, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51,   /* 0x39f0 */
 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3a00 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,102, 56, 32,   /* 0x3a10 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x3a20 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x3a30 */
 10, 32, 57, 50, 32, 67, 76, 49, 69, 78, 68, 32, 32, 32, 32, 32,   /* 0x3a40 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3a50 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3a60 */
 32, 48, 48, 48, 48, 48, 52, 50, 98, 32, 32, 50, 42, 42, 48, 32,   /* 0x3a70 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x3a80 */
 78, 76, 89, 10, 32, 57, 51, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3a90 */
 48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50,101, 32, 32,   /* 0x3aa0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3ab0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 50, 98, 32, 32, 50, 42,   /* 0x3ac0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x3ad0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57,   /* 0x3ae0 */
 52, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32,   /* 0x3af0 */
 48, 48, 48, 48, 48, 48, 52, 56, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3b00 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3b10 */
 48, 48, 48, 52, 53, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3b20 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x3b30 */
 10, 32, 57, 53, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32,   /* 0x3b40 */
 32, 32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32, 32, 48, 48, 48,   /* 0x3b50 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3b60 */
 32, 48, 48, 48, 48, 48, 52, 97, 49, 32, 32, 50, 42, 42, 48, 32,   /* 0x3b70 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x3b80 */
 78, 76, 89, 10, 32, 57, 54, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3b90 */
 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 97, 56, 54, 32, 32,   /* 0x3ba0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3bb0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48,102, 50, 55, 32, 32, 50, 42,   /* 0x3bc0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x3bd0 */
 65, 68, 79, 78, 76, 89, 10, 32, 57, 55, 32, 76, 90, 77, 65, 95,   /* 0x3be0 */
 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,   /* 0x3bf0 */
 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3c00 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 97,100, 32,   /* 0x3c10 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x3c20 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 56, 32, 67, 65,   /* 0x3c30 */
 76, 76, 84, 82, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3c40 */
 48, 48, 48,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3c50 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,   /* 0x3c60 */
 99, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3c70 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x3c80 */
 78, 76, 89, 10, 32, 57, 57, 32, 67, 84, 67, 76, 69, 86, 69, 49,   /* 0x3c90 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32,   /* 0x3ca0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3cb0 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,100, 53, 32, 32, 50, 42,   /* 0x3cc0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x3cd0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48,   /* 0x3ce0 */
 48, 32, 67, 65, 76, 76, 84, 82, 48, 49, 32, 32, 32, 32, 32, 32,   /* 0x3cf0 */
 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3d00 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3d10 */
 48, 48, 49, 57,100, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3d20 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x3d30 */
 10, 49, 48, 49, 32, 67, 84, 66, 83, 72, 82, 48, 49, 32, 32, 32,   /* 0x3d40 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48,   /* 0x3d50 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3d60 */
 32, 48, 48, 48, 48, 49, 57,100,102, 32, 32, 50, 42, 42, 48, 32,   /* 0x3d70 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x3d80 */
 78, 76, 89, 10, 49, 48, 50, 32, 67, 84, 66, 82, 79, 82, 48, 49,   /* 0x3d90 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,   /* 0x3da0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3db0 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,101, 51, 32, 32, 50, 42,   /* 0x3dc0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x3dd0 */
 65, 68, 79, 78, 76, 89, 10, 49, 48, 51, 32, 67, 84, 66, 83, 87,   /* 0x3de0 */
 65, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x3df0 */
 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x3e00 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,101, 53, 32,   /* 0x3e10 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x3e20 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48, 52, 32, 67, 65,   /* 0x3e30 */
 76, 76, 84, 82, 48, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x3e40 */
 48, 48, 48,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x3e50 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,   /* 0x3e60 */
101, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x3e70 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x3e80 */
 78, 76, 89, 10, 49, 48, 53, 32, 67, 65, 76, 76, 84, 82, 49, 48,   /* 0x3e90 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32,   /* 0x3ea0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3eb0 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 57,102, 56, 32, 32, 50, 42,   /* 0x3ec0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x3ed0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48,   /* 0x3ee0 */
 54, 32, 67, 65, 76, 76, 84, 82, 69, 56, 32, 32, 32, 32, 32, 32,   /* 0x3ef0 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3f00 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x3f10 */
 48, 48, 49, 57,102,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x3f20 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x3f30 */
 10, 49, 48, 55, 32, 67, 65, 76, 76, 84, 82, 69, 57, 32, 32, 32,   /* 0x3f40 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x3f50 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x3f60 */
 32, 48, 48, 48, 48, 49, 57,102,102, 32, 32, 50, 42, 42, 48, 32,   /* 0x3f70 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x3f80 */
 78, 76, 89, 10, 49, 48, 56, 32, 67, 65, 76, 76, 84, 82, 49, 49,   /* 0x3f90 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32,   /* 0x3fa0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x3fb0 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 48, 49, 32, 32, 50, 42,   /* 0x3fc0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x3fd0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 48,   /* 0x3fe0 */
 57, 32, 67, 84, 67, 76, 69, 86, 69, 50, 32, 32, 32, 32, 32, 32,   /* 0x3ff0 */
 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x4000 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x4010 */
 48, 48, 49, 97, 48, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x4020 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x4030 */
 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 48, 32, 67, 65, 76, 76,   /* 0x4040 */
 84, 82, 49, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x4050 */
 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x4060 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 48, 97,   /* 0x4070 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x4080 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49, 49, 32, 67,   /* 0x4090 */
 84, 66, 83, 72, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x40a0 */
 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x40b0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x40c0 */
 97, 48, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x40d0 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49,   /* 0x40e0 */
 50, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32, 32, 32, 32, 32, 32,   /* 0x40f0 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x4100 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x4110 */
 48, 48, 49, 97, 49, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x4120 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x4130 */
 10, 49, 49, 51, 32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 32, 32,   /* 0x4140 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48,   /* 0x4150 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4160 */
 32, 48, 48, 48, 48, 49, 97, 49, 50, 32, 32, 50, 42, 42, 48, 32,   /* 0x4170 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x4180 */
 78, 76, 89, 10, 49, 49, 52, 32, 67, 65, 76, 76, 84, 82, 49, 51,   /* 0x4190 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32,   /* 0x41a0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x41b0 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 49, 55, 32, 32, 50, 42,   /* 0x41c0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x41d0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 49, 49,   /* 0x41e0 */
 53, 32, 76, 69, 88, 69, 67, 48, 49, 53, 32, 32, 32, 32, 32, 32,   /* 0x41f0 */
 48, 48, 48, 48, 48, 48, 49, 98, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x4200 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x4210 */
 48, 48, 49, 97, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x4220 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x4230 */
 10, 49, 49, 54, 32, 76, 69, 88, 69, 67, 48, 49, 55, 32, 32, 32,   /* 0x4240 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x4250 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4260 */
 32, 48, 48, 48, 48, 49, 97, 51, 55, 32, 32, 50, 42, 42, 48, 32,   /* 0x4270 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x4280 */
 78, 76, 89, 10, 49, 49, 55, 32, 76, 69, 88, 69, 67, 48, 50, 48,   /* 0x4290 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51, 49, 32, 32,   /* 0x42a0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x42b0 */
 48, 48, 32, 32, 48, 48, 48, 48, 49, 97, 51, 57, 32, 32, 50, 42,   /* 0x42c0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x42d0 */
 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65,   /* 0x42e0 */
 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x42f0 */
 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48,  9, 48,   /* 0x4300 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 49, 48,   /* 0x4310 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4320 */
 32, 32, 78, 50, 66, 70, 65, 83, 49, 49,  9, 48, 48, 48, 48, 48,   /* 0x4330 */
 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 49, 49, 10, 48, 48, 48,   /* 0x4340 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4350 */
 66, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4360 */
 78, 50, 66, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4370 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67,   /* 0x4380 */
 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68,   /* 0x4390 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x43a0 */
 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48,  9, 48,   /* 0x43b0 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 51, 48,   /* 0x43c0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x43d0 */
 32, 32, 78, 50, 66, 68, 69, 67, 53, 48,  9, 48, 48, 48, 48, 48,   /* 0x43e0 */
 48, 48, 48, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 48, 48, 48,   /* 0x43f0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4400 */
 66, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4410 */
 78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4420 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67,   /* 0x4430 */
 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 68,   /* 0x4440 */
 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4450 */
 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48,  9, 48,   /* 0x4460 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 49, 48,   /* 0x4470 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4480 */
 32, 32, 78, 50, 68, 70, 65, 83, 49, 49,  9, 48, 48, 48, 48, 48,   /* 0x4490 */
 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 48, 48, 48,   /* 0x44a0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x44b0 */
 68, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x44c0 */
 78, 50, 68, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x44d0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67,   /* 0x44e0 */
 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68,   /* 0x44f0 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4500 */
 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,  9, 48,   /* 0x4510 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 51, 48,   /* 0x4520 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4530 */
 32, 32, 78, 50, 68, 68, 69, 67, 53, 48,  9, 48, 48, 48, 48, 48,   /* 0x4540 */
 48, 48, 48, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 48, 48, 48,   /* 0x4550 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4560 */
 68, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4570 */
 78, 50, 68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4580 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67,   /* 0x4590 */
 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 68,   /* 0x45a0 */
 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x45b0 */
 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48,  9, 48,   /* 0x45c0 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 49, 48,   /* 0x45d0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x45e0 */
 32, 32, 78, 50, 69, 70, 65, 83, 49, 49,  9, 48, 48, 48, 48, 48,   /* 0x45f0 */
 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 49, 49, 10, 48, 48, 48,   /* 0x4600 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4610 */
 69, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4620 */
 78, 50, 69, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4630 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67,   /* 0x4640 */
 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68,   /* 0x4650 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4660 */
 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,  9, 48,   /* 0x4670 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 51, 48,   /* 0x4680 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4690 */
 32, 32, 78, 50, 69, 68, 69, 67, 53, 48,  9, 48, 48, 48, 48, 48,   /* 0x46a0 */
 48, 48, 48, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48,   /* 0x46b0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x46c0 */
 69, 70, 65, 83, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x46d0 */
 78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x46e0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67,   /* 0x46f0 */
 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 68,   /* 0x4700 */
 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4710 */
 32, 32, 32,100, 32, 32, 67, 76, 49, 82, 76, 79, 65, 68,  9, 48,   /* 0x4720 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 82, 76, 79, 65, 68,   /* 0x4730 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4740 */
 32, 32, 67, 76, 49, 87, 73, 68, 48, 49,  9, 48, 48, 48, 48, 48,   /* 0x4750 */
 48, 48, 48, 32, 67, 76, 49, 87, 73, 68, 48, 49, 10, 48, 48, 48,   /* 0x4760 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76,   /* 0x4770 */
 49, 87, 73, 68, 48, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4780 */
 67, 76, 49, 87, 73, 68, 48, 54, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4790 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73, 68,   /* 0x47a0 */
 48, 56,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 87,   /* 0x47b0 */
 73, 68, 48, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x47c0 */
 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73, 68, 49, 48,  9, 48,   /* 0x47d0 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 87, 73, 68, 49, 48,   /* 0x47e0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x47f0 */
 32, 32, 67, 76, 49, 83, 84, 65, 82, 84,  9, 48, 48, 48, 48, 48,   /* 0x4800 */
 48, 48, 48, 32, 67, 76, 49, 83, 84, 65, 82, 84, 10, 48, 48, 48,   /* 0x4810 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76,   /* 0x4820 */
 49, 84, 79, 80, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4830 */
 67, 76, 49, 84, 79, 80, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4840 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 84, 79, 80,   /* 0x4850 */
 48, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 84,   /* 0x4860 */
 79, 80, 48, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4870 */
 32, 32, 32,100, 32, 32, 67, 76, 49, 84, 79, 80, 48, 55,  9, 48,   /* 0x4880 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 84, 79, 80, 48, 55,   /* 0x4890 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x48a0 */
 32, 32, 67, 76, 49, 76, 69, 78, 48, 48,  9, 48, 48, 48, 48, 48,   /* 0x48b0 */
 48, 48, 48, 32, 67, 76, 49, 76, 69, 78, 48, 48, 10, 48, 48, 48,   /* 0x48c0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76,   /* 0x48d0 */
 49, 67, 79, 80, 89, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x48e0 */
 67, 76, 49, 67, 79, 80, 89, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x48f0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,   /* 0x4900 */
 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76,   /* 0x4910 */
 84, 82, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4920 */
 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48,  9, 48,   /* 0x4930 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 48,   /* 0x4940 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4950 */
 32, 32, 67, 65, 76, 76, 84, 82, 49, 49,  9, 48, 48, 48, 48, 48,   /* 0x4960 */
 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 49, 10, 48, 48, 48,   /* 0x4970 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65,   /* 0x4980 */
 76, 76, 84, 82, 49, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4990 */
 67, 65, 76, 76, 84, 82, 49, 51, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x49a0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48,   /* 0x49b0 */
 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 69, 88, 69,   /* 0x49c0 */
 67, 48, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x49d0 */
 32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48, 48, 48,  9, 48,   /* 0x49e0 */
 48, 48, 48, 48, 48, 48, 48, 32, 76, 69, 88, 69, 67, 48, 48, 48,   /* 0x49f0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4a00 */
 32, 32, 76, 69, 88, 69, 67, 48, 49, 48,  9, 48, 48, 48, 48, 48,   /* 0x4a10 */
 48, 48, 48, 32, 76, 69, 88, 69, 67, 48, 49, 48, 10, 48, 48, 48,   /* 0x4a20 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4a30 */
 66, 70, 65, 83, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4a40 */
 78, 50, 66, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4a50 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65,   /* 0x4a60 */
 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83,   /* 0x4a70 */
 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4a80 */
 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 50, 48,  9, 48,   /* 0x4a90 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 50, 48,   /* 0x4aa0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4ab0 */
 32, 32, 78, 50, 66, 83, 77, 65, 51, 48,  9, 48, 48, 48, 48, 48,   /* 0x4ac0 */
 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 51, 48, 10, 48, 48, 48,   /* 0x4ad0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4ae0 */
 66, 70, 65, 83, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4af0 */
 78, 50, 66, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4b00 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65,   /* 0x4b10 */
 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83,   /* 0x4b20 */
 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4b30 */
 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 52, 48,  9, 48,   /* 0x4b40 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 52, 48,   /* 0x4b50 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4b60 */
 32, 32, 78, 50, 66, 83, 77, 65, 53, 48,  9, 48, 48, 48, 48, 48,   /* 0x4b70 */
 48, 48, 48, 32, 78, 50, 66, 83, 77, 65, 53, 48, 10, 48, 48, 48,   /* 0x4b80 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4b90 */
 66, 70, 65, 83, 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4ba0 */
 78, 50, 66, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4bb0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65,   /* 0x4bc0 */
 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 83,   /* 0x4bd0 */
 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4be0 */
 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 48,  9, 48,   /* 0x4bf0 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 70, 65, 83, 54, 48,   /* 0x4c00 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4c10 */
 32, 32, 78, 50, 68, 70, 65, 83, 49, 48,  9, 48, 48, 48, 48, 48,   /* 0x4c20 */
 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 49, 48, 10, 48, 48, 48,   /* 0x4c30 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4c40 */
 68, 83, 77, 65, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4c50 */
 78, 50, 68, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4c60 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83,   /* 0x4c70 */
 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70,   /* 0x4c80 */
 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4c90 */
 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 51, 48,  9, 48,   /* 0x4ca0 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 51, 48,   /* 0x4cb0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4cc0 */
 32, 32, 78, 50, 68, 70, 65, 83, 51, 48,  9, 48, 48, 48, 48, 48,   /* 0x4cd0 */
 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 51, 48, 10, 48, 48, 48,   /* 0x4ce0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4cf0 */
 68, 83, 77, 65, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4d00 */
 78, 50, 68, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4d10 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83,   /* 0x4d20 */
 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70,   /* 0x4d30 */
 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4d40 */
 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 53, 48,  9, 48,   /* 0x4d50 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 83, 77, 65, 53, 48,   /* 0x4d60 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4d70 */
 32, 32, 78, 50, 68, 70, 65, 83, 53, 48,  9, 48, 48, 48, 48, 48,   /* 0x4d80 */
 48, 48, 48, 32, 78, 50, 68, 70, 65, 83, 53, 48, 10, 48, 48, 48,   /* 0x4d90 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4da0 */
 68, 83, 77, 65, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4db0 */
 78, 50, 68, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4dc0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83,   /* 0x4dd0 */
 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 70,   /* 0x4de0 */
 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4df0 */
 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 48,  9, 48,   /* 0x4e00 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 49, 48,   /* 0x4e10 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4e20 */
 32, 32, 78, 50, 69, 83, 77, 65, 50, 48,  9, 48, 48, 48, 48, 48,   /* 0x4e30 */
 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 50, 48, 10, 48, 48, 48,   /* 0x4e40 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4e50 */
 69, 70, 65, 83, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4e60 */
 78, 50, 69, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4e70 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65,   /* 0x4e80 */
 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83,   /* 0x4e90 */
 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4ea0 */
 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 51, 48,  9, 48,   /* 0x4eb0 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 51, 48,   /* 0x4ec0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4ed0 */
 32, 32, 78, 50, 69, 83, 77, 65, 52, 48,  9, 48, 48, 48, 48, 48,   /* 0x4ee0 */
 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 52, 48, 10, 48, 48, 48,   /* 0x4ef0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4f00 */
 69, 70, 65, 83, 52, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4f10 */
 78, 50, 69, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4f20 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65,   /* 0x4f30 */
 53, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 83,   /* 0x4f40 */
 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x4f50 */
 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 53, 48,  9, 48,   /* 0x4f60 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 70, 65, 83, 53, 48,   /* 0x4f70 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x4f80 */
 32, 32, 78, 50, 69, 83, 77, 65, 54, 48,  9, 48, 48, 48, 48, 48,   /* 0x4f90 */
 48, 48, 48, 32, 78, 50, 69, 83, 77, 65, 54, 48, 10, 48, 48, 48,   /* 0x4fa0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,   /* 0x4fb0 */
 69, 70, 65, 83, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x4fc0 */
 78, 50, 69, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x4fd0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 83, 77, 65,   /* 0x4fe0 */
 49, 66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 83,   /* 0x4ff0 */
 77, 65, 49, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x5000 */
 32, 32, 32,100, 32, 32, 67, 76, 49, 70, 65, 83, 49, 66,  9, 48,   /* 0x5010 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 70, 65, 83, 49, 66,   /* 0x5020 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x5030 */
 32, 32, 67, 76, 49, 71, 69, 84, 49, 66,  9, 48, 48, 48, 48, 48,   /* 0x5040 */
 48, 48, 48, 32, 67, 76, 49, 71, 69, 84, 49, 66, 10, 48, 48, 48,   /* 0x5050 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76,   /* 0x5060 */
 49, 69, 78, 84, 69, 82,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5070 */
 67, 76, 49, 69, 78, 84, 69, 82, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5080 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 83, 77, 65,   /* 0x5090 */
 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 83,   /* 0x50a0 */
 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x50b0 */
 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73, 68, 48, 50,  9, 48,   /* 0x50c0 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 87, 73, 68, 48, 50,   /* 0x50d0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x50e0 */
 32, 32, 67, 76, 49, 87, 73, 68, 48, 51,  9, 48, 48, 48, 48, 48,   /* 0x50f0 */
 48, 48, 48, 32, 67, 76, 49, 87, 73, 68, 48, 51, 10, 48, 48, 48,   /* 0x5100 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76,   /* 0x5110 */
 49, 87, 73, 68, 48, 52,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5120 */
 67, 76, 49, 87, 73, 68, 48, 52, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5130 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73, 68,   /* 0x5140 */
 48, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 87,   /* 0x5150 */
 73, 68, 48, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x5160 */
 32, 32, 32,100, 32, 32, 67, 76, 49, 87, 73, 68, 48, 55,  9, 48,   /* 0x5170 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 87, 73, 68, 48, 55,   /* 0x5180 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x5190 */
 32, 32, 67, 76, 49, 87, 73, 68, 48, 57,  9, 48, 48, 48, 48, 48,   /* 0x51a0 */
 48, 48, 48, 32, 67, 76, 49, 87, 73, 68, 48, 57, 10, 48, 48, 48,   /* 0x51b0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76,   /* 0x51c0 */
 49, 84, 79, 80, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x51d0 */
 67, 76, 49, 84, 79, 80, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x51e0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 84, 79, 80,   /* 0x51f0 */
 48, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 84,   /* 0x5200 */
 79, 80, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x5210 */
 32, 32, 32,100, 32, 32, 67, 76, 49, 84, 79, 80, 48, 51,  9, 48,   /* 0x5220 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 84, 79, 80, 48, 51,   /* 0x5230 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x5240 */
 32, 32, 67, 76, 49, 84, 79, 80, 48, 52,  9, 48, 48, 48, 48, 48,   /* 0x5250 */
 48, 48, 48, 32, 67, 76, 49, 84, 79, 80, 48, 52, 10, 48, 48, 48,   /* 0x5260 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76,   /* 0x5270 */
 49, 84, 79, 80, 48, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5280 */
 67, 76, 49, 84, 79, 80, 48, 53, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5290 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 79, 70, 70,   /* 0x52a0 */
 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 79,   /* 0x52b0 */
 70, 70, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x52c0 */
 32, 32, 32,100, 32, 32, 67, 76, 49, 79, 70, 70, 48, 50,  9, 48,   /* 0x52d0 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 79, 70, 70, 48, 50,   /* 0x52e0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x52f0 */
 32, 32, 67, 76, 49, 79, 70, 70, 48, 51,  9, 48, 48, 48, 48, 48,   /* 0x5300 */
 48, 48, 48, 32, 67, 76, 49, 79, 70, 70, 48, 51, 10, 48, 48, 48,   /* 0x5310 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76,   /* 0x5320 */
 49, 79, 70, 70, 48, 52,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5330 */
 67, 76, 49, 79, 70, 70, 48, 52, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5340 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 49, 76, 69, 78,   /* 0x5350 */
 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 76,   /* 0x5360 */
 69, 78, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x5370 */
 32, 32, 32,100, 32, 32, 67, 76, 49, 76, 69, 78, 48, 50,  9, 48,   /* 0x5380 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 49, 76, 69, 78, 48, 50,   /* 0x5390 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x53a0 */
 32, 32, 67, 76, 49, 69, 78, 68,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x53b0 */
 48, 32, 67, 76, 49, 69, 78, 68, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x53c0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x53d0 */
 69, 67, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90,   /* 0x53e0 */
 77, 65, 95, 68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x53f0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69,   /* 0x5400 */
 76, 70, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90,   /* 0x5410 */
 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5420 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x5430 */
 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90,   /* 0x5440 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5450 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x5460 */
 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90,   /* 0x5470 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5480 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x5490 */
 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90,   /* 0x54a0 */
 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x54b0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86,   /* 0x54c0 */
 69, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 67, 76,   /* 0x54d0 */
 69, 86, 69, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x54e0 */
 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 49,  9, 48,   /* 0x54f0 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 49,   /* 0x5500 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x5510 */
 32, 32, 67, 84, 66, 83, 72, 82, 48, 49,  9, 48, 48, 48, 48, 48,   /* 0x5520 */
 48, 48, 48, 32, 67, 84, 66, 83, 72, 82, 48, 49, 10, 48, 48, 48,   /* 0x5530 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,   /* 0x5540 */
 66, 82, 79, 82, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5550 */
 67, 84, 66, 82, 79, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5560 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65,   /* 0x5570 */
 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83,   /* 0x5580 */
 87, 65, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x5590 */
 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 50,  9, 48,   /* 0x55a0 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 48, 50,   /* 0x55b0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x55c0 */
 32, 32, 67, 65, 76, 76, 84, 82, 69, 56,  9, 48, 48, 48, 48, 48,   /* 0x55d0 */
 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 69, 56, 10, 48, 48, 48,   /* 0x55e0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65,   /* 0x55f0 */
 76, 76, 84, 82, 69, 57,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5600 */
 67, 65, 76, 76, 84, 82, 69, 57, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x5610 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86,   /* 0x5620 */
 69, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 67, 76,   /* 0x5630 */
 69, 86, 69, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x5640 */
 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 50,  9, 48,   /* 0x5650 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 50,   /* 0x5660 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x5670 */
 32, 32, 67, 84, 66, 83, 72, 82, 49, 49,  9, 48, 48, 48, 48, 48,   /* 0x5680 */
 48, 48, 48, 32, 67, 84, 66, 83, 72, 82, 49, 49, 10, 48, 48, 48,   /* 0x5690 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,   /* 0x56a0 */
 66, 82, 79, 82, 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x56b0 */
 67, 84, 66, 82, 79, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x56c0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65,   /* 0x56d0 */
 49, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 66, 83,   /* 0x56e0 */
 87, 65, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x56f0 */
 32, 32, 32,100, 32, 32, 76, 69, 88, 69, 67, 48, 49, 53,  9, 48,   /* 0x5700 */
 48, 48, 48, 48, 48, 48, 48, 32, 76, 69, 88, 69, 67, 48, 49, 53,   /* 0x5710 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x5720 */
 32, 32, 76, 69, 88, 69, 67, 48, 49, 55,  9, 48, 48, 48, 48, 48,   /* 0x5730 */
 48, 48, 48, 32, 76, 69, 88, 69, 67, 48, 49, 55, 10, 48, 48, 48,   /* 0x5740 */
 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 76, 69,   /* 0x5750 */
 88, 69, 67, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5760 */
 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x5770 */
 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,   /* 0x5780 */
 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,115,116, 97, 99,   /* 0x5790 */
107, 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x57a0 */
 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,   /* 0x57b0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,117, 95,   /* 0x57c0 */
108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,   /* 0x57d0 */
 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,   /* 0x57e0 */
 48, 48, 48, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48,   /* 0x57f0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5800 */
 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x5810 */
122,109, 97, 95,112,114,111,112,101,114,116,105,101,115, 10, 48,   /* 0x5820 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5830 */
 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,   /* 0x5840 */
105,108,116,101,114, 95,108,101,110,103,116,104, 10, 48, 48, 48,   /* 0x5850 */
 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,   /* 0x5860 */
 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,   /* 0x5870 */
116,101,114, 95, 99,116,111, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x5880 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x5890 */
 91, 76, 69, 88, 69, 67, 48, 48, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x58a0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x58b0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x58c0 */
 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,   /* 0x58d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 69, 88, 69, 67, 48, 50, 48,   /* 0x58e0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x58f0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65,   /* 0x5900 */
 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x5910 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5920 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,   /* 0x5930 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5940 */
 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x5950 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x5960 */
 82, 32, 91, 78, 50, 66, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70,   /* 0x5970 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x5980 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x5990 */
 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x59a0 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67,   /* 0x59b0 */
 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x59c0 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83,   /* 0x59d0 */
 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x59e0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x59f0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0x5a00 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x5a10 */
 32, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76,   /* 0x5a20 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x5a30 */
 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 50, 48, 93, 58, 10,   /* 0x5a40 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x5a50 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x5a60 */
 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,   /* 0x5a70 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70,   /* 0x5a80 */
 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x5a90 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,   /* 0x5aa0 */
 66, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x5ab0 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5ac0 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x5ad0 */
 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x5ae0 */
 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82,   /* 0x5af0 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x5b00 */
 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 51, 48, 93,   /* 0x5b10 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x5b20 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x5b30 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56,   /* 0x5b40 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x5b50 */
 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32,   /* 0x5b60 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x5b70 */
 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79,   /* 0x5b80 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x5b90 */
 79, 82, 32, 91, 78, 50, 66, 68, 69, 67, 51, 48, 93, 58, 10, 79,   /* 0x5ba0 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x5bb0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x5bc0 */
 48, 48, 48, 48, 48, 48, 49, 49, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x5bd0 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,   /* 0x5be0 */
 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 50,102, 32, 82, 95, 51,   /* 0x5bf0 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x5c00 */
 50, 66, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x5c10 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x5c20 */
 91, 78, 50, 66, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x5c30 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x5c40 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x5c50 */
 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x5c60 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48,   /* 0x5c70 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x5c80 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83,   /* 0x5c90 */
 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x5ca0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5cb0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,   /* 0x5cc0 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5cd0 */
 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x5ce0 */
 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x5cf0 */
 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 10, 82,   /* 0x5d00 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x5d10 */
 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 54, 48, 93,   /* 0x5d20 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x5d30 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x5d40 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56,   /* 0x5d50 */
 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x5d60 */
 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x5d70 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x5d80 */
 78, 50, 66, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x5d90 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5da0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x5db0 */
 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x5dc0 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10,   /* 0x5dd0 */
 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x5de0 */
 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,   /* 0x5df0 */
 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x5e00 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,   /* 0x5e10 */
 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x5e20 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5e30 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49,   /* 0x5e40 */
 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,   /* 0x5e50 */
 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69,   /* 0x5e60 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x5e70 */
 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 49, 48, 93, 58,   /* 0x5e80 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x5e90 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x5ea0 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,   /* 0x5eb0 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,   /* 0x5ec0 */
 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x5ed0 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,   /* 0x5ee0 */
 50, 68, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x5ef0 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x5f00 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x5f10 */
 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x5f20 */
 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10,   /* 0x5f30 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x5f40 */
 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 50, 48,   /* 0x5f50 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x5f60 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x5f70 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,   /* 0x5f80 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x5f90 */
 50, 68, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x5fa0 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x5fb0 */
 91, 78, 50, 68, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x5fc0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x5fd0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x5fe0 */
 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x5ff0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49,   /* 0x6000 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x6010 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65,   /* 0x6020 */
 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x6030 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6040 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82,   /* 0x6050 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6060 */
 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x6070 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x6080 */
 82, 32, 91, 78, 50, 68, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70,   /* 0x6090 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x60a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x60b0 */
 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x60c0 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67,   /* 0x60d0 */
 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56,   /* 0x60e0 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x60f0 */
 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x6100 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x6110 */
 78, 50, 68, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x6120 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6130 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x6140 */
 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x6150 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48, 10,   /* 0x6160 */
 48, 48, 48, 48, 48, 48, 50, 49, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x6170 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,   /* 0x6180 */
 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 52, 51, 32, 82, 95, 51,   /* 0x6190 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x61a0 */
 50, 68, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x61b0 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x61c0 */
 91, 78, 50, 68, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x61d0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x61e0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x61f0 */
 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x6200 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,   /* 0x6210 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x6220 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83,   /* 0x6230 */
 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x6240 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6250 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,   /* 0x6260 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6270 */
 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x6280 */
 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x6290 */
 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82,   /* 0x62a0 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x62b0 */
 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 54, 48, 93,   /* 0x62c0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x62d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x62e0 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56,   /* 0x62f0 */
 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x6300 */
 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x6310 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x6320 */
 78, 50, 68, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x6330 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6340 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x6350 */
 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x6360 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49, 10,   /* 0x6370 */
 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x6380 */
 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,   /* 0x6390 */
 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x63a0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,   /* 0x63b0 */
 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x63c0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x63d0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49,   /* 0x63e0 */
 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,   /* 0x63f0 */
 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69,   /* 0x6400 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x6410 */
 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 49, 48, 93, 58,   /* 0x6420 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x6430 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x6440 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,   /* 0x6450 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,   /* 0x6460 */
 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x6470 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,   /* 0x6480 */
 50, 69, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x6490 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x64a0 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x64b0 */
 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x64c0 */
 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10,   /* 0x64d0 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x64e0 */
 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 50, 48,   /* 0x64f0 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x6500 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x6510 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,   /* 0x6520 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x6530 */
 50, 69, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x6540 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x6550 */
 91, 78, 50, 69, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x6560 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x6570 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x6580 */
 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x6590 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49,   /* 0x65a0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x65b0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65,   /* 0x65c0 */
 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x65d0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x65e0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82,   /* 0x65f0 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6600 */
 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x6610 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x6620 */
 82, 32, 91, 78, 50, 69, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70,   /* 0x6630 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x6640 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x6650 */
 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x6660 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67,   /* 0x6670 */
 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56,   /* 0x6680 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x6690 */
 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x66a0 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x66b0 */
 78, 50, 69, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x66c0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x66d0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x66e0 */
 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x66f0 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48, 10,   /* 0x6700 */
 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x6710 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,   /* 0x6720 */
 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 51,   /* 0x6730 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x6740 */
 50, 69, 68, 69, 67, 54, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x6750 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x6760 */
 91, 78, 50, 69, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x6770 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x6780 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x6790 */
 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x67a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,   /* 0x67b0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x67c0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83,   /* 0x67d0 */
 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x67e0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x67f0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,   /* 0x6800 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6810 */
 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x6820 */
 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x6830 */
 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82,   /* 0x6840 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x6850 */
 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 54, 48, 93,   /* 0x6860 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x6870 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x6880 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56,   /* 0x6890 */
 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,   /* 0x68a0 */
 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x68b0 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x68c0 */
 78, 50, 69, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x68d0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x68e0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x68f0 */
 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x6900 */
 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10,   /* 0x6910 */
 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x6920 */
 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,   /* 0x6930 */
 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x6940 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,   /* 0x6950 */
 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x6960 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6970 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49,   /* 0x6980 */
 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,   /* 0x6990 */
 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69,   /* 0x69a0 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x69b0 */
 32, 70, 79, 82, 32, 91, 67, 76, 49, 69, 78, 84, 69, 82, 93, 58,   /* 0x69c0 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x69d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x69e0 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54,   /* 0x69f0 */
 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49,   /* 0x6a00 */
 83, 84, 65, 82, 84, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x6a10 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67,   /* 0x6a20 */
 76, 49, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x6a30 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6a40 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x6a50 */
 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x6a60 */
 32, 32, 32, 32, 32, 32, 67, 76, 49, 82, 76, 79, 65, 68, 10, 10,   /* 0x6a70 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x6a80 */
 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 87, 73, 68, 48, 51,   /* 0x6a90 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x6aa0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x6ab0 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,   /* 0x6ac0 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67,   /* 0x6ad0 */
 76, 49, 87, 73, 68, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x6ae0 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x6af0 */
 91, 67, 76, 49, 87, 73, 68, 48, 53, 93, 58, 10, 79, 70, 70, 83,   /* 0x6b00 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x6b10 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x6b20 */
 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x6b30 */
 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 87, 73, 68, 49, 48,   /* 0x6b40 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x6b50 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 87, 73, 68,   /* 0x6b60 */
 48, 56, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x6b70 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6b80 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82,   /* 0x6b90 */
 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6ba0 */
 32, 67, 76, 49, 87, 73, 68, 48, 54, 10, 48, 48, 48, 48, 48, 48,   /* 0x6bb0 */
 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x6bc0 */
 32, 32, 32, 32, 32, 67, 76, 49, 87, 73, 68, 49, 48, 10, 48, 48,   /* 0x6bd0 */
 48, 48, 48, 48, 49, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,   /* 0x6be0 */
 50, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 67, 79, 80, 89,   /* 0x6bf0 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x6c00 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 87, 73,   /* 0x6c10 */
 68, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x6c20 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6c30 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32,   /* 0x6c40 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x6c50 */
 32, 32, 67, 76, 49, 84, 79, 80, 48, 55, 10, 48, 48, 48, 48, 48,   /* 0x6c60 */
 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x6c70 */
 32, 32, 32, 32, 32, 32, 67, 76, 49, 87, 73, 68, 48, 56, 10, 48,   /* 0x6c80 */
 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x6c90 */
 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80,   /* 0x6ca0 */
 48, 55, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x6cb0 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 84,   /* 0x6cc0 */
 79, 80, 48, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x6cd0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6ce0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0x6cf0 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x6d00 */
 32, 32, 32, 67, 76, 49, 84, 79, 80, 48, 55, 10, 10, 82, 69, 76,   /* 0x6d10 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x6d20 */
 70, 79, 82, 32, 91, 67, 76, 49, 84, 79, 80, 48, 50, 93, 58, 10,   /* 0x6d30 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x6d40 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x6d50 */
 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,   /* 0x6d60 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 84,   /* 0x6d70 */
 79, 80, 48, 55, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x6d80 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76,   /* 0x6d90 */
 49, 84, 79, 80, 48, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x6da0 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6db0 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x6dc0 */
 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x6dd0 */
 32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80, 48, 55, 10, 10, 82,   /* 0x6de0 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x6df0 */
 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 84, 79, 80, 48, 52, 93,   /* 0x6e00 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x6e10 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x6e20 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,   /* 0x6e30 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76,   /* 0x6e40 */
 49, 84, 79, 80, 48, 55, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x6e50 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x6e60 */
 67, 76, 49, 84, 79, 80, 48, 53, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x6e70 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6e80 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x6e90 */
 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x6ea0 */
 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80, 48, 54, 10,   /* 0x6eb0 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x6ec0 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 84, 79, 80, 48,   /* 0x6ed0 */
 54, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x6ee0 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x6ef0 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95,   /* 0x6f00 */
 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6f10 */
 67, 76, 49, 87, 73, 68, 48, 49, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x6f20 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x6f30 */
 32, 91, 67, 76, 49, 79, 70, 70, 48, 50, 93, 58, 10, 79, 70, 70,   /* 0x6f40 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x6f50 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x6f60 */
 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0x6f70 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80, 48,   /* 0x6f80 */
 55, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54,   /* 0x6f90 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49,   /* 0x6fa0 */
 67, 79, 80, 89, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x6fb0 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67,   /* 0x6fc0 */
 76, 49, 79, 70, 70, 48, 52, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x6fd0 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x6fe0 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x6ff0 */
 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x7000 */
 32, 32, 32, 32, 32, 32, 67, 76, 49, 67, 79, 80, 89, 48, 10, 10,   /* 0x7010 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x7020 */
 68, 83, 32, 70, 79, 82, 32, 91, 67, 76, 49, 76, 69, 78, 48, 50,   /* 0x7030 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x7040 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x7050 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,   /* 0x7060 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67,   /* 0x7070 */
 76, 49, 76, 69, 78, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x7080 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x7090 */
 91, 67, 76, 49, 67, 79, 80, 89, 48, 93, 58, 10, 79, 70, 70, 83,   /* 0x70a0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x70b0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x70c0 */
 48, 48, 48, 50, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50,   /* 0x70d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 67, 76, 49, 84, 79, 80, 48, 48,   /* 0x70e0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x70f0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68,   /* 0x7100 */
 69, 67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x7110 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x7120 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53,   /* 0x7130 */
 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,   /* 0x7140 */
 32, 32, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,   /* 0x7150 */
106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95,   /* 0x7160 */
 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x7170 */
108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48,   /* 0x7180 */
 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,   /* 0x7190 */
 32, 32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110,   /* 0x71a0 */
 10, 48, 48, 48, 48, 48, 48, 50, 97, 32, 82, 95, 51, 56, 54, 95,   /* 0x71b0 */
 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97,   /* 0x71c0 */
 95,112,114,111,112,101,114,116,105,101,115, 10, 10, 82, 69, 76,   /* 0x71d0 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x71e0 */
 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 48, 48, 93, 58, 10,   /* 0x71f0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x7200 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x7210 */
 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,   /* 0x7220 */
 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,   /* 0x7230 */
101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67,   /* 0x7240 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x7250 */
 82, 32, 91, 67, 84, 67, 76, 69, 86, 69, 49, 93, 58, 10, 79, 70,   /* 0x7260 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x7270 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x7280 */
 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32,   /* 0x7290 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114,   /* 0x72a0 */
 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95,   /* 0x72b0 */
 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x72c0 */
 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x72d0 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x72e0 */
 32, 91, 67, 65, 76, 76, 84, 82, 48, 50, 93, 58, 10, 79, 70, 70,   /* 0x72f0 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x7300 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x7310 */
 48, 48, 48, 48, 48,100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0x7320 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48,   /* 0x7330 */
 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x7340 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84,   /* 0x7350 */
 82, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x7360 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x7370 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,   /* 0x7380 */
 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x7390 */
 32, 32,102,105,108,116,101,114, 95,108,101,110,103,116,104, 10,   /* 0x73a0 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x73b0 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49,   /* 0x73c0 */
 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x73d0 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x73e0 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95,   /* 0x73f0 */
 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x7400 */
 67, 65, 76, 76, 84, 82, 49, 51, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x7410 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x7420 */
 32, 91, 67, 84, 67, 76, 69, 86, 69, 50, 93, 58, 10, 79, 70, 70,   /* 0x7430 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x7440 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x7450 */
 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32,   /* 0x7460 */
 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,   /* 0x7470 */
 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51,   /* 0x7480 */
 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67,   /* 0x7490 */
 65, 76, 76, 84, 82, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x74a0 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x74b0 */
 91, 67, 65, 76, 76, 84, 82, 49, 51, 93, 58, 10, 79, 70, 70, 83,   /* 0x74c0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x74d0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x74e0 */
 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,   /* 0x74f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48,   /* 0x7500 */
 10                                                                /* 0x7510 */
};
