/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.ITypeParameter;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.AndPattern;

public class TypeReferencePattern
extends AndPattern
implements IIndexConstants {
    protected char[] qualification;
    protected char[] simpleName;
    protected char[] currentCategory;
    public int segmentsSize;
    protected char[][] segments;
    protected int currentSegment;
    protected static char[][] CATEGORIES = new char[][]{IIndexConstants.REF};

    public TypeReferencePattern(char[] qualification, char[] simpleName, int matchRule) {
        this(matchRule);
        this.qualification = this.isCaseSensitive() ? qualification : CharOperation.toLowerCase(qualification);
        char[] cArray = this.simpleName = this.isCaseSensitive() ? simpleName : CharOperation.toLowerCase(simpleName);
        this.segments = (char[][])(simpleName == null ? (this.qualification == null ? IIndexConstants.ONE_STAR_CHAR : CharOperation.splitOn('.', this.qualification)) : null);
        this.segmentsSize = this.segments == null ? (this.qualification == null ? 0 : CharOperation.occurencesOf('.', this.qualification) + 1) : this.segments.length;
        this.mustResolve = true;
    }

    public TypeReferencePattern(char[] qualification, char[] simpleName, String signature, int matchRule) {
        this(qualification, simpleName, matchRule);
        if (signature != null) {
            this.computeSignature(signature);
        }
    }

    public TypeReferencePattern(char[] qualification, char[] simpleName, IType type, int matchRule) {
        this(qualification, simpleName, matchRule);
        this.typeArguments = this.typeParameterNames(type);
    }

    TypeReferencePattern(int matchRule) {
        super(4, matchRule);
    }

    public void decodeIndexKey(char[] key) {
        this.simpleName = key;
    }

    public SearchPattern getBlankPattern() {
        return new TypeReferencePattern(8);
    }

    public char[] getIndexKey() {
        if (this.simpleName != null) {
            return this.simpleName;
        }
        if (this.currentSegment >= 0) {
            return this.segments[this.currentSegment];
        }
        return null;
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    protected boolean hasNextQuery() {
        if (this.segments == null) {
            return false;
        }
        return --this.currentSegment >= (this.segments.length >= 4 ? 2 : 0);
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    protected void resetQuery() {
        if (this.segments != null) {
            this.currentSegment = this.segments.length - 1;
        }
    }

    protected StringBuffer print(StringBuffer output) {
        output.append("TypeReferencePattern: qualification<");
        if (this.qualification != null) {
            output.append(this.qualification);
        } else {
            output.append("*");
        }
        output.append(">, type<");
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        output.append(">");
        return super.print(output);
    }

    private char[][][] typeParameterNames(IType type) {
        char[][][] typeParameters = new char[10][][];
        int ptr = -1;
        boolean hasParameters = false;
        try {
            IJavaElement parent = type;
            ITypeParameter[] parameters = null;
            while (parent != null) {
                IType parentType;
                int length;
                if (parent.getElementType() != 7) {
                    if (!hasParameters) {
                        return null;
                    }
                    if (++ptr < typeParameters.length) {
                        char[][][] cArray = typeParameters;
                        typeParameters = new char[ptr][][];
                        System.arraycopy(cArray, 0, typeParameters, 0, ptr);
                    }
                    return typeParameters;
                }
                if (++ptr > typeParameters.length) {
                    char[][][] cArray = typeParameters;
                    typeParameters = new char[typeParameters.length + 10][][];
                    System.arraycopy(cArray, 0, typeParameters, 0, ptr);
                }
                int n = length = (parameters = (parentType = parent).getTypeParameters()) == null ? 0 : parameters.length;
                if (length > 0) {
                    hasParameters = true;
                    typeParameters[ptr] = new char[length][];
                    int i = 0;
                    while (i < length) {
                        typeParameters[ptr][i] = Signature.createTypeSignature(parameters[i].getElementName(), false).toCharArray();
                        ++i;
                    }
                }
                parent = parent.getParent();
            }
        }
        catch (JavaModelException jme) {
            return null;
        }
        if (!hasParameters) {
            return null;
        }
        if (++ptr < typeParameters.length) {
            char[][][] cArray = typeParameters;
            typeParameters = new char[ptr][][];
            System.arraycopy(cArray, 0, typeParameters, 0, ptr);
        }
        return typeParameters;
    }
}

