/*
 *  command_line.cc -- BabyTrans ( Babylon Translator front-end for GTK )
 *
 *  Copyright (C) 1999  Frederic Jolliton -- <fjolliton@fnac.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cstddef>
#include <string>

#ifdef HONOR_STD
using std::string ;
#endif

#include "command_line.h"
#include "str_format.h"

#ifdef ENABLE_NLS
# include <libintl.h>
# define _(str) gettext(str)
#else
# define _(str) (str)
#endif
#define N_(str) (str)

cmdline_parser::cmdline_parser( option_item* option_list ,
                                size_t option_number ,
                                int argc , char** argv )
{
    my_index = 0 ;
    my_argc = argc ;
    my_argv = argv ;
    my_option_list = option_list ;
    my_option_number = option_number ;
    my_cur_arg = 1 ;
    my_cur_arg_index = 0 ;
    my_bad = false ;

    if ( argc < 0 )
        my_bad = true ;
}

bool
cmdline_parser::next()
{
    if ( bad() || end() )
        return false ;

    const char*         current = my_argv[ my_cur_arg ] ;

    if ( my_cur_arg_index == 0 ) {
        size_t              len = strlen( current ) ;
        if ( len == 0 ) {
            /* huh ? */
            return false ;
        }
        if ( len == 1 ) {
            set_bad_msg( str_format( _( "Unrecognized option `%1'\n" ) )
                         .with( current ) ) ;
            return false ;
        }
        if ( current[ 0 ] != '-' ) {
            set_bad_msg( str_format( _( "Unrecognized option `%1'\n" ) )
                         .with( current ) ) ;
            return false ;
        }
        if ( current[ 1 ] == '-' ) { /* long option */
            int                 skip = 1 ;
            size_t              i ;
            const char*         cur_negate = NULL ;
            if ( len > 5 && strncmp( current + 2 , "no-" , 3 ) == 0 ) {
                cur_negate = current + 5 ;
            }
            bool                neg_result = false ;
            for ( i = 0 ; i < my_option_number ; ++ i ) {
                if ( my_option_list[ i ].long_name == 0 )
                    continue ;
                if ( strcmp( current + 2 ,
                             my_option_list[ i ].long_name ) == 0 )
                    break ;
                if ( my_option_list[ i ].can_negate
                     && cur_negate != NULL
                     && strcmp( cur_negate ,
                                my_option_list[ i ].long_name ) == 0 ) {
                    neg_result = true ;
                    break ;
                }
            }
            if ( i == my_option_number ) {
                set_bad_msg( str_format( _( "Unrecognized option `%1'\n" ) )
                             .with( current ) ) ;
                return false ;
            }
            if ( neg_result ) {
                set( current + 2 , string() , i ) ;
            } else if ( my_option_list[ i ].narg == 1 ) {
                if ( my_cur_arg + 1 >= my_argc ) {
                    set_bad_msg( str_format( _( "option `%1' requires"
                                             " an argument\n" ) )
                                 .with( current ) ) ;
                    return false ;
                }
                set( current + 2 , my_argv[ my_cur_arg + 1 ] , i ) ;
                ++ skip ;
            } else {
                set( current + 2 , "true" , i ) ;
            }
            my_cur_arg += skip ;
            return true ;
        }
        /* short option */
        my_cur_arg_index = 1 ;
    }

    char                c = current[ my_cur_arg_index ] ;
    size_t              i ;
    for ( i = 0 ; i < my_option_number ; ++ i ) {
        if ( my_option_list[ i ].short_name == 0 )
            continue ;
        if ( my_option_list[ i ].short_name == c )
            break ;
    }
    if ( i == my_option_number ) {
        set_bad_msg( str_format( _( "Unrecognized option `%1'\n" ) )
                     .with( string( "-" ) + c ) ) ;
        return false ;
    }
    if ( my_option_list[ i ].narg == 1 ) {
        if ( current[ my_cur_arg_index + 1 ] != 0 ) {
            set( string() + c ,
                 string( current + my_cur_arg_index + 1 ) ,
                 i ) ;
            my_cur_arg_index = 0 ;
            ++ my_cur_arg ;
        } else {
            if ( my_cur_arg + 1 >= my_argc ) {
                set_bad_msg( str_format( _( "option `%1' requires"
                                         " an argument\n" ) )
                             .with( string( "-" ) + c ) ) ;
                return false ;
            }
            set( string() + c , my_argv[ my_cur_arg + 1 ] , i ) ;
            my_cur_arg_index = 0 ;
            my_cur_arg += 2 ;
        }
    } else {
        set( string() + c , "true" , i ) ;
        ++ my_cur_arg_index ;
        if ( current[ my_cur_arg_index ] == 0 ) {
            my_cur_arg_index = 0 ;
            ++ my_cur_arg ;
        }
    }
    return true ;
}
