/*
 *  file_parser.h -- BabyTrans ( Babylon Translator front-end for GTK )
 *
 *  Copyright (C) 1999  Frederic Jolliton -- <fjolliton@fnac.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef FILE_PARSER_H
#define FILE_PARSER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <string>
#include <vector>

#ifdef HONOR_STD
using std::vector ;
using std::string ;
using std::istream ;
#endif

enum file_parser_status {
    file_parser_ok = 0 ,
    file_parser_eof = 1 ,
    file_parser_syntax_error = 2 ,
    file_parser_io_error = 3
} ;

file_parser_status read_config_line( istream& is , vector<string>& option ) ;

#endif /* FILE_PARSER_H */
