/****************************************************************************
**
** Copyright (C) 2002-2006 Tilo Riemer <riemer@crossvc.com>,
**                         Frank Hemer <frank@hemer.at>,
**                         Jose Hernandez <joseh@tesco.net> and
**                         Joerg Preiss <auba@auba.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef CVSLIB_CVSCONFIG_OLD_H_20061216
#define CVSLIB_CVSCONFIG_OLD_H_20061216

//----------------------------------------------------------------------------

#include "config.h"

//----------------------------------------------------------------------------

#include <qrect.h>
#include <qsettings.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qmessagebox.h>
#include <qcolor.h>

//----------------------------------------------------------------------------

#include "globals.h"
#include "TextCodec.h"

//----------------------------------------------------------------------------


/*!	This class implements all configurable Items of lincvs.
  \brief Configuration class.
*/
class CvsConfigOld
{
   static const char Version[];
   static const char Debug[];
   static const char LogLevel[];
   static const char CheckStatusIntervall[];
   static const char CheckStatusLevel[];
   static const char ProgressIntervall[];

   static const char AutoUpdate[];
   static const char AutoUpdateIntervall[];

   static const char cvsPassFile[];
   static const char cvsPath[];
   static const char cvsVersion[];
   static const char useDirWatch[];

   static const char DirPopupMenu[];
   static const char FilePopupMenu[];
   static const char KeyboarsShortcuts[];
   static const char OpenFileList[];
   static const char ViewFileList[];
   static const char ScanOnTheFly[];
   static const char ScanNonCvs[];
   static const char CvsIgnoreFiles[];
   static const char UseExternalDiff[];
   static const char ExtDiffProgram[];
   static const char IconDir[];
   static const char ColorRevA[];
   static const char ColorRevB[];
   static const char UseStandardDialogs[];
   static const char DateTimeOrder[];
   static const char DateTimeFormat[];
   static const char Use0AsParent[];
   static const char TopLevelWidget[];
   
   static const char GeomX[];
   static const char GeomY[];
   static const char GeomWidth[];
   static const char GeomHeight[];
   static const char SplitterPosH[];
   static const char SplitterPosV[];
   static const char WorkbenchColumnWidth[];
   static const char ToolbarPos[];
   static const char FileHeaderPos[];

   static const char Compression[];
   static const char RwPermission[];
   static const char VirtualInFiletab[];
   static const char DiffPrecision[];
   static const char UnifiedDiffOutput[];

   static const char PruneDirs[];
   static const char BringOverNewDirs[];
   static const char KeywordSuppression[];
   static const char IgnoreWhiteSpace[];
   static const char HistoryPeriod[];
   static const char Quiet[];

   static const char SshKeyList[];
   static const char SshAgent[];
   static const char RemoteBrowser[];
   static const char LocalBrowser[];
   static const char CVSRsh[];
   static const char LocalShell[];

   static const char UserList[];
   static const char ServerList[];
   static const char RepositoryList[];
   static const char ProfileList[];
   static const char XProfileList[];
   static const char ModuleList[];
   static const char WorkdirList[];
   static const char CheckoutAsList[];
   static const char ProxyList[];
   static const char BinaryFileSpecList[];

   static const char HistSizeComments[];
   static const char HistSizeWorkdirs[];
   static const char HistSizeProfiles[];

   static const char Projects[];

   //Syntax highlighting of messagewidget
   static const char UseSyntaxHighlight[];
   static const char SynHighQuestionMarkStyle[];
   static const char SynHighQuestionMarkRgb[];
   static const char SynHighModifiedStyle[];
   static const char SynHighModifiedRgb[];
   static const char SynHighNeedsUpdateStyle[];
   static const char SynHighNeedsUpdateRgb[];
   static const char SynHighMergingStyle[];
   static const char SynHighMergingRgb[];
   static const char SynHighConflictStyle[];
   static const char SynHighConflictRgb[];
   static const char SynHighAddedStyle[];
   static const char SynHighAddedRgb[];
   static const char SynHighRemovedStyle[];
   static const char SynHighRemovedRgb[];
   static const char SynHighRemovedByOtherStyle[];
   static const char SynHighRemovedByOtherRgb[];
   static const char SynHighDiffOldStyle[];
   static const char SynHighDiffOldRgb[];
   static const char SynHighDiffNewStyle[];
   static const char SynHighDiffNewRgb[];
   static const char SynHighScmErrStyle[];
   static const char SynHighScmErrRgb[];

   //fonts
   static const char FontGeneral[];
   static const char FontMessage[];
   static const char FontDiff[];

   //i18n
   static const char TextEncoder[];
   static const char TextDecoder[];
   
   //defaults
   static const char defCvsPath[];
   static const char defCvsVersion[];
   static const char defSshAgent[];
   static const char defRemoteBrowser[];
   static const char defLocalBrowser[];
   static const char defCvsRsh[];
   static const char defLocalShell[];
   static const char defCvsIgnoreFiles[];
   static const char defKeyboarsShortcuts[];
   static const char defOpenFileList[];
   static const char defViewFileList[];

      
public:
   CvsConfigOld();
   ~CvsConfigOld();


   void readCfg();

   bool debug() {
      return m_pSettings->readBoolEntry(Debug, false);
   }
   Debug::LogLevel logLevel() {
      switch (m_pSettings->readNumEntry(LogLevel, 0)) {
	 case 0:  return Debug::LL_LIKE_A_FISH;
	 case 1:  return Debug::LL_THE_OLD_MAN_AND_THE_SEA;
	 case 2:  return Debug::LL_INFO;
	 case 3:  return Debug::LL_DEBUG;
	 case 4:  return Debug::LL_GOSSIP_MONGER;
	 default: return Debug::LL_LIKE_A_FISH;
      }
   }
   QString getCvsPassPath() {
      return m_pSettings->readEntry(cvsPassFile, CVSPASSPATH);
   }
   QString getCvsPath() {
      return m_pSettings->readEntry(cvsPath, defCvsPath);
   }
   QString getCvsVersion() {
      return m_pSettings->readEntry(cvsVersion, defCvsVersion);
   }
   bool getUseDirWatch() {
      return m_pSettings->readBoolEntry(useDirWatch, false);
   }
   long checkStatusIntervall() {
      return m_pSettings->readNumEntry(CheckStatusIntervall, 3000L);
   }
   int getCheckStatusLevel() {
      return m_pSettings->readNumEntry(CheckStatusLevel, 1);
   }
   long progressIntervall() {
      return m_pSettings->readNumEntry(ProgressIntervall, 117L);
   }
   bool getAutoUpdate() {
      return m_pSettings->readBoolEntry(AutoUpdate, false);
   }
   long getAutoUpdateIntervall() {
      return m_pSettings->readNumEntry(AutoUpdateIntervall, 30L);
   }
   int splitterPosH() {
      return m_pSettings->readNumEntry(SplitterPosH, 150);
   }
   int splitterPosV() {
      return m_pSettings->readNumEntry(SplitterPosV, 150);
   }
   int workbenchColumnWidth() {
      return m_pSettings->readNumEntry(WorkbenchColumnWidth, 150);
   }
   QString getToolbarPos() {
      return m_pSettings->readEntry(ToolbarPos, "");
   }
   QString getFileHeaderPos() {
      return m_pSettings->readEntry(FileHeaderPos, "");
   }
	
   int compression() {
      return m_pSettings->readNumEntry(Compression, 0);
   }
   bool rwPermission() {
      return m_pSettings->readBoolEntry(RwPermission, true);
   }
   bool getShowVirtualInFiletab() {
      return m_pSettings->readBoolEntry(VirtualInFiletab, true);
   }
   int getDiffPrecision() {
      return m_pSettings->readNumEntry(DiffPrecision,2);
   }
   bool getUnifiedDiffOutput() {
      return m_pSettings->readBoolEntry(UnifiedDiffOutput, true);
   }
   bool pruneDirs() {
      return m_pSettings->readBoolEntry(PruneDirs, true);
   }
   bool bringOverNewDirs() {
      return m_pSettings->readBoolEntry(BringOverNewDirs, true);
   }
   bool keywordSuppression() {
      return m_pSettings->readBoolEntry(KeywordSuppression, true);
   }
   bool getIgnoreWhiteSpace() {
      return m_pSettings->readBoolEntry(IgnoreWhiteSpace, false);
   }
   int getHistoryPeriod() {
      return m_pSettings->readNumEntry(HistoryPeriod, -1);
   }
   bool getQuiet() {
      return m_pSettings->readBoolEntry(Quiet, false);
   }

   bool useExtDiff() {
      return m_pSettings->readBoolEntry(UseExternalDiff, false);
   }
   QStringList getSshKeyList() {
      QStringList list = m_pSettings->readListEntry(SshKeyList);
      return list;
   }
   QString sshAgent() {
      return m_pSettings->readEntry(SshAgent, defSshAgent);
   }
   QString extDiffProgram() {
      return m_pSettings->readEntry(ExtDiffProgram, "");
   }
   QString localBrowser() {
      return m_pSettings->readEntry(LocalBrowser, defLocalBrowser);
   }
   QString remoteBrowser() {
      return m_pSettings->readEntry(RemoteBrowser, defRemoteBrowser);
   }
   QString localShell() {
      return m_pSettings->readEntry(LocalShell, defLocalShell);
   }
   QString CvsRsh() {
      return m_pSettings->readEntry(CVSRsh, defCvsRsh);
   }
   QRect geometry() {
      return QRect(geomX(), geomY(), geomWidth(), geomHeight());
   }
   QString dirPopupMenu() {
      return m_pSettings->readEntry(DirPopupMenu, DEFDIRPOPUPMENU);
   }
   QString filePopupMenu() {
      return m_pSettings->readEntry(FilePopupMenu, DEFFILEPOPUPMENU);
   }
   QString getKeyboardShortcuts() {
      return m_pSettings->readEntry(KeyboarsShortcuts,defKeyboarsShortcuts);
   }
   QStringList getOpenFileList() {
      QStringList list = m_pSettings->readListEntry(OpenFileList);
      if (list.count() == 0) list.append(defOpenFileList);
      return list;
   }
   QStringList getViewFileList() {
      QStringList list = m_pSettings->readListEntry(ViewFileList);
      if (list.count() == 0) list.append(defViewFileList);
      return list;
   }
   bool getOnTheFlyScanning() {
      return m_pSettings->readBoolEntry(ScanOnTheFly, false);
   }
   bool getScanNonCvs() {
      return m_pSettings->readBoolEntry(ScanNonCvs, true);
   }
   QString cvsIgnoreFiles() {
      return m_pSettings->readEntry(CvsIgnoreFiles, defCvsIgnoreFiles);
   }
   QString iconDirectory() {
      return m_pSettings->readEntry(IconDir, "");
   }

   int colorRev(bool bRevARevB_01) {//false: RevA; true: RevB
      if (bRevARevB_01) {
         return m_pSettings->readNumEntry(ColorRevA, 0x00ff0000L);
      } else {
         return m_pSettings->readNumEntry(ColorRevB, 0x0000ff00L);
      }
   }

   bool getStdDlg() {
      return m_pSettings->readBoolEntry(UseStandardDialogs, true);
   }
   int getDateTimeOrder() {
      return m_pSettings->readNumEntry(DateTimeOrder, QDateEdit().order());
   }
   QString getDateTimeFormat() {
      return m_pSettings->readEntry(DateTimeFormat, "yyyy/MM/dd hh:mm:ss");
   }
   bool get0AsParent() {
      return m_pSettings->readBoolEntry(Use0AsParent, true);
   }
   bool getTopLevelW() {
      return m_pSettings->readBoolEntry(TopLevelWidget, true);
   }
   unsigned int historySizeComments() {
      return m_pSettings->readNumEntry(HistSizeComments, 20);
   }
   unsigned int historySizeWorkdirs() {
      return m_pSettings->readNumEntry(HistSizeWorkdirs, 20);
   }
   unsigned int historySizeProfiles() {
      return m_pSettings->readNumEntry(HistSizeProfiles, 20);
   }
   QStringList userList() {
      return m_pSettings->readListEntry(UserList);
   }   
   QStringList serverList() {
      return m_pSettings->readListEntry(ServerList);
   }   
   QStringList repositoryList() {
      return m_pSettings->readListEntry(RepositoryList);
   }   
   QStringList profileList() {
      return m_pSettings->readListEntry(ProfileList);
   }   
   QStringList xprofileList() {
      return m_pSettings->readListEntry(XProfileList);
   }   
   QStringList moduleList() {
      return m_pSettings->readListEntry(ModuleList);
   }   
   QStringList workdirList() {
      return m_pSettings->readListEntry(WorkdirList);
   }   
   QStringList getCheckoutAsList() {
      return m_pSettings->readListEntry(CheckoutAsList);
   }   
   QStringList getProxyList() {
      return m_pSettings->readListEntry(ProxyList);
   }   
   QStringList getBinaryFileSpecList() {
      return m_pSettings->readListEntry(BinaryFileSpecList);
   }   

   //syntax highlighting   
   bool getUseSyntaxHighlighting() {
      return m_pSettings->readBoolEntry(UseSyntaxHighlight, true);
   }
   HighlightProperties::FontStyle getQuestionMarkStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighQuestionMarkStyle, HighlightProperties::FS_NORMAL);
   }
   QColor getQuestionMarkColor() {
      QColor c(Qt::gray);
      c.setRgb(m_pSettings->readNumEntry(SynHighQuestionMarkRgb, c.rgb()));
      return c;
   }
   HighlightProperties::FontStyle getModifiedStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighModifiedStyle, HighlightProperties::FS_NORMAL);
   }
   QColor getModifiedColor() {
      QColor c(Qt::red);
      c.setRgb(m_pSettings->readNumEntry(SynHighModifiedRgb, c.rgb()));
      return c;
   }
   HighlightProperties::FontStyle getNeedsUpdateStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighNeedsUpdateStyle, HighlightProperties::FS_NORMAL);
   }
   QColor getNeedsUpdateColor() {
      QColor c(Qt::blue);
      c.setRgb(m_pSettings->readNumEntry(SynHighNeedsUpdateRgb, c.rgb()));
      return c;
   }
   HighlightProperties::FontStyle getMergingStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighMergingStyle, HighlightProperties::FS_ITALIC);
   }
   QColor getMergingColor() {
      QColor c(Qt::blue);
      c.setRgb(m_pSettings->readNumEntry(SynHighMergingRgb, c.rgb()));
      return c;
   }
   HighlightProperties::FontStyle getConflictStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighConflictStyle, HighlightProperties::FS_BOLD);
   }
   QColor getConflictColor() {
      QColor c(Qt::magenta);
      c.setRgb(m_pSettings->readNumEntry(SynHighConflictRgb, c.rgb()));
      return c;
   }
   HighlightProperties::FontStyle getAddedStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighAddedStyle, HighlightProperties::FS_BOLD | HighlightProperties::FS_ITALIC);
   }
   QColor getAddedColor() {
      QColor c(Qt::red);
      c.setRgb(m_pSettings->readNumEntry(SynHighAddedRgb, c.rgb()));
      return c;
   }
   HighlightProperties::FontStyle getRemovedStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighRemovedStyle, HighlightProperties::FS_NORMAL);
   }
   QColor getRemovedColor() {
      QColor c(Qt::cyan);
      c.setRgb(m_pSettings->readNumEntry(SynHighRemovedRgb, c.rgb()));
      return c;
   }
   HighlightProperties::FontStyle getRemovedByOtherStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighRemovedByOtherStyle, HighlightProperties::FS_BOLD);
   }
   QColor getRemovedByOtherColor() {
      QColor c(Qt::green);
      c.setRgb(m_pSettings->readNumEntry(SynHighRemovedByOtherRgb, c.rgb()));
      return c;
   }
   HighlightProperties::FontStyle getDiffOldStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighDiffOldStyle, HighlightProperties::FS_NORMAL);
   }
   QColor getDiffOldColor() {
      QColor c(Qt::red);
      c.setRgb(m_pSettings->readNumEntry(SynHighDiffOldRgb, c.rgb()));
      return c;
   }
   HighlightProperties::FontStyle getDiffNewStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighDiffNewStyle, HighlightProperties::FS_NORMAL);
   }
   QColor getDiffNewColor() {
      QColor c(Qt::blue);
      c.setRgb(m_pSettings->readNumEntry(SynHighDiffNewRgb, c.rgb()));
      return c;
   }
   HighlightProperties::FontStyle getScmErrStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighScmErrStyle, HighlightProperties::FS_BOLD);
   }
   QColor getScmErrColor() {
      QColor c(Qt::red);
      c.setRgb(m_pSettings->readNumEntry(SynHighScmErrRgb, c.rgb()));
      return c;
   }
   
   QString getFontGeneral() {
      return m_pSettings->readEntry(FontGeneral, "");  //empty string means default font
   }
   QString getFontMessage() {
      return m_pSettings->readEntry(FontMessage, "");  //empty string means default font
   }
   QString getFontDiff() {
      return m_pSettings->readEntry(FontDiff, "");  //empty string means default font
   }

   QString getTextEncoder() {
      return m_pSettings->readEntry(TextEncoder, TextCodec::DEFAULT_CODEC);  //we should use codec for locale
   }
   QString getTextDecoder() {
      return m_pSettings->readEntry(TextDecoder, TextCodec::DEFAULT_CODEC);  //we should use codec for locale
   }
   
 protected:
   int geomX() {
      return m_pSettings->readNumEntry(GeomX, 50);
   }
   int geomY() {
      return m_pSettings->readNumEntry(GeomY, 50);
   }
   int geomWidth() {
      return m_pSettings->readNumEntry(GeomWidth, 400);
   }
   int geomHeight() {
      return m_pSettings->readNumEntry(GeomHeight, 300);
   }

protected:

   QSettings* m_pSettings;

private:
      
   void readProjectSettings( QString);
   void removeProjectSettings( QString);
   
   void updateVersionOnRead(const QString&,const QString&);
   void readProfiles(QStringList tmpList);
   
   void readExtApps();
   
   Mapping::FileAppList extractMapping(const QStringList&);
   QStringList joinMapping(const Mapping::FileAppList&);
   bool m_needUpdate;
};

//----------------------------------------------------------------------------

#endif // CVSLIB_CVSCONFIG_OLD_H_20061216
